!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * Highcharts
 *
 * (c) 2010-2024 Highsoft AS
 *
 * License: www.highcharts.com/license
 */function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/data-tools",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function s(t,s,r,o){t.hasOwnProperty(s)||(t[s]=o.apply(null,r),"function"==typeof CustomEvent&&e.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:s,module:t[s]}})))}s(t,"Data/Modifiers/DataModifier.js",[t["Core/Utilities.js"]],function(e){var t;let{addEvent:s,fireEvent:r,merge:o}=e;class n{benchmark(e,t){let s=[],r=this,n=()=>{r.modifyTable(e),r.emit({type:"afterBenchmarkIteration"})},{iterations:i}=o({iterations:1},t);r.on("afterBenchmarkIteration",()=>{if(s.length===i){r.emit({type:"afterBenchmark",results:s});return}n()});let l={startTime:0,endTime:0};return r.on("modify",()=>{l.startTime=window.performance.now()}),r.on("afterModify",()=>{l.endTime=window.performance.now(),s.push(l.endTime-l.startTime)}),n(),s}emit(e){r(this,e.type,e)}modify(e,t){let s=this;return new Promise((r,o)=>{e.modified===e&&(e.modified=e.clone(!1,t));try{r(s.modifyTable(e,t))}catch(r){s.emit({type:"error",detail:t,table:e}),o(r)}})}modifyCell(e,t,s,r,o){return this.modifyTable(e)}modifyColumns(e,t,s,r){return this.modifyTable(e)}modifyRows(e,t,s,r){return this.modifyTable(e)}on(e,t){return s(this,e,t)}}return(t=n||(n={})).types={},t.registerType=function(e,s){return!!e&&!t.types[e]&&!!(t.types[e]=s)},n}),s(t,"Data/DataTable.js",[t["Core/Utilities.js"]],function(e){let{addEvent:t,fireEvent:s,uniqueKey:r}=e;class o{static isNull(e){if(e===o.NULL)return!0;if(e instanceof Array){if(!e.length)return!1;for(let t=0,s=e.length;t<s;++t)if(null!==e[t])return!1}else{let t=Object.keys(e);if(!t.length)return!1;for(let s=0,r=t.length;s<r;++s)if(null!==e[t[s]])return!1}return!0}constructor(e={}){this.aliases=e.aliases?JSON.parse(JSON.stringify(e.aliases)):{},this.autoId=!e.id,this.columns={},this.id=e.id||r(),this.modified=this,this.rowCount=0,this.versionTag=r(),this.rowKeysId=e.rowKeysId;let t=e.columns||{},s=Object.keys(t),o=this.columns,n=0;for(let e=0,r=s.length,i,l;e<r;++e)i=t[l=s[e]].slice(),o[l]=i,n=Math.max(n,i.length);for(let e=0,t=s.length;e<t;++e)o[s[e]].length=n;this.rowCount=n;let i=e.aliases||{},l=Object.keys(i),a=this.aliases;for(let e=0,t=l.length,s;e<t;++e)a[s=l[e]]=i[s];this.setRowKeysColumn(n)}clone(e,t){let s={};this.emit({type:"cloneTable",detail:t}),e||(s.aliases=this.aliases,s.columns=this.columns),this.autoId||(s.id=this.id),this.rowKeysId&&(s.rowKeysId=this.rowKeysId);let r=new o(s);return e||(r.versionTag=this.versionTag),this.emit({type:"afterCloneTable",detail:t,tableClone:r}),r}deleteColumnAlias(e){let t=this.aliases[e],s=this.modifier;return t&&(delete this.aliases[e],s&&s.modifyColumns(this,{[t]:Array(this.rowCount)},0)),t}deleteColumns(e,t){let s=this.columns,r={},o={},n=this.modifier,i=this.rowCount;if((e=e||Object.keys(s)).length){this.emit({type:"deleteColumns",columnNames:e,detail:t});for(let t=0,n=e.length,l,a;t<n;++t)(l=s[a=e[t]])&&(r[a]=l,o[a]=Array(i)),delete s[a];let l=Object.keys(s).length;return this.rowKeysId&&1===l&&(delete s[this.rowKeysId],l=0),l||(this.rowCount=0),n&&n.modifyColumns(this,o,0,t),this.emit({type:"afterDeleteColumns",columns:r,columnNames:e,detail:t}),r}}deleteRows(e,t=1,s){let r=[],o=[],n=this.modifier;if(this.emit({type:"deleteRows",detail:s,rowCount:t,rowIndex:e||0}),void 0===e&&(e=0,t=this.rowCount),t>0&&e<this.rowCount){let s=this.columns,n=Object.keys(s);for(let i=0,l=n.length,a,u;i<l;++i){u=(a=s[n[i]]).splice(e,t),i||(this.rowCount=a.length);for(let e=0,t=u.length;e<t;++e)r[e]=r[e]||[],r[e][i]=u[e];o.push(Array(l))}}return n&&n.modifyRows(this,o,e||0,s),this.emit({type:"afterDeleteRows",detail:s,rowCount:t,rowIndex:e||0,rows:r}),r}emit(e){switch(e.type){case"afterDeleteColumns":case"afterDeleteRows":case"afterSetCell":case"afterSetColumns":case"afterSetRows":this.versionTag=r()}s(this,e.type,e)}getCell(e,t){e=this.aliases[e]||e;let s=this.columns[e];if(s)return s[t]}getCellAsBoolean(e,t){e=this.aliases[e]||e;let s=this.columns[e];return!!(s&&s[t])}getCellAsNumber(e,t,s){e=this.aliases[e]||e;let r=this.columns[e],o=r&&r[t];switch(typeof o){case"boolean":return o?1:0;case"number":return isNaN(o)&&!s?null:o}return isNaN(o=parseFloat(`${o??""}`))&&!s?null:o}getCellAsString(e,t){e=this.aliases[e]||e;let s=this.columns[e];return`${s&&s[t]}`}getColumn(e,t){return this.getColumns([e],t)[e]}getColumnAsNumbers(e,t){let s=this.columns[e=this.aliases[e]||e],r=[];if(s){let o=s.length;if(t)for(let t=0;t<o;++t)r.push(this.getCellAsNumber(e,t,!0));else{for(let e=0,t;e<o;++e){if("number"==typeof(t=s[e]))return s.slice();if(null!=t)break}for(let t=0;t<o;++t)r.push(this.getCellAsNumber(e,t))}}return r}getColumnNames(){let e=Object.keys(this.columns);return this.removeRowKeysColumn(e),e}getColumns(e,t){let s=this.aliases,r=this.columns,o={};e=e||Object.keys(r),this.removeRowKeysColumn(e);for(let n=0,i=e.length,l,a;n<i;++n)(l=r[s[a=e[n]]||a])&&(o[a]=t?l:l.slice());return o}getModifier(){return this.modifier}getRow(e,t){return this.getRows(e,1,t)[0]}getRowCount(){return this.rowCount}getRowIndexBy(e,t,s){e=this.aliases[e]||e;let r=this.columns[e];if(r){let e=r.indexOf(t,s);if(-1!==e)return e}}getRowObject(e,t){return this.getRowObjects(e,1,t)[0]}getRowObjects(e=0,t=this.rowCount-e,s){let r=this.aliases,o=this.columns,n=Array(t);s=s||Object.keys(o),this.removeRowKeysColumn(s);for(let i=e,l=0,a=Math.min(this.rowCount,e+t),u,h;i<a;++i,++l)for(let e of(h=n[l]={},s))u=o[r[e]||e],h[e]=u?u[i]:void 0;return n}getRows(e=0,t=this.rowCount-e,s){let r=this.aliases,o=this.columns,n=Array(t);s=s||Object.keys(o);for(let i=e,l=0,a=Math.min(this.rowCount,e+t),u,h;i<a;++i,++l)for(let e of(h=n[l]=[],s))u=o[r[e]||e],h.push(u?u[i]:void 0);return n}getVersionTag(){return this.versionTag}hasColumns(e){let t=this.aliases,s=this.columns;for(let r=0,o=e.length,n;r<o;++r)if(!s[n=e[r]]&&!t[n])return!1;return!0}hasRowWith(e,t){e=this.aliases[e]||e;let s=this.columns[e];return!!s&&-1!==s.indexOf(t)}on(e,s){return t(this,e,s)}renameColumn(e,t){let s=this.columns;if(s[e]){if(e!==t){let r=this.aliases;r[t]&&delete r[t],s[t]=s[e],delete s[e],this.rowKeysId&&this.moveRowKeysColumnToLast(s,this.rowKeysId)}return!0}return!1}setCell(e,t,s,r){let o=this.columns,n=this.modifier,i=o[e=this.aliases[e]||e];i&&i[t]===s||(this.emit({type:"setCell",cellValue:s,columnName:e,detail:r,rowIndex:t}),i||(i=o[e]=Array(this.rowCount)),t>=this.rowCount&&(this.rowCount=t+1),i[t]=s,n&&n.modifyCell(this,e,t,s),this.emit({type:"afterSetCell",cellValue:s,columnName:e,detail:r,rowIndex:t}))}setColumn(e,t=[],s=0,r){this.setColumns({[e]:t},s,r)}setColumns(e,t,s){let r=this.columns,o=this.modifier,n=void 0===t,i=Object.keys(e);this.emit({type:"setColumns",columns:e,columnNames:i,detail:s,rowIndex:t});for(let s=0,o=i.length,l,a;s<o;++s)if(l=e[a=i[s]],a=this.aliases[a]||a,n)r[a]=l.slice(),this.rowCount=l.length;else{let e=r[a]?r[a]:r[a]=Array(this.rowCount);for(let s=t||0,r=l.length;s<r;++s)e[s]=l[s];this.rowCount=Math.max(this.rowCount,e.length)}let l=Object.keys(r);for(let e=0,t=l.length;e<t;++e)r[l[e]].length=this.rowCount;o&&o.modifyColumns(this,e,t||0),this.rowKeysId&&this.moveRowKeysColumnToLast(r,this.rowKeysId),this.emit({type:"afterSetColumns",columns:e,columnNames:i,detail:s,rowIndex:t})}setRowKeysColumn(e){let t=this.rowKeysId;if(!t)return;this.columns[t]=[];let s=this.columns[t];for(let r=0;r<e;r++)s.push(t+"_"+r)}getRowKeysColumn(){let e=this.rowKeysId;if(e)return this.columns[e]}getRowIndexOriginal(e){let t=this.rowKeysId;return t?(""+this.columns[t][e]).split("_")[1]:String(e)}setModifier(e,t){let s=this;return s.emit({type:"setModifier",detail:t,modifier:e,modified:s.modified}),s.modified=s,s.modifier=e,(e?e.modify(s):Promise.resolve(s)).then(s=>(s.emit({type:"afterSetModifier",detail:t,modifier:e,modified:s.modified}),s)).catch(t=>{throw s.emit({type:"setModifierError",error:t,modifier:e,modified:s.modified}),t})}setRow(e,t,s){this.setRows([e],t,s)}setRows(e,t=this.rowCount,s){let r=this.aliases,n=this.columns,i=Object.keys(n),l=this.modifier,a=e.length;this.emit({type:"setRows",detail:s,rowCount:a,rowIndex:t,rows:e});for(let s=0,l=t,u;s<a;++s,++l)if((u=e[s])===o.NULL)for(let e=0,t=i.length;e<t;++e)n[i[e]][l]=null;else if(u instanceof Array)for(let e=0,t=i.length;e<t;++e)n[i[e]][l]=u[e];else{let e=Object.keys(u);for(let t=0,s=e.length,o;t<s;++t)n[o=r[o=e[t]]||o]||(n[o]=Array(l+1)),n[o][l]=u[o]}let u=t+a;if(u>this.rowCount){this.rowCount=u;for(let e=0,t=i.length;e<t;++e)n[i[e]].length=u}this.rowKeysId&&!i.includes(this.rowKeysId)&&this.setRowKeysColumn(a),l&&l.modifyRows(this,e,t),this.emit({type:"afterSetRows",detail:s,rowCount:a,rowIndex:t,rows:e})}moveRowKeysColumnToLast(e,t){let s=e[t];delete e[t],e[t]=s}removeRowKeysColumn(e){this.rowKeysId&&-1!==e.indexOf(this.rowKeysId)&&e.pop()}}return o.NULL={},o.version="1.0.0",o}),s(t,"Data/Connectors/DataConnector.js",[t["Data/Modifiers/DataModifier.js"],t["Data/DataTable.js"],t["Core/Utilities.js"]],function(e,t,s){var r;let{addEvent:o,fireEvent:n,merge:i,pick:l}=s;class a{constructor(e={}){this.table=new t(e.dataTable),this.metadata=e.metadata||{columns:{}}}get polling(){return!!this.polling}describeColumn(e,t){let s=this.metadata.columns;s[e]=i(s[e]||{},t)}describeColumns(e){let t;let s=Object.keys(e);for(;"string"==typeof(t=s.pop());)this.describeColumn(t,e[t])}emit(e){n(this,e.type,e)}getColumnOrder(e){let t=this.metadata.columns,s=Object.keys(t||{});if(s.length)return s.sort((e,s)=>l(t[e].index,0)-l(t[s].index,0))}getSortedColumns(e){return this.table.getColumns(this.getColumnOrder(e))}load(){return n(this,"afterLoad",{table:this.table}),Promise.resolve(this)}on(e,t){return o(this,e,t)}save(){return n(this,"saveError",{table:this.table}),Promise.reject(Error("Not implemented"))}setColumnOrder(e){for(let t=0,s=e.length;t<s;++t)this.describeColumn(e[t],{index:t})}setModifierOptions(t){let s=t&&e.types[t.type];return this.table.setModifier(s?new s(t):void 0).then(()=>this)}startPolling(e=1e3){let t=this;window.clearTimeout(t._polling),t._polling=window.setTimeout(()=>t.load().catch(e=>t.emit({type:"loadError",error:e,table:t.table})).then(()=>{t._polling&&t.startPolling(e)}),e)}stopPolling(){window.clearTimeout(this._polling),delete this._polling}whatIs(e){return this.metadata.columns[e]}}return(r=a||(a={})).types={},r.registerType=function(e,t){return!!e&&!r.types[e]&&!!(r.types[e]=t)},a}),s(t,"Data/Converters/DataConverter.js",[t["Data/DataTable.js"],t["Core/Utilities.js"]],function(e,t){let{addEvent:s,fireEvent:r,isNumber:o,merge:n}=t;class i{constructor(e){this.dateFormats={"YYYY/mm/dd":{regex:/^(\d{4})([\-\.\/])(\d{1,2})\2(\d{1,2})$/,parser:function(e){return e?Date.UTC(+e[1],e[3]-1,+e[4]):NaN}},"dd/mm/YYYY":{regex:/^(\d{1,2})([\-\.\/])(\d{1,2})\2(\d{4})$/,parser:function(e){return e?Date.UTC(+e[4],e[3]-1,+e[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^(\d{1,2})([\-\.\/])(\d{1,2})\2(\d{4})$/,parser:function(e){return e?Date.UTC(+e[4],e[1]-1,+e[3]):NaN}},"dd/mm/YY":{regex:/^(\d{1,2})([\-\.\/])(\d{1,2})\2(\d{2})$/,parser:function(e){let t=new Date;if(!e)return NaN;let s=+e[4];return s>t.getFullYear()-2e3?s+=1900:s+=2e3,Date.UTC(s,e[3]-1,+e[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^(\d{1,2})([\-\.\/])(\d{1,2})\2(\d{2})$/,parser:function(e){return e?Date.UTC(+e[4]+2e3,e[1]-1,+e[3]):NaN}}};let t=n(i.defaultOptions,e),s=t.decimalPoint;("."===s||","===s)&&(s="."===s?"\\.":",",this.decimalRegExp=RegExp("^(-?[0-9]+)"+s+"([0-9]+)$")),this.options=t}asBoolean(e){return"boolean"==typeof e?e:"string"==typeof e?""!==e&&"0"!==e&&"false"!==e:!!this.asNumber(e)}asDate(e){let t;if("string"==typeof e)t=this.parseDate(e);else if("number"==typeof e)t=e;else{if(e instanceof Date)return e;t=this.parseDate(this.asString(e))}return new Date(t)}asGuessedType(e){return({number:this.asNumber,Date:this.asDate,string:this.asString})[this.guessType(e)].call(this,e)}asNumber(e){if("number"==typeof e)return e;if("boolean"==typeof e)return e?1:0;if("string"==typeof e){let t=this.decimalRegExp;if(e.indexOf(" ")>-1&&(e=e.replace(/\s+/g,"")),t){if(!t.test(e))return NaN;e=e.replace(t,"$1.$2")}return parseFloat(e)}return e instanceof Date?e.getDate():e?e.getRowCount():NaN}asString(e){return""+e}deduceDateFormat(e,t,s){let r=[],o=[],n="YYYY/mm/dd",i,l=[],a=0,u=!1,h,m;for((!t||t>e.length)&&(t=e.length);a<t;a++)if(void 0!==e[a]&&e[a]&&e[a].length)for(m=0,i=e[a].trim().replace(/[\-\.\/]/g," ").split(" "),l=["","",""];m<i.length;m++)m<l.length&&(h=parseInt(i[m],10))&&(o[m]=!o[m]||o[m]<h?h:o[m],void 0!==r[m]?r[m]!==h&&(r[m]=!1):r[m]=h,h>31?h<100?l[m]="YY":l[m]="YYYY":h>12&&h<=31?(l[m]="dd",u=!0):l[m].length||(l[m]="mm"));if(u){for(m=0;m<r.length;m++)!1!==r[m]?o[m]>12&&"YY"!==l[m]&&"YYYY"!==l[m]&&(l[m]="YY"):o[m]>12&&"mm"===l[m]&&(l[m]="dd");3===l.length&&"dd"===l[1]&&"dd"===l[2]&&(l[2]="YY"),n=l.join("/")}return s&&(this.options.dateFormat=n),n}emit(e){r(this,e.type,e)}export(e,t){throw this.emit({type:"exportError",columns:[],headers:[]}),Error("Not implemented")}getTable(){throw Error("Not implemented")}guessType(e){let t="string";if("string"==typeof e){let s=this.trim(`${e}`),r=this.decimalRegExp,n=this.trim(s,!0);r&&(n=r.test(n)?n.replace(r,"$1.$2"):"");let i=parseFloat(n);+n===i?e=i:t=o(this.parseDate(e))?"Date":"string"}return"number"==typeof e&&(t=e>31536e6?"Date":"number"),t}on(e,t){return s(this,e,t)}parse(e){throw this.emit({type:"parseError",columns:[],headers:[]}),Error("Not implemented")}parseDate(e,t){let s=this.options,r=t||s.dateFormat,n=NaN,i,l,a;if(s.parseDate)n=s.parseDate(e);else{if(r)(l=this.dateFormats[r])||(l=this.dateFormats["YYYY/mm/dd"]),(a=e.match(l.regex))&&(n=l.parser(a));else for(i in this.dateFormats)if(l=this.dateFormats[i],a=e.match(l.regex)){r=i,n=l.parser(a);break}!a&&("object"==typeof(a=Date.parse(e))&&null!==a&&a.getTime?n=a.getTime()-6e4*a.getTimezoneOffset():o(a)&&(n=a-6e4*new Date(a).getTimezoneOffset(),-1===e.indexOf("2001")&&2001===new Date(n).getFullYear()&&(n=NaN)))}return n}trim(e,t){return"string"==typeof e&&(e=e.replace(/^\s+|\s+$/g,""),t&&/^[\d\s]+$/.test(e)&&(e=e.replace(/\s/g,""))),e}}return i.defaultOptions={dateFormat:"",alternativeFormat:"",startColumn:0,endColumn:Number.MAX_VALUE,startRow:0,endRow:Number.MAX_VALUE,firstRowAsNames:!0,switchRowsAndColumns:!1},(i||(i={})).getTableFromColumns=function(t=[],s=[]){let r=new e;for(let e=0,o=Math.max(s.length,t.length);e<o;++e)r.setColumn(s[e]||`${e}`,t[e]);return r},i}),s(t,"Data/DataCursor.js",[],function(){class e{constructor(e={}){this.emittingRegister=[],this.listenerMap={},this.stateMap=e}addListener(e,t,s){let r=this.listenerMap[e]=this.listenerMap[e]||{};return(r[t]=r[t]||[]).push(s),this}buildEmittingTag(e){return("position"===e.cursor.type?[e.table.id,e.cursor.column,e.cursor.row,e.cursor.state,e.cursor.type]:[e.table.id,e.cursor.columns,e.cursor.firstRow,e.cursor.lastRow,e.cursor.state,e.cursor.type]).join("\0")}emitCursor(t,s,r,o){let n=t.id,i=s.state,l=this.listenerMap[n]&&this.listenerMap[n][i];if(l){let i=this.stateMap[n]=this.stateMap[n]??{},a=i[s.state]||[];o&&(a.length||(i[s.state]=a),-1===e.getIndex(s,a)&&a.push(s));let u={cursor:s,cursors:a,table:t};r&&(u.event=r);let h=this.emittingRegister,m=this.buildEmittingTag(u);if(h.indexOf(m)>=0)return this;try{this.emittingRegister.push(m);for(let e=0,t=l.length;e<t;++e)l[e].call(this,u)}finally{let e=this.emittingRegister.indexOf(m);e>=0&&this.emittingRegister.splice(e,1)}}return this}remitCursor(t,s){let r=this.stateMap[t]&&this.stateMap[t][s.state];if(r){let t=e.getIndex(s,r);t>=0&&r.splice(t,1)}return this}removeListener(e,t,s){let r=this.listenerMap[e]&&this.listenerMap[e][t];if(r){let e=r.indexOf(s);e>=0&&r.splice(e,1)}return this}}return e.version="1.0.0",function(e){function t(e,t){if("range"===e.type)return e;let s={type:"range",firstRow:e.row??(t&&t.firstRow)??0,lastRow:e.row??(t&&t.lastRow)??Number.MAX_VALUE,state:e.state};return void 0!==e.column&&(s.columns=[e.column]),s}e.getIndex=function(e,t){if("position"===e.type){for(let s,r=0,o=t.length;r<o;++r)if("position"===(s=t[r]).type&&s.state===e.state&&s.column===e.column&&s.row===e.row)return r}else{let s=JSON.stringify(e.columns);for(let r,o=0,n=t.length;o<n;++o)if("range"===(r=t[o]).type&&r.state===e.state&&r.firstRow===e.firstRow&&r.lastRow===e.lastRow&&JSON.stringify(r.columns)===s)return o}return -1},e.isEqual=function(e,t){return"position"===e.type&&"position"===t.type?e.column===t.column&&e.row===t.row&&e.state===t.state:"range"===e.type&&"range"===t.type&&e.firstRow===t.firstRow&&e.lastRow===t.lastRow&&JSON.stringify(e.columns)===JSON.stringify(t.columns)},e.isInRange=function(e,s){"position"===s.type&&(s=t(s)),"position"===e.type&&(e=t(e,s));let r=e.columns,o=s.columns;return e.firstRow>=s.firstRow&&e.lastRow<=s.lastRow&&(!r||!o||r.every(e=>o.indexOf(e)>=0))},e.toPositions=function(e){if("position"===e.type)return[e];let t=e.columns||[],s=[],r=e.state;for(let o=e.firstRow,n=e.lastRow;o<n;++o){if(!t.length){s.push({type:"position",row:o,state:r});continue}for(let e=0,n=t.length;e<n;++e)s.push({type:"position",column:t[e],row:o,state:r})}return s},e.toRange=t}(e||(e={})),e}),s(t,"Data/DataPoolDefaults.js",[],function(){return{connectors:[]}}),s(t,"Data/DataPool.js",[t["Data/Connectors/DataConnector.js"],t["Data/DataPoolDefaults.js"],t["Core/Utilities.js"]],function(e,t,s){class r{constructor(e=t){e.connectors=e.connectors||[],this.connectors={},this.options=e,this.waiting={}}emit(e){s.fireEvent(this,e.type,e)}getConnector(e){let t=this.connectors[e];if(t)return Promise.resolve(t);let s=this.waiting[e];if(!s){s=this.waiting[e]=[];let t=this.getConnectorOptions(e);if(!t)throw Error(`Connector '${e}' not found.`);this.loadConnector(t).then(t=>{delete this.waiting[e];for(let e=0,r=s.length;e<r;++e)s[e][0](t)}).catch(t=>{delete this.waiting[e];for(let e=0,r=s.length;e<r;++e)s[e][1](t)})}return new Promise((e,t)=>{s.push([e,t])})}getConnectorIds(){let e=this.options.connectors,t=[];for(let s=0,r=e.length;s<r;++s)t.push(e[s].id);return t}getConnectorOptions(e){let t=this.options.connectors;for(let s=0,r=t.length;s<r;++s)if(t[s].id===e)return t[s]}getConnectorTable(e){return this.getConnector(e).then(e=>e.table)}isNewConnector(e){return!this.connectors[e]}loadConnector(t){return new Promise((s,r)=>{this.emit({type:"load",options:t});let o=e.types[t.type];if(!o)throw Error(`Connector type not found. (${t.type})`);new o(t.options).load().then(e=>{this.connectors[t.id]=e,this.emit({type:"afterLoad",options:t}),s(e)}).catch(r)})}on(e,t){return s.addEvent(this,e,t)}setConnectorOptions(e){let t=this.options.connectors,s=this.connectors;this.emit({type:"setConnectorOptions",options:e});for(let s=0,r=t.length;s<r;++s)if(t[s].id===e.id){t.splice(s,1);break}s[e.id]&&(s[e.id].stopPolling(),delete s[e.id]),t.push(e),this.emit({type:"afterSetConnectorOptions",options:e})}}return r.version="1.0.0",r}),s(t,"Data/Formula/FormulaParser.js",[],function(){let e=/^(?:FALSE|TRUE)/,t=/^[+\-]?\d+(?:\.\d+)?(?:e[+\-]\d+)?/,s=/^[+\-]?\d+(?:,\d+)?(?:e[+\-]\d+)?/,r=/^([A-Z][A-Z\d\.]*)\(/,o=/^(?:[+\-*\/^<=>]|<=|=>)/,n=/^(\$?[A-Z]+)(\$?\d+)\:(\$?[A-Z]+)(\$?\d+)/,i=/^R(\d*|\[\d+\])C(\d*|\[\d+\])\:R(\d*|\[\d+\])C(\d*|\[\d+\])/,l=/^(\$?[A-Z]+)(\$?\d+)(?![\:C])/,a=/^R(\d*|\[\d+\])C(\d*|\[\d+\])(?!\:)/;function u(e){let t=0;for(let s=0,r=e.length,o,n=1;s<r;++s){if("("===(o=e[s])){t||(n=s+1),++t;continue}if(")"===o&&!--t)return e.substring(n,s)}if(t>0){let e=Error("Incomplete parantheses.");throw e.name="FormulaParseError",e}return""}function h(e){let t=-1;for(let s=0,r=e.length,o,n=!1;s<r;++s){if("\\"===(o=e[s])){n=!n;continue}if(n){n=!1;continue}if('"'===o){if(!(t<0))return e.substring(t+1,s);t=s}}let s=Error("Incomplete string.");throw s.name="FormulaParseError",s}function m(e,t){let s;if(s=e.match(i)){let e=""===s[2]||"["===s[2][0],t=""===s[1]||"["===s[1][0],r=""===s[4]||"["===s[4][0],o=""===s[3]||"["===s[3][0],n={type:"range",beginColumn:e?parseInt(s[2].substring(1,-1)||"0",10):parseInt(s[2],10)-1,beginRow:t?parseInt(s[1].substring(1,-1)||"0",10):parseInt(s[1],10)-1,endColumn:r?parseInt(s[4].substring(1,-1)||"0",10):parseInt(s[4],10)-1,endRow:o?parseInt(s[3].substring(1,-1)||"0",10):parseInt(s[3],10)-1};return e&&(n.beginColumnRelative=!0),t&&(n.beginRowRelative=!0),r&&(n.endColumnRelative=!0),o&&(n.endRowRelative=!0),n}if(s=e.match(n)){let e="$"!==s[1][0],t="$"!==s[2][0],r="$"!==s[3][0],o="$"!==s[4][0],n={type:"range",beginColumn:f(e?s[1]:s[1].substring(1))-1,beginRow:parseInt(t?s[2]:s[2].substring(1),10)-1,endColumn:f(r?s[3]:s[3].substring(1))-1,endRow:parseInt(o?s[4]:s[4].substring(1),10)-1};return e&&(n.beginColumnRelative=!0),t&&(n.beginRowRelative=!0),r&&(n.endColumnRelative=!0),o&&(n.endRowRelative=!0),n}let r=c(e,t);return 1===r.length&&"string"!=typeof r[0]?r[0]:r}function c(n,i){let d=i?s:t,p=[],g,y=("="===n[0]?n.substring(1):n).trim();for(;y;){if(g=y.match(a)){let e=""===g[2]||"["===g[2][0],t=""===g[1]||"["===g[1][0],s={type:"reference",column:e?parseInt(g[2].substring(1,-1)||"0",10):parseInt(g[2],10)-1,row:t?parseInt(g[1].substring(1,-1)||"0",10):parseInt(g[1],10)-1};e&&(s.columnRelative=!0),t&&(s.rowRelative=!0),p.push(s),y=y.substring(g[0].length).trim();continue}if(g=y.match(l)){let e="$"!==g[1][0],t="$"!==g[2][0],s={type:"reference",column:f(e?g[1]:g[1].substring(1))-1,row:parseInt(t?g[2]:g[2].substring(1),10)-1};e&&(s.columnRelative=!0),t&&(s.rowRelative=!0),p.push(s),y=y.substring(g[0].length).trim();continue}if(g=y.match(o)){p.push(g[0]),y=y.substring(g[0].length).trim();continue}if(g=y.match(e)){p.push("TRUE"===g[0]),y=y.substring(g[0].length).trim();continue}if(g=y.match(d)){p.push(parseFloat(g[0])),y=y.substring(g[0].length).trim();continue}if('"'===y[0]){let e=h(y);p.push(e.substring(1,-1)),y=y.substring(e.length+2).trim();continue}if(g=y.match(r)){let e=u(y=y.substring(g[1].length).trim());p.push({type:"function",name:g[1],args:function(e,t){let s=[],r=t?";":",",o=0,n="";for(let i=0,l=e.length,a;i<l;++i)if((a=e[i])===r&&!o&&n)s.push(m(n,t)),n="";else if('"'!==a||o||n)" "!==a&&(n+=a,"("===a?++o:")"===a&&--o);else{let t=h(e.substring(i));s.push(t),i+=t.length+1}return!o&&n&&s.push(m(n,t)),s}(e,i)}),y=y.substring(e.length+2).trim();continue}if("("===y[0]){let e=u(y);if(e){p.push(c(e,i)),y=y.substring(e.length+2).trim();continue}}let t=n.length-y.length,s=Error("Unexpected character `"+n.substring(t,t+1)+"` at position "+(t+1)+". (`..."+n.substring(t-5,t+6)+"...`)");throw s.name="FormulaParseError",s}return p}function f(e){let t=0;for(let s=0,r=e.length,o,n=e.length-1;s<r;++s)(o=e.charCodeAt(s))>=65&&o<=90&&(t+=(o-64)*Math.pow(26,n)),--n;return t}return{parseFormula:c}}),s(t,"Data/Formula/FormulaTypes.js",[],function(){let e=["+","-","*","/","^","=","<","<=",">",">="];return{isFormula:function(e){return e instanceof Array},isFunction:function(e){return"object"==typeof e&&!(e instanceof Array)&&"function"===e.type},isOperator:function(t){return"string"==typeof t&&e.indexOf(t)>=0},isRange:function(e){return"object"==typeof e&&!(e instanceof Array)&&"range"===e.type},isReference:function(e){return"object"==typeof e&&!(e instanceof Array)&&"reference"===e.type},isValue:function(e){return"boolean"==typeof e||"number"==typeof e||"string"==typeof e}}}),s(t,"Data/Formula/FormulaProcessor.js",[t["Data/Formula/FormulaTypes.js"]],function(e){let{isFormula:t,isFunction:s,isOperator:r,isRange:o,isReference:n,isValue:i}=e,l=/ */,a=Number.MAX_VALUE/1.000000000001,u=Number.MAX_VALUE/1.000000000002,h=Number.MAX_VALUE,m={"^":3,"*":2,"/":2,"+":1,"-":1,"=":0,"<":0,"<=":0,">":0,">=":0},c={},f=/^[A-Z][A-Z\.]*$/;function d(e){switch(typeof e){case"boolean":return e?h:a;case"string":return u;case"number":return e;default:return NaN}}function p(e){return"string"==typeof e?e.toLowerCase().replace(l,"\0"):e}function g(e){switch(typeof e){case"boolean":return e?1:0;case"string":return parseFloat(e.replace(",","."));case"number":return e;default:return NaN}}function y(e,t,s){let r;switch(e){case"=":return p(t)===p(s);case"<":if(typeof t==typeof s)return p(t)<p(s);return d(t)<d(s);case"<=":if(typeof t==typeof s)return p(t)<=p(s);return d(t)<=d(s);case">":if(typeof t==typeof s)return p(t)>p(s);return d(t)>d(s);case">=":if(typeof t==typeof s)return p(t)>=p(s);return d(t)>=d(s)}switch(t=g(t),s=g(s),e){case"+":r=t+s;break;case"-":r=t-s;break;case"*":r=t*s;break;case"/":r=t/s;break;case"^":r=Math.pow(t,s);break;default:return NaN}return r%1?Math.round(1e9*r)/1e9:r}function C(e,r){return i(e)?e:o(e)?r&&b(e,r)||[]:s(e)?N(e,r):D(t(e)?e:[e],r)}function b(e,t){let s=t.getColumnNames().slice(e.beginColumn,e.endColumn+1),r=[];for(let o=0,n=s.length,l;o<n;++o){let n=t.getColumn(s[o],!0)||[];for(let a=e.beginRow,u=e.endRow+1;a<u;++a)"string"==typeof(l=n[a])&&"="===l[0]&&t!==t.modified&&(l=t.modified.getCell(s[o],a)),r.push(i(l)?l:NaN)}return r}function w(e,t){let s=t.getColumnNames()[e.column];if(s){let r=t.getCell(s,e.row);if("string"==typeof r&&"="===r[0]&&t!==t.modified){let r=t.modified.getCell(s,e.row);return i(r)?r:NaN}return i(r)?r:NaN}return NaN}function D(e,o){let l;for(let a=0,u=e.length,h,c,f,d;a<u;++a){if(r(h=e[a])){c=h;continue}if(i(h)?d=h:t(h)?d=D(e,o):s(h)?d=i(f=N(h,o))?f:NaN:n(h)&&(d=o&&w(h,o)),void 0!==d){if(void 0===l)l=c?y(c,0,d):d;else{if(!c)return NaN;let t=e[a+1];r(t)&&m[t]>m[c]&&(d=y(t,d,D(e.slice(a+2))),a=u),l=y(c,l,d)}c=void 0,d=void 0}}return i(l)?l:NaN}function N(e,t,s){let r=c[e.name];if(r)try{return r(e.args,t)}catch{return NaN}let o=Error(`Function "${e.name}" not found.`);throw o.name="FormulaProcessError",o}return{asNumber:g,getArgumentValue:C,getArgumentsValues:function(e,t){let s=[];for(let r=0,o=e.length;r<o;++r)s.push(C(e[r],t));return s},getRangeValues:b,getReferenceValue:w,processFormula:D,processorFunctions:c,registerProcessorFunction:function(e,t){return f.test(e)&&!c[e]&&!!(c[e]=t)},translateReferences:function e(t,r=0,i=0){for(let l=0,a=t.length,u;l<a;++l)(u=t[l])instanceof Array?e(u,r,i):s(u)?e(u.args,r,i):o(u)?(u.beginColumnRelative&&(u.beginColumn+=r),u.beginRowRelative&&(u.beginRow+=i),u.endColumnRelative&&(u.endColumn+=r),u.endRowRelative&&(u.endRow+=i)):n(u)&&(u.columnRelative&&(u.column+=r),u.rowRelative&&(u.row+=i));return t}}}),s(t,"Data/Formula/Functions/ABS.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){let r=t(e[0],s);switch(typeof r){case"number":return Math.abs(r);case"object":{let e=[];for(let t=0,s=r.length,o;t<s;++t){if("number"!=typeof(o=r[t]))return NaN;e.push(Math.abs(o))}return e}default:return NaN}}return e.registerProcessorFunction("ABS",s),s}),s(t,"Data/Formula/Functions/AND.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,r){for(let o=0,n=e.length,i;o<n;++o)if(!(i=t(e[o],r))||"object"==typeof i&&!s(i,r))return!1;return!0}return e.registerProcessorFunction("AND",s),s}),s(t,"Data/Formula/Functions/AVERAGE.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentsValues:t}=e;function s(e,s){let r=t(e,s),o=0,n=0;for(let e=0,t=r.length,s;e<t;++e)switch(typeof(s=r[e])){case"number":isNaN(s)||(++o,n+=s);break;case"object":for(let e=0,t=s.length,r;e<t;++e)"number"!=typeof(r=s[e])||isNaN(r)||(++o,n+=r)}return o?n/o:0}return e.registerProcessorFunction("AVERAGE",s),s}),s(t,"Data/Formula/Functions/AVERAGEA.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){let r=0,o=0;for(let n=0,i=e.length,l;n<i;++n)switch(typeof(l=t(e[n],s))){case"boolean":++r,o+=l?1:0;continue;case"number":isNaN(l)||(++r,o+=l);continue;case"string":++r;continue;default:for(let e=0,t=l.length,s;e<t;++e)switch(typeof(s=l[e])){case"boolean":++r,o+=s?1:0;continue;case"number":isNaN(s)||(++r,o+=s);continue;case"string":++r;continue}continue}return r?o/r:0}return e.registerProcessorFunction("AVERAGEA",s),s}),s(t,"Data/Formula/Functions/COUNT.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){function t(s,r){let o=e.getArgumentsValues(s,r),n=0;for(let e=0,s=o.length,i;e<s;++e)switch(typeof(i=o[e])){case"number":!isNaN(i)&&++n;break;case"object":n+=t(i,r)}return n}return e.registerProcessorFunction("COUNT",t),t}),s(t,"Data/Formula/Functions/COUNTA.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){function t(s,r){let o=e.getArgumentsValues(s,r),n=0;for(let e=0,s=o.length,i;e<s;++e){switch(typeof(i=o[e])){case"number":if(isNaN(i))continue;break;case"object":n+=t(i,r);continue;case"string":if(!i)continue}++n}return n}return e.registerProcessorFunction("COUNTA",t),t}),s(t,"Data/Formula/Functions/IF.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){return t(e[0],s)?t(e[1],s):t(e[2],s)}return e.registerProcessorFunction("IF",s),s}),s(t,"Data/Formula/Functions/ISNA.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){let r=t(e[0],s);return"number"!=typeof r||isNaN(r)}return e.registerProcessorFunction("ISNA",s),s}),s(t,"Data/Formula/Functions/MAX.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentsValues:t}=e;function s(e,r){let o=t(e,r),n=Number.NEGATIVE_INFINITY;for(let e=0,t=o.length,r;e<t;++e)switch(typeof(r=o[e])){case"number":r>n&&(n=r);break;case"object":(r=s(r))>n&&(n=r)}return isFinite(n)?n:0}return e.registerProcessorFunction("MAX",s),s}),s(t,"Data/Formula/Functions/MEDIAN.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){function t(t,s){let r=[],o=e.getArgumentsValues(t,s);for(let e=0,t=o.length,s;e<t;++e)switch(typeof(s=o[e])){case"number":isNaN(s)||r.push(s);break;case"object":for(let e=0,t=s.length,o;e<t;++e)"number"!=typeof(o=s[e])||isNaN(o)||r.push(o)}let n=r.length;if(!n)return NaN;let i=Math.floor(n/2);return n%2?r[i]:(r[i-1]+r[i])/2}return e.registerProcessorFunction("MEDIAN",t),t}),s(t,"Data/Formula/Functions/MIN.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentsValues:t}=e;function s(e,r){let o=t(e,r),n=Number.POSITIVE_INFINITY;for(let e=0,t=o.length,r;e<t;++e)switch(typeof(r=o[e])){case"number":r<n&&(n=r);break;case"object":(r=s(r))<n&&(n=r)}return isFinite(n)?n:0}return e.registerProcessorFunction("MIN",s),s}),s(t,"Data/Formula/Functions/MOD.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){let r=t(e[0],s),o=t(e[1],s);return("object"==typeof r&&(r=r[0]),"object"==typeof o&&(o=o[0]),"number"!=typeof r||"number"!=typeof o||0===o)?NaN:r%o}return e.registerProcessorFunction("MOD",s),s}),s(t,"Data/Formula/Functions/MODE.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){function t(t,s){let r={},o=e.getArgumentsValues(t,s);for(let e=0,t=o.length,s;e<t;++e)switch(typeof(s=o[e])){case"number":isNaN(s)||(r[s]=(r[s]||0)+1);break;case"object":for(let e=0,t=s.length,o;e<t;++e)"number"!=typeof(o=s[e])||isNaN(o)||(r[o]=(r[o]||0)+1)}return r}function s(e,s){let r=t(e,s),o=Object.keys(r);if(!o.length)return NaN;let n=[parseFloat(o[0])],i=r[o[0]];for(let e=1,t=o.length,s,l;e<t;++e)i<(l=r[s=o[e]])?(n=[parseFloat(s)],i=l):i===l&&n.push(parseFloat(s));return i>1?n:NaN}function r(e,s){let r=t(e,s),o=Object.keys(r);if(!o.length)return NaN;let n=parseFloat(o[0]),i=r[o[0]];for(let e=1,t=o.length,s,l,a;e<t;++e)i<(a=r[s=o[e]])?(n=parseFloat(s),i=a):i===a&&n>(l=parseFloat(s))&&(n=l,i=a);return i>1?n:NaN}return e.registerProcessorFunction("MODE",r),e.registerProcessorFunction("MODE.MULT",s),e.registerProcessorFunction("MODE.SNGL",r),{MULT:s,SNGL:r}}),s(t,"Data/Formula/Functions/NOT.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){let r=t(e[0],s);switch("object"==typeof r&&(r=r[0]),typeof r){case"boolean":case"number":return!r}return NaN}return e.registerProcessorFunction("NOT",s),s}),s(t,"Data/Formula/Functions/OR.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,r){for(let o=0,n=e.length,i;o<n;++o)if("object"==typeof(i=t(e[o],r))){if(s(i,r))return!0}else if(i)return!0;return!1}return e.registerProcessorFunction("OR",s),s}),s(t,"Data/Formula/Functions/PRODUCT.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentsValues:t}=e;function s(e,r){let o=t(e,r),n=1,i=!1;for(let e=0,t=o.length,l;e<t;++e)switch(typeof(l=o[e])){case"number":isNaN(l)||(i=!0,n*=l);break;case"object":i=!0,n*=s(l,r)}return i?n:0}return e.registerProcessorFunction("PRODUCT",s),s}),s(t,"Data/Formula/Functions/SUM.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){function t(s,r){let o=e.getArgumentsValues(s,r),n=0;for(let e=0,s=o.length,i;e<s;++e)switch(typeof(i=o[e])){case"number":isNaN(i)||(n+=i);break;case"object":n+=t(i,r)}return n}return e.registerProcessorFunction("SUM",t),t}),s(t,"Data/Formula/Functions/XOR.js",[t["Data/Formula/FormulaProcessor.js"]],function(e){let{getArgumentValue:t}=e;function s(e,s){for(let r=0,o=e.length,n,i;r<o;++r)switch(typeof(i=t(e[r],s))){case"boolean":case"number":if(void 0===n)n=!!i;else if(!!i!==n)return!0;break;case"object":for(let e=0,t=i.length,s;e<t;++e)switch(typeof(s=i[e])){case"boolean":case"number":if(void 0===n)n=!!s;else if(!!s!==n)return!0}}return!1}return e.registerProcessorFunction("XOR",s),s}),s(t,"Data/Formula/Formula.js",[t["Data/Formula/FormulaParser.js"],t["Data/Formula/FormulaProcessor.js"],t["Data/Formula/FormulaTypes.js"]],function(e,t,s){return{...e,...t,...s}}),s(t,"Data/Converters/CSVConverter.js",[t["Data/Converters/DataConverter.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s}=t;class r extends e{constructor(e){let t=s(r.defaultOptions,e);super(t),this.columns=[],this.headers=[],this.dataTypes=[],this.options=t}export(e,t=this.options){let{useLocalDecimalPoint:s,lineDelimiter:r}=t,o=!1!==this.options.firstRowAsNames,{decimalPoint:n,itemDelimiter:i}=t;n||(n=","!==i&&s?1.1.toLocaleString()[1]:"."),i||(i=","===n?";":",");let l=e.getSortedColumns(t.usePresentationOrder),a=Object.keys(l),u=[],h=a.length,m=[];o&&u.push(a.map(e=>`"${e}"`).join(i));for(let t=0;t<h;t++){let s;let r=a[t],o=l[r],c=o.length,f=e.whatIs(r);f&&(s=f.dataType);for(let e=0;e<c;e++){let r=o[e];if(m[e]||(m[e]=[]),"string"===s?r='"'+r+'"':"number"==typeof r?r=String(r).replace(".",n):"string"==typeof r&&(r=`"${r}"`),m[e][t]=r,t===h-1){let s=t;for(;m[e].length>2&&void 0===m[e][s];)m[e].pop(),s--;u.push(m[e].join(i))}}}return u.join(r)}parse(e,t){let r=this.dataTypes,o=s(this.options,e),{beforeParse:n,lineDelimiter:i,firstRowAsNames:l,itemDelimiter:a}=o,u,h=0,{csv:m,startRow:c,endRow:f}=o,d;if(this.columns=[],this.emit({type:"parse",columns:this.columns,detail:t,headers:this.headers}),m&&n&&(m=n(m)),m){if(u=m.replace(/\r\n|\r/g,"\n").split(i||"\n"),(!c||c<0)&&(c=0),(!f||f>=u.length)&&(f=u.length-1),a||(this.guessedItemDelimiter=this.guessDelimiter(u)),l){let e=u[0].split(a||this.guessedItemDelimiter||",");for(let t=0;t<e.length;t++)e[t]=e[t].trim().replace(/^["']|["']$/g,"");this.headers=e,c++}let e=0;for(h=c;h<=f;h++)"#"===u[h][0]?e++:this.parseCSVRow(u[h],h-c-e);r.length&&r[0].length&&"date"===r[0][1]&&!this.options.dateFormat&&this.deduceDateFormat(this.columns[0],null,!0);for(let e=0,t=this.columns.length;e<t;++e){d=this.columns[e];for(let t=0,s=d.length;t<s;++t)if(d[t]&&"string"==typeof d[t]){let s=this.asGuessedType(d[t]);s instanceof Date&&(s=s.getTime()),this.columns[e][t]=s}}}this.emit({type:"afterParse",columns:this.columns,detail:t,headers:this.headers})}parseCSVRow(e,t){let s=this,r=s.columns||[],o=s.dataTypes,{startColumn:n,endColumn:i}=s.options,l=s.options.itemDelimiter||s.guessedItemDelimiter,{decimalPoint:a}=s.options;a&&a!==l||(a=s.guessedDecimalPoint||".");let u=0,h="",m="",c=0,f=0,d=t=>{h=e[t]},p=e=>{o.length<f+1&&o.push([e]),o[f][o[f].length-1]!==e&&o[f].push(e)},g=()=>{if(n>c||c>i){++c,m="";return}if("string"==typeof m?!isNaN(parseFloat(m))&&isFinite(m)?(m=parseFloat(m),p("number")):isNaN(Date.parse(m))?p("string"):(m=m.replace(/\//g,"-"),p("date")):p("number"),r.length<f+1&&r.push([]),"number"!=typeof m&&"number"!==s.guessType(m)&&a){let e=m;m=m.replace(a,"."),"number"!==s.guessType(m)&&(m=e)}r[f][t]=m,m="",++f,++c};if(e.trim().length&&"#"!==e.trim()[0]){for(;u<e.length;u++){if(d(u),"#"===h&&!/^#[A-F\d]{3,3}|[A-F\d]{6,6}/i.test(e.substring(u))){g();return}if('"'===h)for(d(++u);u<e.length&&'"'!==h;)m+=h,d(++u);else h===l?g():m+=h}g()}}guessDelimiter(e){let t=0,s=0,r,o={",":0,";":0,"	":0},n=e.length;for(let r=0;r<n;r++){let n=!1,i,l,a,u="";if(r>13)break;let h=e[r];for(let e=0;e<h.length&&(i=h[e],l=h[e+1],a=h[e-1],"#"!==i);e++){if('"'===i){if(n){if('"'!==a&&'"'!==l){for(;" "===l&&e<h.length;)l=h[++e];void 0!==o[l]&&o[l]++,n=!1}}else n=!0}else void 0!==o[i]?(isNaN(Date.parse(u=u.trim()))?(isNaN(Number(u))||!isFinite(Number(u)))&&o[i]++:o[i]++,u=""):u+=i;","===i&&s++,"."===i&&t++}}return o[";"]>o[","]?r=";":(o[","],o[";"],r=","),t>s?this.guessedDecimalPoint=".":this.guessedDecimalPoint=",",r}getTable(){return e.getTableFromColumns(this.columns,this.headers)}}return r.defaultOptions={...e.defaultOptions,lineDelimiter:"\n"},r}),s(t,"Data/Connectors/CSVConnector.js",[t["Data/Converters/CSVConverter.js"],t["Data/Connectors/DataConnector.js"],t["Core/Utilities.js"]],function(e,t,s){let{merge:r}=s;class o extends t{constructor(t){let s=r(o.defaultOptions,t);super(s),this.converter=new e(s),this.options=s,s.enablePolling&&this.startPolling(1e3*Math.max(s.dataRefreshRate||0,1))}load(e){let t=this,s=t.converter,r=t.table,{csv:o,csvURL:n,dataModifier:i}=t.options;return t.emit({type:"load",csv:o,detail:e,table:r}),Promise.resolve(n?fetch(n).then(e=>e.text()):o||"").then(e=>(e&&(r.deleteColumns(),s.parse({csv:e}),r.setColumns(s.getTable().getColumns())),t.setModifierOptions(i).then(()=>e))).then(s=>(t.emit({type:"afterLoad",csv:s,detail:e,table:r}),t)).catch(s=>{throw t.emit({type:"loadError",detail:e,error:s,table:r}),s})}}return o.defaultOptions={csv:"",csvURL:"",enablePolling:!1,dataRefreshRate:1,firstRowAsNames:!0},t.registerType("CSV",o),o}),s(t,"Data/Converters/JSONConverter.js",[t["Data/Converters/DataConverter.js"],t["Data/DataTable.js"],t["Core/Utilities.js"]],function(e,t,s){let{error:r,isArray:o,merge:n,objectEach:i}=s;class l extends e{constructor(e){let s=n(l.defaultOptions,e);super(s),this.columns=[],this.headers=[],this.options=s,this.table=new t}parse(e,t){let{beforeParse:s,orientation:l,firstRowAsNames:a,columnNames:u}=e=n(this.options,e),h=e.data;if(h){if(this.columns=[],this.emit({type:"parse",columns:this.columns,detail:t,headers:this.headers}),s&&(h=s(h)),h=h.slice(),"columns"===l)for(let e=0,t=h.length;e<t;e++){let t=h[e];if(!(t instanceof Array))return;this.headers instanceof Array?(a?this.headers.push(`${t.shift()}`):u&&u instanceof Array&&this.headers.push(u[e]),this.table.setColumn(this.headers[e]||e.toString(),t)):r("JSONConverter: Invalid `columnNames` option.",!1)}else if("rows"===l){a?this.headers=h.shift():u&&(this.headers=u);for(let e=0,t=h.length;e<t;e++){let t=h[e];if(o(t))for(let e=0,s=t.length;e<s;e++)this.columns.length<e+1&&this.columns.push([]),this.columns[e].push(t[e]),this.headers instanceof Array?this.table.setColumn(this.headers[e]||e.toString(),this.columns[e]):r("JSONConverter: Invalid `columnNames` option.",!1);else{let s=this.headers;if(s&&!(s instanceof Array)){let e={};i(s,(s,r)=>{e[r]=s.reduce((e,t)=>e[t],t)}),t=e}this.table.setRows([t],e)}}}this.emit({type:"afterParse",columns:this.columns,detail:t,headers:this.headers})}}getTable(){return this.table}}return l.defaultOptions={...e.defaultOptions,data:[],orientation:"rows"},l}),s(t,"Data/Connectors/JSONConnector.js",[t["Data/Connectors/DataConnector.js"],t["Core/Utilities.js"],t["Data/Converters/JSONConverter.js"]],function(e,t,s){let{merge:r}=t;class o extends e{constructor(e){let t=r(o.defaultOptions,e);super(t),this.converter=new s(t),this.options=t,t.enablePolling&&this.startPolling(1e3*Math.max(t.dataRefreshRate||0,1))}load(e){let t=this,s=t.converter,r=t.table,{data:o,dataUrl:n,dataModifier:i}=t.options;return t.emit({type:"load",data:o,detail:e,table:r}),Promise.resolve(n?fetch(n).then(e=>e.json()):o||[]).then(e=>(e&&(r.deleteColumns(),s.parse({data:e}),r.setColumns(s.getTable().getColumns()),r.setRowKeysColumn(e.length)),t.setModifierOptions(i).then(()=>e))).then(s=>(t.emit({type:"afterLoad",data:s,detail:e,table:r}),t)).catch(s=>{throw t.emit({type:"loadError",detail:e,error:s,table:r}),s})}}return o.defaultOptions={data:[],enablePolling:!1,dataRefreshRate:0,firstRowAsNames:!0,orientation:"rows"},e.registerType("JSON",o),o}),s(t,"Data/Converters/GoogleSheetsConverter.js",[t["Data/Converters/DataConverter.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s,uniqueKey:r}=t;class o extends e{constructor(e){let t=s(o.defaultOptions,e);super(t),this.columns=[],this.header=[],this.options=t}parse(e,t){let o;let n=s(this.options,e),i=(n.json?.values||[]).map(e=>e.slice());if(0===i.length)return!1;this.header=[],this.columns=[],this.emit({type:"parse",columns:this.columns,detail:t,headers:this.header});let{beforeParse:l,json:a}=n;l&&a&&(i=l(a.values)),this.columns=i;for(let e=0,t=i.length;e<t;e++){o=i[e],this.header[e]=n.firstRowAsNames?`${o.shift()}`:r();for(let t=0,s=o.length;t<s;++t)if(o[t]&&"string"==typeof o[t]){let s=this.asGuessedType(o[t]);s instanceof Date&&(s=s.getTime()),this.columns[e][t]=s}}this.emit({type:"afterParse",columns:this.columns,detail:t,headers:this.header})}getTable(){return e.getTableFromColumns(this.columns,this.header)}}return o.defaultOptions={...e.defaultOptions},o}),s(t,"Data/Connectors/GoogleSheetsConnector.js",[t["Data/Connectors/DataConnector.js"],t["Data/Converters/GoogleSheetsConverter.js"],t["Core/Utilities.js"]],function(e,t,s){let{merge:r,pick:o}=s;class n extends e{constructor(e){let s=r(n.defaultOptions,e);super(s),this.converter=new t(s),this.options=s}load(e){let t=this,s=t.converter,r=t.table,{dataModifier:o,dataRefreshRate:i,enablePolling:l,firstRowAsNames:a,googleAPIKey:u,googleSpreadsheetKey:h}=t.options,m=n.buildFetchURL(u,h,t.options);return t.emit({type:"load",detail:e,table:r,url:m}),fetch(m).then(e=>e.json()).then(e=>{if("object"==typeof e&&e&&"object"==typeof e.error&&e.error&&"number"==typeof e.error.code&&"string"==typeof e.error.message&&"string"==typeof e.error.status)throw Error(e.error.message);return s.parse({firstRowAsNames:a,json:e}),r.deleteColumns(),r.setColumns(s.getTable().getColumns()),t.setModifierOptions(o)}).then(()=>(t.emit({type:"afterLoad",detail:e,table:r,url:m}),l&&setTimeout(()=>t.load(),1e3*Math.max(i||0,1)),t)).catch(s=>{throw t.emit({type:"loadError",detail:e,error:s,table:r}),s})}}return n.defaultOptions={googleAPIKey:"",googleSpreadsheetKey:"",worksheet:1,enablePolling:!1,dataRefreshRate:2,firstRowAsNames:!0},function(e){let t="ABCDEFGHIJKLMNOPQRSTUVWXYZ";function s(e={}){let{endColumn:r,endRow:n,googleSpreadsheetRange:i,startColumn:l,startRow:a}=e;return i||(t[l||0]||"A")+(Math.max(a||0,0)+1)+":"+(t[o(r,25)]||"Z")+(n?Math.max(n,0):"Z")}e.buildFetchURL=function(e,t,r={}){return`https://sheets.googleapis.com/v4/spreadsheets/${t}/values/`+(r.onlyColumnNames?"A1:Z1":s(r))+"?alt=json"+(r.onlyColumnNames?"":"&dateTimeRenderOption=FORMATTED_STRING&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE")+"&prettyPrint=false"+`&key=${e}`},e.buildQueryRange=s}(n||(n={})),e.registerType("GoogleSheets",n),n}),s(t,"Data/Converters/HTMLTableConverter.js",[t["Data/Converters/DataConverter.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s}=t;class r extends e{constructor(e){let t=s(r.defaultOptions,e);super(t),this.columns=[],this.headers=[],this.options=t,t.tableElement&&(this.tableElement=t.tableElement,this.tableElementID=t.tableElement.id)}export(e,t=this.options){let s=!1!==t.firstRowAsNames,r=t.useMultiLevelHeaders,o=e.getSortedColumns(t.usePresentationOrder),n=Object.keys(o),i=[],l=n.length,a=[],u="";if(s){let e=[];if(r){for(let t of n){let s=(o[t].shift()||"").toString();e.push(s)}u=this.getTableHeaderHTML(n,e,t)}else u=this.getTableHeaderHTML(void 0,n,t)}for(let e=0;e<l;e++){let t=o[n[e]],s=t.length;for(let r=0;r<s;r++){let s=t[r];a[r]||(a[r]=[]),"string"==typeof s||"number"==typeof s||void 0===s||(s=(s||"").toString()),a[r][e]=this.getCellHTMLFromValue(e?"td":"th",null,e?"":'scope="row"',s),e===l-1&&i.push("<tr>"+a[r].join("")+"</tr>")}}let h="";return t.tableCaption&&(h='<caption class="highcharts-table-caption">'+t.tableCaption+"</caption>"),"<table>"+h+u+"<tbody>"+i.join("")+"</tbody></table>"}getCellHTMLFromValue(e,t,s,r,o){let n=r,i="text"+(t?" "+t:"");return"number"==typeof n?(n=n.toString(),","===o&&(n=n.replace(".",o)),i="number"):r||(n="",i="empty"),"<"+e+(s?" "+s:"")+' class="'+i+'">'+n+"</"+e+">"}getTableHeaderHTML(e=[],t=[],s=this.options){let{useMultiLevelHeaders:r,useRowspanHeaders:o}=s,n="<thead>",i=0,l=t&&t.length,a,u=0,h;if(r&&e&&t&&!function(e,t){let s=e.length;if(t.length!==s)return!1;for(;--s;)if(e[s]!==t[s])return!1;return!0}(e,t)){for(n+="<tr>";i<l;++i)(a=e[i])===e[i+1]?++u:u?(n+=this.getCellHTMLFromValue("th","highcharts-table-topheading",'scope="col" colspan="'+(u+1)+'"',a),u=0):(a===t[i]?o?(h=2,delete t[i]):(h=1,t[i]=""):h=1,n+=this.getCellHTMLFromValue("th","highcharts-table-topheading",'scope="col"'+(h>1?' valign="top" rowspan="'+h+'"':""),a));n+="</tr>"}if(t){for(n+="<tr>",i=0,l=t.length;i<l;++i)void 0!==t[i]&&(n+=this.getCellHTMLFromValue("th",null,'scope="col"',t[i]));n+="</tr>"}return n+"</thead>"}parse(e,t){let r=[],o=[],n=s(this.options,e),{endRow:i,startColumn:l,endColumn:a,firstRowAsNames:u}=n,h=n.tableElement||this.tableElement;if(!(h instanceof HTMLElement)){this.emit({type:"parseError",columns:r,detail:t,headers:o,error:"Not a valid HTML Table"});return}this.tableElement=h,this.tableElementID=h.id,this.emit({type:"parse",columns:this.columns,detail:t,headers:this.headers});let m=h.getElementsByTagName("tr"),c=m.length,f=0,d,{startRow:p}=n;if(u&&c){let e=m[0].children,t=e.length;for(let s=l;s<t&&!(s>a);s++)("TD"===(d=e[s]).tagName||"TH"===d.tagName)&&o.push(d.innerHTML);p++}for(;f<c;){if(f>=p&&f<=i){let e=m[f].children,t=e.length,s=0;for(;s<t;){let t=s-l,o=r[t];if(("TD"===(d=e[s]).tagName||"TH"===d.tagName)&&s>=l&&s<=a){r[t]||(r[t]=[]);let e=this.asGuessedType(d.innerHTML);e instanceof Date&&(e=e.getTime()),r[t][f-p]=e;let s=1;for(;f-p>=s&&void 0===o[f-p-s];)o[f-p-s]=null,s++}s++}}f++}this.columns=r,this.headers=o,this.emit({type:"afterParse",columns:r,detail:t,headers:o})}getTable(){return e.getTableFromColumns(this.columns,this.headers)}}return r.defaultOptions={...e.defaultOptions,useRowspanHeaders:!0,useMultiLevelHeaders:!0},r}),s(t,"Data/Connectors/HTMLTableConnector.js",[t["Data/Connectors/DataConnector.js"],t["Core/Globals.js"],t["Data/Converters/HTMLTableConverter.js"],t["Core/Utilities.js"]],function(e,t,s,r){let{win:o}=t,{merge:n}=r;class i extends e{constructor(e){let t=n(i.defaultOptions,e);super(t),this.converter=new s(t),this.options=t}load(e){let t;let s=this,r=s.converter,i=s.table,{dataModifier:l,table:a}=s.options;if(s.emit({type:"load",detail:e,table:i,tableElement:s.tableElement}),"string"==typeof a?(s.tableID=a,t=o.document.getElementById(a)):(t=a,s.tableID=t.id),s.tableElement=t||void 0,!s.tableElement){let t="HTML table not provided, or element with ID not found";return s.emit({type:"loadError",detail:e,error:t,table:i}),Promise.reject(Error(t))}return r.parse(n({tableElement:s.tableElement},s.options),e),i.deleteColumns(),i.setColumns(r.getTable().getColumns()),s.setModifierOptions(l).then(()=>(s.emit({type:"afterLoad",detail:e,table:i,tableElement:s.tableElement}),s))}}return i.defaultOptions={table:""},e.registerType("HTMLTable",i),i}),s(t,"Data/Modifiers/ChainModifier.js",[t["Data/Modifiers/DataModifier.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s}=t;class r extends e{constructor(t,...o){super(),this.chain=o,this.options=s(r.defaultOptions,t);let n=this.options.chain||[];for(let t=0,s=n.length,r,i;t<s;++t)(r=n[t]).type&&(i=e.types[r.type])&&o.push(new i(r))}add(e,t){this.emit({type:"addModifier",detail:t,modifier:e}),this.chain.push(e),this.emit({type:"addModifier",detail:t,modifier:e})}clear(e){this.emit({type:"clearChain",detail:e}),this.chain.length=0,this.emit({type:"afterClearChain",detail:e})}modify(e,t){let s=this.options.reverse?this.chain.slice().reverse():this.chain.slice();e.modified===e&&(e.modified=e.clone(!1,t));let r=Promise.resolve(e);for(let e=0,o=s.length;e<o;++e){let o=s[e];r=r.then(e=>o.modify(e.modified,t))}return(r=r.then(t=>(e.modified.deleteColumns(),e.modified.setColumns(t.modified.getColumns()),e))).catch(s=>{throw this.emit({type:"error",detail:t,table:e}),s})}modifyCell(e,t,s,r,o){let n=this.options.reverse?this.chain.reverse():this.chain;if(n.length){let i=e.clone();for(let e=0,l=n.length;e<l;++e)n[e].modifyCell(i,t,s,r,o),i=i.modified;e.modified=i}return e}modifyColumns(e,t,s,r){let o=this.options.reverse?this.chain.reverse():this.chain.slice();if(o.length){let n=e.clone();for(let e=0,i=o.length;e<i;++e)o[e].modifyColumns(n,t,s,r),n=n.modified;e.modified=n}return e}modifyRows(e,t,s,r){let o=this.options.reverse?this.chain.reverse():this.chain.slice();if(o.length){let n=e.clone();for(let e=0,i=o.length;e<i;++e)o[e].modifyRows(n,t,s,r),n=n.modified;e.modified=n}return e}modifyTable(e,t){this.emit({type:"modify",detail:t,table:e});let s=this.options.reverse?this.chain.reverse():this.chain.slice(),r=e.modified;for(let e=0,o=s.length;e<o;++e)r=s[e].modifyTable(r,t).modified;return e.modified=r,this.emit({type:"afterModify",detail:t,table:e}),e}remove(e,t){let s=this.chain;this.emit({type:"removeModifier",detail:t,modifier:e}),s.splice(s.indexOf(e),1),this.emit({type:"afterRemoveModifier",detail:t,modifier:e})}}return r.defaultOptions={type:"Chain"},e.registerType("Chain",r),r}),s(t,"Data/Modifiers/InvertModifier.js",[t["Data/Modifiers/DataModifier.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s}=t;class r extends e{constructor(e){super(),this.options=s(r.defaultOptions,e)}modifyCell(e,t,s,r,o){let n=e.modified,i=n.getRowIndexBy("columnNames",t);return void 0===i?n.setColumns(this.modifyTable(e.clone()).getColumns(),void 0,o):n.setCell(`${s}`,i,r,o),e}modifyColumns(e,t,s,r){let o=e.modified,n=o.getColumn("columnNames")||[],i=e.getColumnNames(),l=e.getRowCount()!==n.length;if(!l){for(let e=0,t=i.length;e<t;++e)if(i[e]!==n[e]){l=!0;break}}if(l)return this.modifyTable(e,r);i=Object.keys(t);for(let e=0,n=i.length,l,a,u;e<n;++e){l=t[a=i[e]],u=o.getRowIndexBy("columnNames",a)||o.getRowCount();for(let e=0,t=s,n=l.length;e<n;++e,++t)o.setCell(`${t}`,u,l[e],r)}return e}modifyRows(e,t,s,r){let o=e.getColumnNames(),n=e.modified,i=n.getColumn("columnNames")||[],l=e.getRowCount()!==i.length;if(!l){for(let e=0,t=o.length;e<t;++e)if(o[e]!==i[e]){l=!0;break}}if(l)return this.modifyTable(e,r);for(let e=0,i=s,l=t.length,a;e<l;++e,++i)if((a=t[e])instanceof Array)n.setColumn(`${i}`,a);else for(let e=0,t=o.length;e<t;++e)n.setCell(`${i}`,e,a[o[e]],r);return e}modifyTable(e,t){this.emit({type:"modify",detail:t,table:e});let s=e.modified;if(e.hasColumns(["columnNames"])){let t=((e.deleteColumns(["columnNames"])||{}).columnNames||[]).map(e=>`${e}`),r={};for(let s=0,o=e.getRowCount(),n;s<o;++s)(n=e.getRow(s))&&(r[t[s]]=n);s.deleteColumns(),s.setColumns(r)}else{let t={};for(let s=0,r=e.getRowCount(),o;s<r;++s)(o=e.getRow(s))&&(t[`${s}`]=o);t.columnNames=e.getColumnNames(),s.deleteColumns(),s.setColumns(t)}return this.emit({type:"afterModify",detail:t,table:e}),e}}return r.defaultOptions={type:"Invert"},e.registerType("Invert",r),r}),s(t,"Data/Modifiers/MathModifier.js",[t["Data/Modifiers/DataModifier.js"],t["Data/Formula/FormulaParser.js"],t["Data/Formula/FormulaProcessor.js"]],function(e,t,s){class r extends e{constructor(e){super(),this.options={...r.defaultOptions,...e}}modifyTable(e,s){this.emit({type:"modify",detail:s,table:e});let r=this.options.alternativeSeparators,o=this.options.formulaColumns||e.getColumnNames(),n=e.modified;for(let t=0,s=o.length,r;t<s;++t)r=o[t],o.indexOf(r)>=0&&n.setColumn(r,this.processColumn(e,r));let i=this.options.columnFormulas||[];for(let s=0,o=i.length,l,a;s<o;++s)l=i[s],a=t.parseFormula(l.formula,r),n.setColumn(l.column,this.processColumnFormula(a,e,l.rowStart,l.rowEnd));return this.emit({type:"afterModify",detail:s,table:e}),e}processColumn(e,r,o=0){let n=this.options.alternativeSeparators,i=(e.getColumn(r,!0)||[]).slice(o>0?o:0);for(let r=0,o=i.length,l=[],a;r<o;++r)if("string"==typeof(a=i[r])&&"="===a[0])try{l=""===a?l:t.parseFormula(a.substring(1),n),i[r]=s.processFormula(l,e)}catch{i[r]=NaN}return i}processColumnFormula(e,t,r=0,o=t.getRowCount()){r=r>=0?r:0,o=o>=0?o:t.getRowCount()+o;let n=[],i=t.modified;for(let t=0,l=o-r;t<l;++t)try{n[t]=s.processFormula(e,i)}catch{n[t]=NaN}finally{e=s.translateReferences(e,0,1)}return n}}return r.defaultOptions={type:"Math",alternativeSeparators:!1},e.registerType("Math",r),r}),s(t,"Data/Modifiers/RangeModifier.js",[t["Data/Modifiers/DataModifier.js"],t["Core/Utilities.js"]],function(e,t){let{merge:s}=t;class r extends e{constructor(e){super(),this.options=s(r.defaultOptions,e)}modifyTable(e,t){this.emit({type:"modify",detail:t,table:e});let{additive:s,ranges:r,strict:o}=this.options;if(r.length){let t=e.modified,n=e.getColumns(),i=[];for(let l=0,a=r.length,u,h;l<a;++l)if(u=r[l],!o||typeof u.minValue==typeof u.maxValue){l>0&&!s&&(t.deleteRows(),t.setRows(i),n=t.getColumns(),i=[]),h=n[u.column]||[];for(let r=0,n=h.length,l,a;r<n;++r){switch(typeof(l=h[r])){default:continue;case"boolean":case"number":case"string":}(!o||typeof l==typeof u.minValue)&&l>=u.minValue&&l<=u.maxValue&&(a=s?e.getRow(r):t.getRow(r))&&i.push(a)}}t.deleteRows(),t.setRows(i)}return this.emit({type:"afterModify",detail:t,table:e}),e}}return r.defaultOptions={type:"Range",ranges:[]},e.registerType("Range",r),r}),s(t,"Data/Modifiers/SortModifier.js",[t["Data/Modifiers/DataModifier.js"],t["Data/DataTable.js"],t["Core/Utilities.js"]],function(e,t,s){let{merge:r}=s;class o extends e{static ascending(e,t){return(e||0)<(t||0)?-1:(e||0)>(t||0)?1:0}static descending(e,t){return(t||0)<(e||0)?-1:(t||0)>(e||0)?1:0}constructor(e){super(),this.options=r(o.defaultOptions,e)}getRowReferences(e){let t=e.getRows(),s=[];for(let e=0,r=t.length;e<r;++e)s.push({index:e,row:t[e]});return s}modifyCell(e,s,r,o,n){let{orderByColumn:i,orderInColumn:l}=this.options;return s===i&&(l?(e.modified.setCell(s,r,o),e.modified.setColumn(l,this.modifyTable(new t({columns:e.getColumns([i,l])})).modified.getColumn(l))):this.modifyTable(e,n)),e}modifyColumns(e,s,r,o){let{orderByColumn:n,orderInColumn:i}=this.options,l=Object.keys(s);return l.indexOf(n)>-1&&(i&&s[l[0]].length?(e.modified.setColumns(s,r),e.modified.setColumn(i,this.modifyTable(new t({columns:e.getColumns([n,i])})).modified.getColumn(i))):this.modifyTable(e,o)),e}modifyRows(e,s,r,o){let{orderByColumn:n,orderInColumn:i}=this.options;return i&&s.length?(e.modified.setRows(s,r),e.modified.setColumn(i,this.modifyTable(new t({columns:e.getColumns([n,i])})).modified.getColumn(i))):this.modifyTable(e,o),e}modifyTable(e,t){this.emit({type:"modify",detail:t,table:e});let s=e.getColumnNames(),r=e.getRowCount(),n=this.getRowReferences(e),{direction:i,orderByColumn:l,orderInColumn:a}=this.options,u="asc"===i?o.ascending:o.descending,h=s.indexOf(l),m=e.modified;if(-1!==h&&n.sort((e,t)=>u(e.row[h],t.row[h])),a){let e=[];for(let t=0;t<r;++t)e[n[t].index]=t;m.setColumns({[a]:e})}else{let e=[];for(let t=0;t<r;++t)e.push(n[t].row);m.setRows(e,0)}return this.emit({type:"afterModify",detail:t,table:e}),e}}return o.defaultOptions={type:"Sort",direction:"desc",orderByColumn:"y"},e.registerType("Sort",o),o}),s(t,"masters/modules/data-tools.src.js",[t["Core/Globals.js"],t["Data/Connectors/DataConnector.js"],t["Data/Converters/DataConverter.js"],t["Data/DataCursor.js"],t["Data/Modifiers/DataModifier.js"],t["Data/DataPool.js"],t["Data/DataTable.js"],t["Data/Formula/Formula.js"]],function(e,t,s,r,o,n,i,l){return e.DataConnector=e.DataConnector||t,e.DataConverter=e.DataConverter||s,e.DataCursor=e.DataCursor||r,e.DataModifier=e.DataModifier||o,e.DataPool=e.DataPool||n,e.DataTable=e.DataTable||i,e.Formula=e.Formula||l,e})});