!/**
 * Highcharts Gantt JS v11.4.6 (2024-07-08)
 *
 * Tree Grid
 *
 * (c) 2016-2024 Jon Arild Nygard
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(e,i,s,r){e.hasOwnProperty(i)||(e[i]=r.apply(null,s),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:e[i]}})))}i(e,"Core/Axis/BrokenAxis.js",[e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(t,e){var i,s=e.addEvent,r=e.find,o=e.fireEvent,n=e.isArray,a=e.isNumber,l=e.pick;return function(e){function i(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function d(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function h(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var e=this.tickPositions,i=this.tickPositions.info,s=[],r=0;r<e.length;r++)t.isInAnyBreak(e[r])||s.push(e[r]);this.tickPositions=s,this.tickPositions.info=i}}function c(){this.brokenAxis||(this.brokenAxis=new g(this))}function p(){var t,e,i=this.isDirty,s=this.options.connectNulls,r=this.points,o=this.xAxis,n=this.yAxis;if(i)for(var a=r.length;a--;){var l=r[a],d=!(null===l.y&&!1===s)&&((null===(t=null==o?void 0:o.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(l.x,!0))||(null===(e=null==n?void 0:n.brokenAxis)||void 0===e?void 0:e.isInAnyBreak(l.y,!0)));l.visible=!d&&!1!==l.options.visible}}function f(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,l(this.pointArrayMap,["y"]))}function u(t,e){var i,s,r,n,d=this,h=d.points;if(null===(i=null==t?void 0:t.brokenAxis)||void 0===i?void 0:i.hasBreaks){var c=t.brokenAxis;e.forEach(function(e){s=(null==c?void 0:c.breakArray)||[],r=t.isXAxis?t.min:l(d.options.threshold,t.min);var i,p,f=null===(p=null===(i=null==t?void 0:t.options)||void 0===i?void 0:i.breaks)||void 0===p?void 0:p.filter(function(t){for(var e=!0,i=0;i<s.length;i++){var r=s[i];if(r.from===t.from&&r.to===t.to){e=!1;break}}return e});h.forEach(function(i){n=l(i["stack"+e.toUpperCase()],i[e]),s.forEach(function(e){if(a(r)&&a(n)){var s="";r<e.from&&n>e.to||r>e.from&&n<e.from?s="pointBreak":(r<e.from&&n>e.from&&n<e.to||r>e.from&&n>e.to&&n<e.from)&&(s="pointInBreak"),s&&o(t,s,{point:i,brk:e})}}),null==f||f.forEach(function(e){o(t,"pointOutsideOfBreak",{point:i,brk:e})})})})}}function v(){var e=this.currentDataGrouping,i=null==e?void 0:e.gapSize,s=this.points.slice(),r=this.yAxis,o=this.options.gapSize,n=s.length-1;if(o&&n>0){"value"!==this.options.gapUnit&&(o*=this.basePointRange),i&&i>o&&i>=this.basePointRange&&(o=i);for(var a=void 0,l=void 0;n--;)if(l&&!1!==l.visible||(l=s[n+1]),a=s[n],!1!==l.visible&&!1!==a.visible){if(l.x-a.x>o){var d=(a.x+l.x)/2;s.splice(n+1,0,{isNull:!0,x:d}),r.stacking&&this.options.stacking&&((r.stacking.stacks[this.stackKey][d]=new t(r,r.options.stackLabels,!1,d,this.stack)).total=0)}l=a}}return this.getGraphPath(s)}e.compose=function(t,e){if(!t.keepProps.includes("brokenAxis")){t.keepProps.push("brokenAxis"),s(t,"init",c),s(t,"afterInit",i),s(t,"afterSetTickPositions",h),s(t,"afterSetOptions",d);var r=e.prototype;r.drawBreaks=u,r.gappedPath=v,s(e,"afterGeneratePoints",p),s(e,"afterRender",f)}return t};var g=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,e){var i=t.repeat||1/0,s=t.from,r=t.to-t.from,o=e>=s?(e-s)%i:i-(s-e)%i;return t.inclusive?o<=r:o<r&&0!==o},t.lin2Val=function(e){var i=this.brokenAxis,s=i&&i.breakArray;if(!s||!a(e))return e;var r,o,n=e;for(o=0;o<s.length&&!((r=s[o]).from>=n);o++)r.to<n?n+=r.len:t.isInBreak(r,n)&&(n+=r.len);return n},t.val2Lin=function(e){var i=this.brokenAxis,s=i&&i.breakArray;if(!s||!a(e))return e;var r,o,n=e;for(o=0;o<s.length;o++)if((r=s[o]).to<=e)n-=r.len;else if(r.from>=e)break;else if(t.isInBreak(r,e)){n-=e-r.from;break}return n},t.prototype.findBreakAt=function(t,e){return r(e,function(e){return e.from<t&&t<e.to})},t.prototype.isInAnyBreak=function(e,i){var s,r,o,n=this.axis,d=n.options.breaks||[],h=d.length;if(h&&a(e)){for(;h--;)t.isInBreak(d[h],e)&&(s=!0,r||(r=l(d[h].showPoints,!n.isXAxis)));o=s&&i?s&&!r:s}return o},t.prototype.setBreaks=function(e,i){var s=this,r=s.axis,d=n(e)&&!!e.length&&!!Object.keys(e[0]).length;r.isDirty=s.hasBreaks!==d,s.hasBreaks=d,e!==r.options.breaks&&(r.options.breaks=r.userOptions.breaks=e),r.forceRedraw=!0,r.series.forEach(function(t){t.isDirty=!0}),d||r.val2lin!==t.val2Lin||(delete r.val2lin,delete r.lin2val),d&&(r.userOptions.ordinal=!1,r.lin2val=t.lin2Val,r.val2lin=t.val2Lin,r.setExtremes=function(t,e,i,o,n){if(s.hasBreaks){for(var a=this.options.breaks||[],l=void 0;l=s.findBreakAt(t,a);)t=l.to;for(;l=s.findBreakAt(e,a);)e=l.from;e<t&&(e=t)}r.constructor.prototype.setExtremes.call(this,t,e,i,o,n)},r.setAxisTranslation=function(){if(r.constructor.prototype.setAxisTranslation.call(this),s.unitLength=void 0,s.hasBreaks){var e,i,n,d,h=r.options.breaks||[],c=[],p=[],f=l(r.pointRangePadding,0),u=0,v=r.userMin||r.min,g=r.userMax||r.max;h.forEach(function(e){i=e.repeat||1/0,a(v)&&a(g)&&(t.isInBreak(e,v)&&(v+=e.to%i-v%i),t.isInBreak(e,g)&&(g-=g%i-e.from%i))}),h.forEach(function(t){if(n=t.from,i=t.repeat||1/0,a(v)&&a(g)){for(;n-i>v;)n-=i;for(;n<v;)n+=i;for(d=n;d<g;d+=i)c.push({value:d,move:"in"}),c.push({value:d+t.to-t.from,move:"out",size:t.breakSize})}}),c.sort(function(t,e){return t.value===e.value?("in"===t.move?0:1)-("in"===e.move?0:1):t.value-e.value}),e=0,n=v,c.forEach(function(t){1===(e+="in"===t.move?1:-1)&&"in"===t.move&&(n=t.value),0===e&&a(n)&&(p.push({from:n,to:t.value,len:t.value-n-(t.size||0)}),u+=t.value-n-(t.size||0))}),s.breakArray=p,a(v)&&a(g)&&a(r.min)&&(s.unitLength=g-v-u+f,o(r,"afterBreaks"),r.staticScale?r.transA=r.staticScale:s.unitLength&&(r.transA*=(g-r.min+f)/s.unitLength),f&&(r.minPixelPadding=r.transA*(r.minPointOffset||0)),r.min=v,r.max=g)}}),l(i,!0)&&r.chart.redraw()},t}();e.Additions=g}(i||(i={})),i}),i(e,"Core/Axis/GridAxis.js",[e["Core/Axis/Axis.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){var s,r,o=e.dateFormats,n=i.addEvent,a=i.defined,l=i.erase,d=i.find,h=i.isArray,c=i.isNumber,p=i.merge,f=i.pick,u=i.timeUnits,v=i.wrap;function g(t){return i.isObject(t,!0)}function m(t,e){var i={width:0,height:0};if(e.forEach(function(e){var s,r=t[e],o=0,n=0;g(r)&&(o=(s=g(r.label)?r.label:{}).getBBox?s.getBBox().height:0,s.textStr&&!c(s.textPxLength)&&(s.textPxLength=s.getBBox().width),n=c(s.textPxLength)?Math.round(s.textPxLength):0,s.textStr&&(n=Math.round(s.getBBox().width)),i.height=Math.max(o,i.height),i.width=Math.max(n,i.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){var s=this.treeGrid.mapOfPosToGridNode[-1].height||0;i.width+=this.options.labels.indentation*(s-1)}return i}function k(t){var e=this.grid,i=3===this.side;if(i||t.apply(this),!(null==e?void 0:e.isColumn)){var s=(null==e?void 0:e.columns)||[];i&&(s=s.slice().reverse()),s.forEach(function(t){t.getOffset()})}i&&t.apply(this)}function x(t){if(!0===(this.options.grid||{}).enabled){var e=this.axisTitle,i=this.height,s=this.horiz,o=this.left,n=this.offset,a=this.opposite,l=this.options,d=this.top,h=this.width,c=this.tickSize(),p=e&&e.getBBox().width,u=l.title.x,v=l.title.y,g=f(l.title.margin,s?5:10),m=e?this.chart.renderer.fontMetrics(e).f:0,k=(s?d+i:o)+(s?1:-1)*(a?-1:1)*(c?c[0]/2:0)+(this.side===r.bottom?m:0);t.titlePosition.x=s?o-(p||0)/2-g+u:k+(a?h:0)+n+u,t.titlePosition.y=s?k-(a?i:0)+(a?m:-m)/2+n+v:d-g+v}}function b(){var e,i=this.chart,s=this.options.grid,r=void 0===s?{}:s,o=this.userOptions;if(r.enabled&&((e=this.options).labels.align=f(e.labels.align,"center"),this.categories||(e.showLastLabel=!1),this.labelRotation=0,e.labels.rotation=0,e.minTickInterval=1),r.columns)for(var n=this.grid.columns=[],a=this.grid.columnIndex=0;++a<r.columns.length;){var d=p(o,r.columns[a],{isInternal:!0,linkedTo:0,scrollbar:{enabled:!1}},{grid:{columns:void 0}}),h=new t(this.chart,d,"yAxis");h.grid.isColumn=!0,h.grid.columnIndex=a,l(i.axes,h),l(i[this.coll]||[],h),n.push(h)}}function y(){var t=this.axisTitle,e=this.grid,i=this.options;if(!0===(i.grid||{}).enabled){var s=this.min||0,o=this.max||0,n=this.ticks[this.tickPositions[0]];if(t&&!this.chart.styledMode&&(null==n?void 0:n.slotWidth)&&!this.options.title.style.width&&t.css({width:"".concat(n.slotWidth,"px")}),this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){var a=i.lineWidth;if(a){var l=this.getLinePath(a),d=l[0],h=l[1],c=(this.tickSize("tick")||[1])[0]*(this.side===r.top||this.side===r.left?-1:1);if("M"===d[0]&&"L"===h[0]&&(this.horiz?(d[2]+=c,h[2]+=c):(d[1]+=c,h[1]+=c)),!this.horiz&&this.chart.marginRight){var p=["L",this.left,d[2]||0],f=[d,p],u=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(o+this.tickmarkOffset)],v=[["M",h[1]||0,this.toPixels(o+this.tickmarkOffset)],u];this.grid.upperBorder||s%1==0||(this.grid.upperBorder=this.grid.renderBorder(f)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.upperBorder.animate({d:f})),this.grid.lowerBorder||o%1==0||(this.grid.lowerBorder=this.grid.renderBorder(v)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.lowerBorder.animate({d:v}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.axisLineExtra.animate({d:l})):this.grid.axisLineExtra=this.grid.renderBorder(l),this.axisLine[this.showAxis?"show":"hide"]()}}if((e&&e.columns||[]).forEach(function(t){return t.render()}),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)&&this.tickPositions.length){for(var g=this.tickmarkOffset,m=this.tickPositions[this.tickPositions.length-1],k=this.tickPositions[0],x=void 0,b=void 0;(x=this.hiddenLabels.pop())&&x.element;)x.show();for(;(b=this.hiddenMarks.pop())&&b.element;)b.show();(x=this.ticks[k].label)&&(s-k>g?this.hiddenLabels.push(x.hide()):x.show()),(x=this.ticks[m].label)&&(m-o>g?this.hiddenLabels.push(x.hide()):x.show());var y=this.ticks[m].mark;y&&m-o<g&&m-o>0&&this.ticks[m].isLast&&this.hiddenMarks.push(y.hide())}}}function P(){var t=this.tickPositions&&this.tickPositions.info,e=this.options,i=e.grid||{},s=this.userOptions.labels||{};i.enabled&&(this.horiz?(this.series.forEach(function(t){t.options.pointRange=0}),t&&e.dateTimeLabelFormats&&e.labels&&!a(s.align)&&(!1===e.dateTimeLabelFormats[t.unitName].range||t.count>1)&&(e.labels.align="left",a(s.x)||(e.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function A(t){var e,i=this.options,s=t.userOptions,r=i&&g(i.grid)?i.grid:{};!0===r.enabled&&(e=p(!0,{className:"highcharts-grid-axis "+(s.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0,style:{textOverflow:"ellipsis"}},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},s),"xAxis"!==this.coll||(a(s.linkedTo)&&!a(s.tickPixelInterval)&&(e.tickPixelInterval=350),!(!a(s.tickPixelInterval)&&a(s.linkedTo))||a(s.tickPositioner)||a(s.tickInterval)||a(s.units)||(e.tickPositioner=function(t,i){var s=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(s){for(var r=e.units||[],o=void 0,n=1,a="year",l=0;l<r.length;l++){var d=r[l];if(d&&d[0]===s.unitName){o=l;break}}var h=c(o)&&r[o+1];if(h){a=h[0]||"year";var p=h[1];n=p&&p[0]||1}else"year"===s.unitName&&(n=10*s.count);var f=u[a];return this.tickInterval=f*n,this.chart.time.getTimeTicks({unitRange:f,count:n,unitName:a},t,i,this.options.startOfWeek)}})),p(!0,this.options,e),this.horiz&&(i.minPadding=f(s.minPadding,0),i.maxPadding=f(s.maxPadding,0)),c(i.grid.borderWidth)&&(i.tickWidth=i.lineWidth=r.borderWidth))}function G(t){var e=t.userOptions,i=e&&e.grid||{},s=i.columns;i.enabled&&s&&p(!0,this.options,s[0])}function O(){(this.grid.columns||[]).forEach(function(t){return t.setScale()})}function T(t){var e=this.horiz,i=this.maxLabelDimensions,s=this.options.grid,r=void 0===s?{}:s;if(r.enabled&&i){var o=2*this.options.labels.distance,n=e?r.cellHeight||o+i.height:o+i.width;h(t.tickSize)?t.tickSize[0]=n:t.tickSize=[n,0]}}function C(){this.axes.forEach(function(t){(t.grid&&t.grid.columns||[]).forEach(function(t){t.setAxisSize(),t.setAxisTranslation()})})}function B(t){var e=this.grid;(e.columns||[]).forEach(function(e){return e.destroy(t.keepEvents)}),e.columns=void 0}function w(t){var e=t.userOptions||{},i=e.grid||{};i.enabled&&a(i.borderColor)&&(e.tickColor=e.lineColor=i.borderColor),this.grid||(this.grid=new S(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function E(t){var e=this.label,i=this.axis,s=i.reversed,o=i.chart,n=i.options.grid||{},a=i.options.labels,l=a.align,d=r[i.side],h=t.tickmarkOffset,p=i.tickPositions,f=this.pos-h,u=c(p[t.index+1])?p[t.index+1]-h:(i.max||0)+h,v=i.tickSize("tick"),g=v?v[0]:0,m=v?v[1]/2:0;if(!0===n.enabled){var k,x=void 0,b=void 0,y=void 0;if("top"===d?k=(x=i.top+i.offset)-g:"bottom"===d?x=(k=o.chartHeight-i.bottom+i.offset)+g:(x=i.top+i.len-(i.translate(s?u:f)||0),k=i.top+i.len-(i.translate(s?f:u)||0)),"right"===d?y=(b=o.chartWidth-i.right+i.offset)+g:"left"===d?b=(y=i.left+i.offset)-g:(b=Math.round(i.left+(i.translate(s?u:f)||0))-m,y=Math.min(Math.round(i.left+(i.translate(s?f:u)||0))-m,i.left+i.len)),this.slotWidth=y-b,t.pos.x="left"===l?b:"right"===l?y:b+(y-b)/2,t.pos.y=k+(x-k)/2,e){var P=o.renderer.fontMetrics(e),A=e.getBBox().height;if(a.useHTML)t.pos.y+=P.b+-(A/2);else{var G=Math.round(A/P.h);t.pos.y+=(P.b-(P.h-P.f))/2+-((G-1)*P.h/2)}}t.pos.x+=i.horiz&&a.x||0}}function I(t){var i=t.axis,s=t.value;if(i.options.grid&&i.options.grid.enabled){var r=i.tickPositions,o=(i.linkedParent||i).series[0],n=s===r[0],a=s===r[r.length-1],l=o&&d(o.options.data,function(t){return t[i.isXAxis?"x":"y"]===s}),h=void 0;l&&o.is("gantt")&&(h=p(l),e.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(h)),t.isFirst=n,t.isLast=a,t.point=h}}function N(){var t=this.options,e=t.grid||{},i=this.categories,s=this.tickPositions,r=s[0],o=s[1],n=s[s.length-1],a=s[s.length-2],l=this.linkedParent&&this.linkedParent.min,d=this.linkedParent&&this.linkedParent.max,h=l||this.min,p=d||this.max,f=this.tickInterval,u=c(h)&&h>=r+f&&h<o,v=c(h)&&r<h&&r+f>h,g=c(p)&&n>p&&n-f<p,m=c(p)&&p<=n-f&&p>a;!0===e.enabled&&!i&&(this.isXAxis||this.isLinked)&&((v||u)&&!t.startOnTick&&(s[0]=h),(g||m)&&!t.endOnTick&&(s[s.length-1]=p))}function L(t){var e,i=this.options.grid;return!0===(void 0===i?{}:i).enabled&&this.categories?this.tickInterval:t.apply(this,(e=arguments,Array.prototype.slice.call(e,1)))}(s=r||(r={}))[s.top=0]="top",s[s.right=1]="right",s[s.bottom=2]="bottom",s[s.left=3]="left";var S=function(){function t(t){this.axis=t}return t.prototype.isOuterAxis=function(){var t,e=this.axis,i=e.chart,s=e.grid.columnIndex,r=(null===(t=e.linkedParent)||void 0===t?void 0:t.grid.columns)||e.grid.columns||[],o=s?e.linkedParent:e,n=-1,a=0;return 3===e.side&&!i.inverted&&r.length?!e.linkedParent:((i[e.coll]||[]).forEach(function(t,i){t.side!==e.side||t.options.isInternal||(a=i,t!==o||(n=i))}),a===n&&(!c(s)||r.length===s))},t.prototype.renderBorder=function(t){var e=this.axis,i=e.chart.renderer,s=e.options,r=i.path(t).addClass("highcharts-axis-line").add(e.axisGroup);return i.styledMode||r.attr({stroke:s.lineColor,"stroke-width":s.lineWidth,zIndex:7}),r},t}();return o.E=function(t){return this.dateFormat("%a",t,!0).charAt(0)},o.W=function(t){var e=this,i=new this.Date(t);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(t){e.set(t,i,0)});var s=(this.get("Day",i)+6)%7,r=new this.Date(i.valueOf());this.set("Date",r,this.get("Date",i)-s+3);var o=new this.Date(this.get("FullYear",r),0,1);return 4!==this.get("Day",o)&&(this.set("Month",i,0),this.set("Date",i,1+(11-this.get("Day",o))%7)),(1+Math.floor((r.valueOf()-o.valueOf())/6048e5)).toString()},{compose:function(t,e,i){return t.keepProps.includes("grid")||(t.keepProps.push("grid"),t.prototype.getMaxLabelDimensions=m,v(t.prototype,"unsquish",L),v(t.prototype,"getOffset",k),n(t,"init",w),n(t,"afterGetTitlePosition",x),n(t,"afterInit",b),n(t,"afterRender",y),n(t,"afterSetAxisTranslation",P),n(t,"afterSetOptions",A),n(t,"afterSetOptions",G),n(t,"afterSetScale",O),n(t,"afterTickSize",T),n(t,"trimTicks",N),n(t,"destroy",B),n(e,"afterSetChartSize",C),n(i,"afterGetLabelPosition",E),n(i,"labelFormat",I)),t}}}),i(e,"Gantt/Tree.js",[e["Core/Utilities.js"]],function(t){var e=this&&this.__rest||function(t,e){var i={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&0>e.indexOf(s)&&(i[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var r=0,s=Object.getOwnPropertySymbols(t);r<s.length;r++)0>e.indexOf(s[r])&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(i[s[r]]=t[s[r]]);return i},i=t.extend,s=t.isNumber,r=t.pick;function o(t,e,n,a,l,d){var h,c,p=d&&d.after,f=d&&d.before,u={data:a,depth:n-1,id:t,level:n,parent:e||""},v=0,g=0;"function"==typeof f&&f(u,d);var m=(l[t]||[]).map(function(e){var i=o(e.id,t,n+1,e,l,d),r=e.start||NaN,a=!0===e.milestone?r:e.end||NaN;return h=!s(h)||r<h?r:h,c=!s(c)||a>c?a:c,v=v+1+i.descendants,g=Math.max(i.height+1,g),i});return a&&(a.start=r(a.start,h),a.end=r(a.end,c)),i(u,{children:m,descendants:v,height:g}),"function"==typeof p&&p(u,d),u}return{getNode:o,getTree:function(t,i){var s,r;return o("",null,1,null,(s=[],Object.keys(r=t.reduce(function(t,e){var i=e.parent,r=void 0===i?"":i,o=e.id;return void 0===t[r]&&(t[r]=[]),t[r].push(e),o&&s.push(o),t},{})).forEach(function(t){var i;if(""!==t&&-1===s.indexOf(t)){var o=r[t].map(function(t){return e(t,[])});(i=r[""]).push.apply(i,o),delete r[t]}}),r),i)}}}),i(e,"Core/Axis/TreeGrid/TreeGridTick.js",[e["Core/Utilities.js"]],function(t){var e=t.addEvent,i=t.removeEvent,s=t.isObject,r=t.isNumber,o=t.pick,n=t.wrap;function a(){this.treeGrid||(this.treeGrid=new h(this))}function l(t,e,i,n,a,l,d,h,c){var p,f,u,v=o(this.options&&this.options.labels,l),g=this.pos,m=this.axis,k="treegrid"===m.options.type,x=t.apply(this,[e,i,n,a,v,d,h,c]);if(k){var b=v&&s(v.symbol,!0)?v.symbol:{},y=b.width,P=b.padding,A=void 0===P?m.linkedParent?0:5:P,G=v&&r(v.indentation)?v.indentation:0;u=(f=(p=m.treeGrid.mapOfPosToGridNode)&&p[g])&&f.depth||1,x.x+=(void 0===y?0:y)+2*A+(u-1)*G}return x}function d(t){var n,a,l,d,h,c,p,f,u,v,g,m,k,x,b,y,P,A=this.pos,G=this.axis,O=this.label,T=this.treeGrid,C=this.options,B=null==T?void 0:T.labelIcon,w=null==O?void 0:O.element,E=G.treeGrid,I=G.options,N=G.chart,L=G.tickPositions,S=E.mapOfPosToGridNode,M=o(null==C?void 0:C.labels,null==I?void 0:I.labels),j=M&&s(M.symbol,!0)?M.symbol:{},W=S&&S[A],D=W||{},z=D.descendants,R=D.depth,U=W&&z&&z>0,H="treegrid"===I.type&&w,F=L.indexOf(A)>-1,X="highcharts-treegrid-node-",q=X+"level-",V=N.styledMode;(H&&W&&O.removeClass(RegExp(q+".*")).addClass(q+R),t.apply(this,Array.prototype.slice.call(arguments,1)),H&&U)?(b=E.isCollapsed(W),n={color:!V&&O.styles.color||"",collapsed:b,group:O.parentGroup,options:j,renderer:O.renderer,show:F,xy:O.xy},d=!(l=this.treeGrid).labelIcon,h=n.renderer,c=n.xy,f=(p=n.options).width||0,u=p.height||0,v=(null!==(a=p.padding)&&void 0!==a?a:this.axis.linkedParent)?0:5,g={x:c.x-f/2-v,y:c.y-u/2},m=n.collapsed?90:180,k=n.show&&r(g.y),(x=l.labelIcon)||(l.labelIcon=x=h.path(h.symbols[p.type](p.x||0,p.y||0,f,u)).addClass("highcharts-label-icon").add(n.group)),x[k?"show":"hide"](),h.styledMode||x.attr({cursor:"pointer",fill:o(n.color,"#666666"),"stroke-width":1,stroke:p.lineColor,strokeWidth:p.lineWidth||0}),x[d?"attr":"animate"]({translateX:g.x,translateY:g.y,rotation:m}),y=X+(b?"collapsed":"expanded"),P=X+(b?"expanded":"collapsed"),O.addClass(y).removeClass(P),V||O.css({cursor:"pointer"}),[O,B].forEach(function(t){t&&!t.attachedTreeGridEvents&&(e(t.element,"mouseover",function(){O.addClass("highcharts-treegrid-node-active"),O.renderer.styledMode||O.css({textDecoration:"underline"})}),e(t.element,"mouseout",function(){var t;t=s(M.style)?M.style:{},O.removeClass("highcharts-treegrid-node-active"),O.renderer.styledMode||O.css({textDecoration:t.textDecoration||"none"})}),e(t.element,"click",function(){T.toggleCollapse()}),t.attachedTreeGridEvents=!0)})):B&&(i(w),null==O||O.css({cursor:"default"}),B.destroy())}var h=function(){function t(t){this.tick=t}return t.compose=function(t){var i=t.prototype;i.toggleCollapse||(e(t,"init",a),n(i,"getLabelPosition",l),n(i,"renderLabel",d),i.collapse=function(t){this.treeGrid.collapse(t)},i.expand=function(t){this.treeGrid.expand(t)},i.toggleCollapse=function(t){this.treeGrid.toggleCollapse(t)})},t.prototype.collapse=function(t){var e=this.tick,i=e.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){var r=e.pos,n=i.treeGrid.mapOfPosToGridNode[r],a=i.treeGrid.collapse(n);s.setBreaks(a,o(t,!0))}},t.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()},t.prototype.expand=function(t){var e=this.tick,i=e.pos,s=e.axis,r=s.treeGrid,n=s.brokenAxis,a=r.mapOfPosToGridNode;if(n&&a){var l=a[i],d=r.expand(l);n.setBreaks(d,o(t,!0))}},t.prototype.toggleCollapse=function(t){var e=this.tick,i=e.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){var r=e.pos,n=i.treeGrid.mapOfPosToGridNode[r],a=i.treeGrid.toggleCollapse(n);s.setBreaks(a,o(t,!0))}},t}();return h}),i(e,"Series/TreeUtilities.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var i=e.extend,s=e.isArray,r=e.isNumber,o=e.isObject,n=e.merge,a=e.pick,l=e.relativeLength;return{getColor:function(e,i){var s,r,o,n,l,d,h,c=i.index,p=i.mapOptionsToLevel,f=i.parentColor,u=i.parentColorIndex,v=i.series,g=i.colors,m=i.siblings,k=v.points,x=v.chart.options.chart;return e&&(r=k[e.i],o=p[e.level]||{},r&&o.colorByPoint&&(l=r.index%(g?g.length:x.colorCount),n=g&&g[l]),v.chart.styledMode||(d=a(r&&r.options.color,o&&o.color,n,f&&((s=o&&o.colorVariation)&&"brightness"===s.key&&c&&m?t.parse(f).brighten(s.to*(c/m)).get():f),v.color)),h=a(r&&r.options.colorIndex,o&&o.colorIndex,l,u,i.colorIndex)),{color:d,colorIndex:h}},getLevelOptions:function(t){var e,i,l,d,h,c,p={};if(o(t))for(d=r(t.from)?t.from:1,c=t.levels,i={},e=o(t.defaults)?t.defaults:{},s(c)&&(i=c.reduce(function(t,i){var s,l,h;return o(i)&&r(i.level)&&(l=a((h=n({},i)).levelIsConstant,e.levelIsConstant),delete h.levelIsConstant,delete h.level,o(t[s=i.level+(l?0:d-1)])?n(!0,t[s],h):t[s]=h),t},{})),h=r(t.to)?t.to:1,l=0;l<=h;l++)p[l]=n({},e,o(i[l])?i[l]:{});return p},getNodeWidth:function(t,e){var i=t.chart,s=t.options,r=s.nodeDistance,o=void 0===r?0:r,n=s.nodeWidth,a=void 0===n?0:n,d=i.plotSizeX,h=void 0===d?1:d;if("auto"===a){if("string"==typeof o&&/%$/.test(o))return h/(e+parseFloat(o)/100*(e-1));var c=Number(o);return(h+c)/(e||1)-c}return l(a,h)},setTreeValues:function t(e,s){var r=s.before,o=s.idRoot,n=s.mapIdToNode[o],l=!1!==s.levelIsConstant,d=s.points[e.i],h=d&&d.options||{},c=[],p=0;e.levelDynamic=e.level-(l?0:n.level),e.name=a(d&&d.name,""),e.visible=o===e.id||!0===s.visible,"function"==typeof r&&(e=r(e,s)),e.children.forEach(function(r,o){var n=i({},s);i(n,{index:o,siblings:e.children.length,visible:e.visible}),r=t(r,n),c.push(r),r.visible&&(p+=r.val)});var f=a(h.value,p);return e.visible=f>=0&&(p>0||e.visible),e.children=c,e.childrenTotal=p,e.isLeaf=e.visible&&!p,e.val=f,e},updateRootId:function(t){var e,i;return o(t)&&(i=o(t.options)?t.options:{},e=a(t.rootNode,i.rootId,""),o(t.userOptions)&&(t.userOptions.rootId=e),t.rootNode=e),e}}}),i(e,"Core/Axis/TreeGrid/TreeGridAxis.js",[e["Core/Axis/BrokenAxis.js"],e["Core/Axis/GridAxis.js"],e["Gantt/Tree.js"],e["Core/Axis/TreeGrid/TreeGridTick.js"],e["Series/TreeUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,s,r,o){var n,a=r.getLevelOptions,l=o.addEvent,d=o.find,h=o.fireEvent,c=o.isArray,p=o.isObject,f=o.isString,u=o.merge,v=o.pick,g=o.removeEvent,m=o.wrap;function k(t,e){var i=t.collapseEnd||0,s=t.collapseStart||0;return i>=e&&(s-=.5),{from:s,to:i,showPoints:!1}}function x(t,e,s){var r,o,n=[],a=[],l={},h="boolean"==typeof e&&e,c={},u=-1,v=i.getTree(t,{after:function(t){var e=c[t.pos],i=0,s=0;e.children.forEach(function(t){s+=(t.descendants||0)+1,i=Math.max((t.height||0)+1,i)}),e.descendants=s,e.height=i,e.collapsed&&a.push(e)},before:function(t){var e,i,s=p(t.data,!0)?t.data:{},r=f(s.name)?s.name:"",o=l[t.parent],a=p(o,!0)?c[o.pos]:null;h&&p(a,!0)&&(e=d(a.children,function(t){return t.name===r}))?(i=e.pos,e.nodes.push(t)):i=u++,!c[i]&&(c[i]=e={depth:a?a.depth+1:0,name:r,id:s.id,nodes:[t],children:[],pos:i},-1!==i&&n.push(r),p(a,!0)&&a.children.push(e)),f(t.id)&&(l[t.id]=t),e&&!0===s.collapsed&&(e.collapsed=!0),t.pos=i}});return r=c,{categories:n,mapOfIdToNode:l,mapOfPosToGridNode:c=(o=function(t,e,i){var r=t.nodes,n=e+(-1===e?0:s-1),a=(n-e)/2,l=e+a;return r.forEach(function(t){var i=t.data;p(i,!0)&&(i.y=e+(i.seriesIndex||0),delete i.seriesIndex),t.pos=l}),i[l]=t,t.pos=l,t.tickmarkOffset=a+.5,t.collapseStart=n+.5,t.children.forEach(function(t){o(t,n+1,i),n=(t.collapseEnd||0)-.5}),t.collapseEnd=n+.5,i})(r["-1"],-1,{}),collapsedNodes:a,tree:v}}function b(t){t.target.axes.filter(function(t){return"treegrid"===t.options.type}).forEach(function(e){var i,s,r=e.options||{},o=r.labels,n=r.uniqueNames,l=r.max,d=!e.treeGrid.mapOfPosToGridNode||e.series.some(function(t){return!t.hasRendered||t.isDirtyData||t.isDirty}),h=0;if(d){if(i=e.series.reduce(function(t,e){return e.visible&&((e.options.data||[]).forEach(function(i){e.options.keys&&e.options.keys.length&&(i=e.pointClass.prototype.optionsToObject.call({series:e},i),e.pointClass.setGanttPointAliases(i)),p(i,!0)&&(i.seriesIndex=h,t.push(i))}),!0===n&&h++),t},[]),l&&i.length<l)for(var f=i.length;f<=l;f++)i.push({name:f+"​"});s=x(i,n||!1,!0===n?h:1),e.categories=s.categories,e.treeGrid.mapOfPosToGridNode=s.mapOfPosToGridNode,e.hasNames=!0,e.treeGrid.tree=s.tree,e.series.forEach(function(t){var e=(t.options.data||[]).map(function(e){return c(e)&&t.options.keys&&t.options.keys.length&&i.forEach(function(t){e.indexOf(t.x)>=0&&e.indexOf(t.x2)>=0&&(e=t)}),p(e,!0)?u(e):e});t.visible&&t.setData(e,!1)}),e.treeGrid.mapOptionsToLevel=a({defaults:o,from:1,levels:o&&o.levels,to:e.treeGrid.tree&&e.treeGrid.tree.height}),"beforeRender"===t.type&&(e.treeGrid.collapsedNodes=s.collapsedNodes)}})}function y(t,e){var i,s,r,o=this.treeGrid.mapOptionsToLevel||{},a="treegrid"===this.options.type,l=this.ticks,d=l[e];a&&this.treeGrid.mapOfPosToGridNode?((i=o[(r=this.treeGrid.mapOfPosToGridNode[e]).depth])&&(s={labels:i}),!d&&n?l[e]=d=new n(this,e,void 0,void 0,{category:r.name,tickmarkOffset:r.tickmarkOffset,options:s}):(d.parameters.category=r.name,d.options=s,d.addLabel())):t.apply(this,Array.prototype.slice.call(arguments,1))}function P(t,e,i,s){var r=this,o="treegrid"===i.type;r.treeGrid||(r.treeGrid=new O(r)),o&&(l(e,"beforeRender",b),l(e,"beforeRedraw",b),l(e,"addSeries",function(t){if(t.options.data){var e=x(t.options.data,i.uniqueNames||!1,1);r.treeGrid.collapsedNodes=(r.treeGrid.collapsedNodes||[]).concat(e.collapsedNodes)}}),l(r,"foundExtremes",function(){r.treeGrid.collapsedNodes&&r.treeGrid.collapsedNodes.forEach(function(t){var e=r.treeGrid.collapse(t);r.brokenAxis&&(r.brokenAxis.setBreaks(e,!1),r.treeGrid.collapsedNodes&&(r.treeGrid.collapsedNodes=r.treeGrid.collapsedNodes.filter(function(e){return t.collapseStart!==e.collapseStart||t.collapseEnd!==e.collapseEnd})))})}),l(r,"afterBreaks",function(){"yAxis"===r.coll&&!r.staticScale&&r.chart.options.chart.height&&(r.isDirty=!0)}),i=u({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10}},uniqueNames:!1},i,{reversed:!0})),t.apply(r,[e,i,s]),o&&(r.hasNames=!0,r.options.showLastLabel=!0)}function A(t){var e,i=this.options,s="number"==typeof i.linkedTo?null===(e=this.chart[this.coll])||void 0===e?void 0:e[i.linkedTo]:void 0;if("treegrid"===i.type){if(this.min=v(this.userMin,i.min,this.dataMin),this.max=v(this.userMax,i.max,this.dataMax),h(this,"foundExtremes"),this.setAxisTranslation(),this.tickInterval=1,this.tickmarkOffset=.5,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[],s){var r=s.getExtremes();this.min=v(r.min,r.dataMin),this.max=v(r.max,r.dataMax),this.tickPositions=s.tickPositions}this.linkedParent=s}else t.apply(this,Array.prototype.slice.call(arguments,1))}function G(t){var e=this;"treegrid"===e.options.type&&e.visible&&e.tickPositions.forEach(function(t){var i=e.ticks[t];i.label&&i.label.attachedTreeGridEvents&&(g(i.label.element),i.label.attachedTreeGridEvents=!1)}),t.apply(e,Array.prototype.slice.call(arguments,1))}var O=function(){function r(t){this.axis=t}return r.compose=function(r,o,a,l){if(!r.keepProps.includes("treeGrid")){var d=r.prototype;r.keepProps.push("treeGrid"),m(d,"generateTick",y),m(d,"init",P),m(d,"setTickInterval",A),m(d,"redraw",G),d.utils={getNode:i.getNode},n||(n=l)}return e.compose(r,o,l),t.compose(r,a),s.compose(l),r},r.prototype.setCollapsedStatus=function(t){var e=this.axis,i=e.chart;e.series.forEach(function(e){var s=e.options.data;if(t.id&&s){var r=i.get(t.id),o=s[e.data.indexOf(r)];r&&o&&(r.collapsed=t.collapsed,o.collapsed=t.collapsed)}})},r.prototype.collapse=function(t){var e=this.axis,i=e.options.breaks||[],s=k(t,e.max);return i.push(s),t.collapsed=!0,e.treeGrid.setCollapsedStatus(t),i},r.prototype.expand=function(t){var e=this.axis,i=e.options.breaks||[],s=k(t,e.max);return t.collapsed=!1,e.treeGrid.setCollapsedStatus(t),i.reduce(function(t,e){return(e.to!==s.to||e.from!==s.from)&&t.push(e),t},[])},r.prototype.getTickPositions=function(){var t=this.axis,e=Math.floor(t.min/t.tickInterval)*t.tickInterval,i=Math.ceil(t.max/t.tickInterval)*t.tickInterval;return Object.keys(t.treeGrid.mapOfPosToGridNode||{}).reduce(function(s,r){var o=+r;return o>=e&&o<=i&&!(t.brokenAxis&&t.brokenAxis.isInAnyBreak(o))&&s.push(o),s},[])},r.prototype.isCollapsed=function(t){var e=this.axis,i=e.options.breaks||[],s=k(t,e.max);return i.some(function(t){return t.from===s.from&&t.to===s.to})},r.prototype.toggleCollapse=function(t){return this.isCollapsed(t)?this.expand(t):this.collapse(t)},r}();return O}),i(e,"masters/modules/treegrid.src.js",[e["Core/Globals.js"],e["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(t,e){return e.compose(t.Axis,t.Chart,t.Series,t.Tick),t})});