!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 * Treegraph chart series type
 *
 *  (c) 2010-2024 Pawel Lysy Grzegorz Blachlinski
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/treegraph",["highcharts","highcharts/modules/treemap"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(e,i,o,r){e.hasOwnProperty(i)||(e[i]=r.apply(null,o),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:e[i]}})))}i(e,"Series/PathUtilities.js",[],function(){function t(t,e){for(var i=[],o=0;o<t.length;o++){var r=t[o][1],n=t[o][2];if("number"==typeof r&&"number"==typeof n){if(0===o)i.push(["M",r,n]);else if(o===t.length-1)i.push(["L",r,n]);else if(e){var s=t[o-1],a=t[o+1];if(s&&a){var l=s[1],h=s[2],p=a[1],d=a[2];if("number"==typeof l&&"number"==typeof p&&"number"==typeof h&&"number"==typeof d&&l!==p&&h!==d){var c=l<p?1:-1,u=h<d?1:-1;i.push(["L",r-c*Math.min(Math.abs(r-l),e),n-u*Math.min(Math.abs(n-h),e)],["C",r,n,r,n,r+c*Math.min(Math.abs(r-p),e),n+u*Math.min(Math.abs(n-d),e)])}}}else i.push(["L",r,n])}}return i}return{applyRadius:t,getLinkPath:{default:function(e){var i=e.x1,o=e.y1,r=e.x2,n=e.y2,s=e.width,a=void 0===s?0:s,l=e.inverted,h=void 0!==l&&l,p=e.radius,d=e.parentVisible,c=[["M",i,o],["L",i,o],["C",i,o,i,n,i,n],["L",i,n],["C",i,o,i,n,i,n],["L",i,n]];return d?t([["M",i,o],["L",i+a*(h?-.5:.5),o],["L",i+a*(h?-.5:.5),n],["L",r,n]],p):c},straight:function(t){var e=t.x1,i=t.y1,o=t.x2,r=t.y2,n=t.width,s=t.inverted;return t.parentVisible?[["M",e,i],["L",e+(void 0===n?0:n)*(void 0!==s&&s?-1:1),r],["L",o,r]]:[["M",e,i],["L",e,r],["L",e,r]]},curved:function(t){var e=t.x1,i=t.y1,o=t.x2,r=t.y2,n=t.offset,s=void 0===n?0:n,a=t.width,l=void 0===a?0:a,h=t.inverted,p=void 0!==h&&h;return t.parentVisible?[["M",e,i],["C",e+s,i,e-s+l*(p?-1:1),r,e+l*(p?-1:1),r],["L",o,r]]:[["M",e,i],["C",e,i,e,r,e,r],["L",o,r]]}}}}),i(e,"Series/Treegraph/TreegraphNode.js",[e["Core/Series/SeriesRegistry.js"]],function(t){var e,i=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)});return function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.mod=0,e.shift=0,e.change=0,e.children=[],e.preX=0,e.hidden=!1,e.wasVisited=!1,e.collapsed=!1,e}return i(e,t),e.prototype.nextLeft=function(){return this.getLeftMostChild()||this.thread},e.prototype.nextRight=function(){return this.getRightMostChild()||this.thread},e.prototype.getAncestor=function(t,e){return t.ancestor.children[0]===this.children[0]?t.ancestor:e},e.prototype.getLeftMostSibling=function(){var t=this.getParent();if(t)for(var e=0,i=t.children;e<i.length;e++){var o=i[e];if(o&&o.point.visible)return o}},e.prototype.hasChildren=function(){for(var t=this.children,e=0;e<t.length;e++)if(t[e].point.visible)return!0;return!1},e.prototype.getLeftSibling=function(){var t=this.getParent();if(t){for(var e=t.children,i=this.relativeXPosition-1;i>=0;i--)if(e[i]&&e[i].point.visible)return e[i]}},e.prototype.getLeftMostChild=function(){for(var t=this.children,e=0;e<t.length;e++)if(t[e].point.visible)return t[e]},e.prototype.getRightMostChild=function(){for(var t=this.children,e=t.length-1;e>=0;e--)if(t[e].point.visible)return t[e]},e.prototype.getParent=function(){return this.parentNode},e.prototype.getFirstChild=function(){for(var t=this.children,e=0;e<t.length;e++)if(t[e].point.visible)return t[e]},e}(t.seriesTypes.treemap.prototype.NodeClass)}),i(e,"Series/Treegraph/TreegraphPoint.js",[e["Core/Series/Point.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),n=e.seriesTypes.treemap.prototype.pointClass,s=i.addEvent,a=i.fireEvent,l=i.merge,h=function(e){function i(){var i=null!==e&&e.apply(this,arguments)||this;return i.dataLabelOnHidden=!0,i.isLink=!1,i.setState=t.prototype.setState,i}return r(i,e),i.prototype.draw=function(){e.prototype.draw.apply(this,arguments);var t=this.graphic;t&&t.animate({visibility:this.visible?"inherit":"hidden"}),this.renderCollapseButton()},i.prototype.renderCollapseButton=function(){var t=this.series,e=this.graphic&&this.graphic.parentGroup,i=t.mapOptionsToLevel[this.node.level||0]||{},o=l(t.options.collapseButton,i.collapseButton,this.options.collapseButton),r=o.width,n=o.height,s=o.shape,a=o.style,h=this.series.chart,p=this.visible&&(this.collapsed||!o.onlyOnHover||"hover"===this.state)?1:0;if(this.shapeArgs){if(this.collapseButtonOptions=o,this.collapseButton){if(this.node.children.length&&o.enabled){var d=this.getCollapseBtnPosition(o),c=d.x,u=d.y;this.collapseButton.attr({text:this.collapsed?"+":"-",rotation:h.inverted?90:0,rotationOriginX:r/2,rotationOriginY:n/2,visibility:this.visible?"inherit":"hidden"}).animate({x:c,y:u,opacity:p})}else this.collapseButton.destroy(),delete this.collapseButton}else{if(!this.node.children.length||!o.enabled)return;var f=this.getCollapseBtnPosition(o),c=f.x,u=f.y,v=o.fillColor||this.color||"#cccccc";this.collapseButton=h.renderer.label(this.collapsed?"+":"-",c,u,s).attr({height:n-4,width:r-4,padding:2,fill:v,rotation:h.inverted?90:0,rotationOriginX:r/2,rotationOriginY:n/2,stroke:o.lineColor||"#ffffff","stroke-width":o.lineWidth,"text-align":"center",align:"center",zIndex:1,opacity:p,visibility:this.visible?"inherit":"hidden"}).addClass("highcharts-tracker").addClass("highcharts-collapse-button").removeClass("highcharts-no-tooltip").css(l({color:"string"==typeof v?h.renderer.getContrast(v):"#333333"},a)).add(e),this.collapseButton.element.point=this}}},i.prototype.toggleCollapse=function(t){var e=this.series;this.update({collapsed:null!=t?t:!this.collapsed},!1,void 0,!1),a(e,"toggleCollapse"),e.redraw()},i.prototype.destroy=function(){this.collapseButton&&(this.collapseButton.destroy(),delete this.collapseButton,this.collapseButton=void 0),this.linkToParent&&(this.linkToParent.destroy(),delete this.linkToParent),e.prototype.destroy.apply(this,arguments)},i.prototype.getCollapseBtnPosition=function(t){var e=this.series.chart.inverted,i=t.width,o=t.height,r=this.shapeArgs||{},n=r.x,s=r.y,a=r.width,l=r.height;return{x:(void 0===n?0:n)+t.x+(e?-(.3*o):(void 0===a?0:a)+-.3*i),y:(void 0===s?0:s)+(void 0===l?0:l)/2-o/2+t.y}},i}(n);return s(h,"mouseOut",function(){var t=this.collapseButton,e=this.collapseButtonOptions;t&&(null==e?void 0:e.onlyOnHover)&&!this.collapsed&&t.animate({opacity:0})}),s(h,"mouseOver",function(){var t,e;this.collapseButton&&this.visible&&this.collapseButton.animate({opacity:1},null===(e=null===(t=this.series.options.states)||void 0===t?void 0:t.hover)||void 0===e?void 0:e.animation)}),s(h,"click",function(){this.toggleCollapse()}),h}),i(e,"Series/Treegraph/TreegraphLink.js",[e["Core/Series/Point.js"],e["Core/Utilities.js"],e["Core/Series/SeriesRegistry.js"]],function(t,e,i){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),n=e.pick,s=e.extend;return function(e){function i(t,i,o,r){var n=e.call(this,t,i,o)||this;return n.dataLabelOnNull=!0,n.formatPrefix="link",n.isLink=!0,n.node={},n.formatPrefix="link",n.dataLabelOnNull=!0,r&&(n.fromNode=r.node.parentNode.point,n.visible=r.visible,n.toNode=r,n.id=n.toNode.id+"-"+n.fromNode.id),n}return r(i,e),i.prototype.update=function(e,i,o,r){var a={id:this.id,formatPrefix:this.formatPrefix};t.prototype.update.call(this,e,!this.isLink&&i,o,r),this.visible=this.toNode.visible,s(this,a),n(i,!0)&&this.series.chart.redraw(o)},i}(i.seriesTypes.column.prototype.pointClass)}),i(e,"Series/Treegraph/TreegraphLayout.js",[e["Series/Treegraph/TreegraphNode.js"]],function(t){return function(){function e(){}return e.createDummyNode=function(e,i,o){var r=new t;return r.id=e.id+"-"+o,r.ancestor=e,r.children.push(i),r.parent=e.id,r.parentNode=e,r.point=i.point,r.level=i.level-o,r.relativeXPosition=i.relativeXPosition,r.visible=i.visible,e.children[i.relativeXPosition]=r,i.oldParentNode=e,i.relativeXPosition=0,i.parentNode=r,i.parent=r.id,r},e.prototype.calculatePositions=function(t){var e=t.nodeList;this.resetValues(e);var i=t.tree;i&&(this.calculateRelativeX(i,0),this.beforeLayout(e),this.firstWalk(i),this.secondWalk(i,-i.preX),this.afterLayout(e))},e.prototype.beforeLayout=function(t){for(var i=0;i<t.length;i++)for(var o=t[i],r=0,n=o.children;r<n.length;r++){var s=n[r];if(s&&s.level-o.level>1)for(var a=s.level-o.level-1;a>0;)s=e.createDummyNode(o,s,a),a--}},e.prototype.resetValues=function(t){for(var e=0;e<t.length;e++){var i=t[e];i.mod=0,i.ancestor=i,i.shift=0,i.thread=void 0,i.change=0,i.preX=0}},e.prototype.calculateRelativeX=function(t,e){for(var i=t.children,o=0,r=i.length;o<r;++o)this.calculateRelativeX(i[o],o);t.relativeXPosition=e},e.prototype.firstWalk=function(t){var e;if(t.hasChildren()){for(var i=t.getLeftMostChild(),o=0,r=t.children;o<r.length;o++){var n=r[o];this.firstWalk(n),i=this.apportion(n,i)}this.executeShifts(t);var s=t.getLeftMostChild(),a=t.getRightMostChild(),l=(s.preX+a.preX)/2;(e=t.getLeftSibling())?(t.preX=e.preX+1,t.mod=t.preX-l):t.preX=l}else(e=t.getLeftSibling())?(t.preX=e.preX+1,t.mod=t.preX):t.preX=0},e.prototype.secondWalk=function(t,e){t.yPosition=t.preX+e,t.xPosition=t.level;for(var i=0,o=t.children;i<o.length;i++){var r=o[i];this.secondWalk(r,e+t.mod)}},e.prototype.executeShifts=function(t){for(var e=0,i=0,o=t.children.length-1;o>=0;o--){var r=t.children[o];r.preX+=e,r.mod+=e,i+=r.change,e+=r.shift+i}},e.prototype.apportion=function(t,e){var i=t.getLeftSibling();if(i){for(var o=t,r=t,n=i,s=o.getLeftMostSibling(),a=o.mod,l=r.mod,h=n.mod,p=s.mod;n&&n.nextRight()&&o&&o.nextLeft();){n=n.nextRight(),s=s.nextLeft(),o=o.nextLeft(),(r=r.nextRight()).ancestor=t;var d=n.preX+h-(o.preX+a)+1;d>0&&(this.moveSubtree(t.getAncestor(n,e),t,d),a+=d,l+=d),h+=n.mod,a+=o.mod,p+=s.mod,l+=r.mod}n&&n.nextRight()&&!r.nextRight()&&(r.thread=n.nextRight(),r.mod+=h-l),o&&o.nextLeft()&&!s.nextLeft()&&(s.thread=o.nextLeft(),s.mod+=a-p),e=t}return e},e.prototype.moveSubtree=function(t,e,i){var o=e.relativeXPosition-t.relativeXPosition;e.change-=i/o,e.shift+=i,e.preX+=i,e.mod+=i,t.change+=i/o},e.prototype.afterLayout=function(t){for(var e=0;e<t.length;e++){var i=t[e];i.oldParentNode&&(i.relativeXPosition=i.parentNode.relativeXPosition,i.parent=i.oldParentNode.parent,i.parentNode=i.oldParentNode,delete i.oldParentNode.children[i.relativeXPosition],i.oldParentNode.children[i.relativeXPosition]=i,i.oldParentNode=void 0)}},e}()}),i(e,"Series/Treegraph/TreegraphSeriesDefaults.js",[],function(){return{reversed:!1,marker:{radius:10,lineWidth:0,symbol:"circle",fillOpacity:1,states:{}},link:{color:"#666666",lineWidth:1,radius:10,cursor:"default",type:"curved"},collapseButton:{onlyOnHover:!0,enabled:!0,lineWidth:1,x:0,y:0,height:18,width:18,shape:"circle",style:{cursor:"pointer",fontWeight:"bold",fontSize:"1em"}},fillSpace:!1,tooltip:{linkFormat:"{point.fromNode.id} → {point.toNode.id}",pointFormat:"{point.id}"},dataLabels:{defer:!0,linkTextPath:{attributes:{startOffset:"50%"}},enabled:!0,linkFormatter:function(){return""},style:{textOverflow:"none"}},nodeDistance:30,nodeWidth:void 0}}),i(e,"Extensions/TextPath.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.deg2rad,o=e.addEvent,r=e.merge,n=e.uniqueKey,s=e.defined,a=e.extend;function l(t,e){var i=this;e=r(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},e);var l=this.renderer.url,h=this.text||this,p=h.textPath,d=e.attributes,c=e.enabled;if(t=t||p&&p.path,p&&p.undo(),t&&c){var u=o(h,"afterModifyTree",function(e){if(t&&c){var o=t.attr("id");o||t.attr("id",o=n());var r={x:0,y:0};s(d.dx)&&(r.dx=d.dx,delete d.dx),s(d.dy)&&(r.dy=d.dy,delete d.dy),h.attr(r),i.attr({transform:""}),i.box&&(i.box=i.box.destroy());var p=e.nodes.slice(0);e.nodes.length=0,e.nodes[0]={tagName:"textPath",attributes:a(d,{"text-anchor":d.textAnchor,href:"".concat(l,"#").concat(o)}),children:p}}});h.textPath={path:t,undo:u}}else h.attr({dx:0,dy:0}),delete h.textPath;return this.added&&(h.textCache="",this.renderer.buildText(h)),this}function h(t){var e,o=t.bBox,r=null===(e=this.element)||void 0===e?void 0:e.querySelector("textPath");if(r){for(var n=[],s=this.renderer.fontMetrics(this.element),a=s.b,l=s.h-a,h=RegExp('(<tspan>|<tspan(?!\\sclass="highcharts-br")[^>]*>|<\\/tspan>)',"g"),p=r.innerHTML.replace(h,"").split(/<tspan class="highcharts-br"[^>]*>/),d=p.length,c=function(t,e){var o=e.x,n=e.y,s=(r.getRotationOfChar(t)-90)*i,h=Math.cos(s),p=Math.sin(s);return[[o-l*h,n-l*p],[o+a*h,n+a*p]]},u=0,f=0;f<d;f++){for(var v=p[f].length,y=0;y<v;y+=5)try{var g=u+y+f,b=c(g,r.getStartPositionOfChar(g)),m=b[0],x=b[1];0===y?(n.push(x),n.push(m)):(0===f&&n.unshift(x),f===d-1&&n.push(m))}catch(t){break}u+=v-1;try{var g=u+f,P=r.getEndPositionOfChar(g),k=c(g,P),m=k[0],x=k[1];n.unshift(x),n.unshift(m)}catch(t){break}}n.length&&n.push(n[0].slice()),o.polygon=n}return o}function p(t){var e,i=t.labelOptions,o=t.point,r=i[o.formatPrefix+"TextPath"]||i.textPath;r&&!i.useHTML&&(this.setTextPath((null===(e=o.getDataLabelPath)||void 0===e?void 0:e.call(o,this))||o.graphic,r),o.dataLabelPath&&!r.enabled&&(o.dataLabelPath=o.dataLabelPath.destroy()))}return{compose:function(t){o(t,"afterGetBBox",h),o(t,"beforeAddingDataLabel",p);var e=t.prototype;e.setTextPath||(e.setTextPath=l)}}}),i(e,"Series/Treegraph/TreegraphSeries.js",[e["Series/PathUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Series/Treegraph/TreegraphNode.js"],e["Series/Treegraph/TreegraphPoint.js"],e["Series/TreeUtilities.js"],e["Core/Utilities.js"],e["Series/Treegraph/TreegraphLink.js"],e["Series/Treegraph/TreegraphLayout.js"],e["Series/Treegraph/TreegraphSeriesDefaults.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Extensions/TextPath.js"]],function(t,e,i,o,r,n,s,a,l,h,p,d){var c,u=this&&this.__extends||(c=function(t,e){return(c=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}c(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),f=t.getLinkPath,v=e.series.prototype,y=e.seriesTypes,g=y.treemap,b=y.column,m=i.prototype.symbols,x=n.getLevelOptions,P=n.getNodeWidth,k=s.arrayMax,L=s.crisp,T=s.extend,C=s.merge,S=s.pick,w=s.relativeLength,O=s.splat;d.compose(p);var j=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.nodeList=[],e.links=[],e}return u(e,t),e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.layoutAlgorythm=new l;var e=this,i=this.chart.labelCollectors;i.some(function(t){return"collectorFunc"===t.name})||i.push(function(){var t=[];if(!O(e.options.dataLabels)[0].allowOverlap)for(var i=0,o=e.links;i<o.length;i++){var r=o[i];r.dataLabel&&t.push(r.dataLabel)}return t})},e.prototype.getLayoutModifiers=function(){var t=this,e=this.chart,i=this,o=e.plotSizeX,r=e.plotSizeY,n=k(this.points.map(function(t){return t.node.xPosition})),s=1/0,a=-1/0,l=1/0,h=-1/0,p=0,d=0,c=0,u=0;this.points.forEach(function(e){if(!t.options.fillSpace||e.visible){var f,v=e.node,y=i.mapOptionsToLevel[e.node.level]||{},g=C(t.options.marker,y.marker,e.options.marker),b=null!==(f=g.width)&&void 0!==f?f:P(t,n),m=w(g.radius||0,Math.min(o,r)),x=g.symbol,k="circle"!==x&&g.height?w(g.height,r):2*m,L="circle"!==x&&b?w(b,o):2*m;v.nodeSizeX=L,v.nodeSizeY=k,v.xPosition<=s&&(s=v.xPosition,d=Math.max(L+(g.lineWidth||0),d)),v.xPosition>=a&&(a=v.xPosition,p=Math.max(L+(g.lineWidth||0),p)),v.yPosition<=l&&(l=v.yPosition,u=Math.max(k+(g.lineWidth||0),u)),v.yPosition>=h&&(h=v.yPosition,c=Math.max(k+(g.lineWidth||0),c))}});var f=h===l?1:(r-(u+c)/2)/(h-l),v=h===l?r/2:-f*l+u/2,y=a===s?1:(o-(p+p)/2)/(a-s),g=a===s?o/2:-y*s+d/2;return{ax:y,bx:g,ay:f,by:v}},e.prototype.getLinks=function(){var t=this,e=this,i=[];return this.data.forEach(function(o){var r=e.mapOptionsToLevel[o.node.level||0]||{};if(o.node.parent){var n=C(r,o.options);if(!o.linkToParent||o.linkToParent.destroyed){var s=new e.LinkClass(e,n,void 0,o);o.linkToParent=s}else o.collapsed=S(o.collapsed,(t.mapOptionsToLevel[o.node.level]||{}).collapsed),o.linkToParent.visible=o.linkToParent.toNode.visible;o.linkToParent.index=i.push(o.linkToParent)-1}else o.linkToParent&&(e.links.splice(o.linkToParent.index),o.linkToParent.destroy(),delete o.linkToParent)}),i},e.prototype.buildTree=function(e,i,o,r,n){var s=this.points[i];return o=s&&s.level||o,t.prototype.buildTree.call(this,e,i,o,r,n)},e.prototype.markerAttribs=function(){return{}},e.prototype.setCollapsedStatus=function(t,e){var i=this,o=t.point;o&&(o.collapsed=S(o.collapsed,(this.mapOptionsToLevel[t.level]||{}).collapsed),o.visible=e,e=!1!==e&&!o.collapsed),t.children.forEach(function(t){i.setCollapsedStatus(t,e)})},e.prototype.drawTracker=function(){b.prototype.drawTracker.apply(this,arguments),b.prototype.drawTracker.call(this,this.links)},e.prototype.translate=function(){var t,e=this,i=this.options,o=n.updateRootId(this);v.translate.call(this);var r=this.tree=this.getTree();t=this.nodeMap[o],""===o||t&&t.children.length||(this.setRootNode("",!1),o=this.rootNode,t=this.nodeMap[o]),this.mapOptionsToLevel=x({from:t.level+1,levels:i.levels,to:r.height,defaults:{levelIsConstant:this.options.levelIsConstant,colorByPoint:i.colorByPoint}}),this.setCollapsedStatus(r,!0),this.links=this.getLinks(),this.setTreeValues(r),this.layoutAlgorythm.calculatePositions(this),this.layoutModifier=this.getLayoutModifiers(),this.points.forEach(function(t){e.translateNode(t)}),this.points.forEach(function(t){t.linkToParent&&e.translateLink(t.linkToParent)}),i.colorByPoint||this.setColorRecursive(this.tree)},e.prototype.translateLink=function(t){var e,i,o,r,n,s=t.fromNode,a=t.toNode,l=(null===(e=this.options.link)||void 0===e?void 0:e.lineWidth)||0,h=S(null===(i=this.options.link)||void 0===i?void 0:i.curveFactor,.5),p=S(null===(o=t.options.link)||void 0===o?void 0:o.type,null===(r=this.options.link)||void 0===r?void 0:r.type,"default");if(s.shapeArgs&&a.shapeArgs){var d=s.shapeArgs.width||0,c=this.chart.inverted,u=L((s.shapeArgs.y||0)+(s.shapeArgs.height||0)/2,l),v=L((a.shapeArgs.y||0)+(a.shapeArgs.height||0)/2,l),y=L((s.shapeArgs.x||0)+d,l),g=L(a.shapeArgs.x||0,l);c&&(y-=d,g+=a.shapeArgs.width||0);var b=a.node.xPosition-s.node.xPosition;t.shapeType="path";var m=(Math.abs(g-y)+d)/b-d,x=L((g+y)/2,l);t.plotX=x,t.plotY=v,t.shapeArgs={d:f[p]({x1:y,y1:u,x2:g,y2:v,width:m,offset:m*h*(c?-1:1),inverted:c,parentVisible:a.visible,radius:null===(n=this.options.link)||void 0===n?void 0:n.radius})},t.dlBox={x:(y+g)/2,y:(u+v)/2,height:l,width:0},t.tooltipPos=c?[(this.chart.plotSizeY||0)-t.dlBox.y,(this.chart.plotSizeX||0)-t.dlBox.x]:[t.dlBox.x,t.dlBox.y]}},e.prototype.drawNodeLabels=function(t){for(var e,i,o=this.mapOptionsToLevel,r=0;r<t.length;r++){var n=t[r];i=o[n.node.level],e={style:{}},i&&i.dataLabels&&(e=C(e,i.dataLabels),this.hasDataLabels=function(){return!0}),n.shapeArgs&&!O(this.options.dataLabels)[0].style.width&&(e.style.width=n.shapeArgs.width,n.dataLabel&&n.dataLabel.css({width:n.shapeArgs.width+"px"})),n.dlOptions=C(e,n.options.dataLabels)}v.drawDataLabels.call(this,t)},e.prototype.alignDataLabel=function(e,i){var o=e.visible;e.visible=!0,t.prototype.alignDataLabel.apply(this,arguments),i.animate({opacity:!1===o?0:1},void 0,function(){o||i.hide()}),e.visible=o},e.prototype.drawDataLabels=function(){this.options.dataLabels&&(this.options.dataLabels=O(this.options.dataLabels),this.drawNodeLabels(this.points),v.drawDataLabels.call(this,this.links))},e.prototype.destroy=function(){if(this.links){for(var t=0,e=this.links;t<e.length;t++)e[t].destroy();this.links.length=0}return v.destroy.apply(this,arguments)},e.prototype.pointAttribs=function(t,e){var i=t&&this.mapOptionsToLevel[t.node.level||0]||{},o=t&&t.options,r=i.states&&i.states[e]||{};t&&(t.options.marker=C(this.options.marker,i.marker,t.options.marker));var n=S(r&&r.link&&r.link.color,o&&o.link&&o.link.color,i&&i.link&&i.link.color,this.options.link&&this.options.link.color),s=S(r&&r.link&&r.link.lineWidth,o&&o.link&&o.link.lineWidth,i&&i.link&&i.link.lineWidth,this.options.link&&this.options.link.lineWidth),a=v.pointAttribs.call(this,t,e);return t&&(t.isLink&&(a.stroke=n,a["stroke-width"]=s,delete a.fill),t.visible||(a.opacity=0)),a},e.prototype.drawPoints=function(){g.prototype.drawPoints.apply(this,arguments),b.prototype.drawPoints.call(this,this.links)},e.prototype.translateNode=function(t){var e=this.chart,i=t.node,o=e.plotSizeY,r=e.plotSizeX,n=this.layoutModifier,s=n.ax,a=n.bx,l=n.ay,h=n.by,p=s*i.xPosition+a,d=l*i.yPosition+h,c=this.mapOptionsToLevel[i.level]||{},u=C(this.options.marker,c.marker,t.options.marker).symbol,f=i.nodeSizeY,v=i.nodeSizeX,y=this.options.reversed,g=i.x=e.inverted?r-v/2-p:p-v/2,b=i.y=y?d-f/2:o-d-f/2,x=S(t.options.borderRadius,c.borderRadius,this.options.borderRadius),P=m[u||"circle"];if(void 0===P?(t.hasImage=!0,t.shapeType="image",t.imageUrl=u.match(/^url\((.*?)\)$/)[1]):t.shapeType="path",!t.visible&&t.linkToParent){var k=t.linkToParent.fromNode;if(k){var L=k.shapeArgs||{},w=L.x,O=void 0===w?0:w,j=L.y,M=void 0===j?0:j,X=L.width,N=L.height;t.shapeArgs||(t.shapeArgs={}),t.hasImage||T(t.shapeArgs,{d:P(O,M,void 0===X?0:X,void 0===N?0:N,x?{r:x}:void 0)}),T(t.shapeArgs,{x:O,y:M}),t.plotX=k.plotX,t.plotY=k.plotY}}else t.plotX=g,t.plotY=b,t.shapeArgs={x:g,y:b,width:v,height:f,cursor:t.node.isLeaf?"default":"pointer"},t.hasImage||(t.shapeArgs.d=P(g,b,v,f,x?{r:x}:void 0));t.tooltipPos=e.inverted?[o-b-f/2,r-g-v/2]:[g+v/2,b]},e.defaultOptions=C(g.defaultOptions,h),e}(g);return T(j.prototype,{pointClass:r,NodeClass:o,LinkClass:a}),e.registerSeriesType("treegraph",j),j}),i(e,"masters/modules/treegraph.src.js",[e["Core/Globals.js"]],function(t){return t})});