!/**
 * Highstock JS v11.4.6 (2024-07-08)
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(i,e,o,r){i.hasOwnProperty(e)||(i[e]=r.apply(null,o),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:i[e]}})))}e(i,"Series/DataModifyComposition.js",[i["Core/Axis/Axis.js"],i["Core/Series/Point.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=i.prototype.tooltipFormatter,n=o.addEvent,a=o.arrayMax,l=o.arrayMin,h=o.correctFloat,p=o.defined,d=o.isArray,u=o.isNumber,c=o.isString,f=o.pick;return function(t){function i(t,i,e){!this.isXAxis&&(this.series.forEach(function(e){"compare"===t&&"boolean"!=typeof i?e.setCompare(i,!1):"cumulative"!==t||c(i)||e.setCumulative(i,!1)}),f(e,!0)&&this.chart.redraw())}function e(t){var i=this,e=i.series.chart.numberFormatter,o=function(o){t=t.replace("{point."+o+"}",(i[o]>0&&"change"===o?"+":"")+e(i[o],f(i.series.tooltipOptions.changeDecimals,2)))};return p(i.change)&&o("change"),p(i.cumulativeSum)&&o("cumulativeSum"),s.apply(this,[t])}function o(){var t,i=this.options.compare;("percent"===i||"value"===i||this.options.cumulative)&&(t=new b(this),"percent"===i||"value"===i?t.initCompare(i):t.initCumulative()),this.dataModify=t}function r(t){var i=t.dataExtremes,e=i.activeYData;if(this.dataModify&&i){var o=void 0;this.options.compare?o=[this.dataModify.modifyValue(i.dataMin),this.dataModify.modifyValue(i.dataMax)]:this.options.cumulative&&d(e)&&e.length>=2&&(o=b.getCumulativeExtremes(e)),o&&(i.dataMin=l(o),i.dataMax=a(o))}}function g(t,i){this.options.compare=this.userOptions.compare=t,this.update({},f(i,!0)),this.dataModify&&("value"===t||"percent"===t)?this.dataModify.initCompare(t):this.points.forEach(function(t){delete t.change})}function v(){if(this.xAxis&&this.processedYData&&this.dataModify){var t=this.processedXData,i=this.processedYData,e=i.length,o=!0===this.options.compareStart?0:1,r=-1,s=void 0;for(this.pointArrayMap&&(r=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y")),s=0;s<e-o;s++){var n=i[s]&&r>-1?i[s][r]:i[s];if(u(n)&&0!==n&&t[s+o]>=(this.xAxis.min||0)){this.dataModify.compareValue=n;break}}}}function x(t,i){this.setModifier("compare",t,i)}function m(t,i){t=f(t,!1),this.options.cumulative=this.userOptions.cumulative=t,this.update({},f(i,!0)),this.dataModify?this.dataModify.initCumulative():this.points.forEach(function(t){delete t.cumulativeSum})}function y(t,i){this.setModifier("cumulative",t,i)}t.compose=function(t,s,a){var l=s.prototype,h=a.prototype,p=t.prototype;return p.setCompare||(p.setCompare=g,p.setCumulative=m,n(t,"afterInit",o),n(t,"afterGetExtremes",r),n(t,"afterProcessData",v)),l.setCompare||(l.setCompare=x,l.setModifier=i,l.setCumulative=y,h.tooltipFormatter=e),t};var b=function(){function t(t){this.series=t}return t.prototype.modifyValue=function(){return 0},t.getCumulativeExtremes=function(t){var i=1/0,e=-1/0;return t.reduce(function(t,o){var r=t+o;return i=Math.min(i,r,t),e=Math.max(e,r,t),r}),[i,e]},t.prototype.initCompare=function(t){this.modifyValue=function(i,e){null===i&&(i=0);var o=this.compareValue;if(void 0!==i&&void 0!==o){if("value"===t?i-=o:i=i/o*100-(100===this.series.options.compareBase?0:100),void 0!==e){var r=this.series.points[e];r&&(r.change=i)}return i}return 0}},t.prototype.initCumulative=function(){this.modifyValue=function(t,i){if(null===t&&(t=0),void 0!==t&&void 0!==i){var e=i>0?this.series.points[i-1]:null;e&&e.cumulativeSum&&(t=h(e.cumulativeSum+t));var o=this.series.points[i],r=o.series.options.cumulativeStart,s=o.x<=this.series.xAxis.max&&o.x>=this.series.xAxis.min;return o&&(!r||s?o.cumulativeSum=t:o.cumulativeSum=void 0),t}return 0}},t}();t.Additions=b}(r||(r={})),r}),e(i,"Stock/Navigator/ChartNavigatorComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.isTouchDevice,r=i.addEvent,s=i.merge,n=i.pick,a=[];function l(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function h(){var t,i,e,o,r=this.legend,s=this.navigator;if(s){i=r&&r.options,e=s.xAxis,o=s.yAxis;var a=s.scrollbarHeight,l=s.scrollButtonSize;this.inverted?(s.left=s.opposite?this.chartWidth-a-s.height:this.spacing[3]+a,s.top=this.plotTop+l):(s.left=n(e.left,this.plotLeft+l),s.top=s.navigatorOptions.top||this.chartHeight-s.height-a-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?r.legendHeight+n(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&o&&(this.inverted?e.options.left=o.options.left=s.left:e.options.top=o.options.top=s.top,e.setAxisSize(),o.setAxisSize())}}function p(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this),n(t.redraw,!0)&&this.redraw(t.animation))}function d(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this))}function u(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!o&&"x"===this.zooming.type||o&&"x"===this.zooming.pinchType))return!1}function c(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function f(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(s(!0,this.options.navigator,i),s(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,o){if(i.pushUnique(a,t)){var s=t.prototype;e=o,s.callbacks.push(c),r(t,"afterAddSeries",l),r(t,"afterSetChartSize",h),r(t,"afterUpdate",p),r(t,"beforeRender",d),r(t,"beforeShowResetZoom",u),r(t,"update",f)}}}}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,o=i.addEvent,r=i.correctFloat,s=i.defined,n=i.isNumber,a=i.pick;function l(){this.navigatorAxis||(this.navigatorAxis=new p(this))}function h(t){var i,o=this.chart,r=o.options,n=r.navigator,a=this.navigatorAxis,l=o.zooming.pinchType,h=r.rangeSelector,p=o.zooming.type;if(this.isXAxis&&((null==n?void 0:n.enabled)||(null==h?void 0:h.enabled))){if("y"===p&&"zoom"===t.trigger)i=!1;else if(("zoom"===t.trigger&&"xy"===p||e&&"xy"===l)&&this.options.range){var d=a.previousZoom;s(t.min)?a.previousZoom=[this.min,this.max]:d&&(t.min=d[0],t.max=d[1],a.previousZoom=void 0)}}void 0!==i&&t.preventDefault()}var p=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),o(t,"init",l),o(t,"setExtremes",h))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,o){var l=this.axis,h=(l.pointRange||0)/2,p=a(e,l.translate(t,!0,!l.horiz)),d=a(o,l.translate(i,!0,!l.horiz));return s(e)||(p=r(p+h)),s(o)||(d=r(d-h)),n(p)&&n(d)||(p=d=void 0),{min:p,max:d}},t}();return p}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,o=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,borderRadius:0,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===o.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",id:"navigator-x-axis",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,id:"navigator-y-axis",maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[i["Core/Renderer/SVG/Symbols.js"],i["Core/Utilities.js"]],function(t,i){var e=this&&this.__spreadArray||function(t,i,e){if(e||2==arguments.length)for(var o,r=0,s=i.length;r<s;r++)!o&&r in i||(o||(o=Array.prototype.slice.call(i,0,r)),o[r]=i[r]);return t.concat(o||Array.prototype.slice.call(i))},o=i.relativeLength;return{"navigator-handle":function(i,r,s,n,a){void 0===a&&(a={});var l=a.width?a.width/2:s,h=o(a.borderRadius||0,Math.min(2*l,n));return e([["M",-1.5,(n=a.height||n)/2-3.5],["L",-1.5,n/2+4.5],["M",.5,n/2-3.5],["L",.5,n/2+4.5]],t.rect(-l-1,.5,2*l+1,n,{r:h}),!0)}}}),e(i,"Stock/Utilities/StockUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined;return{setFixedRange:function(t){var e=this.xAxis[0];i(e.dataMax)&&i(e.dataMin)&&t?this.fixedRange=Math.min(t,e.dataMax-e.dataMin):this.fixedRange=t}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a){var l=t.setOptions,h=i.composed,p=s.getRendererType,d=n.setFixedRange,u=a.addEvent,c=a.extend,f=a.pushUnique;function g(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,s){e.compose(i),f(h,"Navigator")&&(t.prototype.setFixedRange=d,c(p().prototype.symbols,r),u(s,"afterUpdate",g),l({navigator:o}))}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.composed,r=i.addEvent,s=i.defined,n=i.pick,a=i.pushUnique;return function(t){var i;function e(t){var i=n(t.options&&t.options.min,t.min),e=n(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:s(t.dataMin)?Math.min(i,t.min,t.dataMin,n(t.threshold,1/0)):i,scrollMax:s(t.dataMax)?Math.max(e,t.max,t.dataMax,n(t.threshold,-1/0)):e}}function l(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function h(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),r(t.scrollbar,"changed",function(i){var o,r,n=e(t),a=n.axisMin,l=n.axisMax,h=n.scrollMin,p=n.scrollMax-h;if(s(a)&&s(l)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(o=h+p*this.to,r=h+p*this.from):(o=h+p*(1-this.from),r=h+p*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var d="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(r,o,!0,d,i)}else this.setRange(this.from,this.to)}}))}function p(){var t,i,o,r=e(this),n=r.scrollMin,a=r.scrollMax,l=this.scrollbar,h=this.axisTitleMargin+(this.titleOffset||0),p=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(l&&p){if(this.horiz)this.opposite||(p[1]+=h),l.position(this.left,this.top+this.height+2+p[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(p[1]+=d),t=1;else{this.opposite&&(p[0]+=h);var u=void 0;u=l.options.opposite?this.left+this.width+2+p[0]-(this.opposite?0:d):this.opposite?0:d,l.position(u,this.top,this.width,this.height),this.opposite&&(p[0]+=d),t=0}p[t]+=l.size+(l.options.margin||0),isNaN(n)||isNaN(a)||!s(this.min)||!s(this.max)||this.min===this.max?l.setRange(0,1):(i=(this.min-n)/(a-n),o=(this.max-n)/(a-n),this.horiz&&!this.reversed||!this.horiz&&this.reversed?l.setRange(i,o):l.setRange(1-o,1-i))}}t.compose=function(t,e){a(o,"Axis.Scrollbar")&&(i=e,r(t,"afterGetOffset",l),r(t,"afterInit",h),r(t,"afterRender",p))}}(e||(e={})),e}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s=t.defaultOptions,n=r.addEvent,a=r.correctFloat,l=r.crisp,h=r.defined,p=r.destroyObjectProperties,d=r.fireEvent,u=r.merge,c=r.pick,f=r.removeEvent,g=function(){function t(t,i,e){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,o=0;o<e;o+=2)"number"==typeof(i=t[o+1])&&(t[o+1]=t[o+2],t[o+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,e=this.scrollbarGroup.element,o=this.track.element,r=this.mouseDownHandler.bind(this),s=this.mouseMoveHandler.bind(this),a=this.mouseUpHandler.bind(this),l=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[e,"mousedown",r],[e.ownerDocument,"mousemove",s],[e.ownerDocument,"mouseup",a],[e,"touchstart",r],[e.ownerDocument,"touchmove",s],[e.ownerDocument,"touchend",a]];l.forEach(function(t){n.apply(null,t)}),this._events=l},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*c(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=a(this.to-this.from)*c(this.options.step,.2);this.updatePosition(a(this.from-i),a(this.to-i)),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,p(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,o=this.scrollbarButtons,r=this.options,s=this.size,n=e.g().add(this.group);if(o.push(n),r.buttonsEnabled){var a=e.rect().addClass("highcharts-scrollbar-button").add(n);this.chart.styledMode||a.attr({stroke:r.buttonBorderColor,"stroke-width":r.buttonBorderWidth,fill:r.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:s,height:s,r:r.buttonBorderRadius},a.strokeWidth()));var l=e.path(t.swapXY([["M",s/2+(i?-1:1),s/2-3],["L",s/2+(i?-1:1),s/2+3],["L",s/2+(i?2:-2),s/2]],r.vertical)).addClass("highcharts-scrollbar-arrow").add(o[i]);this.chart.styledMode||l.attr({fill:r.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=u(o,s.scrollbar,i),this.options.margin=c(this.options.margin,10),this.chart=e,this.size=c(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.cursorToScrollbarPosition(e);this.chartX=o.chartX,this.chartY=o.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e,o=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,r=this.options.vertical?"chartY":"chartX",s=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][r])&&(e=this.cursorToScrollbarPosition(o)[r]-this[r],this.hasDragged=!0,this.updatePosition(s[0]+e,s[1]+e),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,o){var r=this.options,s=r.buttonsEnabled,n=r.margin,a=void 0===n?0:n,l=r.vertical,h=this.rendered?"animate":"attr",p=o,d=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=o,this.xOffset=p,this.yOffset=d,l?(this.width=this.yOffset=e=d=this.size,this.xOffset=p=0,this.yOffset=d=s?this.size:0,this.barWidth=o-(s?2*e:0),this.x=t+=a):(this.height=o=this.size,this.xOffset=p=s?this.size:0,this.barWidth=e-(s?2*o:0),this.y=this.y+a),this.group[h]({translateX:t,translateY:this.y}),this.track[h]({width:e,height:o}),this.scrollbarButtons[1][h]({translateX:l?0:e-p,translateY:l?o-d:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){f.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,o=this.size,r=this.chart.styledMode,s=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=s,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:o,width:o}).add(s),r||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var n=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-l(0,n),y:-l(0,n)}),this.scrollbarGroup=i.g().add(s),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:o-n,width:o-n,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),r||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-l(0,this.scrollbarStrokeWidth),-l(0,this.scrollbarStrokeWidth)),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,o,r=this.options,s=r.vertical,n=r.minWidth,l=this.barWidth,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(h(l)){var d=l*Math.min(i,1);e=Math.ceil(l*(t=Math.max(t,0))),this.calculatedWidth=o=a(d-e),o<n&&(e=(l-n+o)*t,o=n);var u=Math.floor(e+this.xOffset+this.yOffset),c=o/2-.5;this.from=t,this.to=i,s?(this.scrollbarGroup[p]({translateY:u}),this.scrollbar[p]({height:o}),this.scrollbarRifles[p]({translateY:c}),this.scrollbarTop=u,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:u}),this.scrollbar[p]({width:o}),this.scrollbarRifles[p]({translateX:c}),this.scrollbarLeft=u,this.scrollbarTop=0),o<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===r.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return c(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!h(t)},t.prototype.trackClick=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.to-this.from,r=this.y+this.scrollbarTop,s=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>r||!this.options.vertical&&e.chartX>s?this.updatePosition(this.from+o,this.to+o):this.updatePosition(this.from-o,this.to-o),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,u(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=a(1-a(i-t)),i=1),t<0&&(i=a(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=o,t}();return s.scrollbar=u(!0,g.defaultOptions,s.scrollbar),g}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Stock/Navigator/ChartNavigatorComposition.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Renderer/SVG/SVGRenderer.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a,l){var h=this&&this.__assign||function(){return(h=Object.assign||function(t){for(var i,e=1,o=arguments.length;e<o;e++)for(var r in i=arguments[e])Object.prototype.hasOwnProperty.call(i,r)&&(t[r]=i[r]);return t}).apply(this,arguments)},p=e.defaultOptions,d=o.isTouchDevice,u=a.prototype.symbols,c=l.addEvent,f=l.clamp,g=l.correctFloat,v=l.defined,x=l.destroyObjectProperties,m=l.erase,y=l.extend,b=l.find,M=l.fireEvent,S=l.isArray,A=l.isNumber,k=l.merge,C=l.pick,w=l.removeEvent,D=l.splat;function O(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var o=[].filter.call(i,A);if(o.length)return Math[t].apply(0,o)}return function(){function e(t){this.isDirty=!1,this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,o,r){i.compose(t,e),s.compose(t,o,r)},e.prototype.drawHandle=function(t,i,e,o){var r=this.navigatorOptions.handles.height;this.handles[i][o](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-r)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-r/2-1)})},e.prototype.drawOutline=function(t,i,e,o){var r,s,n=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),l=a/2,h=a%2/2,p=this.scrollButtonSize,d=this.size,u=this.top,c=this.height,f=u-l,g=u+c,v=this.left;e?(r=u+i+h,i=u+t+h,s=[["M",v+c,u-p-h],["L",v+c,r],["L",v,r],["M",v,i],["L",v+c,i],["L",v+c,u+d+p]],n&&s.push(["M",v+c,r-l],["L",v+c,i+l])):(v-=p,t+=v+p-h,i+=v+p-h,s=[["M",v,f],["L",t,f],["L",t,g],["M",i,g],["L",i,f],["L",v+d+2*p,f]],n&&s.push(["M",t-l,f],["L",i+l,f])),this.outline[o]({d:s})},e.prototype.drawMasks=function(t,i,e,o){var r,s,n,a,l=this.left,h=this.top,p=this.height;e?(n=[l,l,l],a=[h,h+t,h+i],s=[p,p,p],r=[t,i-t,this.size-i]):(n=[l,l+t,l+i],a=[h,h,h],s=[t,i-t,this.size-i],r=[p,p,p]),this.shades.forEach(function(t,i){t[o]({x:n[i],y:a[i],width:s[i],height:r[i]})})},e.prototype.renderElements=function(){var t,i,e=this,o=e.navigatorOptions,r=o.maskInside,s=e.chart,n=s.inverted,a=s.renderer,l={cursor:n?"ns-resize":"ew-resize"},h=null!==(t=e.navigatorGroup)&&void 0!==t?t:e.navigatorGroup=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!r,r,!r].forEach(function(t,i){var r,n=null!==(r=e.shades[i])&&void 0!==r?r:e.shades[i]=a.rect().addClass("highcharts-navigator-mask"+(1===i?"-inside":"-outside")).add(h);s.styledMode||(n.attr({fill:t?o.maskFill:"rgba(0,0,0,0)"}),1===i&&n.css(l))}),e.outline||(e.outline=a.path().addClass("highcharts-navigator-outline").add(h)),s.styledMode||e.outline.attr({"stroke-width":o.outlineWidth,stroke:o.outlineColor}),null===(i=o.handles)||void 0===i?void 0:i.enabled){var p=o.handles,d=p.height,c=p.width;[0,1].forEach(function(t){var i=p.symbols[t];if(e.handles[t]){if(i!==e.handles[t].symbolName){var o=u[i].call(u,-c/2-1,0,c,d);e.handles[t].attr({d:o}),e.handles[t].symbolName=i}}else e.handles[t]=a.symbol(i,-c/2-1,0,c,d,p),e.handles[t].attr({zIndex:7-t}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][t]).add(h);s.inverted&&e.handles[t].attr({rotation:90,rotationOriginX:Math.floor(-c/2),rotationOriginY:(d+c)/2}),s.styledMode||e.handles[t].attr({fill:p.backgroundColor,stroke:p.borderColor,"stroke-width":p.lineWidth,width:p.width,height:p.height,x:-c/2-1,y:0}).css(l)})}},e.prototype.update=function(t,i){var e,o,r,s,n=this;void 0===i&&(i=!1);var a=this.chart,l=a.options.chart.inverted!==(null===(r=a.scrollbar)||void 0===r?void 0:r.options.vertical);if(k(!0,a.options.navigator,t),this.navigatorOptions=a.options.navigator||{},this.setOpposite(),v(t.enabled)||l)return this.destroy(),this.navigatorEnabled=t.enabled||this.navigatorEnabled,this.init(a);if(this.navigatorEnabled&&(this.isDirty=!0,!1===t.adaptToUpdatedData&&this.baseSeries.forEach(function(t){w(t,"updatedData",n.updatedDataHandler)},this),t.adaptToUpdatedData&&this.baseSeries.forEach(function(t){t.eventsToUnbind.push(c(t,"updatedData",n.updatedDataHandler))},this),(t.series||t.baseSeries)&&this.setBaseSeries(void 0,!1),t.height||t.xAxis||t.yAxis)){this.height=null!==(s=t.height)&&void 0!==s?s:this.height;var p=this.getXAxisOffsets();this.xAxis.update(h(h({},t.xAxis),((e={offsets:p})[a.inverted?"width":"height"]=this.height,e[a.inverted?"height":"width"]=void 0,e)),!1),this.yAxis.update(h(h({},t.yAxis),((o={})[a.inverted?"width":"height"]=this.height,o)),!1)}i&&a.redraw()},e.prototype.render=function(t,i,e,o){var r,s,n,a,l,h=this.chart,p=this.xAxis,d=p.pointRange||0,u=p.navigatorAxis.fake?h.xAxis[0]:p,c=this.navigatorEnabled,x=this.rendered,m=h.inverted,y=h.xAxis[0].minRange,b=h.xAxis[0].options.maxRange,S=this.scrollButtonSize,k=this.scrollbarHeight;if(!this.hasDragged||v(e)){if(this.isDirty&&this.renderElements(),t=g(t-d/2),i=g(i+d/2),!A(t)||!A(i)){if(!x)return;e=0,o=C(p.width,u.width)}this.left=C(p.left,h.plotLeft+S+(m?h.plotWidth:0));var w=this.size=a=C(p.len,(m?h.plotHeight:h.plotWidth)-2*S);r=m?k:a+2*S,e=C(e,p.toPixels(t,!0)),o=C(o,p.toPixels(i,!0)),A(e)&&Math.abs(e)!==1/0||(e=0,o=r);var D=p.toValue(e,!0),O=p.toValue(o,!0),E=Math.abs(g(O-D));E<y?this.grabbedLeft?e=p.toPixels(O-y-d,!0):this.grabbedRight&&(o=p.toPixels(D+y+d,!0)):v(b)&&g(E-d)>b&&(this.grabbedLeft?e=p.toPixels(O-b-d,!0):this.grabbedRight&&(o=p.toPixels(D+b+d,!0))),this.zoomedMax=f(Math.max(e,o),0,w),this.zoomedMin=f(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,o),0,w),this.range=this.zoomedMax-this.zoomedMin,w=Math.round(this.zoomedMax);var P=Math.round(this.zoomedMin);c&&(this.navigatorGroup.attr({visibility:"inherit"}),l=x&&!this.hasDragged?"animate":"attr",this.drawMasks(P,w,m,l),this.drawOutline(P,w,m,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(P,0,m,l),this.drawHandle(w,1,m,l))),this.scrollbar&&(m?(n=this.top-S,s=this.left-k+(c||!u.opposite?0:(u.titleOffset||0)+u.axisTitleMargin),k=a+2*S):(n=this.top+(c?this.height:-k),s=this.left-S),this.scrollbar.position(s,n,r,k),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,this.isDirty=!1,M(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,i,e=this,o=e.chart,r=o.container,s=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(s=e.getPartsEvents("mousedown")).push(c(o.renderTo,"mousemove",t),c(r.ownerDocument,"mouseup",i),c(o.renderTo,"touchmove",t),c(r.ownerDocument,"touchend",i)),s.concat(e.getPartsEvents("touchstart")),e.eventsToUnbind=s,e.series&&e.series[0]&&s.push(c(e.series[0].xAxis,"foundExtremes",function(){o.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(o){i[o].forEach(function(r,s){e.push(c(r.element,t,function(t){i[o+"Mousedown"](t,s)}))})}),e},e.prototype.shadesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o,r,s,n,a=this.chart,l=this.xAxis,h=this.zoomedMin,p=this.size,d=this.range,u=this.left,c=t.chartX;a.inverted&&(c=t.chartY,u=this.top),1===i?(this.grabbedCenter=c,this.fixedWidth=d,this.dragOffset=c-h):(n=c-u-d/2,0===i?n=Math.max(0,n):2===i&&n+d>=p&&(n=p-d,this.reversedExtremes?(n-=d,r=this.getUnionExtremes().dataMin):o=this.getUnionExtremes().dataMax),n!==h&&(this.fixedWidth=d,v((s=l.navigatorAxis.toFixedRange(n,n+d,r,o)).min)&&M(this,"setRange",{min:Math.min(s.min,s.max),max:Math.max(s.min,s.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},e.prototype.handlesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o=this.chart,r=o.xAxis[0],s=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=s?r.min:r.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=s?r.max:r.min),o.setFixedRange(void 0)},e.prototype.onMouseMove=function(t){var i,e,o=this,r=o.chart,s=o.navigatorSize,n=o.range,a=o.dragOffset,l=r.inverted,h=o.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=(null===(i=r.pointer)||void 0===i?void 0:i.normalize(t))||t).chartX,l&&(h=o.top,e=t.chartY),o.grabbedLeft?(o.hasDragged=!0,o.render(0,0,e-h,o.otherHandlePos)):o.grabbedRight?(o.hasDragged=!0,o.render(0,0,o.otherHandlePos,e-h)):o.grabbedCenter&&(o.hasDragged=!0,e<a?e=a:e>s+a-n&&(e=s+a-n),o.render(0,0,e-a,e-a+n)),o.hasDragged&&o.scrollbar&&C(o.scrollbar.options.liveRedraw,!d&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){o.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var i,e,o,r,s,n,a=this.chart,l=this.xAxis,h=this.scrollbar,p=t.DOMEvent||t,d=a.inverted,u=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===t.trigger)&&(o=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?r=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(s=this.fixedExtreme),this.zoomedMax===this.size&&(s=this.reversedExtremes?o.dataMin:o.dataMax),0===this.zoomedMin&&(r=this.reversedExtremes?o.dataMax:o.dataMin),v((n=l.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,r,s)).min)&&M(this,"setRange",{min:Math.min(n.min,n.max),max:Math.max(n.min,n.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:p}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&A(this.zoomedMin)&&A(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,d,u),this.outline&&this.drawOutline(e,i,d,u),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,d,u),this.drawHandle(i,1,d,u)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){w(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&w(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.getXAxisOffsets=function(){return this.chart.inverted?[this.scrollButtonSize,0,-this.scrollButtonSize,0]:[0,-this.scrollButtonSize,0,this.scrollButtonSize]},e.prototype.init=function(i){var e=i.options,o=e.navigator||{},s=o.enabled,a=e.scrollbar||{},l=a.enabled,h=s&&o.height||0,p=l&&a.height||0,d=a.buttonsEnabled&&p||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=h,this.scrollbarHeight=p,this.scrollButtonSize=d,this.scrollbarEnabled=l,this.navigatorEnabled=s,this.navigatorOptions=o,this.scrollbarOptions=a,this.setOpposite();var u=this,f=u.baseSeries,g=i.xAxis.length,v=i.yAxis.length,x=f&&f[0]&&f[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,u.navigatorEnabled){var m=this.getXAxisOffsets();u.xAxis=new t(i,k({breaks:x.options.breaks,ordinal:x.options.ordinal,overscroll:x.options.overscroll},o.xAxis,{type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:x.options.ordinal?0:x.options.minPadding,maxPadding:x.options.ordinal?0:x.options.maxPadding,zoomEnabled:!1},i.inverted?{offsets:m,width:h}:{offsets:m,height:h}),"xAxis"),u.yAxis=new t(i,k(o.yAxis,{alignTicks:!1,offset:0,index:v,isInternal:!0,reversed:C(o.yAxis&&o.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:h}:{height:h}),"yAxis"),f||o.series.data?u.updateNavigatorSeries(!1):0===i.series.length&&(u.unbindRedraw=c(i,"beforeRedraw",function(){i.series.length>0&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=i.inverted&&!u.xAxis.reversed||!i.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()}else u.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var o=i.xAxis[0],r=o.getExtremes(),s=o.len-2*d,n=O("min",o.options.min,r.dataMin),a=O("max",o.options.max,r.dataMax)-n;return e?t*a/s+n:s*(t-n)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=r.prototype.toFixedRange.bind(u.xAxis.navigatorAxis);if(i.options.scrollbar.enabled){var y=k(i.options.scrollbar,{vertical:i.inverted});!A(y.margin)&&u.navigatorEnabled&&(y.margin=i.inverted?-3:3),i.scrollbar=u.scrollbar=new n(i.renderer,y,i),c(u.scrollbar,"changed",function(t){var i=u.size,e=i*this.to,o=i*this.from;u.hasDragged=u.scrollbar.hasDragged,u.render(0,0,o,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){u.onMouseUp(t)})})}u.addBaseSeriesEvents(),u.addChartEvents()},e.prototype.setOpposite=function(){var t=this.navigatorOptions,i=this.navigatorEnabled,e=this.chart;this.opposite=C(t.opposite,!!(!i&&e.inverted))},e.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],o=this.xAxis,r=o.options,s=e.options;return t&&null===e.dataMin||(i={dataMin:C(r&&r.min,O("min",s.min,e.dataMin,o.dataMin,o.min)),dataMax:C(r&&r.max,O("max",s.max,e.dataMax,o.dataMax,o.max))}),i},e.prototype.setBaseSeries=function(t,i){var e=this.chart,o=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?b(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&o.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},e.prototype.updateNavigatorSeries=function(t,i){var e,o,r,s,n,a=this,l=a.chart,h=a.baseSeries,d={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:null===(e=this.navigatorOptions.xAxis)||void 0===e?void 0:e.id,yAxis:null===(o=this.navigatorOptions.yAxis)||void 0===o?void 0:o.id,showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},u=a.series=(a.series||[]).filter(function(t){var i=t.baseSeries;return!(0>h.indexOf(i))||(i&&(w(i,"updatedData",a.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),c=a.navigatorOptions.series;h&&h.length&&h.forEach(function(t){var e=t.navigatorSeries,o=y({color:t.color,visible:t.visible},S(c)?p.navigator.series:c);if(!e||!1!==a.navigatorOptions.adaptToUpdatedData){d.name="Navigator "+h.length,n=(r=t.options||{}).navigatorOptions||{},o.dataLabels=D(o.dataLabels),(s=k(r,d,o,n)).pointRange=C(o.pointRange,n.pointRange,p.plotOptions[s.type||"line"].pointRange);var f=n.data||o.data;a.hasNavigatorData=a.hasNavigatorData||!!f,s.data=f||r.data&&r.data.slice(0),e&&e.options?e.update(s,i):(t.navigatorSeries=l.initSeries(s),l.setSortedData(),t.navigatorSeries.baseSeries=t,u.push(t.navigatorSeries))}}),(c.data&&!(h&&h.length)||S(c))&&(a.hasNavigatorData=!1,(c=D(c)).forEach(function(t,i){d.name="Navigator "+(u.length+1),(s=k(p.navigator.series,{color:l.series[i]&&!l.series[i].options.isInternal&&l.series[i].color||l.options.colors[i]||l.options.colors[0]},d,t)).data=t.data,s.data&&(a.hasNavigatorData=!0,u.push(l.initSeries(s)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(c(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(o){o.eventsToUnbind.push(c(o,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),o.eventsToUnbind.push(c(o,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&o.xAxis&&o.eventsToUnbind.push(c(o,"updatedData",t.updatedDataHandler)),o.eventsToUnbind.push(c(o,"remove",function(){e&&m(e,o),this.navigatorSeries&&(m(i.series,this.navigatorSeries),v(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,i,e,o=this.chart.navigator,r=this.getExtremes(),s=r.min,n=r.max,a=r.dataMin,l=r.dataMax,h=n-s,p=o.stickToMin,d=o.stickToMax,u=C(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),c=o.series&&o.series[0],f=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(p&&(i=(e=a)+h),d&&(i=l+u,p||(e=Math.max(a,i-h,o.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE)))),f&&(p||d)&&A(e)&&(this.min=this.userMin=e,this.max=this.userMax=i)),o.stickToMin=o.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=C(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),o=t.xAxis,r=o.max,s=o.min,n=o.options.range;return!!(A(r)&&A(s))&&(n&&r-e>0?r-e<n:s<=e)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(c(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),c(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),c(e,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(m(this.chart.xAxis,this.xAxis),m(this.chart.axes,this.xAxis)),this.yAxis&&(m(this.chart.yAxis,this.yAxis),m(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){x(t)}),this.navigatorEnabled=!1},e}()}),e(i,"Core/Axis/OrdinalAxis.js",[i["Core/Axis/Axis.js"],i["Core/Globals.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=o.addEvent,n=o.correctFloat,a=o.css,l=o.defined,h=o.error,p=o.isNumber,d=o.pick,u=o.timeUnits,c=o.isString;return function(t){function o(t,i,e,o,r,s,n){void 0===r&&(r=[]),void 0===s&&(s=0);var a,p,d,c,f,g={},v=this.options.tickPixelInterval,x=this.chart.time,m=[],y=0,b=[],M=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!r||r.length<3||void 0===i)return x.getTimeTicks.apply(x,arguments);var S=r.length;for(a=0;a<S;a++){if(f=a&&r[a-1]>e,r[a]<i&&(y=a),a===S-1||r[a+1]-r[a]>5*s||f){if(r[a]>M){for(p=x.getTimeTicks(t,r[y],r[a],o);p.length&&p[0]<=M;)p.shift();p.length&&(M=p[p.length-1]),m.push(b.length),b=b.concat(p)}y=a+1}if(f)break}if(p){if(c=p.info,n&&c.unitRange<=u.hour){for(y=1,a=b.length-1;y<a;y++)x.dateFormat("%d",b[y])!==x.dateFormat("%d",b[y-1])&&(g[b[y]]="day",d=!0);d&&(g[b[0]]="day"),c.higherRanks=g}c.segmentStarts=m,b.info=c}else h(12,!1,this.chart);if(n&&l(v)){for(var A=b.length,k=[],C=[],w=void 0,D=void 0,O=void 0,E=void 0,P=void 0,B=A;B--;)D=this.translate(b[B]),O&&(C[B]=O-D),k[B]=O=D;for(C.sort(function(t,i){return t-i}),(E=C[Math.floor(C.length/2)])<.6*v&&(E=null),B=b[A-1]>e?A-1:A,O=void 0;B--;)P=Math.abs(O-(D=k[B])),O&&P<.8*v&&(null===E||P<.8*E)?(g[b[B]]&&!g[b[B+1]]?(w=B+1,O=D):w=B,b.splice(w,1)):O=D}return b}function r(t){var i=this.ordinal.positions;if(!i)return t;var e,o=i.length-1;return(t<0?t=i[0]:t>o?t=i[o]:(o=Math.floor(t),e=t-o),void 0!==e&&void 0!==i[o])?i[o]+(e?e*(i[o+1]-i[o]):0):t}function f(t){var i=this.ordinal,e=this.old?this.old.min:this.min,o=this.old?this.old.transA:this.transA,r=i.getExtendedPositions();if(r&&r.length){var s=n((t-e)*o+this.minPixelPadding),a=n(i.getIndexOfPoint(s,r)),l=n(a%1);if(a>=0&&a<=r.length-1){var h=r[Math.floor(a)],p=r[Math.ceil(a)];return r[Math.floor(a)]+l*(p-h)}}return t}function g(i,e){var o=t.Additions.findIndexOf(i,e,!0);if(i[o]===e)return o;var r=(e-i[o])/(i[o+1]-i[o]);return o+r}function v(){this.ordinal||(this.ordinal=new t.Additions(this))}function x(){var t=this.eventArgs,i=this.options;if(this.isXAxis&&l(i.overscroll)&&0!==i.overscroll&&p(this.max)&&p(this.min)&&(this.options.ordinal&&!this.ordinal.originalOrdinalRange&&this.ordinal.getExtendedPositions(!1),this.max===this.dataMax&&((null==t?void 0:t.trigger)!=="pan"||this.isInternal)&&(null==t?void 0:t.trigger)!=="navigator")){var e=this.ordinal.convertOverscroll(i.overscroll);this.max+=e,!this.isInternal&&l(this.userMin)&&(null==t?void 0:t.trigger)!=="mousewheel"&&(this.min+=e)}}function m(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function y(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function b(t){var i=this.xAxis[0],e=i.ordinal.convertOverscroll(i.options.overscroll),o=t.originalEvent.chartX,r=this.options.chart.panning,s=!1;if(r&&"y"!==r.type&&i.options.ordinal&&i.series.length&&(!t.touches||t.touches.length<=1)){var n=this.mouseDownX,l=i.getExtremes(),h=l.dataMin,p=l.dataMax,d=l.min,u=l.max,c=this.hoverPoints,f=i.closestPointRange||i.ordinal&&i.ordinal.overscrollPointsRange,g=Math.round((n-o)/(i.translationSlope*(i.ordinal.slope||f))),v=i.ordinal.getExtendedPositions(),x={ordinal:{positions:v,extendedOrdinalPositions:v}},m=i.index2val,y=i.val2lin,b=void 0,M=void 0;if(d<=h&&g<0||u+e>=p&&g>0)return;x.ordinal.positions?Math.abs(g)>1&&(c&&c.forEach(function(t){t.setState()}),p>(M=x.ordinal.positions)[M.length-1]&&M.push(p),this.setFixedRange(u-d),(b=i.navigatorAxis.toFixedRange(void 0,void 0,m.apply(x,[y.apply(x,[d,!0])+g]),m.apply(x,[y.apply(x,[u,!0])+g]))).min>=Math.min(l.dataMin,d)&&b.max<=Math.max(p,u)+e&&i.setExtremes(b.min,b.max,!0,!1,{trigger:"pan"}),this.mouseDownX=o,a(this.container,{cursor:"move"})):s=!0}else s=!0;s||r&&/y/.test(r.type)?e&&(i.max=i.dataMax+e):t.preventDefault()}function M(){var t=this.xAxis;t&&t.options.ordinal&&(delete t.ordinal.index,delete t.ordinal.originalOrdinalRange)}function S(t,i){var e,o,r=this.ordinal,s=r.positions,n=r.slope;if(!s)return t;var a=s.length;if(s[0]<=t&&s[a-1]>=t)e=g(s,t);else{if(!((o=r.getExtendedPositions&&r.getExtendedPositions())&&o.length))return t;var l=o.length;n||(n=(o[l-1]-o[0])/l);var h=g(o,s[0]);if(t>=o[0]&&t<=o[l-1])e=g(o,t)-h;else{if(!i)return t;if(t<o[0]){var p=o[0]-t,d=p/n;e=-h-d}else{var p=t-o[l-1],d=p/n;e=d+l-h}}}return i?e:n*(e||0)+r.offset}t.compose=function(t,i,e){var n=t.prototype;return n.ordinal2lin||(n.getTimeTicks=o,n.index2val=r,n.lin2val=f,n.val2lin=S,n.ordinal2lin=n.val2lin,s(t,"afterInit",v),s(t,"foundExtremes",x),s(t,"afterSetScale",m),s(t,"initialAxisTranslation",y),s(e,"pan",b),s(e,"touchpan",b),s(i,"updatedData",M)),t};var A=function(){function t(t){this.index={},this.axis=t}return t.prototype.beforeSetTickPositions=function(){var t,i,e,o,r,s,n,a,l=this.axis,h=l.ordinal,p=l.getExtremes(),u=p.min,c=p.max,f=null===(t=l.brokenAxis)||void 0===t?void 0:t.hasBreaks,g=l.options.ordinal,v=[],x=Number.MAX_VALUE,m=!1,y=!1,b=!1;if(g||f){var M=0;if(l.series.forEach(function(t,o){if(e=[],o>0&&"highcharts-navigator-series"!==t.options.id&&t.processedXData.length>1&&(y=M!==t.processedXData[1]-t.processedXData[0]),M=t.processedXData[1]-t.processedXData[0],t.boosted&&(b=t.boosted),t.reserveSpace()&&(!1!==t.takeOrdinalPosition||f)&&(i=(v=v.concat(t.processedXData)).length,v.sort(function(t,i){return t-i}),x=Math.min(x,d(t.closestPointRange,x)),i)){for(o=0;o<i-1;)v[o]!==v[o+1]&&e.push(v[o+1]),o++;e[0]!==v[0]&&e.unshift(v[0]),v=e}}),l.ordinal.originalOrdinalRange||(l.ordinal.originalOrdinalRange=(v.length-1)*x),y&&b&&(v.pop(),v.shift()),(i=v.length)>2){for(o=v[1]-v[0],a=i-1;a--&&!m;)v[a+1]-v[a]!==o&&(m=!0);!l.options.keepOrdinalPadding&&(v[0]-u>o||c-v[v.length-1]>o)&&(m=!0)}else l.options.overscroll&&(2===i?x=v[1]-v[0]:1===i?(x=l.ordinal.convertOverscroll(l.options.overscroll),v=[v[0],v[0]+x]):x=h.overscrollPointsRange);m||l.forceOrdinal?(l.options.overscroll&&(h.overscrollPointsRange=x,v=v.concat(h.getOverscrollPositions())),h.positions=v,r=l.ordinal2lin(Math.max(u,v[0]),!0),s=Math.max(l.ordinal2lin(Math.min(c,v[v.length-1]),!0),1),h.slope=n=(c-u)/(s-r),h.offset=u-r*n):(h.overscrollPointsRange=d(l.closestPointRange,h.overscrollPointsRange),h.positions=l.ordinal.slope=h.offset=void 0)}l.isOrdinal=g&&m,h.groupIntervalFactor=null},t.findIndexOf=function(t,i,e){for(var o,r=0,s=t.length-1;r<s;)t[o=Math.ceil((r+s)/2)]<=i?r=o:s=o-1;return t[r]===i?r:e?r:-1},t.prototype.getExtendedPositions=function(t){void 0===t&&(t=!0);var o,r,s=this,n=s.axis,a=n.constructor.prototype,l=n.chart,h=null===(o=n.series[0])||void 0===o?void 0:o.currentDataGrouping,p=h?h.count+h.unitName:"raw",d=t?n.ordinal.convertOverscroll(n.options.overscroll):0,u=n.getExtremes(),c=void 0,f=s.index;return f||(f=s.index={}),f[p]||((r={series:[],chart:l,forceOrdinal:!1,getExtremes:function(){return{min:u.dataMin,max:u.dataMax+d}},applyGrouping:a.applyGrouping,getGroupPixelWidth:a.getGroupPixelWidth,getTimeTicks:a.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:a.ordinal2lin,getIndexOfPoint:a.getIndexOfPoint,val2lin:a.val2lin}).ordinal.axis=r,n.series.forEach(function(o){var n,a,p;c={xAxis:r,xData:o.xData.slice(),chart:l,groupPixelWidth:o.groupPixelWidth,destroyGroupedData:i.noop,getProcessedData:e.prototype.getProcessedData,applyGrouping:e.prototype.applyGrouping,reserveSpace:e.prototype.reserveSpace,visible:o.visible},t&&(c.xData=c.xData.concat(s.getOverscrollPositions())),c.options={dataGrouping:h?{firstAnchor:null===(n=o.options.dataGrouping)||void 0===n?void 0:n.firstAnchor,anchor:null===(a=o.options.dataGrouping)||void 0===a?void 0:a.anchor,lastAnchor:null===(p=o.options.dataGrouping)||void 0===p?void 0:p.firstAnchor,enabled:!0,forced:!0,approximation:"open",units:[[h.unitName,[h.count]]]}:{enabled:!1}},r.series.push(c),o.processData.apply(c)}),r.applyGrouping({hasExtremesChanged:!0}),(null==c?void 0:c.closestPointRange)!==(null==c?void 0:c.basePointRange)&&c.currentDataGrouping&&(r.forceOrdinal=!0),n.ordinal.beforeSetTickPositions.apply({axis:r}),!n.ordinal.originalOrdinalRange&&r.ordinal.originalOrdinalRange&&(n.ordinal.originalOrdinalRange=r.ordinal.originalOrdinalRange),f[p]=r.ordinal.positions),f[p]},t.prototype.getGroupIntervalFactor=function(t,i,e){var o,r,s=e.processedXData,n=s.length,a=[],l=this.groupIntervalFactor;if(!l){for(r=0;r<n-1;r++)a[r]=s[r+1]-s[r];a.sort(function(t,i){return t-i}),o=a[Math.floor(n/2)],t=Math.max(t,s[0]),i=Math.min(i,s[n-1]),this.groupIntervalFactor=l=n*o/(i-t)}return l},t.prototype.getIndexOfPoint=function(i,e){var o,r=this.axis,s=0,a=function(t){var i=r.min,e=r.max;return!!(l(i)&&l(e))&&t.points.some(function(t){return t.x>=i&&t.x<=e})};r.series.forEach(function(t){var i,e=null===(i=t.points)||void 0===i?void 0:i[0];l(null==e?void 0:e.plotX)&&(e.plotX<o||!l(o))&&a(t)&&(o=e.plotX,s=e.x)}),null!=o||(o=r.minPixelPadding);var h=r.translationSlope*(this.slope||r.closestPointRange||this.overscrollPointsRange),p=n((i-o)/h);return t.findIndexOf(e,s,!0)+p},t.prototype.getOverscrollPositions=function(){var t=this.axis,i=this.convertOverscroll(t.options.overscroll),e=this.overscrollPointsRange,o=[],r=t.dataMax;if(l(e))for(;r<=t.dataMax+i;)o.push(r+=e);return o},t.prototype.postProcessTickInterval=function(t){var i=this.axis,e=this.slope;return e?i.options.breaks?i.closestPointRange||t:t/(e/i.closestPointRange):t},t.prototype.convertOverscroll=function(t){void 0===t&&(t=0);var i=this,e=i.axis,o=function(t){return d(i.originalOrdinalRange,l(e.dataMax)&&l(e.dataMin)?e.dataMax-e.dataMin:0)*t};if(c(t)){var r=parseInt(t,10);if(/%$/.test(t))return o(r/100);if(/px/.test(t)){var s=Math.min(r,.9*e.len)/e.len;return o(s/(1-s))}return 0}return t},t}();t.Additions=A}(r||(r={})),r}),e(i,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),e(i,"Stock/RangeSelector/RangeSelectorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=t.defaultOptions,n=i.composed,a=o.addEvent,l=o.defined,h=o.extend,p=o.isNumber,d=o.merge,u=o.pick,c=o.pushUnique,f=[];function g(){var t,i,e=this.range,o=e.type,r=this.max,s=this.chart.time,n=function(t,i){var e="year"===o?"FullYear":"Month",r=new s.Date(t),n=s.get(e,r);return s.set(e,r,n+i),n===s.get(e,r)&&s.set("Date",r,0),r.getTime()-t};p(e)?(t=r-e,i=e):e&&(t=r+n(r,-(e.count||1)),this.chart&&this.chart.setFixedRange(r-t));var a=u(this.dataMin,Number.MIN_VALUE);return p(t)||(t=a),t<=a&&(t=a,void 0===i&&(i=n(t,e.count)),this.newMax=Math.min(t+i,u(this.dataMax,Number.MAX_VALUE))),p(r)?!p(e)&&e&&e._offsetMin&&(t+=e._offsetMin):t=void 0,t}function v(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new r(this))}function x(){var t=this.rangeSelector;if(t){p(t.deferredYTDClick)&&(t.clickButton(t.deferredYTDClick),delete t.deferredYTDClick);var i=t.options.verticalAlign;t.options.floating||("bottom"===i?this.extraBottomMargin=!0:"middle"===i||(this.extraTopMargin=!0))}}function m(){var t,i=this.rangeSelector;if(i){var e=this.xAxis[0].getExtremes(),o=this.legend,r=i&&i.options.verticalAlign;p(e.min)&&i.render(e.min,e.max),o.display&&"top"===r&&r===o.options.verticalAlign&&(t=d(this.spacingBox),"vertical"===o.options.layout?t.y=this.plotTop:t.y+=i.getHeight(),o.group.placed=!1,o.align(t))}}function y(){for(var t=0,i=f.length;t<i;++t){var e=f[t];if(e[0]===this){e[1].forEach(function(t){return t()}),f.splice(t,1);return}}}function b(){var t=this.rangeSelector;if(t){var i=t.getHeight();this.extraTopMargin&&(this.plotTop+=i),this.extraBottomMargin&&(this.marginBottom+=i)}}function M(t){var i=t.options.rangeSelector,e=this.extraBottomMargin,o=this.extraTopMargin,s=this.rangeSelector;if(i&&i.enabled&&!l(s)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=s=new r(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,s){var n=i&&i.verticalAlign||s.options&&s.options.verticalAlign;s.options.floating||("bottom"===n?this.extraBottomMargin=!0:"middle"===n||(this.extraTopMargin=!0)),(this.extraBottomMargin!==e||this.extraTopMargin!==o)&&(this.isDirtyBox=!0)}}return{compose:function(t,i,o){if(r=o,c(n,"RangeSelector")){var l=i.prototype;t.prototype.minFromRange=g,a(i,"afterGetContainer",v),a(i,"beforeRender",x),a(i,"destroy",y),a(i,"getMargins",b),a(i,"redraw",m),a(i,"update",M),l.callbacks.push(m),h(s,{rangeSelector:e.rangeSelector}),h(s.lang,e.lang)}}}}),e(i,"Stock/RangeSelector/RangeSelector.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorComposition.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"],i["Core/Axis/OrdinalAxis.js"]],function(t,i,e,o,r,s,n){var a=i.defaultOptions,l=s.addEvent,h=s.createElement,p=s.css,d=s.defined,u=s.destroyObjectProperties,c=s.discardElement,f=s.extend,g=s.fireEvent,v=s.isNumber,x=s.merge,m=s.objectEach,y=s.pad,b=s.pick,M=s.pInt,S=s.splat,A=function(){function i(t){this.buttonOptions=i.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.init(t)}return i.compose=function(t,e){o.compose(t,e,i)},i.prototype.clickButton=function(i,e){var o,r,s,n,a,h=this.chart,p=this.buttonOptions[i],u=h.xAxis[0],c=h.scroller&&h.scroller.getUnionExtremes()||u||{},f=p.type,x=p.dataGrouping,m=c.dataMin,y=c.dataMax,M=u&&Math.round(Math.min(u.max,b(y,u.max))),A=p._range,k=!0;if(null!==m&&null!==y){if(this.setSelected(i),x&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(u||{chart:this.chart},x,!1),this.frozenStates=p.preserveDataGrouping),"month"===f||"year"===f)u?(n={range:p,max:M,chart:h,dataMin:m,dataMax:y},o=u.minFromRange.call(n),v(n.newMax)&&(M=n.newMax),k=!1):A=p;else if(A)M=Math.min((o=Math.max(M-A,m))+A,y),k=!1;else if("ytd"===f){if(u)(void 0===y||void 0===m)&&(m=Number.MAX_VALUE,y=Number.MIN_VALUE,h.series.forEach(function(t){var i=t.xData;i&&(m=Math.min(i[0],m),y=Math.max(i[i.length-1],y))}),e=!1),o=s=(a=this.getYTDExtremes(y,m,h.time.useUTC)).min,M=a.max;else{this.deferredYTDClick=i;return}}else"all"===f&&u&&(h.navigator&&h.navigator.baseSeries[0]&&(h.navigator.baseSeries[0].xAxis.options.range=void 0),o=m,M=y);if(k&&p._offsetMin&&d(o)&&(o+=p._offsetMin),p._offsetMax&&d(M)&&(M+=p._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=i+1),u)u.setExtremes(o,M,b(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:p}),h.setFixedRange(p._range);else{r=S(h.options.xAxis)[0];var C=l(h,"afterGetAxes",function(){var t=h.xAxis[0];t.range=t.options.range=A,t.min=t.options.min=s});l(h,"load",function(){var t=h.xAxis[0];h.setFixedRange(p._range),t.options.range=r.range,t.options.min=r.min,C()})}g(this,"afterBtnClick")}},i.prototype.setSelected=function(t){this.selected=this.options.selected=t},i.prototype.init=function(t){var i=this,e=t.options.rangeSelector,o=e.buttons||i.defaultButtons.slice(),r=e.selected,s=function(){var t=i.minInput,e=i.maxInput;t&&t.blur&&g(t,"blur"),e&&e.blur&&g(e,"blur")};i.chart=t,i.options=e,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(l(t.container,"mousedown",s)),this.eventsToUnbind.push(l(t,"resize",s)),o.forEach(i.computeButtonRange),void 0!==r&&o[r]&&this.clickButton(r,!1),this.eventsToUnbind.push(l(t,"load",function(){t.xAxis&&t.xAxis[0]&&l(t.xAxis[0],"setExtremes",function(e){v(this.max)&&v(this.min)&&this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==e.trigger&&"updatedData"!==e.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})})),this.createElements()},i.prototype.updateButtonStates=function(){var t=this,i=this.chart,e=this.dropdown,o=this.dropdownLabel,r=i.xAxis[0],s=Math.round(r.max-r.min),l=!r.hasVisibleSeries,h=24*36e5,d=i.scroller&&i.scroller.getUnionExtremes()||r,u=d.dataMin,c=d.dataMax,f=t.getYTDExtremes(c,u,i.time.useUTC),g=f.min,x=f.max,m=t.selected,y=t.options.allButtonsEnabled,b=Array(t.buttonOptions.length).fill(0),M=v(m),S=t.buttons,A=!1,k=null;t.buttonOptions.forEach(function(i,e){var o,a=i._range,p=i.type,d=i.count||1,f=i._offsetMax-i._offsetMin,v=e===m,S=a>c-u,C=a<r.minRange,w=!1,D=a===s;if(v&&S&&(A=!0),r.isOrdinal&&(null===(o=r.ordinal)||void 0===o?void 0:o.positions)&&a&&s<a){var O=r.ordinal.positions,E=n.Additions.findIndexOf(O,r.min,!0),P=Math.min(n.Additions.findIndexOf(O,r.max,!0)+1,O.length-1);O[P]-O[E]>a&&(D=!0)}else("month"===p||"year"===p)&&s+36e5>=({month:28,year:365})[p]*h*d-f&&s-36e5<=({month:31,year:366})[p]*h*d+f?D=!0:"ytd"===p?(D=x-g+f===s,w=!v):"all"===p&&(D=r.max-r.min>=c-u);var B=!y&&!(A&&"all"===p)&&(S||C||l),T=A&&"all"===p||!w&&D||v&&t.frozenStates;B?b[e]=3:T&&(!M||e===m)&&(k=e)}),null!==k?(b[k]=2,t.setSelected(k)):(t.setSelected(),o&&(o.setState(0),o.attr({text:(a.lang.rangeSelectorZoom||"")+" ▾"})));for(var C=0;C<b.length;C++){var w=b[C],D=S[C];if(D.state!==w&&(D.setState(w),e)){e.options[C+1].disabled=3===w,2===w&&(o&&(o.setState(2),o.attr({text:t.buttonOptions[C].text+" ▾"})),e.selectedIndex=C+1);var O=o.getBBox();p(e,{width:"".concat(O.width,"px"),height:"".concat(O.height,"px")})}}},i.prototype.computeButtonRange=function(t){var i=t.type,e=t.count||1,o={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};o[i]?t._range=o[i]*e:("month"===i||"year"===i)&&(t._range=24*({month:30,year:365})[i]*36e5*e),t._offsetMin=b(t.offsetMin,0),t._offsetMax=b(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},i.prototype.getInputValue=function(t){var i="min"===t?this.minInput:this.maxInput,e=this.chart.options.rangeSelector,o=this.chart.time;return i?("text"===i.type&&e.inputDateParser||this.defaultInputDateParser)(i.value,o.useUTC,o):0},i.prototype.setInputValue=function(t,i){var e=this.options,o=this.chart.time,r="min"===t?this.minInput:this.maxInput,s="min"===t?this.minDateBox:this.maxDateBox;if(r){var n=r.getAttribute("data-hc-time"),a=d(n)?Number(n):void 0;if(d(i)){var l=a;d(l)&&r.setAttribute("data-hc-time-previous",l),r.setAttribute("data-hc-time",i),a=i}r.value=o.dateFormat(this.inputTypeFormats[r.type]||e.inputEditDateFormat,a),s&&s.attr({text:o.dateFormat(e.inputDateFormat,a)})}},i.prototype.setInputExtremes=function(t,i,e){var o="min"===t?this.minInput:this.maxInput;if(o){var r=this.inputTypeFormats[o.type],s=this.chart.time;if(r){var n=s.dateFormat(r,i);o.min!==n&&(o.min=n);var a=s.dateFormat(r,e);o.max!==a&&(o.max=a)}}},i.prototype.showInput=function(t){var i="min"===t?this.minDateBox:this.maxDateBox,e="min"===t?this.minInput:this.maxInput;if(e&&i&&this.inputGroup){var o="text"===e.type,r=this.inputGroup,s=r.translateX,n=void 0===s?0:s,a=r.translateY,l=void 0===a?0:a,h=i.x,d=void 0===h?0:h,u=i.width,c=void 0===u?0:u,f=i.height,g=void 0===f?0:f,v=this.options.inputBoxWidth;p(e,{width:o?c+(v?-2:20)+"px":"auto",height:g-2+"px",border:"2px solid silver"}),o&&v?p(e,{left:n+d+"px",top:l+"px"}):p(e,{left:Math.min(Math.round(d+n-(e.offsetWidth-c)/2),this.chart.chartWidth-e.offsetWidth)+"px",top:l-(e.offsetHeight-g)/2+"px"})}},i.prototype.hideInput=function(t){var i="min"===t?this.minInput:this.maxInput;i&&p(i,{top:"-9999em",border:0,width:"1px",height:"1px"})},i.prototype.defaultInputDateParser=function(t,i,o){var r,s=t.split("/").join("-").split(" ").join("T");if(-1===s.indexOf("T")&&(s+="T00:00"),i)s+="Z";else if(e.isSafari&&!((r=s).length>6&&(r.lastIndexOf("-")===r.length-6||r.lastIndexOf("+")===r.length-6))){var n=new Date(s).getTimezoneOffset()/60;s+=n<=0?"+".concat(y(-n),":00"):"-".concat(y(n),":00")}var a=Date.parse(s);if(!v(a)){var l=t.split("-");a=Date.UTC(M(l[0]),M(l[1])-1,M(l[2]))}return o&&i&&v(a)&&(a+=o.getTimezoneOffset(a)),a},i.prototype.drawInput=function(t){var i=this.chart,o=this.div,r=this.inputGroup,s=this,n=i.renderer.style||{},l=i.renderer,d=i.options.rangeSelector,u=a.lang,c="min"===t;function g(t){var e,o=s.maxInput,r=s.minInput,n=i.xAxis[0],a=(null===(e=i.scroller)||void 0===e?void 0:e.getUnionExtremes())||n,l=a.dataMin,h=a.dataMax,p=i.xAxis[0].getExtremes()[t],d=s.getInputValue(t);v(d)&&d!==p&&(c&&o&&v(l)?d>Number(o.getAttribute("data-hc-time"))?d=void 0:d<l&&(d=l):r&&v(h)&&(d<Number(r.getAttribute("data-hc-time"))?d=void 0:d>h&&(d=h)),void 0!==d&&n.setExtremes(c?d:n.min,c?n.max:d,void 0,void 0,{trigger:"rangeSelectorInput"}))}var m=u[c?"rangeSelectorFrom":"rangeSelectorTo"]||"",y=l.label(m,0).addClass("highcharts-range-label").attr({padding:m?2:0,height:m?d.inputBoxHeight:0}).add(r),b=l.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){s.showInput(t),s[t+"Input"].focus()});i.styledMode||b.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),b.add(r);var M=h("input",{name:t,className:"highcharts-range-selector"},void 0,o);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var i=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(i){return -1!==t.indexOf("%"+i)}),e=["H","k","I","l","M","S"].some(function(i){return -1!==t.indexOf("%"+i)});return i&&e?"datetime-local":i?"date":e?"time":"text"}(d.inputDateFormat||"%e %b %Y")),i.styledMode||(y.css(x(n,d.labelStyle)),b.css(x({color:"#333333"},n,d.inputStyle)),p(M,f({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:n.fontSize,fontFamily:n.fontFamily,top:"-9999em"},d.inputStyle))),M.onfocus=function(){s.showInput(t)},M.onblur=function(){M===e.doc.activeElement&&g(t),s.hideInput(t),s.setInputValue(t),M.blur()};var S=!1;return M.onchange=function(){S||(g(t),s.hideInput(t),M.blur())},M.onkeypress=function(i){13===i.keyCode&&g(t)},M.onkeydown=function(i){S=!0,("ArrowUp"===i.key||"ArrowDown"===i.key||"Tab"===i.key)&&g(t)},M.onkeyup=function(){S=!1},{dateBox:b,input:M,label:y}},i.prototype.getPosition=function(){var t=this.chart,i=t.options.rangeSelector,e="top"===i.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:e+i.buttonPosition.y,inputTop:e+i.inputPosition.y-10}},i.prototype.getYTDExtremes=function(t,i,e){var o=this.chart.time,r=new o.Date(t),s=o.get("FullYear",r),n=Math.max(i,e?o.Date.UTC(s,0,1):+new o.Date(s,0,1)),a=r.getTime();return{max:Math.min(t||a,a),min:n}},i.prototype.createElements=function(){var t,i=this.chart,e=i.renderer,o=i.container,r=i.options,s=r.rangeSelector,n=s.inputEnabled,a=b(null===(t=r.chart.style)||void 0===t?void 0:t.zIndex,0)+1;if(!1!==s.enabled&&(this.group=e.g("range-selector-group").attr({zIndex:7}).add(),this.div=h("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),o.parentNode&&o.parentNode.insertBefore(this.div,o),n)){this.inputGroup=e.g("input-group").add(this.group);var l=this.drawInput("min");this.minDateBox=l.dateBox,this.minLabel=l.label,this.minInput=l.input;var p=this.drawInput("max");this.maxDateBox=p.dateBox,this.maxLabel=p.label,this.maxInput=p.input}},i.prototype.render=function(t,i){var e=this.chart,o=e.options.rangeSelector,r=o.inputEnabled;if(!1!==o.enabled){if(r){this.setInputValue("min",t),this.setInputValue("max",i);var s=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{};if(d(s.dataMin)&&d(s.dataMax)){var n=e.xAxis[0].minRange||0;this.setInputExtremes("min",s.dataMin,Math.min(s.dataMax,this.getInputValue("max"))-n),this.setInputExtremes("max",Math.max(s.dataMin,this.getInputValue("min"))+n,s.dataMax)}if(this.inputGroup){var a=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var i=t.getBBox().width;i&&(t.attr({x:a}),a+=i+o.inputSpacing)}})}}this.alignElements(),this.updateButtonStates()}},i.prototype.renderButtons=function(){var t,i=this,o=this.buttons,r=this.chart,s=this.options,n=a.lang,p=r.renderer,d=x(s.buttonTheme),u=d&&d.states,c=d.width||28;delete d.width,delete d.states,this.buttonGroup=p.g("range-selector-buttons").add(this.group);var f=this.dropdown=h("select",void 0,{position:"absolute",padding:0,border:0,cursor:"pointer",opacity:1e-4},this.div),v=null===(t=r.userOptions.rangeSelector)||void 0===t?void 0:t.buttonTheme;this.dropdownLabel=p.button("",0,0,function(){},x(d,{"stroke-width":b(d["stroke-width"],0),width:"auto",paddingLeft:b(s.buttonTheme.paddingLeft,null==v?void 0:v.padding,8),paddingRight:b(s.buttonTheme.paddingRight,null==v?void 0:v.padding,8)}),u&&u.hover,u&&u.select,u&&u.disabled).hide().add(this.group),l(f,"touchstart",function(){f.style.fontSize="16px"});var m=e.isMS?"mouseover":"mouseenter",y=e.isMS?"mouseout":"mouseleave";l(f,m,function(){g(i.dropdownLabel.element,m)}),l(f,y,function(){g(i.dropdownLabel.element,y)}),l(f,"change",function(){g(i.buttons[f.selectedIndex-1].element,"click")}),this.zoomText=p.label(n.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),d["stroke-width"]=b(d["stroke-width"],0)),h("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,f),this.buttonOptions.forEach(function(t,e){h("option",{textContent:t.title||t.text},void 0,f),o[e]=p.button(t.text,0,0,function(o){var r,s=t.events&&t.events.click;s&&(r=s.call(t,o)),!1!==r&&i.clickButton(e),i.isActive=!0},d,u&&u.hover,u&&u.select,u&&u.disabled).attr({"text-align":"center",width:c}).add(i.buttonGroup),t.title&&o[e].attr("title",t.title)})},i.prototype.alignElements=function(){var t,i=this,e=this.buttonGroup,o=this.buttons,r=this.chart,s=this.group,n=this.inputGroup,a=this.options,l=this.zoomText,h=r.options,p=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,d=a.buttonPosition,u=a.inputPosition,c=a.verticalAlign,f=function(t,e){return p&&i.titleCollision(r)&&"top"===c&&"right"===e.align&&e.y-t.getBBox().height-12<(p.y||0)+(p.height||0)+r.spacing[0]?-40:0},g=r.plotLeft;if(s&&d&&u){var v=d.x-r.spacing[3];if(e){if(this.positionButtons(),!this.initialButtonGroupWidth){var x=0;l&&(x+=l.getBBox().width+5),o.forEach(function(t,i){x+=t.width||0,i!==o.length-1&&(x+=a.buttonSpacing)}),this.initialButtonGroupWidth=x}g-=r.spacing[3];var m=f(e,d);this.alignButtonGroup(m),(null===(t=this.buttonGroup)||void 0===t?void 0:t.translateY)&&this.dropdownLabel.attr({y:this.buttonGroup.translateY}),s.placed=e.placed=r.hasLoaded}var y=0;n&&(y=f(n,u),"left"===u.align?v=g:"right"===u.align&&(v=-Math.max(r.axisOffset[1],-y)),n.align({y:u.y,width:n.getBBox().width,align:u.align,x:u.x+v-2},!0,r.spacingBox),n.placed=r.hasLoaded),this.handleCollision(y),s.align({verticalAlign:c},!0,r.spacingBox);var M=s.alignAttr.translateY,S=s.getBBox().height+20,A=0;if("bottom"===c){var k=r.legend&&r.legend.options;A=M-(S=S+(k&&"bottom"===k.verticalAlign&&k.enabled&&!k.floating?r.legend.legendHeight+b(k.margin,10):0)-20)-(a.floating?0:a.y)-(r.titleOffset?r.titleOffset[2]:0)-10}"top"===c?(a.floating&&(A=0),r.titleOffset&&r.titleOffset[0]&&(A=r.titleOffset[0]),A+=r.margin[0]-r.spacing[0]||0):"middle"===c&&(u.y===d.y?A=M:(u.y||d.y)&&(u.y<0||d.y<0?A-=Math.min(u.y,d.y):A=M-S)),s.translate(a.x,a.y+Math.floor(A));var C=this.minInput,w=this.maxInput,D=this.dropdown;a.inputEnabled&&C&&w&&(C.style.marginTop=s.translateY+"px",w.style.marginTop=s.translateY+"px"),D&&(D.style.marginTop=s.translateY+"px")}},i.prototype.alignButtonGroup=function(t,i){var e=this.chart,o=this.options,r=this.buttonGroup,s=o.buttonPosition,n=e.plotLeft-e.spacing[3],a=s.x-e.spacing[3];"right"===s.align?a+=t-n:"center"===s.align&&(a-=n/2),r&&r.align({y:s.y,width:b(i,this.initialButtonGroupWidth),align:s.align,x:a},!0,e.spacingBox)},i.prototype.positionButtons=function(){var t=this.buttons,i=this.chart,e=this.options,o=this.zoomText,r=i.hasLoaded?"animate":"attr",s=e.buttonPosition,n=i.plotLeft,a=n;o&&"hidden"!==o.visibility&&(o[r]({x:b(n+s.x,n)}),a+=s.x+o.getBBox().width+5);for(var l=0,h=this.buttonOptions.length;l<h;++l)"hidden"!==t[l].visibility?(t[l][r]({x:a}),a+=(t[l].width||0)+e.buttonSpacing):t[l][r]({x:n})},i.prototype.handleCollision=function(t){var i=this,e=this.chart,o=this.buttonGroup,r=this.inputGroup,s=this.options,n=s.buttonPosition,a=s.dropdown,l=s.inputPosition,h=function(){var t=0;return i.buttons.forEach(function(i){var e=i.getBBox();e.width>t&&(t=e.width)}),t},p=function(i){if((null==r?void 0:r.alignOptions)&&o){var e=r.alignAttr.translateX+r.alignOptions.x-t+r.getBBox().x+2,s=r.alignOptions.width||0,a=o.alignAttr.translateX+o.getBBox().x;return a+i>e&&e+s>a&&n.y<l.y+r.getBBox().height}return!1},d=function(){r&&o&&r.attr({translateX:r.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:r.alignAttr.translateY+o.getBBox().height+10})};if(o){if("always"===a){this.collapseButtons(),p(h())&&d();return}"never"===a&&this.expandButtons()}r&&o?l.align===n.align||p(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(),p(h())&&d()):d():"responsive"===a&&this.expandButtons():o&&"responsive"===a&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons():this.expandButtons())},i.prototype.collapseButtons=function(){var t=this.buttons,i=this.zoomText;!0!==this.isCollapsed&&(this.isCollapsed=!0,i.hide(),t.forEach(function(t){t.hide()}),this.showDropdown())},i.prototype.expandButtons=function(){var t=this.buttons,i=this.zoomText;!1!==this.isCollapsed&&(this.isCollapsed=!1,this.hideDropdown(),i.show(),t.forEach(function(t){t.show()}),this.positionButtons())},i.prototype.showDropdown=function(){var t=this.buttonGroup,i=this.chart,e=this.dropdownLabel,o=this.dropdown;if(t&&o){var r=t.translateX,s=t.translateY,n=i.plotLeft+(void 0===r?0:r),a=void 0===s?0:s;e.attr({x:n,y:a}).show(),p(o,{left:n+"px",top:a+"px",visibility:"inherit"}),this.hasVisibleDropdown=!0}},i.prototype.hideDropdown=function(){var t=this.dropdown;t&&(this.dropdownLabel.hide(),p(t,{visibility:"hidden",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},i.prototype.getHeight=function(){var t=this.options,i=this.group,e=t.inputPosition,o=t.buttonPosition,r=t.y,s=o.y,n=e.y,a=0;if(t.height)return t.height;this.alignElements(),a=i?i.getBBox(!0).height+13+r:0;var l=Math.min(n,s);return(n<0&&s<0||n>0&&s>0)&&(a+=Math.abs(l)),a},i.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},i.prototype.update=function(t,i){void 0===i&&(i=!0);var e=this.chart;x(!0,e.options.rangeSelector,t),this.destroy(),this.init(e),i&&this.render()},i.prototype.destroy=function(){var t=this,e=t.minInput,o=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),u(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),m(t,function(e,o){e&&"chart"!==o&&(e instanceof r?e.destroy():e instanceof window.HTMLElement&&c(e)),e!==i.prototype[o]&&(t[o]=null)},this)},i}();return f(A.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),A}),e(i,"Core/Chart/StockChart.js",[i["Core/Chart/Chart.js"],i["Core/Templating.js"],i["Core/Defaults.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a){var l,h=this&&this.__extends||(l=function(t,i){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}l(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),p=i.format,d=e.getOptions,u=n.setFixedRange,c=a.addEvent,f=a.clamp,g=a.crisp,v=a.defined,x=a.extend,m=a.find,y=a.isNumber,b=a.isString,M=a.merge,S=a.pick,A=a.splat;function k(t,i,e){var o,r,s,n;return"xAxis"===t?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0}:"yAxis"===t?{labels:{y:-2},opposite:null===(r=null!==(o=e.opposite)&&void 0!==o?o:i.opposite)||void 0===r||r,showLastLabel:!!(i.categories||"category"===i.type),title:{text:(null===(s=e.title)||void 0===s?void 0:s.text)!=="Values"?null===(n=e.title)||void 0===n?void 0:n.text:null}}:{}}function C(t,i){if("xAxis"===t){var e=S(i.navigator&&i.navigator.enabled,o.enabled,!0),r={type:"datetime",categories:void 0};return e&&(r.startOnTick=!1,r.endOnTick=!1),r}return{}}var w=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return h(i,t),i.prototype.init=function(i,e){var n=d(),a=i.xAxis,l=i.yAxis,h=S(i.navigator&&i.navigator.enabled,o.enabled,!0);i.xAxis=i.yAxis=void 0;var p=M({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x",mouseWheel:{type:"x"}}},navigator:{enabled:h},scrollbar:{enabled:S(s.enabled,!0)},rangeSelector:{enabled:S(r.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:S(n.tooltip&&n.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},i,{isStock:!0});i.xAxis=a,i.yAxis=l,p.xAxis=A(i.xAxis||{}).map(function(t){return M(k("xAxis",t,n.xAxis),t,C("xAxis",i))}),p.yAxis=A(i.yAxis||{}).map(function(t){return M(k("yAxis",t,n.yAxis),t)}),t.prototype.init.call(this,p,e)},i.prototype.createAxis=function(i,e){return e.axis=M(k(i,e.axis,d()[i]),e.axis,C(i,this.userOptions)),t.prototype.createAxis.call(this,i,e)},i}(t);return c(t,"update",function(t){var i=t.options;"scrollbar"in i&&this.navigator&&(M(!0,this.options.scrollbar,i.scrollbar),this.navigator.update({enabled:!!this.navigator.navigatorEnabled}),delete i.scrollbar)}),function(t){function i(t){if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&y(this.min)&&y(this.max)){var i,e,o,r=this.chart,s=this.logarithmic,n=this.crosshair.label,a=this.horiz,l=this.opposite,h=this.left,d=this.top,u=this.width,c="inside"===this.options.tickPosition,f=!1!==this.crosshair.snap,g=t.e||this.cross&&this.cross.e,v=t.point,m=this.crossLabel,b=n.format,M="",A=0,k=this.min,C=this.max;s&&(k=s.lin2log(this.min),C=s.lin2log(this.max));var w=a?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";m||(m=this.crossLabel=r.renderer.label("",0,void 0,n.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(v&&v.series?v.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:n.align||w,padding:S(n.padding,8),r:S(n.borderRadius,3),zIndex:2}).add(this.labelGroup),r.styledMode||m.attr({fill:n.backgroundColor||v&&v.series&&v.series.color||"#666666",stroke:n.borderColor||"","stroke-width":n.borderWidth||0}).css(x({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},n.style||{}))),a?(i=f?(v.plotX||0)+h:g.chartX,e=d+(l?0:this.height)):(i=h+this.offset+(l?u:0),e=f?(v.plotY||0)+d:g.chartY),b||n.formatter||(this.dateTime&&(M="%b %d, %Y"),b="{value"+(M?":"+M:"")+"}");var D=f?this.isXAxis?v.x:v.y:this.toValue(a?g.chartX:g.chartY),O=v&&v.series?v.series.isPointInside(v):y(D)&&D>k&&D<C,E="";b?E=p(b,{value:D},r):n.formatter&&y(D)&&(E=n.formatter.call(this,D)),m.attr({text:E,x:i,y:e,visibility:O?"inherit":"hidden"});var P=m.getBBox();!y(m.x)||a||l||(i=m.x-P.width/2),y(m.y)&&(a?(c&&!l||!c&&l)&&(e=m.y-P.height):e=m.y-P.height/2),o=a?{left:h,right:h+this.width}:{left:"left"===this.labelAlign?h:0,right:"right"===this.labelAlign?h+this.width:r.chartWidth};var B=m.translateX||0;B<o.left&&(A=o.left-B),B+P.width>=o.right&&(A=-(B+P.width-o.right)),m.attr({x:i+A,y:e,anchorX:a?i:this.opposite?0:r.chartWidth,anchorY:a?this.opposite?r.chartHeight:0:e+P.height/2})}}function e(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())}function o(t){var i=this.chart,e=this.options,o=i._labelPanes=i._labelPanes||{},r=e.labels;if(i.options.isStock&&"yAxis"===this.coll){var s=e.top+","+e.height;!o[s]&&r.enabled&&(15===r.distance&&1===this.side&&(r.distance=0),void 0===r.align&&(r.align="right"),o[s]=this,t.align="right",t.preventDefault())}}function r(){var t=this.chart,i=this.options&&this.options.top+","+this.options.height;i&&t._labelPanes&&t._labelPanes[i]===this&&delete t._labelPanes[i]}function s(t){var i,e,o,r,s,n,a,l=this.isLinked&&!this.series&&this.linkedParent?this.linkedParent.series:this.series,h=this.chart,p=h.renderer,d=this.left,u=this.top,c=[],g=t.translatedValue,x=t.value,M=t.force,A=[];if(h.options.isStock&&!1!==t.acrossPanes&&"xAxis"===this.coll||"yAxis"===this.coll){t.preventDefault(),k="xAxis"===this.coll?"yAxis":"xAxis",A=y(C=this.options[k])?[h[k][C]]:b(C)?[h.get(C)]:l.map(function(t){return t[k]}),s=this.isXAxis?h.yAxis:h.xAxis;for(var k,C,w=0;w<s.length;w++){var D=s[w];if(!v(D.options.id)||-1===D.options.id.indexOf("navigator")){var O=D.isXAxis?"yAxis":"xAxis";this===(v(D.options[O])?h[O][D.options[O]]:h[O][0])&&A.push(D)}}n=A.length?[]:[this.isXAxis?h.yAxis[0]:h.xAxis[0]];for(var E=function(t){-1!==n.indexOf(t)||m(n,function(i){return i.pos===t.pos&&i.len===t.len})||n.push(t)},P=0,B=A;P<B.length;P++){var T=B[P];E(T)}if(y(a=S(g,this.translate(x||0,void 0,void 0,t.old)))){if(this.horiz)for(var j=0;j<n.length;j++){var T=n[j],G=void 0;r=(e=T.pos)+T.len,i=o=Math.round(a+this.transB),"pass"!==M&&(i<d||i>d+this.width)&&(M?i=o=f(i,d,d+this.width):G=!0),G||c.push(["M",i,e],["L",o,r])}else for(var R=0;R<n.length;R++){var T=n[R],G=void 0;o=(i=T.pos)+T.len,e=r=Math.round(u+this.height-a),"pass"!==M&&(e<u||e>u+this.height)&&(M?e=r=f(e,u,u+this.height):G=!0),G||c.push(["M",i,e],["L",o,r])}}t.path=c.length>0?p.crispPolyLine(c,t.lineWidth||1):void 0}}function n(t){if(this.chart.options.isStock){var i=void 0;this.is("column")||this.is("columnrange")?i={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(i={marker:{enabled:!1,radius:2}}),i&&(t.plotOptions[this.type]=M(t.plotOptions[this.type],i))}}function a(){var t=this.chart,i=this.options.dataGrouping;return!1!==this.allowDG&&i&&S(i.enabled,t.options.isStock)}function l(t,i){for(var e=0;e<t.length;e+=2){var o=t[e],r=t[e+1];v(o[1])&&o[1]===r[1]&&(o[1]=r[1]=g(o[1],i)),v(o[2])&&o[2]===r[2]&&(o[2]=r[2]=g(o[2],i))}return t}t.compose=function(t,h,p,d){var f=p.prototype;f.forceCropping||(c(h,"afterDrawCrosshair",i),c(h,"afterHideCrosshair",e),c(h,"autoLabelAlign",o),c(h,"destroy",r),c(h,"getPlotLinePath",s),t.prototype.setFixedRange=u,f.forceCropping=a,c(p,"setOptions",n),d.prototype.crispPolyLine=l)},t.stockChart=function(i,e,o){return new t(i,e,o)}}(w||(w={})),w}),e(i,"Series/HLC/HLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e(i,t),i}(t.seriesTypes.column.prototype.pointClass)}),e(i,"Series/HLC/HLCSeriesDefaults.js",[],function(){return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}}),e(i,"Series/HLC/HLCSeries.js",[i["Series/HLC/HLCPoint.js"],i["Series/HLC/HLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=this&&this.__extends||(r=function(t,i){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}r(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=e.seriesTypes.column,a=o.crisp,l=o.extend,h=o.merge,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.extendStem=function(t,i,e){var o=t[0],r=t[1];"number"==typeof o[2]&&(o[2]=Math.max(e+i,o[2])),"number"==typeof r[2]&&(r[2]=Math.min(e-i,r[2]))},e.prototype.getPointPath=function(t,i){var e=i.strokeWidth(),o=t.series,r=a(t.plotX||0,e),s=Math.round(t.shapeArgs.width/2),n=[["M",r,Math.round(t.yBottom)],["L",r,Math.round(t.plotHigh)]];if(null!==t.close){var l=a(t.plotClose,e);n.push(["M",r,l],["L",r+s,l]),o.extendStem(n,e/2,l)}return n},e.prototype.drawSinglePoint=function(t){var i,e=t.series,o=e.chart,r=t.graphic;void 0!==t.plotY&&(r||(t.graphic=r=o.renderer.path().add(e.group)),o.styledMode||r.attr(e.pointAttribs(t,t.selected&&"select")),i=e.getPointPath(t,r),r[r?"animate":"attr"]({d:i}).addClass(t.getClassName(),!0))},e.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)},e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e);return delete o.fill,o},e.prototype.toYData=function(t){return[t.high,t.low,t.close]},e.prototype.translate=function(){var i=this,e=i.yAxis,o=this.pointArrayMap&&this.pointArrayMap.slice()||[],r=o.map(function(t){return"plot".concat(t.charAt(0).toUpperCase()+t.slice(1))});r.push("yBottom"),o.push("low"),t.prototype.translate.apply(i),i.points.forEach(function(t){o.forEach(function(o,s){var n=t[o];null!==n&&(i.dataModify&&(n=i.dataModify.modifyValue(n)),t[r[s]]=e.toPixels(n,!0))}),t.tooltipPos[1]=t.plotHigh+e.pos-i.chart.plotTop})},e.defaultOptions=h(n.defaultOptions,i),e}(n);return l(p.prototype,{pointClass:t,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"}),e.registerSeriesType("hlc",p),p}),e(i,"Series/OHLC/OHLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e(i,t),i.prototype.getClassName=function(){return t.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},i.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},i.prototype.resolveColor=function(){t.prototype.resolveColor.call(this),this.series.is("heikinashi")||this.resolveUpColor()},i.prototype.getZone=function(){var i=t.prototype.getZone.call(this);return this.resolveUpColor(),i},i.prototype.applyOptions=function(){return t.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},i}(t.seriesTypes.hlc.prototype.pointClass)}),e(i,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}}),e(i,"Series/OHLC/OHLCSeries.js",[i["Core/Globals.js"],i["Series/OHLC/OHLCPoint.js"],i["Series/OHLC/OHLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s,n=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),a=t.composed,l=o.seriesTypes.hlc,h=r.addEvent,p=r.crisp,d=r.extend,u=r.merge,c=r.pushUnique;function f(t){var i=t.options,e=i.dataGrouping;e&&i.useOhlcData&&"highcharts-navigator-series"!==i.id&&(e.approximation="ohlc")}function g(t){var i=t.options;i.useOhlcData&&"highcharts-navigator-series"!==i.id&&d(this,{pointValKey:v.prototype.pointValKey,pointArrayMap:v.prototype.pointArrayMap,toYData:v.prototype.toYData})}var v=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n(i,t),i.compose=function(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];c(a,"OHLCSeries")&&(h(t,"afterSetOptions",f),h(t,"init",g))},i.prototype.getPointPath=function(i,e){var o=t.prototype.getPointPath.call(this,i,e),r=e.strokeWidth(),s=p(i.plotX||0,r),n=Math.round(i.shapeArgs.width/2);if(null!==i.open){var a=p(i.plotOpen,r);o.push(["M",s,a],["L",s-n,a]),t.prototype.extendStem.call(this,o,r/2,a)}return o},i.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e),r=this.options;return delete o.fill,!i.options.color&&r.upColor&&i.open<i.close&&(o.stroke=r.upColor),o},i.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},i.defaultOptions=u(l.defaultOptions,e),i}(l);return d(v.prototype,{pointClass:i,pointArrayMap:["open","high","low","close"]}),o.registerSeriesType("ohlc",v),v}),e(i,"Series/Candlestick/CandlestickSeriesDefaults.js",[],function(){return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}}),e(i,"Series/Candlestick/CandlestickSeries.js",[i["Series/Candlestick/CandlestickSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r=this&&this.__extends||(o=function(t,i){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}o(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),s=i.seriesTypes,n=s.column,a=s.ohlc,l=e.crisp,h=e.merge,p=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return r(e,i),e.prototype.pointAttribs=function(t,i){var e=n.prototype.pointAttribs.call(this,t,i),o=this.options,r=t.open<t.close,s=o.lineColor||this.color,a=t.color||this.color;if(e["stroke-width"]=o.lineWidth,e.fill=t.options.color||r&&o.upColor||a,e.stroke=t.options.lineColor||r&&o.upLineColor||s,i){var l=o.states[i];e.fill=l.color||e.fill,e.stroke=l.lineColor||e.stroke,e["stroke-width"]=l.lineWidth||e["stroke-width"]}return e},e.prototype.drawPoints=function(){for(var t=this.points,i=this.chart,e=this.yAxis.reversed,o=0;o<t.length;o++){var r=t[o],s=r.graphic,n=void 0,a=void 0,h=void 0,p=void 0,d=void 0,u=void 0,c=void 0,f=void 0,g=void 0,v=!s;if(void 0!==r.plotY){s||(r.graphic=s=i.renderer.path().add(this.group)),this.chart.styledMode||s.attr(this.pointAttribs(r,r.selected&&"select")).shadow(this.options.shadow);var x=s.strokeWidth();c=l(r.plotX||0,x),h=Math.min(n=r.plotOpen,a=r.plotClose),p=Math.max(n,a),g=Math.round(r.shapeArgs.width/2),d=e?p!==r.yBottom:Math.round(h)!==Math.round(r.plotHigh||0),u=e?Math.round(h)!==Math.round(r.plotHigh||0):p!==r.yBottom,h=l(h,x),p=l(p,x),(f=[]).push(["M",c-g,p],["L",c-g,h],["L",c+g,h],["L",c+g,p],["Z"],["M",c,h],["L",c,d?Math.round(e?r.yBottom:r.plotHigh):h],["M",c,p],["L",c,u?Math.round(e?r.plotHigh:r.yBottom):p]),s[v?"attr":"animate"]({d:f}).addClass(r.getClassName(),!0)}}},e.defaultOptions=h(a.defaultOptions,{tooltip:a.defaultOptions.tooltip},t),e}(a);return i.registerSeriesType("candlestick",p),p}),e(i,"Series/Flags/FlagsPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.column.prototype.pointClass,s=i.isNumber;return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.ttBelow=!1,i}return o(i,t),i.prototype.isValid=function(){return s(this.y)||void 0===this.y},i.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},i}(r)}),e(i,"Series/Flags/FlagsSeriesDefaults.js",[],function(){return{borderRadius:0,pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}}),e(i,"Series/Flags/FlagsSymbols.js",[i["Core/Renderer/RendererRegistry.js"]],function(t){var i;return function(i){var e=[];function o(t,i,e,o,r){var s=r&&r.anchorX||t,n=r&&r.anchorY||i,a=this.circle(s-1,n-1,2,2);return a.push(["M",s,n],["L",t,i+o],["L",t,i],["L",t+e,i],["L",t+e,i+o],["L",t,i+o],["Z"]),a}function r(t,i){t[i+"pin"]=function(e,o,r,s,n){var a,l=n&&n.anchorX,h=n&&n.anchorY;if("circle"===i&&s>r&&(e-=Math.round((s-r)/2),r=s),a=t[i](e,o,r,s,n),l&&h){var p=l;if("circle"===i)p=e+r/2;else{var d=a[0],u=a[1];"M"===d[0]&&"L"===u[0]&&(p=(d[1]+u[1])/2)}var c=o>h?o:o+s;a.push(["M",p,c],["L",l,h]),a=a.concat(t.circle(l-1,h-1,2,2))}return a}}i.compose=function(i){if(-1===e.indexOf(i)){e.push(i);var s=i.prototype.symbols;s.flag=o,r(s,"circle"),r(s,"square")}var n=t.getRendererType();e.indexOf(n)&&e.push(n)}}(i||(i={})),i}),e(i,"Series/OnSeriesComposition.js",[i["Series/Column/ColumnSeries.js"],i["Core/Globals.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=i.composed,n=t.prototype,a=e.prototype,l=o.defined,h=o.pushUnique,p=o.stableSort;return function(t){function i(t){return a.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function e(){n.translate.apply(this);var t,i,e,o,r,s,a,h,d,u=this,c=u.options,f=u.chart,g=u.points,v=c.onSeries,x=v&&f.get(v),m=x&&x.options.step,y=x&&x.points,b=f.inverted,M=u.xAxis,S=u.yAxis,A=g.length-1,k=c.onKey||"y",C=y&&y.length,w=0;if(x&&x.visible&&C)for(w=(x.pointXOffset||0)+(x.barW||0)/2,h=x.currentDataGrouping,s=y[C-1].x+(h?h.totalRange:0),p(g,function(t,i){return t.x-i.x}),k="plot"+k[0].toUpperCase()+k.substr(1);C--&&g[A]&&"break"!==function(){if(r=y[C],(e=g[A]).y=r.y,r.x<=e.x&&void 0!==r[k]){if(e.x<=s&&(e.plotY=r[k],r.x<e.x&&!m&&(a=y[C+1])&&void 0!==a[k])){if(l(e.plotX)&&x.is("spline")){for(var o=[r.plotX||0,r.plotY||0],n=[a.plotX||0,a.plotY||0],h=(null===(t=r.controlPoints)||void 0===t?void 0:t.high)||o,p=(null===(i=a.controlPoints)||void 0===i?void 0:i.low)||n,u=function(t,i){return Math.pow(1-t,3)*o[i]+3*(1-t)*(1-t)*t*h[i]+3*(1-t)*t*t*p[i]+t*t*t*n[i]},c=0,f=1,v=void 0,b=0;b<100;b++){var M=(c+f)/2,w=u(M,0);if(null===w)break;if(.25>Math.abs(w-e.plotX)){v=M;break}w<e.plotX?c=M:f=M}l(v)&&(e.plotY=u(v,1),e.y=S.toValue(e.plotY,!0))}else d=(e.x-r.x)/(a.x-r.x),e.plotY+=d*(a[k]-r[k]),e.y+=d*(a.y-r.y)}if(A--,C++,A<0)return"break"}}(););g.forEach(function(t,i){var e;t.plotX+=w,(void 0===t.plotY||b)&&(t.plotX>=0&&t.plotX<=M.len?b?(t.plotY=M.translate(t.x,0,1,0,1),t.plotX=l(t.y)?S.translate(t.y,0,0,0,1):0):t.plotY=(M.opposite?0:u.yAxis.len)+M.offset:t.shapeArgs={}),(o=g[i-1])&&o.plotX===t.plotX&&(void 0===o.stackIndex&&(o.stackIndex=0),e=o.stackIndex+1),t.stackIndex=e}),this.onSeries=x}t.compose=function(t){if(h(s,"OnSeries")){var o=t.prototype;o.getPlotBox=i,o.translate=e}return t},t.getPlotBox=i,t.translate=e}(r||(r={})),r}),e(i,"Series/Flags/FlagsSeries.js",[i["Series/Flags/FlagsPoint.js"],i["Series/Flags/FlagsSeriesDefaults.js"],i["Series/Flags/FlagsSymbols.js"],i["Core/Globals.js"],i["Series/OnSeriesComposition.js"],i["Core/Renderer/RendererUtilities.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a,l){var h,p=this&&this.__extends||(h=function(t,i){return(h=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}h(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),d=o.noop,u=s.distribute,c=n.series,f=n.seriesTypes.column,g=l.addEvent,v=l.defined,x=l.extend,m=l.isNumber,y=l.merge,b=l.objectEach,M=l.wrap,S=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return p(o,t),o.prototype.animate=function(t){t&&this.setClip()},o.prototype.drawPoints=function(){var t,i,e,o,r,s,n,l,h,p,d,c,f,g=this.points,x=this.chart,S=x.renderer,A=x.inverted,k=this.options,C=k.y,w=this.yAxis,D={},O=[],E=m(k.borderRadius)?k.borderRadius:0;for(s=g.length;s--;)n=g[s],c=(A?n.plotY:n.plotX)>this.xAxis.len,e=n.plotX,h=n.stackIndex,r=n.options.shape||k.shape,void 0!==(o=n.plotY)&&(o=n.plotY+C-(void 0!==h&&h*k.stackDistance)),n.anchorX=h?void 0:n.plotX,p=h?void 0:n.plotY,f="flag"!==r,l=n.graphic,void 0!==o&&e>=0&&!c?(l&&n.hasNewShapeType()&&(l=l.destroy()),l||(l=n.graphic=S.label("",0,void 0,r,void 0,void 0,k.useHTML).addClass("highcharts-point").add(this.markerGroup),n.graphic.div&&(n.graphic.div.point=n),l.isNew=!0),l.attr({align:f?"center":"left",width:k.width,height:k.height,"text-align":k.textAlign,r:E}),x.styledMode||l.attr(this.pointAttribs(n)).css(y(k.style,n.style)).shadow(k.shadow),e>0&&(e-=l.strokeWidth()%2),d={y:o,anchorY:p},k.allowOverlapX&&(d.x=e,d.anchorX=n.anchorX),l.attr({text:null!==(i=null!==(t=n.options.title)&&void 0!==t?t:k.title)&&void 0!==i?i:"A"})[l.isNew?"attr":"animate"](d),k.allowOverlapX||(D[n.plotX]?D[n.plotX].size=Math.max(D[n.plotX].size,l.width||0):D[n.plotX]={align:f?.5:0,size:l.width||0,target:e,anchorX:e}),n.tooltipPos=[e,o+w.pos-x.plotTop]):l&&(n.graphic=l.destroy());if(!k.allowOverlapX){var P=100;b(D,function(t){t.plotX=t.anchorX,O.push(t),P=Math.max(t.size,P)}),u(O,A?w.len:this.xAxis.len,P);for(var B=0;B<g.length;B++){var T=g[B],j=T.plotX,G=T.graphic,R=G&&D[j];R&&G&&(v(R.pos)?G[G.isNew?"attr":"animate"]({x:R.pos+(R.align||0)*R.size,anchorX:T.anchorX}).show().isNew=!1:G.hide().isNew=!0)}}k.useHTML&&this.markerGroup&&M(this.markerGroup,"on",function(t){return a.prototype.on.apply(t.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},o.prototype.drawTracker=function(){var i=this.points;t.prototype.drawTracker.call(this);for(var e=function(t){var e=t.graphic;e&&(t.unbindMouseOver&&t.unbindMouseOver(),t.unbindMouseOver=g(e.element,"mouseover",function(){t.stackIndex>0&&!t.raised&&(t._y=e.y,e.attr({y:t._y-8}),t.raised=!0);for(var o=0;o<i.length;o++){var r=i[o];r!==t&&r.raised&&r.graphic&&(r.graphic.attr({y:r._y}),r.raised=!1)}}))},o=0;o<i.length;o++)e(i[o])},o.prototype.pointAttribs=function(t,i){var e=this.options,o=t&&t.color||this.color,r=e.lineColor,s=t&&t.lineWidth,n=t&&t.fillColor||e.fillColor;return i&&(n=e.states[i].fillColor,r=e.states[i].lineColor,s=e.states[i].lineWidth),{fill:n||o,stroke:r||o,"stroke-width":s||e.lineWidth||0}},o.prototype.setClip=function(){c.prototype.setClip.apply(this,arguments),!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},o.compose=e.compose,o.defaultOptions=y(f.defaultOptions,i),o}(f);return r.compose(S),x(S.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:t,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:d,init:c.prototype.init}),n.registerSeriesType("flags",S),S}),e(i,"Core/Axis/BrokenAxis.js",[i["Core/Axis/Stacking/StackItem.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.find,s=i.fireEvent,n=i.isArray,a=i.isNumber,l=i.pick;return function(i){function e(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function h(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function p(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var i=this.tickPositions,e=this.tickPositions.info,o=[],r=0;r<i.length;r++)t.isInAnyBreak(i[r])||o.push(i[r]);this.tickPositions=o,this.tickPositions.info=e}}function d(){this.brokenAxis||(this.brokenAxis=new v(this))}function u(){var t,i,e=this.isDirty,o=this.options.connectNulls,r=this.points,s=this.xAxis,n=this.yAxis;if(e)for(var a=r.length;a--;){var l=r[a],h=!(null===l.y&&!1===o)&&((null===(t=null==s?void 0:s.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(l.x,!0))||(null===(i=null==n?void 0:n.brokenAxis)||void 0===i?void 0:i.isInAnyBreak(l.y,!0)));l.visible=!h&&!1!==l.options.visible}}function c(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,l(this.pointArrayMap,["y"]))}function f(t,i){var e,o,r,n,h=this,p=h.points;if(null===(e=null==t?void 0:t.brokenAxis)||void 0===e?void 0:e.hasBreaks){var d=t.brokenAxis;i.forEach(function(i){o=(null==d?void 0:d.breakArray)||[],r=t.isXAxis?t.min:l(h.options.threshold,t.min);var e,u,c=null===(u=null===(e=null==t?void 0:t.options)||void 0===e?void 0:e.breaks)||void 0===u?void 0:u.filter(function(t){for(var i=!0,e=0;e<o.length;e++){var r=o[e];if(r.from===t.from&&r.to===t.to){i=!1;break}}return i});p.forEach(function(e){n=l(e["stack"+i.toUpperCase()],e[i]),o.forEach(function(i){if(a(r)&&a(n)){var o="";r<i.from&&n>i.to||r>i.from&&n<i.from?o="pointBreak":(r<i.from&&n>i.from&&n<i.to||r>i.from&&n>i.to&&n<i.from)&&(o="pointInBreak"),o&&s(t,o,{point:e,brk:i})}}),null==c||c.forEach(function(i){s(t,"pointOutsideOfBreak",{point:e,brk:i})})})})}}function g(){var i=this.currentDataGrouping,e=null==i?void 0:i.gapSize,o=this.points.slice(),r=this.yAxis,s=this.options.gapSize,n=o.length-1;if(s&&n>0){"value"!==this.options.gapUnit&&(s*=this.basePointRange),e&&e>s&&e>=this.basePointRange&&(s=e);for(var a=void 0,l=void 0;n--;)if(l&&!1!==l.visible||(l=o[n+1]),a=o[n],!1!==l.visible&&!1!==a.visible){if(l.x-a.x>s){var h=(a.x+l.x)/2;o.splice(n+1,0,{isNull:!0,x:h}),r.stacking&&this.options.stacking&&((r.stacking.stacks[this.stackKey][h]=new t(r,r.options.stackLabels,!1,h,this.stack)).total=0)}l=a}}return this.getGraphPath(o)}i.compose=function(t,i){if(!t.keepProps.includes("brokenAxis")){t.keepProps.push("brokenAxis"),o(t,"init",d),o(t,"afterInit",e),o(t,"afterSetTickPositions",p),o(t,"afterSetOptions",h);var r=i.prototype;r.drawBreaks=f,r.gappedPath=g,o(i,"afterGeneratePoints",u),o(i,"afterRender",c)}return t};var v=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,i){var e=t.repeat||1/0,o=t.from,r=t.to-t.from,s=i>=o?(i-o)%e:e-(o-i)%e;return t.inclusive?s<=r:s<r&&0!==s},t.lin2Val=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length&&!((r=o[s]).from>=n);s++)r.to<n?n+=r.len:t.isInBreak(r,n)&&(n+=r.len);return n},t.val2Lin=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length;s++)if((r=o[s]).to<=i)n-=r.len;else if(r.from>=i)break;else if(t.isInBreak(r,i)){n-=i-r.from;break}return n},t.prototype.findBreakAt=function(t,i){return r(i,function(i){return i.from<t&&t<i.to})},t.prototype.isInAnyBreak=function(i,e){var o,r,s,n=this.axis,h=n.options.breaks||[],p=h.length;if(p&&a(i)){for(;p--;)t.isInBreak(h[p],i)&&(o=!0,r||(r=l(h[p].showPoints,!n.isXAxis)));s=o&&e?o&&!r:o}return s},t.prototype.setBreaks=function(i,e){var o=this,r=o.axis,h=n(i)&&!!i.length&&!!Object.keys(i[0]).length;r.isDirty=o.hasBreaks!==h,o.hasBreaks=h,i!==r.options.breaks&&(r.options.breaks=r.userOptions.breaks=i),r.forceRedraw=!0,r.series.forEach(function(t){t.isDirty=!0}),h||r.val2lin!==t.val2Lin||(delete r.val2lin,delete r.lin2val),h&&(r.userOptions.ordinal=!1,r.lin2val=t.lin2Val,r.val2lin=t.val2Lin,r.setExtremes=function(t,i,e,s,n){if(o.hasBreaks){for(var a=this.options.breaks||[],l=void 0;l=o.findBreakAt(t,a);)t=l.to;for(;l=o.findBreakAt(i,a);)i=l.from;i<t&&(i=t)}r.constructor.prototype.setExtremes.call(this,t,i,e,s,n)},r.setAxisTranslation=function(){if(r.constructor.prototype.setAxisTranslation.call(this),o.unitLength=void 0,o.hasBreaks){var i,e,n,h,p=r.options.breaks||[],d=[],u=[],c=l(r.pointRangePadding,0),f=0,g=r.userMin||r.min,v=r.userMax||r.max;p.forEach(function(i){e=i.repeat||1/0,a(g)&&a(v)&&(t.isInBreak(i,g)&&(g+=i.to%e-g%e),t.isInBreak(i,v)&&(v-=v%e-i.from%e))}),p.forEach(function(t){if(n=t.from,e=t.repeat||1/0,a(g)&&a(v)){for(;n-e>g;)n-=e;for(;n<g;)n+=e;for(h=n;h<v;h+=e)d.push({value:h,move:"in"}),d.push({value:h+t.to-t.from,move:"out",size:t.breakSize})}}),d.sort(function(t,i){return t.value===i.value?("in"===t.move?0:1)-("in"===i.move?0:1):t.value-i.value}),i=0,n=g,d.forEach(function(t){1===(i+="in"===t.move?1:-1)&&"in"===t.move&&(n=t.value),0===i&&a(n)&&(u.push({from:n,to:t.value,len:t.value-n-(t.size||0)}),f+=t.value-n-(t.size||0))}),o.breakArray=u,a(g)&&a(v)&&a(r.min)&&(o.unitLength=v-g-f+c,s(r,"afterBreaks"),r.staticScale?r.transA=r.staticScale:o.unitLength&&(r.transA*=(v-r.min+c)/o.unitLength),c&&(r.minPixelPadding=r.transA*(r.minPointOffset||0)),r.min=g,r.max=v)}}),l(e,!0)&&r.chart.redraw()},t}();i.Additions=v}(e||(e={})),e}),e(i,"masters/modules/broken-axis.src.js",[i["Core/Globals.js"],i["Core/Axis/BrokenAxis.js"]],function(t,i){return t.BrokenAxis=t.BrokenAxis||i,t.BrokenAxis.compose(t.Axis,t.Series),t}),e(i,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),e(i,"Extensions/DataGrouping/ApproximationDefaults.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e=i.arrayMax,o=i.arrayMin,r=i.correctFloat,s=i.extend,n=i.isNumber;function a(t){var i=t.length,e=l(t);return n(e)&&i&&(e=r(e/i)),e}function l(t){var i,e=t.length;if(!e&&t.hasNulls)i=null;else if(e)for(i=0;e--;)i+=t[e];return i}var h={average:a,averages:function(){var t=[];return[].forEach.call(arguments,function(i){t.push(a(i))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?e(t):t.hasNulls?null:void 0},hlc:function(i,e,o){if(i=t.high(i),e=t.low(e),o=t.close(o),n(i)||n(e)||n(o))return[i,e,o]},low:function(t){return t.length?o(t):t.hasNulls?null:void 0},ohlc:function(i,e,o,r){if(i=t.open(i),e=t.high(e),o=t.low(o),r=t.close(r),n(i)||n(e)||n(o)||n(r))return[i,e,o,r]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(i,e){return(i=t.low(i),e=t.high(e),n(i)||n(e))?[i,e]:null===i&&null===e?null:void 0},sum:l};return s(t,h),h}),e(i,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),e(i,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.extend,s=i.merge,n=i.pick;function a(t){var i=this,e=i.series;e.forEach(function(t){t.groupPixelWidth=void 0}),e.forEach(function(e){e.groupPixelWidth=i.getGroupPixelWidth&&i.getGroupPixelWidth(),e.groupPixelWidth&&(e.hasProcessed=!0),e.applyGrouping(!!t.hasExtremesChanged)})}function l(){for(var i,e,o=this.series,r=o.length,s=0,a=!1;r--;)(e=o[r].options.dataGrouping)&&(s=Math.max(s,n(e.groupPixelWidth,t.common.groupPixelWidth)),i=(o[r].processedXData||o[r].data).length,(o[r].groupPixelWidth||i>this.chart.plotSizeX/s||i&&e.forced)&&(a=!0));return a?s:0}function h(){this.series.forEach(function(t){t.hasProcessed=!1})}function p(t,i){var o;if(i=n(i,!0),t||(t={forced:!1,units:null}),this instanceof e)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(i){i.dataGrouping="boolean"==typeof t?t:s(t,i.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),i&&this.chart.redraw()}return{compose:function(t){e=t;var i=t.prototype;i.applyGrouping||(o(t,"afterSetScale",h),o(t,"postProcessData",a),r(i,{applyGrouping:a,getGroupPixelWidth:l,setDataGrouping:p}))}}}),e(i,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Axis/DateTimeAxis.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=r.series.prototype,a=s.addEvent,l=s.defined,h=s.error,p=s.extend,d=s.isNumber,u=s.merge,c=s.pick,f=n.generatePoints;function g(t){var o,r,s,a,p=this.chart,u=this.options.dataGrouping,f=!1!==this.allowDG&&u&&c(u.enabled,p.options.isStock),g=this.reserveSpace(),v=this.currentDataGrouping,x=!1;f&&!this.requireSorting&&(this.requireSorting=x=!0);var m=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!f;if(x&&(this.requireSorting=!1),!m){this.destroyGroupedData();var y=u.groupAll?this.xData:this.processedXData,b=u.groupAll?this.yData:this.processedYData,M=p.plotSizeX,S=this.xAxis,A=S.options.ordinal,k=this.groupPixelWidth;if(k&&y&&y.length&&M){r=!0,this.isDirty=!0,this.points=null;var C,w=S.getExtremes(),D=w.min,O=w.max,E=A&&S.ordinal&&S.ordinal.getGroupIntervalFactor(D,O,this)||1,P=k*(O-D)/M*E,B=S.getTimeTicks(e.Additions.prototype.normalizeTimeTickInterval(P,u.units||i.units),Math.min(D,y[0]),Math.max(O,y[y.length-1]),S.options.startOfWeek,y,this.closestPointRange),T=n.groupData.apply(this,[y,b,B,u.approximation]),j=T.groupedXData,G=T.groupedYData,R=0;for(u&&u.smoothed&&j.length&&(u.firstAnchor="firstPoint",u.anchor="middle",u.lastAnchor="lastPoint",h(32,!1,p,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),o=1;o<B.length;o++)B.info.segmentStarts&&-1!==B.info.segmentStarts.indexOf(o)||(R=Math.max(B[o]-B[o-1],R));(s=B.info).gapSize=R,this.closestPointRange=B.info.totalRange,this.groupMap=T.groupMap,this.currentDataGrouping=s,function(t,i,e){var o=t.options.dataGrouping,r=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(o&&t.xData&&r&&t.groupMap){var s=i.length-1,n=o.anchor,a=o.firstAnchor,l=o.lastAnchor,h=i.length-1,p=0;if(a&&t.xData[0]>=i[0]){p++;var u=t.groupMap[0].start,c=t.groupMap[0].length,f=void 0;d(u)&&d(c)&&(f=u+(c-1)),i[0]=({start:i[0],middle:i[0]+.5*r,end:i[0]+r,firstPoint:t.xData[0],lastPoint:f&&t.xData[f]})[a]}if(s>0&&l&&r&&i[s]>=e-r){h--;var g=t.groupMap[t.groupMap.length-1].start;i[s]=({start:i[s],middle:i[s]+.5*r,end:i[s]+r,firstPoint:g&&t.xData[g],lastPoint:t.xData[t.xData.length-1]})[l]}if(n&&"start"!==n)for(var v=r*({middle:.5,end:1})[n];h>=p;)i[h]+=v,h--}}(this,j,O),g&&(l((C=j)[0])&&d(S.min)&&d(S.dataMin)&&C[0]<S.min&&((!l(S.options.min)&&S.min<=S.dataMin||S.min===S.dataMin)&&(S.min=Math.min(C[0],S.min)),S.dataMin=Math.min(C[0],S.dataMin)),l(C[C.length-1])&&d(S.max)&&d(S.dataMax)&&C[C.length-1]>S.max&&((!l(S.options.max)&&d(S.dataMax)&&S.max>=S.dataMax||S.max===S.dataMax)&&(S.max=Math.max(C[C.length-1],S.max)),S.dataMax=Math.max(C[C.length-1],S.dataMax))),u.groupAll&&(this.allGroupedData=G,j=(a=this.cropData(j,G,S.min,S.max)).xData,G=a.yData,this.cropStart=a.start),this.processedXData=j,this.processedYData=G}else this.groupMap=null,this.currentDataGrouping=void 0;this.hasGroupedData=r,this.preventGraphAnimation=(v&&v.totalRange)!==(s&&s.totalRange)}}function v(){this.groupedData&&(this.groupedData.forEach(function(t,i){t&&(this.groupedData[i]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function x(){f.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function m(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function y(i,e,o,r){var s,n,a,h=this,p=h.data,c=h.options&&h.options.data,f=[],g=[],v=[],x=i.length,m=!!e,y=[],b=h.pointArrayMap,M=b&&b.length,S=["x"].concat(b||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,C=0,w="function"==typeof r?r:r&&t[r]?t[r]:t[h.getDGApproximation&&h.getDGApproximation()||"average"];if(M)for(var D=b.length;D--;)y.push([]);else y.push([]);for(var O=M||1,E=0;E<=x;E++)if(!(i[E]<o[0])){for(;void 0!==o[k+1]&&i[E]>=o[k+1]||E===x;){s=o[k],h.dataGroupInfo={start:A?C:h.cropStart+C,length:y[0].length,groupStart:s},a=w.apply(h,y),h.pointClass&&!l(h.dataGroupInfo.options)&&(h.dataGroupInfo.options=u(h.pointClass.prototype.optionsToObject.call({series:h},h.options.data[h.cropStart+C])),S.forEach(function(t){delete h.dataGroupInfo.options[t]})),void 0!==a&&(f.push(s),g.push(a),v.push(h.dataGroupInfo)),C=E;for(var P=0;P<O;P++)y[P].length=0,y[P].hasNulls=!1;if(k+=1,E===x)break}if(E===x)break;if(b)for(var B=h.options.dataGrouping&&h.options.dataGrouping.groupAll?E:h.cropStart+E,T=p&&p[B]||h.pointClass.prototype.applyOptions.apply({series:h},[c[B]]),j=void 0,P=0;P<M;P++)d(j=T[b[P]])?y[P].push(j):null===j&&(y[P].hasNulls=!0);else d(n=m?e[E]:null)?y[0].push(n):null===n&&(y[0].hasNulls=!0)}return{groupedXData:f,groupedYData:g,groupMap:v}}function b(t){var e=t.options,r=this.type,s=this.chart.options.plotOptions,n=this.useCommonDataGrouping&&i.common,a=i.seriesSpecific,l=o.defaultOptions.plotOptions[r].dataGrouping;if(s&&(a[r]||n)){var h=this.chart.rangeSelector;l||(l=u(i.common,a[r])),e.dataGrouping=u(n,l,s.series&&s.series.dataGrouping,s[r].dataGrouping,this.userOptions.dataGrouping,!e.isInternal&&h&&d(h.selected)&&h.buttonOptions[h.selected].dataGrouping)}}return{compose:function(t){var i=t.prototype;i.applyGrouping||(a(t.prototype.pointClass,"update",function(){if(this.dataGroup)return h(24,!1,this.series.chart),!1}),a(t,"afterSetOptions",b),a(t,"destroy",v),p(i,{applyGrouping:g,destroyGroupedData:v,generatePoints:x,getDGApproximation:m,groupData:y}))},groupData:y}}),e(i,"Extensions/DataGrouping/DataGrouping.js",[i["Extensions/DataGrouping/DataGroupingAxisComposition.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],i["Core/Templating.js"],i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=o.format,a=r.composed,l=s.addEvent,h=s.extend,p=s.isNumber,d=s.pick,u=s.pushUnique;function c(t){var e,o,r,s,a,l,u=this.chart,c=u.time,f=t.labelConfig,g=f.series,v=f.point,x=g.options,m=g.tooltipOptions,y=x.dataGrouping,b=g.xAxis,M=m.xDateFormat,S=m[t.isFooter?"footerFormat":"headerFormat"];if(b&&"datetime"===b.options.type&&y&&p(f.key)){r=g.currentDataGrouping,s=y.dateTimeLabelFormats||i.common.dateTimeLabelFormats,r?(a=s[r.unitName],1===r.count?M=a[0]:(M=a[1],o=a[2])):!M&&s&&b.dateTime&&(M=b.dateTime.getXDateFormat(f.x,m.dateTimeLabelFormats));var A=d(null===(e=g.groupMap)||void 0===e?void 0:e[v.index].groupStart,f.key),k=A+(null==r?void 0:r.totalRange)-1;l=c.dateFormat(M,A),o&&(l+=c.dateFormat(o,k)),g.chart.styledMode&&(S=this.styledModeFormat(S)),t.text=n(S,{point:h(f.point,{key:l}),series:g},u),t.preventDefault()}}return{compose:function(i,o,r){t.compose(i),e.compose(o),r&&u(a,"DataGrouping")&&l(r,"headerFormatter",c)},groupData:e.groupData}}),e(i,"masters/modules/datagrouping.src.js",[i["Core/Globals.js"],i["Extensions/DataGrouping/ApproximationDefaults.js"],i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGrouping.js"]],function(t,i,e,o){return t.dataGrouping=t.dataGrouping||{},t.dataGrouping.approximationDefaults=t.dataGrouping.approximationDefaults||i,t.dataGrouping.approximations=t.dataGrouping.approximations||e,o.compose(t.Axis,t.Series,t.Tooltip),t}),e(i,"Extensions/Annotations/NavigationBindingsUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined,e=t.isNumber,o=t.pick,r={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:r,getAssignedAxis:function(t){return t.filter(function(t){var i=t.axis.getExtremes(),r=i.min,s=i.max,n=o(t.axis.minPointOffset,0);return e(r)&&e(s)&&t.value>=r-n&&t.value<=s+n&&!t.axis.options.isInternal})[0]},getFieldType:function(t,e){var o=r[t],s=typeof e;return i(o)&&(s=o),({string:"text",number:"number",boolean:"checkbox"})[s]}}}),e(i,"Extensions/MouseWheelZoom/MouseWheelZoom.js",[i["Core/Utilities.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"]],function(t,i){var e,o=t.addEvent,r=t.isObject,s=t.pick,n=t.defined,a=t.merge,l=i.getAssignedAxis,h=[],p={enabled:!0,sensitivity:1.1},d=function(t,i,o,r,a,l,h){var p=s(h.type,t.zooming.type,""),d=[];"x"===p?d=o:"y"===p?d=r:"xy"===p&&(d=t.axes);var u=t.transform({axes:d,to:{x:a-5,y:l-5,width:10,height:10},from:{x:a-5*i,y:l-5*i,width:10*i,height:10*i},trigger:"mousewheel"});return u&&(n(e)&&clearTimeout(e),e=setTimeout(function(){var i;null===(i=t.pointer)||void 0===i||i.drop()},400)),u};function u(){var t,i=this,e=(r(t=this.zooming.mouseWheel)||(t={enabled:null==t||t}),a(p,t));e.enabled&&o(this.container,"wheel",function(t){t=(null===(o=i.pointer)||void 0===o?void 0:o.normalize(t))||t;var o,r,s=i.pointer,n=s&&!s.inClass(t.target,"highcharts-no-mousewheel");if(i.isInsidePlot(t.chartX-i.plotLeft,t.chartY-i.plotTop)&&n){var a=e.sensitivity||1.1,h=t.detail||(t.deltaY||0)/120,p=l(s.getCoordinates(t).xAxis),u=l(s.getCoordinates(t).yAxis);d(i,Math.pow(a,h),p?[p.axis]:i.xAxis,u?[u.axis]:i.yAxis,t.chartX,t.chartY,e)&&(null===(r=t.preventDefault)||void 0===r||r.call(t))}})}return{compose:function(t){-1===h.indexOf(t)&&(h.push(t),o(t,"afterGetContainer",u))}}}),e(i,"masters/modules/mouse-wheel-zoom.src.js",[i["Core/Globals.js"],i["Extensions/MouseWheelZoom/MouseWheelZoom.js"]],function(t,i){return t.MouseWheelZoom=t.MouseWheelZoom||i,t.MouseWheelZoom.compose(t.Chart),t}),e(i,"masters/modules/stock.src.js",[i["Core/Globals.js"],i["Series/DataModifyComposition.js"],i["Stock/Navigator/Navigator.js"],i["Core/Axis/OrdinalAxis.js"],i["Stock/RangeSelector/RangeSelector.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Chart/StockChart.js"],i["Series/OHLC/OHLCSeries.js"],i["Series/Flags/FlagsSeries.js"]],function(t,i,e,o,r,s,n,a,l){return t.Navigator=t.Navigator||e,t.OrdinalAxis=t.OrdinalAxis||o,t.RangeSelector=t.RangeSelector||r,t.Scrollbar=t.Scrollbar||s,t.stockChart=t.stockChart||n.stockChart,t.StockChart=t.StockChart||t.stockChart,t.extend(t.StockChart,n),i.compose(t.Series,t.Axis,t.Point),l.compose(t.Renderer),a.compose(t.Series),t.Navigator.compose(t.Chart,t.Axis,t.Series),t.OrdinalAxis.compose(t.Axis,t.Series,t.Chart),t.RangeSelector.compose(t.Axis,t.Chart),t.Scrollbar.compose(t.Axis),t.StockChart.compose(t.Chart,t.Axis,t.Series,t.SVGRenderer),t})});