!/**
 * Highstock JS v11.4.6 (2024-07-08)
 *
 * Advanced Highcharts Stock tools
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock-tools",["highcharts","highcharts/modules/stock"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(i,e,s,n){i.hasOwnProperty(e)||(i[e]=n.apply(null,s),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:i[e]}})))}e(i,"Core/Chart/ChartNavigationComposition.js",[],function(){var t,i,e;return(i=t||(t={})).compose=function(t){return t.navigation||(t.navigation=new e(t)),t},e=function(){function t(t){this.updates=[],this.chart=t}return t.prototype.addUpdate=function(t){this.chart.navigation.updates.push(t)},t.prototype.update=function(t,i){var e=this;this.updates.forEach(function(s){s.call(e.chart,t,i)})},t}(),i.Additions=e,t}),e(i,"Extensions/Annotations/NavigationBindingsDefaults.js",[i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Utilities.js"]],function(t,i){var e=t.getAssignedAxis,s=i.isNumber,n=i.merge;return{lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(t){var i,s=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=s&&e(s.xAxis),a=s&&e(s.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(n({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:o.value,y:a.value,xAxis:o.axis.index,yAxis:a.axis.index},r:5}]},r.annotationsOptions,r.bindings.circleAnnotation.annotationsOptions))},steps:[function(t,i){var e,n=i.options.shapes,o=n&&n[0]&&n[0].point||{};if(s(o.xAxis)&&s(o.yAxis)){var a=this.chart.inverted,r=this.chart.xAxis[o.xAxis].toPixels(o.x),l=this.chart.yAxis[o.yAxis].toPixels(o.y);e=Math.max(Math.sqrt(Math.pow(a?l-t.chartX:r-t.chartX,2)+Math.pow(a?r-t.chartY:l-t.chartY,2)),5)}i.update({shapes:[{r:e}]})}]},ellipseAnnotation:{className:"highcharts-ellipse-annotation",start:function(t){var i,s=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=s&&e(s.xAxis),a=s&&e(s.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(n({langKey:"ellipse",type:"basicAnnotation",shapes:[{type:"ellipse",xAxis:o.axis.index,yAxis:a.axis.index,points:[{x:o.value,y:a.value},{x:o.value,y:a.value}],ry:1}]},r.annotationsOptions,r.bindings.ellipseAnnotation.annotationOptions))},steps:[function(t,i){var e=i.shapes[0],s=e.getAbsolutePosition(e.points[1]);e.translatePoint(t.chartX-s.x,t.chartY-s.y,1),e.redraw(!1)},function(t,i){var e=i.shapes[0],s=e.getAbsolutePosition(e.points[0]),n=e.getAbsolutePosition(e.points[1]),o=e.getDistanceFromLine(s,n,t.chartX,t.chartY),a=e.getYAxis(),r=Math.abs(a.toValue(0)-a.toValue(o));e.setYRadius(r),e.redraw(!1)}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(t){var i,s=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=s&&e(s.xAxis),a=s&&e(s.yAxis);if(o&&a){var r=o.value,l=a.value,c=o.axis.index,h=a.axis.index,p=this.chart.options.navigation;return this.chart.addAnnotation(n({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{command:"Z"}]}]},p.annotationsOptions,p.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(t,i){var s,n=i.options.shapes,o=n&&n[0]&&n[0].points||[],a=null===(s=this.chart.pointer)||void 0===s?void 0:s.getCoordinates(t),r=a&&e(a.xAxis),l=a&&e(a.yAxis);if(r&&l){var c=r.value,h=l.value;o[1].x=c,o[2].x=c,o[2].y=h,o[3].y=h,i.update({shapes:[{points:o}]})}}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(t){var i,s=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=s&&e(s.xAxis),a=s&&e(s.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(n({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}",overflow:"none",crop:!0},labels:[{point:{xAxis:o.axis.index,yAxis:a.axis.index,x:o.value,y:a.value}}]},r.annotationsOptions,r.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}}}),e(i,"Extensions/Annotations/NavigationBindings.js",[i["Core/Chart/ChartNavigationComposition.js"],i["Core/Defaults.js"],i["Core/Templating.js"],i["Core/Globals.js"],i["Extensions/Annotations/NavigationBindingsDefaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,s,n,o,a){var r=i.setOptions,l=e.format,c=s.composed,h=s.doc,p=s.win,d=o.getAssignedAxis,u=o.getFieldType,g=a.addEvent,v=a.attr,y=a.defined,m=a.fireEvent,f=a.isArray,x=a.isFunction,b=a.isNumber,k=a.isObject,A=a.merge,C=a.objectEach,w=a.pick,N=a.pushUnique;function T(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()}function O(){this.navigationBindings&&this.navigationBindings.destroy()}function S(){var t=this.options;t&&t.navigation&&t.navigation.bindings&&(this.navigationBindings=new W(this,t.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())}function L(){var t=this.navigationBindings,i="highcharts-disabled-btn";if(this&&t){var e=!1;if(this.series.forEach(function(t){!t.options.isInternal&&t.visible&&(e=!0)}),this.navigationBindings&&this.navigationBindings.container&&this.navigationBindings.container[0]){var s=this.navigationBindings.container[0];C(t.boundClassNames,function(t,n){var o=s.querySelectorAll("."+n);if(o)for(var a=0;a<o.length;a++){var r=o[a],l=r.className;"normal"===t.noDataState?-1!==l.indexOf(i)&&r.classList.remove(i):e?-1!==l.indexOf(i)&&r.classList.remove(i):-1===l.indexOf(i)&&(r.className+=" "+i)}})}}}function B(){this.deselectAnnotation()}function E(){this.selectedButtonElement=null}function I(t){var i,e,s=t.prototype.defaultOptions.events&&t.prototype.defaultOptions.events.click;function n(t){var i=this,e=i.chart.navigationBindings,n=e.activeAnnotation;s&&s.call(i,t),n!==i?(e.deselectAnnotation(),e.activeAnnotation=i,i.setControlPointsVisibility(!0),m(e,"showPopup",{annotation:i,formType:"annotation-toolbar",options:e.annotationToFields(i),onSubmit:function(t){if("remove"===t.actionType)e.activeAnnotation=!1,e.chart.removeAnnotation(i);else{var s={};e.fieldsToOptions(t.fields,s),e.deselectAnnotation();var n=s.typeOptions;"measure"===i.options.type&&(n.crosshairY.enabled=0!==n.crosshairY.strokeWidth,n.crosshairX.enabled=0!==n.crosshairX.strokeWidth),i.update(s)}}})):m(e,"closePopup"),t.activeAnnotation=!0}A(!0,t.prototype.defaultOptions.events,{click:n,touchstart:function(t){i=t.touches[0].clientX,e=t.touches[0].clientY},touchend:function(t){i&&Math.sqrt(Math.pow(i-t.changedTouches[0].clientX,2)+Math.pow(e-t.changedTouches[0].clientY,2))>=4||n.call(this,t)}})}var W=function(){function i(t,i){this.boundClassNames=void 0,this.chart=t,this.options=i,this.eventsToUnbind=[],this.container=this.chart.container.getElementsByClassName(this.options.bindingsClassName||""),this.container.length||(this.container=h.getElementsByClassName(this.options.bindingsClassName||""))}return i.compose=function(t,e){N(c,"NavigationBindings")&&(g(t,"remove",T),I(t),C(t.types,function(t){I(t)}),g(e,"destroy",O),g(e,"load",S),g(e,"render",L),g(i,"closePopup",B),g(i,"deselectButton",E),r(n))},i.prototype.getCoords=function(t){var i,e=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t);return[e&&d(e.xAxis),e&&d(e.yAxis)]},i.prototype.initEvents=function(){var t=this,i=t.chart,e=t.container,n=t.options;t.boundClassNames={},C(n.bindings||{},function(i){t.boundClassNames[i.className]=i}),[].forEach.call(e,function(i){t.eventsToUnbind.push(g(i,"click",function(e){var s=t.getButtonEvents(i,e);s&&!s.button.classList.contains("highcharts-disabled-btn")&&t.bindingsButtonClick(s.button,s.events,e)}))}),C(n.events||{},function(i,e){x(i)&&t.eventsToUnbind.push(g(t,e,i,{passive:!1}))}),t.eventsToUnbind.push(g(i.container,"click",function(e){!i.cancelClick&&i.isInsidePlot(e.chartX-i.plotLeft,e.chartY-i.plotTop,{visiblePlotOnly:!0})&&t.bindingsChartClick(this,e)})),t.eventsToUnbind.push(g(i.container,s.isTouchDevice?"touchmove":"mousemove",function(i){t.bindingsContainerMouseMove(this,i)},s.isTouchDevice?{passive:!1}:void 0))},i.prototype.initUpdate=function(){var i=this;t.compose(this.chart).navigation.addUpdate(function(t){i.update(t)})},i.prototype.bindingsButtonClick=function(t,i,e){var s=this.chart,n=s.renderer.boxWrapper,o=!0;this.selectedButtonElement&&(this.selectedButtonElement.classList===t.classList&&(o=!1),m(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&s.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1)),o?(this.selectedButton=i,this.selectedButtonElement=t,m(this,"selectButton",{button:t}),i.init&&i.init.call(this,t,e),(i.start||i.steps)&&s.renderer.boxWrapper.addClass("highcharts-draw-mode")):(s.stockTools&&t.classList.remove("highcharts-active"),n.removeClass("highcharts-draw-mode"),this.nextEvent=!1,this.mouseMoveEvent=!1,this.selectedButton=null)},i.prototype.bindingsChartClick=function(t,i){t=this.chart;var e=this.activeAnnotation,s=this.selectedButton,n=t.renderer.boxWrapper;e&&(e.cancelClick||i.activeAnnotation||!i.target.parentNode||function(t,i){var e=p.Element.prototype,s=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,n=null;if(e.closest)n=e.closest.call(t,i);else do{if(s.call(t,i))return t;t=t.parentElement||t.parentNode}while(null!==t&&1===t.nodeType);return n}(i.target,".highcharts-popup")?e.cancelClick&&setTimeout(function(){e.cancelClick=!1},0):m(this,"closePopup")),s&&s.start&&(this.nextEvent?(this.nextEvent(i,this.currentUserDetails),this.steps&&(this.stepIndex++,s.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=s.steps[this.stepIndex]:(m(this,"deselectButton",{button:this.selectedButtonElement}),n.removeClass("highcharts-draw-mode"),s.end&&s.end.call(this,i,this.currentUserDetails),this.nextEvent=!1,this.mouseMoveEvent=!1,this.selectedButton=null))):(this.currentUserDetails=s.start.call(this,i),this.currentUserDetails&&s.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=s.steps[this.stepIndex]):(m(this,"deselectButton",{button:this.selectedButtonElement}),n.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,s.end&&s.end.call(this,i,this.currentUserDetails))))},i.prototype.bindingsContainerMouseMove=function(t,i){this.mouseMoveEvent&&this.mouseMoveEvent(i,this.currentUserDetails)},i.prototype.fieldsToOptions=function(t,i){return C(t,function(t,e){var s=parseFloat(t),n=e.split("."),o=n.length-1;if(!b(s)||t.match(/px|em/g)||e.match(/format/g)||(t=s),"undefined"!==t){var a=i;n.forEach(function(i,e){if("__proto__"!==i&&"constructor"!==i){var s=w(n[e+1],"");o===e?a[i]=t:(a[i]||(a[i]=s.match(/\d/g)?[]:{}),a=a[i])}})}}),i},i.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},i.prototype.annotationToFields=function(t){var e=t.options,s=i.annotationsEditable,n=s.nestedOptions,o=w(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,e.labels&&e.labels[0]&&e.labels[0].type,"label"),a=i.annotationsNonEditable[e.langKey]||[],r={langKey:e.langKey,type:o};function c(i,e,s,o,r){var h;s&&y(i)&&-1===a.indexOf(e)&&((s.indexOf&&s.indexOf(e))>=0||s[e]||!0===s)&&(f(i)?(o[e]=[],i.forEach(function(t,i){k(t)?(o[e][i]={},C(t,function(t,s){c(t,s,n[e],o[e][i],e)})):c(t,0,n[e],o[e],e)})):k(i)?(h={},f(o)?(o.push(h),h[e]={},h=h[e]):o[e]=h,C(i,function(t,i){c(t,i,0===e?s:n[e],h,e)})):"format"===e?o[e]=[l(i,t.labels[0].points[0]).toString(),"text"]:f(o)?o.push([i,u(r,i)]):o[e]=[i,u(e,i)])}return C(e,function(t,i){"typeOptions"===i?(r[i]={},C(e[i],function(t,e){c(t,e,n,r[i],e)})):c(t,i,s[o],r,i)}),r},i.prototype.getClickedClassNames=function(t,i){for(var e,s=i.target,n=[];s&&s.tagName&&((e=v(s,"class"))&&(n=n.concat(e.split(" ").map(function(t){return[t,s]}))),(s=s.parentNode)!==t););return n},i.prototype.getButtonEvents=function(t,i){var e,s=this;return this.getClickedClassNames(t,i).forEach(function(t){s.boundClassNames[t[0]]&&!e&&(e={events:s.boundClassNames[t[0]],button:t[1]})}),e},i.prototype.update=function(t){this.options=A(!0,this.options,t),this.removeEvents(),this.initEvents()},i.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(t){return t()})},i.prototype.destroy=function(){this.removeEvents()},i.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],ellipse:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},i.annotationsNonEditable={rectangle:["crosshairX","crosshairY","labelOptions"],ellipse:["labelOptions"],circle:["labelOptions"]},i}();return W}),e(i,"Stock/StockTools/StockToolsUtilities.js",[i["Core/Defaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,s){var n=t.getOptions,o=i.getAssignedAxis,a=i.getFieldType,r=s.defined,l=s.fireEvent,c=s.isNumber,h=s.uniqueKey,p=["apo","ad","aroon","aroonoscillator","atr","ao","cci","chaikin","cmf","cmo","disparityindex","dmi","dpo","linearRegressionAngle","linearRegressionIntercept","linearRegressionSlope","klinger","macd","mfi","momentum","natr","obv","ppo","roc","rsi","slowstochastic","stochastic","trix","williamsr"],d=["ad","cmf","klinger","mfi","obv","vbp","vwap"];function u(t,i){var e,s,n,a,r=null===(e=i.pointer)||void 0===e?void 0:e.getCoordinates(t),l=Number.MAX_VALUE;if(i.navigationBindings&&r&&(s=o(r.xAxis),n=o(r.yAxis)),s&&n){var c=s.value,h=n.value;if(n.axis.series.forEach(function(i){if(i.points){var e=i.searchPoint(t,!0);e&&l>Math.abs(e.x-c)&&(l=Math.abs(e.x-c),a=e)}}),a&&a.x&&a.y)return{x:a.x,y:a.y,below:h<a.y,series:a.series,xAxis:a.series.xAxis.index||0,yAxis:a.series.yAxis.index||0}}}return{indicatorsWithAxes:p,indicatorsWithVolume:d,addFlagFromForm:function(t){return function(i){var e=this,s=e.chart,n=s.stockTools,o=u(i,s);if(o){var r={x:o.x,y:o.y},c={type:"flags",onSeries:o.series.id,shape:t,data:[r],xAxis:o.xAxis,yAxis:o.yAxis,point:{events:{click:function(){var t=this,i=t.options;l(e,"showPopup",{point:t,formType:"annotation-toolbar",options:{langKey:"flags",type:"flags",title:[i.title,a("title",i.title)],name:[i.name,a("name",i.name)]},onSubmit:function(i){"remove"===i.actionType?t.remove():t.update(e.fieldsToOptions(i.fields,{}))}})}}}};n&&n.guiEnabled||s.addSeries(c),l(e,"showPopup",{formType:"flag",options:{langKey:"flags",type:"flags",title:["A",a("label","A")],name:["Flag A",a("label","Flag A")]},onSubmit:function(t){e.fieldsToOptions(t.fields,c.data[0]),s.addSeries(c)}})}}},attractToPoint:u,getAssignedAxis:o,isNotNavigatorYAxis:function(t){return"highcharts-navigator-yaxis"!==t.userOptions.className},isPriceIndicatorEnabled:function(t){return t.some(function(t){return t.lastVisiblePrice||t.lastPrice})},manageIndicators:function(t){var i,s,o,a,c=this.chart,u={linkedTo:t.linkedTo,type:t.type};if("edit"===t.actionType)this.fieldsToOptions(t.fields,u),(a=c.get(t.seriesId))&&a.update(u,!1);else if("remove"===t.actionType){if((a=c.get(t.seriesId))&&(i=a.yAxis,a.linkedSeries&&a.linkedSeries.forEach(function(t){t.remove(!1)}),a.remove(!1),p.indexOf(a.type)>=0)){var g={height:i.options.height,top:i.options.top};i.remove(!1),this.resizeYAxes(g)}}else u.id=h(),this.fieldsToOptions(t.fields,u),s=c.get(u.linkedTo),o=n().plotOptions,void 0!==s&&s instanceof e&&"sum"===s.getDGApproximation()&&!r(o&&o[u.type]&&o.dataGrouping&&o.dataGrouping.approximation)&&(u.dataGrouping={approximation:"sum"}),p.indexOf(t.type)>=0?(i=c.addAxis({id:h(),offset:0,opposite:!0,title:{text:""},tickPixelInterval:40,showLastLabel:!1,labels:{align:"left",y:-2}},!1,!1),u.yAxis=i.options.id,this.resizeYAxes()):u.yAxis=c.get(t.linkedTo).options.yAxis,d.indexOf(t.type)>=0&&(u.params.volumeSeriesID=c.series.filter(function(t){return"column"===t.options.type})[0].options.id),c.addSeries(u,!1);l(this,"deselectButton",{button:this.selectedButtonElement}),c.redraw()},shallowArraysEqual:function(t,i){if(!r(t)||!r(i)||t.length!==i.length)return!1;for(var e=0;e<t.length;e++)if(t[e]!==i[e])return!1;return!0},updateHeight:function(t,i){var e=i.options.typeOptions,s=c(e.yAxis)&&this.chart.yAxis[e.yAxis];s&&e.points&&i.update({typeOptions:{height:s.toValue(t[s.horiz?"chartX":"chartY"])-(e.points[1].y||0)}})},updateNthPoint:function(t){return function(i,e){var s=e.options.typeOptions,n=c(s.xAxis)&&this.chart.xAxis[s.xAxis],o=c(s.yAxis)&&this.chart.yAxis[s.yAxis];n&&o&&(s.points.forEach(function(e,s){s>=t&&(e.x=n.toValue(i[n.horiz?"chartX":"chartY"]),e.y=o.toValue(i[o.horiz?"chartX":"chartY"]))}),e.update({typeOptions:{points:s.points}}))}},updateRectSize:function(t,i){var e=i.chart,s=i.options.typeOptions,n=c(s.xAxis)&&e.xAxis[s.xAxis],o=c(s.yAxis)&&e.yAxis[s.yAxis];if(n&&o){var a=n.toValue(t[n.horiz?"chartX":"chartY"]),r=o.toValue(t[o.horiz?"chartX":"chartY"]),l=a-s.point.x,h=s.point.y-r;i.update({typeOptions:{background:{width:e.inverted?h:l,height:e.inverted?l:h}}})}}}}),e(i,"Stock/StockTools/StockToolsBindings.js",[i["Core/Globals.js"],i["Stock/StockTools/StockToolsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e){var s=i.addFlagFromForm,n=i.attractToPoint,o=i.isNotNavigatorYAxis,a=i.isPriceIndicatorEnabled,r=i.manageIndicators,l=i.updateHeight,c=i.updateNthPoint,h=i.updateRectSize,p=e.fireEvent,d=e.merge;return{segment:{className:"highcharts-segment",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"segment",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.segment.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowSegment:{className:"highcharts-arrow-segment",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"arrowSegment",type:"crookedLine",typeOptions:{line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.arrowSegment.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},ray:{className:"highcharts-ray",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"ray",type:"infinityLine",typeOptions:{type:"ray",xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.ray.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowRay:{className:"highcharts-arrow-ray",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"arrowRay",type:"infinityLine",typeOptions:{type:"ray",line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.arrowRay.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},infinityLine:{className:"highcharts-infinity-line",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"infinityLine",type:"infinityLine",typeOptions:{type:"line",xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.infinityLine.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowInfinityLine:{className:"highcharts-arrow-infinity-line",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"arrowInfinityLine",type:"infinityLine",typeOptions:{type:"line",line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value},{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.arrowInfinityLine.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},horizontalLine:{className:"highcharts-horizontal-line",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"horizontalLine",type:"infinityLine",draggable:"y",typeOptions:{type:"horizontalLine",xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.horizontalLine.annotationsOptions);this.chart.addAnnotation(o)}}},verticalLine:{className:"highcharts-vertical-line",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({langKey:"verticalLine",type:"infinityLine",draggable:"x",typeOptions:{type:"verticalLine",xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value}]}},n.annotationsOptions,n.bindings.verticalLine.annotationsOptions);this.chart.addAnnotation(o)}}},crooked3:{className:"highcharts-crooked3",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"crooked3",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o},{x:n,y:o}]}},a.annotationsOptions,a.bindings.crooked3.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2)]},crooked5:{className:"highcharts-crooked5",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"crooked5",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o}]}},a.annotationsOptions,a.bindings.crooked5.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3),c(4)]},elliott3:{className:"highcharts-elliott3",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"elliott3",type:"elliottWave",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.elliott3.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3)]},elliott5:{className:"highcharts-elliott5",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"elliott5",type:"elliottWave",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o},{x:n,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.elliott5.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3),c(4),c(5)]},measureX:{className:"highcharts-measure-x",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"x",xAxis:e.axis.index,yAxis:s.axis.index,point:{x:n,y:o},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{enabled:!1,strokeWidth:0,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureX.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},measureY:{className:"highcharts-measure-y",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"y",xAxis:e.axis.index,yAxis:s.axis.index,point:{x:n,y:o},crosshairX:{enabled:!1,strokeWidth:0,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureY.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},measureXY:{className:"highcharts-measure-xy",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"xy",xAxis:e.axis.index,yAxis:s.axis.index,point:{x:n,y:o},background:{width:0,height:0,strokeWidth:10},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureXY.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},fibonacci:{className:"highcharts-fibonacci",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"fibonacci",type:"fibonacci",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.fibonacci.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),l]},parallelChannel:{className:"highcharts-parallel-channel",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"parallelChannel",type:"tunnel",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:n,y:o},{x:n,y:o}]}},a.annotationsOptions,a.bindings.parallelChannel.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),l]},pitchfork:{className:"highcharts-pitchfork",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=e.value,o=s.value,a=this.chart.options.navigation,r=d({langKey:"pitchfork",type:"pitchfork",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value,y:s.value,controlPoint:{style:{fill:"#f21313"}}},{x:n,y:o},{x:n,y:o}],innerBackground:{fill:"rgba(100, 170, 255, 0.8)"}},shapeOptions:{strokeWidth:2}},a.annotationsOptions,a.bindings.pitchfork.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2)]},verticalCounter:{className:"highcharts-vertical-counter",start:function(t){var i=n(t,this.chart);if(i){this.verticalCounter=this.verticalCounter||0;var e=this.chart.options.navigation,s=d({langKey:"verticalCounter",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40,text:this.verticalCounter.toString()}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalCounter.annotationsOptions),o=this.chart.addAnnotation(s);this.verticalCounter++,o.options.events.click.call(o,{})}}},timeCycles:{className:"highcharts-time-cycles",start:function(t){var i=n(t,this.chart);if(i){var e=this.chart.options.navigation,s=d({langKey:"timeCycles",type:"timeCycles",typeOptions:{xAxis:i.xAxis,yAxis:i.yAxis,points:[{x:i.x},{x:i.x}],line:{stroke:"rgba(0, 0, 0, 0.75)",fill:"transparent",strokeWidth:2}}},e.annotationsOptions,e.bindings.timeCycles.annotationsOptions),o=this.chart.addAnnotation(s);return o.options.events.click.call(o,{}),o}},steps:[c(1)]},verticalLabel:{className:"highcharts-vertical-label",start:function(t){var i=n(t,this.chart);if(i){var e=this.chart.options.navigation,s=d({langKey:"verticalLabel",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalLabel.annotationsOptions),o=this.chart.addAnnotation(s);o.options.events.click.call(o,{})}}},verticalArrow:{className:"highcharts-vertical-arrow",start:function(t){var i=n(t,this.chart);if(i){var e=this.chart.options.navigation,s=d({langKey:"verticalArrow",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40,format:" "},connector:{fill:"none",stroke:i.below?"#f21313":"#06b535"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalArrow.annotationsOptions),o=this.chart.addAnnotation(s);o.options.events.click.call(o,{})}}},fibonacciTimeZones:{className:"highcharts-fibonacci-time-zones",start:function(t){var i=this.getCoords(t),e=i[0],s=i[1];if(e&&s){var n=this.chart.options.navigation,o=d({type:"fibonacciTimeZones",langKey:"fibonacciTimeZones",typeOptions:{xAxis:e.axis.index,yAxis:s.axis.index,points:[{x:e.value}]}},n.annotationsOptions,n.bindings.fibonacciTimeZones.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[function(t,i){var e=i.options.typeOptions.points,s=e&&e[0].x,n=this.getCoords(t),o=n[0],a=n[1];o&&a&&i.update({typeOptions:{xAxis:o.axis.index,yAxis:a.axis.index,points:[{x:s},{x:o.value}]}})}]},flagCirclepin:{className:"highcharts-flag-circlepin",start:s("circlepin")},flagDiamondpin:{className:"highcharts-flag-diamondpin",start:s("flag")},flagSquarepin:{className:"highcharts-flag-squarepin",start:s("squarepin")},flagSimplepin:{className:"highcharts-flag-simplepin",start:s("nopin")},zoomX:{className:"highcharts-zoom-x",init:function(t){this.chart.update({chart:{zooming:{type:"x"}}}),p(this,"deselectButton",{button:t})}},zoomY:{className:"highcharts-zoom-y",init:function(t){this.chart.update({chart:{zooming:{type:"y"}}}),p(this,"deselectButton",{button:t})}},zoomXY:{className:"highcharts-zoom-xy",init:function(t){this.chart.update({chart:{zooming:{type:"xy"}}}),p(this,"deselectButton",{button:t})}},seriesTypeLine:{className:"highcharts-series-type-line",init:function(t){this.chart.series[0].update({type:"line",useOhlcData:!0}),p(this,"deselectButton",{button:t})}},seriesTypeOhlc:{className:"highcharts-series-type-ohlc",init:function(t){this.chart.series[0].update({type:"ohlc"}),p(this,"deselectButton",{button:t})}},seriesTypeCandlestick:{className:"highcharts-series-type-candlestick",init:function(t){this.chart.series[0].update({type:"candlestick"}),p(this,"deselectButton",{button:t})}},seriesTypeHeikinAshi:{className:"highcharts-series-type-heikinashi",init:function(t){this.chart.series[0].update({type:"heikinashi"}),p(this,"deselectButton",{button:t})}},seriesTypeHLC:{className:"highcharts-series-type-hlc",init:function(t){this.chart.series[0].update({type:"hlc",useOhlcData:!0}),p(this,"deselectButton",{button:t})}},seriesTypeHollowCandlestick:{className:"highcharts-series-type-hollowcandlestick",init:function(t){this.chart.series[0].update({type:"hollowcandlestick"}),p(this,"deselectButton",{button:t})}},fullScreen:{className:"highcharts-full-screen",noDataState:"normal",init:function(t){this.chart.fullscreen&&this.chart.fullscreen.toggle(),p(this,"deselectButton",{button:t})}},currentPriceIndicator:{className:"highcharts-current-price-indicator",init:function(t){var i=this.chart,e=i.series,s=i.stockTools,n=a(i.series);s&&s.guiEnabled&&(e.forEach(function(t){t.update({lastPrice:{enabled:!n},lastVisiblePrice:{enabled:!n,label:{enabled:!0}}},!1)}),i.redraw()),p(this,"deselectButton",{button:t})}},indicators:{className:"highcharts-indicators",init:function(){var t=this;p(t,"showPopup",{formType:"indicators",options:{},onSubmit:function(i){r.call(t,i)}})}},toggleAnnotations:{className:"highcharts-toggle-annotations",init:function(t){var i=this.chart,e=i.stockTools,s=e.getIconsURL();this.toggledAnnotations=!this.toggledAnnotations,(i.annotations||[]).forEach(function(t){t.setVisibility(!this.toggledAnnotations)},this),e&&e.guiEnabled&&(this.toggledAnnotations?t.firstChild.style["background-image"]='url("'+s+'annotations-hidden.svg")':t.firstChild.style["background-image"]='url("'+s+'annotations-visible.svg")'),p(this,"deselectButton",{button:t})}},saveChart:{className:"highcharts-save-chart",noDataState:"normal",init:function(i){var e=this.chart,s=[],n=[],a=[],r=[];e.annotations.forEach(function(t,i){s[i]=t.userOptions}),e.series.forEach(function(t){t.is("sma")?n.push(t.userOptions):"flags"===t.type&&a.push(t.userOptions)}),e.yAxis.forEach(function(t){o(t)&&r.push(t.options)}),t.win.localStorage.setItem("highcharts-chart",JSON.stringify({annotations:s,indicators:n,flags:a,yAxes:r})),p(this,"deselectButton",{button:i})}}}}),e(i,"Stock/StockTools/StockToolsDefaults.js",[],function(){return{lang:{stockTools:{gui:{simpleShapes:"Simple shapes",lines:"Lines",crookedLines:"Crooked lines",measure:"Measure",advanced:"Advanced",toggleAnnotations:"Toggle annotations",verticalLabels:"Vertical labels",flags:"Flags",zoomChange:"Zoom change",typeChange:"Type change",saveChart:"Save chart",indicators:"Indicators",currentPriceIndicator:"Current Price Indicators",zoomX:"Zoom X",zoomY:"Zoom Y",zoomXY:"Zooom XY",fullScreen:"Fullscreen",typeOHLC:"OHLC",typeLine:"Line",typeCandlestick:"Candlestick",typeHLC:"HLC",typeHollowCandlestick:"Hollow Candlestick",typeHeikinAshi:"Heikin Ashi",circle:"Circle",ellipse:"Ellipse",label:"Label",rectangle:"Rectangle",flagCirclepin:"Flag circle",flagDiamondpin:"Flag diamond",flagSquarepin:"Flag square",flagSimplepin:"Flag simple",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",infinityLine:"Infinity line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",timeCycles:"Time Cycles"}},navigation:{popup:{circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",infinityLine:"Infinity line",measure:"Measure",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",timeCycles:"Time Cycles",flags:"Flags",addButton:"Add",saveButton:"Save",editButton:"Edit",removeButton:"Remove",series:"Series",volume:"Volume",connector:"Connector",innerBackground:"Inner background",outerBackground:"Outer background",crosshairX:"Crosshair X",crosshairY:"Crosshair Y",tunnel:"Tunnel",background:"Background",noFilterMatch:"No match",searchIndicators:"Search Indicators",clearFilter:"✕ clear filter",index:"Index",period:"Period",periods:"Periods",standardDeviation:"Standard deviation",periodTenkan:"Tenkan period",periodSenkouSpanB:"Senkou Span B period",periodATR:"ATR period",multiplierATR:"ATR multiplier",shortPeriod:"Short period",longPeriod:"Long period",signalPeriod:"Signal period",decimals:"Decimals",algorithm:"Algorithm",topBand:"Top band",bottomBand:"Bottom band",initialAccelerationFactor:"Initial acceleration factor",maxAccelerationFactor:"Max acceleration factor",increment:"Increment",multiplier:"Multiplier",ranges:"Ranges",highIndex:"High index",lowIndex:"Low index",deviation:"Deviation",xAxisUnit:"x-axis unit",factor:"Factor",fastAvgPeriod:"Fast average period",slowAvgPeriod:"Slow average period",average:"Average",indicatorAliases:{abands:["Acceleration Bands"],bb:["Bollinger Bands"],dema:["Double Exponential Moving Average"],ema:["Exponential Moving Average"],ikh:["Ichimoku Kinko Hyo"],keltnerchannels:["Keltner Channels"],linearRegression:["Linear Regression"],pivotpoints:["Pivot Points"],pc:["Price Channel"],priceenvelopes:["Price Envelopes"],psar:["Parabolic SAR"],sma:["Simple Moving Average"],supertrend:["Super Trend"],tema:["Triple Exponential Moving Average"],vbp:["Volume by Price"],vwap:["Volume Weighted Moving Average"],wma:["Weighted Moving Average"],zigzag:["Zig Zag"],apo:["Absolute price indicator"],ad:["Accumulation/Distribution"],aroon:["Aroon"],aroonoscillator:["Aroon oscillator"],atr:["Average True Range"],ao:["Awesome oscillator"],cci:["Commodity Channel Index"],chaikin:["Chaikin"],cmf:["Chaikin Money Flow"],cmo:["Chande Momentum Oscillator"],disparityindex:["Disparity Index"],dmi:["Directional Movement Index"],dpo:["Detrended price oscillator"],klinger:["Klinger Oscillator"],linearRegressionAngle:["Linear Regression Angle"],linearRegressionIntercept:["Linear Regression Intercept"],linearRegressionSlope:["Linear Regression Slope"],macd:["Moving Average Convergence Divergence"],mfi:["Money Flow Index"],momentum:["Momentum"],natr:["Normalized Average True Range"],obv:["On-Balance Volume"],ppo:["Percentage Price oscillator"],roc:["Rate of Change"],rsi:["Relative Strength Index"],slowstochastic:["Slow Stochastic"],stochastic:["Stochastic"],trix:["TRIX"],williamsr:["Williams %R"]}}}},stockTools:{gui:{enabled:!0,className:"highcharts-bindings-wrapper",toolbarClassName:"stocktools-toolbar",buttons:["indicators","separator","simpleShapes","lines","crookedLines","measure","advanced","toggleAnnotations","separator","verticalLabels","flags","separator","zoomChange","fullScreen","typeChange","separator","currentPriceIndicator","saveChart"],definitions:{separator:{elementType:"span",symbol:"separator.svg"},simpleShapes:{items:["label","circle","ellipse","rectangle"],circle:{symbol:"circle.svg"},ellipse:{symbol:"ellipse.svg"},rectangle:{symbol:"rectangle.svg"},label:{symbol:"label.svg"}},flags:{items:["flagCirclepin","flagDiamondpin","flagSquarepin","flagSimplepin"],flagSimplepin:{symbol:"flag-basic.svg"},flagDiamondpin:{symbol:"flag-diamond.svg"},flagSquarepin:{symbol:"flag-trapeze.svg"},flagCirclepin:{symbol:"flag-elipse.svg"}},lines:{items:["segment","arrowSegment","ray","arrowRay","line","arrowInfinityLine","horizontalLine","verticalLine"],segment:{symbol:"segment.svg"},arrowSegment:{symbol:"arrow-segment.svg"},ray:{symbol:"ray.svg"},arrowRay:{symbol:"arrow-ray.svg"},line:{symbol:"line.svg"},arrowInfinityLine:{symbol:"arrow-line.svg"},verticalLine:{symbol:"vertical-line.svg"},horizontalLine:{symbol:"horizontal-line.svg"}},crookedLines:{items:["elliott3","elliott5","crooked3","crooked5"],crooked3:{symbol:"crooked-3.svg"},crooked5:{symbol:"crooked-5.svg"},elliott3:{symbol:"elliott-3.svg"},elliott5:{symbol:"elliott-5.svg"}},verticalLabels:{items:["verticalCounter","verticalLabel","verticalArrow"],verticalCounter:{symbol:"vertical-counter.svg"},verticalLabel:{symbol:"vertical-label.svg"},verticalArrow:{symbol:"vertical-arrow.svg"}},advanced:{items:["fibonacci","fibonacciTimeZones","pitchfork","parallelChannel","timeCycles"],pitchfork:{symbol:"pitchfork.svg"},fibonacci:{symbol:"fibonacci.svg"},fibonacciTimeZones:{symbol:"fibonacci-timezone.svg"},parallelChannel:{symbol:"parallel-channel.svg"},timeCycles:{symbol:"time-cycles.svg"}},measure:{items:["measureXY","measureX","measureY"],measureX:{symbol:"measure-x.svg"},measureY:{symbol:"measure-y.svg"},measureXY:{symbol:"measure-xy.svg"}},toggleAnnotations:{symbol:"annotations-visible.svg"},currentPriceIndicator:{symbol:"current-price-show.svg"},indicators:{symbol:"indicators.svg"},zoomChange:{items:["zoomX","zoomY","zoomXY"],zoomX:{symbol:"zoom-x.svg"},zoomY:{symbol:"zoom-y.svg"},zoomXY:{symbol:"zoom-xy.svg"}},typeChange:{items:["typeOHLC","typeLine","typeCandlestick","typeHollowCandlestick","typeHLC","typeHeikinAshi"],typeOHLC:{symbol:"series-ohlc.svg"},typeLine:{symbol:"series-line.svg"},typeCandlestick:{symbol:"series-candlestick.svg"},typeHLC:{symbol:"series-hlc.svg"},typeHeikinAshi:{symbol:"series-heikin-ashi.svg"},typeHollowCandlestick:{symbol:"series-hollow-candlestick.svg"}},fullScreen:{symbol:"fullscreen.svg"},saveChart:{symbol:"save-chart.svg"}},visible:!0}}}}),e(i,"Stock/StockTools/StockTools.js",[i["Core/Defaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Stock/StockTools/StockToolsBindings.js"],i["Stock/StockTools/StockToolsDefaults.js"],i["Stock/StockTools/StockToolsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,s,n,o){var a=t.setOptions,r=i.getAssignedAxis,l=n.isNotNavigatorYAxis,c=n.isPriceIndicatorEnabled,h=o.correctFloat,p=o.defined,d=o.isNumber,u=o.pick;function g(t,i,e,s){var n,o,a,r=0;function l(t){return p(t)&&!d(t)&&t.match("%")}return s&&(a=h(parseFloat(s.top)/100),o=h(parseFloat(s.height)/100)),{positions:t.map(function(s,c){var p=h(l(s.options.height)?parseFloat(s.options.height)/100:s.height/i),u=h(l(s.options.top)?parseFloat(s.options.top)/100:(s.top-s.chart.plotTop)/i);return o?(u>a&&(u-=o),r=Math.max(r,(u||0)+(p||0))):(d(p)||(p=t[c-1].series.every(function(t){return t.is("sma")})?n:e/100),d(u)||(u=r),n=p,r=h(Math.max(r,(u||0)+(p||0)))),{height:100*p,top:100*u}}),allAxesHeight:r}}function v(t){var i=[];return t.forEach(function(e,s){var n=t[s+1];n?i[s]={enabled:!0,controlledAxis:{next:[u(n.options.id,n.index)]}}:i[s]={enabled:!1}}),i}function y(t,i,e,s){return t.forEach(function(n,o){var a=t[o-1];n.top=a?h(a.height+a.top):0,e&&(n.height=h(n.height+s*i))}),t}function m(t){var i=this.chart,e=i.yAxis.filter(l),s=i.plotHeight,n=this.getYAxisPositions(e,s,20,t),o=n.positions,a=n.allAxesHeight,r=this.getYAxisResizers(e);!t&&a<=h(1)?o[o.length-1]={height:20,top:h(100*a-20)}:o.forEach(function(t){t.height=t.height/(100*a)*100,t.top=t.top/(100*a)*100}),o.forEach(function(t,i){e[i].update({height:t.height+"%",top:t.top+"%",resize:r[i],offset:0},!1)})}return{compose:function(t){var i,o=t.prototype;(null===(i=o.utils)||void 0===i?void 0:i.manageIndicators)||(o.getYAxisPositions=g,o.getYAxisResizers=v,o.recalculateYAxisPositions=y,o.resizeYAxes=m,o.utils=o.utils||{},o.utils.indicatorsWithAxes=n.indicatorsWithAxes,o.utils.indicatorsWithVolume=n.indicatorsWithVolume,o.utils.getAssignedAxis=r,o.utils.isPriceIndicatorEnabled=c,o.utils.manageIndicators=n.manageIndicators,a(s),a({navigation:{bindings:e}}))}}}),e(i,"Stock/StockTools/StockToolbar.js",[i["Core/Utilities.js"],i["Core/Renderer/HTML/AST.js"],i["Stock/StockTools/StockToolsUtilities.js"]],function(t,i,e){var s=t.addEvent,n=t.createElement,o=t.css,a=t.defined,r=t.fireEvent,l=t.getStyle,c=t.isArray,h=t.merge,p=t.pick,d=e.shallowArraysEqual,u=function(){function t(t,i,e){this.width=0,this.isDirty=!1,this.chart=e,this.options=t,this.lang=i,this.iconsURL=this.getIconsURL(),this.guiEnabled=t.enabled,this.visible=p(t.visible,!0),this.guiClassName=t.className,this.toolbarClassName=t.toolbarClassName,this.eventsToUnbind=[],this.guiEnabled&&(this.createContainer(),this.createButtons(),this.showHideNavigation()),r(this,"afterInit")}return t.prototype.createButtons=function(){var t=this,i=this.lang,e=this.options,n=this.toolbar,o=e.buttons,a=e.definitions,r=n.childNodes;this.buttonList=o,o.forEach(function(e){var o=t.addButton(n,a,e,i);t.eventsToUnbind.push(s(o.buttonWrapper,"click",function(){return t.eraseActiveButtons(r,o.buttonWrapper)})),c(a[e].items)&&t.addSubmenu(o,a[e])})},t.prototype.addSubmenu=function(t,i){var e=this,a=t.submenuArrow,r=t.buttonWrapper,c=l(r,"width"),h=this.wrapper,p=this.listWrapper,d=this.toolbar.childNodes,u=this.submenu=n("ul",{className:"highcharts-submenu-wrapper"},void 0,r);this.addSubmenuItems(r,i),this.eventsToUnbind.push(s(a,"click",function(t){if(t.stopPropagation(),e.eraseActiveButtons(d,r),r.className.indexOf("highcharts-current")>=0)p.style.width=p.startWidth+"px",r.classList.remove("highcharts-current"),u.style.display="none";else{u.style.display="block";var i=u.offsetHeight-r.offsetHeight-3;u.offsetHeight+r.offsetTop>h.offsetHeight&&r.offsetTop>i||(i=0),o(u,{top:-i+"px",left:c+3+"px"}),r.className+=" highcharts-current",p.startWidth=h.offsetWidth,p.style.width=p.startWidth+l(p,"padding-left")+u.offsetWidth+3+"px"}}))},t.prototype.addSubmenuItems=function(t,i){var e,n=this,o=this,a=this.submenu,r=this.lang,l=this.listWrapper;i.items.forEach(function(c){e=n.addButton(a,i,c,r),n.eventsToUnbind.push(s(e.mainButton,"click",function(){o.switchSymbol(this,t,!0),l.style.width=l.startWidth+"px",a.style.display="none"}))});var c=a.querySelectorAll("li > .highcharts-menu-item-btn")[0];this.switchSymbol(c,!1)},t.prototype.eraseActiveButtons=function(t,i,e){[].forEach.call(t,function(t){t!==i&&(t.classList.remove("highcharts-current"),t.classList.remove("highcharts-active"),(e=t.querySelectorAll(".highcharts-submenu-wrapper")).length>0&&(e[0].style.display="none"))})},t.prototype.addButton=function(i,e,s,o){void 0===o&&(o={});var a=e[s],r=a.items,l=t.prototype.classMapping,c=a.className||"",h=n("li",{className:p(l[s],"")+" "+c,title:o[s]||s},void 0,i),d=n(a.elementType||"button",{className:"highcharts-menu-item-btn"},void 0,h);if(r&&r.length){var u=n("button",{className:"highcharts-submenu-item-arrow highcharts-arrow-right"},void 0,h);return u.style.backgroundImage="url("+this.iconsURL+"arrow-bottom.svg)",{buttonWrapper:h,mainButton:d,submenuArrow:u}}return d.style.backgroundImage="url("+this.iconsURL+a.symbol+")",{buttonWrapper:h,mainButton:d}},t.prototype.addNavigation=function(){var t=this.wrapper;this.arrowWrapper=n("div",{className:"highcharts-arrow-wrapper"}),this.arrowUp=n("div",{className:"highcharts-arrow-up"},void 0,this.arrowWrapper),this.arrowUp.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",this.arrowDown=n("div",{className:"highcharts-arrow-down"},void 0,this.arrowWrapper),this.arrowDown.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",t.insertBefore(this.arrowWrapper,t.childNodes[0]),this.scrollButtons()},t.prototype.scrollButtons=function(){var t=this.wrapper,i=this.toolbar,e=.1*t.offsetHeight,n=0;this.eventsToUnbind.push(s(this.arrowUp,"click",function(){n>0&&(n-=e,i.style.marginTop=-n+"px")})),this.eventsToUnbind.push(s(this.arrowDown,"click",function(){t.offsetHeight+n<=i.offsetHeight+e&&(n+=e,i.style.marginTop=-n+"px")}))},t.prototype.createContainer=function(){var t,i,e=this,o=this.chart,a=this.options,r=o.container,l=o.options.navigation,c=null==l?void 0:l.bindingsClassName,h=this,p=this.wrapper=n("div",{className:"highcharts-stocktools-wrapper "+a.className+" "+c});r.appendChild(p),this.showHideBtn=n("div",{className:"highcharts-toggle-toolbar highcharts-arrow-left"},void 0,p),this.eventsToUnbind.push(s(this.showHideBtn,"click",function(){e.update({gui:{visible:!h.visible}})})),["mousedown","mousemove","click","touchstart"].forEach(function(t){s(p,t,function(t){return t.stopPropagation()})}),s(p,"mouseover",function(t){var i;return null===(i=o.pointer)||void 0===i?void 0:i.onContainerMouseLeave(t)}),this.toolbar=i=n("ul",{className:"highcharts-stocktools-toolbar "+a.toolbarClassName}),this.listWrapper=t=n("div",{className:"highcharts-menu-wrapper"}),p.insertBefore(t,p.childNodes[0]),t.insertBefore(i,t.childNodes[0]),this.showHideToolbar(),this.addNavigation()},t.prototype.showHideNavigation=function(){this.visible&&this.toolbar.offsetHeight>this.wrapper.offsetHeight-50?this.arrowWrapper.style.display="block":(this.toolbar.style.marginTop="0px",this.arrowWrapper.style.display="none")},t.prototype.showHideToolbar=function(){var t=this.wrapper,i=this.listWrapper,e=this.submenu,s=this.showHideBtn,n=this.visible;s.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",n?(t.style.height="100%",i.classList.remove("highcharts-hide"),s.classList.remove("highcharts-arrow-right"),s.style.top=l(i,"padding-top")+"px",s.style.left=t.offsetWidth+l(i,"padding-left")+"px"):(e&&(e.style.display="none"),s.style.left="0px",n=this.visible=!1,i.classList.add("highcharts-hide"),s.classList.add("highcharts-arrow-right"),t.style.height=s.offsetHeight+"px")},t.prototype.switchSymbol=function(t,i){var e=t.parentNode,s=e.className,n=e.parentNode.parentNode;!(s.indexOf("highcharts-disabled-btn")>-1)&&(n.className="",s&&n.classList.add(s.trim()),n.querySelectorAll(".highcharts-menu-item-btn")[0].style.backgroundImage=t.style.backgroundImage,i&&this.toggleButtonActiveClass(n))},t.prototype.toggleButtonActiveClass=function(t){var i=t.classList;i.contains("highcharts-active")?i.remove("highcharts-active"):i.add("highcharts-active")},t.prototype.unselectAllButtons=function(t){var i=t.parentNode.querySelectorAll(".highcharts-active");[].forEach.call(i,function(i){i!==t&&i.classList.remove("highcharts-active")})},t.prototype.update=function(t,i){this.isDirty=!!t.gui.definitions,h(!0,this.chart.options.stockTools,t),h(!0,this.options,t.gui),this.visible=p(this.options.visible&&this.options.enabled,!0),this.chart.navigationBindings&&this.chart.navigationBindings.update(),this.chart.isDirtyBox=!0,p(i,!0)&&this.chart.redraw()},t.prototype.destroy=function(){var t=this.wrapper,i=t&&t.parentNode;this.eventsToUnbind.forEach(function(t){return t()}),i&&i.removeChild(t)},t.prototype.redraw=function(){if(this.options.enabled!==this.guiEnabled)this.handleGuiEnabledChange();else{if(!this.guiEnabled)return;this.updateClassNames(),this.updateButtons(),this.updateVisibility(),this.showHideNavigation(),this.showHideToolbar()}},t.prototype.handleGuiEnabledChange=function(){!1===this.options.enabled&&(this.destroy(),this.visible=!1),!0===this.options.enabled&&(this.createContainer(),this.createButtons()),this.guiEnabled=this.options.enabled},t.prototype.updateClassNames=function(){this.options.className!==this.guiClassName&&(this.guiClassName&&this.wrapper.classList.remove(this.guiClassName),this.options.className&&this.wrapper.classList.add(this.options.className),this.guiClassName=this.options.className),this.options.toolbarClassName!==this.toolbarClassName&&(this.toolbarClassName&&this.toolbar.classList.remove(this.toolbarClassName),this.options.toolbarClassName&&this.toolbar.classList.add(this.options.toolbarClassName),this.toolbarClassName=this.options.toolbarClassName)},t.prototype.updateButtons=function(){(!d(this.options.buttons,this.buttonList)||this.isDirty)&&(this.toolbar.innerHTML=i.emptyHTML,this.createButtons())},t.prototype.updateVisibility=function(){a(this.options.visible)&&(this.visible=this.options.visible)},t.prototype.getIconsURL=function(){return this.chart.options.navigation.iconsURL||this.options.iconsURL||"https://code.highcharts.com/11.4.6/gfx/stock-icons/"},t}();return u.prototype.classMapping={circle:"highcharts-circle-annotation",ellipse:"highcharts-ellipse-annotation",rectangle:"highcharts-rectangle-annotation",label:"highcharts-label-annotation",segment:"highcharts-segment",arrowSegment:"highcharts-arrow-segment",ray:"highcharts-ray",arrowRay:"highcharts-arrow-ray",line:"highcharts-infinity-line",arrowInfinityLine:"highcharts-arrow-infinity-line",verticalLine:"highcharts-vertical-line",horizontalLine:"highcharts-horizontal-line",crooked3:"highcharts-crooked3",crooked5:"highcharts-crooked5",elliott3:"highcharts-elliott3",elliott5:"highcharts-elliott5",pitchfork:"highcharts-pitchfork",fibonacci:"highcharts-fibonacci",fibonacciTimeZones:"highcharts-fibonacci-time-zones",parallelChannel:"highcharts-parallel-channel",measureX:"highcharts-measure-x",measureY:"highcharts-measure-y",measureXY:"highcharts-measure-xy",timeCycles:"highcharts-time-cycles",verticalCounter:"highcharts-vertical-counter",verticalLabel:"highcharts-vertical-label",verticalArrow:"highcharts-vertical-arrow",currentPriceIndicator:"highcharts-current-price-indicator",indicators:"highcharts-indicators",flagCirclepin:"highcharts-flag-circlepin",flagDiamondpin:"highcharts-flag-diamondpin",flagSquarepin:"highcharts-flag-squarepin",flagSimplepin:"highcharts-flag-simplepin",zoomX:"highcharts-zoom-x",zoomY:"highcharts-zoom-y",zoomXY:"highcharts-zoom-xy",typeLine:"highcharts-series-type-line",typeOHLC:"highcharts-series-type-ohlc",typeHLC:"highcharts-series-type-hlc",typeCandlestick:"highcharts-series-type-candlestick",typeHollowCandlestick:"highcharts-series-type-hollowcandlestick",typeHeikinAshi:"highcharts-series-type-heikinashi",fullScreen:"highcharts-full-screen",toggleAnnotations:"highcharts-toggle-annotations",saveChart:"highcharts-save-chart",separator:"highcharts-separator"},u}),e(i,"Stock/StockTools/StockToolsGui.js",[i["Core/Defaults.js"],i["Stock/StockTools/StockToolsDefaults.js"],i["Stock/StockTools/StockToolbar.js"],i["Core/Utilities.js"]],function(t,i,e,s){var n=t.setOptions,o=s.addEvent,a=s.getStyle,r=s.merge,l=s.pick;function c(t){var i=this.options,s=i.lang,n=r(i.stockTools&&i.stockTools.gui,t&&t.gui),o=s&&s.stockTools&&s.stockTools.gui;this.stockTools=new e(n,o,this),this.stockTools.guiEnabled&&(this.isDirtyBox=!0)}function h(){this.setStockTools()}function p(){this.stockTools&&(this.stockTools.redraw(),function(t){var i;if(null===(i=t.stockTools)||void 0===i?void 0:i.guiEnabled){var e=t.options.chart,s=t.stockTools.listWrapper,n=s&&(s.startWidth+a(s,"padding-left")+a(s,"padding-right")||s.offsetWidth);t.stockTools.width=n;var o=!1;if(n<t.plotWidth){var r=l(e.spacingLeft,e.spacing&&e.spacing[3],0)+n,c=r-t.spacingBox.x;t.spacingBox.x=r,t.spacingBox.width-=c,o=!0}else 0===n&&(o=!0);n!==t.stockTools.prevOffsetWidth&&(t.stockTools.prevOffsetWidth=n,o&&(t.isDirtyLegend=!0))}}(this))}function d(){this.stockTools&&this.stockTools.destroy()}function u(){var t,i=(null===(t=this.stockTools)||void 0===t?void 0:t.visible)&&this.stockTools.guiEnabled?this.stockTools.width:0;i&&i<this.plotWidth&&(this.plotLeft+=i,this.spacing[3]+=i)}function g(){var t,i,e=this.stockTools,s=e&&e.toolbar&&e.toolbar.querySelector(".highcharts-current-price-indicator");e&&this.navigationBindings&&this.options.series&&s&&((null===(i=null===(t=this.navigationBindings.utils)||void 0===t?void 0:t.isPriceIndicatorEnabled)||void 0===i?void 0:i.call(t,this.series))?s.firstChild.style["background-image"]='url("'+e.getIconsURL()+'current-price-hide.svg")':s.firstChild.style["background-image"]='url("'+e.getIconsURL()+'current-price-show.svg")')}function v(t){var i=this.chart.stockTools;if(i&&i.guiEnabled){var e=t.button;e.parentNode.className.indexOf("highcharts-submenu-wrapper")>=0&&(e=e.parentNode.parentNode),e.classList.remove("highcharts-active")}}function y(t){var i=this.chart.stockTools;if(i&&i.guiEnabled){var e=t.button;i.unselectAllButtons(t.button),e.parentNode.className.indexOf("highcharts-submenu-wrapper")>=0&&(e=e.parentNode.parentNode),i.toggleButtonActiveClass(e)}}return{compose:function(t,e){var s=t.prototype;s.setStockTools||(o(t,"afterGetContainer",h),o(t,"beforeRedraw",p),o(t,"beforeRender",p),o(t,"destroy",d),o(t,"getMargins",u,{order:0}),o(t,"render",g),s.setStockTools=c,o(e,"deselectButton",v),o(e,"selectButton",y),n(i))}}}),e(i,"masters/modules/stock-tools.src.js",[i["Core/Globals.js"],i["Extensions/Annotations/NavigationBindings.js"],i["Stock/StockTools/StockTools.js"],i["Stock/StockTools/StockToolsGui.js"],i["Stock/StockTools/StockToolbar.js"]],function(t,i,e,s,n){return t.NavigationBindings=t.NavigationBindings||i,t.Toolbar=n,e.compose(t.NavigationBindings),s.compose(t.Chart,t.NavigationBindings),t})});