!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * Pictorial graph series type for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi, Magdalena Gut
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pictorial",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(e,i,r,o){e.hasOwnProperty(i)||(e[i]=o.apply(null,r),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:e[i]}})))}i(e,"Extensions/PatternFill.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Utilities.js"]],function(t,e,i){var r=t.animObject,o=e.getOptions,a=i.addEvent,n=i.defined,s=i.erase,h=i.extend,l=i.merge,p=i.pick,d=i.removeEvent,c=i.wrap,f=function(){for(var t=[],e=o().colors,i=0,r=0,a=["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"];r<a.length;r++){var n=a[r];t.push({path:n,color:e[i++],width:5,height:5,patternTransform:"scale(1.4 1.4)"})}i=5;for(var s=0,h=["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z","M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"];s<h.length;s++){var n=h[s];t.push({path:n,color:e[i],width:10,height:10}),i+=5}return t}();function u(t,e){var i,r=JSON.stringify(t),o=r.length||0,a=0,n=0;if(e){i=Math.max(Math.floor(o/500),1);for(var s=0;s<o;s+=i)a+=r.charCodeAt(s);a&=a}for(;n<o;++n)a=(a<<5)-a+r.charCodeAt(n),a&=a;return a.toString(16).replace("-","1")}function g(){if(this.renderer&&(this.renderer.defIds||[]).filter(function(t){return t&&t.indexOf&&0===t.indexOf("highcharts-pattern-")}).length){for(var t=0,e=this.series;t<e.length;t++){var i=e[t];if(i.visible)for(var r=0,o=i.points;r<o.length;r++){var a=o[r],n=a.options&&a.options.color;n&&n.pattern&&(n.pattern._width="defer",n.pattern._height="defer")}}this.redraw(!1)}}function m(){var t={},e=this.renderer,i=(e.defIds||[]).filter(function(t){return t.indexOf&&0===t.indexOf("highcharts-pattern-")});if(i.length){[].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(i){var r=i.getAttribute("fill")||i.getAttribute("color")||i.getAttribute("stroke");r&&(t[r.replace(e.url,"").replace("url(#","").replace(")","")]=!0)});for(var r=0;r<i.length;r++){var o=i[r];!t[o]&&(s(e.defIds,o),e.patternElements[o]&&(e.patternElements[o].destroy(),delete e.patternElements[o]))}}}function v(){var t=this.options.color;t&&t.pattern&&("string"==typeof t.pattern.path&&(t.pattern.path={d:t.pattern.path}),this.color=this.options.color=l(this.series.options.color,t))}function y(t){var e=t.args[0],i=t.args[1],r=t.args[2],o=this.chartIndex||0,a=e.pattern,n="#333333";if(void 0!==e.patternIndex&&f&&(a=f[e.patternIndex]),!a)return!0;if(a.image||"string"==typeof a.path||a.path&&a.path.d){var s=r.parentNode&&r.parentNode.getAttribute("class");s=s&&s.indexOf("highcharts-legend")>-1,("defer"===a._width||"defer"===a._height)&&w.call({graphic:{element:r}},a),(s||!a.id)&&((a=l({},a)).id="highcharts-pattern-"+o+"-"+u(a)+u(a,!0)),this.addPattern(a,!this.forExport&&p(a.animation,this.globalAnimation,{duration:100})),n="url(".concat(this.url,"#").concat(a.id+(this.forExport?"-export":""),")")}else n=a.color||n;return r.setAttribute(i,n),e.toString=function(){return n},!1}function x(){var t=this.chart.isResizing;if(this.isDirtyData||t||!this.chart.hasRendered)for(var e=0,i=this.points;e<i.length;e++){var r=i[e],o=r.options&&r.options.color;o&&o.pattern&&(t&&!(r.shapeArgs&&r.shapeArgs.width&&r.shapeArgs.height)?(o.pattern._width="defer",o.pattern._height="defer"):r.calculatePatternDimensions(o.pattern))}}function w(t){if(!t.width||!t.height){var e=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},i=this.shapeArgs;if(i&&(e.width=i.width||e.width,e.height=i.height||e.height,e.x=i.x||e.x,e.y=i.y||e.y),t.image){if(!e.width||!e.height){t._width="defer",t._height="defer";var r=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;n(r)&&r<0&&(t._inverted=!0);return}t.aspectRatio&&(e.aspectRatio=e.width/e.height,t.aspectRatio>e.aspectRatio?e.aspectWidth=e.height*t.aspectRatio:e.aspectHeight=e.width/t.aspectRatio),t._width=t.width||Math.ceil(e.aspectWidth||e.width),t._height=t.height||Math.ceil(e.aspectHeight||e.height)}t.width||(t._x=t.x||0,t._x+=e.x-Math.round(e.aspectWidth?Math.abs(e.aspectWidth-e.width)/2:0)),t.height||(t._y=t.y||0,t._y+=e.y-Math.round(e.aspectHeight?Math.abs(e.aspectHeight-e.height)/2:0))}}function b(t,e){var o,a,n,s=p(e,!0),h=r(s),l=t.color||"#333333",c=t.height||("number"==typeof t._height?t._height:0)||32,f=t.width||("number"==typeof t._width?t._width:0)||32,u=t.id;if(!u&&(this.idCounter=this.idCounter||0,u="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter),this.forExport&&(u+="-export"),this.defIds=this.defIds||[],!(this.defIds.indexOf(u)>-1)){this.defIds.push(u);var g={id:u,patternUnits:"userSpaceOnUse",patternContentUnits:t.patternContentUnits||"userSpaceOnUse",width:f,height:c,x:t._x||t.x||0,y:t._y||t.y||0};t._inverted&&(g.patternTransform="scale(1, -1)",t.patternTransform&&(t.patternTransform+=" scale(1, -1)")),t.patternTransform&&(g.patternTransform=t.patternTransform);var m=this.createElement("pattern").attr(g).add(this.defs);return(m.id=u,t.path)?(n=i.isObject(t.path)?t.path:{d:t.path},t.backgroundColor&&(o=t.backgroundColor,this.rect(0,0,f,c).attr({fill:o}).add(m)),a={d:n.d},this.styledMode||(a.stroke=n.stroke||l,a["stroke-width"]=p(n.strokeWidth,2),a.fill=n.fill||"none"),n.transform&&(a.transform=n.transform),this.createElement("path").attr(a).add(m),m.color=l):t.image&&(s?this.image(t.image,0,0,f,c,function(){this.animate({opacity:p(t.opacity,1)},h),d(this.element,"load")}).attr({opacity:0}).add(m):this.image(t.image,0,0,f,c).add(m)),t.image&&s||void 0===t.opacity||[].forEach.call(m.element.childNodes,function(e){e.setAttribute("opacity",t.opacity)}),this.patternElements=this.patternElements||{},this.patternElements[u]=m,m}}function C(t){var e=this.options.color;e&&e.pattern&&!e.pattern.color?(delete this.options.color,t.apply(this,[].slice.call(arguments,1)),e.pattern.color=this.color,this.color=this.options.color=e):t.apply(this,[].slice.call(arguments,1))}function A(){if(null===(t=this.chart)||void 0===t?void 0:t.mapView){var t,e,i=this.chart.renderer,r=i.patternElements;(null===(e=i.defIds)||void 0===e?void 0:e.length)&&r&&this.points.filter(function(t){var e,i,r,o;return!!t.graphic&&(t.graphic.element.hasAttribute("fill")||t.graphic.element.hasAttribute("color")||t.graphic.element.hasAttribute("stroke"))&&!(null===(i=null===(e=t.options.color)||void 0===e?void 0:e.pattern)||void 0===i?void 0:i.image)&&!!(null===(r=t.group)||void 0===r?void 0:r.scaleX)&&!!(null===(o=t.group)||void 0===o?void 0:o.scaleY)}).map(function(t){var e,r,o,a,n;return{id:((null===(e=t.graphic)||void 0===e?void 0:e.element.getAttribute("fill"))||(null===(r=t.graphic)||void 0===r?void 0:r.element.getAttribute("color"))||(null===(o=t.graphic)||void 0===o?void 0:o.element.getAttribute("stroke"))||"").replace(i.url,"").replace("url(#","").replace(")",""),x:(null===(a=t.group)||void 0===a?void 0:a.scaleX)||1,y:(null===(n=t.group)||void 0===n?void 0:n.scaleY)||1}}).filter(function(t,e,i){return""!==t.id&&-1!==t.id.indexOf("highcharts-pattern-")&&!i.some(function(i,r){return i.id===t.id&&r<e})}).forEach(function(t){var e=t.id;r[e].scaleX=1/t.x,r[e].scaleY=1/t.y,r[e].updateTransform("patternTransform")})}}return{compose:function(t,e,i){var r=e.prototype.pointClass,o=r.prototype;o.calculatePatternDimensions||(a(t,"endResize",g),a(t,"redraw",m),h(o,{calculatePatternDimensions:w}),a(r,"afterInit",v),a(e,"render",x),c(e.prototype,"getColor",C),a(e,"afterRender",A),a(e,"mapZoomComplete",A),h(i.prototype,{addPattern:b}),a(i,"complexColor",y))},patterns:f}}),i(e,"Series/Pictorial/PictorialUtilities.js",[e["Core/Utilities.js"]],function(t){var e=t.defined;return{rescalePatternFill:function(t,e,i,r,o){void 0===o&&(o=1);var a=t&&t.attr("fill"),n=a&&a.match(/url\(([^)]+)\)/);if(n){var s=document.querySelector("".concat(n[1]," path"));if(s){var h=s.getBBox();if(0===h.width){var l=s.parentElement;t.renderer.box.appendChild(s),h=s.getBBox(),l.appendChild(s)}var p=1/(h.width+o),d=e/r/h.height,c=h.width/h.height,f=i/e,u=-h.width/2;c<f&&(p=p*c/f),s.setAttribute("stroke-width",o/(i*p)),s.setAttribute("transform","translate(0.5, 0)"+"scale(".concat(p," ").concat(d,") ")+"translate(".concat(u+o*p/2,", ").concat(-h.y,")"))}}},invertShadowGroup:function(t,e){var i=e.chart.inverted;i&&t.attr({rotation:i?90:0,scaleX:i?-1:1})},getStackMetrics:function(t,i){var r=t.len,o=0;return i&&e(i.max)&&(o=t.toPixels(i.max,!0),r=t.len-o),{height:r,y:o}}}}),i(e,"Series/Pictorial/PictorialPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Series/Pictorial/PictorialUtilities.js"]],function(t,e){var i,r=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),o=t.seriesTypes.column.prototype.pointClass,a=e.rescalePatternFill,n=e.getStackMetrics;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.setState=function(){t.prototype.setState.apply(this,arguments);var e=this.series,i=e.options.paths;if(this.graphic&&this.shapeArgs&&i){var r=i[this.index%i.length];a(this.graphic,n(e.yAxis,r).height,this.shapeArgs.width||0,this.shapeArgs.height||1/0,this.series.options.borderWidth||0)}},e}(o)}),i(e,"Series/Pictorial/PictorialSeries.js",[e["Extensions/PatternFill.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Chart/Chart.js"],e["Series/Pictorial/PictorialPoint.js"],e["Series/Pictorial/PictorialUtilities.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,r,o,a,n,s,h,l){var p,d=this&&this.__extends||(p=function(t,e){return(p=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}p(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),c=n.seriesTypes.column;t.compose(i,a,h);var f=e.animObject,u=o.getStackMetrics,g=o.invertShadowGroup,m=o.rescalePatternFill,v=l.addEvent,y=l.defined,x=l.merge,w=l.objectEach,b=l.pick,C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return d(e,t),e.prototype.animate=function(t){var e=this.chart,i=this.group,r=f(this.options.animation),o=[this.getSharedClipKey(),r.duration,r.easing,r.defer].join(","),a=e.sharedClips[o];if(t&&i){var n=this.getClipBox();a||(n.y=n.height,n.height=0,a=e.renderer.clipRect(n),e.sharedClips[o]=a),i.clip(a)}else if(a&&!a.hasClass("highcharts-animating")){var s=this.getClipBox();a.addClass("highcharts-animating").animate(s,r)}},e.prototype.animateDrilldown=function(){},e.prototype.animateDrillupFrom=function(){},e.prototype.pointAttribs=function(e){var i=t.prototype.pointAttribs.apply(this,arguments),r=this.options.paths;if(e&&e.shapeArgs&&r){var o=r[e.index%r.length],a=u(this.yAxis,o),n=a.y,s=a.height,h=o.definition;h!==e.pathDef?(e.pathDef=h,i.fill={pattern:{path:{d:h,fill:i.fill,strokeWidth:i["stroke-width"],stroke:i.stroke},x:e.shapeArgs.x,y:n,width:e.shapeArgs.width||0,height:s,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#ff0000"}}):e.pathDef&&e.graphic&&delete i.fill}return delete i.stroke,delete i.strokeWidth,i},e.prototype.getExtremes=function(){var e=t.prototype.getExtremes.apply(this,arguments),i=this.options.paths;return i&&i.forEach(function(t){y(t.max)&&y(e.dataMax)&&t.max>e.dataMax&&(e.dataMax=t.max)}),e},e.defaultOptions=x(c.defaultOptions,{borderWidth:0}),e}(c);function A(t){var e=Object.keys(t.points).filter(function(t){return t.split(",").length>1}),i=t.axis.chart.series,r=e.map(function(t){return parseFloat(t.split(",")[0])}),o=-1;r.forEach(function(t){i[t]&&i[t].visible&&(o=t)});var a=t.axis.chart.series[o];if(a&&a.is("pictorial")&&t.axis.hasData()&&a.xAxis.hasData()){var n=a.xAxis,s=t.axis.options,h=t.axis.chart,l=t.shadow,p=n.toPixels(t.x,!0),d=h.inverted?n.len-p:p,c=a.options.paths||[],f=t.x%c.length,v=c[f],y=a.getColumnMetrics&&a.getColumnMetrics().width,x=u(a.yAxis,v),w=x.height,C=x.y,A=s.stackShadow,_=b(A&&A.borderWidth,a.options.borderWidth,1);if(!l&&A&&A.enabled&&v)t.shadowGroup||(t.shadowGroup=h.renderer.g("shadow-group").add()),t.shadowGroup.attr({translateX:h.inverted?t.axis.pos:n.pos,translateY:h.inverted?n.pos:t.axis.pos}),t.shadow=h.renderer.rect(d,C,y,w).attr({fill:{pattern:{path:{d:v.definition,fill:A.color||"#dedede",strokeWidth:_,stroke:A.borderColor||"transparent"},x:d,y:C,width:y,height:w,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#dedede"}}}).add(t.shadowGroup),g(t.shadowGroup,t.axis),m(t.shadow,w,y,w,_),t.setOffset(a.pointXOffset||0,a.barW||0);else if(l&&t.shadowGroup){l.animate({x:d,y:C,width:y,height:w});var M=l.attr("fill"),S=M&&M.match(/url\(([^)]+)\)/);S&&h.renderer.patternElements&&h.renderer.patternElements[S[1].slice(1)].animate({x:d,y:C,width:y,height:w}),t.shadowGroup.animate({translateX:h.inverted?t.axis.pos:n.pos,translateY:h.inverted?n.pos:t.axis.pos}),g(t.shadowGroup,t.axis),m(l,w,y,w,_),t.setOffset(a.pointXOffset||0,a.barW||0)}}else t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadow=void 0,t.shadowGroup.destroy(),t.shadowGroup=void 0)}function _(t,e){t.axes&&t.axes.forEach(function(t){t.stacking&&w(t.stacking.stacks,function(t){w(t,function(t){e(t)})})})}function M(t){_(t,function(t){t.shadow&&t.shadowGroup&&(t.shadow.destroy(),t.shadowGroup.destroy(),delete t.shadow,delete t.shadowGroup)})}return v(C,"afterRender",function(){var t=this,e=t.options.paths,i=/url\(([^)]+)\)/;t.points.forEach(function(r){if(r.graphic&&r.shapeArgs&&e){var o=e[r.index%e.length],a=r.graphic.attr("fill"),n=a&&a.match(i),s=u(t.yAxis,o),h=s.y,l=s.height;if(n&&t.chart.renderer.patternElements){var p=t.chart.renderer.patternElements[n[1].slice(1)];p&&p.animate({x:r.shapeArgs.x,y:h,width:r.shapeArgs.width||0,height:l})}m(r.graphic,u(t.yAxis,o).height,r.shapeArgs.width||0,r.shapeArgs.height||1/0,t.options.borderWidth||0)}})}),v(i,"render",function(){_(this,A)}),v(s,"afterSetOffset",function(t){if(this.shadow){var e=this.axis,i=e.chart,r=e.len,o=t.xOffset,a=t.width,n=i.inverted?o-i.xAxis[0].len:o,s=i.inverted?-r:0;this.shadow.attr({translateX:n,translateY:s}),this.shadow.animate({width:a})}}),v(i,"afterDrilldown",function(){M(this)}),v(i,"afterDrillUp",function(){M(this)}),C.prototype.pointClass=r,n.registerSeriesType("pictorial",C),C}),i(e,"masters/modules/pictorial.src.js",[e["Core/Globals.js"]],function(t){return t})});