!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * Standalone navigator module
 *
 * (c) 2009-2024 Mateusz Bernacik
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/navigator",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(i,e,s,o){i.hasOwnProperty(e)||(i[e]=o.apply(null,s),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:i[e]}})))}e(i,"Stock/Navigator/ChartNavigatorComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,s=t.isTouchDevice,o=i.addEvent,r=i.merge,a=i.pick,n=[];function h(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function d(){var t,i,e,s,o=this.legend,r=this.navigator;if(r){i=o&&o.options,e=r.xAxis,s=r.yAxis;var n=r.scrollbarHeight,h=r.scrollButtonSize;this.inverted?(r.left=r.opposite?this.chartWidth-n-r.height:this.spacing[3]+n,r.top=this.plotTop+h):(r.left=a(e.left,this.plotLeft+h),r.top=r.navigatorOptions.top||this.chartHeight-r.height-n-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?o.legendHeight+a(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&s&&(this.inverted?e.options.left=s.options.left=r.left:e.options.top=s.options.top=r.top,e.setAxisSize(),s.setAxisSize())}}function l(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this),a(t.redraw,!0)&&this.redraw(t.animation))}function c(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this))}function p(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!s&&"x"===this.zooming.type||s&&"x"===this.zooming.pinchType))return!1}function g(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function u(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(r(!0,this.options.navigator,i),r(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,s){if(i.pushUnique(n,t)){var r=t.prototype;e=s,r.callbacks.push(g),o(t,"afterAddSeries",h),o(t,"afterSetChartSize",d),o(t,"afterUpdate",l),o(t,"beforeRender",c),o(t,"beforeShowResetZoom",p),o(t,"update",u)}}}}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,s=i.addEvent,o=i.correctFloat,r=i.defined,a=i.isNumber,n=i.pick;function h(){this.navigatorAxis||(this.navigatorAxis=new l(this))}function d(t){var i,s=this.chart,o=s.options,a=o.navigator,n=this.navigatorAxis,h=s.zooming.pinchType,d=o.rangeSelector,l=s.zooming.type;if(this.isXAxis&&((null==a?void 0:a.enabled)||(null==d?void 0:d.enabled))){if("y"===l&&"zoom"===t.trigger)i=!1;else if(("zoom"===t.trigger&&"xy"===l||e&&"xy"===h)&&this.options.range){var c=n.previousZoom;r(t.min)?n.previousZoom=[this.min,this.max]:c&&(t.min=c[0],t.max=c[1],n.previousZoom=void 0)}}void 0!==i&&t.preventDefault()}var l=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),s(t,"init",h),s(t,"setExtremes",d))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,s){var h=this.axis,d=(h.pointRange||0)/2,l=n(e,h.translate(t,!0,!h.horiz)),c=n(s,h.translate(i,!0,!h.horiz));return r(e)||(l=o(l+d)),r(s)||(c=o(c-d)),a(l)&&a(c)||(l=c=void 0),{min:l,max:c}},t}();return l}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,s=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,borderRadius:0,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===s.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",id:"navigator-x-axis",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,id:"navigator-y-axis",maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[i["Core/Renderer/SVG/Symbols.js"],i["Core/Utilities.js"]],function(t,i){var e=this&&this.__spreadArray||function(t,i,e){if(e||2==arguments.length)for(var s,o=0,r=i.length;o<r;o++)!s&&o in i||(s||(s=Array.prototype.slice.call(i,0,o)),s[o]=i[o]);return t.concat(s||Array.prototype.slice.call(i))},s=i.relativeLength;return{"navigator-handle":function(i,o,r,a,n){void 0===n&&(n={});var h=n.width?n.width/2:r,d=s(n.borderRadius||0,Math.min(2*h,a));return e([["M",-1.5,(a=n.height||a)/2-3.5],["L",-1.5,a/2+4.5],["M",.5,a/2-3.5],["L",.5,a/2+4.5]],t.rect(-h-1,.5,2*h+1,a,{r:d}),!0)}}}),e(i,"Stock/Utilities/StockUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined;return{setFixedRange:function(t){var e=this.xAxis[0];i(e.dataMax)&&i(e.dataMin)&&t?this.fixedRange=Math.min(t,e.dataMax-e.dataMin):this.fixedRange=t}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,s,o,r,a,n){var h=t.setOptions,d=i.composed,l=r.getRendererType,c=a.setFixedRange,p=n.addEvent,g=n.extend,u=n.pushUnique;function v(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,r){e.compose(i),u(d,"Navigator")&&(t.prototype.setFixedRange=c,g(l().prototype.symbols,o),p(r,"afterUpdate",v),h({navigator:s}))}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,s=t.composed,o=i.addEvent,r=i.defined,a=i.pick,n=i.pushUnique;return function(t){var i;function e(t){var i=a(t.options&&t.options.min,t.min),e=a(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:r(t.dataMin)?Math.min(i,t.min,t.dataMin,a(t.threshold,1/0)):i,scrollMax:r(t.dataMax)?Math.max(e,t.max,t.dataMax,a(t.threshold,-1/0)):e}}function h(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function d(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),o(t.scrollbar,"changed",function(i){var s,o,a=e(t),n=a.axisMin,h=a.axisMax,d=a.scrollMin,l=a.scrollMax-d;if(r(n)&&r(h)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(s=d+l*this.to,o=d+l*this.from):(s=d+l*(1-this.from),o=d+l*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var c="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(o,s,!0,c,i)}else this.setRange(this.from,this.to)}}))}function l(){var t,i,s,o=e(this),a=o.scrollMin,n=o.scrollMax,h=this.scrollbar,d=this.axisTitleMargin+(this.titleOffset||0),l=this.chart.scrollbarsOffsets,c=this.options.margin||0;if(h&&l){if(this.horiz)this.opposite||(l[1]+=d),h.position(this.left,this.top+this.height+2+l[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(l[1]+=c),t=1;else{this.opposite&&(l[0]+=d);var p=void 0;p=h.options.opposite?this.left+this.width+2+l[0]-(this.opposite?0:c):this.opposite?0:c,h.position(p,this.top,this.width,this.height),this.opposite&&(l[0]+=c),t=0}l[t]+=h.size+(h.options.margin||0),isNaN(a)||isNaN(n)||!r(this.min)||!r(this.max)||this.min===this.max?h.setRange(0,1):(i=(this.min-a)/(n-a),s=(this.max-a)/(n-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(i,s):h.setRange(1-s,1-i))}}t.compose=function(t,e){n(s,"Axis.Scrollbar")&&(i=e,o(t,"afterGetOffset",h),o(t,"afterInit",d),o(t,"afterRender",l))}}(e||(e={})),e}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,s,o){var r=t.defaultOptions,a=o.addEvent,n=o.correctFloat,h=o.crisp,d=o.defined,l=o.destroyObjectProperties,c=o.fireEvent,p=o.merge,g=o.pick,u=o.removeEvent,v=function(){function t(t,i,e){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,s=0;s<e;s+=2)"number"==typeof(i=t[s+1])&&(t[s+1]=t[s+2],t[s+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,e=this.scrollbarGroup.element,s=this.track.element,o=this.mouseDownHandler.bind(this),r=this.mouseMoveHandler.bind(this),n=this.mouseUpHandler.bind(this),h=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[e,"mousedown",o],[e.ownerDocument,"mousemove",r],[e.ownerDocument,"mouseup",n],[e,"touchstart",o],[e.ownerDocument,"touchmove",r],[e.ownerDocument,"touchend",n]];h.forEach(function(t){a.apply(null,t)}),this._events=h},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*g(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),c(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=n(this.to-this.from)*g(this.options.step,.2);this.updatePosition(n(this.from-i),n(this.to-i)),c(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,l(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,s=this.scrollbarButtons,o=this.options,r=this.size,a=e.g().add(this.group);if(s.push(a),o.buttonsEnabled){var n=e.rect().addClass("highcharts-scrollbar-button").add(a);this.chart.styledMode||n.attr({stroke:o.buttonBorderColor,"stroke-width":o.buttonBorderWidth,fill:o.buttonBackgroundColor}),n.attr(n.crisp({x:-.5,y:-.5,width:r,height:r,r:o.buttonBorderRadius},n.strokeWidth()));var h=e.path(t.swapXY([["M",r/2+(i?-1:1),r/2-3],["L",r/2+(i?-1:1),r/2+3],["L",r/2+(i?2:-2),r/2]],o.vertical)).addClass("highcharts-scrollbar-arrow").add(s[i]);this.chart.styledMode||h.attr({fill:o.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=p(s,r.scrollbar,i),this.options.margin=g(this.options.margin,10),this.chart=e,this.size=g(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,s=this.cursorToScrollbarPosition(e);this.chartX=s.chartX,this.chartY=s.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e,s=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.options.vertical?"chartY":"chartX",r=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(e=this.cursorToScrollbarPosition(s)[o]-this[o],this.hasDragged=!0,this.updatePosition(r[0]+e,r[1]+e),this.hasDragged&&c(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&c(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,s){var o=this.options,r=o.buttonsEnabled,a=o.margin,n=void 0===a?0:a,h=o.vertical,d=this.rendered?"animate":"attr",l=s,c=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=s,this.xOffset=l,this.yOffset=c,h?(this.width=this.yOffset=e=c=this.size,this.xOffset=l=0,this.yOffset=c=r?this.size:0,this.barWidth=s-(r?2*e:0),this.x=t+=n):(this.height=s=this.size,this.xOffset=l=r?this.size:0,this.barWidth=e-(r?2*s:0),this.y=this.y+n),this.group[d]({translateX:t,translateY:this.y}),this.track[d]({width:e,height:s}),this.scrollbarButtons[1][d]({translateX:h?0:e-l,translateY:h?s-c:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){u.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,s=this.size,o=this.chart.styledMode,r=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=r,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:s,width:s}).add(r),o||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var a=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-h(0,a),y:-h(0,a)}),this.scrollbarGroup=i.g().add(r),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:s-a,width:s-a,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,s/4],["L",-3,2*s/3],["M",0,s/4],["L",0,2*s/3],["M",3,s/4],["L",3,2*s/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),o||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-h(0,this.scrollbarStrokeWidth),-h(0,this.scrollbarStrokeWidth)),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,s,o=this.options,r=o.vertical,a=o.minWidth,h=this.barWidth,l=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(d(h)){var c=h*Math.min(i,1);e=Math.ceil(h*(t=Math.max(t,0))),this.calculatedWidth=s=n(c-e),s<a&&(e=(h-a+s)*t,s=a);var p=Math.floor(e+this.xOffset+this.yOffset),g=s/2-.5;this.from=t,this.to=i,r?(this.scrollbarGroup[l]({translateY:p}),this.scrollbar[l]({height:s}),this.scrollbarRifles[l]({translateY:g}),this.scrollbarTop=p,this.scrollbarLeft=0):(this.scrollbarGroup[l]({translateX:p}),this.scrollbar[l]({width:s}),this.scrollbarRifles[l]({translateX:g}),this.scrollbarLeft=p,this.scrollbarTop=0),s<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return g(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!d(t)},t.prototype.trackClick=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,s=this.to-this.from,o=this.y+this.scrollbarTop,r=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>o||!this.options.vertical&&e.chartX>r?this.updatePosition(this.from+s,this.to+s):this.updatePosition(this.from-s,this.to-s),c(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,p(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=n(1-n(i-t)),i=1),t<0&&(i=n(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=s,t}();return r.scrollbar=p(!0,v.defaultOptions,r.scrollbar),v}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Stock/Navigator/ChartNavigatorComposition.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Renderer/SVG/SVGRenderer.js"],i["Core/Utilities.js"]],function(t,i,e,s,o,r,a,n,h){var d=this&&this.__assign||function(){return(d=Object.assign||function(t){for(var i,e=1,s=arguments.length;e<s;e++)for(var o in i=arguments[e])Object.prototype.hasOwnProperty.call(i,o)&&(t[o]=i[o]);return t}).apply(this,arguments)},l=e.defaultOptions,c=s.isTouchDevice,p=n.prototype.symbols,g=h.addEvent,u=h.clamp,v=h.correctFloat,f=h.defined,x=h.destroyObjectProperties,m=h.erase,b=h.extend,y=h.find,M=h.fireEvent,A=h.isArray,S=h.isNumber,k=h.merge,E=h.pick,w=h.removeEvent,O=h.splat;function C(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var s=[].filter.call(i,S);if(s.length)return Math[t].apply(0,s)}return function(){function e(t){this.isDirty=!1,this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,s,o){i.compose(t,e),r.compose(t,s,o)},e.prototype.drawHandle=function(t,i,e,s){var o=this.navigatorOptions.handles.height;this.handles[i][s](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})},e.prototype.drawOutline=function(t,i,e,s){var o,r,a=this.navigatorOptions.maskInside,n=this.outline.strokeWidth(),h=n/2,d=n%2/2,l=this.scrollButtonSize,c=this.size,p=this.top,g=this.height,u=p-h,v=p+g,f=this.left;e?(o=p+i+d,i=p+t+d,r=[["M",f+g,p-l-d],["L",f+g,o],["L",f,o],["M",f,i],["L",f+g,i],["L",f+g,p+c+l]],a&&r.push(["M",f+g,o-h],["L",f+g,i+h])):(f-=l,t+=f+l-d,i+=f+l-d,r=[["M",f,u],["L",t,u],["L",t,v],["M",i,v],["L",i,u],["L",f+c+2*l,u]],a&&r.push(["M",t-h,u],["L",i+h,u])),this.outline[s]({d:r})},e.prototype.drawMasks=function(t,i,e,s){var o,r,a,n,h=this.left,d=this.top,l=this.height;e?(a=[h,h,h],n=[d,d+t,d+i],r=[l,l,l],o=[t,i-t,this.size-i]):(a=[h,h+t,h+i],n=[d,d,d],r=[t,i-t,this.size-i],o=[l,l,l]),this.shades.forEach(function(t,i){t[s]({x:a[i],y:n[i],width:r[i],height:o[i]})})},e.prototype.renderElements=function(){var t,i,e=this,s=e.navigatorOptions,o=s.maskInside,r=e.chart,a=r.inverted,n=r.renderer,h={cursor:a?"ns-resize":"ew-resize"},d=null!==(t=e.navigatorGroup)&&void 0!==t?t:e.navigatorGroup=n.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!o,o,!o].forEach(function(t,i){var o,a=null!==(o=e.shades[i])&&void 0!==o?o:e.shades[i]=n.rect().addClass("highcharts-navigator-mask"+(1===i?"-inside":"-outside")).add(d);r.styledMode||(a.attr({fill:t?s.maskFill:"rgba(0,0,0,0)"}),1===i&&a.css(h))}),e.outline||(e.outline=n.path().addClass("highcharts-navigator-outline").add(d)),r.styledMode||e.outline.attr({"stroke-width":s.outlineWidth,stroke:s.outlineColor}),null===(i=s.handles)||void 0===i?void 0:i.enabled){var l=s.handles,c=l.height,g=l.width;[0,1].forEach(function(t){var i=l.symbols[t];if(e.handles[t]){if(i!==e.handles[t].symbolName){var s=p[i].call(p,-g/2-1,0,g,c);e.handles[t].attr({d:s}),e.handles[t].symbolName=i}}else e.handles[t]=n.symbol(i,-g/2-1,0,g,c,l),e.handles[t].attr({zIndex:7-t}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][t]).add(d);r.inverted&&e.handles[t].attr({rotation:90,rotationOriginX:Math.floor(-g/2),rotationOriginY:(c+g)/2}),r.styledMode||e.handles[t].attr({fill:l.backgroundColor,stroke:l.borderColor,"stroke-width":l.lineWidth,width:l.width,height:l.height,x:-g/2-1,y:0}).css(h)})}},e.prototype.update=function(t,i){var e,s,o,r,a=this;void 0===i&&(i=!1);var n=this.chart,h=n.options.chart.inverted!==(null===(o=n.scrollbar)||void 0===o?void 0:o.options.vertical);if(k(!0,n.options.navigator,t),this.navigatorOptions=n.options.navigator||{},this.setOpposite(),f(t.enabled)||h)return this.destroy(),this.navigatorEnabled=t.enabled||this.navigatorEnabled,this.init(n);if(this.navigatorEnabled&&(this.isDirty=!0,!1===t.adaptToUpdatedData&&this.baseSeries.forEach(function(t){w(t,"updatedData",a.updatedDataHandler)},this),t.adaptToUpdatedData&&this.baseSeries.forEach(function(t){t.eventsToUnbind.push(g(t,"updatedData",a.updatedDataHandler))},this),(t.series||t.baseSeries)&&this.setBaseSeries(void 0,!1),t.height||t.xAxis||t.yAxis)){this.height=null!==(r=t.height)&&void 0!==r?r:this.height;var l=this.getXAxisOffsets();this.xAxis.update(d(d({},t.xAxis),((e={offsets:l})[n.inverted?"width":"height"]=this.height,e[n.inverted?"height":"width"]=void 0,e)),!1),this.yAxis.update(d(d({},t.yAxis),((s={})[n.inverted?"width":"height"]=this.height,s)),!1)}i&&n.redraw()},e.prototype.render=function(t,i,e,s){var o,r,a,n,h,d=this.chart,l=this.xAxis,c=l.pointRange||0,p=l.navigatorAxis.fake?d.xAxis[0]:l,g=this.navigatorEnabled,x=this.rendered,m=d.inverted,b=d.xAxis[0].minRange,y=d.xAxis[0].options.maxRange,A=this.scrollButtonSize,k=this.scrollbarHeight;if(!this.hasDragged||f(e)){if(this.isDirty&&this.renderElements(),t=v(t-c/2),i=v(i+c/2),!S(t)||!S(i)){if(!x)return;e=0,s=E(l.width,p.width)}this.left=E(l.left,d.plotLeft+A+(m?d.plotWidth:0));var w=this.size=n=E(l.len,(m?d.plotHeight:d.plotWidth)-2*A);o=m?k:n+2*A,e=E(e,l.toPixels(t,!0)),s=E(s,l.toPixels(i,!0)),S(e)&&Math.abs(e)!==1/0||(e=0,s=o);var O=l.toValue(e,!0),C=l.toValue(s,!0),D=Math.abs(v(C-O));D<b?this.grabbedLeft?e=l.toPixels(C-b-c,!0):this.grabbedRight&&(s=l.toPixels(O+b+c,!0)):f(y)&&v(D-c)>y&&(this.grabbedLeft?e=l.toPixels(C-y-c,!0):this.grabbedRight&&(s=l.toPixels(O+y+c,!0))),this.zoomedMax=u(Math.max(e,s),0,w),this.zoomedMin=u(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,s),0,w),this.range=this.zoomedMax-this.zoomedMin,w=Math.round(this.zoomedMax);var z=Math.round(this.zoomedMin);g&&(this.navigatorGroup.attr({visibility:"inherit"}),h=x&&!this.hasDragged?"animate":"attr",this.drawMasks(z,w,m,h),this.drawOutline(z,w,m,h),this.navigatorOptions.handles.enabled&&(this.drawHandle(z,0,m,h),this.drawHandle(w,1,m,h))),this.scrollbar&&(m?(a=this.top-A,r=this.left-k+(g||!p.opposite?0:(p.titleOffset||0)+p.axisTitleMargin),k=n+2*A):(a=this.top+(g?this.height:-k),r=this.left-A),this.scrollbar.position(r,a,o,k),this.scrollbar.setRange(this.zoomedMin/(n||1),this.zoomedMax/(n||1))),this.rendered=!0,this.isDirty=!1,M(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,i,e=this,s=e.chart,o=s.container,r=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(r=e.getPartsEvents("mousedown")).push(g(s.renderTo,"mousemove",t),g(o.ownerDocument,"mouseup",i),g(s.renderTo,"touchmove",t),g(o.ownerDocument,"touchend",i)),r.concat(e.getPartsEvents("touchstart")),e.eventsToUnbind=r,e.series&&e.series[0]&&r.push(g(e.series[0].xAxis,"foundExtremes",function(){s.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(s){i[s].forEach(function(o,r){e.push(g(o.element,t,function(t){i[s+"Mousedown"](t,r)}))})}),e},e.prototype.shadesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,s,o,r,a,n=this.chart,h=this.xAxis,d=this.zoomedMin,l=this.size,c=this.range,p=this.left,g=t.chartX;n.inverted&&(g=t.chartY,p=this.top),1===i?(this.grabbedCenter=g,this.fixedWidth=c,this.dragOffset=g-d):(a=g-p-c/2,0===i?a=Math.max(0,a):2===i&&a+c>=l&&(a=l-c,this.reversedExtremes?(a-=c,o=this.getUnionExtremes().dataMin):s=this.getUnionExtremes().dataMax),a!==d&&(this.fixedWidth=c,f((r=h.navigatorAxis.toFixedRange(a,a+c,o,s)).min)&&M(this,"setRange",{min:Math.min(r.min,r.max),max:Math.max(r.min,r.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},e.prototype.handlesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,s=this.chart,o=s.xAxis[0],r=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=r?o.min:o.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=r?o.max:o.min),s.setFixedRange(void 0)},e.prototype.onMouseMove=function(t){var i,e,s=this,o=s.chart,r=s.navigatorSize,a=s.range,n=s.dragOffset,h=o.inverted,d=s.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=(null===(i=o.pointer)||void 0===i?void 0:i.normalize(t))||t).chartX,h&&(d=s.top,e=t.chartY),s.grabbedLeft?(s.hasDragged=!0,s.render(0,0,e-d,s.otherHandlePos)):s.grabbedRight?(s.hasDragged=!0,s.render(0,0,s.otherHandlePos,e-d)):s.grabbedCenter&&(s.hasDragged=!0,e<n?e=n:e>r+n-a&&(e=r+n-a),s.render(0,0,e-n,e-n+a)),s.hasDragged&&s.scrollbar&&E(s.scrollbar.options.liveRedraw,!c&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){s.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var i,e,s,o,r,a,n=this.chart,h=this.xAxis,d=this.scrollbar,l=t.DOMEvent||t,c=n.inverted,p=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!d||!d.hasDragged)||"scrollbar"===t.trigger)&&(s=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?s.dataMin:s.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?s.dataMax:s.dataMin),f((a=h.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&M(this,"setRange",{min:Math.min(a.min,a.max),max:Math.max(a.min,a.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:l}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&S(this.zoomedMin)&&S(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,c,p),this.outline&&this.drawOutline(e,i,c,p),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,c,p),this.drawHandle(i,1,c,p)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){w(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&w(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.getXAxisOffsets=function(){return this.chart.inverted?[this.scrollButtonSize,0,-this.scrollButtonSize,0]:[0,-this.scrollButtonSize,0,this.scrollButtonSize]},e.prototype.init=function(i){var e=i.options,s=e.navigator||{},r=s.enabled,n=e.scrollbar||{},h=n.enabled,d=r&&s.height||0,l=h&&n.height||0,c=n.buttonsEnabled&&l||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=d,this.scrollbarHeight=l,this.scrollButtonSize=c,this.scrollbarEnabled=h,this.navigatorEnabled=r,this.navigatorOptions=s,this.scrollbarOptions=n,this.setOpposite();var p=this,u=p.baseSeries,v=i.xAxis.length,f=i.yAxis.length,x=u&&u[0]&&u[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,p.navigatorEnabled){var m=this.getXAxisOffsets();p.xAxis=new t(i,k({breaks:x.options.breaks,ordinal:x.options.ordinal,overscroll:x.options.overscroll},s.xAxis,{type:"datetime",index:v,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:x.options.ordinal?0:x.options.minPadding,maxPadding:x.options.ordinal?0:x.options.maxPadding,zoomEnabled:!1},i.inverted?{offsets:m,width:d}:{offsets:m,height:d}),"xAxis"),p.yAxis=new t(i,k(s.yAxis,{alignTicks:!1,offset:0,index:f,isInternal:!0,reversed:E(s.yAxis&&s.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:d}:{height:d}),"yAxis"),u||s.series.data?p.updateNavigatorSeries(!1):0===i.series.length&&(p.unbindRedraw=g(i,"beforeRedraw",function(){i.series.length>0&&!p.series&&(p.setBaseSeries(),p.unbindRedraw())})),p.reversedExtremes=i.inverted&&!p.xAxis.reversed||!i.inverted&&p.xAxis.reversed,p.renderElements(),p.addMouseEvents()}else p.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var s=i.xAxis[0],o=s.getExtremes(),r=s.len-2*c,a=C("min",s.options.min,o.dataMin),n=C("max",s.options.max,o.dataMax)-a;return e?t*n/r+a:r*(t-a)/n},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},p.xAxis.navigatorAxis.axis=p.xAxis,p.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(p.xAxis.navigatorAxis);if(i.options.scrollbar.enabled){var b=k(i.options.scrollbar,{vertical:i.inverted});!S(b.margin)&&p.navigatorEnabled&&(b.margin=i.inverted?-3:3),i.scrollbar=p.scrollbar=new a(i.renderer,b,i),g(p.scrollbar,"changed",function(t){var i=p.size,e=i*this.to,s=i*this.from;p.hasDragged=p.scrollbar.hasDragged,p.render(0,0,s,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){p.onMouseUp(t)})})}p.addBaseSeriesEvents(),p.addChartEvents()},e.prototype.setOpposite=function(){var t=this.navigatorOptions,i=this.navigatorEnabled,e=this.chart;this.opposite=E(t.opposite,!!(!i&&e.inverted))},e.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],s=this.xAxis,o=s.options,r=e.options;return t&&null===e.dataMin||(i={dataMin:E(o&&o.min,C("min",r.min,e.dataMin,s.dataMin,s.min)),dataMax:E(o&&o.max,C("max",r.max,e.dataMax,s.dataMax,s.max))}),i},e.prototype.setBaseSeries=function(t,i){var e=this.chart,s=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?y(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&s.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},e.prototype.updateNavigatorSeries=function(t,i){var e,s,o,r,a,n=this,h=n.chart,d=n.baseSeries,c={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:null===(e=this.navigatorOptions.xAxis)||void 0===e?void 0:e.id,yAxis:null===(s=this.navigatorOptions.yAxis)||void 0===s?void 0:s.id,showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},p=n.series=(n.series||[]).filter(function(t){var i=t.baseSeries;return!(0>d.indexOf(i))||(i&&(w(i,"updatedData",n.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),g=n.navigatorOptions.series;d&&d.length&&d.forEach(function(t){var e=t.navigatorSeries,s=b({color:t.color,visible:t.visible},A(g)?l.navigator.series:g);if(!e||!1!==n.navigatorOptions.adaptToUpdatedData){c.name="Navigator "+d.length,a=(o=t.options||{}).navigatorOptions||{},s.dataLabels=O(s.dataLabels),(r=k(o,c,s,a)).pointRange=E(s.pointRange,a.pointRange,l.plotOptions[r.type||"line"].pointRange);var u=a.data||s.data;n.hasNavigatorData=n.hasNavigatorData||!!u,r.data=u||o.data&&o.data.slice(0),e&&e.options?e.update(r,i):(t.navigatorSeries=h.initSeries(r),h.setSortedData(),t.navigatorSeries.baseSeries=t,p.push(t.navigatorSeries))}}),(g.data&&!(d&&d.length)||A(g))&&(n.hasNavigatorData=!1,(g=O(g)).forEach(function(t,i){c.name="Navigator "+(p.length+1),(r=k(l.navigator.series,{color:h.series[i]&&!h.series[i].options.isInternal&&h.series[i].color||h.options.colors[i]||h.options.colors[0]},c,t)).data=t.data,r.data&&(n.hasNavigatorData=!0,p.push(h.initSeries(r)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(g(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(s){s.eventsToUnbind.push(g(s,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),s.eventsToUnbind.push(g(s,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&s.xAxis&&s.eventsToUnbind.push(g(s,"updatedData",t.updatedDataHandler)),s.eventsToUnbind.push(g(s,"remove",function(){e&&m(e,s),this.navigatorSeries&&(m(i.series,this.navigatorSeries),f(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,i,e,s=this.chart.navigator,o=this.getExtremes(),r=o.min,a=o.max,n=o.dataMin,h=o.dataMax,d=a-r,l=s.stickToMin,c=s.stickToMax,p=E(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),g=s.series&&s.series[0],u=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(l&&(i=(e=n)+d),c&&(i=h+p,l||(e=Math.max(n,i-d,s.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE)))),u&&(l||c)&&S(e)&&(this.min=this.userMin=e,this.max=this.userMax=i)),s.stickToMin=s.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=E(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),s=t.xAxis,o=s.max,r=s.min,a=s.options.range;return!!(S(o)&&S(r))&&(a&&o-e>0?o-e<a:r<=e)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(g(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),g(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),g(e,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(m(this.chart.xAxis,this.xAxis),m(this.chart.axes,this.xAxis)),this.yAxis&&(m(this.chart.yAxis,this.yAxis),m(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){x(t)}),this.navigatorEnabled=!1},e}()}),e(i,"Stock/Navigator/StandaloneNavigatorDefaults.js",[],function(){return{chart:{height:70,margin:[0,5,0,5]},exporting:{enabled:!1},legend:{enabled:!1},navigator:{enabled:!1},plotOptions:{series:{states:{hover:{enabled:!1}},marker:{enabled:!1}}},scrollbar:{enabled:!1},title:{text:""},tooltip:{enabled:!1},xAxis:{visible:!1},yAxis:{height:0,visible:!1}}}),e(i,"Stock/Navigator/StandaloneNavigator.js",[i["Core/Chart/Chart.js"],i["Stock/Navigator/Navigator.js"],i["Core/Globals.js"],i["Core/Utilities.js"],i["Core/Axis/Axis.js"],i["Stock/Navigator/StandaloneNavigatorDefaults.js"]],function(t,i,e,s,o,r){var a=s.merge,n=s.addEvent,h=s.fireEvent,d=s.pick;return function(){function s(s,o){this.boundAxes=[],this.userOptions=o,this.chartOptions=a(e.getOptions(),r,{navigator:o});var n=new t(s,this.chartOptions);n.options=a(n.options,{navigator:{enabled:!0},scrollbar:{enabled:!0}}),this.chartOptions.navigator&&this.chartOptions.scrollbar&&(this.chartOptions.navigator.enabled=!0,this.chartOptions.scrollbar.enabled=!0),this.navigator=new i(n),n.navigator=this.navigator,this.initNavigator()}return s.navigator=function(t,i){var o=new s(t,i);return e.navigators?e.navigators.push(o):e.navigators=[o],o},s.prototype.bind=function(i,e){var s=this;void 0===e&&(e=!0);var r=this,a=i instanceof t?i.xAxis[0]:i;if(a instanceof o){var h=this.navigator.xAxis,d=h.min,l=h.max,c=[];if(e){var p=n(a,"setExtremes",function(t){("pan"===t.trigger||"zoom"===t.trigger||"mouseWheelZoom"===t.trigger)&&r.setRange(t.min,t.max,!0,"pan"!==t.trigger,{trigger:a})});c.push(p)}var g=n(this.navigator,"setRange",function(t){a.setExtremes(t.min,t.max,t.redraw,t.animation)});c.push(g);var u=this.boundAxes.filter(function(t){return t.axis===a})[0];u||(u={axis:a,callbacks:[]},this.boundAxes.push(u)),u.callbacks=c,a.series.forEach(function(t){t.options.showInNavigator&&r.addSeries(t.options)}),a.setExtremes(d,l),n(a,"destroy",function(t){t.keepEvents||s.unbind(a)})}},s.prototype.unbind=function(t){if(!t){this.boundAxes.forEach(function(t){t.callbacks.forEach(function(t){return t()})}),this.boundAxes.length=0;return}for(var i=t instanceof o?t:t.xAxis[0],e=this.boundAxes.length-1;e>=0;e--)this.boundAxes[e].axis===i&&(this.boundAxes[e].callbacks.forEach(function(t){return t()}),this.boundAxes.splice(e,1))},s.prototype.destroy=function(){this.boundAxes.forEach(function(t){t.callbacks.forEach(function(t){return t()})}),this.boundAxes.length=0,this.navigator.destroy(),this.navigator.chart.destroy()},s.prototype.update=function(t,i){this.chartOptions=a(this.chartOptions,{navigator:t}),this.navigator.chart.update(this.chartOptions,i)},s.prototype.redraw=function(){this.navigator.chart.redraw()},s.prototype.addSeries=function(t){this.navigator.chart.addSeries(a(t,{showInNavigator:d(t.showInNavigator,!0)})),this.navigator.setBaseSeries()},s.prototype.initNavigator=function(){var t,i=this.navigator;i.top=1,i.xAxis.setScale(),i.yAxis.setScale(),i.xAxis.render(),i.yAxis.render(),null===(t=i.series)||void 0===t||t.forEach(function(t){t.translate(),t.render(),t.redraw()});var e=this.getInitialExtremes(),s=e.min,o=e.max;i.chart.xAxis[0].userMin=s,i.chart.xAxis[0].userMax=o,i.render(s,o)},s.prototype.getRange=function(){var t=this.navigator.chart.xAxis[0].getExtremes(),i=t.min,e=t.max,s=this.navigator.xAxis.getExtremes(),o=s.userMin,r=s.userMax,a=s.min,n=s.max;return{min:d(i,a),max:d(e,n),dataMin:a,dataMax:n,userMin:o,userMax:r}},s.prototype.setRange=function(t,i,e,s,o){h(this.navigator,"setRange",{min:t,max:i,redraw:e,animation:s,eventArguments:a(o,{trigger:"navigator"})})},s.prototype.getInitialExtremes=function(){var t=this.navigator.xAxis.getExtremes();return{min:t.min,max:t.max}},s}()}),e(i,"masters/modules/navigator.src.js",[i["Core/Globals.js"],i["Stock/Navigator/StandaloneNavigator.js"],i["Stock/Navigator/NavigatorComposition.js"]],function(t,i,e){return t.StandaloneNavigator=t.StandaloneNavigator||i,t.navigator=t.StandaloneNavigator.navigator,e.compose(t.Chart,t.Axis,t.Series),t})});