!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * Marker clusters module for Highcharts
 *
 * (c) 2010-2024 Wojciech Chmiel
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/marker-clusters",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function r(e,r,i,a){e.hasOwnProperty(r)||(e[r]=a.apply(null,i),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:r,module:e[r]}})))}r(e,"Extensions/MarkerClusters/MarkerClusterDefaults.js",[],function(){return{cluster:{enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}},tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}}}),r(e,"Extensions/MarkerClusters/MarkerClusterScatter.js",[e["Core/Animation/AnimationUtilities.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Core/Utilities.js"]],function(t,e,r){var i,a=t.animObject,s=e.cluster,n=r.addEvent,o=r.defined,l=r.error,u=r.isArray,p=r.isFunction,d=r.isObject,h=r.isNumber,c=r.merge,f=r.objectEach,m=r.relativeLength,g=r.syncTimeout,x={grid:function(t,e,r,i){var a,s,n,o,l,u={},p=this.getGridOffset(),d=this.getScaledGridSize(i);for(l=0;l<t.length;l++){var h=F(this,{x:t[l],y:e[l]});a=h.x-p.plotLeft,s=h.y-p.plotTop,n=Math.floor(a/d),u[o=Math.floor(s/d)+"-"+n]||(u[o]=[]),u[o].push({dataIndex:r[l],x:t[l],y:e[l]})}return u},kmeans:function(t,e,r,i){var a,n=[],o=[],l={},u=i.processedDistance||s.layoutAlgorithm.distance,p=i.iterations,d=0,h=!0,c=0,f=0,m=[];i.processedGridSize=i.processedDistance;var g=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,t,e,r,i):{};for(var x in g)g[x].length>1&&(a=I(g[x]),n.push({posX:a.x,posY:a.y,oldX:0,oldY:0,startPointsLen:g[x].length,points:[]}));for(;h;){for(var y=0;y<n.length;y++)n[y].points.length=0;o.length=0;for(var C=0;C<t.length;C++)c=t[C],f=e[C],(m=this.getClusterDistancesFromPoint(n,c,f)).length&&m[0].distance<u?n[m[0].clusterIndex].points.push({x:c,y:f,dataIndex:r[C]}):o.push({x:c,y:f,dataIndex:r[C]});for(var C=0;C<n.length;C++)1===n[C].points.length&&(m=this.getClusterDistancesFromPoint(n,n[C].points[0].x,n[C].points[0].y))[1].distance<u&&(n[m[1].clusterIndex].points.push(n[C].points[0]),n[m[0].clusterIndex].points.length=0);h=!1;for(var C=0;C<n.length;C++)a=I(n[C].points),n[C].oldX=n[C].posX,n[C].oldY=n[C].posY,n[C].posX=a.x,n[C].posY=a.y,(n[C].posX>n[C].oldX+1||n[C].posX<n[C].oldX-1||n[C].posY>n[C].oldY+1||n[C].posY<n[C].oldY-1)&&(h=!0);p&&(h=d<p-1),d++}for(var C=0,k=n.length;C<k;++C)l["cluster"+C]=n[C].points;for(var C=0,k=o.length;C<k;++C)l["noise"+C]=[o[C]];return l},optimizedKmeans:function(t,e,r,i){var a,n,l,u=i.processedDistance||s.layoutAlgorithm.gridSize,p=this.getRealExtremes(),d=(this.options.cluster||{}).marker,h={};if(!this.markerClusterInfo||this.initMaxX&&this.initMaxX<p.maxX||this.initMinX&&this.initMinX>p.minX||this.initMaxY&&this.initMaxY<p.maxY||this.initMinY&&this.initMinY>p.minY)this.initMaxX=p.maxX,this.initMinX=p.minX,this.initMaxY=p.maxY,this.initMinY=p.minY,h=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,t,e,r,i):{},this.baseClusters=null;else{this.baseClusters||(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise});for(var c=0,f=this.baseClusters.clusters;c<f.length;c++){var m=f[c];m.pointsOutside=[],m.pointsInside=[];for(var g=0,x=m.data;g<x.length;g++){var y=x[g],C=F(this,y),k=F(this,m);a=Math.sqrt(Math.pow(C.x-k.x,2)+Math.pow(C.y-k.y,2)),n=u-(l=m.clusterZone&&m.clusterZone.marker&&m.clusterZone.marker.radius?m.clusterZone.marker.radius:d&&d.radius?d.radius:s.marker.radius)>=0?u-l:l,a>l+n&&o(m.pointsOutside)?m.pointsOutside.push(y):o(m.pointsInside)&&m.pointsInside.push(y)}m.pointsInside.length&&(h[m.id]=m.pointsInside);for(var v=0,M=0,I=m.pointsOutside;M<I.length;M++){var S=I[M];h[m.id+"_noise"+v++]=[S]}}for(var b=0,A=this.baseClusters.noise;b<A.length;b++){var X=A[b];h[X.id]=X.data}}return h}},y=[],C=0;function k(t,e,r){t.attr({opacity:e}).animate({opacity:1},r)}function v(t,e,r,i){M(t,i,r,!0,!0);for(var a=0;a<e.length;a++){var s=e[a];s.point&&s.point.destroy&&s.point.destroy()}}function M(t,e,r,i,a){t.point&&(i&&t.point.graphic&&(t.point.graphic.show(),k(t.point.graphic,e,r)),a&&t.point.dataLabel&&(t.point.dataLabel.show(),k(t.point.dataLabel,e,r)))}function I(t){for(var e=t.length,r=0,i=0,a=0;a<e;a++)r+=t[a].x,i+=t[a].y;return{x:r/e,y:i/e}}function S(t,e){var r=[];return r.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){r[t.dataIndex]=t})}),t.noise.forEach(function(t){r[t.data[0].dataIndex]=t.data[0]}),r}function b(){return Math.random().toString(36).substring(2,7)+"-"+C++}function A(t,e,r){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),r&&t.point.dataLabel&&t.point.dataLabel.hide())}function X(t){(t.point||t.target).firePointEvent("drillToCluster",t,function(t){var e,r,i,a=t.point||t.target,s=a.series,n=a.series.xAxis,o=a.series.yAxis,l=a.series.chart,u=l.inverted,p=l.mapView,d=l.pointer;if((s.options.cluster||{}).drillToCluster&&a.clusteredData){var h=a.clusteredData.map(function(t){return t.x}).sort(function(t,e){return t-e}),c=a.clusteredData.map(function(t){return t.y}).sort(function(t,e){return t-e}),f=h[0],m=h[h.length-1],g=c[0],x=c[c.length-1],y=Math.abs((m-f)*.1),C=Math.abs((x-g)*.1),k=Math.min(f,m)-y,v=Math.max(f,m)+y,M=Math.min(g,x)-C,I=Math.max(g,x)+C;if(p)p.fitToBounds({x1:k,x2:v,y1:M,y2:I});else if(n&&o){var S=n.toPixels(k),b=n.toPixels(v),A=o.toPixels(M),X=o.toPixels(I);u&&(S=(e=[A,X,S,b])[0],b=e[1],A=e[2],X=e[3]),S>b&&(S=(r=[b,S])[0],b=r[1]),A>X&&(A=(i=[X,A])[0],X=i[1]),d&&(d.zoomX=!0,d.zoomY=!0),l.transform({from:{x:S,y:A,width:b-S,height:X-A}})}}})}function Y(t,e){var r=t.chart,i=t.xAxis,a=t.yAxis;return r.mapView?r.mapView.pixelsToProjectedUnits(e):{x:i?i.toValue(e.x):0,y:a?a.toValue(e.y):0}}function D(t){var e,r,i,s=this.chart,n=s.mapView,o=a((this.options.cluster||{}).animation),l=o.duration||500,u=(this.markerClusterInfo||{}).pointsState,p=(u||{}).newState,d=(u||{}).oldState,h=[],c=0,f=0,m=0,x=!1,y=!1;if(d&&p){var C=F(this,r=p[t.stateId]);f=C.x-(n?0:s.plotLeft),m=C.y-(n?0:s.plotTop),1===r.parentsId.length?(e=d[(p||{})[t.stateId].parentsId[0]],r.point&&r.point.graphic&&e&&e.point&&e.point.plotX&&e.point.plotY&&e.point.plotX!==r.point.plotX&&e.point.plotY!==r.point.plotY&&(i=r.point.graphic.getBBox(),c=r.point.graphic&&r.point.graphic.isImg?0:i.width/2,r.point.graphic.attr({x:e.point.plotX-c,y:e.point.plotY-c}),r.point.graphic.animate({x:f-(r.point.graphic.radius||0),y:m-(r.point.graphic.radius||0)},o,function(){y=!0,e.point&&e.point.destroy&&e.point.destroy()}),r.point.dataLabel&&r.point.dataLabel.alignAttr&&e.point.dataLabel&&e.point.dataLabel.alignAttr&&(r.point.dataLabel.attr({x:e.point.dataLabel.alignAttr.x,y:e.point.dataLabel.alignAttr.y}),r.point.dataLabel.animate({x:r.point.dataLabel.alignAttr.x,y:r.point.dataLabel.alignAttr.y},o)))):0===r.parentsId.length?(A(r,!0,!0),g(function(){M(r,.1,o,!0,!0)},l/2)):(A(r,!0,!0),r.parentsId.forEach(function(t){d&&d[t]&&(e=d[t],h.push(e),e.point&&e.point.graphic&&(x=!0,e.point.graphic.show(),e.point.graphic.animate({x:f-(e.point.graphic.radius||0),y:m-(e.point.graphic.radius||0),opacity:.4},o,function(){y=!0,v(r,h,o,.7)}),e.point.dataLabel&&-9999!==e.point.dataLabel.y&&r.point&&r.point.dataLabel&&r.point.dataLabel.alignAttr&&(e.point.dataLabel.show(),e.point.dataLabel.animate({x:r.point.dataLabel.alignAttr.x,y:r.point.dataLabel.alignAttr.y,opacity:.4},o))))}),g(function(){y||v(r,h,o,.85)},l),x||g(function(){v(r,h,o,.1)},l/2))}}function L(){(this.markerClusterSeriesData||[]).forEach(function(t){t&&t.destroy&&t.destroy()}),this.markerClusterSeriesData=null}function P(){var t,e,r,a,l,u,d,c,f,g,x,y,C,k,v,M,I=this,S=I.chart,b=S.mapView,A=I.xData,D=I.yData,L=I.options.cluster,P=I.getRealExtremes(),z=[],w=[],E=[];if(b&&I.is("mappoint")&&A&&D&&(I.options.data||[]).forEach(function(t,e){var r=I.projectPoint(t);r&&(A[e]=r.x,D[e]=r.y)}),L&&L.enabled&&A&&A.length&&D&&D.length&&!S.polar){x=L.layoutAlgorithm.type,(k=L.layoutAlgorithm).processedGridSize=m(k.gridSize||s.layoutAlgorithm.gridSize,S.plotWidth),k.processedDistance=m(k.distance||s.layoutAlgorithm.distance,S.plotWidth),a=k.kmeansThreshold||s.layoutAlgorithm.kmeansThreshold;var j=k.processedGridSize/2,O=Y(I,{x:0,y:0}),T=Y(I,{x:j,y:j});for(M=0,l=Math.abs(O.x-T.x),u=Math.abs(O.y-T.y);M<A.length;M++)!I.dataMaxX&&(o(c)&&o(d)&&o(g)&&o(f)?h(D[M])&&h(g)&&h(f)&&(c=Math.max(A[M],c),d=Math.min(A[M],d),g=Math.max(D[M]||g,g),f=Math.min(D[M]||f,f)):(c=d=A[M],g=f=D[M])),A[M]>=P.minX-l&&A[M]<=P.maxX+l&&(D[M]||P.minY)>=P.minY-u&&(D[M]||P.maxY)<=P.maxY+u&&(z.push(A[M]),w.push(D[M]),E.push(M));o(c)&&o(d)&&h(g)&&h(f)&&(I.dataMaxX=c,I.dataMinX=d,I.dataMaxY=g,I.dataMinY=f),y=(C=(p(x)?x:I.markerClusterAlgorithms?x&&I.markerClusterAlgorithms[x]?I.markerClusterAlgorithms[x]:z.length<a?I.markerClusterAlgorithms.kmeans:I.markerClusterAlgorithms.grid:function(){return!1}).call(this,z,w,E,k))?I.getClusteredData(C,L):C,L.animation&&I.markerClusterInfo&&I.markerClusterInfo.pointsState&&I.markerClusterInfo.pointsState.oldState?(function(t){if(t)for(var e=void 0,r=0,i=Object.keys(t);r<i.length;r++)(e=t[i[r]]).point&&e.point.destroy&&e.point.destroy()}(I.markerClusterInfo.pointsState.oldState),t=I.markerClusterInfo.pointsState.newState):t={},e=A.length,r=I.markerClusterInfo,y&&(I.processedXData=y.groupedXData,I.processedYData=y.groupedYData,I.hasGroupedData=!0,I.markerClusterInfo=y,I.groupMap=y.groupMap),i.apply(this),y&&I.markerClusterInfo&&((I.markerClusterInfo.clusters||[]).forEach(function(t){(v=I.points[t.index]).isCluster=!0,v.clusteredData=t.data,v.clusterPointsAmount=t.data.length,t.point=v,n(v,"click",X)}),(I.markerClusterInfo.noise||[]).forEach(function(t){t.point=I.points[t.index]}),L.animation&&I.markerClusterInfo&&(I.markerClusterInfo.pointsState={oldState:t,newState:I.getPointsState(y,r,e)}),L.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else i.apply(this)}function z(t,e,r){for(var i=[],a=0;a<t.length;a++){var s=F(this,{x:e,y:r}),n=F(this,{x:t[a].posX,y:t[a].posY}),o=Math.sqrt(Math.pow(s.x-n.x,2)+Math.pow(s.y-n.y,2));i.push({clusterIndex:a,distance:o})}return i.sort(function(t,e){return t.distance-e.distance})}function w(t,e){var r,i,a,n,o,h,f,m,g,x,y,C,k,v,M=[],S=[],A=[],X=[],Y=[],D=Math.max(2,e.minimumClusterSize||2),L=0;if(p(e.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(t))return l("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(v in t)if(t[v].length>=D){if(a=t[v],r=b(),o=a.length,e.zones)for(k=0;k<e.zones.length;k++)o>=e.zones[k].from&&o<=e.zones[k].to&&((y=e.zones[k]).zoneIndex=k,x=e.zones[k].marker,C=e.zones[k].className);for(g=I(a),"grid"!==e.layoutAlgorithm.type||e.allowOverlap?f={x:g.x,y:g.y}:(h=this.options.marker||{},f=this.preventClusterCollisions({x:g.x,y:g.y,key:v,groupedData:t,gridSize:this.getScaledGridSize(e.layoutAlgorithm),defaultRadius:h.radius||3+(h.lineWidth||0),clusterRadius:x&&x.radius?x.radius:(e.marker||{}).radius||s.marker.radius})),k=0;k<o;k++)a[k].parentStateId=r;if(A.push({x:f.x,y:f.y,id:v,stateId:r,index:L,data:a,clusterZone:y,clusterZoneClassName:C}),M.push(f.x),S.push(f.y),Y.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:c(e.marker,{states:e.states},x||{})}}),this.options.data&&this.options.data.length)for(k=0;k<o;k++)d(this.options.data[a[k].dataIndex])&&(a[k].options=this.options.data[a[k].dataIndex]);L++,x=null}else for(k=0;k<t[v].length;k++)i=t[v][k],r=b(),m=null,n=((this.options||{}).data||[])[i.dataIndex],M.push(i.x),S.push(i.y),i.parentStateId=r,X.push({x:i.x,y:i.y,id:v,stateId:r,index:L,data:t[v]}),m=n&&"object"==typeof n&&!u(n)?c(n,{x:i.x,y:i.y}):{userOptions:n,x:i.x,y:i.y},Y.push({options:m}),L++;return{clusters:A,noise:X,groupedXData:M,groupedYData:S,groupMap:Y}}function E(){var t=this.chart,e=this.xAxis,r=this.yAxis,i=0;return{plotLeft:e&&this.dataMinX&&this.dataMaxX?e.reversed?e.toPixels(this.dataMaxX):e.toPixels(this.dataMinX):t.plotLeft,plotTop:r&&this.dataMinY&&this.dataMaxY?r.reversed?r.toPixels(this.dataMinY):r.toPixels(this.dataMaxY):t.plotTop}}function j(t,e,r){var i,a,s=e?S(e,r):[],n=S(t,r),o={};y=[],t.clusters.forEach(function(t){o[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(function(t){o[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}});for(var l=0;l<n.length;l++)i=n[l],a=s[l],i&&a&&i.parentStateId&&a.parentStateId&&o[i.parentStateId]&&-1===o[i.parentStateId].parentsId.indexOf(a.parentStateId)&&(o[i.parentStateId].parentsId.push(a.parentStateId),-1===y.indexOf(a.parentStateId)&&y.push(a.parentStateId));return o}function O(){var t=this.chart,e=t.mapView?0:t.plotLeft,r=Y(this,{x:e,y:t.mapView?0:t.plotTop}),i=Y(this,{x:e+t.plotWidth,y:e+t.plotHeight}),a=r.x,s=i.x,n=r.y,o=i.y;return{minX:Math.min(a,s),maxX:Math.max(a,s),minY:Math.min(n,o),maxY:Math.max(n,o)}}function T(t){var e=this.xAxis,r=this.chart.mapView,i=t.processedGridSize||s.layoutAlgorithm.gridSize,a=!0,n=1,o=1;this.gridValueSize||(r?this.gridValueSize=i/r.getScale():this.gridValueSize=Math.abs(e.toValue(i)-e.toValue(0)));for(var l=+(i/(r?this.gridValueSize*r.getScale():e.toPixels(this.gridValueSize)-e.toPixels(0))).toFixed(14);a&&1!==l;){var u=Math.pow(2,n);l>.75&&l<1.25?a=!1:l>=1/u&&l<1/u*2?(a=!1,o=u):l<=u&&l>u/2&&(a=!1,o=1/u),n++}return i/o/l}function V(){var t=this.markerClusterSeriesData,e=((this.markerClusterInfo||{}).pointsState||{}).oldState||{},r=y.map(function(t){return(e[t].point||{}).id||""});(t||[]).forEach(function(t){t&&-1!==r.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t&&t.destroy&&t.destroy()})}function G(t){var e,r=!1;return!!d(t)&&(f(t,function(t){if(r=!0,!u(t)||!t.length){r=!1;return}for(e=0;e<t.length;e++)if(!d(t[e])||!t[e].x||!t[e].y){r=!1;return}}),r)}function R(t){var e,r,i,a,n,l,u,p,d,h,c,f,m,g,x=t.key.split("-").map(parseFloat),y=x[0],C=x[1],k=t.gridSize,v=t.groupedData,M=t.defaultRadius,S=t.clusterRadius,b=C*k,A=y*k,X=F(this,t),D=[],L=(this.options.cluster||{}).marker,P=(this.options.cluster||{}).zones,z=this.getGridOffset(),w=X.x,E=X.y,j=0,O=0;for(w-=z.plotLeft,E-=z.plotTop,p=1;p<5;p++)for(d=0,a=p%2?-1:1,n=p<3?-1:1,l=Math.floor((w+a*S)/k),g=[(u=Math.floor((E+n*S)/k))+"-"+l,u+"-"+C,y+"-"+l];d<g.length;d++)-1===D.indexOf(g[d])&&g[d]!==t.key&&D.push(g[d]);for(var T=0;T<D.length;T++){var V=D[T];if(v[V]){v[V].posX||(f=I(v[V]),v[V].posX=f.x,v[V].posY=f.y);var G=F(this,{x:v[V].posX||0,y:v[V].posY||0});if(r=G.x-z.plotLeft,i=G.y-z.plotTop,c=(e=V.split("-").map(parseFloat))[0],h=e[1],P)for(p=0,j=v[V].length;p<P.length;p++)j>=P[p].from&&j<=P[p].to&&(O=o((P[p].marker||{}).radius)?P[p].marker.radius||0:L&&L.radius?L.radius:s.marker.radius);v[V].length>1&&0===O&&L&&L.radius?O=L.radius:1===v[V].length&&(O=M),m=S+O,O=0,h!==C&&Math.abs(w-r)<m&&(w=h-C<0?b+S:b+k-S),c!==y&&Math.abs(E-i)<m&&(E=c-y<0?A+S:A+k-S)}}var R=Y(this,{x:w+z.plotLeft,y:E+z.plotTop});return v[t.key].posX=R.x,v[t.key].posY=R.y,R}function F(t,e){var r=t.chart,i=t.xAxis,a=t.yAxis;return r.mapView?r.mapView.projectedUnitsToPixels(e):{x:i?i.toPixels(e.x):0,y:a?a.toPixels(e.y):0}}return{compose:function(t,r){var a=r.prototype;a.markerClusterAlgorithms||(i=a.generatePoints,a.markerClusterAlgorithms=x,a.animateClusterPoint=D,a.destroyClusteredData=L,a.generatePoints=P,a.getClusterDistancesFromPoint=z,a.getClusteredData=w,a.getGridOffset=E,a.getPointsState=j,a.getRealExtremes=O,a.getScaledGridSize=T,a.hideClusteredData=V,a.isValidGroupedDataObject=G,a.preventClusterCollisions=R,n(r,"destroy",a.destroyClusteredData),(t.plotOptions||{}).series=c((t.plotOptions||{}).series,e))}}}),r(e,"Extensions/MarkerClusters/MarkerClusters.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Extensions/MarkerClusters/MarkerClusterScatter.js"],e["Core/Utilities.js"]],function(t,e,r,i,a,s){var n=t.animObject,o=e.defaultOptions,l=r.composed,u=s.addEvent,p=s.defined,d=s.error,h=s.isFunction,c=s.merge,f=s.pushUnique,m=s.syncTimeout;function g(){for(var t=this.chart,e=0,r=0,i=t.series;r<i.length;r++){var a=i[r];a.markerClusterInfo&&(e=n((a.options.cluster||{}).animation).duration||0)}m(function(){t.tooltip&&t.tooltip.destroy()},e)}function x(){for(var t,e=0,r=this.series||[];e<r.length;e++){var i=r[e];if(i.markerClusterInfo){var a=i.options.cluster,s=((i.markerClusterInfo||{}).pointsState||{}).oldState;if((a||{}).animation&&i.markerClusterInfo&&0===((null===(t=i.chart.pointer)||void 0===t?void 0:t.pinchDown)||[]).length&&"pan"!==((i.xAxis||{}).eventArgs||{}).trigger&&s&&Object.keys(s).length){for(var n=0,o=i.markerClusterInfo.clusters;n<o.length;n++){var l=o[n];i.animateClusterPoint(l)}for(var u=0,p=i.markerClusterInfo.noise;u<p.length;u++){var d=p[u];i.animateClusterPoint(d)}}}}}function y(t){var e=(((t.point||t.target).series.options.cluster||{}).events||{}).drillToCluster;h(e)&&e.call(this,t)}function C(){if(this.dataGroup)return d("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}function k(){var t=(this.options.cluster||{}).drillToCluster;if(this.markerClusterInfo&&this.markerClusterInfo.clusters)for(var e=0,r=this.markerClusterInfo.clusters;e<r.length;e++){var i=r[e];i.point&&i.point.graphic&&(i.point.graphic.addClass("highcharts-cluster-point"),t&&i.point&&(i.point.graphic.css({cursor:"pointer"}),i.point.dataLabel&&i.point.dataLabel.css({cursor:"pointer"})),p(i.clusterZone)&&i.point.graphic.addClass(i.clusterZoneClassName||"highcharts-cluster-zone-"+i.clusterZone.zoneIndex))}}return(o.plotOptions||{}).series=c((o.plotOptions||{}).series,i),{compose:function(t,e,r,i){if(f(l,"MarkerClusters")){var s=i.prototype.pointClass,n=i.types.scatter;u(t,"setExtremes",g),u(e,"render",x),u(s,"drillToCluster",y),u(s,"update",C),u(i,"afterRender",k),n&&a.compose(r,n)}}}}),r(e,"Extensions/MarkerClusters/MarkerClusterSymbols.js",[],function(){var t;function e(e,r,i,a){var s=i/2,n=a/2,o=t.arc(e+s,r+n,s-4,n-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),l=t.arc(e+s,r+n,s-3,n-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:s-2,open:!1});return t.arc(e+s,r+n,s-1,n-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:s,open:!1}).concat(l,o)}return{compose:function(r){(t=r.prototype.symbols).cluster=e}}}),r(e,"masters/modules/marker-clusters.src.js",[e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusters.js"],e["Extensions/MarkerClusters/MarkerClusterSymbols.js"]],function(t,e,r){return e.compose(t.Axis,t.Chart,t.defaultOptions,t.Series),r.compose(t.SVGRenderer),t})});