!/**
 * Highstock JS v11.4.6 (2024-07-08)
 *
 * Data grouping module
 *
 * (c) 2010-2024 Torstein Hønsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function a(i,a,o,e){i.hasOwnProperty(a)||(i[a]=e.apply(null,o),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:a,module:i[a]}})))}a(i,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),a(i,"Extensions/DataGrouping/ApproximationDefaults.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Core/Utilities.js"]],function(t,i){var a=i.arrayMax,o=i.arrayMin,e=i.correctFloat,n=i.extend,r=i.isNumber;function s(t){var i=t.length,a=p(t);return r(a)&&i&&(a=e(a/i)),a}function p(t){var i,a=t.length;if(!a&&t.hasNulls)i=null;else if(a)for(i=0;a--;)i+=t[a];return i}var u={average:s,averages:function(){var t=[];return[].forEach.call(arguments,function(i){t.push(s(i))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?a(t):t.hasNulls?null:void 0},hlc:function(i,a,o){if(i=t.high(i),a=t.low(a),o=t.close(o),r(i)||r(a)||r(o))return[i,a,o]},low:function(t){return t.length?o(t):t.hasNulls?null:void 0},ohlc:function(i,a,o,e){if(i=t.open(i),a=t.high(a),o=t.low(o),e=t.close(e),r(i)||r(a)||r(o)||r(e))return[i,a,o,e]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(i,a){return(i=t.low(i),a=t.high(a),r(i)||r(a))?[i,a]:null===i&&null===a?null:void 0},sum:p};return n(t,u),u}),a(i,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),a(i,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Utilities.js"]],function(t,i){var a,o=i.addEvent,e=i.extend,n=i.merge,r=i.pick;function s(t){var i=this,a=i.series;a.forEach(function(t){t.groupPixelWidth=void 0}),a.forEach(function(a){a.groupPixelWidth=i.getGroupPixelWidth&&i.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping(!!t.hasExtremesChanged)})}function p(){for(var i,a,o=this.series,e=o.length,n=0,s=!1;e--;)(a=o[e].options.dataGrouping)&&(n=Math.max(n,r(a.groupPixelWidth,t.common.groupPixelWidth)),i=(o[e].processedXData||o[e].data).length,(o[e].groupPixelWidth||i>this.chart.plotSizeX/n||i&&a.forced)&&(s=!0));return s?n:0}function u(){this.series.forEach(function(t){t.hasProcessed=!1})}function l(t,i){var o;if(i=r(i,!0),t||(t={forced:!1,units:null}),this instanceof a)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(i){i.dataGrouping="boolean"==typeof t?t:n(t,i.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),i&&this.chart.redraw()}return{compose:function(t){a=t;var i=t.prototype;i.applyGrouping||(o(t,"afterSetScale",u),o(t,"postProcessData",s),e(i,{applyGrouping:s,getGroupPixelWidth:p,setDataGrouping:l}))}}}),a(i,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Axis/DateTimeAxis.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,a,o,e,n){var r=e.series.prototype,s=n.addEvent,p=n.defined,u=n.error,l=n.extend,h=n.isNumber,d=n.merge,g=n.pick,c=r.generatePoints;function f(t){var o,e,n,s,l=this.chart,d=this.options.dataGrouping,c=!1!==this.allowDG&&d&&g(d.enabled,l.options.isStock),f=this.reserveSpace(),m=this.currentDataGrouping,x=!1;c&&!this.requireSorting&&(this.requireSorting=x=!0);var D=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!c;if(x&&(this.requireSorting=!1),!D){this.destroyGroupedData();var G=d.groupAll?this.xData:this.processedXData,v=d.groupAll?this.yData:this.processedYData,y=l.plotSizeX,M=this.xAxis,A=M.options.ordinal,S=this.groupPixelWidth;if(S&&G&&G.length&&y){e=!0,this.isDirty=!0,this.points=null;var b,E=M.getExtremes(),P=E.min,j=E.max,C=A&&M.ordinal&&M.ordinal.getGroupIntervalFactor(P,j,this)||1,W=S*(j-P)/y*C,k=M.getTimeTicks(a.Additions.prototype.normalizeTimeTickInterval(W,d.units||i.units),Math.min(P,G[0]),Math.max(j,G[G.length-1]),M.options.startOfWeek,G,this.closestPointRange),H=r.groupData.apply(this,[G,v,k,d.approximation]),F=H.groupedXData,T=H.groupedYData,Y=0;for(d&&d.smoothed&&F.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",u(32,!1,l,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),o=1;o<k.length;o++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(o)||(Y=Math.max(k[o]-k[o-1],Y));(n=k.info).gapSize=Y,this.closestPointRange=k.info.totalRange,this.groupMap=H.groupMap,this.currentDataGrouping=n,function(t,i,a){var o=t.options.dataGrouping,e=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(o&&t.xData&&e&&t.groupMap){var n=i.length-1,r=o.anchor,s=o.firstAnchor,p=o.lastAnchor,u=i.length-1,l=0;if(s&&t.xData[0]>=i[0]){l++;var d=t.groupMap[0].start,g=t.groupMap[0].length,c=void 0;h(d)&&h(g)&&(c=d+(g-1)),i[0]=({start:i[0],middle:i[0]+.5*e,end:i[0]+e,firstPoint:t.xData[0],lastPoint:c&&t.xData[c]})[s]}if(n>0&&p&&e&&i[n]>=a-e){u--;var f=t.groupMap[t.groupMap.length-1].start;i[n]=({start:i[n],middle:i[n]+.5*e,end:i[n]+e,firstPoint:f&&t.xData[f],lastPoint:t.xData[t.xData.length-1]})[p]}if(r&&"start"!==r)for(var m=e*({middle:.5,end:1})[r];u>=l;)i[u]+=m,u--}}(this,F,j),f&&(p((b=F)[0])&&h(M.min)&&h(M.dataMin)&&b[0]<M.min&&((!p(M.options.min)&&M.min<=M.dataMin||M.min===M.dataMin)&&(M.min=Math.min(b[0],M.min)),M.dataMin=Math.min(b[0],M.dataMin)),p(b[b.length-1])&&h(M.max)&&h(M.dataMax)&&b[b.length-1]>M.max&&((!p(M.options.max)&&h(M.dataMax)&&M.max>=M.dataMax||M.max===M.dataMax)&&(M.max=Math.max(b[b.length-1],M.max)),M.dataMax=Math.max(b[b.length-1],M.dataMax))),d.groupAll&&(this.allGroupedData=T,F=(s=this.cropData(F,T,M.min,M.max)).xData,T=s.yData,this.cropStart=s.start),this.processedXData=F,this.processedYData=T}else this.groupMap=null,this.currentDataGrouping=void 0;this.hasGroupedData=e,this.preventGraphAnimation=(m&&m.totalRange)!==(n&&n.totalRange)}}function m(){this.groupedData&&(this.groupedData.forEach(function(t,i){t&&(this.groupedData[i]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function x(){c.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function D(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function G(i,a,o,e){var n,r,s,u=this,l=u.data,g=u.options&&u.options.data,c=[],f=[],m=[],x=i.length,D=!!a,G=[],v=u.pointArrayMap,y=v&&v.length,M=["x"].concat(v||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,b=0,E="function"==typeof e?e:e&&t[e]?t[e]:t[u.getDGApproximation&&u.getDGApproximation()||"average"];if(y)for(var P=v.length;P--;)G.push([]);else G.push([]);for(var j=y||1,C=0;C<=x;C++)if(!(i[C]<o[0])){for(;void 0!==o[S+1]&&i[C]>=o[S+1]||C===x;){n=o[S],u.dataGroupInfo={start:A?b:u.cropStart+b,length:G[0].length,groupStart:n},s=E.apply(u,G),u.pointClass&&!p(u.dataGroupInfo.options)&&(u.dataGroupInfo.options=d(u.pointClass.prototype.optionsToObject.call({series:u},u.options.data[u.cropStart+b])),M.forEach(function(t){delete u.dataGroupInfo.options[t]})),void 0!==s&&(c.push(n),f.push(s),m.push(u.dataGroupInfo)),b=C;for(var W=0;W<j;W++)G[W].length=0,G[W].hasNulls=!1;if(S+=1,C===x)break}if(C===x)break;if(v)for(var k=u.options.dataGrouping&&u.options.dataGrouping.groupAll?C:u.cropStart+C,H=l&&l[k]||u.pointClass.prototype.applyOptions.apply({series:u},[g[k]]),F=void 0,W=0;W<y;W++)h(F=H[v[W]])?G[W].push(F):null===F&&(G[W].hasNulls=!0);else h(r=D?a[C]:null)?G[0].push(r):null===r&&(G[0].hasNulls=!0)}return{groupedXData:c,groupedYData:f,groupMap:m}}function v(t){var a=t.options,e=this.type,n=this.chart.options.plotOptions,r=this.useCommonDataGrouping&&i.common,s=i.seriesSpecific,p=o.defaultOptions.plotOptions[e].dataGrouping;if(n&&(s[e]||r)){var u=this.chart.rangeSelector;p||(p=d(i.common,s[e])),a.dataGrouping=d(r,p,n.series&&n.series.dataGrouping,n[e].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&u&&h(u.selected)&&u.buttonOptions[u.selected].dataGrouping)}}return{compose:function(t){var i=t.prototype;i.applyGrouping||(s(t.prototype.pointClass,"update",function(){if(this.dataGroup)return u(24,!1,this.series.chart),!1}),s(t,"afterSetOptions",v),s(t,"destroy",m),l(i,{applyGrouping:f,destroyGroupedData:m,generatePoints:x,getDGApproximation:D,groupData:G}))},groupData:G}}),a(i,"Extensions/DataGrouping/DataGrouping.js",[i["Extensions/DataGrouping/DataGroupingAxisComposition.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],i["Core/Templating.js"],i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i,a,o,e,n){var r=o.format,s=e.composed,p=n.addEvent,u=n.extend,l=n.isNumber,h=n.pick,d=n.pushUnique;function g(t){var a,o,e,n,s,p,d=this.chart,g=d.time,c=t.labelConfig,f=c.series,m=c.point,x=f.options,D=f.tooltipOptions,G=x.dataGrouping,v=f.xAxis,y=D.xDateFormat,M=D[t.isFooter?"footerFormat":"headerFormat"];if(v&&"datetime"===v.options.type&&G&&l(c.key)){e=f.currentDataGrouping,n=G.dateTimeLabelFormats||i.common.dateTimeLabelFormats,e?(s=n[e.unitName],1===e.count?y=s[0]:(y=s[1],o=s[2])):!y&&n&&v.dateTime&&(y=v.dateTime.getXDateFormat(c.x,D.dateTimeLabelFormats));var A=h(null===(a=f.groupMap)||void 0===a?void 0:a[m.index].groupStart,c.key),S=A+(null==e?void 0:e.totalRange)-1;p=g.dateFormat(y,A),o&&(p+=g.dateFormat(o,S)),f.chart.styledMode&&(M=this.styledModeFormat(M)),t.text=r(M,{point:u(c.point,{key:p}),series:f},d),t.preventDefault()}}return{compose:function(i,o,e){t.compose(i),a.compose(o),e&&d(s,"DataGrouping")&&p(e,"headerFormatter",g)},groupData:a.groupData}}),a(i,"masters/modules/datagrouping.src.js",[i["Core/Globals.js"],i["Extensions/DataGrouping/ApproximationDefaults.js"],i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGrouping.js"]],function(t,i,a,o){return t.dataGrouping=t.dataGrouping||{},t.dataGrouping.approximationDefaults=t.dataGrouping.approximationDefaults||i,t.dataGrouping.approximations=t.dataGrouping.approximations||a,o.compose(t.Axis,t.Series,t.Tooltip),t})});