!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * Boost module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(e,i,o,r){e.hasOwnProperty(i)||(e[i]=r.apply(null,o),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:e[i]}})))}i(e,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(t){var e={};return t.forEach(function(t){e[t]=!0}),e}),i(e,"Extensions/Boost/BoostChart.js",[e["Extensions/Boost/BoostableMap.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){var o=e.composed,r=i.addEvent,s=i.pick,n=i.pushUnique;function a(e){var i=e.series,o=e.boost=e.boost||{},r=e.options.boost||{},n=s(r.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;var a=r.allowForce;if(void 0===a){a=!0;for(var l=0,h=e.xAxis;l<h.length;l++){var c=h[l];if(s(c.min,-1/0)>s(c.dataMin,-1/0)||s(c.max,1/0)<s(c.dataMax,1/0)){a=!1;break}}}if(void 0!==o.forceChartBoost){if(a)return o.forceChartBoost;o.forceChartBoost=void 0}for(var d,u=0,p=0,f=0;f<i.length;f++){var g=i[f];0!==(d=g.options).boostThreshold&&!1!==g.visible&&"heatmap"!==g.type&&(t[g.type]&&++u,function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var i=-Number.MAX_VALUE;return t.forEach(function(t){if(null!=t&&void 0!==t.length&&t.length>0)return i=t.length,!0}),i}(g.processedXData,d.data,g.points)>=(d.boostThreshold||Number.MAX_VALUE)&&++p)}return o.forceChartBoost=a&&(u===i.length&&p===u||p>5),o.forceChartBoost}function l(t){function e(){t.boost&&t.boost.wgl&&a(t)&&t.boost.wgl.render(t)}r(t,"predraw",function(){var e,i;t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.axes.some(function(t){return t.isPanning})||null===(i=(e=t.boost).clear)||void 0===i||i.call(e),t.boost.canvas&&t.boost.wgl&&a(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),r(t,"load",e,{order:-1}),r(t,"redraw",e);var i=-1,o=-1;r(t.pointer,"afterGetHoverData",function(e){var r,s=null===(r=e.hoverPoint)||void 0===r?void 0:r.series;if(t.boost=t.boost||{},t.boost.markerGroup&&s){var n=t.inverted?s.yAxis:s.xAxis,a=t.inverted?s.xAxis:s.yAxis;(n&&n.pos!==i||a&&a.pos!==o)&&(t.series.forEach(function(t){var e;null===(e=t.halo)||void 0===e||e.hide()}),t.boost.markerGroup.translate(n.pos,a.pos),i=n.pos,o=a.pos)}})}return{compose:function(t,e){return e&&n(o,"Boost.Chart")&&t.prototype.callbacks.push(l),t},getBoostClipRect:function(t,e){var i=t.navigator,o={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.plotHeight};if(i&&t.inverted?(o.width+=i.top+i.height,i.opposite||(o.x=i.left)):i&&!t.inverted&&(o.height=i.top+i.height-t.plotTop),e.getClipBox){var r=e.xAxis,s=e.yAxis;if(o=e.getClipBox(),t.inverted){var n=o.width;o.width=o.height,o.height=n,o.x=s.pos,o.y=r.pos}else o.x=r.pos,o.y=s.pos}if(e===t){var a=t.inverted?t.xAxis:t.yAxis;a.length<=1&&(o.y=Math.min(a[0].pos,o.y),o.height=a[0].pos-t.plotTop+a[0].len)}return o},isChartSeriesBoosting:a}}),i(e,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(t){var e=t.clamp,i=t.error,o=t.pick;return function(){function t(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}return t.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)},t.prototype.createShader=function(){var t=this,e=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),i=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),o=function(e){return t.gl.getUniformLocation(t.shaderProgram,e)};return e&&i?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,e),this.gl.attachShader(this.shaderProgram,i),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=o("uPMatrix"),this.psUniform=o("pSize"),this.fcUniform=o("fillColor"),this.isBubbleUniform=o("isBubble"),this.bubbleSizeAbsUniform=o("bubbleSizeAbs"),this.bubbleSizeAreaUniform=o("bubbleSizeByArea"),this.uSamplerUniform=o("uSampler"),this.skipTranslationUniform=o("skipTranslation"),this.isCircleUniform=o("isCircle"),this.isInverted=o("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)},t.prototype.handleErrors=function(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))},t.prototype.stringToProgram=function(t,e){var i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)},t.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)},t.prototype.fillColorUniform=function(){return this.fcUniform},t.prototype.getProgram=function(){return this.shaderProgram},t.prototype.pointSizeUniform=function(){return this.psUniform},t.prototype.perspectiveUniform=function(){return this.pUniform},t.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))},t.prototype.setBubbleUniforms=function(t,i,r,s){void 0===s&&(s=1);var n=t.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){var h=t.getPxExtremes();a=o(n.zMin,e(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=o(n.zMax,Math.max(l,r)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*s),this.setUniform("bubbleMaxSize",h.maxPxSize*s),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",t.options.zThreshold)}},t.prototype.setColor=function(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])},t.prototype.setDrawAsCircle=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,t?1:0)},t.prototype.setInverted=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)},t.prototype.setPMatrix=function(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)},t.prototype.setPointSize=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)},t.prototype.setSkipTranslation=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===t?1:0)},t.prototype.setTexture=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)},t.prototype.setUniform=function(t,e){if(this.gl&&this.shaderProgram){var i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}},t}()}),i(e,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function t(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}return t.prototype.allocate=function(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)},t.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)},t.prototype.build=function(t,e,i){var o;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(o=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||o,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),o=!1,!0):(this.destroy(),!1)},t.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]},t.prototype.push=function(t,e,i,o){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=o)},t.prototype.render=function(t,e,i){var o=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!o&&((!t||t>o||t<0)&&(t=0),(!e||e>o)&&(e=o),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))},t}()}),i(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLDrawMode.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVertexBuffer.js"]],function(t,e,i,o,r,s){var n=t.parse,a=e.doc,l=e.win,h=i.isNumber,c=i.isObject,d=i.merge,u=i.objectEach,p=i.pick,f={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},g={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function i(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}return i.orthoMatrix=function(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]},i.seriesPointCount=function(t){var e,i,o;return t.boosted?(e=!!t.options.stacking,i=t.xData||t.options.xData||t.processedXData,o=(e?t.data:i||t.options.data).length,"treemap"===t.type?o*=12:"heatmap"===t.type?o*=6:f[t.type]&&(o*=2),o):0},i.prototype.getPixelRatio=function(){return this.settings.pixelRatio||l.devicePixelRatio||1},i.prototype.setOptions=function(t){"pixelRatio"in t||(t.pixelRatio=1),d(!0,this.settings,t)},i.prototype.allocateBuffer=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.series.forEach(function(t){t.boosted&&(o+=i.seriesPointCount(t))}),e&&e.allocate(o))},i.prototype.allocateBufferForSingleSeries=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.boosted&&(o=i.seriesPointCount(t)),e&&e.allocate(o))},i.prototype.clear=function(){var t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)},i.prototype.pushSeriesData=function(t,e){var i,o,r,s,a,l,h,d,u=this,p=this.data,g=this.settings,m=this.vbuffer,b=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),v=t.chart,x=t.options,A=t.sorted,y=t.xAxis,P=t.yAxis,T=!!x.stacking,E=x.data,S=t.xAxis.getExtremes(),C=S.min-(t.xAxis.minPointOffset||0),M=S.max+(t.xAxis.minPointOffset||0),k=t.yAxis.getExtremes(),U=k.min-(t.yAxis.minPointOffset||0),R=k.max+(t.yAxis.minPointOffset||0),w=t.xData||x.xData||t.processedXData,D=t.yData||x.yData||t.processedYData,B=t.zData||x.zData||t.processedZData,L=!w||0===w.length,G=x.connectNulls,N=t.points||!1,_=T?t.data:w||E,z={x:Number.MAX_VALUE,y:0},I={x:-Number.MAX_VALUE,y:0},O=void 0===v.index,X=f[t.type],V=x.zoneAxis||"y",j=x.zones||!1,F=x.threshold,W=this.getPixelRatio(),Y=t.chart.plotWidth,H=!1,K=!1,Z=0,q=!1,Q=-1,J=!1,$=!1,tt=!1,te=!1,ti=!1,to=!1,tr=!0,ts=!0,tn=!1,ta=!1,tl=0;if(!x.boostData||!(x.boostData.length>0)){x.gapSize&&(ta="value"!==x.gapUnit?x.gapSize*t.closestPointRange:x.gapSize),j&&(d=[],j.forEach(function(t,e){if(t.color){var i=n(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,d[e]=i,tn||void 0!==t.value||(tn=i)}}),tn||(tn=n(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tn[0]/=255,tn[1]/=255,tn[2]/=255)),v.inverted&&(Y=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;var th=function(t){t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},tc=function(t,i,o,r,s){void 0===r&&(r=1),th(s),1!==W&&(!g.useGPUTranslations||e.skipTranslation)&&(t*=W,i*=W,r*=W),g.usePreallocated&&m?(m.push(t,i,o?1:0,r),tl+=4):(p.push(t),p.push(i),p.push(o?W:0),p.push(r))},td=function(){e.segments.length&&(e.segments[e.segments.length-1].to=p.length||tl)},tu=function(){e.segments.length&&e.segments[e.segments.length-1].from===(p.length||tl)||(td(),e.segments.push({from:p.length||tl}))},tp=function(t,e,i,o,r){th(r),tc(t+i,e),th(r),tc(t,e),th(r),tc(t,e+o),th(r),tc(t,e+o),th(r),tc(t+i,e+o),th(r),tc(t+i,e)};if(tu(),N&&N.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",N[0].node&&N[0].node.levelDynamic&&N.sort(function(t,e){if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),N.forEach(function(e){var i,r,s=e.plotY;if(void 0!==s&&!isNaN(s)&&null!==e.y&&e.shapeArgs){var a=e.shapeArgs,l=a.x,h=void 0===l?0:l,c=a.y,d=void 0===c?0:c,u=a.width,p=void 0===u?0:u,f=a.height,g=void 0===f?0:f;i=(r=v.styledMode?e.series.colorAttribs(e):r=e.series.pointAttribs(e))["stroke-width"]||0,ti=n(r.fill).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255,t.is("treemap")&&(i=i||1,o=n(r.stroke).rgba,o[0]/=255,o[1]/=255,o[2]/=255,tp(h,d,p,g,o),i/=2),t.is("heatmap")&&v.inverted&&(h=y.len-h,d=P.len-d,p=-p,g=-g),tp(h+i,d+i,p-2*i,g-2*i,ti)}}),td();return}for(;Q<_.length-1&&"break"!==function(){if(void 0===(a=_[++Q]))return"continue";if(O)return"break";var o,u=E&&E[Q];return(!L&&c(u,!0)&&u.color&&(ti=n(u.color).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255),L?(r=a[0],s=a[1],_[Q+1]&&($=_[Q+1][0]),_[Q-1]&&(J=_[Q-1][0]),a.length>=3&&(l=a[2],a[2]>e.zMax&&(e.zMax=a[2]),a[2]<e.zMin&&(e.zMin=a[2]))):(r=a,s=D[Q],_[Q+1]&&($=_[Q+1]),_[Q-1]&&(J=_[Q-1]),B&&B.length&&(l=B[Q],B[Q]>e.zMax&&(e.zMax=B[Q]),B[Q]<e.zMin&&(e.zMin=B[Q]))),G||null!==r&&null!==s)?($&&$>=C&&$<=M&&(tt=!0),J&&J>=C&&J<=M&&(te=!0),b?(L&&(s=a.slice(1,3)),h=s[0],s=s[1]):T&&(r=a.x,h=(s=a.stackY)-a.y),null!=U&&null!=R&&(tr=s>=U&&s<=R),r>M&&I.x<M&&(I.x=r,I.y=s),r<C&&z.x>C&&(z.x=r,z.y=s),null===s&&G)?"continue":null!==s&&(tr||tt||te)?(A&&($>=C||r>=C)&&(J<=M||r<=M)&&(to=!0),to||tt||te)?(ta&&r-J>ta&&tu(),j&&(j.some(function(t,e){var i=j[e-1];return"x"===V?void 0!==t.value&&r<=t.value&&(d[e]&&(!i||r>=i.value)&&(o=d[e]),!0):void 0!==t.value&&s<=t.value&&(d[e]&&(!i||s>=i.value)&&(o=d[e]),!0)}),ti=o||tn||ti),!g.useGPUTranslations&&(e.skipTranslation=!0,r=y.toPixels(r,!0),s=P.toPixels(s,!0),r>Y&&"POINTS"===e.drawMode))?"continue":(e.hasMarkers&&to&&!1!==H&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(r-H))),!g.useGPUTranslations&&!g.usePreallocated&&H&&1>Math.abs(r-H)&&K&&1>Math.abs(s-K))?(g.debug.showSkipSummary&&++Z,"continue"):void(X&&(i=h,(!1===h||void 0===h)&&(i=s<0?s:0),(b||T)&&!P.logarithmic||(i=Math.max(null===F?U:F,U)),g.useGPUTranslations||(i=P.toPixels(i,!0)),tc(r,i,0,0,ti)),x.step&&!ts&&tc(r,K,0,2,ti),tc(r,s,0,"bubble"===t.type?l||1:2,ti),H=r,K=s,q=!0,ts=!1):"continue":(tu(),"continue"):(tu(),"continue")}(););g.debug.showSkipSummary&&console.log("skipped points:",Z);var tf=function(t,i){if(g.useGPUTranslations||(e.skipTranslation=!0,t.x=y.toPixels(t.x,!0),t.y=P.toPixels(t.y,!0)),i){u.data=[t.x,t.y,0,2].concat(u.data);return}tc(t.x,t.y,0,2)};!q&&!1!==G&&"line_strip"===t.drawMode&&(z.x<Number.MAX_VALUE&&tf(z,!0),I.x>-Number.MAX_VALUE&&tf(I)),td()}},i.prototype.pushSeries=function(t){var e=this.markerData,i=this.series,r=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),r.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");var s={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:o[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(s):i[t.index]=s,this.pushSeriesData(t,s),r.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")},i.prototype.flush=function(){var t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()},i.prototype.setXAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}},i.prototype.setYAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}},i.prototype.setThreshold=function(t,e){var i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))},i.prototype.renderChart=function(o){var r=this,a=this.gl,l=this.settings,c=this.shader,d=this.vbuffer,u=this.getPixelRatio();if(!o)return!1;this.width=o.chartWidth*u,this.height=o.chartHeight*u;var f=this.height,m=this.width;if(!a||!c||!m||!f)return!1;l.debug.timeRendering&&console.time("gl rendering"),a.canvas.width=m,a.canvas.height=f,c.bind(),a.viewport(0,0,m,f),c.setPMatrix(i.orthoMatrix(m,f)),l.lineWidth>1&&!e.isMS&&a.lineWidth(l.lineWidth),d&&(d.build(this.data,"aVertexPosition",4),d.bind()),c.setInverted(o.inverted),this.series.forEach(function(e,i){var f,m,b,v,x,A,y=e.series.options,P=y.marker,T=void 0!==y.lineWidth?y.lineWidth:1,E=y.threshold,S=h(E),C=e.series.yAxis.getThreshold(E),M=p(y.marker?y.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((y.marker?y.marker.radius:10)||10)),k=r.textureHandles[P&&P.symbol||e.series.symbol]||r.textureHandles.circle,U=[];if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to&&(k.isReady&&(a.bindTexture(a.TEXTURE_2D,k.handle),c.setTexture(k.handle)),o.styledMode?e.series.markerGroup===(null===(f=e.series.chart.boost)||void 0===f?void 0:f.markerGroup)?(delete e.series.markerGroup,e.series.markerGroup=e.series.plotGroup("markerGroup","markers","visible",1,o.seriesGroup).addClass("highcharts-tracker"),A=e.series.markerGroup.getStyle("fill"),e.series.markerGroup.destroy(),e.series.markerGroup=null===(m=e.series.chart.boost)||void 0===m?void 0:m.markerGroup):A=null===(b=e.series.markerGroup)||void 0===b?void 0:b.getStyle("fill"):(A="POINTS"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,y.colorByPoint&&(A=e.series.chart.options.colors[i])),e.series.fillOpacity&&y.fillOpacity&&(A=new t(A).setOpacity(p(y.fillOpacity,1)).get()),U=n(A).rgba,l.useAlpha||(U[3]=1),"LINES"===e.drawMode&&l.useAlpha&&U[3]<1&&(U[3]/=10),"add"===y.boostBlending?(a.blendFunc(a.SRC_ALPHA,a.ONE),a.blendEquation(a.FUNC_ADD)):"mult"===y.boostBlending||"multiply"===y.boostBlending?a.blendFunc(a.DST_COLOR,a.ZERO):"darken"===y.boostBlending?(a.blendFunc(a.ONE,a.ONE),a.blendEquation(a.FUNC_MIN)):a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA),c.reset(),e.colorData.length>0?(c.setUniform("hasColor",1),(x=new s(a,c)).build(Array(e.segments[0].from).concat(e.colorData),"aColor",4),x.bind()):(c.setUniform("hasColor",0),a.disableVertexAttribArray(a.getAttribLocation(c.getProgram(),"aColor"))),c.setColor(U),r.setXAxis(e.series.xAxis),r.setYAxis(e.series.yAxis),r.setThreshold(S,C),"POINTS"===e.drawMode&&c.setPointSize(2*p(y.marker&&y.marker.radius,.5)*u),c.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&c.setBubbleUniforms(e.series,e.zMin,e.zMax,u),c.setDrawAsCircle(g[e.series.type]||!1),d)){if(T>0||"LINE_STRIP"!==e.drawMode)for(v=0;v<e.segments.length;v++)d.render(e.segments[v].from,e.segments[v].to,e.drawMode);if(e.hasMarkers&&M)for(c.setPointSize(2*p(y.marker&&y.marker.radius,5)*u),c.setDrawAsCircle(!0),v=0;v<e.segments.length;v++)d.render(e.segments[v].from,e.segments[v].to,"POINTS")}}),l.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()},i.prototype.render=function(t){var e=this;if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(function(){e.render(t)},1)},i.prototype.setSize=function(t,e){var o=this.shader;o&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,o.bind(),o.setPMatrix(i.orthoMatrix(t,e)))},i.prototype.init=function(t,e){var i=this,o=this.settings;if(this.isInited=!1,!t)return!1;o.debug.timeSetup&&console.time("gl setup");for(var n=0;n<m.length&&(this.gl=t.getContext(m[n],{}),!this.gl);++n);var l=this.gl;if(!l)return!1;e||this.flush(),l.enable(l.BLEND),l.blendFunc(l.SRC_ALPHA,l.ONE_MINUS_SRC_ALPHA),l.disable(l.DEPTH_TEST),l.depthFunc(l.LESS);var h=this.shader=new r(l);if(!h)return!1;this.vbuffer=new s(l,h);var c=function(t,e){var o={isReady:!1,texture:a.createElement("canvas"),handle:l.createTexture()},r=o.texture.getContext("2d");i.textureHandles[t]=o,o.texture.width=512,o.texture.height=512,r.mozImageSmoothingEnabled=!1,r.webkitImageSmoothingEnabled=!1,r.msImageSmoothingEnabled=!1,r.imageSmoothingEnabled=!1,r.strokeStyle="rgba(255, 255, 255, 0)",r.fillStyle="#FFF",e(r);try{l.activeTexture(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,o.handle),l.texImage2D(l.TEXTURE_2D,0,l.RGBA,l.RGBA,l.UNSIGNED_BYTE,o.texture),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_S,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_T,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MAG_FILTER,l.LINEAR),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MIN_FILTER,l.LINEAR),l.bindTexture(l.TEXTURE_2D,null),o.isReady=!0}catch(t){}};return c("circle",function(t){t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),c("square",function(t){t.fillRect(0,0,512,512)}),c("diamond",function(t){t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),c("triangle",function(t){t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),c("triangle-down",function(t){t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,o.debug.timeSetup&&console.timeEnd("gl setup"),!0},i.prototype.destroy=function(){var t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(u(this.textureHandles,function(e){e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)},i}()}),i(e,"Extensions/Boost/BoostSeries.js",[e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostChart.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLRenderer.js"]],function(t,e,i,o,r,s,n){var a,l,h=i.getBoostClipRect,c=i.isChartSeriesBoosting,d=o.getOptions,u=r.composed,p=r.doc,f=r.noop,g=r.win,m=s.addEvent,b=s.destroyObjectProperties,v=s.error,x=s.extend,A=s.fireEvent,y=s.isArray,P=s.isNumber,T=s.pick,E=s.pushUnique,S=s.wrap,C=s.defined;function M(t,e){var i=e.boost;t&&i&&i.target&&i.canvas&&!c(e.chart)&&t.allocateBufferForSingleSeries(e)}function k(t){return T(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function U(t,e){var i,o,r,s=t.constructor,a=t.seriesGroup||e.group,d=t.chartWidth,u=t.chartHeight,f=t,g="undefined"!=typeof SVGForeignObjectElement,m=!1;c(t)?f=t:(f=e,m=!!((null===(i=e.options.events)||void 0===i?void 0:i.click)||(null===(r=null===(o=e.options.point)||void 0===o?void 0:o.events)||void 0===r?void 0:r.click)));var b=f.boost=f.boost||{};if(g=!1,l||(l=p.createElement("canvas")),!b.target&&(b.canvas=l,t.renderer.forExport||!g?(f.renderTarget=b.target=t.renderer.image("",0,0,d,u).addClass("highcharts-boost-canvas").add(a),b.clear=function(){b.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},b.copy=function(){b.resize(),b.target.attr({href:b.canvas.toDataURL("image/png")})}):(b.targetFo=t.renderer.createElement("foreignObject").add(a),f.renderTarget=b.target=p.createElement("canvas"),b.targetCtx=b.target.getContext("2d"),b.targetFo.element.appendChild(b.target),b.clear=function(){b.target.width=b.canvas.width,b.target.height=b.canvas.height},b.copy=function(){b.target.width=b.canvas.width,b.target.height=b.canvas.height,b.targetCtx.drawImage(b.canvas,0,0)}),b.resize=function(){var e,i;d=t.chartWidth,u=t.chartHeight,(b.targetFo||b.target).attr({x:0,y:0,width:d,height:u}).css({pointerEvents:m?void 0:"none",mixedBlendMode:"normal",opacity:1}).addClass(m?"highcharts-tracker":""),f instanceof s&&(null===(i=null===(e=f.boost)||void 0===e?void 0:e.markerGroup)||void 0===i||i.translate(t.plotLeft,t.plotTop))},b.clipRect=t.renderer.clipRect(),(b.targetFo||b.target).attr({zIndex:e.options.zIndex}),f instanceof s&&(f.boost.markerGroup=f.renderer.g().add(a).translate(e.xAxis.pos,e.yAxis.pos))),b.canvas.width=d,b.canvas.height=u,b.clipRect){var x=h(t,f),A=x.width===t.clipBox.width&&x.height===t.clipBox.height?a:b.targetFo||b.target;b.clipRect.attr(x),null==A||A.clip(b.clipRect)}return b.resize(),b.clear(),!b.wgl&&(b.wgl=new n(function(t){t.settings.debug.timeBufferCopy&&console.time("buffer copy"),b.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),b.wgl.init(b.canvas)||v("[highcharts boost] - unable to init WebGL renderer"),b.wgl.setOptions(t.options.boost||{}),f instanceof s&&b.wgl.allocateBuffer(t)),b.wgl.setSize(d,u),b.wgl}function R(t){var e=t.points;if(e){var i=void 0,o=void 0;for(o=0;o<e.length;o+=1)(i=e[o])&&i.destroyElements&&i.destroyElements()}["graph","area","tracker"].forEach(function(e){var i=t[e];i&&(t[e]=i.destroy())});for(var r=0,s=t.zones;r<s.length;r++)b(s[r],void 0,!0)}function w(t,e,i,o,r,s){for(var n=(r=r||0)+(o=o||3e3),a=!0;a&&r<n&&r<t.length;)a=e(t[r],r),++r;a&&(r<t.length?s?w(t,e,i,o,r,s):g.requestAnimationFrame?g.requestAnimationFrame(function(){w(t,e,i,o,r)}):setTimeout(w,0,t,e,i,o,r):i&&i())}function D(t,e){var i=t.options,o=i.data,r=t.xAxis&&t.xAxis.options,s=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return o.length>(i.boostThreshold||Number.MAX_VALUE)&&P(s.min)&&P(s.max)&&(!e||P(r.min)&&P(r.max))&&(!n||P(n.min)&&P(n.max))}var B=function(t,e){return!t.forceCrop&&(c(t.chart)||(e?e.length:0)>=(t.options.boostThreshold||Number.MAX_VALUE))};function L(){var t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}function G(){var t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function N(t){var e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!c(t.chart)&&e.wgl.render(t.chart)}function _(t,e){var i=t.options,o=t.xAxis,r=t.pointClass;if(e instanceof r)return e;var s=t.xData||i.xData||t.processedXData||!1,n=new r(t,(t.options.data||[])[e.i],s?s[e.i]:void 0);return n.category=T(o.categories?o.categories[n.x]:n.x,n.x),n.dist=e.dist,n.distX=e.distX,n.plotX=e.plotX,n.plotY=e.plotY,n.index=e.i,n.percentage=e.percentage,n.isInside=t.isPointInside(n),n}function z(t){var e=this.options,i=this.xAxis,o=this.yAxis;if(!this.isDirty&&!i.isDirty&&!o.isDirty&&!t)return!1;this.yAxis.setTickInterval();var r=e.boostThreshold||0,s=e.cropThreshold,n=e.data||this.data,a=this.xData,l=i.getExtremes(),h=null!==(g=l.max)&&void 0!==g?g:Number.MAX_VALUE,c=null!==(m=l.min)&&void 0!==m?m:-Number.MAX_VALUE,d=this.yData,u=o.getExtremes(),p=null!==(b=u.max)&&void 0!==b?b:Number.MAX_VALUE,f=null!==(v=u.min)&&void 0!==v?v:-Number.MAX_VALUE;if(!this.boosted&&i.old&&o.old&&c>=(null!==(x=i.old.min)&&void 0!==x?x:-Number.MAX_VALUE)&&h<=(null!==(A=i.old.max)&&void 0!==A?A:Number.MAX_VALUE)&&f>=(null!==(y=o.old.min)&&void 0!==y?y:-Number.MAX_VALUE)&&p<=(null!==(T=o.old.max)&&void 0!==T?T:Number.MAX_VALUE))return null!==(E=this.processedXData)&&void 0!==E||(this.processedXData=a),null!==(S=this.processedYData)&&void 0!==S||(this.processedYData=d),!0;if(!r||n.length<r||s&&!this.forceCrop&&!this.getExtremesFromAll&&!e.getExtremesFromAll&&n.length<s)return this.processedXData=a,this.processedYData=d,!0;for(var g,m,b,v,x,A,y,T,E,S,C,M,k,U,R,w,D,L,G,N,_=[],z=[],I=[],O=!(P(l.max)||P(l.min)),X=!(P(u.max)||P(u.min)),V=!1,j=a[0],F=a[0],W=d[0],Y=d[0],H=0,K=a.length;H<K;++H)G=a[H],N=d[H],G>=c&&G<=h&&N>=f&&N<=p?(_.push({x:G,y:N}),z.push(G),I.push(N),O&&(j=Math.max(j,G),F=Math.min(F,G)),X&&(W=Math.max(W,N),Y=Math.min(Y,N))):V=!0;return O&&(null!==(C=(R=i.options).max)&&void 0!==C||(R.max=j),null!==(M=(w=i.options).min)&&void 0!==M||(w.min=F)),X&&(null!==(k=(D=o.options).max)&&void 0!==k||(D.max=W),null!==(U=(L=o.options).min)&&void 0!==U||(L.min=Y)),this.cropped=V,this.cropStart=0,this.processedXData=z,this.processedYData=I,B(this,z)||(this.processedData=_),!0}function I(){var t,e,i,o,r,s=this,n=this.options||{},l=this.chart,h=l.boost,d=this.boost,u=this.xAxis,p=this.yAxis,g=n.xData||this.processedXData,m=n.yData||this.processedYData,b=this.processedData||n.data,v=u.getExtremes(),x=v.min-(u.minPointOffset||0),y=v.max+(u.minPointOffset||0),P=p.getExtremes(),E=P.min-(p.minPointOffset||0),S=P.max+(p.minPointOffset||0),k={},D=!!this.sampling,B=n.enableMouseTracking,L=n.threshold,G=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),_=!!n.stacking,z=this.cropStart||0,I=this.requireSorting,O=!g,X="x"===n.findNearestPointBy,V=this.xData||this.options.xData||this.processedXData||!1,j=T(n.lineWidth,1),F=!1,W=p.getThreshold(L);if(!u.isPanning&&!p.isPanning&&(F=U(l,this),l.boosted=!0,this.visible)){(this.points||this.graph)&&R(this),c(l)?(this.markerGroup&&this.markerGroup!==(null==h?void 0:h.markerGroup)&&this.markerGroup.destroy(),this.markerGroup=null==h?void 0:h.markerGroup,d&&d.target&&(this.renderTarget=d.target=d.target.destroy())):(this.markerGroup===(null==h?void 0:h.markerGroup)&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers","visible",1,l.seriesGroup).addClass("highcharts-tracker"));var Y=this.points=[],H=function(t,e,i,o){var r=!!V&&V[z+i],s=function(t){l.inverted&&(t=u.len-t,e=p.len-e),Y.push({destroy:f,x:r,clientX:t,plotX:t,plotY:e,i:z+i,percentage:o})};t=Math.ceil(t),a=X?t:t+","+e,B&&(k[a]?r===V[V.length-1]&&(Y.length--,s(t)):(k[a]=!0,s(t)))};this.buildKDTree=f,A(this,"renderCanvas"),this.is("line")&&j>1&&(null==d?void 0:d.target)&&h&&!h.lineWidthFilter&&(h.lineWidthFilter=l.renderer.definition({tagName:"filter",children:[{tagName:"feMorphology",attributes:{operator:"dilate",radius:.25*j}}],attributes:{id:"linewidth"}}),d.target.attr({filter:"url(#linewidth)"})),F&&(M(F,this),F.pushSeries(this),N(this));var K=F.settings;l.renderer.forExport||(K.debug.timeKDTree&&console.time("kd tree building"),w(_?this.data.slice(z):g||b,function(s,n){var a,h,c,d,f,g=void 0===l.index,b=!1,v=!0;return!C(s)||(!g&&(O?(a=s[0],h=s[1]):(a=s,h=m[n]),G?(O&&(h=s.slice(1,3)),b=h[0],h=h[1]):_&&(a=s.x,b=(h=s.stackY)-s.y,f=s.percentage),I||(v=(h||0)>=E&&h<=S),null!==h&&a>=x&&a<=y&&v&&(c=u.toPixels(a,!0),D?((void 0===o||c===t)&&(G||(b=h),(void 0===r||h>i)&&(i=h,r=n),(void 0===o||b<e)&&(e=b,o=n)),X&&c===t||(void 0!==o&&(d=p.toPixels(i,!0),W=p.toPixels(e,!0),H(c,d,r,f),W!==d&&H(c,W,o,f)),o=r=void 0,t=c)):H(c,d=Math.ceil(p.toPixels(h,!0)),n,f))),!g)},function(){A(s,"renderedCanvas"),delete s.buildKDTree,s.options&&s.buildKDTree(),K.debug.timeKDTree&&console.timeEnd("kd tree building")}))}}function O(t){var e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;var i=U(this.chart,this);i&&(M(i,this),i.pushSeries(this)),N(this)}function X(t){if(this.boosted){if(D(this))return{};if(this.xAxis.isPanning||this.yAxis.isPanning)return this}return t.apply(this,[].slice.call(arguments,1))}function V(e){var i,o,r=this.options.data;if(k(this.chart)&&t[this.type]){var s=this.is("scatter")&&!this.is("bubble");if(!B(this,r)||s||this.options.stacking||!D(this,!0)){if(this.boosted&&((null===(i=this.xAxis)||void 0===i?void 0:i.isPanning)||(null===(o=this.yAxis)||void 0===o?void 0:o.isPanning)))return;s&&!this.yAxis.treeGrid?z.call(this,arguments[1]):e.apply(this,[].slice.call(arguments,1)),r=this.processedXData}if(this.boosted=B(this,r),this.boosted){var n=void 0;this.options.data&&this.options.data.length&&!P(n=this.getFirstValidPoint(this.options.data))&&!y(n)&&v(12,!1,this.chart),function(t){t.boost=t.boost||{getPoint:function(e){return _(t,e)}};var e,i=t.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(function(e){i.push({prop:e,val:t[e],own:Object.hasOwnProperty.call(t,e)})}),t.allowDG=!1,t.directTouch=!1,t.stickyTracking=!0,t.finishedAnimating=!0,t.labelBySeries&&(t.labelBySeries=t.labelBySeries.destroy()),t.is("scatter")&&t.data.length){for(var o=0,r=t.data;o<r.length;o++){var s=r[o];null===(e=null==s?void 0:s.destroy)||void 0===e||e.call(s)}t.data.length=0,t.points.length=0,delete t.processedData}}(this)}else!function(t){var e=t.boost,i=t.chart,o=i.boost;if(null==o?void 0:o.markerGroup){o.markerGroup.destroy(),o.markerGroup=void 0;for(var r=0,s=i.series;r<s.length;r++){var n=s[r];n.markerGroup=void 0,n.markerGroup=n.plotGroup("markerGroup","markers","visible",1,i.seriesGroup).addClass("highcharts-tracker")}}e&&((e.altered||[]).forEach(function(e){e.own?t[e.prop]=e.val:delete t[e.prop]}),e.clear&&e.clear())}(this)}else e.apply(this,[].slice.call(arguments,1))}function j(t){var e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}return{compose:function(i,o,r){if(E(u,"Boost.Series")){var s=d().plotOptions,n=i.prototype;if(m(i,"destroy",L),m(i,"hide",G),r&&(n.renderCanvas=I),S(n,"getExtremes",X),S(n,"processData",V),S(n,"searchPoint",j),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(e){return function(e,i,o){function r(e){var i=this.options.stacking&&("translate"===o||"generatePoints"===o);this.boosted&&!i&&k(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&t[this.type]&&0!==this.options.boostThreshold?"render"===o&&this.renderCanvas&&this.renderCanvas():e.call(this)}if(S(e,o,r),"translate"===o)for(var s=0,n=["column","arearange","columnrange","heatmap","treemap"];s<n.length;s++){var a=n[s];i[a]&&S(i[a].prototype,o,r)}}(n,o,e)}),e.forEach(function(t){var e=s[t];e&&(e.boostThreshold=5e3,e.boostData=[],o[t].prototype.fillOpacity=!0)}),r){var a=o.area,l=o.areaspline,h=o.bubble,c=o.column,p=o.heatmap,f=o.scatter,g=o.treemap;if(a&&x(a.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),l&&x(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),h){var b=h.prototype;delete b.buildKDTree,S(b,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}c&&x(c.prototype,{fill:!0,sampling:!0}),f&&(f.prototype.fill=!0),[p,g].forEach(function(t){t&&S(t.prototype,"drawPoints",O)})}}return i},destroyGraphics:R,eachAsync:w,getPoint:_}}),i(e,"Extensions/BoostCanvas.js",[e["Extensions/Boost/BoostChart.js"],e["Extensions/Boost/BoostSeries.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,o,r){var s,n=t.getBoostClipRect,a=t.isChartSeriesBoosting,l=e.destroyGraphics,h=i.parse,c=o.doc,d=o.noop,u=r.addEvent,p=r.fireEvent,f=r.isNumber,g=r.merge,m=r.pick,b=r.wrap;return function(t){var o,s="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";function v(t,e,i,o,r){r&&e!==r.clientX&&(t.moveTo(r.clientX,r.yBottom),t.lineTo(r.clientX,r.plotY),t.lineTo(e,i),t.lineTo(e,o))}function x(t,e,i,o,r){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[r],0,2*Math.PI,!1)}function A(t,e,i,o){t.rect(e-1,i,1,o-i)}function y(){this.boost&&this.boost.copy&&this.boost.copy()}function P(){var t=this.boost||{};t.target&&t.target.attr({href:s}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function T(){a(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function E(t,e,i){t.lineTo(e,i)}function S(){var t,e=this.chart,i=a(e)?e:this,o=i===e?e.seriesGroup:e.seriesGroup||this.group,r=e.chartWidth,l=e.chartHeight,h=function(t,e,i,o,r,s,n){t.call(this,i,e,o,r,s,n)},d=i.boost=i.boost||{};return t=d.targetCtx,d.canvas||(d.canvas=c.createElement("canvas"),d.target=e.renderer.image("",0,0,r,l).addClass("highcharts-boost-canvas").add(o),t=d.targetCtx=d.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(e){b(t,e,h)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},d.clear=function(){t.clearRect(0,0,d.canvas.width,d.canvas.height),i===d.target&&d.target.attr({href:s})},d.clipRect=e.renderer.clipRect(),d.target.clip(d.clipRect)),d.canvas.width!==r&&(d.canvas.width=r),d.canvas.height!==l&&(d.canvas.height=l),d.target.attr({x:0,y:0,width:r,height:l,style:"pointer-events: none",href:s}),d.clipRect&&d.clipRect.attr(n(e,i)),t}function C(){var t=this,n=t.options,a=t.chart,c=t.xAxis,b=t.yAxis,v=a.options.boost||{},x={timeRendering:v.timeRendering||!1,timeSeriesProcessing:v.timeSeriesProcessing||!1,timeSetup:v.timeSetup||!1},A=t.processedXData,y=t.processedYData,P=n.data,T=c.getExtremes(),E=T.min,S=T.max,C=b.getExtremes(),M=C.min,k=C.max,U={},R=!!t.sampling,w=n.marker&&n.marker.radius,D=t.cvsStrokeBatch||1e3,B=n.enableMouseTracking,L=n.threshold,G=f(L),N=b.getThreshold(L),_=t.fill,z=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),I=!!n.stacking,O=t.cropStart||0,X=a.options.loading,V=t.requireSorting,j=n.connectNulls,F=!A,W=I?t.data:A||P,Y=t.fillOpacity?i.parse(t.color).setOpacity(m(n.fillOpacity,.75)).get():t.color,H="x"===n.findNearestPointBy,K=this.boost||{},Z=t.cvsDrawPoint,q=n.lineWidth?t.cvsLineTo:void 0,Q=w&&w<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;K.target&&K.target.attr({href:s}),(t.points||t.graph)&&l(t),t.plotGroup("group","series",t.visible?"visible":"hidden",n.zIndex,a.seriesGroup),t.markerGroup=t.group,u(t,"destroy",function(){t.markerGroup=null});var J=this.points=[],$=this.getContext();if(t.buildKDTree=d,K.clear&&K.clear(),t.visible){P.length>99999&&(a.options.loading=g(X,{labelStyle:{backgroundColor:h("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),r.clearTimeout(o),a.showLoading("Drawing..."),a.options.loading=X),x.timeRendering&&console.time("canvas rendering");var tt,te,ti,to,tr,ts,tn,ta,tl=0,th=N,tc=function(){_?($.fillStyle=Y,$.fill()):($.strokeStyle=t.color,$.lineWidth=n.lineWidth,$.stroke())},td=function(e,i,o,r){0===tl&&($.beginPath(),q&&($.lineJoin="round")),a.scroller&&"highcharts-navigator-series"===t.options.className?(i+=a.scroller.top,o&&(o+=a.scroller.top)):i+=a.plotTop,e+=a.plotLeft,ti?$.moveTo(e,i):Z?Z($,e,i,o,te):q?q($,e,i):Q&&Q.call(t,$,e,i,w,r),(tl+=1)===D&&(tc(),tl=0),te={clientX:e,plotY:i,yBottom:o}},tu=this.xData||this.options.xData||this.processedXData||!1,tp=function(t,e,i){ta=H?t:t+","+e,B&&!U[ta]&&(U[ta]=!0,a.inverted&&(t=c.len-t,e=b.len-e),J.push({x:!!tu&&tu[O+i],clientX:t,plotX:t,plotY:e,i:O+i}))};e.eachAsync(W,function(e,i){var o,r,s,n,l,h,d=void 0===a.index,u=!1,p=!1,f=NaN,g=NaN,m=!0;return!d&&(F?(o=e[0],r=e[1],W[i+1]&&(f=W[i+1][0]),W[i-1]&&(g=W[i-1][0])):(o=e,r=y[i],W[i+1]&&(f=W[i+1]),W[i-1]&&(g=W[i-1])),f&&f>=E&&f<=S&&(u=!0),g&&g>=E&&g<=S&&(p=!0),z?(F&&(r=e.slice(1,3)),h=r[0],r=r[1]):I&&(o=e.x,h=(r=e.stackY)-e.y),l=null===r,V||(m=r>=M&&r<=k),!l&&(o>=E&&o<=S&&m||u||p)&&(s=Math.round(c.toPixels(o,!0)),R?((void 0===ts||s===tt)&&(z||(h=r),(void 0===tn||r>tr)&&(tr=r,tn=i),(void 0===ts||h<to)&&(to=h,ts=i)),s!==tt&&(void 0!==ts&&(n=b.toPixels(tr,!0),th=b.toPixels(to,!0),td(s,G?Math.min(n,N):n,G?Math.max(th,N):th,i),tp(s,n,tn),th!==n&&tp(s,th,ts)),ts=tn=void 0,tt=s)):(td(s,n=Math.round(b.toPixels(r,!0)),th,i),tp(s,n,i))),ti=l&&!j,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!d},function(){var e=a.loadingDiv,i=a.loadingShown;tc(),t.canvasToSVG(),x.timeRendering&&console.timeEnd("canvas rendering"),p(t,"renderedCanvas"),i&&(e.style.transition="opacity 250ms",e.opacity=0,a.loadingShown=!1,o=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),a.loadingDiv=a.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},a.renderer.forExport?Number.MAX_VALUE:void 0)}}function M(t,e,i,o){t.moveTo(e,i),t.arc(e,i,o,0,2*Math.PI,!1)}function k(t,e,i,o){t.rect(e-o,i-o,2*o,2*o)}function U(){var t=this.chart,e=this.getContext(),i=this.chart.inverted,o=this.xAxis,r=this.yAxis;e?(this.points.forEach(function(s){var n,a=s.plotY;if(void 0!==a&&!isNaN(a)&&null!==s.y&&e){var l=s.shapeArgs||{},h=l.x,c=void 0===h?0:h,d=l.y,u=void 0===d?0:d,p=l.width,f=void 0===p?0:p,g=l.height,m=void 0===g?0:g;n=t.styledMode?s.series.colorAttribs(s):s.series.pointAttribs(s),e.fillStyle=n.fill,i?e.fillRect(r.len-u+o.left,o.len-c+r.top,-m,-f):e.fillRect(c+o.left,u+r.top,f,m)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,i){var o=e.prototype;if(!o.renderCanvas){var r=i.area,s=i.bubble,n=i.column,a=i.heatmap,l=i.scatter;if(t.prototype.callbacks.push(function(t){u(t,"predraw",P),u(t,"render",y)}),o.canvasToSVG=T,o.cvsLineTo=E,o.getContext=S,o.renderCanvas=C,r){var h=r.prototype;h.cvsDrawPoint=v,h.fill=!0,h.fillOpacity=!0,h.sampling=!0}if(s){var c=s.prototype;c.cvsMarkerCircle=x,c.cvsStrokeBatch=1}if(n){var d=n.prototype;d.cvsDrawPoint=A,d.fill=!0,d.sampling=!0}if(a&&b(a.prototype,"drawPoints",U),l){var p=l.prototype;p.cvsMarkerCircle=M,p.cvsMarkerSquare=k,p.fill=!0}}}}(s||(s={})),s}),i(e,"masters/modules/boost-canvas.src.js",[e["Core/Globals.js"],e["Extensions/BoostCanvas.js"]],function(t,e){return t.initCanvasBoost=function(){e.compose(t.Chart,t.Series,t.seriesTypes)},t})});