!/**
 * Highcharts JS v11.4.6 (2024-07-08)
 *
 * 3D features for Highcharts JS
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/highcharts-3d",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(e,i,s,r){e.hasOwnProperty(i)||(e[i]=r.apply(null,s),"function"==typeof CustomEvent&&t.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:e[i]}})))}i(e,"Core/Math3D.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.deg2rad,s=e.pick;function r(t,e,r,a){var n=e.options.chart.options3d,h=s(a,!!r&&e.inverted),l={x:e.plotWidth/2,y:e.plotHeight/2,z:n.depth/2,vd:s(n.depth,1)*s(n.viewDistance,0)},p=e.scale3d||1,c=i*n.beta*(h?-1:1),d=i*n.alpha*(h?-1:1),x={cosA:Math.cos(d),cosB:Math.cos(-c),sinA:Math.sin(d),sinB:Math.sin(-c)};return r||(l.x+=e.plotLeft,l.y+=e.plotTop),t.map(function(t){var e,i,s,r=(e=(h?t.y:t.x)-l.x,i=(h?t.x:t.y)-l.y,s=(t.z||0)-l.z,{x:x.cosB*e-x.sinB*s,y:-x.sinA*x.sinB*e+x.cosA*i-x.cosB*x.sinA*s,z:x.cosA*x.sinB*e+x.sinA*i+x.cosA*x.cosB*s}),a=o(r,l,l.vd);return a.x=a.x*p+l.x,a.y=a.y*p+l.y,a.z=r.z*p+l.z,{x:h?a.y:a.x,y:h?a.x:a.y,z:a.z}})}function o(t,e,i){var s=i>0&&i<Number.POSITIVE_INFINITY?i/(t.z+e.z+i):1;return{x:t.x*s,y:t.y*s}}function a(t){var e,i,s=0;for(e=0;e<t.length;e++)i=(e+1)%t.length,s+=t[e].x*t[i].y-t[i].x*t[e].y;return s/2}return{perspective:r,perspective3D:o,pointCameraDistance:function(t,e){var i=e.options.chart.options3d,r={x:e.plotWidth/2,y:e.plotHeight/2,z:s(i.depth,1)*s(i.viewDistance,0)+i.depth};return Math.sqrt(Math.pow(r.x-s(t.plotX,t.x),2)+Math.pow(r.y-s(t.plotY,t.y),2)+Math.pow(r.z-s(t.plotZ,t.z),2))},shapeArea:a,shapeArea3D:function(t,e,i){return a(r(t,e,i))}}}),i(e,"Core/Chart/Chart3D.js",[e["Core/Color/Color.js"],e["Core/Defaults.js"],e["Core/Math3D.js"],e["Core/Utilities.js"]],function(t,e,i,s){var r,o=t.parse,a=e.defaultOptions,n=i.perspective,h=i.shapeArea3D,l=s.addEvent,p=s.isArray,c=s.merge,d=s.pick,x=s.wrap;return function(t){function e(t){this.is3d()&&"scatter"===t.options.type&&(t.options.type="scatter3d")}function i(){if(this.chart3d&&this.is3d()){var t=this.renderer,e=this.options.chart.options3d,i=this.chart3d.get3dFrame(),s=this.plotLeft,r=this.plotLeft+this.plotWidth,a=this.plotTop,n=this.plotTop+this.plotHeight,h=e.depth,l=s-(i.left.visible?i.left.size:0),p=r+(i.right.visible?i.right.size:0),c=a-(i.top.visible?i.top.size:0),d=n+(i.bottom.visible?i.bottom.size:0),x=0-(i.front.visible?i.front.size:0),f=h+(i.back.visible?i.back.size:0),y=this.hasRendered?"animate":"attr";this.chart3d.frame3d=i,this.frameShapes||(this.frameShapes={bottom:t.polyhedron().add(),top:t.polyhedron().add(),left:t.polyhedron().add(),right:t.polyhedron().add(),back:t.polyhedron().add(),front:t.polyhedron().add()}),this.frameShapes.bottom[y]({class:"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:i.bottom.frontFacing?-1e3:1e3,faces:[{fill:o(i.bottom.color).brighten(.1).get(),vertexes:[{x:l,y:d,z:x},{x:p,y:d,z:x},{x:p,y:d,z:f},{x:l,y:d,z:f}],enabled:i.bottom.visible},{fill:o(i.bottom.color).brighten(.1).get(),vertexes:[{x:s,y:n,z:h},{x:r,y:n,z:h},{x:r,y:n,z:0},{x:s,y:n,z:0}],enabled:i.bottom.visible},{fill:o(i.bottom.color).brighten(-.1).get(),vertexes:[{x:l,y:d,z:x},{x:l,y:d,z:f},{x:s,y:n,z:h},{x:s,y:n,z:0}],enabled:i.bottom.visible&&!i.left.visible},{fill:o(i.bottom.color).brighten(-.1).get(),vertexes:[{x:p,y:d,z:f},{x:p,y:d,z:x},{x:r,y:n,z:0},{x:r,y:n,z:h}],enabled:i.bottom.visible&&!i.right.visible},{fill:o(i.bottom.color).get(),vertexes:[{x:p,y:d,z:x},{x:l,y:d,z:x},{x:s,y:n,z:0},{x:r,y:n,z:0}],enabled:i.bottom.visible&&!i.front.visible},{fill:o(i.bottom.color).get(),vertexes:[{x:l,y:d,z:f},{x:p,y:d,z:f},{x:r,y:n,z:h},{x:s,y:n,z:h}],enabled:i.bottom.visible&&!i.back.visible}]}),this.frameShapes.top[y]({class:"highcharts-3d-frame highcharts-3d-frame-top",zIndex:i.top.frontFacing?-1e3:1e3,faces:[{fill:o(i.top.color).brighten(.1).get(),vertexes:[{x:l,y:c,z:f},{x:p,y:c,z:f},{x:p,y:c,z:x},{x:l,y:c,z:x}],enabled:i.top.visible},{fill:o(i.top.color).brighten(.1).get(),vertexes:[{x:s,y:a,z:0},{x:r,y:a,z:0},{x:r,y:a,z:h},{x:s,y:a,z:h}],enabled:i.top.visible},{fill:o(i.top.color).brighten(-.1).get(),vertexes:[{x:l,y:c,z:f},{x:l,y:c,z:x},{x:s,y:a,z:0},{x:s,y:a,z:h}],enabled:i.top.visible&&!i.left.visible},{fill:o(i.top.color).brighten(-.1).get(),vertexes:[{x:p,y:c,z:x},{x:p,y:c,z:f},{x:r,y:a,z:h},{x:r,y:a,z:0}],enabled:i.top.visible&&!i.right.visible},{fill:o(i.top.color).get(),vertexes:[{x:l,y:c,z:x},{x:p,y:c,z:x},{x:r,y:a,z:0},{x:s,y:a,z:0}],enabled:i.top.visible&&!i.front.visible},{fill:o(i.top.color).get(),vertexes:[{x:p,y:c,z:f},{x:l,y:c,z:f},{x:s,y:a,z:h},{x:r,y:a,z:h}],enabled:i.top.visible&&!i.back.visible}]}),this.frameShapes.left[y]({class:"highcharts-3d-frame highcharts-3d-frame-left",zIndex:i.left.frontFacing?-1e3:1e3,faces:[{fill:o(i.left.color).brighten(.1).get(),vertexes:[{x:l,y:d,z:x},{x:s,y:n,z:0},{x:s,y:n,z:h},{x:l,y:d,z:f}],enabled:i.left.visible&&!i.bottom.visible},{fill:o(i.left.color).brighten(.1).get(),vertexes:[{x:l,y:c,z:f},{x:s,y:a,z:h},{x:s,y:a,z:0},{x:l,y:c,z:x}],enabled:i.left.visible&&!i.top.visible},{fill:o(i.left.color).brighten(-.1).get(),vertexes:[{x:l,y:d,z:f},{x:l,y:c,z:f},{x:l,y:c,z:x},{x:l,y:d,z:x}],enabled:i.left.visible},{fill:o(i.left.color).brighten(-.1).get(),vertexes:[{x:s,y:a,z:h},{x:s,y:n,z:h},{x:s,y:n,z:0},{x:s,y:a,z:0}],enabled:i.left.visible},{fill:o(i.left.color).get(),vertexes:[{x:l,y:d,z:x},{x:l,y:c,z:x},{x:s,y:a,z:0},{x:s,y:n,z:0}],enabled:i.left.visible&&!i.front.visible},{fill:o(i.left.color).get(),vertexes:[{x:l,y:c,z:f},{x:l,y:d,z:f},{x:s,y:n,z:h},{x:s,y:a,z:h}],enabled:i.left.visible&&!i.back.visible}]}),this.frameShapes.right[y]({class:"highcharts-3d-frame highcharts-3d-frame-right",zIndex:i.right.frontFacing?-1e3:1e3,faces:[{fill:o(i.right.color).brighten(.1).get(),vertexes:[{x:p,y:d,z:f},{x:r,y:n,z:h},{x:r,y:n,z:0},{x:p,y:d,z:x}],enabled:i.right.visible&&!i.bottom.visible},{fill:o(i.right.color).brighten(.1).get(),vertexes:[{x:p,y:c,z:x},{x:r,y:a,z:0},{x:r,y:a,z:h},{x:p,y:c,z:f}],enabled:i.right.visible&&!i.top.visible},{fill:o(i.right.color).brighten(-.1).get(),vertexes:[{x:r,y:a,z:0},{x:r,y:n,z:0},{x:r,y:n,z:h},{x:r,y:a,z:h}],enabled:i.right.visible},{fill:o(i.right.color).brighten(-.1).get(),vertexes:[{x:p,y:d,z:x},{x:p,y:c,z:x},{x:p,y:c,z:f},{x:p,y:d,z:f}],enabled:i.right.visible},{fill:o(i.right.color).get(),vertexes:[{x:p,y:c,z:x},{x:p,y:d,z:x},{x:r,y:n,z:0},{x:r,y:a,z:0}],enabled:i.right.visible&&!i.front.visible},{fill:o(i.right.color).get(),vertexes:[{x:p,y:d,z:f},{x:p,y:c,z:f},{x:r,y:a,z:h},{x:r,y:n,z:h}],enabled:i.right.visible&&!i.back.visible}]}),this.frameShapes.back[y]({class:"highcharts-3d-frame highcharts-3d-frame-back",zIndex:i.back.frontFacing?-1e3:1e3,faces:[{fill:o(i.back.color).brighten(.1).get(),vertexes:[{x:p,y:d,z:f},{x:l,y:d,z:f},{x:s,y:n,z:h},{x:r,y:n,z:h}],enabled:i.back.visible&&!i.bottom.visible},{fill:o(i.back.color).brighten(.1).get(),vertexes:[{x:l,y:c,z:f},{x:p,y:c,z:f},{x:r,y:a,z:h},{x:s,y:a,z:h}],enabled:i.back.visible&&!i.top.visible},{fill:o(i.back.color).brighten(-.1).get(),vertexes:[{x:l,y:d,z:f},{x:l,y:c,z:f},{x:s,y:a,z:h},{x:s,y:n,z:h}],enabled:i.back.visible&&!i.left.visible},{fill:o(i.back.color).brighten(-.1).get(),vertexes:[{x:p,y:c,z:f},{x:p,y:d,z:f},{x:r,y:n,z:h},{x:r,y:a,z:h}],enabled:i.back.visible&&!i.right.visible},{fill:o(i.back.color).get(),vertexes:[{x:s,y:a,z:h},{x:r,y:a,z:h},{x:r,y:n,z:h},{x:s,y:n,z:h}],enabled:i.back.visible},{fill:o(i.back.color).get(),vertexes:[{x:l,y:d,z:f},{x:p,y:d,z:f},{x:p,y:c,z:f},{x:l,y:c,z:f}],enabled:i.back.visible}]}),this.frameShapes.front[y]({class:"highcharts-3d-frame highcharts-3d-frame-front",zIndex:i.front.frontFacing?-1e3:1e3,faces:[{fill:o(i.front.color).brighten(.1).get(),vertexes:[{x:l,y:d,z:x},{x:p,y:d,z:x},{x:r,y:n,z:0},{x:s,y:n,z:0}],enabled:i.front.visible&&!i.bottom.visible},{fill:o(i.front.color).brighten(.1).get(),vertexes:[{x:p,y:c,z:x},{x:l,y:c,z:x},{x:s,y:a,z:0},{x:r,y:a,z:0}],enabled:i.front.visible&&!i.top.visible},{fill:o(i.front.color).brighten(-.1).get(),vertexes:[{x:l,y:c,z:x},{x:l,y:d,z:x},{x:s,y:n,z:0},{x:s,y:a,z:0}],enabled:i.front.visible&&!i.left.visible},{fill:o(i.front.color).brighten(-.1).get(),vertexes:[{x:p,y:d,z:x},{x:p,y:c,z:x},{x:r,y:a,z:0},{x:r,y:n,z:0}],enabled:i.front.visible&&!i.right.visible},{fill:o(i.front.color).get(),vertexes:[{x:r,y:a,z:0},{x:s,y:a,z:0},{x:s,y:n,z:0},{x:r,y:n,z:0}],enabled:i.front.visible},{fill:o(i.front.color).get(),vertexes:[{x:p,y:d,z:x},{x:l,y:d,z:x},{x:l,y:c,z:x},{x:p,y:c,z:x}],enabled:i.front.visible}]})}}function s(){this.styledMode&&[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(t){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+t.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:t.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:t.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:t.slope}}]}]})},this)}function r(){var t=this.options;this.is3d()&&(t.series||[]).forEach(function(e){"scatter"===(e.type||t.chart.type||t.chart.defaultSeriesType)&&(e.type="scatter3d")})}function f(){var t=this.options.chart.options3d;if(this.chart3d&&this.is3d()){t&&(t.alpha=t.alpha%360+(t.alpha>=0?0:360),t.beta=t.beta%360+(t.beta>=0?0:360));var e=this.inverted,i=this.clipBox,s=this.margin;i[e?"y":"x"]=-(s[3]||0),i[e?"x":"y"]=-(s[0]||0),i[e?"height":"width"]=this.chartWidth+(s[3]||0)+(s[1]||0),i[e?"width":"height"]=this.chartHeight+(s[0]||0)+(s[2]||0),this.scale3d=1,!0===t.fitToPlot&&(this.scale3d=this.chart3d.getScale(t.depth)),this.chart3d.frame3d=this.chart3d.get3dFrame()}}function y(){this.is3d()&&(this.isDirtyBox=!0)}function u(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function v(){this.chart3d||(this.chart3d=new m(this))}function z(t){return this.is3d()||t.apply(this,[].slice.call(arguments,1))}function b(t){var e,i=this.series.length;if(this.is3d())for(;i--;)(e=this.series[i]).translate(),e.render();else t.call(this)}function g(t){t.apply(this,[].slice.call(arguments,1)),this.is3d()&&(this.container.className+=" highcharts-3d-chart")}t.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}},t.compose=function(o,n){var h=o.prototype,d=n.prototype;h.is3d=function(){var t;return!!(null===(t=this.options.chart.options3d)||void 0===t?void 0:t.enabled)},h.propsRequireDirtyBox.push("chart.options3d"),h.propsRequireUpdateSeries.push("chart.options3d"),d.matrixSetter=function(){var t;if(this.pos<1&&(p(this.start)||p(this.end))){var e=this.start||[1,0,0,1,0,0],i=this.end||[1,0,0,1,0,0];t=[];for(var s=0;s<6;s++)t.push(this.pos*i[s]+(1-this.pos)*e[s])}else t=this.end;this.elem.attr(this.prop,t,null,!0)},c(!0,a,t.defaultOptions),l(o,"init",v),l(o,"addSeries",e),l(o,"afterDrawChartBox",i),l(o,"afterGetContainer",s),l(o,"afterInit",r),l(o,"afterSetChartSize",f),l(o,"beforeRedraw",y),l(o,"beforeRender",u),x(h,"isInsidePlot",z),x(h,"renderSeries",b),x(h,"setClassName",g)};var m=function(){function t(t){this.chart=t}return t.prototype.get3dFrame=function(){var t=this.chart,e=t.options.chart.options3d,i=e.frame,s=t.plotLeft,r=t.plotLeft+t.plotWidth,o=t.plotTop,a=t.plotTop+t.plotHeight,l=e.depth,p=function(e){var i=h(e,t);return i>.5?1:i<-.5?-1:0},c=p([{x:s,y:a,z:l},{x:r,y:a,z:l},{x:r,y:a,z:0},{x:s,y:a,z:0}]),x=p([{x:s,y:o,z:0},{x:r,y:o,z:0},{x:r,y:o,z:l},{x:s,y:o,z:l}]),f=p([{x:s,y:o,z:0},{x:s,y:o,z:l},{x:s,y:a,z:l},{x:s,y:a,z:0}]),y=p([{x:r,y:o,z:l},{x:r,y:o,z:0},{x:r,y:a,z:0},{x:r,y:a,z:l}]),u=p([{x:s,y:a,z:0},{x:r,y:a,z:0},{x:r,y:o,z:0},{x:s,y:o,z:0}]),v=p([{x:s,y:o,z:l},{x:r,y:o,z:l},{x:r,y:a,z:l},{x:s,y:a,z:l}]),z=!1,b=!1,g=!1,m=!1;[].concat(t.xAxis,t.yAxis,t.zAxis).forEach(function(t){t&&(t.horiz?t.opposite?b=!0:z=!0:t.opposite?m=!0:g=!0)});var M=function(t,e,i){for(var s=["size","color","visible"],r={},o=0;o<s.length;o++)for(var a=s[o],n=0;n<t.length;n++)if("object"==typeof t[n]){var h=t[n][a];if(null!=h){r[a]=h;break}}var l=i;return!0===r.visible||!1===r.visible?l=r.visible:"auto"===r.visible&&(l=e>0),{size:d(r.size,1),color:d(r.color,"none"),frontFacing:e>0,visible:l}},P={axes:{},bottom:M([i.bottom,i.top,i],c,z),top:M([i.top,i.bottom,i],x,b),left:M([i.left,i.right,i.side,i],f,g),right:M([i.right,i.left,i.side,i],y,m),back:M([i.back,i.front,i],v,!0),front:M([i.front,i.back,i],u,!1)};if("auto"===e.axisLabelPosition){var A=function(t,e){return t.visible!==e.visible||t.visible&&e.visible&&t.frontFacing!==e.frontFacing},S=[];A(P.left,P.front)&&S.push({y:(o+a)/2,x:s,z:0,xDir:{x:1,y:0,z:0}}),A(P.left,P.back)&&S.push({y:(o+a)/2,x:s,z:l,xDir:{x:0,y:0,z:-1}}),A(P.right,P.front)&&S.push({y:(o+a)/2,x:r,z:0,xDir:{x:0,y:0,z:1}}),A(P.right,P.back)&&S.push({y:(o+a)/2,x:r,z:l,xDir:{x:-1,y:0,z:0}});var C=[];A(P.bottom,P.front)&&C.push({x:(s+r)/2,y:a,z:0,xDir:{x:1,y:0,z:0}}),A(P.bottom,P.back)&&C.push({x:(s+r)/2,y:a,z:l,xDir:{x:-1,y:0,z:0}});var D=[];A(P.top,P.front)&&D.push({x:(s+r)/2,y:o,z:0,xDir:{x:1,y:0,z:0}}),A(P.top,P.back)&&D.push({x:(s+r)/2,y:o,z:l,xDir:{x:-1,y:0,z:0}});var j=[];A(P.bottom,P.left)&&j.push({z:(0+l)/2,y:a,x:s,xDir:{x:0,y:0,z:-1}}),A(P.bottom,P.right)&&j.push({z:(0+l)/2,y:a,x:r,xDir:{x:0,y:0,z:1}});var k=[];A(P.top,P.left)&&k.push({z:(0+l)/2,y:o,x:s,xDir:{x:0,y:0,z:-1}}),A(P.top,P.right)&&k.push({z:(0+l)/2,y:o,x:r,xDir:{x:0,y:0,z:1}});var w=function(e,i,s){if(0===e.length)return null;if(1===e.length)return e[0];for(var r=n(e,t,!1),o=0,a=1;a<r.length;a++)s*r[a][i]>s*r[o][i]?o=a:s*r[a][i]==s*r[o][i]&&r[a].z<r[o].z&&(o=a);return e[o]};P.axes={y:{left:w(S,"x",-1),right:w(S,"x",1)},x:{top:w(D,"y",-1),bottom:w(C,"y",1)},z:{top:w(k,"y",-1),bottom:w(j,"y",1)}}}else P.axes={y:{left:{x:s,z:0,xDir:{x:1,y:0,z:0}},right:{x:r,z:0,xDir:{x:0,y:0,z:1}}},x:{top:{y:o,z:0,xDir:{x:1,y:0,z:0}},bottom:{y:a,z:0,xDir:{x:1,y:0,z:0}}},z:{top:{x:g?r:s,y:o,xDir:g?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:g?r:s,y:a,xDir:g?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return P},t.prototype.getScale=function(t){var e,i=this.chart,s=i.plotLeft,r=i.plotWidth+s,o=i.plotTop,a=i.plotHeight+o,h=s+i.plotWidth/2,l=o+i.plotHeight/2,p={minX:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,minY:Number.MAX_VALUE,maxY:-Number.MAX_VALUE},c=1;return e=[{x:s,y:o,z:0},{x:s,y:o,z:t}],[0,1].forEach(function(t){e.push({x:r,y:e[t].y,z:e[t].z})}),[0,1,2,3].forEach(function(t){e.push({x:e[t].x,y:a,z:e[t].z})}),(e=n(e,i,!1)).forEach(function(t){p.minX=Math.min(p.minX,t.x),p.maxX=Math.max(p.maxX,t.x),p.minY=Math.min(p.minY,t.y),p.maxY=Math.max(p.maxY,t.y)}),s>p.minX&&(c=Math.min(c,1-Math.abs((s+h)/(p.minX+h))%1)),r<p.maxX&&(c=Math.min(c,(r-h)/(p.maxX-h))),o>p.minY&&(c=p.minY<0?Math.min(c,(o+l)/(-p.minY+o+l)):Math.min(c,1-(o+l)/(p.minY+l)%1)),a<p.maxY&&(c=Math.min(c,Math.abs((a-l)/(p.maxY-l)))),c},t}();t.Additions=m}(r||(r={})),r}),i(e,"Series/Area3D/Area3DSeries.js",[e["Core/Globals.js"],e["Core/Math3D.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){var r=t.composed,o=e.perspective,a=i.seriesTypes.line.prototype,n=s.pushUnique,h=s.wrap;function l(t){var e=t.apply(this,[].slice.call(arguments,1));if(!this.chart.is3d())return e;var i=a.getGraphPath,s=this.options,r=Math.round(this.yAxis.getThreshold(s.threshold)),n=[];if(this.rawPointsX)for(var h=0;h<this.points.length;h++)n.push({x:this.rawPointsX[h],y:s.stacking?this.points[h].yBottom:r,z:this.zPadding});var l=this.chart.options.chart.options3d;n=o(n,this.chart,!0).map(function(t){return{plotX:t.x,plotY:t.y,plotZ:t.z}}),this.group&&l&&l.depth&&l.beta&&(this.markerGroup&&(this.markerGroup.add(this.group),this.markerGroup.attr({translateX:0,translateY:0})),this.group.attr({zIndex:Math.max(1,l.beta>270||l.beta<90?l.depth-Math.round(this.zPadding||0):Math.round(this.zPadding||0))})),n.reversed=!0;var p=i.call(this,n,!0,!0);if(p[0]&&"M"===p[0][0]&&(p[0]=["L",p[0][1],p[0][2]]),this.areaPath){var c=this.areaPath.splice(0,this.areaPath.length/2).concat(p);c.xMap=this.areaPath.xMap,this.areaPath=c}return this.graphPath=e,e}return{compose:function(t){n(r,"Area3DSeries")&&h(t.prototype,"getGraphPath",l)}}}),i(e,"Core/Axis/Axis3DDefaults.js",[],function(){return{labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}}}),i(e,"Core/Axis/Tick3DComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.composed,s=e.addEvent,r=e.extend,o=e.pushUnique,a=e.wrap;function n(t){var e=this.axis.axis3D;e&&r(t.pos,e.fix3dPosition(t.pos))}function h(t){var e=this.axis.axis3D,i=t.apply(this,[].slice.call(arguments,1));if(e){var s=i[0],r=i[1];if("M"===s[0]&&"L"===r[0]){var o=[e.fix3dPosition({x:s[1],y:s[2],z:0}),e.fix3dPosition({x:r[1],y:r[2],z:0})];return this.axis.chart.renderer.toLineSegments(o)}}return i}return{compose:function(t){o(i,"Axis.Tick3D")&&(s(t,"afterGetLabelPosition",n),a(t.prototype,"getMarkPath",h))}}}),i(e,"Core/Axis/Axis3DComposition.js",[e["Core/Axis/Axis3DDefaults.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Math3D.js"],e["Core/Axis/Tick3DComposition.js"],e["Core/Utilities.js"]],function(t,e,i,s,r,o){var a=e.defaultOptions,n=i.deg2rad,h=s.perspective,l=s.perspective3D,p=s.shapeArea,c=o.addEvent,d=o.merge,x=o.pick,f=o.wrap;function y(){var t=this.chart,e=this.options;t.is3d&&t.is3d()&&"colorAxis"!==this.coll&&(e.tickWidth=x(e.tickWidth,0),e.gridLineWidth=x(e.gridLineWidth,1))}function u(t){this.chart.is3d()&&"colorAxis"!==this.coll&&t.point&&(t.point.crosshairPos=this.isXAxis?t.point.axisXpos:this.len-t.point.axisYpos)}function v(){this.axis3D||(this.axis3D=new P(this))}function z(t){return this.chart.is3d()&&"colorAxis"!==this.coll?[]:t.apply(this,[].slice.call(arguments,1))}function b(t){if(!this.chart.is3d()||"colorAxis"===this.coll)return t.apply(this,[].slice.call(arguments,1));var e=arguments,i=e[1],s=e[2],r=[],o=this.getPlotLinePath({value:i}),a=this.getPlotLinePath({value:s});if(o&&a)for(var n=0;n<o.length;n+=2){var h=o[n],l=o[n+1],p=a[n],c=a[n+1];"M"===h[0]&&"L"===l[0]&&"M"===p[0]&&"L"===c[0]&&r.push(h,l,c,["L",p[1],p[2]],["Z"])}return r}function g(t){var e=this.axis3D,i=this.chart,s=t.apply(this,[].slice.call(arguments,1));if("colorAxis"===this.coll||!i.chart3d||!i.is3d()||null===s)return s;var r,o=i.options.chart.options3d,a=this.isZAxis?i.plotWidth:o.depth,n=i.chart3d.frame3d,l=s[0],p=s[1],c=[];return"M"===l[0]&&"L"===p[0]&&(r=[e.swapZ({x:l[1],y:l[2],z:0}),e.swapZ({x:l[1],y:l[2],z:a}),e.swapZ({x:p[1],y:p[2],z:0}),e.swapZ({x:p[1],y:p[2],z:a})],this.horiz?(this.isZAxis?(n.left.visible&&c.push(r[0],r[2]),n.right.visible&&c.push(r[1],r[3])):(n.front.visible&&c.push(r[0],r[2]),n.back.visible&&c.push(r[1],r[3])),n.top.visible&&c.push(r[0],r[1]),n.bottom.visible&&c.push(r[2],r[3])):(n.front.visible&&c.push(r[0],r[2]),n.back.visible&&c.push(r[1],r[3]),n.left.visible&&c.push(r[0],r[1]),n.right.visible&&c.push(r[2],r[3])),c=h(c,this.chart,!1)),i.renderer.toLineSegments(c)}function m(t,e){var i,s=this.chart,r=this.gridGroup,o=this.tickPositions,a=this.ticks;if(this.categories&&s.frameShapes&&s.is3d()&&r&&e&&e.label){var n=r.element.childNodes[0].getBBox(),h=s.frameShapes.left.getBBox(),p=s.options.chart.options3d,c={x:s.plotWidth/2,y:s.plotHeight/2,z:p.depth/2,vd:x(p.depth,1)*x(p.viewDistance,0)},d=o.indexOf(e.pos),f=a[o[d-1]],y=a[o[d+1]],u=void 0,v=void 0,z=void 0;return(null===(i=null==f?void 0:f.label)||void 0===i?void 0:i.xy)&&(v=l({x:f.label.xy.x,y:f.label.xy.y,z:null},c,c.vd)),y&&y.label&&y.label.xy&&(z=l({x:y.label.xy.x,y:y.label.xy.y,z:null},c,c.vd)),u=l(u={x:e.label.xy.x,y:e.label.xy.y,z:null},c,c.vd),Math.abs(v?u.x-v.x:z?z.x-u.x:n.x-h.x)}return t.apply(this,[].slice.call(arguments,1))}function M(t){var e=t.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(e,!0):e}var P=function(){function e(t){this.axis=t}return e.compose=function(e,i){if(r.compose(i),!e.keepProps.includes("axis3D")){d(!0,a.xAxis,t),e.keepProps.push("axis3D"),c(e,"init",v),c(e,"afterSetOptions",y),c(e,"drawCrosshair",u);var s=e.prototype;f(s,"getLinePath",z),f(s,"getPlotBandPath",b),f(s,"getPlotLinePath",g),f(s,"getSlotWidth",m),f(s,"getTitlePosition",M)}},e.prototype.fix3dPosition=function(t,e){var i=this.axis,s=i.chart;if("colorAxis"===i.coll||!s.chart3d||!s.is3d())return t;var r,o=n*s.options.chart.options3d.alpha,a=n*s.options.chart.options3d.beta,l=x(e&&i.options.title.position3d,i.options.labels.position3d),c=x(e&&i.options.title.skew3d,i.options.labels.skew3d),d=s.chart3d.frame3d,f=s.plotLeft,y=s.plotWidth+f,u=s.plotTop,v=s.plotHeight+u,z=0,b=0,g={x:0,y:1,z:0},m=!1;if(t=i.axis3D.swapZ({x:t.x,y:t.y,z:0}),i.isZAxis){if(i.opposite){if(null===d.axes.z.top)return{};b=t.y-u,t.x=d.axes.z.top.x,t.y=d.axes.z.top.y,r=d.axes.z.top.xDir,m=!d.top.frontFacing}else{if(null===d.axes.z.bottom)return{};b=t.y-v,t.x=d.axes.z.bottom.x,t.y=d.axes.z.bottom.y,r=d.axes.z.bottom.xDir,m=!d.bottom.frontFacing}}else if(i.horiz){if(i.opposite){if(null===d.axes.x.top)return{};b=t.y-u,t.y=d.axes.x.top.y,t.z=d.axes.x.top.z,r=d.axes.x.top.xDir,m=!d.top.frontFacing}else{if(null===d.axes.x.bottom)return{};b=t.y-v,t.y=d.axes.x.bottom.y,t.z=d.axes.x.bottom.z,r=d.axes.x.bottom.xDir,m=!d.bottom.frontFacing}}else if(i.opposite){if(null===d.axes.y.right)return{};z=t.x-y,t.x=d.axes.y.right.x,t.z=d.axes.y.right.z,r={x:(r=d.axes.y.right.xDir).z,y:r.y,z:-r.x}}else{if(null===d.axes.y.left)return{};z=t.x-f,t.x=d.axes.y.left.x,t.z=d.axes.y.left.z,r=d.axes.y.left.xDir}if("chart"===l);else if("flap"===l){if(i.horiz){var M=Math.sin(o),P=Math.cos(o);i.opposite&&(M=-M),m&&(M=-M),g={x:r.z*M,y:P,z:-r.x*M}}else r={x:Math.cos(a),y:0,z:Math.sin(a)}}else if("ortho"===l){if(i.horiz){var A=Math.sin(o),S=Math.cos(o),C={x:Math.sin(a)*S,y:-A,z:-S*Math.cos(a)},D=1/Math.sqrt((g={x:r.y*C.z-r.z*C.y,y:r.z*C.x-r.x*C.z,z:r.x*C.y-r.y*C.x}).x*g.x+g.y*g.y+g.z*g.z);m&&(D=-D),g={x:D*g.x,y:D*g.y,z:D*g.z}}else r={x:Math.cos(a),y:0,z:Math.sin(a)}}else i.horiz?g={x:Math.sin(a)*Math.sin(o),y:Math.cos(o),z:-Math.cos(a)*Math.sin(o)}:r={x:Math.cos(a),y:0,z:Math.sin(a)};t.x+=z*r.x+b*g.x,t.y+=z*r.y+b*g.y,t.z+=z*r.z+b*g.z;var j=h([t],i.chart)[0];if(c){0>p(h([t,{x:t.x+r.x,y:t.y+r.y,z:t.z+r.z},{x:t.x+g.x,y:t.y+g.y,z:t.z+g.z}],i.chart))&&(r={x:-r.x,y:-r.y,z:-r.z});var k=h([{x:t.x,y:t.y,z:t.z},{x:t.x+r.x,y:t.y+r.y,z:t.z+r.z},{x:t.x+g.x,y:t.y+g.y,z:t.z+g.z}],i.chart);j.matrix=[k[1].x-k[0].x,k[1].y-k[0].y,k[2].x-k[0].x,k[2].y-k[0].y,j.x,j.y],j.matrix[4]-=j.x*j.matrix[0]+j.y*j.matrix[2],j.matrix[5]-=j.x*j.matrix[1]+j.y*j.matrix[3]}return j},e.prototype.swapZ=function(t,e){var i=this.axis;if(i.isZAxis){var s=e?0:i.chart.plotLeft;return{x:s+t.z,y:t.y,z:t.x-s}}return t},e}();return P}),i(e,"Core/Series/Series3D.js",[e["Core/Globals.js"],e["Core/Math3D.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var r,o=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=t.composed,n=e.perspective,h=s.addEvent,l=s.extend,p=s.isNumber,c=s.merge,d=s.pick,x=s.pushUnique;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.compose=function(t){x(a,"Core.Series3D")&&(h(t,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()}),l(t.prototype,{translate3dPoints:e.prototype.translate3dPoints}))},e.prototype.translate3dPoints=function(){var t,e,i=this,s=i.options,r=i.chart,o=d(i.zAxis,r.options.zAxis[0]),a=[],h=[],l=s.stacking?p(s.stack)?s.stack:0:i.index||0;i.zPadding=l*(s.depth||0+(s.groupZPadding||1)),i.data.forEach(function(t){o&&o.translate?(e=o.logarithmic&&o.val2lin?o.val2lin(t.z):t.z,t.plotZ=o.translate(e),t.isInside=!!t.isInside&&e>=o.min&&e<=o.max):t.plotZ=i.zPadding,t.axisXpos=t.plotX,t.axisYpos=t.plotY,t.axisZpos=t.plotZ,a.push({x:t.plotX,y:t.plotY,z:t.plotZ}),h.push(t.plotX||0)}),i.rawPointsX=h;var c=n(a,r,!0);i.data.forEach(function(e,i){t=c[i],e.plotX=t.x,e.plotY=t.y,e.plotZ=t.z})},e.defaultOptions=c(i.defaultOptions),e}(i)}),i(e,"Core/Renderer/SVG/SVGElement3D.js",[e["Core/Color/Color.js"],e["Core/Renderer/RendererRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){var s,r=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),o=t.parse,a=e.getRendererType().prototype.Element,n=i.defined,h=i.pick;return function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.parts=["front","top","side"],e.pathType="cuboid",e}return r(e,t),e.prototype.initArgs=function(t){for(var e=this.renderer,i=e[this.pathType+"Path"](t),s=i.zIndexes,r=0,o=this.parts;r<o.length;r++){var a=o[r],n={class:"highcharts-3d-"+a,zIndex:s[a]||0};e.styledMode&&("top"===a?n.filter="url(#highcharts-brighter)":"side"===a&&(n.filter="url(#highcharts-darker)")),this[a]=e.path(i[a]).attr(n).add(this)}this.attr({"stroke-linejoin":"round",zIndex:s.group}),this.forcedSides=i.forcedSides},e.prototype.singleSetterForParts=function(t,e,i,s,r,o){var a={},n=[null,null,s||"attr",r,o],h=i&&i.zIndexes;if(i){h&&h.group&&this.attr({zIndex:h.group});for(var l=0,p=Object.keys(i);l<p.length;l++){var c=p[l];a[c]={},a[c][t]=i[c],h&&(a[c].zIndex=i.zIndexes[c]||0)}n[1]=a}else a[t]=e,n[0]=a;return this.processParts.apply(this,n)},e.prototype.processParts=function(t,e,i,s,r){for(var o=0,a=this.parts;o<a.length;o++){var n=a[o];e&&(t=h(e[n],!1)),!1!==t&&this[n][i](t,s,r)}return this},e.prototype.destroy=function(){return this.processParts(null,null,"destroy"),t.prototype.destroy.call(this)},e.prototype.attr=function(e,i,s,r){if("string"==typeof e&&void 0!==i){var o=e;(e={})[o]=i}return e.shapeArgs||n(e.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](e.shapeArgs||e)):t.prototype.attr.call(this,e,void 0,s,r)},e.prototype.animate=function(e,i,s){if(n(e.x)&&n(e.y)){var r=this.renderer[this.pathType+"Path"](e),o=r.forcedSides;this.singleSetterForParts("d",null,r,"animate",i,s),this.attr({zIndex:r.zIndexes.group}),o===this.forcedSides||(this.forcedSides=o,this.renderer.styledMode||this.fillSetter(this.fill))}else t.prototype.animate.call(this,e,i,s);return this},e.prototype.fillSetter=function(t){return this.forcedSides=this.forcedSides||[],this.singleSetterForParts("fill",null,{front:t,top:o(t).brighten(this.forcedSides.indexOf("top")>=0?0:.1).get(),side:o(t).brighten(this.forcedSides.indexOf("side")>=0?0:-.1).get()}),this.color=this.fill=t,this},e.types={base:e,cuboid:e},e}(a)}),i(e,"Core/Renderer/SVG/SVGRenderer3D.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Math3D.js"],e["Core/Renderer/SVG/SVGElement3D.js"],e["Core/Utilities.js"]],function(t,e,i,s,r,o){var a,n=t.animObject,h=e.parse,l=i.charts,p=i.deg2rad,c=s.perspective,d=s.shapeArea,x=o.defined,f=o.extend,y=o.merge,u=o.pick,v=Math.cos,z=Math.sin,b=Math.PI,g=4*(Math.sqrt(2)-1)/3/(b/2);function m(t,e,i,s,r,o,a,n){var h=o-r,l=[];return o>r&&o-r>Math.PI/2+1e-4?l=(l=l.concat(m(t,e,i,s,r,r+Math.PI/2,a,n))).concat(m(t,e,i,s,r+Math.PI/2,o,a,n)):o<r&&r-o>Math.PI/2+1e-4?l=(l=l.concat(m(t,e,i,s,r,r-Math.PI/2,a,n))).concat(m(t,e,i,s,r-Math.PI/2,o,a,n)):[["C",t+i*Math.cos(r)-i*g*h*Math.sin(r)+a,e+s*Math.sin(r)+s*g*h*Math.cos(r)+n,t+i*Math.cos(o)+i*g*h*Math.sin(o)+a,e+s*Math.sin(o)-s*g*h*Math.cos(o)+n,t+i*Math.cos(o)+a,e+s*Math.sin(o)+n]]}return function(t){function e(t,e){for(var i=[],s=0;s<t.length;s++){var r=t[s];i.push(["L",r.x,r.y])}return t.length&&(i[0][0]="M",e&&i.push(["Z"])),i}function s(t){for(var e=[],i=!0,s=0;s<t.length;s++){var r=t[s];e.push(i?["M",r.x,r.y]:["L",r.x,r.y]),i=!i}return e}function o(t){var e=this,i=e.Element.prototype,s=e.createElement("path");return s.vertexes=[],s.insidePlotArea=!1,s.enabled=!0,s.attr=function(t){if("object"==typeof t&&(x(t.enabled)||x(t.vertexes)||x(t.insidePlotArea))){this.enabled=u(t.enabled,this.enabled),this.vertexes=u(t.vertexes,this.vertexes),this.insidePlotArea=u(t.insidePlotArea,this.insidePlotArea),delete t.enabled,delete t.vertexes,delete t.insidePlotArea;var s=l[e.chartIndex],r=c(this.vertexes,s,this.insidePlotArea),o=e.toLinePath(r,!0),a=d(r);t.d=o,t.visibility=this.enabled&&a>0?"inherit":"hidden"}return i.attr.apply(this,arguments)},s.animate=function(t){if("object"==typeof t&&(x(t.enabled)||x(t.vertexes)||x(t.insidePlotArea))){this.enabled=u(t.enabled,this.enabled),this.vertexes=u(t.vertexes,this.vertexes),this.insidePlotArea=u(t.insidePlotArea,this.insidePlotArea),delete t.enabled,delete t.vertexes,delete t.insidePlotArea;var s=l[e.chartIndex],r=c(this.vertexes,s,this.insidePlotArea),o=e.toLinePath(r,!0),a=d(r),n=this.enabled&&a>0?"visible":"hidden";t.d=o,this.attr("visibility",n)}return i.animate.apply(this,arguments)},s.attr(t)}function a(t){var e=this,i=e.Element.prototype,s=e.g(),r=s.destroy;return this.styledMode||s.attr({"stroke-linejoin":"round"}),s.faces=[],s.destroy=function(){for(var t=0;t<s.faces.length;t++)s.faces[t].destroy();return r.call(this)},s.attr=function(t,r,o,a){if("object"==typeof t&&x(t.faces)){for(;s.faces.length>t.faces.length;)s.faces.pop().destroy();for(;s.faces.length<t.faces.length;)s.faces.push(e.face3d().add(s));for(var n=0;n<t.faces.length;n++)e.styledMode&&delete t.faces[n].fill,s.faces[n].attr(t.faces[n],null,o,a);delete t.faces}return i.attr.apply(this,arguments)},s.animate=function(t,r,o){if(t&&t.faces){for(;s.faces.length>t.faces.length;)s.faces.pop().destroy();for(;s.faces.length<t.faces.length;)s.faces.push(e.face3d().add(s));for(var a=0;a<t.faces.length;a++)s.faces[a].animate(t.faces[a],r,o);delete t.faces}return i.animate.apply(this,arguments)},s.attr(t)}function g(t,e){var i=new r.types[t](this,"g");return i.initArgs(e),i}function M(t){return this.element3d("cuboid",t)}function P(t){var e,i=t.x||0,s=t.y||0,r=t.z||0,o=t.height||0,a=t.width||0,n=t.depth||0,h=l[this.chartIndex],p=h.options.chart.options3d.alpha,x=[],f=0,y=[{x:i,y:s,z:r},{x:i+a,y:s,z:r},{x:i+a,y:s+o,z:r},{x:i,y:s+o,z:r},{x:i,y:s+o,z:r+n},{x:i+a,y:s+o,z:r+n},{x:i+a,y:s,z:r+n},{x:i,y:s,z:r+n}];y=c(y,h,t.insidePlotArea);var u=function(t){return 0===o&&t>1&&t<6?{x:y[t].x,y:y[t].y+10,z:y[t].z}:y[0].x===y[7].x&&t>=4?{x:y[t].x+10,y:y[t].y,z:y[t].z}:0===n&&t<2||t>5?{x:y[t].x,y:y[t].y,z:y[t].z+10}:y[t]},v=function(t){return y[t]},z=function(t,e,i){var s=t.map(v),r=e.map(v),o=t.map(u),a=e.map(u),n=[[],-1];return 0>d(s)?n=[s,0]:0>d(r)?n=[r,1]:i&&(x.push(i),n=0>d(o)?[s,0]:0>d(a)?[r,1]:[s,0]),n},b=(e=z([3,2,1,0],[7,6,5,4],"front"))[0],g=e[1],m=(e=z([1,6,7,0],[4,5,2,3],"top"))[0],M=e[1],P=(e=z([1,2,5,6],[0,7,4,3],"side"))[0],A=e[1];return 1===A?f+=1e6*(h.plotWidth-i):A||(f+=1e6*i),f+=10*(!M||p>=0&&p<=180||p<360&&p>357.5?h.plotHeight-s:10+s),1===g?f+=100*r:g||(f+=100*(1e3-r)),{front:this.toLinePath(b,!0),top:this.toLinePath(m,!0),side:this.toLinePath(P,!0),zIndexes:{group:Math.round(f)},forcedSides:x,isFront:g,isTop:M}}function A(t){var e=this.g(),s=this.Element.prototype,r=["x","y","r","innerR","start","end","depth"];function o(t){var e,i={},s=!1;for(e in t=y(t))-1!==r.indexOf(e)&&(i[e]=t[e],delete t[e],s=!0);return!!s&&[i,t]}(t=y(t)).alpha=(t.alpha||0)*p,t.beta=(t.beta||0)*p,e.top=this.path(),e.side1=this.path(),e.side2=this.path(),e.inn=this.path(),e.out=this.path(),e.onAdd=function(){var t=e.parentGroup,i=e.attr("class");e.top.add(e);for(var s=0,r=["out","inn","side1","side2"];s<r.length;s++)e[r[s]].attr({class:i+" highcharts-3d-side"}).add(t)};for(var a=function(t){e[t]=function(){for(var i=arguments,s=0,r=["top","out","inn","side1","side2"];s<r.length;s++){var o=r[s];e[o][t].apply(e[o],i)}}},l=0,c=["addClass","removeClass"];l<c.length;l++)a(c[l]);e.setPaths=function(t){var i=e.renderer.arc3dPath(t),s=100*i.zTop;e.attribs=t,e.top.attr({d:i.top,zIndex:i.zTop}),e.inn.attr({d:i.inn,zIndex:i.zInn}),e.out.attr({d:i.out,zIndex:i.zOut}),e.side1.attr({d:i.side1,zIndex:i.zSide1}),e.side2.attr({d:i.side2,zIndex:i.zSide2}),e.zIndex=s,e.attr({zIndex:s}),t.center&&(e.top.setRadialReference(t.center),delete t.center)},e.setPaths(t),e.fillSetter=function(t){var e=h(t).brighten(-.1).get();return this.fill=t,this.side1.attr({fill:e}),this.side2.attr({fill:e}),this.inn.attr({fill:e}),this.out.attr({fill:e}),this.top.attr({fill:t}),this};for(var d=0,x=["opacity","translateX","translateY","visibility"];d<x.length;d++)e[x[d]+"Setter"]=function(t,i){e[i]=t;for(var s=0,r=["out","inn","side1","side2","top"];s<r.length;s++)e[r[s]].attr(i,t)};return e.attr=function(t){var i,r;return"object"==typeof t&&(r=o(t))&&(i=r[0],arguments[0]=r[1],f(e.attribs,i),e.setPaths(e.attribs)),s.attr.apply(e,arguments)},e.animate=function(t,r,a){var h,l,p=this.attribs,c="data-"+Math.random().toString(26).substring(2,9);delete t.center,delete t.z,delete t.alpha,delete t.beta;var d=n(u(r,this.renderer.globalAnimation));return d.duration&&(h=o(t),e[c]=0,t[c]=1,e[c+"Setter"]=i.noop,h&&(l=h[0],d.step=function(t,e){var i=function(t){return p[t]+(u(l[t],p[t])-p[t])*e.pos};e.prop===c&&e.elem.setPaths(y(p,{x:i("x"),y:i("y"),r:i("r"),innerR:i("innerR"),start:i("start"),end:i("end"),depth:i("depth")}))}),r=d),s.animate.call(this,t,r,a)},e.destroy=function(){return this.top.destroy(),this.out.destroy(),this.inn.destroy(),this.side1.destroy(),this.side2.destroy(),s.destroy.call(this)},e.hide=function(){this.top.hide(),this.out.hide(),this.inn.hide(),this.side1.hide(),this.side2.hide()},e.show=function(t){this.top.show(t),this.out.show(t),this.inn.show(t),this.side1.show(t),this.side2.show(t)},e}function S(t){var e=t.x||0,i=t.y||0,s=t.start||0,r=(t.end||0)-1e-5,o=t.r||0,a=t.innerR||0,n=t.depth||0,h=t.alpha||0,l=t.beta||0,p=Math.cos(s),c=Math.sin(s),d=Math.cos(r),x=Math.sin(r),f=o*Math.cos(l),y=o*Math.cos(h),u=a*Math.cos(l),g=a*Math.cos(h),M=n*Math.sin(l),P=n*Math.sin(h),A=[["M",e+f*p,i+y*c]];(A=A.concat(m(e,i,f,y,s,r,0,0))).push(["L",e+u*d,i+g*x]),(A=A.concat(m(e,i,u,g,r,s,0,0))).push(["Z"]);var S=l>0?Math.PI/2:0,C=h>0?0:Math.PI/2,D=s>-S?s:r>-S?-S:s,j=r<b-C?r:s<b-C?b-C:r,k=2*b-C,w=[["M",e+f*v(D),i+y*z(D)]];w=w.concat(m(e,i,f,y,D,j,0,0)),r>k&&s<k?(w.push(["L",e+f*v(j)+M,i+y*z(j)+P]),(w=w.concat(m(e,i,f,y,j,k,M,P))).push(["L",e+f*v(k),i+y*z(k)]),(w=w.concat(m(e,i,f,y,k,r,0,0))).push(["L",e+f*v(r)+M,i+y*z(r)+P]),(w=w.concat(m(e,i,f,y,r,k,M,P))).push(["L",e+f*v(k),i+y*z(k)]),w=w.concat(m(e,i,f,y,k,j,0,0))):r>b-C&&s<b-C&&(w.push(["L",e+f*Math.cos(j)+M,i+y*Math.sin(j)+P]),(w=w.concat(m(e,i,f,y,j,r,M,P))).push(["L",e+f*Math.cos(r),i+y*Math.sin(r)]),w=w.concat(m(e,i,f,y,r,j,0,0))),w.push(["L",e+f*Math.cos(j)+M,i+y*Math.sin(j)+P]),(w=w.concat(m(e,i,f,y,j,D,M,P))).push(["Z"]);var _=[["M",e+u*p,i+g*c]];(_=_.concat(m(e,i,u,g,s,r,0,0))).push(["L",e+u*Math.cos(r)+M,i+g*Math.sin(r)+P]),(_=_.concat(m(e,i,u,g,r,s,M,P))).push(["Z"]);var O=[["M",e+f*p,i+y*c],["L",e+f*p+M,i+y*c+P],["L",e+u*p+M,i+g*c+P],["L",e+u*p,i+g*c],["Z"]],L=[["M",e+f*d,i+y*x],["L",e+f*d+M,i+y*x+P],["L",e+u*d+M,i+g*x+P],["L",e+u*d,i+g*x],["Z"]],I=Math.atan2(P,-M),T=Math.abs(r+I),E=Math.abs(s+I),X=Math.abs((s+r)/2+I);function G(t){return(t%=2*Math.PI)>Math.PI&&(t=2*Math.PI-t),t}T=G(T),E=G(E);var Z=1e5*(X=G(X)),Y=1e5*E,R=1e5*T;return{top:A,zTop:1e5*Math.PI+1,out:w,zOut:Math.max(Z,Y,R),inn:_,zInn:Math.max(Z,Y,R),side1:O,zSide1:.99*R,side2:L,zSide2:.99*Y}}t.compose=function(t){var i=t.prototype;i.element3d||f(i,{Element3D:r,arc3d:A,arc3dPath:S,cuboid:M,cuboidPath:P,element3d:g,face3d:o,polyhedron:a,toLinePath:e,toLineSegments:s})}}(a||(a={})),a}),i(e,"Core/Axis/ZAxis.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Utilities.js"]],function(t,e,i){var s,r=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),o=e.defaultOptions,a=i.addEvent,n=i.merge,h=i.pick,l=i.splat;function p(t){return new d(this,t)}function c(){var t=this,e=this.options.zAxis=l(this.options.zAxis||{});this.is3d()&&(this.zAxis=[],e.forEach(function(e){t.addZAxis(e).setScale()}))}var d=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.isZAxis=!0,e}return r(e,t),e.compose=function(t){var e=t.prototype;e.addZAxis||(o.zAxis=n(o.xAxis,{offset:0,lineWidth:0}),e.addZAxis=p,e.collectionsWithInit.zAxis=[e.addZAxis],e.collectionsWithUpdate.push("zAxis"),a(t,"afterGetAxes",c))},e.prototype.init=function(e,i){this.isZAxis=!0,t.prototype.init.call(this,e,i,"zAxis")},e.prototype.getSeriesExtremes=function(){var t=this;this.hasVisibleSeries=!1,this.dataMin=this.dataMax=this.ignoreMinPadding=this.ignoreMaxPadding=void 0,this.stacking&&this.stacking.buildStacks(),this.series.forEach(function(e){if(e.reserveSpace()){var i=e.options.threshold;t.hasVisibleSeries=!0,t.positiveValuesOnly&&i<=0&&(i=void 0);var s=e.zData;s.length&&(t.dataMin=Math.min(h(t.dataMin,s[0]),Math.min.apply(null,s)),t.dataMax=Math.max(h(t.dataMax,s[0]),Math.max.apply(null,s)))}})},e.prototype.setAxisSize=function(){var e=this.chart;t.prototype.setAxisSize.call(this),this.width=this.len=e.options.chart.options3d&&e.options.chart.options3d.depth||0,this.right=e.chartWidth-this.width-this.left},e}(t);return d}),i(e,"Series/Column3D/Column3DComposition.js",[e["Core/Globals.js"],e["Core/Math3D.js"],e["Core/Utilities.js"]],function(t,e,i){var s=t.composed,r=e.perspective,o=i.addEvent,a=i.extend,n=i.pick,h=i.pushUnique,l=i.wrap;function p(){var t,e=this.chart,i=this.options,s=i.depth,o=(i.stacking?i.stack||0:this.index)*(s+(i.groupZPadding||1)),n=this.borderWidth%2?.5:0;e.inverted&&!this.yAxis.reversed&&(n*=-1),!1!==i.grouping&&(o=0),o+=i.groupZPadding||1;for(var h=0,l=this.points;h<l.length;h++){var p=l[h];if(p.outside3dPlot=null,null!==p.y){for(var c=a({x:0,y:0,width:0,height:0},p.shapeArgs||{}),d=[["x","width"],["y","height"]],x=p.tooltipPos,f=void 0,y=0;y<d.length;y++){var u=d[y];if((f=c[u[0]]-n)<0&&(c[u[1]]+=c[u[0]]+n,c[u[0]]=-n,f=0),f+c[u[1]]>this[u[0]+"Axis"].len&&0!==c[u[1]]&&(c[u[1]]=this[u[0]+"Axis"].len-c[u[0]]),0!==c[u[1]]&&(c[u[0]]>=this[u[0]+"Axis"].len||c[u[0]]+c[u[1]]<=n)){for(var v in c)c[v]="y"===v?-9999:0;p.outside3dPlot=!0}}if("roundedRect"===p.shapeType&&(p.shapeType="cuboid"),p.shapeArgs=a(c,{z:o,depth:s,insidePlotArea:!0}),t={x:c.x+c.width/2,y:c.y,z:o+s/2},e.inverted&&(t.x=c.height,t.y=p.clientX||0),p.axisXpos=t.x,p.axisYpos=t.y,p.axisZpos=t.z,p.plot3d=r([t],e,!0,!1)[0],x){var z=r([{x:x[0],y:x[1],z:o+s/2}],e,!0,!1)[0];p.tooltipPos=[z.x,z.y]}}}this.z=o}function c(){if(this.chart.is3d()){var t=this.options,e=t.grouping,i=t.stacking,s=this.yAxis.options.reversedStacks,r=0;if(!(void 0!==e&&!e)){var o,a,h,l,p=(o=this.chart.series,a={totalStacks:0},l=1,o.forEach(function(t){a[h=n(t.options.stack,i?0:o.length-1-t.index)]?a[h].series.push(t):(a[h]={series:[t],position:l},l++)}),a.totalStacks=l+1,a),c=t.stack||0,d=void 0;for(d=0;d<p[c].series.length&&p[c].series[d]!==this;d++);r=10*(p.totalStacks-p[c].position)+(s?d:-d),this.xAxis.reversed||(r=10*p.totalStacks-r)}t.depth=t.depth||25,this.z=this.z||0,t.zIndex=r}}function d(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];return this.series.chart.is3d()?this.graphic&&"g"!==this.graphic.element.nodeName:t.apply(this,e)}function x(t){if(this.chart.is3d()){var e=arguments,i=e[1],s=this.yAxis,r=this.yAxis.reversed;if(i)for(var o=0,a=this.points;o<a.length;o++){var n=a[o];null===n.y||(n.height=n.shapeArgs.height,n.shapey=n.shapeArgs.y,n.shapeArgs.height=1,r||(n.stackY?n.shapeArgs.y=n.plotY+s.translate(n.stackY):n.shapeArgs.y=n.plotY+(n.negative?-n.height:n.height)))}else{for(var h=0,l=this.points;h<l.length;h++){var n=l[h];null!==n.y&&(n.shapeArgs.height=n.height,n.shapeArgs.y=n.shapey,n.graphic&&n.graphic[n.outside3dPlot?"attr":"animate"](n.shapeArgs,this.options.animation))}this.drawDataLabels()}}else t.apply(this,[].slice.call(arguments,1))}function f(t,e,i,s,r,o){return"dataLabelsGroup"!==e&&"markerGroup"!==e&&this.chart.is3d()&&(this[e]&&delete this[e],o&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(o)),this[e]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[e].survive=!0,"group"===e&&(arguments[3]="visible"))),t.apply(this,Array.prototype.slice.call(arguments,1))}function y(t){var e=t.apply(this,[].slice.call(arguments,1));return this.chart.is3d&&this.chart.is3d()&&(e.stroke=this.options.edgeColor||e.fill,e["stroke-width"]=n(this.options.edgeWidth,1)),e}function u(t,e,i){var s=this.chart.is3d&&this.chart.is3d();s&&(this.options.inactiveOtherPoints=!0),t.call(this,e,i),s&&(this.options.inactiveOtherPoints=!1)}function v(t,e){if(this.chart.is3d())for(var i=0,s=this.points;i<s.length;i++){var r=s[i];r.visible=r.options.visible=e=void 0===e?!n(this.visible,r.visible):e,this.options.data[this.data.indexOf(r)]=r.options,r.graphic&&r.graphic.attr({visibility:e?"visible":"hidden"})}t.apply(this,Array.prototype.slice.call(arguments,1))}function z(t){t.apply(this,[].slice.call(arguments,1)),this.chart.is3d()&&this.translate3dShapes()}function b(t,e,i,s,o){var a=this.chart;if(s.outside3dPlot=e.outside3dPlot,a.is3d()&&this.is("column")){var h=this.options,l=n(s.inside,!!this.options.stacking),p=a.options.chart.options3d,c=e.pointWidth/2||0,d={x:o.x+c,y:o.y,z:this.z+h.depth/2};a.inverted&&(l&&(o.width=0,d.x+=e.shapeArgs.height/2),p.alpha>=90&&p.alpha<=270&&(d.y+=e.shapeArgs.width)),d=r([d],a,!0,!1)[0],o.x=d.x-c,o.y=e.outside3dPlot?-9e9:d.y}t.apply(this,[].slice.call(arguments,1))}function g(t){return!arguments[2].outside3dPlot&&t.apply(this,[].slice.call(arguments,1))}function m(t,e){var i=t.apply(this,[].slice.call(arguments,1)),s=this.axis.chart,o=e.width;if(s.is3d()&&this.base){var a=+this.base.split(",")[0],n=s.series[a],h=s.options.chart.options3d;if(n&&"column"===n.type){var l={x:i.x+(s.inverted?i.height:o/2),y:i.y,z:n.options.depth/2};s.inverted&&(i.width=0,h.alpha>=90&&h.alpha<=270&&(l.y+=o)),l=r([l],s,!0,!1)[0],i.x=l.x-o/2,i.y=l.y}}return i}return{compose:function(t,e){if(h(s,"Column3D")){var i=t.prototype,r=e.prototype,a=t.types,n=a.column,M=a.columnRange;if(l(i,"alignDataLabel",b),l(i,"justifyDataLabel",g),l(r,"getStackBox",m),n){var P=n.prototype,A=P.pointClass.prototype;P.translate3dPoints=function(){},P.translate3dShapes=p,o(P,"afterInit",c),l(A,"hasNewShapeType",d),l(P,"animate",x),l(P,"plotGroup",f),l(P,"pointAttribs",y),l(P,"setState",u),l(P,"setVisible",v),l(P,"translate",z)}if(M){var S=M.prototype;l(S.pointClass.prototype,"hasNewShapeType",d),l(S,"plotGroup",f),l(S,"pointAttribs",y),l(S,"setState",u),l(S,"setVisible",v)}}}}}),i(e,"Series/Pie3D/Pie3DPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){var e,i=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function s(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(s.prototype=i.prototype,new s)});return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i(e,t),e.prototype.haloPath=function(){var e;return(null===(e=this.series)||void 0===e?void 0:e.chart.is3d())?[]:t.prototype.haloPath.apply(this,arguments)},e}(t.seriesTypes.pie.prototype.pointClass)}),i(e,"Series/Pie3D/Pie3DSeries.js",[e["Core/Globals.js"],e["Series/Pie3D/Pie3DPoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){var r,o=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=t.composed,n=t.deg2rad,h=i.seriesTypes.pie,l=s.extend,p=s.pick,c=s.pushUnique,d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.compose=function(t){c(a,"Pie3D")&&(t.types.pie=e)},e.prototype.addPoint=function(){t.prototype.addPoint.apply(this,arguments),this.chart.is3d()&&this.update(this.userOptions,!0)},e.prototype.animate=function(e){if(this.chart.is3d()){var i=this.center,s=this.group,r=this.markerGroup,o=this.options.animation,a=void 0;!0===o&&(o={}),e?(s.oldtranslateX=p(s.oldtranslateX,s.translateX),s.oldtranslateY=p(s.oldtranslateY,s.translateY),a={translateX:i[0],translateY:i[1],scaleX:.001,scaleY:.001},s.attr(a),r&&(r.attrSetters=s.attrSetters,r.attr(a))):(a={translateX:s.oldtranslateX,translateY:s.oldtranslateY,scaleX:1,scaleY:1},s.animate(a,o),r&&r.animate(a,o))}else t.prototype.animate.apply(this,arguments)},e.prototype.getDataLabelPosition=function(e,i){var s=t.prototype.getDataLabelPosition.call(this,e,i);if(this.chart.is3d())for(var r=this.chart.options.chart.options3d,o=e.shapeArgs,a=o.r,h=(o.alpha||(null==r?void 0:r.alpha))*n,l=(o.beta||(null==r?void 0:r.beta))*n,p=(o.start+o.end)/2,c=s.connectorPosition,d=-a*(1-Math.cos(h))*Math.sin(p),x=a*(Math.cos(l)-1)*Math.cos(p),f=0,y=[null==s?void 0:s.natural,c.breakAt,c.touchingSliceAt];f<y.length;f++){var u=y[f];u.x+=x,u.y+=d}return s},e.prototype.pointAttribs=function(e){var i=t.prototype.pointAttribs.apply(this,arguments),s=this.options;return this.chart.is3d()&&!this.chart.styledMode&&(i.stroke=s.edgeColor||e.color||this.color,i["stroke-width"]=p(s.edgeWidth,1)),i},e.prototype.translate=function(){if(t.prototype.translate.apply(this,arguments),this.chart.is3d()){var e=this.options,i=e.depth||0,s=this.chart.options.chart.options3d,r=s.alpha,o=s.beta,a=e.stacking?(e.stack||0)*i:this._i*i;a+=i/2,!1!==e.grouping&&(a=0);for(var h=0,l=this.points;h<l.length;h++){var p=l[h],c=p.shapeArgs;p.shapeType="arc3d",c.z=a,c.depth=.75*i,c.alpha=r,c.beta=o,c.center=this.center;var d=(c.end+c.start)/2;p.slicedTranslation={translateX:Math.round(Math.cos(d)*e.slicedOffset*Math.cos(r*n)),translateY:Math.round(Math.sin(d)*e.slicedOffset*Math.cos(r*n))}}}},e.prototype.drawTracker=function(){if(t.prototype.drawTracker.apply(this,arguments),this.chart.is3d())for(var e=0,i=this.points;e<i.length;e++){var s=i[e];if(s.graphic)for(var r=0,o=["out","inn","side1","side2"];r<o.length;r++){var a=o[r];s.graphic&&(s.graphic[a].element.point=s)}}},e}(h);return l(d.prototype,{pointClass:e}),d}),i(e,"Series/Scatter3D/Scatter3DPoint.js",[e["Series/Scatter/ScatterSeries.js"],e["Core/Utilities.js"]],function(t,e){var i,s=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function s(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(s.prototype=e.prototype,new s)}),r=t.prototype.pointClass,o=e.defined;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.applyOptions=function(){return t.prototype.applyOptions.apply(this,arguments),o(this.z)||(this.z=0),this},e}(r)}),i(e,"Series/Scatter3D/Scatter3DSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}}}),i(e,"Series/Scatter3D/Scatter3DSeries.js",[e["Core/Math3D.js"],e["Series/Scatter3D/Scatter3DPoint.js"],e["Series/Scatter3D/Scatter3DSeriesDefaults.js"],e["Series/Scatter/ScatterSeries.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,r,o){var a,n=this&&this.__extends||(a=function(t,e){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),h=t.pointCameraDistance,l=o.extend,p=o.merge,c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.pointAttribs=function(e){var i=t.prototype.pointAttribs.apply(this,arguments);return this.chart.is3d()&&e&&(i.zIndex=h(e,this.chart)),i},e.defaultOptions=p(s.defaultOptions,i),e}(s);return l(c.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:e}),r.registerSeriesType("scatter3d",c),c}),i(e,"masters/highcharts-3d.src.js",[e["Core/Globals.js"],e["Core/Chart/Chart3D.js"],e["Series/Area3D/Area3DSeries.js"],e["Core/Axis/Axis3DComposition.js"],e["Core/Renderer/RendererRegistry.js"],e["Core/Series/Series3D.js"],e["Core/Axis/Stacking/StackItem.js"],e["Core/Renderer/SVG/SVGRenderer3D.js"],e["Core/Axis/ZAxis.js"],e["Series/Column3D/Column3DComposition.js"],e["Series/Pie3D/Pie3DSeries.js"]],function(t,e,i,s,r,o,a,n,h,l,p){return i.compose(t.seriesTypes.area),s.compose(t.Axis,t.Tick),e.compose(t.Chart,t.Fx),l.compose(t.Series,a),p.compose(t.Series),o.compose(t.Series),n.compose(r.getRendererType()),h.compose(t.Chart),t})});