/**
 * EasyUI for jQuery 1.10.19
 * 
 * Copyright (c) 2009-2024 www.jeasyui.com. All rights reserved.
 *
 * Licensed under the freeware license: http://www.jeasyui.com/license_freeware.php
 * To use it on other terms please contact us: info@jeasyui.com
 *
 */
(function($){
var _1=0;
function _2(a,o){
return $.easyui.indexOfArray(a,o);
};
function _3(a,o,id){
$.easyui.removeArrayItem(a,o,id);
};
function _4(a,o,r){
$.easyui.addArrayItem(a,o,r);
};
function _5(_6,aa){
return $.data(_6,"treegrid")?aa.slice(1):aa;
};
function _7(_8){
var _9=$.data(_8,"datagrid");
var _a=_9.options;
var _b=_9.panel;
var dc=_9.dc;
var ss=null;
if(_a.sharedStyleSheet){
ss=typeof _a.sharedStyleSheet=="boolean"?"head":_a.sharedStyleSheet;
}else{
ss=_b.closest("div.datagrid-view");
if(!ss.length){
ss=dc.view;
}
}
var cc=$(ss);
var _c=$.data(cc[0],"ss");
if(!_c){
_c=$.data(cc[0],"ss",{cache:{},dirty:[]});
}
return {add:function(_d){
var ss=["<style type=\"text/css\" easyui=\"true\">"];
for(var i=0;i<_d.length;i++){
_c.cache[_d[i][0]]={width:_d[i][1]};
}
var _e=0;
for(var s in _c.cache){
var _f=_c.cache[s];
_f.index=_e++;
ss.push(s+"{width:"+_f.width+"}");
}
ss.push("</style>");
$(ss.join("\n")).appendTo(cc);
cc.children("style[easyui]:not(:last)").remove();
},getRule:function(_10){
var _11=cc.children("style[easyui]:last")[0];
var _12=_11.styleSheet?_11.styleSheet:(_11.sheet||document.styleSheets[document.styleSheets.length-1]);
var _13=_12.cssRules||_12.rules;
return _13[_10];
},set:function(_14,_15){
var _16=_c.cache[_14];
if(_16){
_16.width=_15;
var _17=this.getRule(_16.index);
if(_17){
_17.style["width"]=_15;
}
}
},remove:function(_18){
var tmp=[];
for(var s in _c.cache){
if(s.indexOf(_18)==-1){
tmp.push([s,_c.cache[s].width]);
}
}
_c.cache={};
this.add(tmp);
},dirty:function(_19){
if(_19){
_c.dirty.push(_19);
}
},clean:function(){
for(var i=0;i<_c.dirty.length;i++){
this.remove(_c.dirty[i]);
}
_c.dirty=[];
}};
};
function _1a(_1b,_1c){
var _1d=$.data(_1b,"datagrid");
var _1e=_1d.options;
var _1f=_1d.panel;
if(_1c){
$.extend(_1e,_1c);
}
if(_1e.fit==true){
var p=_1f.panel("panel").parent();
_1e.width=p.width();
_1e.height=p.height();
}
_1f.panel("resize",_1e);
};
function _20(_21){
var _22=$.data(_21,"datagrid");
var _23=_22.options;
var dc=_22.dc;
var _24=_22.panel;
if(!_24.is(":visible")){
return;
}
var _25=_24.width();
var _26=_24.height();
var _27=dc.view;
var _28=dc.view1;
var _29=dc.view2;
var _2a=_28.children("div.datagrid-header");
var _2b=_29.children("div.datagrid-header");
var _2c=_2a.find("table");
var _2d=_2b.find("table");
_27.width(_25);
var _2e=_2a.children("div.datagrid-header-inner").show();
_28.width(_2e.find("table").width());
if(!_23.showHeader){
_2e.hide();
}
_29.width(_25-_28._outerWidth());
_28.children()._outerWidth(_28.width());
_29.children()._outerWidth(_29.width());
var all=_2a.add(_2b).add(_2c).add(_2d);
all.css("height","");
var hh=Math.max(_2c.height(),_2d.height());
all._outerHeight(hh);
_27.children(".datagrid-empty").css("top",hh+"px");
dc.body1.add(dc.body2).children("table.datagrid-btable-frozen").css({position:"absolute",top:dc.header2._outerHeight()});
var _2f=dc.body2.children("table.datagrid-btable-frozen")._outerHeight();
var _30=_2f+_2b._outerHeight()+_29.children(".datagrid-footer")._outerHeight();
_24.children(":not(.datagrid-view,.datagrid-mask,.datagrid-mask-msg)").each(function(){
_30+=$(this)._outerHeight();
});
var _31=_24.outerHeight()-_24.height();
var _32=_24._size("minHeight")||"";
var _33=_24._size("maxHeight")||"";
_28.add(_29).children("div.datagrid-body").css({marginTop:_2f,height:(isNaN(parseInt(_23.height))?"":(_26-_30)),minHeight:(_32?_32-_31-_30:""),maxHeight:(_33?_33-_31-_30:"")});
_27.height(_29.height());
};
function _34(_35,_36,_37){
var _38=$.data(_35,"datagrid").data.rows;
var _39=$.data(_35,"datagrid").options;
var dc=$.data(_35,"datagrid").dc;
var tmp=$("<tr class=\"datagrid-row\" style=\"position:absolute;left:-999999px\"></tr>").appendTo("body");
var _3a=tmp.outerHeight();
tmp.remove();
if(!dc.body1.is(":empty")&&(!_39.nowrap||_39.autoRowHeight||_37)){
if(_36!=undefined){
var tr1=_39.finder.getTr(_35,_36,"body",1);
var tr2=_39.finder.getTr(_35,_36,"body",2);
_3b(tr1,tr2);
}else{
var tr1=_39.finder.getTr(_35,0,"allbody",1);
var tr2=_39.finder.getTr(_35,0,"allbody",2);
_3b(tr1,tr2);
if(_39.showFooter){
var tr1=_39.finder.getTr(_35,0,"allfooter",1);
var tr2=_39.finder.getTr(_35,0,"allfooter",2);
_3b(tr1,tr2);
}
}
}
_20(_35);
if(_39.height=="auto"){
var _3c=dc.body1.parent();
var _3d=dc.body2;
var _3e=_3f(_3d);
var _40=_3e.height;
if(_3e.width>_3d.width()){
_40+=18;
}
_40-=parseInt(_3d.css("marginTop"))||0;
_3c.height(_40);
_3d.height(_40);
dc.view.height(dc.view2.height());
}
dc.body2.triggerHandler("scroll");
function _3b(_41,_42){
for(var i=0;i<_42.length;i++){
var tr1=$(_41[i]);
var tr2=$(_42[i]);
tr1.css("height","");
tr2.css("height","");
var _43=Math.max(tr1.outerHeight(),tr2.outerHeight());
if(_43!=_3a){
_43=Math.max(_43,_3a)+1;
tr1.css("height",_43);
tr2.css("height",_43);
}
}
};
function _3f(cc){
var _44=0;
var _45=0;
$(cc).children().each(function(){
var c=$(this);
if(c.is(":visible")){
_45+=c._outerHeight();
if(_44<c._outerWidth()){
_44=c._outerWidth();
}
}
});
return {width:_44,height:_45};
};
};
function _46(_47,_48){
var _49=$.data(_47,"datagrid");
var _4a=_49.options;
var dc=_49.dc;
if(!dc.body2.children("table.datagrid-btable-frozen").length){
dc.body1.add(dc.body2).prepend("<table class=\"datagrid-btable datagrid-btable-frozen\" cellspacing=\"0\" cellpadding=\"0\"></table>");
}
_4b(true);
_4b(false);
_20(_47);
function _4b(_4c){
var _4d=_4c?1:2;
var tr=_4a.finder.getTr(_47,_48,"body",_4d);
(_4c?dc.body1:dc.body2).children("table.datagrid-btable-frozen").append(tr);
};
};
function _4e(_4f,_50){
function _51(){
var _52=[];
var _53=[];
$(_4f).children("thead").each(function(){
var opt=$.parser.parseOptions(this,[{frozen:"boolean"}]);
$(this).find("tr").each(function(){
var _54=[];
$(this).find("th").each(function(){
var th=$(this);
var col=$.extend({},$.parser.parseOptions(this,["id","field","align","halign","order","width",{sortable:"boolean",checkbox:"boolean",resizable:"boolean",fixed:"boolean"},{rowspan:"number",colspan:"number"}]),{title:(th.html()||undefined),hidden:(th.attr("hidden")?true:undefined),hformatter:(th.attr("hformatter")?eval(th.attr("hformatter")):undefined),hstyler:(th.attr("hstyler")?eval(th.attr("hstyler")):undefined),formatter:(th.attr("formatter")?eval(th.attr("formatter")):undefined),styler:(th.attr("styler")?eval(th.attr("styler")):undefined),sorter:(th.attr("sorter")?eval(th.attr("sorter")):undefined)});
if(col.width&&String(col.width).indexOf("%")==-1){
col.width=parseInt(col.width);
}
if(th.attr("editor")){
var s=$.trim(th.attr("editor"));
if(s.substr(0,1)=="{"){
col.editor=eval("("+s+")");
}else{
col.editor=s;
}
}
_54.push(col);
});
opt.frozen?_52.push(_54):_53.push(_54);
});
});
return [_52,_53];
};
var _55=$("<div class=\"datagrid-wrap\">"+"<div class=\"datagrid-view\">"+"<div class=\"datagrid-view1\">"+"<div class=\"datagrid-header\">"+"<div class=\"datagrid-header-inner\"></div>"+"</div>"+"<div class=\"datagrid-body\">"+"<div class=\"datagrid-body-inner\"></div>"+"</div>"+"<div class=\"datagrid-footer\">"+"<div class=\"datagrid-footer-inner\"></div>"+"</div>"+"</div>"+"<div class=\"datagrid-view2\">"+"<div class=\"datagrid-header\">"+"<div class=\"datagrid-header-inner\"></div>"+"</div>"+"<div class=\"datagrid-body\"></div>"+"<div class=\"datagrid-footer\">"+"<div class=\"datagrid-footer-inner\"></div>"+"</div>"+"</div>"+"</div>"+"</div>").insertAfter(_4f);
_55.panel({doSize:false,cls:"datagrid"});
$(_4f).addClass("datagrid-f").hide().appendTo(_55.children("div.datagrid-view"));
var cc=_51();
var _56=_55.children("div.datagrid-view");
var _57=_56.children("div.datagrid-view1");
var _58=_56.children("div.datagrid-view2");
return {panel:_55,frozenColumns:cc[0],columns:cc[1],dc:{view:_56,view1:_57,view2:_58,header1:_57.children("div.datagrid-header").children("div.datagrid-header-inner"),header2:_58.children("div.datagrid-header").children("div.datagrid-header-inner"),body1:_57.children("div.datagrid-body").children("div.datagrid-body-inner"),body2:_58.children("div.datagrid-body"),footer1:_57.children("div.datagrid-footer").children("div.datagrid-footer-inner"),footer2:_58.children("div.datagrid-footer").children("div.datagrid-footer-inner")}};
};
function _59(_5a){
var _5b=$.data(_5a,"datagrid");
var _5c=_5b.options;
var dc=_5b.dc;
var _5d=_5b.panel;
_5b.ss=$(_5a).datagrid("createStyleSheet");
_5d.panel($.extend({},_5c,{id:null,doSize:false,onResize:function(_5e,_5f){
if($.data(_5a,"datagrid")){
_20(_5a);
$(_5a).datagrid("fitColumns");
_5c.onResize.call(_5d,_5e,_5f);
}
},onExpand:function(){
if($.data(_5a,"datagrid")){
$(_5a).datagrid("fixRowHeight").datagrid("fitColumns");
_5c.onExpand.call(_5d);
}
}}));
var _60=$(_5a).attr("id")||"";
if(_60){
_60+="_";
}
_5b.rowIdPrefix=_60+"datagrid-row-r"+(++_1);
_5b.cellClassPrefix=_60+"datagrid-cell-c"+_1;
_61(dc.header1,_5c.frozenColumns,true);
_61(dc.header2,_5c.columns,false);
_62();
dc.header1.add(dc.header2).css("display",_5c.showHeader?"block":"none");
dc.footer1.add(dc.footer2).css("display",_5c.showFooter?"block":"none");
if(_5c.toolbar){
if($.isArray(_5c.toolbar)){
$("div.datagrid-toolbar",_5d).remove();
var tb=$("<div class=\"datagrid-toolbar\"><table cellspacing=\"0\" cellpadding=\"0\"><tr></tr></table></div>").prependTo(_5d);
var tr=tb.find("tr");
for(var i=0;i<_5c.toolbar.length;i++){
var btn=_5c.toolbar[i];
if(btn=="-"){
$("<td><div class=\"datagrid-btn-separator\"></div></td>").appendTo(tr);
}else{
var td=$("<td></td>").appendTo(tr);
btn.type=btn.type||"linkbutton";
btn.plain=btn.plain||true;
var _63=$("<a href=\"javascript:;\"></a>").appendTo(td);
_63[0].onclick=eval(btn.handler||function(){
});
_63[btn.type](btn);
if(btn.onInit){
btn.onInit.call(_63[0]);
}
}
}
}else{
$(_5c.toolbar).addClass("datagrid-toolbar").prependTo(_5d);
$(_5c.toolbar).show();
}
}else{
$("div.datagrid-toolbar",_5d).remove();
}
$("div.datagrid-pager",_5d).remove();
if(_5c.pagination){
var _64=$("<div class=\"datagrid-pager\"></div>");
if(_5c.pagePosition=="bottom"){
_64.appendTo(_5d);
}else{
if(_5c.pagePosition=="top"){
_64.addClass("datagrid-pager-top").prependTo(_5d);
}else{
var _65=$("<div class=\"datagrid-pager datagrid-pager-top\"></div>").prependTo(_5d);
_64.appendTo(_5d);
_64=_64.add(_65);
}
}
_64.pagination({total:0,pageNumber:_5c.pageNumber,pageSize:_5c.pageSize,pageList:_5c.pageList,onSelectPage:function(_66,_67){
_5c.pageNumber=_66||1;
_5c.pageSize=_67;
_64.pagination("refresh",{pageNumber:_66,pageSize:_67});
_c3(_5a);
}});
_5c.pageSize=_64.pagination("options").pageSize;
}
function _61(_68,_69,_6a){
if(!_69){
return;
}
$(_68).show();
$(_68).empty();
var tmp=$("<div class=\"datagrid-cell\" style=\"position:absolute;left:-99999px\"></div>").appendTo("body");
tmp._outerWidth(99);
var _6b=100-parseInt(tmp[0].style.width);
tmp.remove();
var _6c=[];
var _6d=[];
var _6e=[];
if(_5c.sortName){
_6c=_5c.sortName.split(",");
_6d=_5c.sortOrder.split(",");
}
var t=$("<table class=\"datagrid-htable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody></tbody></table>").appendTo(_68);
for(var i=0;i<_69.length;i++){
var tr=$("<tr class=\"datagrid-header-row\"></tr>").appendTo($("tbody",t));
var _6f=_69[i];
for(var j=0;j<_6f.length;j++){
var col=_6f[j];
var _70="";
if(col.rowspan){
_70+="rowspan=\""+col.rowspan+"\" ";
}
if(col.colspan){
_70+="colspan=\""+col.colspan+"\" ";
if(!col.id){
col.id=["datagrid-td-group"+_1,i,j].join("-");
}
}
if(col.id){
_70+="id=\""+col.id+"\"";
}
var css=col.hstyler?col.hstyler(col.title,col):"";
if(typeof css=="string"){
var _71=css;
var _72="";
}else{
css=css||{};
var _71=css["style"]||"";
var _72=css["class"]||"";
}
var td=$("<td "+_70+" class=\""+_72+"\" style=\""+_71+"\""+"></td>").appendTo(tr);
if(col.checkbox){
td.attr("field",col.field);
$("<div class=\"datagrid-header-check\"></div>").html("<input type=\"checkbox\">").appendTo(td);
}else{
if(col.field){
td.attr("field",col.field);
td.append("<div class=\"datagrid-cell\"><span></span><span class=\"datagrid-sort-icon\"></span></div>");
td.find("span:first").html(col.hformatter?col.hformatter(col.title,col):col.title);
var _73=td.find("div.datagrid-cell");
var pos=_2(_6c,col.field);
if(pos>=0){
_73.addClass("datagrid-sort-"+_6d[pos]);
}
if(col.sortable){
_73.addClass("datagrid-sort");
}
if(col.resizable==false){
_73.attr("resizable","false");
}
if(col.width){
var _74=$.parser.parseValue("width",col.width,dc.view,_5c.scrollbarSize+(_5c.rownumbers?_5c.rownumberWidth:0));
col.deltaWidth=_6b;
col.boxWidth=_74-_6b;
}else{
col.auto=true;
}
_73.css("text-align",(col.halign||col.align||""));
col.cellClass=_5b.cellClassPrefix+"-"+col.field.replace(/[\.|\s]/g,"-");
_73.addClass(col.cellClass);
}else{
$("<div class=\"datagrid-cell-group\"></div>").html(col.hformatter?col.hformatter(col.title,col):col.title).appendTo(td);
}
}
if(col.hidden){
td.hide();
_6e.push(col.field);
}
}
}
if(_6a&&_5c.rownumbers){
var td=$("<td rowspan=\""+_5c.frozenColumns.length+"\"><div class=\"datagrid-header-rownumber\"></div></td>");
if($("tr",t).length==0){
td.wrap("<tr class=\"datagrid-header-row\"></tr>").parent().appendTo($("tbody",t));
}else{
td.prependTo($("tr:first",t));
}
}
for(var i=0;i<_6e.length;i++){
_c5(_5a,_6e[i],-1);
}
};
function _62(){
var _75=[[".datagrid-header-rownumber",(_5c.rownumberWidth-1)+"px"],[".datagrid-cell-rownumber",(_5c.rownumberWidth-1)+"px"]];
var _76=_77(_5a,true).concat(_77(_5a));
for(var i=0;i<_76.length;i++){
var col=_78(_5a,_76[i]);
if(col&&!col.checkbox){
_75.push(["."+col.cellClass,col.boxWidth?col.boxWidth+"px":"auto"]);
}
}
_5b.ss.add(_75);
_5b.ss.dirty(_5b.cellSelectorPrefix);
_5b.cellSelectorPrefix="."+_5b.cellClassPrefix;
};
};
function _79(_7a){
var _7b=$.data(_7a,"datagrid");
var _7c=_7b.panel;
var _7d=_7b.options;
var dc=_7b.dc;
var _7e=dc.header1.add(dc.header2);
_7e._unbind(".datagrid");
for(var _7f in _7d.headerEvents){
_7e._bind(_7f+".datagrid",_7d.headerEvents[_7f]);
}
var _80=_7e.find("div.datagrid-cell");
var _81=_7d.resizeHandle=="right"?"e":(_7d.resizeHandle=="left"?"w":"e,w");
_80.each(function(){
$(this).resizable({handles:_81,edge:_7d.resizeEdge,disabled:($(this).attr("resizable")?$(this).attr("resizable")=="false":false),minWidth:25,onStartResize:function(e){
_7b.resizing=true;
_7e.css("cursor",$("body").css("cursor"));
if(!_7b.proxy){
_7b.proxy=$("<div class=\"datagrid-resize-proxy\"></div>").appendTo(dc.view);
}
if(e.data.dir=="e"){
e.data.deltaEdge=$(this)._outerWidth()-(e.pageX-$(this).offset().left);
}else{
e.data.deltaEdge=$(this).offset().left-e.pageX-1;
}
_7b.proxy.css({left:e.pageX-$(_7c).offset().left-1+e.data.deltaEdge,display:"none"});
setTimeout(function(){
if(_7b.proxy){
_7b.proxy.show();
}
},500);
},onResize:function(e){
_7b.proxy.css({left:e.pageX-$(_7c).offset().left-1+e.data.deltaEdge,display:"block"});
return false;
},onStopResize:function(e){
_7e.css("cursor","");
$(this).css("height","");
var _82=$(this).parent().attr("field");
var col=_78(_7a,_82);
col.width=$(this)._outerWidth()+1;
col.boxWidth=col.width-col.deltaWidth;
col.auto=undefined;
$(this).css("width","");
$(_7a).datagrid("fixColumnSize",_82);
_7b.proxy.remove();
_7b.proxy=null;
if($(this).parents("div:first.datagrid-header").parent().hasClass("datagrid-view1")){
_20(_7a);
}
$(_7a).datagrid("fitColumns");
_7d.onResizeColumn.call(_7a,_82,col.width);
setTimeout(function(){
_7b.resizing=false;
},0);
}});
});
var bb=dc.body1.add(dc.body2);
bb._unbind();
for(var _7f in _7d.rowEvents){
bb._bind(_7f,_7d.rowEvents[_7f]);
}
dc.body1._bind("mousewheel DOMMouseScroll MozMousePixelScroll",function(e){
e.preventDefault();
var e1=e.originalEvent||window.event;
var _83=e1.wheelDelta||e1.detail*(-1);
if("deltaY" in e1){
_83=e1.deltaY*-1;
}
var dg=$(e.target).closest("div.datagrid-view").children(".datagrid-f");
var dc=dg.data("datagrid").dc;
dc.body2.scrollTop(dc.body2.scrollTop()-_83);
});
dc.body2._bind("scroll",function(){
var b1=dc.view1.children("div.datagrid-body");
var stv=$(this).scrollTop();
$(this).scrollTop(stv);
b1.scrollTop(stv);
var c1=dc.body1.children(":first");
var c2=dc.body2.children(":first");
if(c1.length&&c2.length){
var _84=c1.offset().top;
var _85=c2.offset().top;
if(_84!=_85){
b1.scrollTop(b1.scrollTop()+_84-_85);
}
}
dc.view2.children("div.datagrid-header,div.datagrid-footer")._scrollLeft($(this)._scrollLeft());
dc.body2.children("table.datagrid-btable-frozen").css("left",-$(this)._scrollLeft());
});
};
function _86(_87){
return function(e){
var td=$(e.target).closest("td[field]");
if(td.length){
var _88=_89(td);
if(!$(_88).data("datagrid").resizing&&_87){
td.addClass("datagrid-header-over");
}else{
td.removeClass("datagrid-header-over");
}
}
};
};
function _8a(e){
var _8b=_89(e.target);
var _8c=$(_8b).datagrid("options");
var ck=$(e.target).closest("input[type=checkbox]");
if(ck.length){
if(_8c.singleSelect&&_8c.selectOnCheck){
return false;
}
if(ck.is(":checked")){
_8d(_8b);
}else{
_8e(_8b);
}
e.stopPropagation();
}else{
var _8f=$(e.target).closest(".datagrid-cell");
if(_8f.length){
var p1=_8f.offset().left+5;
var p2=_8f.offset().left+_8f._outerWidth()-5;
if(e.pageX<p2&&e.pageX>p1){
_90(_8b,_8f.parent().attr("field"));
}
}
}
};
function _91(e){
var _92=_89(e.target);
var _93=$(_92).datagrid("options");
var _94=$(e.target).closest(".datagrid-cell");
if(_94.length){
var p1=_94.offset().left+5;
var p2=_94.offset().left+_94._outerWidth()-5;
var _95=_93.resizeHandle=="right"?(e.pageX>p2):(_93.resizeHandle=="left"?(e.pageX<p1):(e.pageX<p1||e.pageX>p2));
if(_95){
var _96=_94.parent().attr("field");
var col=_78(_92,_96);
if(col.resizable==false){
return;
}
$(_92).datagrid("autoSizeColumn",_96);
col.auto=false;
}
}
};
function _97(e){
var _98=_89(e.target);
var _99=$(_98).datagrid("options");
var td=$(e.target).closest("td[field]");
_99.onHeaderContextMenu.call(_98,e,td.attr("field"));
};
function _9a(_9b){
return function(e){
var tr=_9c(e.target);
if(!tr){
return;
}
var _9d=_89(tr);
if($.data(_9d,"datagrid").resizing){
return;
}
var _9e=_9f(tr);
if(_9b){
_a0(_9d,_9e);
}else{
var _a1=$.data(_9d,"datagrid").options;
_a1.finder.getTr(_9d,_9e).removeClass("datagrid-row-over");
}
};
};
function _a2(e){
var tr=_9c(e.target);
if(!tr){
return;
}
var _a3=_89(tr);
var _a4=$.data(_a3,"datagrid").options;
var _a5=_9f(tr);
var tt=$(e.target);
if(tt.parent().hasClass("datagrid-cell-check")){
if(_a4.singleSelect&&_a4.selectOnCheck){
tt._propAttr("checked",!tt.is(":checked"));
_a6(_a3,_a5);
}else{
if(tt.is(":checked")){
tt._propAttr("checked",false);
_a6(_a3,_a5);
}else{
tt._propAttr("checked",true);
_a7(_a3,_a5);
}
}
}else{
var row=_a4.finder.getRow(_a3,_a5);
var td=tt.closest("td[field]",tr);
if(td.length){
var _a8=td.attr("field");
_a4.onClickCell.call(_a3,_a5,_a8,row[_a8]);
}
if(_a4.singleSelect==true){
_a9(_a3,_a5);
}else{
if(_a4.ctrlSelect){
if(e.metaKey||e.ctrlKey){
if(tr.hasClass("datagrid-row-selected")){
_aa(_a3,_a5);
}else{
_a9(_a3,_a5);
}
}else{
if(e.shiftKey){
$(_a3).datagrid("clearSelections");
var _ab=Math.min(_a4.lastSelectedIndex||0,_a5);
var _ac=Math.max(_a4.lastSelectedIndex||0,_a5);
for(var i=_ab;i<=_ac;i++){
_a9(_a3,i);
}
}else{
$(_a3).datagrid("clearSelections");
_a9(_a3,_a5);
_a4.lastSelectedIndex=_a5;
}
}
}else{
if(tr.hasClass("datagrid-row-selected")){
_aa(_a3,_a5);
}else{
_a9(_a3,_a5);
}
}
}
_a4.onClickRow.apply(_a3,_5(_a3,[_a5,row]));
}
};
function _ad(e){
var tr=_9c(e.target);
if(!tr){
return;
}
var _ae=_89(tr);
var _af=$.data(_ae,"datagrid").options;
var _b0=_9f(tr);
var row=_af.finder.getRow(_ae,_b0);
var td=$(e.target).closest("td[field]",tr);
if(td.length){
var _b1=td.attr("field");
_af.onDblClickCell.call(_ae,_b0,_b1,row[_b1]);
}
_af.onDblClickRow.apply(_ae,_5(_ae,[_b0,row]));
};
function _b2(e){
var tr=_9c(e.target);
if(tr){
var _b3=_89(tr);
var _b4=$.data(_b3,"datagrid").options;
var _b5=_9f(tr);
var row=_b4.finder.getRow(_b3,_b5);
_b4.onRowContextMenu.call(_b3,e,_b5,row);
}else{
var _b6=_9c(e.target,".datagrid-body");
if(_b6){
var _b3=_89(_b6);
var _b4=$.data(_b3,"datagrid").options;
_b4.onRowContextMenu.call(_b3,e,-1,null);
}
}
};
function _89(t){
return $(t).closest("div.datagrid-view").children(".datagrid-f")[0];
};
function _9c(t,_b7){
var tr=$(t).closest(_b7||"tr.datagrid-row");
if(tr.length&&tr.parent().length){
return tr;
}else{
return undefined;
}
};
function _9f(tr){
if(tr.attr("datagrid-row-index")){
return parseInt(tr.attr("datagrid-row-index"));
}else{
return tr.attr("node-id");
}
};
function _90(_b8,_b9){
var _ba=$.data(_b8,"datagrid");
var _bb=_ba.options;
_b9=_b9||{};
var _bc={sortName:_bb.sortName,sortOrder:_bb.sortOrder};
if(typeof _b9=="object"){
$.extend(_bc,_b9);
}
var _bd=[];
var _be=[];
if(_bc.sortName){
_bd=_bc.sortName.split(",");
_be=_bc.sortOrder.split(",");
}
if(typeof _b9=="string"){
var _bf=_b9;
var col=_78(_b8,_bf);
if(!col.sortable||_ba.resizing){
return;
}
var _c0=col.order||"asc";
var pos=_2(_bd,_bf);
if(pos>=0){
var _c1=_be[pos]=="asc"?"desc":"asc";
if(_bb.multiSort&&_c1==_c0){
_bd.splice(pos,1);
_be.splice(pos,1);
}else{
_be[pos]=_c1;
}
}else{
if(_bb.multiSort){
_bd.push(_bf);
_be.push(_c0);
}else{
_bd=[_bf];
_be=[_c0];
}
}
_bc.sortName=_bd.join(",");
_bc.sortOrder=_be.join(",");
}
if(_bb.onBeforeSortColumn.call(_b8,_bc.sortName,_bc.sortOrder)==false){
return;
}
$.extend(_bb,_bc);
var dc=_ba.dc;
var _c2=dc.header1.add(dc.header2);
_c2.find("div.datagrid-cell").removeClass("datagrid-sort-asc datagrid-sort-desc");
for(var i=0;i<_bd.length;i++){
var col=_78(_b8,_bd[i]);
_c2.find("div."+col.cellClass).addClass("datagrid-sort-"+_be[i]);
}
if(_bb.remoteSort){
_c3(_b8);
}else{
_c4(_b8,$(_b8).datagrid("getData"));
}
_bb.onSortColumn.call(_b8,_bb.sortName,_bb.sortOrder);
};
function _c5(_c6,_c7,_c8){
_c9(true);
_c9(false);
function _c9(_ca){
var aa=_cb(_c6,_ca);
if(aa.length){
var _cc=aa[aa.length-1];
var _cd=_2(_cc,_c7);
if(_cd>=0){
for(var _ce=0;_ce<aa.length-1;_ce++){
var td=$("#"+aa[_ce][_cd]);
var _cf=parseInt(td.attr("colspan")||1)+(_c8||0);
td.attr("colspan",_cf);
if(_cf){
td.show();
}else{
td.hide();
}
}
}
}
};
};
function _d0(_d1){
var _d2=$.data(_d1,"datagrid");
var _d3=_d2.options;
var dc=_d2.dc;
var _d4=dc.view2.children("div.datagrid-header");
var _d5=_d4.children("div.datagrid-header-inner");
dc.body2.css("overflow-x","");
_d6();
_d7();
_d8();
_d6(true);
_d5.show();
if(_d4.width()>=_d4.find("table").width()){
dc.body2.css("overflow-x","hidden");
}
if(!_d3.showHeader){
_d5.hide();
}
function _d8(){
if(!_d3.fitColumns){
return;
}
if(!_d2.leftWidth){
_d2.leftWidth=0;
}
var _d9=0;
var cc=[];
var _da=_77(_d1,false);
for(var i=0;i<_da.length;i++){
var col=_78(_d1,_da[i]);
if(_db(col)){
_d9+=col.width;
cc.push({field:col.field,col:col,addingWidth:0});
}
}
if(!_d9){
return;
}
cc[cc.length-1].addingWidth-=_d2.leftWidth;
_d5.show();
var _dc=_d4.width()-_d4.find("table").width()-_d3.scrollbarSize+_d2.leftWidth;
var _dd=_dc/_d9;
if(!_d3.showHeader){
_d5.hide();
}
for(var i=0;i<cc.length;i++){
var c=cc[i];
var _de=parseInt(c.col.width*_dd);
c.addingWidth+=_de;
_dc-=_de;
}
cc[cc.length-1].addingWidth+=_dc;
for(var i=0;i<cc.length;i++){
var c=cc[i];
if(c.col.boxWidth+c.addingWidth>0){
c.col.boxWidth+=c.addingWidth;
c.col.width+=c.addingWidth;
}
}
_d2.leftWidth=_dc;
$(_d1).datagrid("fixColumnSize");
};
function _d7(){
var _df=false;
var _e0=_77(_d1,true).concat(_77(_d1,false));
$.map(_e0,function(_e1){
var col=_78(_d1,_e1);
if(String(col.width||"").indexOf("%")>=0){
var _e2=$.parser.parseValue("width",col.width,dc.view,_d3.scrollbarSize+(_d3.rownumbers?_d3.rownumberWidth:0))-col.deltaWidth;
if(_e2>0){
col.boxWidth=_e2;
_df=true;
}
}
});
if(_df){
$(_d1).datagrid("fixColumnSize");
}
};
function _d6(fit){
var _e3=dc.header1.add(dc.header2).find(".datagrid-cell-group");
if(_e3.length){
_e3.each(function(){
$(this)._outerWidth(fit?$(this).parent().width():10);
});
if(fit){
_20(_d1);
}
}
};
function _db(col){
if(String(col.width||"").indexOf("%")>=0){
return false;
}
if(!col.hidden&&!col.checkbox&&!col.auto&&!col.fixed){
return true;
}
};
};
function _e4(_e5,_e6){
var _e7=$.data(_e5,"datagrid");
var _e8=_e7.options;
var dc=_e7.dc;
var tmp=$("<div class=\"datagrid-cell\" style=\"position:absolute;left:-9999px\"></div>").appendTo("body");
if(_e6){
_1a(_e6);
$(_e5).datagrid("fitColumns");
}else{
var _e9=false;
var _ea=_77(_e5,true).concat(_77(_e5,false));
for(var i=0;i<_ea.length;i++){
var _e6=_ea[i];
var col=_78(_e5,_e6);
if(col.auto){
_1a(_e6);
_e9=true;
}
}
if(_e9){
$(_e5).datagrid("fitColumns");
}
}
tmp.remove();
function _1a(_eb){
var _ec=dc.view.find("div.datagrid-header td[field=\""+_eb+"\"] div.datagrid-cell");
_ec.css("width","");
var col=$(_e5).datagrid("getColumnOption",_eb);
col.width=undefined;
col.boxWidth=undefined;
col.auto=true;
$(_e5).datagrid("fixColumnSize",_eb);
var _ed=Math.max(_ee("header"),_ee("allbody"),_ee("allfooter"))+1;
_ec._outerWidth(_ed-1);
col.width=_ed;
col.boxWidth=parseInt(_ec[0].style.width);
col.deltaWidth=_ed-col.boxWidth;
_ec.css("width","");
$(_e5).datagrid("fixColumnSize",_eb);
_e8.onResizeColumn.call(_e5,_eb,col.width);
function _ee(_ef){
var _f0=0;
if(_ef=="header"){
_f0=_f1(_ec);
}else{
_e8.finder.getTr(_e5,0,_ef).find("td[field=\""+_eb+"\"] div.datagrid-cell").each(function(){
var w=_f1($(this));
if(_f0<w){
_f0=w;
}
});
}
return _f0;
function _f1(_f2){
return _f2.is(":visible")?_f2._outerWidth():tmp.html(_f2.html())._outerWidth();
};
};
};
};
function _f3(_f4,_f5){
var _f6=$.data(_f4,"datagrid");
var _f7=_f6.options;
var dc=_f6.dc;
var _f8=dc.view.find("table.datagrid-btable,table.datagrid-ftable");
_f8.css("table-layout","fixed");
if(_f5){
fix(_f5);
}else{
var ff=_77(_f4,true).concat(_77(_f4,false));
for(var i=0;i<ff.length;i++){
fix(ff[i]);
}
}
_f8.css("table-layout","");
_f9(_f4);
_34(_f4);
_fa(_f4);
function fix(_fb){
var col=_78(_f4,_fb);
if(col.cellClass){
_f6.ss.set("."+col.cellClass,col.boxWidth?col.boxWidth+"px":"auto");
}
};
};
function _f9(_fc,tds){
var dc=$.data(_fc,"datagrid").dc;
tds=tds||dc.view.find("td.datagrid-td-merged");
tds.each(function(){
var td=$(this);
var _fd=td.attr("colspan")||1;
if(_fd>1){
var col=_78(_fc,td.attr("field"));
var _fe=col.boxWidth+col.deltaWidth-1;
for(var i=1;i<_fd;i++){
td=td.next();
col=_78(_fc,td.attr("field"));
_fe+=col.boxWidth+col.deltaWidth;
}
$(this).children("div.datagrid-cell")._outerWidth(_fe);
}
});
};
function _fa(_ff){
var dc=$.data(_ff,"datagrid").dc;
dc.view.find("div.datagrid-editable").each(function(){
var cell=$(this);
var _100=cell.parent().attr("field");
var col=$(_ff).datagrid("getColumnOption",_100);
cell._outerWidth(col.boxWidth+col.deltaWidth-1);
var ed=$.data(this,"datagrid.editor");
if(ed.actions.resize){
ed.actions.resize(ed.target,cell.width());
}
});
};
function _78(_101,_102){
function find(_103){
if(_103){
for(var i=0;i<_103.length;i++){
var cc=_103[i];
for(var j=0;j<cc.length;j++){
var c=cc[j];
if(c.field==_102){
return c;
}
}
}
}
return null;
};
var opts=$.data(_101,"datagrid").options;
var col=find(opts.columns);
if(!col){
col=find(opts.frozenColumns);
}
return col;
};
function _cb(_104,_105){
var opts=$.data(_104,"datagrid").options;
var _106=_105?opts.frozenColumns:opts.columns;
var aa=[];
var _107=_108();
for(var i=0;i<_106.length;i++){
aa[i]=new Array(_107);
}
for(var _109=0;_109<_106.length;_109++){
$.map(_106[_109],function(col){
var _10a=_10b(aa[_109]);
if(_10a>=0){
var _10c=col.field||col.id||"";
for(var c=0;c<(col.colspan||1);c++){
for(var r=0;r<(col.rowspan||1);r++){
aa[_109+r][_10a]=_10c;
}
_10a++;
}
}
});
}
return aa;
function _108(){
var _10d=0;
$.map(_106[0]||[],function(col){
_10d+=col.colspan||1;
});
return _10d;
};
function _10b(a){
for(var i=0;i<a.length;i++){
if(a[i]==undefined){
return i;
}
}
return -1;
};
};
function _77(_10e,_10f){
var aa=_cb(_10e,_10f);
return aa.length?aa[aa.length-1]:aa;
};
function _c4(_110,data){
var _111=$.data(_110,"datagrid");
var opts=_111.options;
var dc=_111.dc;
data=opts.loadFilter.call(_110,data);
if($.isArray(data)){
data={total:data.length,rows:data};
}
data.total=parseInt(data.total);
_111.data=data;
if(data.footer){
_111.footer=data.footer;
}
if(!opts.remoteSort&&opts.sortName){
var _112=opts.sortName.split(",");
var _113=opts.sortOrder.split(",");
data.rows.sort(function(r1,r2){
var r=0;
for(var i=0;i<_112.length;i++){
var sn=_112[i];
var so=_113[i];
var col=_78(_110,sn);
var _114=col.sorter||function(a,b){
return a==b?0:(a>b?1:-1);
};
r=_114(r1[sn],r2[sn],r1,r2)*(so=="asc"?1:-1);
if(r!=0){
return r;
}
}
return r;
});
}
if(opts.view.onBeforeRender){
opts.view.onBeforeRender.call(opts.view,_110,data.rows);
}
opts.view.render.call(opts.view,_110,dc.body2,false);
opts.view.render.call(opts.view,_110,dc.body1,true);
if(opts.showFooter){
opts.view.renderFooter.call(opts.view,_110,dc.footer2,false);
opts.view.renderFooter.call(opts.view,_110,dc.footer1,true);
}
if(opts.view.onAfterRender){
opts.view.onAfterRender.call(opts.view,_110);
}
_111.ss.clean();
var _115=$(_110).datagrid("getPager");
if(_115.length){
var _116=_115.pagination("options");
if(_116.total!=data.total){
_115.pagination("refresh",{pageNumber:opts.pageNumber,total:data.total});
if(opts.pageNumber!=_116.pageNumber&&_116.pageNumber>0){
opts.pageNumber=_116.pageNumber;
_c3(_110);
}
}
}
_34(_110);
dc.body2.triggerHandler("scroll");
$(_110).datagrid("setSelectionState");
$(_110).datagrid("autoSizeColumn");
opts.onLoadSuccess.call(_110,data);
};
function _117(_118){
var _119=$.data(_118,"datagrid");
var opts=_119.options;
var dc=_119.dc;
dc.header1.add(dc.header2).find("input[type=checkbox]")._propAttr("checked",false);
if(opts.idField){
var _11a=$.data(_118,"treegrid")?true:false;
var _11b=opts.onSelect;
var _11c=opts.onCheck;
opts.onSelect=opts.onCheck=function(){
};
var rows=opts.finder.getRows(_118);
for(var i=0;i<rows.length;i++){
var row=rows[i];
var _11d=_11a?row[opts.idField]:$(_118).datagrid("getRowIndex",row[opts.idField]);
if(_11e(_119.selectedRows,row)){
_a9(_118,_11d,true,true);
}
if(_11e(_119.checkedRows,row)){
_a6(_118,_11d,true);
}
}
opts.onSelect=_11b;
opts.onCheck=_11c;
}
function _11e(a,r){
for(var i=0;i<a.length;i++){
if(a[i][opts.idField]==r[opts.idField]){
a[i]=r;
return true;
}
}
return false;
};
};
function _11f(_120,row){
var _121=$.data(_120,"datagrid");
var opts=_121.options;
var rows=_121.data.rows;
if(typeof row=="object"){
return _2(rows,row);
}else{
for(var i=0;i<rows.length;i++){
if(rows[i][opts.idField]==row){
return i;
}
}
return -1;
}
};
function _122(_123){
var _124=$.data(_123,"datagrid");
var opts=_124.options;
var data=_124.data;
if(opts.idField){
return _124.selectedRows;
}else{
var rows=[];
opts.finder.getTr(_123,"","selected",2).each(function(){
rows.push(opts.finder.getRow(_123,$(this)));
});
return rows;
}
};
function _125(_126){
var _127=$.data(_126,"datagrid");
var opts=_127.options;
if(opts.idField){
return _127.checkedRows;
}else{
var rows=[];
opts.finder.getTr(_126,"","checked",2).each(function(){
rows.push(opts.finder.getRow(_126,$(this)));
});
return rows;
}
};
function _128(_129,_12a){
var _12b=$.data(_129,"datagrid");
var dc=_12b.dc;
var opts=_12b.options;
var tr=opts.finder.getTr(_129,_12a);
if(tr.length){
if(tr.closest("table").hasClass("datagrid-btable-frozen")){
return;
}
var _12c=dc.view2.children("div.datagrid-header")._outerHeight();
var _12d=dc.body2;
var _12e=opts.scrollbarSize;
if(_12d[0].offsetHeight&&_12d[0].clientHeight&&_12d[0].offsetHeight<=_12d[0].clientHeight){
_12e=0;
}
var _12f=_12d.outerHeight(true)-_12d.outerHeight();
var top=tr.offset().top-dc.view2.offset().top-_12c-_12f;
if(top<0){
_12d.scrollTop(_12d.scrollTop()+top);
}else{
if(top+tr._outerHeight()>_12d.height()-_12e){
_12d.scrollTop(_12d.scrollTop()+top+tr._outerHeight()-_12d.height()+_12e);
}
}
}
};
function _a0(_130,_131){
var _132=$.data(_130,"datagrid");
var opts=_132.options;
opts.finder.getTr(_130,_132.highlightIndex).removeClass("datagrid-row-over");
opts.finder.getTr(_130,_131).addClass("datagrid-row-over");
_132.highlightIndex=_131;
};
function _a9(_133,_134,_135,_136){
var _137=$.data(_133,"datagrid");
var opts=_137.options;
var row=opts.finder.getRow(_133,_134);
if(!row){
return;
}
var tr=opts.finder.getTr(_133,_134);
if(tr.hasClass("datagrid-row-selected")){
return;
}
if(opts.onBeforeSelect.apply(_133,_5(_133,[_134,row]))==false){
return;
}
if(opts.singleSelect){
_138(_133,true);
_137.selectedRows=[];
}
if(!_135&&opts.checkOnSelect){
_a6(_133,_134,true);
}
if(opts.idField){
_4(_137.selectedRows,opts.idField,row);
}
tr.addClass("datagrid-row-selected");
if(_137.selectingData){
_137.selectingData.push(row);
}
opts.onSelect.apply(_133,_5(_133,[_134,row]));
if(!_136&&opts.scrollOnSelect){
_128(_133,_134);
}
};
function _aa(_139,_13a,_13b){
var _13c=$.data(_139,"datagrid");
var dc=_13c.dc;
var opts=_13c.options;
var row=opts.finder.getRow(_139,_13a);
if(!row){
return;
}
var tr=opts.finder.getTr(_139,_13a);
if(!tr.hasClass("datagrid-row-selected")){
return;
}
if(opts.onBeforeUnselect.apply(_139,_5(_139,[_13a,row]))==false){
return;
}
if(!_13b&&opts.checkOnSelect){
_a7(_139,_13a,true);
}
tr.removeClass("datagrid-row-selected");
if(opts.idField){
_3(_13c.selectedRows,opts.idField,row[opts.idField]);
}
if(_13c.selectingData){
_13c.selectingData.push(row);
}
opts.onUnselect.apply(_139,_5(_139,[_13a,row]));
};
function _13d(_13e,_13f){
var _140=$.data(_13e,"datagrid");
var opts=_140.options;
var _141=$.data(_13e,"treegrid")?true:false;
var _142=opts.scrollOnSelect;
opts.scrollOnSelect=false;
_140.selectingData=[];
if(!_13f&&opts.checkOnSelect){
_8d(_13e,true);
}
var rows=opts.finder.getRows(_13e);
for(var i=0;i<rows.length;i++){
var _143=_141?rows[i][opts.idField]:$(_13e).datagrid("getRowIndex",rows[i]);
_a9(_13e,_143);
}
var _144=_140.selectingData;
_140.selectingData=null;
opts.scrollOnSelect=_142;
opts.onSelectAll.call(_13e,_144);
};
function _138(_145,_146){
var _147=$.data(_145,"datagrid");
var opts=_147.options;
var _148=$.data(_145,"treegrid")?true:false;
_147.selectingData=[];
if(!_146&&opts.checkOnSelect){
_8e(_145,true);
}
var rows=opts.finder.getRows(_145);
for(var i=0;i<rows.length;i++){
var _149=_148?rows[i][opts.idField]:$(_145).datagrid("getRowIndex",rows[i]);
_aa(_145,_149);
}
var _14a=_147.selectingData;
_147.selectingData=null;
opts.onUnselectAll.call(_145,_14a);
};
function _14b(_14c){
var _14d=$.data(_14c,"datagrid");
var opts=_14d.options;
var _14e=[];
var rows=opts.finder.getRows(_14c);
for(var i=0;i<rows.length;i++){
var _14f=_11f(_14c,rows[i]);
if(opts.onBeforeCheck.apply(_14c,_5(_14c,[_14f,rows[i]]))!=false){
_14e.push(rows[i]);
}
}
var trs=opts.finder.getTr(_14c,"","checked",2);
var _150=trs.length==_14e.length;
var dc=_14d.dc;
dc.header1.add(dc.header2).find("input[type=checkbox]")._propAttr("checked",_150);
};
function _a6(_151,_152,_153){
var _154=$.data(_151,"datagrid");
var opts=_154.options;
var row=opts.finder.getRow(_151,_152);
if(!row){
return;
}
var tr=opts.finder.getTr(_151,_152);
var ck=tr.find(".datagrid-cell-check input[type=checkbox]");
if(ck.is(":checked")){
return;
}
if(opts.onBeforeCheck.apply(_151,_5(_151,[_152,row]))==false){
return;
}
if(opts.singleSelect&&opts.selectOnCheck){
_8e(_151,true);
_154.checkedRows=[];
}
if(!_153&&opts.selectOnCheck){
_a9(_151,_152,true);
}
tr.addClass("datagrid-row-checked");
ck._propAttr("checked",true);
if(!opts.notSetHeaderCheck){
_14b(_151);
}
if(opts.idField){
_4(_154.checkedRows,opts.idField,row);
}
if(_154.checkingData){
_154.checkingData.push(row);
}
opts.onCheck.apply(_151,_5(_151,[_152,row]));
};
function _a7(_155,_156,_157){
var _158=$.data(_155,"datagrid");
var opts=_158.options;
var row=opts.finder.getRow(_155,_156);
if(!row){
return;
}
var tr=opts.finder.getTr(_155,_156);
var ck=tr.find("div.datagrid-cell-check input[type=checkbox]");
if(!ck.is(":checked")){
return;
}
if(opts.onBeforeUncheck.apply(_155,_5(_155,[_156,row]))==false){
return;
}
if(!_157&&opts.selectOnCheck){
_aa(_155,_156,true);
}
tr.removeClass("datagrid-row-checked");
ck._propAttr("checked",false);
var dc=_158.dc;
var _159=dc.header1.add(dc.header2);
_159.find("input[type=checkbox]")._propAttr("checked",false);
if(opts.idField){
_3(_158.checkedRows,opts.idField,row[opts.idField]);
}
if(_158.checkingData){
_158.checkingData.push(row);
}
opts.onUncheck.apply(_155,_5(_155,[_156,row]));
};
function _8d(_15a,_15b){
var _15c=$.data(_15a,"datagrid");
var opts=_15c.options;
var _15d=$.data(_15a,"treegrid")?true:false;
var _15e=opts.scrollOnSelect;
opts.scrollOnSelect=false;
opts.notSetHeaderCheck=true;
_15c.checkingData=[];
if(!_15b&&opts.selectOnCheck){
_13d(_15a,true);
}
var rows=opts.finder.getRows(_15a);
for(var i=0;i<rows.length;i++){
var _15f=_15d?rows[i][opts.idField]:$(_15a).datagrid("getRowIndex",rows[i]);
_a6(_15a,_15f);
}
_14b(_15a);
var _160=_15c.checkingData;
_15c.checkingData=null;
opts.scrollOnSelect=_15e;
opts.notSetHeaderCheck=false;
opts.onCheckAll.call(_15a,_160);
};
function _8e(_161,_162){
var _163=$.data(_161,"datagrid");
var opts=_163.options;
var _164=$.data(_161,"treegrid")?true:false;
_163.checkingData=[];
if(!_162&&opts.selectOnCheck){
_138(_161,true);
}
var rows=opts.finder.getRows(_161);
for(var i=0;i<rows.length;i++){
var _165=_164?rows[i][opts.idField]:$(_161).datagrid("getRowIndex",rows[i]);
_a7(_161,_165);
}
var _166=_163.checkingData;
_163.checkingData=null;
opts.onUncheckAll.call(_161,_166);
};
function _167(_168,_169){
var opts=$.data(_168,"datagrid").options;
var tr=opts.finder.getTr(_168,_169);
var row=opts.finder.getRow(_168,_169);
if(tr.hasClass("datagrid-row-editing")){
return;
}
if(opts.onBeforeEdit.apply(_168,_5(_168,[_169,row]))==false){
return;
}
tr.addClass("datagrid-row-editing");
_16a(_168,_169);
_fa(_168);
tr.find("div.datagrid-editable").each(function(){
var _16b=$(this).parent().attr("field");
var ed=$.data(this,"datagrid.editor");
ed.actions.setValue(ed.target,row[_16b]);
});
_16c(_168,_169);
opts.onBeginEdit.apply(_168,_5(_168,[_169,row]));
};
function _16d(_16e,_16f,_170){
var _171=$.data(_16e,"datagrid");
var opts=_171.options;
var _172=_171.updatedRows;
var _173=_171.insertedRows;
var tr=opts.finder.getTr(_16e,_16f);
var row=opts.finder.getRow(_16e,_16f);
if(!tr.hasClass("datagrid-row-editing")){
return;
}
if(!_170){
if(!_16c(_16e,_16f)){
return;
}
var _174=false;
var _175={};
tr.find("div.datagrid-editable").each(function(){
var _176=$(this).parent().attr("field");
var ed=$.data(this,"datagrid.editor");
var t=$(ed.target);
var _177=t.data("textbox")?t.textbox("textbox"):t;
if(_177.is(":focus")){
_177.triggerHandler("blur");
}
var _178=ed.actions.getValue(ed.target);
if(row[_176]!==_178){
row[_176]=_178;
_174=true;
_175[_176]=_178;
}
});
if(_174){
if(_2(_173,row)==-1){
if(_2(_172,row)==-1){
_172.push(row);
}
}
}
opts.onEndEdit.apply(_16e,_5(_16e,[_16f,row,_175]));
}
tr.removeClass("datagrid-row-editing");
_179(_16e,_16f);
$(_16e).datagrid("refreshRow",_16f);
if(!_170){
opts.onAfterEdit.apply(_16e,_5(_16e,[_16f,row,_175]));
}else{
opts.onCancelEdit.apply(_16e,_5(_16e,[_16f,row]));
}
};
function _17a(_17b,_17c){
var opts=$.data(_17b,"datagrid").options;
var tr=opts.finder.getTr(_17b,_17c);
var _17d=[];
tr.children("td").each(function(){
var cell=$(this).find("div.datagrid-editable");
if(cell.length){
var ed=$.data(cell[0],"datagrid.editor");
_17d.push(ed);
}
});
return _17d;
};
function _17e(_17f,_180){
var _181=_17a(_17f,_180.index!=undefined?_180.index:_180.id);
for(var i=0;i<_181.length;i++){
if(_181[i].field==_180.field){
return _181[i];
}
}
return null;
};
function _16a(_182,_183){
var opts=$.data(_182,"datagrid").options;
var tr=opts.finder.getTr(_182,_183);
tr.children("td").each(function(){
var cell=$(this).find("div.datagrid-cell");
var _184=$(this).attr("field");
var col=_78(_182,_184);
if(col&&col.editor){
var _185,_186;
if(typeof col.editor=="string"){
_185=col.editor;
}else{
_185=col.editor.type;
_186=col.editor.options;
}
var _187=opts.editors[_185];
if(_187){
var _188=cell.html();
var _189=cell._outerWidth();
cell.addClass("datagrid-editable");
cell._outerWidth(_189);
cell.html("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\"><tr><td></td></tr></table>");
cell.children("table")._bind("click dblclick contextmenu",function(e){
e.stopPropagation();
});
$.data(cell[0],"datagrid.editor",{actions:_187,target:_187.init(cell.find("td"),$.extend({height:opts.editorHeight},_186)),field:_184,type:_185,oldHtml:_188});
}
}
});
_34(_182,_183,true);
};
function _179(_18a,_18b){
var opts=$.data(_18a,"datagrid").options;
var tr=opts.finder.getTr(_18a,_18b);
tr.children("td").each(function(){
var cell=$(this).find("div.datagrid-editable");
if(cell.length){
var ed=$.data(cell[0],"datagrid.editor");
if(ed.actions.destroy){
ed.actions.destroy(ed.target);
}
cell.html(ed.oldHtml);
$.removeData(cell[0],"datagrid.editor");
cell.removeClass("datagrid-editable");
cell.css("width","");
}
});
};
function _16c(_18c,_18d){
var tr=$.data(_18c,"datagrid").options.finder.getTr(_18c,_18d);
if(!tr.hasClass("datagrid-row-editing")){
return true;
}
var vbox=tr.find(".validatebox-text");
vbox.validatebox("validate");
vbox.trigger("mouseleave");
var _18e=tr.find(".validatebox-invalid");
return _18e.length==0;
};
function _18f(_190,_191){
var _192=$.data(_190,"datagrid").insertedRows;
var _193=$.data(_190,"datagrid").deletedRows;
var _194=$.data(_190,"datagrid").updatedRows;
if(!_191){
var rows=[];
rows=rows.concat(_192);
rows=rows.concat(_193);
rows=rows.concat(_194);
return rows;
}else{
if(_191=="inserted"){
return _192;
}else{
if(_191=="deleted"){
return _193;
}else{
if(_191=="updated"){
return _194;
}
}
}
}
return [];
};
function _195(_196,_197){
var _198=$.data(_196,"datagrid");
var opts=_198.options;
var data=_198.data;
var _199=_198.insertedRows;
var _19a=_198.deletedRows;
$(_196).datagrid("cancelEdit",_197);
var row=opts.finder.getRow(_196,_197);
if(_2(_199,row)>=0){
_3(_199,row);
}else{
_19a.push(row);
}
_3(_198.selectedRows,opts.idField,row[opts.idField]);
_3(_198.checkedRows,opts.idField,row[opts.idField]);
opts.view.deleteRow.call(opts.view,_196,_197);
if(opts.height=="auto"){
_34(_196);
}
$(_196).datagrid("getPager").pagination("refresh",{total:data.total});
};
function _19b(_19c,_19d){
var data=$.data(_19c,"datagrid").data;
var view=$.data(_19c,"datagrid").options.view;
var _19e=$.data(_19c,"datagrid").insertedRows;
view.insertRow.call(view,_19c,_19d.index,_19d.row);
_19e.push(_19d.row);
$(_19c).datagrid("getPager").pagination("refresh",{total:data.total});
};
function _19f(_1a0,row){
var data=$.data(_1a0,"datagrid").data;
var view=$.data(_1a0,"datagrid").options.view;
var _1a1=$.data(_1a0,"datagrid").insertedRows;
view.insertRow.call(view,_1a0,null,row);
_1a1.push(row);
$(_1a0).datagrid("getPager").pagination("refresh",{total:data.total});
};
function _1a2(_1a3,_1a4){
var _1a5=$.data(_1a3,"datagrid");
var opts=_1a5.options;
var row=opts.finder.getRow(_1a3,_1a4.index);
var _1a6=false;
_1a4.row=_1a4.row||{};
for(var _1a7 in _1a4.row){
if(row[_1a7]!==_1a4.row[_1a7]){
_1a6=true;
break;
}
}
if(_1a6){
if(_2(_1a5.insertedRows,row)==-1){
if(_2(_1a5.updatedRows,row)==-1){
_1a5.updatedRows.push(row);
}
}
opts.view.updateRow.call(opts.view,_1a3,_1a4.index,_1a4.row);
}
};
function _1a8(_1a9){
var _1aa=$.data(_1a9,"datagrid");
var data=_1aa.data;
var rows=data.rows;
var _1ab=[];
for(var i=0;i<rows.length;i++){
_1ab.push($.extend({},rows[i]));
}
_1aa.originalRows=_1ab;
_1aa.updatedRows=[];
_1aa.insertedRows=[];
_1aa.deletedRows=[];
};
function _1ac(_1ad){
var data=$.data(_1ad,"datagrid").data;
var ok=true;
for(var i=0,len=data.rows.length;i<len;i++){
if(_16c(_1ad,i)){
$(_1ad).datagrid("endEdit",i);
}else{
ok=false;
}
}
if(ok){
_1a8(_1ad);
}
};
function _1ae(_1af){
var _1b0=$.data(_1af,"datagrid");
var opts=_1b0.options;
var _1b1=_1b0.originalRows;
var _1b2=_1b0.insertedRows;
var _1b3=_1b0.deletedRows;
var _1b4=_1b0.selectedRows;
var _1b5=_1b0.checkedRows;
var data=_1b0.data;
function _1b6(a){
var ids=[];
for(var i=0;i<a.length;i++){
ids.push(a[i][opts.idField]);
}
return ids;
};
function _1b7(ids,_1b8){
for(var i=0;i<ids.length;i++){
var _1b9=_11f(_1af,ids[i]);
if(_1b9>=0){
(_1b8=="s"?_a9:_a6)(_1af,_1b9,true);
}
}
};
for(var i=0;i<data.rows.length;i++){
$(_1af).datagrid("cancelEdit",i);
}
var _1ba=_1b6(_1b4);
var _1bb=_1b6(_1b5);
_1b4.splice(0,_1b4.length);
_1b5.splice(0,_1b5.length);
data.total+=_1b3.length-_1b2.length;
data.rows=_1b1;
_c4(_1af,data);
_1b7(_1ba,"s");
_1b7(_1bb,"c");
_1a8(_1af);
};
function _c3(_1bc,_1bd,cb){
var opts=$.data(_1bc,"datagrid").options;
if(_1bd){
opts.queryParams=_1bd;
}
var _1be=$.extend({},opts.queryParams);
if(opts.pagination){
$.extend(_1be,{page:opts.pageNumber||1,rows:opts.pageSize});
}
if(opts.sortName&&opts.remoteSort){
$.extend(_1be,{sort:opts.sortName,order:opts.sortOrder});
}
if(opts.onBeforeLoad.call(_1bc,_1be)==false){
opts.view.setEmptyMsg(_1bc);
return;
}
$(_1bc).datagrid("loading");
var _1bf=opts.loader.call(_1bc,_1be,function(data){
$(_1bc).datagrid("loaded");
$(_1bc).datagrid("loadData",data);
if(cb){
cb();
}
},function(){
$(_1bc).datagrid("loaded");
opts.onLoadError.apply(_1bc,arguments);
});
if(_1bf==false){
$(_1bc).datagrid("loaded");
opts.view.setEmptyMsg(_1bc);
}
};
function _1c0(_1c1,_1c2){
var opts=$.data(_1c1,"datagrid").options;
_1c2.type=_1c2.type||"body";
_1c2.rowspan=_1c2.rowspan||1;
_1c2.colspan=_1c2.colspan||1;
if(_1c2.rowspan==1&&_1c2.colspan==1){
return;
}
var tr=opts.finder.getTr(_1c1,(_1c2.index!=undefined?_1c2.index:_1c2.id),_1c2.type);
if(!tr.length){
return;
}
var td=tr.find("td[field=\""+_1c2.field+"\"]");
td.attr("rowspan",_1c2.rowspan).attr("colspan",_1c2.colspan);
td.addClass("datagrid-td-merged");
_1c3(td.next(),_1c2.colspan-1);
for(var i=1;i<_1c2.rowspan;i++){
tr=tr.next();
if(!tr.length){
break;
}
_1c3(tr.find("td[field=\""+_1c2.field+"\"]"),_1c2.colspan);
}
_f9(_1c1,td);
function _1c3(td,_1c4){
for(var i=0;i<_1c4;i++){
td.hide();
td=td.next();
}
};
};
$.fn.datagrid=function(_1c5,_1c6){
if(typeof _1c5=="string"){
return $.fn.datagrid.methods[_1c5](this,_1c6);
}
_1c5=_1c5||{};
return this.each(function(){
var _1c7=$.data(this,"datagrid");
var opts;
if(_1c7){
opts=$.extend(_1c7.options,_1c5);
_1c7.options=opts;
}else{
opts=$.extend({},$.extend({},$.fn.datagrid.defaults,{queryParams:{}}),$.fn.datagrid.parseOptions(this),_1c5);
$(this).css("width","").css("height","");
var _1c8=_4e(this,opts.rownumbers);
if(!opts.columns){
opts.columns=_1c8.columns;
}
if(!opts.frozenColumns){
opts.frozenColumns=_1c8.frozenColumns;
}
opts.columns=$.extend(true,[],opts.columns);
opts.frozenColumns=$.extend(true,[],opts.frozenColumns);
opts.view=$.extend({},opts.view);
$.data(this,"datagrid",{options:opts,panel:_1c8.panel,dc:_1c8.dc,ss:null,selectedRows:[],checkedRows:[],data:{total:0,rows:[]},originalRows:[],updatedRows:[],insertedRows:[],deletedRows:[]});
}
_59(this);
_79(this);
_1a(this);
if(opts.data){
$(this).datagrid("loadData",opts.data);
}else{
var data=$.fn.datagrid.parseData(this);
if(data.total>0){
$(this).datagrid("loadData",data);
}else{
$(this).datagrid("autoSizeColumn");
}
}
_c3(this);
});
};
function _1c9(_1ca){
var _1cb={};
$.map(_1ca,function(name){
_1cb[name]=_1cc(name);
});
return _1cb;
function _1cc(name){
function isA(_1cd){
return $.data($(_1cd)[0],name)!=undefined;
};
return {init:function(_1ce,_1cf){
var _1d0=$("<input type=\"text\" class=\"datagrid-editable-input\">").appendTo(_1ce);
if(_1d0[name]&&name!="text"){
return _1d0[name](_1cf);
}else{
return _1d0;
}
},destroy:function(_1d1){
if(isA(_1d1,name)){
$(_1d1)[name]("destroy");
}
},getValue:function(_1d2){
if(isA(_1d2,name)){
var opts=$(_1d2)[name]("options");
if(opts.multiple){
return $(_1d2)[name]("getValues").join(opts.separator);
}else{
return $(_1d2)[name]("getValue");
}
}else{
return $(_1d2).val();
}
},setValue:function(_1d3,_1d4){
if(isA(_1d3,name)){
var opts=$(_1d3)[name]("options");
if(opts.multiple){
if(_1d4){
$(_1d3)[name]("setValues",_1d4.split(opts.separator));
}else{
$(_1d3)[name]("clear");
}
}else{
$(_1d3)[name]("setValue",_1d4);
}
}else{
$(_1d3).val(_1d4);
}
},resize:function(_1d5,_1d6){
if(isA(_1d5,name)){
$(_1d5)[name]("resize",_1d6);
}else{
$(_1d5)._size({width:_1d6,height:$.fn.datagrid.defaults.editorHeight});
}
}};
};
};
var _1d7=$.extend({},_1c9(["text","textbox","passwordbox","filebox","numberbox","numberspinner","combobox","combotree","combogrid","combotreegrid","datebox","datetimebox","timespinner","datetimespinner"]),{textarea:{init:function(_1d8,_1d9){
var _1da=$("<textarea class=\"datagrid-editable-input\"></textarea>").appendTo(_1d8);
_1da.css("vertical-align","middle")._outerHeight(_1d9.height);
return _1da;
},getValue:function(_1db){
return $(_1db).val();
},setValue:function(_1dc,_1dd){
$(_1dc).val(_1dd);
},resize:function(_1de,_1df){
$(_1de)._outerWidth(_1df);
}},checkbox:{init:function(_1e0,_1e1){
var _1e2=$("<input type=\"checkbox\">").appendTo(_1e0);
_1e2.val(_1e1.on);
_1e2.attr("offval",_1e1.off);
return _1e2;
},getValue:function(_1e3){
if($(_1e3).is(":checked")){
return $(_1e3).val();
}else{
return $(_1e3).attr("offval");
}
},setValue:function(_1e4,_1e5){
var _1e6=false;
if($(_1e4).val()==_1e5){
_1e6=true;
}
$(_1e4)._propAttr("checked",_1e6);
}},validatebox:{init:function(_1e7,_1e8){
var _1e9=$("<input type=\"text\" class=\"datagrid-editable-input\">").appendTo(_1e7);
_1e9.validatebox(_1e8);
return _1e9;
},destroy:function(_1ea){
$(_1ea).validatebox("destroy");
},getValue:function(_1eb){
return $(_1eb).val();
},setValue:function(_1ec,_1ed){
$(_1ec).val(_1ed);
},resize:function(_1ee,_1ef){
$(_1ee)._outerWidth(_1ef)._outerHeight($.fn.datagrid.defaults.editorHeight);
}}});
$.fn.datagrid.methods={options:function(jq){
var _1f0=$.data(jq[0],"datagrid").options;
var _1f1=$.data(jq[0],"datagrid").panel.panel("options");
var opts=$.extend(_1f0,{width:_1f1.width,height:_1f1.height,closed:_1f1.closed,collapsed:_1f1.collapsed,minimized:_1f1.minimized,maximized:_1f1.maximized});
return opts;
},setSelectionState:function(jq){
return jq.each(function(){
_117(this);
});
},createStyleSheet:function(jq){
return _7(jq[0]);
},getPanel:function(jq){
return $.data(jq[0],"datagrid").panel;
},getPager:function(jq){
return $.data(jq[0],"datagrid").panel.children("div.datagrid-pager");
},getColumnFields:function(jq,_1f2){
return _77(jq[0],_1f2);
},getColumnOption:function(jq,_1f3){
return _78(jq[0],_1f3);
},resize:function(jq,_1f4){
return jq.each(function(){
_1a(this,_1f4);
});
},load:function(jq,_1f5){
return jq.each(function(){
var opts=$(this).datagrid("options");
if(typeof _1f5=="string"){
opts.url=_1f5;
_1f5=null;
}
opts.pageNumber=1;
var _1f6=$(this).datagrid("getPager");
_1f6.pagination("refresh",{pageNumber:1});
_c3(this,_1f5);
});
},reload:function(jq,_1f7){
return jq.each(function(){
var opts=$(this).datagrid("options");
if(typeof _1f7=="string"){
opts.url=_1f7;
_1f7=null;
}
_c3(this,_1f7);
});
},reloadFooter:function(jq,_1f8){
return jq.each(function(){
var opts=$.data(this,"datagrid").options;
var dc=$.data(this,"datagrid").dc;
if(_1f8){
$.data(this,"datagrid").footer=_1f8;
}
if(opts.showFooter){
opts.view.renderFooter.call(opts.view,this,dc.footer2,false);
opts.view.renderFooter.call(opts.view,this,dc.footer1,true);
if(opts.view.onAfterRender){
opts.view.onAfterRender.call(opts.view,this);
}
$(this).datagrid("fixRowHeight");
}
});
},loading:function(jq){
return jq.each(function(){
var opts=$.data(this,"datagrid").options;
$(this).datagrid("getPager").pagination("loading");
if(opts.loadMsg){
var _1f9=$(this).datagrid("getPanel");
if(!_1f9.children("div.datagrid-mask").length){
$("<div class=\"datagrid-mask\" style=\"display:block\"></div>").appendTo(_1f9);
var msg=$("<div class=\"datagrid-mask-msg\" style=\"display:block;left:50%\"></div>").html(opts.loadMsg).appendTo(_1f9);
msg._outerHeight(40);
msg.css({marginLeft:(-msg.outerWidth()/2),lineHeight:(msg.height()+"px")});
}
}
});
},loaded:function(jq){
return jq.each(function(){
$(this).datagrid("getPager").pagination("loaded");
var _1fa=$(this).datagrid("getPanel");
_1fa.children("div.datagrid-mask-msg").remove();
_1fa.children("div.datagrid-mask").remove();
});
},fitColumns:function(jq){
return jq.each(function(){
_d0(this);
});
},fixColumnSize:function(jq,_1fb){
return jq.each(function(){
_f3(this,_1fb);
});
},fixRowHeight:function(jq,_1fc){
return jq.each(function(){
_34(this,_1fc);
});
},freezeRow:function(jq,_1fd){
return jq.each(function(){
_46(this,_1fd);
});
},autoSizeColumn:function(jq,_1fe){
return jq.each(function(){
_e4(this,_1fe);
});
},loadData:function(jq,data){
return jq.each(function(){
_c4(this,data);
_1a8(this);
});
},getData:function(jq){
return $.data(jq[0],"datagrid").data;
},getRows:function(jq){
return $.data(jq[0],"datagrid").data.rows;
},getFooterRows:function(jq){
return $.data(jq[0],"datagrid").footer;
},getRowIndex:function(jq,id){
return _11f(jq[0],id);
},getChecked:function(jq){
return _125(jq[0]);
},getSelected:function(jq){
var rows=_122(jq[0]);
return rows.length>0?rows[0]:null;
},getSelections:function(jq){
return _122(jq[0]);
},clearSelections:function(jq){
return jq.each(function(){
var _1ff=$.data(this,"datagrid");
var _200=_1ff.selectedRows;
var _201=_1ff.checkedRows;
_200.splice(0,_200.length);
_138(this);
if(_1ff.options.checkOnSelect){
_201.splice(0,_201.length);
}
});
},clearChecked:function(jq){
return jq.each(function(){
var _202=$.data(this,"datagrid");
var _203=_202.selectedRows;
var _204=_202.checkedRows;
_204.splice(0,_204.length);
_8e(this);
if(_202.options.selectOnCheck){
_203.splice(0,_203.length);
}
});
},scrollTo:function(jq,_205){
return jq.each(function(){
_128(this,_205);
});
},highlightRow:function(jq,_206){
return jq.each(function(){
_a0(this,_206);
_128(this,_206);
});
},selectAll:function(jq){
return jq.each(function(){
_13d(this);
});
},unselectAll:function(jq){
return jq.each(function(){
_138(this);
});
},selectRow:function(jq,_207){
return jq.each(function(){
_a9(this,_207);
});
},selectRecord:function(jq,id){
return jq.each(function(){
var opts=$.data(this,"datagrid").options;
if(opts.idField){
var _208=_11f(this,id);
if(_208>=0){
$(this).datagrid("selectRow",_208);
}
}
});
},unselectRow:function(jq,_209){
return jq.each(function(){
_aa(this,_209);
});
},checkRow:function(jq,_20a){
return jq.each(function(){
_a6(this,_20a);
});
},uncheckRow:function(jq,_20b){
return jq.each(function(){
_a7(this,_20b);
});
},checkAll:function(jq){
return jq.each(function(){
_8d(this);
});
},uncheckAll:function(jq){
return jq.each(function(){
_8e(this);
});
},beginEdit:function(jq,_20c){
return jq.each(function(){
_167(this,_20c);
});
},endEdit:function(jq,_20d){
return jq.each(function(){
_16d(this,_20d,false);
});
},cancelEdit:function(jq,_20e){
return jq.each(function(){
_16d(this,_20e,true);
});
},getEditors:function(jq,_20f){
return _17a(jq[0],_20f);
},getEditor:function(jq,_210){
return _17e(jq[0],_210);
},refreshRow:function(jq,_211){
return jq.each(function(){
var opts=$.data(this,"datagrid").options;
opts.view.refreshRow.call(opts.view,this,_211);
});
},validateRow:function(jq,_212){
return _16c(jq[0],_212);
},updateRow:function(jq,_213){
return jq.each(function(){
_1a2(this,_213);
});
},appendRow:function(jq,row){
return jq.each(function(){
_19f(this,row);
});
},insertRow:function(jq,_214){
return jq.each(function(){
_19b(this,_214);
});
},deleteRow:function(jq,_215){
return jq.each(function(){
_195(this,_215);
});
},getChanges:function(jq,_216){
return _18f(jq[0],_216);
},acceptChanges:function(jq){
return jq.each(function(){
_1ac(this);
});
},rejectChanges:function(jq){
return jq.each(function(){
_1ae(this);
});
},mergeCells:function(jq,_217){
return jq.each(function(){
_1c0(this,_217);
});
},showColumn:function(jq,_218){
return jq.each(function(){
var col=$(this).datagrid("getColumnOption",_218);
if(col.hidden){
col.hidden=false;
$(this).datagrid("getPanel").find("td[field=\""+_218+"\"]").show();
_c5(this,_218,1);
$(this).datagrid("fitColumns");
}
});
},hideColumn:function(jq,_219){
return jq.each(function(){
var col=$(this).datagrid("getColumnOption",_219);
if(!col.hidden){
col.hidden=true;
$(this).datagrid("getPanel").find("td[field=\""+_219+"\"]").hide();
_c5(this,_219,-1);
$(this).datagrid("fitColumns");
}
});
},sort:function(jq,_21a){
return jq.each(function(){
_90(this,_21a);
});
},gotoPage:function(jq,_21b){
return jq.each(function(){
var _21c=this;
var page,cb;
if(typeof _21b=="object"){
page=_21b.page;
cb=_21b.callback;
}else{
page=_21b;
}
$(_21c).datagrid("options").pageNumber=page;
$(_21c).datagrid("getPager").pagination("refresh",{pageNumber:page});
_c3(_21c,null,function(){
if(cb){
cb.call(_21c,page);
}
});
});
}};
$.fn.datagrid.parseOptions=function(_21d){
var t=$(_21d);
return $.extend({},$.fn.panel.parseOptions(_21d),$.parser.parseOptions(_21d,["url","toolbar","idField","sortName","sortOrder","pagePosition","resizeHandle",{sharedStyleSheet:"boolean",fitColumns:"boolean",autoRowHeight:"boolean",striped:"boolean",nowrap:"boolean"},{rownumbers:"boolean",singleSelect:"boolean",ctrlSelect:"boolean",checkOnSelect:"boolean",selectOnCheck:"boolean"},{pagination:"boolean",pageSize:"number",pageNumber:"number"},{multiSort:"boolean",remoteSort:"boolean",showHeader:"boolean",showFooter:"boolean"},{scrollbarSize:"number",scrollOnSelect:"boolean"}]),{pageList:(t.attr("pageList")?eval(t.attr("pageList")):undefined),loadMsg:(t.attr("loadMsg")!=undefined?t.attr("loadMsg"):undefined),rowStyler:(t.attr("rowStyler")?eval(t.attr("rowStyler")):undefined)});
};
$.fn.datagrid.parseData=function(_21e){
var t=$(_21e);
var data={total:0,rows:[]};
var _21f=t.datagrid("getColumnFields",true).concat(t.datagrid("getColumnFields",false));
t.find("tbody tr").each(function(){
data.total++;
var row={};
$.extend(row,$.parser.parseOptions(this,["iconCls","state"]));
for(var i=0;i<_21f.length;i++){
row[_21f[i]]=$(this).find("td:eq("+i+")").html();
}
data.rows.push(row);
});
return data;
};
var _220={render:function(_221,_222,_223){
var rows=$(_221).datagrid("getRows");
$(_222).empty().html(this.renderTable(_221,0,rows,_223));
},renderFooter:function(_224,_225,_226){
var opts=$.data(_224,"datagrid").options;
var rows=$.data(_224,"datagrid").footer||[];
var _227=$(_224).datagrid("getColumnFields",_226);
var _228=["<table class=\"datagrid-ftable\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>"];
for(var i=0;i<rows.length;i++){
_228.push("<tr class=\"datagrid-row\" datagrid-row-index=\""+i+"\">");
_228.push(this.renderRow.call(this,_224,_227,_226,i,rows[i]));
_228.push("</tr>");
}
_228.push("</tbody></table>");
$(_225).html(_228.join(""));
},renderTable:function(_229,_22a,rows,_22b){
var _22c=$.data(_229,"datagrid");
var opts=_22c.options;
if(_22b){
if(!(opts.rownumbers||(opts.frozenColumns&&opts.frozenColumns.length))){
return "";
}
}
var _22d=$(_229).datagrid("getColumnFields",_22b);
var _22e=["<table class=\"datagrid-btable\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>"];
for(var i=0;i<rows.length;i++){
var row=rows[i];
var css=opts.rowStyler?opts.rowStyler.call(_229,_22a,row):"";
var cs=this.getStyleValue(css);
var cls="class=\"datagrid-row "+(_22a%2&&opts.striped?"datagrid-row-alt ":" ")+cs.c+"\"";
var _22f=cs.s?"style=\""+cs.s+"\"":"";
var _230=_22c.rowIdPrefix+"-"+(_22b?1:2)+"-"+_22a;
_22e.push("<tr id=\""+_230+"\" datagrid-row-index=\""+_22a+"\" "+cls+" "+_22f+">");
_22e.push(this.renderRow.call(this,_229,_22d,_22b,_22a,row));
_22e.push("</tr>");
_22a++;
}
_22e.push("</tbody></table>");
return _22e.join("");
},renderRow:function(_231,_232,_233,_234,_235){
var opts=$.data(_231,"datagrid").options;
var cc=[];
if(_233&&opts.rownumbers){
var _236=_234+1;
if(opts.pagination){
_236+=(opts.pageNumber-1)*opts.pageSize;
}
cc.push("<td class=\"datagrid-td-rownumber\"><div class=\"datagrid-cell-rownumber\">"+_236+"</div></td>");
}
for(var i=0;i<_232.length;i++){
var _237=_232[i];
var col=$(_231).datagrid("getColumnOption",_237);
if(col){
var _238=_235[_237];
var css=col.styler?(col.styler.call(_231,_238,_235,_234)||""):"";
var cs=this.getStyleValue(css);
var cls=cs.c?"class=\""+cs.c+"\"":"";
var _239=col.hidden?"style=\"display:none;"+cs.s+"\"":(cs.s?"style=\""+cs.s+"\"":"");
cc.push("<td field=\""+_237+"\" "+cls+" "+_239+">");
var _239="";
if(!col.checkbox){
if(col.align){
_239+="text-align:"+col.align+";";
}
if(!opts.nowrap){
_239+="white-space:normal;height:auto;";
}else{
if(opts.autoRowHeight){
_239+="height:auto;";
}
}
}
cc.push("<div style=\""+_239+"\" ");
cc.push(col.checkbox?"class=\"datagrid-cell-check\"":"class=\"datagrid-cell "+col.cellClass+"\"");
cc.push(">");
if(col.checkbox){
cc.push("<input type=\"checkbox\" "+(_235.checked?"checked=\"checked\"":""));
cc.push(" name=\""+_237+"\" value=\""+(_238!=undefined?_238:"")+"\">");
}else{
if(col.formatter){
cc.push(col.formatter(_238,_235,_234));
}else{
cc.push(_238);
}
}
cc.push("</div>");
cc.push("</td>");
}
}
return cc.join("");
},getStyleValue:function(css){
var _23a="";
var _23b="";
if(typeof css=="string"){
_23b=css;
}else{
if(css){
_23a=css["class"]||"";
_23b=css["style"]||"";
}
}
return {c:_23a,s:_23b};
},refreshRow:function(_23c,_23d){
this.updateRow.call(this,_23c,_23d,{});
},updateRow:function(_23e,_23f,row){
var opts=$.data(_23e,"datagrid").options;
var _240=opts.finder.getRow(_23e,_23f);
$.extend(_240,row);
var cs=_241.call(this,_23f);
var _242=cs.s;
var cls="datagrid-row "+(_23f%2&&opts.striped?"datagrid-row-alt ":" ")+cs.c;
function _241(_243){
var css=opts.rowStyler?opts.rowStyler.call(_23e,_243,_240):"";
return this.getStyleValue(css);
};
function _244(_245){
var tr=opts.finder.getTr(_23e,_23f,"body",(_245?1:2));
if(!tr.length){
return;
}
var _246=$(_23e).datagrid("getColumnFields",_245);
var _247=tr.find("div.datagrid-cell-check input[type=checkbox]").is(":checked");
tr.html(this.renderRow.call(this,_23e,_246,_245,_23f,_240));
var _248=(tr.hasClass("datagrid-row-checked")?" datagrid-row-checked":"")+(tr.hasClass("datagrid-row-selected")?" datagrid-row-selected":"");
tr.attr("style",_242).attr("class",cls+_248);
if(_247){
tr.find("div.datagrid-cell-check input[type=checkbox]")._propAttr("checked",true);
}
};
_244.call(this,true);
_244.call(this,false);
$(_23e).datagrid("fixRowHeight",_23f);
},insertRow:function(_249,_24a,row){
var _24b=$.data(_249,"datagrid");
var opts=_24b.options;
var dc=_24b.dc;
var data=_24b.data;
if(_24a==undefined||_24a==null){
_24a=data.rows.length;
}
if(_24a>data.rows.length){
_24a=data.rows.length;
}
function _24c(_24d){
var _24e=_24d?1:2;
for(var i=data.rows.length-1;i>=_24a;i--){
var tr=opts.finder.getTr(_249,i,"body",_24e);
tr.attr("datagrid-row-index",i+1);
tr.attr("id",_24b.rowIdPrefix+"-"+_24e+"-"+(i+1));
if(_24d&&opts.rownumbers){
var _24f=i+2;
if(opts.pagination){
_24f+=(opts.pageNumber-1)*opts.pageSize;
}
tr.find("div.datagrid-cell-rownumber").html(_24f);
}
if(opts.striped){
tr.removeClass("datagrid-row-alt").addClass((i+1)%2?"datagrid-row-alt":"");
}
}
};
function _250(_251){
var _252=_251?1:2;
var _253=$(_249).datagrid("getColumnFields",_251);
var _254=_24b.rowIdPrefix+"-"+_252+"-"+_24a;
var tr="<tr id=\""+_254+"\" class=\"datagrid-row\" datagrid-row-index=\""+_24a+"\"></tr>";
if(_24a>=data.rows.length){
if(data.rows.length){
opts.finder.getTr(_249,"","last",_252).after(tr);
}else{
var cc=_251?dc.body1:dc.body2;
cc.html("<table class=\"datagrid-btable\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>"+tr+"</tbody></table>");
}
}else{
opts.finder.getTr(_249,_24a+1,"body",_252).before(tr);
}
};
_24c.call(this,true);
_24c.call(this,false);
_250.call(this,true);
_250.call(this,false);
data.total+=1;
data.rows.splice(_24a,0,row);
this.setEmptyMsg(_249);
this.refreshRow.call(this,_249,_24a);
},deleteRow:function(_255,_256){
var _257=$.data(_255,"datagrid");
var opts=_257.options;
var data=_257.data;
function _258(_259){
var _25a=_259?1:2;
for(var i=_256+1;i<data.rows.length;i++){
var tr=opts.finder.getTr(_255,i,"body",_25a);
tr.attr("datagrid-row-index",i-1);
tr.attr("id",_257.rowIdPrefix+"-"+_25a+"-"+(i-1));
if(_259&&opts.rownumbers){
var _25b=i;
if(opts.pagination){
_25b+=(opts.pageNumber-1)*opts.pageSize;
}
tr.find("div.datagrid-cell-rownumber").html(_25b);
}
if(opts.striped){
tr.removeClass("datagrid-row-alt").addClass((i-1)%2?"datagrid-row-alt":"");
}
}
};
opts.finder.getTr(_255,_256).remove();
_258.call(this,true);
_258.call(this,false);
data.total-=1;
data.rows.splice(_256,1);
this.setEmptyMsg(_255);
},onBeforeRender:function(_25c,rows){
},onAfterRender:function(_25d){
var _25e=$.data(_25d,"datagrid");
var opts=_25e.options;
if(opts.showFooter){
var _25f=$(_25d).datagrid("getPanel").find("div.datagrid-footer");
_25f.find("div.datagrid-cell-rownumber,div.datagrid-cell-check").css("visibility","hidden");
}
this.setEmptyMsg(_25d);
},setEmptyMsg:function(_260){
var _261=$.data(_260,"datagrid");
var opts=_261.options;
var _262=opts.finder.getRows(_260).length==0;
if(_262){
this.renderEmptyRow(_260);
}
if(opts.emptyMsg){
_261.dc.view.children(".datagrid-empty").remove();
if(_262){
var h=_261.dc.header2.parent().outerHeight();
var d=$("<div class=\"datagrid-empty\"></div>").appendTo(_261.dc.view);
d.html(opts.emptyMsg).css("top",h+"px");
}
}
},renderEmptyRow:function(_263){
var opts=$(_263).datagrid("options");
var cols=$.map($(_263).datagrid("getColumnFields"),function(_264){
return $(_263).datagrid("getColumnOption",_264);
});
$.map(cols,function(col){
col.formatter1=col.formatter;
col.styler1=col.styler;
col.formatter=col.styler=undefined;
});
var _265=opts.rowStyler;
opts.rowStyler=function(){
};
var _266=$.data(_263,"datagrid").dc.body2;
_266.html(this.renderTable(_263,0,[{}],false));
_266.find("tbody *").css({height:1,borderColor:"transparent",background:"transparent"});
var tr=_266.find(".datagrid-row");
tr.removeClass("datagrid-row").removeAttr("datagrid-row-index");
tr.find(".datagrid-cell,.datagrid-cell-check").empty();
$.map(cols,function(col){
col.formatter=col.formatter1;
col.styler=col.styler1;
col.formatter1=col.styler1=undefined;
});
opts.rowStyler=_265;
}};
$.fn.datagrid.defaults=$.extend({},$.fn.panel.defaults,{sharedStyleSheet:false,frozenColumns:undefined,columns:undefined,fitColumns:false,resizeHandle:"right",resizeEdge:5,autoRowHeight:true,toolbar:null,striped:false,method:"post",nowrap:true,idField:null,url:null,data:null,loadMsg:"Processing, please wait ...",emptyMsg:"",rownumbers:false,singleSelect:false,ctrlSelect:false,selectOnCheck:true,checkOnSelect:true,pagination:false,pagePosition:"bottom",pageNumber:1,pageSize:10,pageList:[10,20,30,40,50],queryParams:{},sortName:null,sortOrder:"asc",multiSort:false,remoteSort:true,showHeader:true,showFooter:false,scrollOnSelect:true,scrollbarSize:18,rownumberWidth:30,editorHeight:31,headerEvents:{mouseover:_86(true),mouseout:_86(false),click:_8a,dblclick:_91,contextmenu:_97},rowEvents:{mouseover:_9a(true),mouseout:_9a(false),click:_a2,dblclick:_ad,contextmenu:_b2},rowStyler:function(_267,_268){
},loader:function(_269,_26a,_26b){
var opts=$(this).datagrid("options");
if(!opts.url){
return false;
}
$.ajax({type:opts.method,url:opts.url,data:_269,dataType:"json",success:function(data){
_26a(data);
},error:function(){
_26b.apply(this,arguments);
}});
},loadFilter:function(data){
return data;
},editors:_1d7,finder:{getTr:function(_26c,_26d,type,_26e){
type=type||"body";
_26e=_26e||0;
var _26f=$.data(_26c,"datagrid");
var dc=_26f.dc;
var opts=_26f.options;
if(_26e==0){
var tr1=opts.finder.getTr(_26c,_26d,type,1);
var tr2=opts.finder.getTr(_26c,_26d,type,2);
return tr1.add(tr2);
}else{
if(type=="body"){
var tr=$("#"+_26f.rowIdPrefix+"-"+_26e+"-"+_26d);
if(!tr.length){
tr=(_26e==1?dc.body1:dc.body2).find(">table>tbody>tr[datagrid-row-index="+_26d+"]");
}
return tr;
}else{
if(type=="footer"){
return (_26e==1?dc.footer1:dc.footer2).find(">table>tbody>tr[datagrid-row-index="+_26d+"]");
}else{
if(type=="selected"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr.datagrid-row-selected");
}else{
if(type=="highlight"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr.datagrid-row-over");
}else{
if(type=="checked"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr.datagrid-row-checked");
}else{
if(type=="editing"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr.datagrid-row-editing");
}else{
if(type=="last"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr[datagrid-row-index]:last");
}else{
if(type=="allbody"){
return (_26e==1?dc.body1:dc.body2).find(">table>tbody>tr[datagrid-row-index]");
}else{
if(type=="allfooter"){
return (_26e==1?dc.footer1:dc.footer2).find(">table>tbody>tr[datagrid-row-index]");
}
}
}
}
}
}
}
}
}
}
},getRow:function(_270,p){
var _271=(typeof p=="object")?p.attr("datagrid-row-index"):p;
return $.data(_270,"datagrid").data.rows[parseInt(_271)];
},getRows:function(_272){
return $(_272).datagrid("getRows");
}},view:_220,onBeforeLoad:function(_273){
},onLoadSuccess:function(){
},onLoadError:function(){
},onClickRow:function(_274,_275){
},onDblClickRow:function(_276,_277){
},onClickCell:function(_278,_279,_27a){
},onDblClickCell:function(_27b,_27c,_27d){
},onBeforeSortColumn:function(sort,_27e){
},onSortColumn:function(sort,_27f){
},onResizeColumn:function(_280,_281){
},onBeforeSelect:function(_282,_283){
},onSelect:function(_284,_285){
},onBeforeUnselect:function(_286,_287){
},onUnselect:function(_288,_289){
},onSelectAll:function(rows){
},onUnselectAll:function(rows){
},onBeforeCheck:function(_28a,_28b){
},onCheck:function(_28c,_28d){
},onBeforeUncheck:function(_28e,_28f){
},onUncheck:function(_290,_291){
},onCheckAll:function(rows){
},onUncheckAll:function(rows){
},onBeforeEdit:function(_292,_293){
},onBeginEdit:function(_294,_295){
},onEndEdit:function(_296,_297,_298){
},onAfterEdit:function(_299,_29a,_29b){
},onCancelEdit:function(_29c,_29d){
},onHeaderContextMenu:function(e,_29e){
},onRowContextMenu:function(e,_29f,_2a0){
}});
})(jQuery);

