﻿function validateMobileNumber(input) {
    const value = input.value.trim();
    const error = document.getElementById('mobileNumberHint');

    // Remove any non-digit characters
    input.value = value.replace(/\D/g, '');

    // Validation rules
    if (!value) {
        setError('لطفا شماره تلفن همراه را وارد کنید');
    } else if (!/^\d+$/.test(value)) {
        setError('فقط از اعداد ۰ تا ۹ استفاده کنید');
    } else if (!/^09/.test(value)) {
        setError('شماره تلفن همراه باید با ۰۹ شروع شود');
    } else if (value.length !== 11) {
        setError('شماره تلفن همراه باید ۱۱ رقم باشد');
    } else if (!/^09[0-9]{9}$/.test(value)) {
        setError('فرمت شماره تلفن همراه نادرست است');
    } else {
        error.className = 'form-text text-muted hint-text';
        error.textContent = 'مثال: ۰۹۱۲۳۴۵۶۷۸۹';
        input.setCustomValidity('');
        return true;
    }

    function setError(message) {
        error.className = 'form-text text-danger';
        error.textContent = message;
        input.setCustomValidity(message);
    }
}

function validateNationalCodeId(input) {
    const value = input.value.trim();
    const error = document.getElementById('nationalCodeIdHint');

    // Remove any non-digit characters
    input.value = value.replace(/\D/g, '');

    // Validation rules
    if (!value) {
        setError('لطفا کد ملی یا شناسه ملی را وارد کنید');
    } else if (!/^\d+$/.test(value)) {
        setError('فقط از اعداد ۰ تا ۹ استفاده کنید');
        // } else if (value.length !== 10 && value.length !== 11) {
        //     setError('کد ملی باید ۱۰ رقم و شناسه ملی ۱۱ رقم باشد');
    } else if (!/^\d{10,11}$/.test(value)) {
        setError('کد ملی باید ۱۰ رقم و شناسه ملی ۱۱ رقم باشد');
    } else {
        error.className = 'form-text text-muted hint-text';
        if (value.length === 10) {
            error.textContent = 'کد ملی اشخاص حقیقی';
        }
        else {
            error.textContent = 'شناسه ملی اشخاص حقوقی';
        }
        input.setCustomValidity('');
        return true;
    }

    function setError(message) {
        error.className = 'form-text text-danger';
        error.textContent = message;
        input.setCustomValidity(message);
    }
}

function validateCaptcha(input) {
    const value = input.value.trim();
    const error = document.getElementById('captchaHint');

    // Remove any non-digit characters
    input.value = value.replace(/\D/g, '');

    // Validation rules
    if (!value) {
        setError('لطفا کد امنیتی را وارد کنید');
    } else if (!/^\d+$/.test(value)) {
        setError('فقط از اعداد ۰ تا ۹ استفاده کنید');
    } else if (value.length !== 5) {
        setError('کد امنیتی باید ۵ رقم باشد');
    } else {
        error.className = 'form-text text-muted hint-text';
        error.textContent = '';
        input.setCustomValidity('');
        return true;
    }

    function setError(message) {
        error.className = 'form-text text-danger';
        error.textContent = message;
        input.setCustomValidity(message);
    }
}

// Add paste event handler for captcha
const captchaInput = document.getElementById('txtCaptcha');
if (captchaInput) {
    captchaInput.addEventListener('paste', (e) => {
        e.preventDefault();
        const text = (e.originalEvent || e).clipboardData.getData('text/plain');
        const cleanNumber = text.replace(/\D/g, '');
        e.target.value = cleanNumber.slice(0, 5);
        validateCaptcha(e.target);
    });
}

// Add paste event handler for national code id
const nationalCodeIdInput = document.getElementById('txtNationalCodeId');
if (nationalCodeIdInput) {
    nationalCodeIdInput.addEventListener('paste', (e) => {
        e.preventDefault();
        const text = (e.originalEvent || e).clipboardData.getData('text/plain');
        const cleanNumber = text.replace(/\D/g, '');
        e.target.value = cleanNumber.slice(0, 11);
        validateNationalCodeId(e.target);
    });
}