﻿function formatIsPaidView(val) {
    //
    if (val === true) {
        return ' <label style="color:green">پرداخت شده</label>';
    }

    return ' <label style="color:red">پرداخت نشده</label>';
}

function formatIsNewField(val) {

    if (val) {
        return 'صدور';
    }
    return 'تمدید';
}



function formatHasLicense(val) {
    if (val == 2) return 'دارد';
    return 'ندارد';
}

function formatBoolean(val) {
    if (val == 1) {
        return '<input type="checkbox" checked readonly>';
    } else {
        return '<input type="checkbox" readonly>';
    }
}

function formatNullRemover(val) {
    if (val) {
        return val;
    } else {
        return '';
    }
}

function formatAmountMinus(val) {
    var amount = parseInt(val).toLocaleString();

    if (val > 0) {
        amount = 0
    }
    return `<span style='color:red'>${amount}</span>`;
}

function formatAmountPlus(val) {

    var amount = parseInt(val).toLocaleString();
    if (val < 0) {
        amount = 0
    }
    return `<span style='color:green'>${amount}</span>`;
    //if (val > 0) {
    //    plus += val;
    //    return `<span style='color:green'>${val}</span>`;
    //}
    //else {
    //    return `<span style='color:green'>-</span>`;
    //}
}

function checkIfBaranehApp() {
    var userAgent = navigator.userAgent.toLowerCase();
    if (userAgent.indexOf('baranehapp') !== -1) {

        return true;
    } else {

        return false;
    }
}

function getBase64Image(selector) {
    return new Promise((resolve, reject) => {
        try {


            const file = $(selector).next().find('.textbox-value')[0].files[0];
            const reader = new FileReader();

            reader.addEventListener("load", function() {
                resolve(reader.result);
            }, false);

            if (file) {
                reader.readAsDataURL(file);
            } else {
                resolve(false);
            }
        } catch (e) {
            resolve(false);
        }
    });

}

$(document).ready(function() {
    SetValidation();

});

//v=1
function SetValidation() {
    // NumberBox
    $(".TrackingCode").on("input", function () {
        try {
            // Get the input value
            var inputValue = $(this).val();

            // Remove non-numeric characters
            inputValue = inputValue.replace(/[^0-9]/g, '');

            // Get min and max values from data attributes
            var minlength = parseInt($(this).data("minlength"));
            var maxlength = parseInt($(this).data("maxlength"));

            // Apply the minimum and maximum character limits
            if (inputValue.length < minlength) {
                inputValue = inputValue.substr(0, minlength);
            } else if (inputValue.length > maxlength) {
                inputValue = inputValue.substr(0, maxlength);
            }

            // Update the input value
            $(this).val(inputValue);

            // Add Bootstrap's is-invalid class if the input is not valid
            if (inputValue.length < minlength || inputValue.length > maxlength) {
                $(this).addClass("is-invalid");
                console.error(`Validation error: Input length is not within the range for element with class 'TrackingCode'.`);
            } else {
                $(this).removeClass("is-invalid");
            }
        } catch (error) {
            console.error(`Error in element with class 'TrackingCode': ${error.message}`);
        }
    });

    // PlateNo
    $('.plateP2').each(function () {
        try {
            $(this).combobox({
                method: 'get',
                url: '/resources/jsons/plates.json',
                valueField: 'id',
                textField: 'text',
            });
        } catch (error) {
            console.error(`Error in element with class 'plateP2': ${error.message}`);
        }
    });

    $('.plateContainer').each(function () {
        try {
            $(this).height($(this).width() / 5);
        } catch (error) {
            console.error(`Error in element with class 'plateContainer': ${error.message}`);
        }
    });

    $('.plateP4').each(function () {
        try {
            $(this).next().addClass('plateP4');
            $(this).textbox('textbox').css({
                'text-align': 'center'
            });
            $(this).textbox('textbox').attr('maxlength', '2');
        } catch (error) {
            console.error(`Error in element with class 'plateP4': ${error.message}`);
        }
    });

    $('.plateP1').each(function () {
        try {
            $(this).next().addClass('plateP1');
            $(this).textbox('textbox').css({
                'text-align': 'center'
            });
            $(this).textbox('textbox').attr('maxlength', '2');
        } catch (error) {
            console.error(`Error in element with class 'plateP1': ${error.message}`);
        }
    });

    $('.plateP3').each(function () {
        try {
            $(this).next().addClass('plateP3');
            $(this).textbox('textbox').css({
                'text-align': 'center'
            });
            $(this).textbox('textbox').attr('maxlength', '3');
        } catch (error) {
            console.error(`Error in element with class 'plateP3': ${error.message}`);
        }
    });

    $('.PostalCode').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '10');
            } else {
                console.error(`Element with class 'PostalCode' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'PostalCode': ${error.message}`);
        }
    });

    $('.NationalCode').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '10');
            } else {
                console.error(`Element with class 'NationalCode' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'NationalCode': ${error.message}`);
        }
    });

    $('.NationalId').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '11');
            } else {
                console.error(`Element with class 'NationalId' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'NationalId': ${error.message}`);
        }
    });

    $('.MobileNumber').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '11');
            } else {
                console.error(`Element with class 'MobileNumber' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'MobileNumber': ${error.message}`);
        }
    });

    $('.Phone').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '8');
            } else {
                console.error(`Element with class 'Phone' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'Phone': ${error.message}`);
        }
    });

    $('.PhoneWithPre').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '11');
            } else {
                console.error(`Element with class 'PhoneWithPre' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'PhoneWithPre': ${error.message}`);
        }
    });

    $('.Model').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '4');
            } else {
                console.error(`Element with class 'Model' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'Model': ${error.message}`);
        }
    });

    $('.CapacityKg').each(function () {
        try {
            var element = $(this).numberbox('textbox');
            if (element.length) {
                element.attr('maxlength', '5');
            } else {
                console.error(`Element with class 'CapacityKg' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'CapacityKg': ${error.message}`);
        }
    });

    $('.TrackingCode').each(function () {
        try {
            $(this).data("maxlength", 15);
            $(this).data("minlength", 15);
        } catch (error) {
            console.error(`Error in element with class 'TrackingCode': ${error.message}`);
        }
    });

    $('.Vin').each(function () {
        try {
            var element = $(this).textbox('textbox');
            if (element.length) {
                element.attr('maxlength', '17');
            } else {
                console.error(`Element with class 'Vin' not found.`);
            }
        } catch (error) {
            console.error(`Error in element with class 'Vin': ${error.message}`);
        }
    });

    $('.dpTextBox').each(function () {
        try {
            $(this).MdPersianDateTimePicker({
                targetTextSelector: '#' + $(this).attr('id'), // Ensure the element has an ID
                targetDateSelector: '#' + $(this).attr('id') + 'Val', // Corresponding hidden input ID
                dateFormat: 'yyyy/MM/dd',
                textFormat: 'yyyy/MM/dd',
                englishNumber: false
            });
        } catch (error) {
            console.error(`Error initializing MdPersianDateTimePicker for element with class 'dpTextBox': ${error.message}`);
        }
    });


    $('.dpTextBox').on('blur', function () {
        var value = $(this).val();
        if (value.length === 0) {
            $(this).addClass('dpTextBox-Invalid').removeClass('dpTextBox-Valid');
        } else {
            $(this).addClass('dpTextBox-Valid').removeClass('dpTextBox-Invalid');
        }
    });
}






function toEnglishNumber(inputNumber2) {
    if (!inputNumber2) return '';
    var str = inputNumber2.toString().trim();
    if (!str) return '';
    str = str.replace(/۰/img, '0');
    str = str.replace(/۱/img, '1');
    str = str.replace(/۲/img, '2');
    str = str.replace(/۳/img, '3');
    str = str.replace(/۴/img, '4');
    str = str.replace(/۵/img, '5');
    str = str.replace(/۶/img, '6');
    str = str.replace(/۷/img, '7');
    str = str.replace(/۸/img, '8');
    str = str.replace(/۹/img, '9');
    return str;
}




function formatIsSuccessful(val) {
    if (val === true) {
        return `<span style='color: white;background-color:green;padding:5px;'>موفق</span>`;
    } else {
        return `<span style='color: white;background-color:red;padding:5px;'>ناموفق</span>`;
    }
}




var GlobalImagesEnums = {

    'VehicleOwnershipCertificateImage': 1,
    'TechnicalLicensingImage': 3,
    'CommitmentImage': 4,
    'TicketImage': 5,
    'ManagerPersonalImage': 99,
    'MotorcycleLicensingImage': 100,
    'MotorcycleDriverImage': 101,
    'PoliceClearanceCertificateImage': 102,
    'HealthCardImage': 103,
    'NationalCardImage': 104,
    'BirthCertificateImage': 105,
    'NonAddictionImage': 106,
    'PersonalImage': 107,
    'FirstPageOfPassportImage': 108,
    'ReagentGuaranteeImage': 109,
    'WorkPermitImage': 110,
    'StatuteImage': 111,
    'AnnouncementOfTheLatestChangesInTheOfficialNewspaperImage': 112,
    'CompanyOwnershipDocumentOrLeaseImage': 113,
    'LatestInsuranceListPaymentReceipt': 114,
    'SampleCarContract': 115,
    'LastEducationalCertificate': 116,
    'LastCompanyMemberEducationalCertificate': 117,
    'WhiteListExceptionImage': 120,
    'TransferPlateVehicleOwnershipCertificateImage': 121,
    'TransferPlateTechnicalLicensingImage': 122,
    'TransferPlateTehranemanTaxImage': 123,
    'TransferPlateDriverLicensingImage': 124,
    'TransferPlateNationalCardImage': 125,
    'TransferPlatePoliceClearanceCertificateImage': 126,
    'TransferPlateNonAddictionImage': 127,
    'ExitPublicPlatePowerOfAttorneyImage': 128,
    'ExitPublicPlateNationalCardImage': 129,
    'ExitPublicPlateOwnerShipCertificateImage': 130,
    'ExitPublicPlateTehranemanTaxImage': 131,
    'DriverLicensingImage': 132, //تصویر راننده مربوط به فرم پروانه اشتغال
    'DriverLicensingHealthCardImage': 133,
    'DriverLicensingNonAddictionImage': 134,
    'LeaseOrOwnershipDocumentOfTheCompanyImage': 135,
    'InsuranceListImage': 136,
    'DriverLicensingDrivingLicenseImage': 137, //  تصویر گواهینامه راننده مربوط به فرم پروانه اشتغال
    'MotorcycleTechnicalLicensingImage': 138, // معاینه فنی موتورسیکلت
    'MotorcycleHealthCardImage': 139, // معاینه فنی موتورسیکلت
    'MotorcyclePoliceClearanceCertificateImage': 140, // معاینه فنی موتورسیکلت
    'MotorcycleReagentGuaranteeImage': 141,
    'CompanyNotarizedPledgeImage': 142, // تعهدنامه محضری شرکت
    'AdminLicenseOwnerVisitReport': 143, // گزارش ادمین برای پروانه بهره برداری
    'DriverBackOfDriverLicenseImage': 144, //تصویر پشت گواهی نامه
    'DriverEndOfMilitaryServiceCardImage': 145, //تصویر کارت پایان خدمت سربازی
    'LicensingInsuranceImage': 146, // تصویر بیمه در پروانه فعالیت
    'LicensingLetterOfCommitment': 147, // تعهد نامه پروانه فعالیت      
    'ActivityLicensingBackgroundImage': 148, //     تصویر پس زمینه پروانه فعالیت 
    'DriverLicensingBackgroundImage': 149, //  تصویر پس زمینه پروانه اشتغال
    'ActivityLicensingOwnerImage': 150, //تصویر مالک پروانه فعالیت
    'ReceiptImage': 151, // تصویر فیش واریزی به حساب شهرداری
    'VehicleCardImage': 152, //تصویر روی کارت ماشین
    'VehicleCardBackImage': 153, //تصویر روی کارت ماشین
    'CarCommitmentGPSImg': 154, //تعهد نامه نصب تجهیزات
    'CarGoodWorkDoneImg': 155, // حسن انجام کار 
    'PrimissoryNoteImg': 156, // سفته
    'SmartEquipmentImg': 157, // کارت هوشمند
    'OldActivityLicImg': 159, // پروانه فعالیت
    'DriverGoodWorkDoneImg': 160, //حسن انجام کار راننده
    'HeadOfHouseHoldImg': 161, //سرپرست خانوار
    'HousbandFileImg': 162, // مشخصات همسر
    'IdentityFirstPageImg': 163, //صفحه اول شناسنامه
    'CompanyAllowdSignImg': 164, //آخرین روزنامه رسمی صاحبان دارای حق امضا
    'CompanyGuaranteeDocsImage': 165, // تضامین شرکت
    'CompanyManagerEndOfMilitaryServiceCardImage': 166, // پایان خدمت مدیرعامل
    'CompanyNavyListImage': 167, //نمونه لیست ناوگان پروانه بهره برداری

}


var GlobalSmsMessagesEnums = {
    'General': 1,
    'CompanyRejected': 101,
    'CompanyAccepted': 102,
    'CompanyIssued': 103,
    'CompanyCanceled': 104,
    'CompanyBeforeExpire': 105,
    'CompanyAfterExpired': 106,
    'CompanyPaymentPending': 107,
    'CompanyPaymentRejected': 108,
    'CompanyPaymentAccepted': 109,
    'CompanyUtcmsImported': 100,
    'CompanyChangeState': 111,
    'CompanyCustomMessage': 112,
    'VehicleLicensingRejected': 201,
    'VehicleLicensingAccepted': 202,
    'VehicleLicensingIssued': 203,
    'VehicleLicensingCanceled': 204,
    'VehicleLicensingBeforeExpire': 205,
    'VehicleLicensingAfterExpired': 206,
    'VehicleLicensingPaymentPending': 207,
    'VehicleLicensingPaymentRejected': 208,
    'VehicleLicensingPaymentAccepted': 209,
    'VehicleLicensingUtcmsImported': 210,
    'VehicleLicensingChangeState': 211,
    'VehicleLicensingCustomMessage': 212,
    'DriverLicensingRejected': 301,
    'DriverLicensingAccepted': 302,
    'DriverLicensingIssued': 303,
    'DriverLicensingCanceled': 304,
    'DriverLicensingBeforeExpire': 305,
    'DriverLicensingAfterExpired': 306,
    'DriverLicensingPaymentPending': 307,
    'DriverLicensingPaymentRejected': 308,
    'DriverLicensingPaymentAccepted': 309,
    'DriverLicensingUtcmsImported': 310,
    'DriverLicensingChangeState': 311,
    'DriverLicensingCustomMessage': 312,
    'TrafficLicensingRejected': 401,
    'TrafficLicensingAccepted': 402,
    'TrafficLicensingIssued': 403,
    'TrafficLicensingCanceled': 404,
    'TrafficLicensingBeforeExpire': 405,
    'TrafficLicensingAfterExpired': 406,
    'TrafficLicensingPaymentPending': 407,
    'TrafficLicensingPaymentRejected': 408,
    'TrafficLicensingPaymentAccepted': 409,
    'TrafficLicensingUtcmsImported': 410,
    'TrafficLicensingChangeState': 411,
    'TrafficLicensingCustomMessage': 412,
    'VoucherRejected': 501,
    'VoucherRejectedByUtcms': 502,
    'VoucherIssued': 503,
    'VoucherIssuedByUtcms': 504,
    'LicensingCustomMessage': 505,
    'TicketRegistered': 601,
    'TicketAnswered': 602,
    'TicketCustomMessage': 603,
    'TrolleyRegisteredVerifactionCode': 701,
    'TrolleyAccepted': 702,
    'TrolleyRehected': 703,
    'TrolleyCustomMessage': 704,
    'UserRegistrationSucceed': 801,
    'UserRegistrationVerifactionCode': 802,
    'UserRegistrationForgetPassword': 803,
    'UserRegistrationActivated': 804,
    'UserRegistrationErro': 805,
    'UserRegistrationCustomMessage': 806,
    'AdminPanelCustomMessage': 901,
    'AdminPanelMotorLink': 902,
    'ExitPlateCustomMessage': 1101,
    'ExitPlateAccept': 1102,
    'ExitPlateReject': 1103,
    'TransferPlateCustomMessage': 1201,
    'TransferPlateAccept': 1202,
    'TransferPlateReject': 1203,
}

var GlobalSubSystemsEnums = {
    'CompanyLicensing': 1,
    'VehicleLicensing': 2,
    'DriverLicensing': 3,
    'TrafficLicensing': 4,
    'Vouchers': 5,
    'Wallet': 6,
    'UserManagement': 7,
    'Avls': 8,
    'ExitPlate': 9,
    'TransferPlate': 10,
    'Ticket': 11,
    'Trolley': 12,
    'MotorcycleLicensing': 13,
    'General': 14,
    'OverLoad': 15,
    'Terminal': 16,
    'Others': 100
}




var UTCMSLicensingStatus = {
    0: '',
    1: 'پیش نویس ',
    2: 'در دست بررسی',
    3: 'تایید شده',
    4: 'رد درخواست',
    5: 'پروانه صادر شده است',
    6: 'پروانه تمدید شده است',
    7: 'پروانه منقضی شده است',
    8: 'پروانه باطل شده است',
    9: 'حذف شده',
    10: 'ویرایش شده',
    11: 'در انتظار دریافت اطلاعات',
    12: 'تایید بازرسی',
    13: 'بایگانی'


}



function isJson(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}


function isObject(obj) {
    return obj != null && obj.constructor.name === "Object";
}




function easyuiIsANumberTextbox(newValue, oldValue) {
    alert(newValue);
}


function easyuiNumberFormatter(v) {

    return s;
}

function easyuiNumberParser(s) {
    return s;
}


function logout() {
    $.messager.confirm('پیام سیستم', 'آیا برای خروج از سیستم اطمینان دارید؟', function(r) {
        if (r) {
            $.ajax({
                url: '/CoreServices/API/Login/OwinLogout',
                type: 'get',
                contentType: 'application/json',
                success: function(data) {
                    window.top.location.replace(data);
                },
                error: function(xhr, textStatus, errorThrown) {
                    window.top.location.replace("/login.aspx");
                }
            });
        }
    });
    return false;

}

function GetAllQueryString(inputUrl) {

    var queryStringArr = {};
    var url = location.search.substr(1).split("&");
    if (inputUrl != undefined) {
        inputUrlArr = inputUrl.split('?');
        if (inputUrlArr.length == 1)
            return queryStringArr;
        else
            url = inputUrlArr[1].split("&");

    }

    url.forEach(function(pair) {
        if (pair === "") return;
        var parts = pair.split("=");

        if (parts[0].indexOf('[]') > 0) {
            if (queryStringArr[parts[0]] == undefined)
                queryStringArr[parts[0]] = [];
            queryStringArr[parts[0]].push(parts[1]);
        } else
            queryStringArr[parts[0]] = parts[1] && decodeURIComponent(parts[1].replace(/\+/g, " "));
    });
    return queryStringArr;
};

function showAjaxErrorMessage(xhr, textStatus, errorThrown) {

    var title = "پیام سیستم";
    var message = 'خطا در دریافت اطلاعات';
    if (errorThrown == 'Unauthorized') {
        message = 'شما دسترسی به این عملیات را ندارید';
        showErrorMessage(message, 'error', title);
        window.top.location.replace("/login.aspx");
    }

    showErrorMessage(message, 'error', title);
}

function showErrorMessage(message, errorType, title) {




    if (errorType == null)
        errorType = 'error';

    if (title == null)
        title = 'error';

    $.messager.alert(title, message, errorType);
}

if (!String.prototype.endsWith) {
    String.prototype.endsWith = function(searchString, position) {
        var subjectString = this.toString();
        if (typeof position !== 'number' || !isFinite(position) || Math.floor(position) !== position || position > subjectString.length) {
            position = subjectString.length;
        }
        position -= searchString.length;
        var lastIndex = subjectString.indexOf(searchString, position);
        return lastIndex !== -1 && lastIndex === position;
    };
}

function toEnglishNum(num, dontTrim) {

    //if (num == null || num == 'undefined') return null;
    var i = 0,
        j = 0,
        dontTrim = dontTrim || false,
        num = dontTrim ? num.toString() : num.toString().trim(),
        len = num.length,
        res = '',
        pos,
        persianNumbers = typeof persianNumber == 'undefined' ? ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'] :
        persianNumbers;

    for (; i < len; i++)
        if (~(pos = persianNumbers.indexOf(num.charAt(i))))
            res += pos;
        else
            res += num.charAt(i);
    return res;
};


function restrictAccess(formId, elementsSelectorList = []) {
    var absolutePath = window.top.location.pathname;
    $.ajax({
        url: '/CoreServices/API/ApplicationPages/CheckRestrictAccess',
        type: 'GET',
        contentType: 'application/json',
        data: {
            path: absolutePath
        },
        success: function(data) {
            //

            if (data) {
                if (data == true) {
                    return;
                }
                if (data.IsShow) {
                    //Ok  
                } else {
                    //UnAuthorize
                    window.top.location.href = '/ErrorPages/403.aspx';
                }

                if (data.IsEdit) {
                    //Ok
                    return;
                } else {
                    //UnAuthorize to Modify
                    //

                    //$.each($(containerSelector).find("input, button, textarea, select,a,span"), function (index, value) {
                    //    $(value).prop("disabled", true);
                    //    $(value).linkbutton('disable');
                    // //   $(value).css("display", "none");
                    //});

                    if (formId) {
                        $(formId).form("disable");
                    }

                    elementsSelectorList.map((value, index) => {
                        $(value).prop("disabled", true);
                        try {
                            //$(value).linkbutton('disable');
                            //$(value).textbox('disable');
                            //$(value).combobox('disable'); 
                            /// $(containerSelector).form("disable");

                        } catch (e) {
                            //continue;
                        }
                    });
                }



                return;
            }

            window.top.location.href = '/ErrorPages/403.aspx';


        },
        error: function() {
            //
        }
    });
}

try {

    if ($.fn.form) {
        $.extend($.fn.form.methods, {
            disable: function(jq) {
                return jq.each(function() {
                    var t = $(this);
                    t.find('input')._propAttr('disabled', 'disabled');
                    var plugins = ['combo', 'combobox', 'combotree', 'combogrid', 'datebox', 'datetimebox', 'spinner', 'timespinner', 'numberbox', 'numberspinner', 'slider', "textbox", "linkbutton"];
                    for (var i = 0; i < plugins.length; i++) {
                        var plugin = plugins[i];
                        var r = t.find('.' + plugin + '-f');
                        if (r.length && r[plugin]) {
                            r[plugin]('disable');
                        }
                    }
                    t.form('validate');
                })
            }
        })
    }
} catch (e) {

}



function getPlateNo(showAlert, txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

    var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
    var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).combobox('getValue'));
    var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
    var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());


    if (onePlateNo === 0 && twoPlateNo === -1 && threePlateNo === 0 && iranPlateNo === 0) {
        return '';
    }

    var isPlateOK = (onePlateNo !== 0 && twoPlateNo !== -1 && threePlateNo !== 0 && iranPlateNo !== 0);
    if (!isPlateOK) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
            return 'error';
        }
    }


    var isValidValue = true;

    if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
        isValidValue = false;

    if (twoPlateNo == -1)
        isValidValue = false;

    if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
        isValidValue = false;

    if (iranPlateNo < 10 || iranPlateNo > 99)
        isValidValue = false;

    if (isValidValue == false) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    if (twoPlateNo.toString().length == 1)
        twoPlateNo = '0' + twoPlateNo.toString();

    var plateNo = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

    if (plateNo.length != 9) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    return plateNo;

}

function getPlateNoBoot(showAlert, txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

    var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
    var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).val());
    var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
    var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());



    if (onePlateNo === 0 && twoPlateNo === -1 && threePlateNo === 0 && iranPlateNo === 0) {
        return '';
    }

    var isPlateOK = (onePlateNo !== 0 && twoPlateNo !== -1 && threePlateNo !== 0 && iranPlateNo !== 0);
    if (!isPlateOK) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
            return 'error';
        }
    }


    var isValidValue = true;

    if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
        isValidValue = false;

    if (twoPlateNo == -1)
        isValidValue = false;

    if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
        isValidValue = false;

    if (iranPlateNo < 10 || iranPlateNo > 99)
        isValidValue = false;

    if (isValidValue == false) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    if (twoPlateNo.toString().length == 1)
        twoPlateNo = '0' + twoPlateNo.toString();

    var plateNo = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

    if (plateNo.length != 9) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    return plateNo;

}

function getPlateNoEu(showAlert, txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

    var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
    var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).combobox('getValue'));
    var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
    var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());

    if (onePlateNo === 0 && twoPlateNo === -1 && threePlateNo === 0 && iranPlateNo === 0) {
        return '';
    }

    var isPlateOK = (onePlateNo !== 0 && twoPlateNo !== -1 && threePlateNo !== 0 && iranPlateNo !== 0);
    if (!isPlateOK) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
            return 'error';
        }
    }

    var isValidValue = true;

    if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
        isValidValue = false;

    if (twoPlateNo == -1)
        isValidValue = false;

    if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
        isValidValue = false;

    if (iranPlateNo < 10 || iranPlateNo > 99)
        isValidValue = false;

    if (isValidValue == false) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    if (twoPlateNo.toString().length == 1)
        twoPlateNo = '0' + twoPlateNo.toString();

    var plateNo = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

    if (plateNo.length != 9) {
        if (showAlert === true) {
            $.messager.alert('خطا', 'پلاک وارد شده اشتباه می باشد.', 'error');
        }
        return 'error';
    }

    return plateNo;

}




function initDefaultFileBox(id, previewBtnId, previewImgId, imgDialogId, required, maxSize = 409600) {

    var selector = '#' + id;

    if (typeof previewBtnId === 'undefined') {
        previewBtnId = selector + 'PreviewBtn';
    }

    if (typeof previewImgId === 'undefined') {
        previewImgId = selector + 'Preview';
    }

    if (typeof imgDialogId === 'undefined') {
        imgDialogId = selector + 'Img';
    }

    if (typeof required === "undefined") {
        required = false;
    }


    $(selector).filebox({
        accept: 'image/jpeg,image/png',
        onChange: function myfunction() {
            var input = $(selector).next().find('.textbox-value')[0];
            var size = input.files[0].size;
            //
            if (size > maxSize) {
                $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 400 کیلوبایت میباشد', 'warning');
                return;
            }
            //var size= alert($('#fuAttachLicense').input.files[0].size);
            if (input.files && input.files[0]) {

                $(previewBtnId).attr('src', "/Resources/Dist/Images/large_picture.png");
                $(previewBtnId).click(function() {
                    $(imgDialogId).dialog('open');
                });
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(previewImgId).attr('src', e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        },
        required: required
    });

}


if ($.fn.datagrid) {
    $.extend($.fn.datagrid.methods, {

        toHtml: function(jq, style) {
            return jq.each(function() {
                var format = function(s, c) {
                    return s.replace(/{(\w+)}/g, function(m, p) {
                        return c[p];
                    })
                }
                var template = '<html ><head><style>{style}</style></head><body><table  >{table}</table></body></html>';
                var alink = $('<a style="display:none"></a>').appendTo('body');
                var view = $(this).datagrid('getPanel').find('div.datagrid-view');
                var table = view.find('div.datagrid-view2 table.datagrid-btable').clone();
                var theader = view.find('.datagrid-header-row').clone();
                var tbody = table.find('>tbody');
                table.prepend(theader);
                view.find('div.datagrid-view1 table.datagrid-btable>tbody>tr').each(function(index) {
                    $(this).clone().children().prependTo(tbody.children('tr:eq(' + index + ')'));
                });

                var style = style ||
                    " table {border:1px solid #aaa;  }  td {white-space: nowrap;border:1px solid #ddd; font-family:Tahoma;}  .datagrid-header-row { background-color:#eee; } "
                var lista = {
                    style: style,
                    table: table.html()
                }
                var dd = format(template, lista)
                var w = window.open('');
                w.document.write(dd);

            });
        }
    });
}



function CreateFormPage(strPrintName, printDatagrid) {
    var tableString = '<p style="text-align:center;">' + strPrintName + '</p><table id="mainPrintingTable" cellspacing="0" class="pb">';
    var frozenColumns = printDatagrid.datagrid("options").frozenColumns;
    var columns = printDatagrid.datagrid("options").columns;
    var nameList = '';

    // Load title
    if (typeof columns != 'undefined' && columns != '') {
        $(columns).each(function(index) {
            tableString += '\n<tr>';
            if (typeof frozenColumns != 'undefined' && typeof frozenColumns[index] != 'undefined') {
                for (var i = frozenColumns[index].length - 1; i >= 1; --i) {
                    if (!frozenColumns[index][i].hidden) {
                        tableString += '\n<th width="' + frozenColumns[index][i].width + '"';
                        if (typeof frozenColumns[index][i].rowspan != 'undefined' && frozenColumns[index][i].rowspan > 1) {
                            tableString += ' rowspan="' + frozenColumns[index][i].rowspan + '"';
                        }
                        if (typeof frozenColumns[index][i].colspan != 'undefined' && frozenColumns[index][i].colspan > 1) {
                            tableString += ' colspan="' + frozenColumns[index][i].colspan + '"';
                        }
                        if (typeof frozenColumns[index][i].field != 'undefined' && frozenColumns[index][i].field != '') {
                            nameList += ',{"f":"' + frozenColumns[index][i].field + '", "a":"' + frozenColumns[index][i].align + '"}';
                        }
                        tableString += '>' + frozenColumns[0][i].title + '</th>';
                    }
                }
            }
            for (var i = columns[index].length - 1; i >= 1; --i) {
                if (!columns[index][i].hidden) {
                    tableString += '\n<th width="' + columns[index][i].width + '"';
                    if (typeof columns[index][i].rowspan != 'undefined' && columns[index][i].rowspan > 1) {
                        tableString += ' rowspan="' + columns[index][i].rowspan + '"';
                    }
                    if (typeof columns[index][i].colspan != 'undefined' && columns[index][i].colspan > 1) {
                        tableString += ' colspan="' + columns[index][i].colspan + '"';
                    }
                    if (typeof columns[index][i].field != 'undefined' && columns[index][i].field != '') {
                        nameList += ',{"f":"' + columns[index][i].field + '", "a":"' + columns[index][i].align + '"}';
                    }
                    tableString += '>' + columns[index][i].title + '</th>';
                }
            }
            tableString += '\n</tr>';
        });
    }

    // Load content
    var rows = printDatagrid.datagrid("getRows");
    var nl = eval('([' + nameList.substring(1) + '])');
    for (var i = 0; i < rows.length; ++i) {
        tableString += '\n<tr>';
        $(nl).each(function(j) {
            var e = nl[j].f.lastIndexOf('_0');

            tableString += '\n<td';
            if (nl[j].a != 'undefined' && nl[j].a != '') {
                tableString += ' style="text-align:' + nl[j].a + ';"';
            }
            tableString += '>';
            if (e + 2 == nl[j].f.length) {
                tableString += rows[i][nl[j].f.substring(0, e)];
            } else
                tableString += rows[i][nl[j].f];
            tableString += '</td>';
        });
        tableString += '\n</tr>';
    }

    // Load footer
    var footer = printDatagrid.datagrid('options').footer;
    if (footer) {
        tableString += '<tr>';
        for (var i = 0; i < footer.length; i++) {
            tableString += '<td>' + footer[i] + '</td>';
        }
        tableString += '</tr>';
    }

    tableString += '\n</table>';
    var height = window.outerHeight;
    var width = window.outerWidth;
    var modal = window.open("/DesktopModules/Baraneh/CSS/print.html", null, "width=" + width + ",height=" + height + ",modal=yes,alwaysRaised=yes", null);
    modal.dialogArguments = tableString;
}



getPersianDate = (format) => {
    let week = new Array("يكشنبه", "دوشنبه", "سه شنبه", "چهارشنبه", "پنج شنبه", "جمعه", "شنبه")
    let months = new Array("فروردين", "ارديبهشت", "خرداد", "تير", "مرداد", "شهريور", "مهر", "آبان", "آذر", "دي", "بهمن", "اسفند");
    let today = new Date();
    let d = today.getDay();
    let day = today.getDate();
    let month = today.getMonth() + 1;
    let year = today.getYear();
    year = (window.navigator.userAgent.indexOf('MSIE') > 0) ? year : 1900 + year;
    if (year == 0) {
        year = 2000;
    }
    if (year < 100) {
        year += 1900;
    }
    y = 1;
    for (i = 0; i < 3000; i += 4) {
        if (year == i) {
            y = 2;
        }
    }
    for (i = 1; i < 3000; i += 4) {
        if (year == i) {
            y = 3;
        }
    }
    if (y == 1) {
        year -= ((month < 3) || ((month == 3) && (day < 21))) ? 622 : 621;
        switch (month) {
            case 1:
                (day < 21) ? (month = 10, day += 10) : (month = 11, day -= 20);
                break;
            case 2:
                (day < 20) ? (month = 11, day += 11) : (month = 12, day -= 19);
                break;
            case 3:
                (day < 21) ? (month = 12, day += 9) : (month = 1, day -= 20);
                break;
            case 4:
                (day < 21) ? (month = 1, day += 11) : (month = 2, day -= 20);
                break;
            case 5:
            case 6:
                (day < 22) ? (month -= 3, day += 10) : (month -= 2, day -= 21);
                break;
            case 7:
            case 8:
            case 9:
                (day < 23) ? (month -= 3, day += 9) : (month -= 2, day -= 22);
                break;
            case 10:
                (day < 23) ? (month = 7, day += 8) : (month = 8, day -= 22);
                break;
            case 11:
            case 12:
                (day < 22) ? (month -= 3, day += 9) : (month -= 2, day -= 21);
                break;
            default:
                break;
        }
    }
    if (y == 2) {
        year -= ((month < 3) || ((month == 3) && (day < 20))) ? 622 : 621;
        switch (month) {
            case 1:
                (day < 21) ? (month = 10, day += 10) : (month = 11, day -= 20);
                break;
            case 2:
                (day < 20) ? (month = 11, day += 11) : (month = 12, day -= 19);
                break;
            case 3:
                (day < 20) ? (month = 12, day += 10) : (month = 1, day -= 19);
                break;
            case 4:
                (day < 20) ? (month = 1, day += 12) : (month = 2, day -= 19);
                break;
            case 5:
                (day < 21) ? (month = 2, day += 11) : (month = 3, day -= 20);
                break;
            case 6:
                (day < 21) ? (month = 3, day += 11) : (month = 4, day -= 20);
                break;
            case 7:
                (day < 22) ? (month = 4, day += 10) : (month = 5, day -= 21);
                break;
            case 8:
                (day < 22) ? (month = 5, day += 10) : (month = 6, day -= 21);
                break;
            case 9:
                (day < 22) ? (month = 6, day += 10) : (month = 7, day -= 21);
                break;
            case 10:
                (day < 22) ? (month = 7, day += 9) : (month = 8, day -= 21);
                break;
            case 11:
                (day < 21) ? (month = 8, day += 10) : (month = 9, day -= 20);
                break;
            case 12:
                (day < 21) ? (month = 9, day += 10) : (month = 10, day -= 20);
                break;
            default:
                break;
        }
    }
    if (y == 3) {
        year -= ((month < 3) || ((month == 3) && (day < 21))) ? 622 : 621;
        switch (month) {
            case 1:
                (day < 20) ? (month = 10, day += 11) : (month = 11, day -= 19);
                break;
            case 2:
                (day < 19) ? (month = 11, day += 12) : (month = 12, day -= 18);
                break;
            case 3:
                (day < 21) ? (month = 12, day += 10) : (month = 1, day -= 20);
                break;
            case 4:
                (day < 21) ? (month = 1, day += 11) : (month = 2, day -= 20);
                break;
            case 5:
            case 6:
                (day < 22) ? (month -= 3, day += 10) : (month -= 2, day -= 21);
                break;
            case 7:
            case 8:
            case 9:
                (day < 23) ? (month -= 3, day += 9) : (month -= 2, day -= 22);
                break;
            case 10:
                (day < 23) ? (month = 7, day += 8) : (month = 8, day -= 22);
                break;
            case 11:
            case 12:
                (day < 22) ? (month -= 3, day += 9) : (month -= 2, day -= 21);
                break;
            default:
                break;
        }
    }
    if (format === null || format === undefined)
        return `${week[d]} ${day} ${months[month - 1]} ${year}`;
    if (format === "y/m/d")
        return `${year}/${month}/${day}`;
    if (format === "d/m/y")
        return `${day}/${month}/${year}`;
}

function Base64toBlob(b64Data, contentType, sliceSize) {
    contentType = contentType || '';
    sliceSize = sliceSize || 512;

    var byteCharacters = atob(b64Data);
    var byteArrays = [];

    for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
        var slice = byteCharacters.slice(offset, offset + sliceSize);

        var byteNumbers = new Array(slice.length);
        for (var i = 0; i < slice.length; i++) {
            byteNumbers[i] = slice.charCodeAt(i);
        }

        var byteArray = new Uint8Array(byteNumbers);

        byteArrays.push(byteArray);
    }
    var blob = new Blob(byteArrays, {
        type: contentType
    });
    return blob;
}

//function Append_Pdf(containerId, base64) {
//    /*var elm = containerId.replace('#', '');
//    var blob = Base64toBlob(base64, 'application/pdf');
//    var url = URL.createObjectURL(blob);

//    var viewer = '<iframe id = "' + elm + '-pdf-js-viewer" src = "/Resources/plugins/pdfjs-4.5.136-legacy/web/viewer.html?file=' + encodeURIComponent(url) + '"  frameborder = "0" width = "98%" height = "98%" style=" overflow:auto; display:block;"></iframe>';

//    $(containerId).append(viewer);*/

//    if (!$(containerId).length) {
//        console.warn("Container not found:", containerId);
//        return;
//    }
    
//    // Check visibility
//    if ($(containerId).css("display") === "none") {
//        $(containerId).css("display", "block");
//    }

//    $(containerId).css("position", "relative");
    
//    var elm = containerId.replace('#', '');
//    var blob = Base64toBlob(base64, 'application/pdf');
//    var url = URL.createObjectURL(blob);

//    var viewer = '<iframe id="' + elm + '-pdf-js-viewer" src="/Resources/plugins/pdfjs-4.5.136-legacy/web/viewer.html?file=' + encodeURIComponent(url) + '" frameborder="0" width="98%" height="98%"></iframe>';
//    $(containerId).append(viewer);
//}

function Append_Pdf(containerId, base64) {
    if (!$(containerId).length) {
        console.warn("Container not found:", containerId);
        return;
    }

    // Check visibility
    if ($(containerId).css("display") === "none") {
        $(containerId).css("display", "block");
    }

    $(containerId).css("position", "relative");

    var elm = containerId.replace('#', '');
    var blob = Base64toBlob(base64, 'application/pdf');
    var url = URL.createObjectURL(blob);

    var viewer = '<iframe id="' + elm + '-pdf-js-viewer" src="/Resources/plugins/pdfjs-4.5.136-legacy/web/viewer.html?file=' + encodeURIComponent(url) + '" frameborder="0" width="98%" height="98%"></iframe>';
    $(containerId).append(viewer);

    // Ensure the iframe is attached to the DOM and visible before scrolling
    var iframe = document.getElementById(elm + '-pdf-js-viewer');
    if (iframe) {
        scrollElementIntoView(iframe);
    }
}

function scrollElementIntoView(element) {
    if (!element) {
        console.error("Element is not defined.");
        return;
    }

    // Check if the element is attached to the DOM
    if (!document.body.contains(element)) {
        console.error("Element is not attached to the DOM.");
        return;
    }

    // Check if the element is visible
    //if (element.offsetParent === null) {
    //    console.error("Element is not visible.");
    //    return;
    //}

    // Scroll the element into view
    element.scrollIntoView({ behavior: 'smooth', block: 'center' });
}

function IFPDF(elementId) {
    /*if ($('#' + elementId + 'PDFOBJECT iframe').length > 0) {
        $('#' + elementId + 'Pdf_dialog').dialog('open').dialog('center');
        return;
    }

    if ($('#' + elementId + 'Preview').attr("src") !== "#" && $('#' + elementId + 'Preview').attr("src") !== "") {
        $('#' + elementId + 'Img').dialog('open').dialog('center');
        return;
    }

    $('#' + elementId + 'Pdf_dialog').dialog('open').dialog('center');*/

    const dialog = $('#' + elementId + 'Pdf_dialog');
    
    if ($('#' + elementId + 'PDFOBJECT iframe').length > 0) {
        dialog.dialog('open').dialog('center');
        return;
    }

    if ($('#' + elementId + 'Preview').attr("src") !== "#" && $('#' + elementId + 'Preview').attr("src") !== "") {
        $('#' + elementId + 'Img').dialog('open').dialog('center');
        return;
    }

    dialog.dialog('open').dialog('center');
    
    // Adding a small delay before initializing the viewer for smoother display
    setTimeout(() => {
        dialog.dialog('open').dialog('center');
    }, 100);

}

function LoadImagePdfAttachment(elementId, fId, typeId) {

    $.ajax({
        url: '/CoreServices/API/FileAttachments/FileDetailsById',
        type: 'GET',
        data: {
            foreignKeyId: fId,
            typeId: typeId
        },
        success: function(data) {

            if (data === null) {
                return;
            }
            if (!data.IsSuccessful) {
                return;
            }

            var imgProfile = data.ReturnValue;

            $("#" + elementId + "Status").css("display", "block");
            $('#' + elementId + 'PreviewBtn').attr('src', "/Resources/dist/Images/large_picture.png");
            if (imgProfile.Extension.toLowerCase().includes("pdf")) {
                var idd = '#' + elementId + 'PDFOBJECT';
                Append_Pdf(idd, imgProfile.FileContent);
                let btn = document.getElementById(elementId + 'PreviewBtn');
                btn.addEventListener("click", IFPDF.bind(null, elementId));
                $('#' + elementId + 'PreviewBtn').removeAttr('data-magnify');

                return;
            }

            $('#' + elementId + 'PreviewBtn').attr('data-src', "data:image/png;base64," + data.ReturnValue.FileContent);
            $('#' + elementId + 'PreviewBtn').click(function() {
                $("[data-magnify=gallery]").magnify(defaultOpts);
            });

        },
        error: function(xhr, textStatus, errorThrown) {
            showAjaxErrorMessage(xhr, textStatus, errorThrown);
            return;
        }
    });
}

function LoadImagePdfAttachmentByGUID(elementId, guid, typeId) {

    $.ajax({
        url: '/Companies/API/Attachments/FileDetailsByGUID',
        type: 'GET',
        data: {
            guid: guid,
            attachmentTypeId: typeId
        },
        success: function(data) {

            if (data === null) {
                return;
            }
            if (!data.IsSuccessful) {
                return;
            }

            var imgProfile = data.ReturnValue;

            $("#" + elementId + "Status").css("display", "block");
            $('#' + elementId + 'PreviewBtn').attr('src', "/Resources/dist/Images/large_picture.png");
            if (imgProfile.Extension.toLowerCase().includes("pdf")) {
                var idd = '#' + elementId + 'PDFOBJECT';
                Append_Pdf(idd, imgProfile.FileContent);
                let btn = document.getElementById(elementId + 'PreviewBtn');
                btn.addEventListener("click", IFPDF.bind(null, elementId));
                $('#' + elementId + 'PreviewBtn').removeAttr('data-magnify');

                return;
            }

            $('#' + elementId + 'PreviewBtn').attr('data-src', "data:image/png;base64," + data.ReturnValue.FileContent);
            $('#' + elementId + 'PreviewBtn').click(function() {
                $("[data-magnify=gallery]").magnify(defaultOpts);
            });

        },
        error: function(xhr, textStatus, errorThrown) {
            showAjaxErrorMessage(xhr, textStatus, errorThrown);
            return;
        }
    });
}