﻿// Select2 Extension ***************************************************************************

$.fn.select2Fill = function (options) {
    const valueField = options.valueField || 'id';
    const textField = options.textField || 'text';
    const data = options.data || [];

    this.each(function () {
        const $select = $(this);
        data.forEach(function (item) {
            const $option = $('<option>').val(item[valueField]).text(item[textField]);
            $select.append($option);
        });
    });

    if ($(this).prop('required')) {
        return this.select2({
            theme: 'bootstrap4'
        }).on('select2:select', function () {
            if ($(this).val()) {
                $(this).removeClass('is-invalid').addClass('is-valid'); // Add 'is-valid' on selection
            } else {
                $(this).removeClass('is-valid').addClass('is-invalid');
            }
        }).val(null).trigger('change').addClass('is-invalid');
    }
    return this.select2();
};

$.fn.select2FillServiceResult = function (options) {
    const $select = $(this);
    $.ajax({
        url: options.url,
        type: options.method,
        success: function (response) {
            if (response.IsSuccessful) {
                $select.select2Fill({
                    valueField: options.valueField,
                    textField: options.textField,
                    data: response.ReturnValue
                });
            }
        },
        error: function (xhr, textStatus, errorThrown) {
            console.error(`Error fetching data from ${options.url}: ${textStatus} - ${errorThrown}`);
        }
    });
};

$.fn.select2FillList = function (options) {
    const $select = $(this);
    $.ajax({
        url: options.url,
        type: options.method,
        success: function (response) {
            if (response) {
                $select.select2Fill({
                    valueField: options.valueField,
                    textField: options.textField,
                    data: response
                });
            }
        },
        error: function (xhr, textStatus, errorThrown) {
            console.error(`Error fetching data from ${options.url}: ${textStatus} - ${errorThrown}`);
        }
    });
};

// EasyUi Extension
$.fn.extend({
    initializeGrid: function (customConfig) {
        // Base configuration
        const baseConfig = {
            filterBtnPosition: 'left',
            remoteFilter: true,
            method: 'get',
            fitColumns: true,
            fit: true,
            singleSelect: true,
            collapsible: true,
            pagination: true,
            clientPaging: false,
            pageSize: 15,
            pageList: [15, 30, 50, 100, 99999],
            rownumbers: true,
            loadMsg: 'لطفا کمی صبر کنید',
        };

        // Merge the base config with customConfig
        const finalConfig = $.extend(true, baseConfig, customConfig);

        // Initialize the grid using the final configuration
        return this.datagrid(finalConfig);
    }
});

// dpEdit Extension

// Set Default Value
(function ($) {
    $.fn.dpSetFaValue = function (param) {
        this.filter('.dpTextBox').each(function () {
            if (param === '' || param === undefined || param === null) return false;
            const y = parseInt(param.substring(0, 4));
            const m = parseInt(param.substring(5, 7));
            const d = parseInt(param.substring(8, 10));

            $(this).MdPersianDateTimePicker('setDatePersian', {
                year: y,
                month: m,
                day: d
            });
        });
        return this;
    };
}(jQuery));


//Get dp Value with English numbers :

(function ($) {
    $.fn.dpGetEnValue = function () {
        let result = null;
        this.filter('.dpTextBox').each(function () {
            try {
                const value = toEnglishNumber($(this).val());
                if (value) {
                    result = value;
                }
            } catch (error) {
                console.error(`Error converting value to English number: ${error.message}`);
            }
        });
        return result;
    };
}(jQuery));

