﻿# PowerShell script to remove signing from all .csproj files in the solution
Get-ChildItem -Recurse -Filter "*.csproj" | ForEach-Object {
    $file = $_.FullName
    (Get-Content $file) -replace "<SignAssembly>true</SignAssembly>", "" `
                        -replace "<AssemblyOriginatorKeyFile>.*?<\/AssemblyOriginatorKeyFile>", "" `
    | Set-Content $file
    Write-Host "Updated $file"
}
