﻿# Get all project directories
$projects = Get-ChildItem -Recurse -Filter *.csproj

foreach ($project in $projects) {
    # Get the project directory
    $projectDir = Split-Path $project.FullName

    # Define the Interfaces folder path
    $interfacesFolder = Join-Path $projectDir "Interfaces"

    # Check if the Interfaces folder exists, if not, create it
    if (-Not (Test-Path $interfacesFolder)) {
        New-Item -ItemType Directory -Path $interfacesFolder
        Write-Output "Created Interfaces folder in $projectDir"
    } else {
        Write-Output "Interfaces folder already exists in $projectDir"
    }
}
