﻿# Define the folder variable containing the path to your HTML files
$folder = "E:\UnderConstruction\Baraneh4\Branch-Dev\Baraneh.Web.UI\AdminBaraneh"

# Function to extract content between specific tags
function Extract-ContentBetweenTags {
    param (
        [string]$content,
        [string]$startTag,
        [string]$endTag
    )

    # Use regex to extract content between start and end tags
    $pattern = [regex]::Escape($startTag) + "(.*?)" + [regex]::Escape($endTag)
    $match = [regex]::Match($content, $pattern, [System.Text.RegularExpressions.RegexOptions]::Singleline)

    if ($match.Success) {
        return $match.Groups[1].Value.Trim()
    }

    return ""
}

# Process each HTML file in the folder and subfolders
Get-ChildItem -Path $folder -Recurse -Filter *.html | ForEach-Object {
    $htmlFile = $_
    $aspxFilePath = [System.IO.Path]::ChangeExtension($htmlFile.FullName, ".aspx")

    # Check if the .aspx file already exists, if so, delete it
    if (Test-Path $aspxFilePath) {
        Remove-Item $aspxFilePath -Force
        Write-Host "Deleted existing .aspx file: $aspxFilePath"
    }

    # Read the content of the HTML file
    $content = Get-Content $htmlFile.FullName -Raw

    # 1. Extract valid <style> contents (not commented)
    $styleMatches = [regex]::Matches($content, '(?<!<!--)\s*<style>(.*?)</style>(?!-->)', [System.Text.RegularExpressions.RegexOptions]::Singleline)
    $validStyles = ""

    foreach ($styleMatch in $styleMatches) {
        $validStyles += $styleMatch.Groups[1].Value.Trim() + "`n"
    }

    # 2. Extract body content excluding <style> and <script> tags
    $bodyContent = Extract-ContentBetweenTags $content "<body>" "</body>"
    
    # Remove <style> and <script> tags from body content
    $bodyContent = [regex]::Replace($bodyContent, '<style.*?>.*?</style>', '', [System.Text.RegularExpressions.RegexOptions]::Singleline).Trim()
    $bodyContent = [regex]::Replace($bodyContent, '<script.*?>.*?</script>', '', [System.Text.RegularExpressions.RegexOptions]::Singleline).Trim()

    # 3. Extract <script> tags within the <body> tag
    $scriptMatches = [regex]::Matches($content, '<body.*?>(.*?)</body>', [System.Text.RegularExpressions.RegexOptions]::Singleline)
    $bodyScripts = ""
    
    if ($scriptMatches.Count -gt 0) {
        $scriptsContent = $scriptMatches[0].Groups[1].Value
        $scriptMatchesInBody = [regex]::Matches($scriptsContent, '<script.*?>.*?</script>', [System.Text.RegularExpressions.RegexOptions]::Singleline)

        foreach ($scriptMatch in $scriptMatchesInBody) {
            $bodyScripts += $scriptMatch.Value + "`n"
        }
    }

    # Build the new content for the ASPX file
    # Fix duplicate quotes and ensure correct encoding
    $newContent = @"
<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    $validStyles
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    $bodyContent
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    $bodyScripts

    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>
"@ -replace '\r?\n', "`r`n"  # Normalize to Windows CR LF line endings

    # Write the new content to the .aspx file with UTF-8 encoding
    [System.IO.File]::WriteAllText($aspxFilePath, $newContent, [System.Text.Encoding]::UTF8)

    Write-Host "Converted $($htmlFile.FullName) to $aspxFilePath"
}

Write-Host "Conversion completed!"
