﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true" CodeBehind="Login.aspx.cs" Inherits="Baraneh.Web.UI.Login" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        .login-container {
            width: 95%;
            max-width: 600px; /* Increased from 400px */
            margin: 0 auto;
            padding: 2rem 0;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .login-container {
                width: 90%;
                min-width: 280px;
            }
        }

        .card {
            border: none;
            box-shadow: 0 0 20px rgba(0,0,0,0.08);
            border-radius: 15px;
            overflow: hidden;
            transition: transform 0.2s;
        }

        /* .card:hover {
            transform: translateY(-5px);
        } */

        .card-header {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
            padding: 1.5rem;
        }

        .card-header h3 {
            color: white;
            font-size: 1.5rem;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }

        .card-body {
            padding: 2rem 2rem 0 2rem;
        }

        .input-field {
            border: 1px solid #ced4da;  /* Bootstrap default border color */
            border-radius: 0.25rem;     /* Bootstrap default border radius */
            display: flex;
            align-items: center;
            padding: 0.375rem 0.75rem;  /* Bootstrap default padding */
            position: relative;
            margin-bottom: 1rem;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
            background: #f8f9fa;
            transition: all 0.3s ease;
        }

        .input-field:focus-within {
            border-color: #86b7fe;      /* Bootstrap default focus border color */
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13,110,253,.25); /* Bootstrap default focus shadow */
        }

        .input-field:hover {
            background: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .input-field input {
            border: none;
            outline: none;
            width: 100%;
            box-shadow: none;
            text-align: center;
            direction: ltr;
            padding: 0;                 /* Remove default input padding */
            background: transparent;     /* Remove default input background */
            background-color: transparent !important;
            font-family: 'Vazirmatn' !important;
            font-size: 1.1rem !important;
        }

        .input-field .icon {
            color: dimgray;
            padding: 2px;
        }

        .toggle-password {
            cursor: pointer;
            position: absolute;
            left: 10px;
            color: dimgray;
        }

        .captcha-section {
            text-align: center;
            padding: 1rem 1rem 0 1rem;
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            /*margin: 1rem 0;*/
        }

        .captcha-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
            padding: 0.5rem;     /* Added padding for better spacing */
        }

        .captcha-wrapper img {
            width:60; /* Increased from 160px */
            height: auto;
            object-fit: contain;
        }

        .refresh-btn {
            background: none;
            border: none;
            color: dimgray;
            cursor: pointer;
            font-size: 1.125rem;
            color: #0093E9;
            transition: transform 0.3s ease;
        }

        .refresh-btn:hover {
            transform: rotate(180deg);
        }

        .captcha-input {
            width: 80%;
            margin: 0 auto;
        }

        .captcha-input input {
            text-align: center !important;
            direction: ltr !important;
            width: 100%;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            padding: 0.375rem 0.75rem;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
            background-color: transparent !important;
            font-family: 'Vazirmatn' !important;
            font-size: 1.1rem !important;
        }

        .captcha-input input:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13,110,253,.25);
        }

        .office-section {
            margin: 1rem 0;
        }

        .office-checkbox {
            width: 20px;
            height: 20px;
            margin-right: 0.5rem;
        }

        .loginGuide-section {
            /*text-align: center;*/
            /*padding: 1rem 0;*/
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1rem 0;
            /*border: 1px solid red; */
            margin-left: 1.5rem;
            margin-right: 1.5rem;
            
            
        }

        .button-section {
            /*background: #f8f9fa;
            border-top: 1px solid rgba(0,0,0,0.05);*/
            margin-left: 1.5rem;
            margin-right: 1.5rem;
        }

        .app-section {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            padding: 1rem;
        }

        .app-section img {
            width: clamp(80px, 15vw, 120px);
            height: auto;
        }

        /* Prevent browser autofill background colors */
        input:-webkit-autofill,
        input:-webkit-autofill:hover,
        input:-webkit-autofill:focus,
        input:-webkit-autofill:active {
            -webkit-box-shadow: 0 0 0 30px white inset !important;
            -webkit-text-fill-color: inherit !important;
            transition: background-color 5000s ease-in-out 0s;
        }

        /* Common input styles */
        input {
            font-family: 'Vazirmatn' !important;
            font-size: 1rem !important;
        }

        /* Adjust placeholder color and size */
        ::placeholder {
            font-family: 'Vazirmatn' !important;
            font-size: 1rem !important;
            opacity: 0.7;
        }

        .input-label {
            display: block;
            text-align: right;
            margin-bottom: 0.3rem;
            font-weight: 500;
            color: #495057;
            font-family: 'Vazirmatn';
            font-size: 0.95rem;
            margin-bottom: 0.5rem;
            color: #2c3e50;
        }

        .icon {
            color: #0093E9;
            font-size: 1.1rem;
        }

        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 0.6rem 1.2rem;
            transition: all 0.3s ease;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
        }

        .btn-info {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
        }

        .card-footer {
            background: #fff;
            border-top: 1px solid rgba(0,0,0,0.05);
            padding: 1rem;
        }

        .card-footer a {
            color: #0093E9;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .card-footer a:hover {
            color: #0056b3;
        }

        /* Improve spacing between elements */
        .form-group {
            margin-bottom: 1.5rem;
        }

        /* Enhanced mobile responsiveness */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            
            .button-section {
                padding: 1rem;
            }

            .captcha-wrapper img {
            width:80%; /* Increased from 160px */
            height: auto;
            object-fit: contain;
            }
        }

        @media (max-width: 576px) {
            .captcha-wrapper img {
            width:100%; /* Increased from 160px */
            height: auto;
            object-fit: contain;
            }
        }
    </style>

    <div class="login-container">
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">سامانه حمل و نقل بار و کالا</h3>
            </div>

            <div class="card-body">
                <div class="form-group">
                    <label class="input-label">نام کاربری :</label>
                    <div class="input-field">
                        <span class="far fa-user icon"></span>
                        <input type="text" id="txtUserName" placeholder="نام کاربری خود را وارد کنید" required>
                    </div>
                </div>
                    
                <div class="form-group">
                    <label class="input-label">کلمه عبور :</label>
                    <div class="input-field">
                        <span class="fas fa-lock icon"></span>
                        <input type="password" id="txtPassword" placeholder="رمز عبور را وارد کنید" required>
                        <span toggle="#txtPassword" class="far fa-eye toggle-password"></span>
                    </div>
                </div>

                <div id="officeDiv" runat="server" class="office-section">
                    <label>
                        <input type="checkbox" id="chkIsOffice" class="office-checkbox" onchange="chkIsOfficeChange()">
                        دفاتر
                    </label>
                    <div class="input-field">
                        <span class="far fa-id-card icon"></span>
                        <input type="text" disabled id="txtReferred" placeholder="کدملی / شناسه ملی مراجعه کننده">
                    </div>
                </div>
                
                <div class="form-group captcha-section">
                    <div class="captcha-wrapper">
                        <img id="captchaImage" src="/App_handlers/captcha.ashx" alt="کد امنیتی">
                        <button type="button" class="refresh-btn" onclick="refreshCaptcha()"
                            aria-label="تازه سازی کد امنیتی">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                    <div class="captcha-input">
                        <input type="text" id="txtCaptcha" name="captcha" class="form-control"
                            placeholder="کد امنیتی را وارد کنید" required inputmode="numeric" autocomplete="off"
                            dir="ltr" minlength="5" maxlength="5" pattern="^\d{5}$"
                            aria-describedby="captchaHint" oninvalid="validateCaptcha(this);"
                            oninput="validateCaptcha(this);" onblur="validateCaptcha(this);">
                        <small id="captchaHint" class="form-text text-muted hint-text" style="height:8px">
                            کد ۵ رقمی نمایش داده شده را وارد کنید
                        </small>
                    </div>
                </div>
            </div>
            
            <!-- <div id="loginGuide" runat="server" class="row loginGuide-section">
            </div> -->

            <div class="row button-section">
                
                <div class="col-6">
                    <a id="btnLoginSSo" runat="server" href="" class="btn btn-success col-12">ورود</a>
                    <a id="btnLogin" runat="server" onclick="loginUser()" class="btn btn-success col-12">ورود</a>
                </div>

                <div class="col-6">
                    <!-- Replaced dropdown with a simple button trigger for modal -->
                    <button id="btnRegister" runat="server" class="btn btn-info col-12" onclick="$('#registerModal').modal('show')">
                        ثبت نام
                    </button>
                </div>
            </div>
            <div id="loginOptions" runat="server" class="card-footer">
                <a id="linkSSO" runat="server" target="_blank" href="/Baraneh/Users/ResetPassword.aspx">ورود از طریق</a>
                <br />
                <a id="linkDolat" runat="server" target="_blank" href="/documents/help990517.pdf">ورود از طریق دولت الکترونیک</a>
            </div>
            <div id="forgerPassAndHelpContainer" runat="server" class="card-footer">
                <a id="btnForgotPassword" runat="server" target="_blank" href="/Baraneh/Users/ResetPassword.aspx">فراموشی رمز عبور</a>
                <span>&nbsp;&nbsp;&nbsp;&nbsp;</span>
                <a id="btnHelp" runat="server" target="_blank" href="/documents/help990517.pdf">راهنمای سیستم</a>
                <br />
                <br />
            </div>
        </div>
        <div id="announceContainer" runat="server" class="card card-danger">
            <div class="alert alert-danger">
                <h3 class="card-title">توجه</h3>
            </div>
            <div class="d-flex justify-content-center" style="margin: 10px">
                <a runat="server" href="https://baraneh.tehran.ir/Docs/VehicleDriverAssignment.pdf">
                    <img class="img-fluid" alt="Responsive image" src="https://baraneh.tehran.ir/Customize/Tehran/Images/VehicleDriveAssignment.jpg"><noscript></noscript>
                </a>
            </div>
        </div>
        <div id="appContainer" runat="server" class="card card-info">
            <div class="alert alert-warning">
                <h3 class="card-title">سایر نسخه ها</h3>
            </div>
            <div class="d-flex justify-content-center app-section" style="margin: 10px">
                <a id="lnkAppDownloadDirect" runat="server" href="">
                    <img class="img-fluid" alt="Responsive image" src="/Resources/dist/Images/android-direct-download.png"><noscript></noscript>
                </a>
                <a id="lnkAppDownloadBazaar" runat="server" href="">
                    <img class="img-fluid" alt="Responsive image" src="/Resources/dist/Images/bazaar.png"><noscript></noscript>
                </a>
                <a id="lnkAppDownloadMyket" runat="server" href="">
                    <img class="img-fluid" alt="Responsive image" src="/Resources/dist/Images/myketmarket.png"><noscript></noscript>
                </a>
            </div>
        </div>
    </div>

    <!-- New Modal for Registration -->
    <div id="registerModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="registerModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="registerModalLabel" class="modal-title">ثبت نام</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="بستن">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                        <a href="/Baraneh/Registration/RegisterIndividual.aspx" class="list-group-item list-group-item-action">اشخاص حقیقی</a>
                        <a href="/Baraneh/Registration/RegisterEnterprise.aspx" class="list-group-item list-group-item-action">اشخاص حقوقی</a>
                        <a href="/Baraneh/Registration/RegisterViaUtcmsTrackingCode.aspx" class="list-group-item list-group-item-action">ثبت نام به کد پیگیری UTCMS</a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script src="/Resources/dist/js/CustomValidations.js" type="text/javascript"></script>
    <script>
      

        $(".toggle-password").click(function () {
            $(this).toggleClass("fa-eye fa-eye-slash");

            var input = $($(this).attr("toggle"));

            input.attr("type", input.attr("type") === "password" ? "text" : "password");
        });

       

        function chkIsOfficeChange() {
            if ($("#chkIsOffice").prop("checked")) {
                $("#txtReferred").prop("disabled", false);
            } else {
                $("#txtReferred").prop("disabled", true);
            }
        }

        function loginUser() {
            var captcha = $("#txtCaptcha").val() || "";
            var userName = $('#txtUserName').val();
            var password = $('#txtPassword').val();

            if (userName.trim() == "" || password.trim() == "") {
                $.messager.alert('اخطار', "نام کاربری و کلمه عبور را وارد نمایید", 'warning');
                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            if ($("#chkIsOffice").prop("checked") == true) {
                if ($("#txtReferred").val() == "") {
                    $.messager.progress('close');
                    $.messager.alert('اخطار', 'نام کاربری مراجعه کننده را وارد کنید', 'warning');
                    return;
                }
                var txtReferredUser = $("#txtReferred").val();

                var param = {
                    UserName: userName,
                    Password: password,
                    Captcha: captcha,
                    ReferredUsername: txtReferredUser
                };

                $.ajax({
                    url: '/CoreServices/API/Login/OwinLoginOfficeC',
                    type: 'post',
                    contentType: 'application/json',
                    data: JSON.stringify(param),
                    success: function (data) {
                        $.messager.progress('close');

                        if (data) {
                            if (data.IsSuccessful) {
                                navigatePage();
                            } else {
                                $.messager.alert('warning', data.Message, 'اخطار');
                                console.log(data.ReturnValue); 
                            }
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        $.messager.progress('close');
                        $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');
                        console.log(errorThrown); 
                    }
                });
            } else {
                var param = {
                    UserName: userName,
                    Password: password,
                    Captcha: captcha
                };
                $.ajax({
                    url: '/CoreServices/API/Login/OwinLoginC',
                    type: 'post',
                    contentType: 'application/json',
                    data: JSON.stringify(param),
                    success: function (data) {
                        $.messager.progress('close'); 

                        if (data) {
                            
                            if (data.IsSuccessful) {
                                navigatePage();
                            } else {
                                refreshCaptcha();
                                $.messager.alert('warning', data.Message, 'اخطار');
                                console.log(data.ReturnValue); 
                            }
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        $.messager.progress('close');
                        $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');
                        console.log(errorThrown); 
                    }
                });
            }
        }

        function navigatePage() {
            $.ajax({
                url: '/CoreServices/API/UsersAccess/NavigateDashboard',
                type: 'GET',
                contentType: 'application/json',
                success: function (data) {
                    window.location.replace(data);
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('خطا', 'خطا در دریافت اطلاعات', 'error');
                    console.log(errorThrown); 
                }
            });
        }

        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }

        function validatePaste(evt) {
            var clipboardData = evt.clipboardData || window.clipboardData;
            var pastedData = clipboardData.getData('Text');
            if (!/^\d*$/.test(pastedData)) {
                return false;
            }
            return true;
        }

        function refreshCaptcha() {
            document.getElementById('captchaImage').src = "/App_handlers/captcha.ashx?" + new Date().getTime();
        }
    </script>
</asp:Content>
