﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="Weighbridge.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Weighbridge.Weighbridge" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" id="announce">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست توزین های ثبت شده</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست توزین های ثبت شده'">
                    <table id="grdLicensingCarList">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'Id', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'CenterWeighingCode', sortable:'true', width:160">كد مركز توزين</th>
                                <th data-options="field:'WeighingDate', sortable:'true', width:160">تاريخ توزين</th>
                                <th data-options="field:'WeighingTime', sortable:'true', width:160">زمان توزين</th>
                                <th data-options="field:'VehicleTypeName', sortable:'true', width:160">نوع وسيله نقليه</th>
                                <th data-options="field:'PlateNo', sortable:'true', width:160">شماره پلاك وسيله نقليه</th>
                                <th data-options="field:'DriverName', sortable:'true', width:160">نام راننده</th>
                                <th data-options="field:'DriverNationalCode', sortable:'true', width:160">كد ملي راننده</th>
                                <th data-options="field:'DriverMobileNumber', sortable:'true', width:160">شماره تلفن همراه راننده</th>
                                <th data-options="field:'CompanyName', sortable:'true', width:160">نام شرکت</th>
                                <th data-options="field:'TotalWeight', sortable:'true', width:160">وزن كل</th>
                                <th data-options="field:'CargoType', sortable:'true', width:160">نوع بار</th>
                                <th data-options="field:'OriginPoint', sortable:'true', width:160">مبدأ حركت</th>
                                <th data-options="field:'DestinationPoint', sortable:'true', width:160">مقصد حركت</th>
                                <th data-options="field:'Overload', sortable:'true', width:160">ميزان اضافه بار</th>
                                <th data-options="field:'DifferentWeight', sortable:'true', width:160">متخلف وزن</th>
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
  
                                <span>پلاک</span>
                            <input tabindex="4" onkeypress="return /[0-9]/i.test(event.key)"maxlength="2" id="txtIranPlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" required>
                            <span>ایران</span>
                            <input tabindex="3"onkeypress="return /[0-9]/i.test(event.key)" maxlength="3"id="txtThreePlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" >
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>

                            </select>
                            <input tabindex="1"onkeypress="return /[0-9]/i.test(event.key)" maxlength="2" type="text" id="txtOnePlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                            <a onclick="searchWeighbridge()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                         </div>
                    </div>
                </div>
            </div>
        </section>
    </div>


</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdLicensingCarList = $('#grdLicensingCarList');
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var drpLicenseOwner = $('#drpLicenseOwner');

        $(function () {

            winCarEdit.window({
                width: '1060',
                height: '500',
                modal: true,
                title: "فرم اطلاعات خودروها",
                closed: true
            });

            winLicensing.window({
                width: '1060',
                height: '500',
                modal: true,
                title: "فرم اطلاعات پروانه صادر شده",
                closed: true
            });


            grdLicensingCarList.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                method: 'get',
                fit: true,
                singleSelect: false,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/Weighbridge/API/Weighbridge/GetAllByPlateNo',
                rownumbers: true,
                sortName: 'WeighingDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                height: $(window).height() - 160,
                queryParams: {
                    plaqueNo: ''
                }
            });
        });
        


        function searchWeighbridge() {

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoBoot(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;
             

             
            opts.queryParams['plateNo'] = plaqueValue; 
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }

        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').val('');
            $('#txtThreePlateNoCarList').val('');
            $('#txtIranPlateNoCarList').val('');
            $('#drpTwoPlateNoCarList').val('');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

    

            opts.queryParams['plaqueNo'] = ''; 
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        $(document).ready(function () {
            restrictAccess();
        });
    </script>

</asp:Content>
