﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="VoucherEdit.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Vouchers.VoucherEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

    <link rel="stylesheet" href="https://static.neshan.org/sdk/mapboxgl/v1.13.2/neshan-sdk/v1.1.3/index.css" />
    <link rel="stylesheet" type="text/css" href="/Resources/dist/css/VoucherRequest.css">
    <script src="https://static.neshan.org/sdk/mapboxgl/v1.13.2/neshan-sdk/v1.1.3/index.js"></script>


    <div class="content-wrapper" style="padding: 20px;">
        <div class="title-head">
        </div>
        <div class="main">
            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>استعلام پلاک</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="container d-flex justify-content-center">
                            <div class="col-12 col-md-4 vplateContainer ">
                                <div class="vplateItems col-12 col-md-12">
                                    <input tabindex="4" id="txtPlateP4" class="form-control col-2 vpltP4" required numeric maxlength="2" pattern=".{2,2}">
                                    <input tabindex="3" id="txtPlateP3" class="form-control col-2 vpltP3" required numeric maxlength="3" pattern=".{3,3}">
                                    <select tabindex="2" id="drpPlateP2" class="form-control col-3 select2bs4 vpltP2 " required></select>
                                    <input tabindex="1" id="txtPlateP1" class="form-control col-2 vpltP1" required numeric maxlength="2" pattern=".{2,2}">
                                </div>
                            </div>
                        </div>
                        <div class="container d-flex justify-content-center align-items-center">
                            <div class="col-12 col-md-12 d-flex justify-content-center">
                                <button type="button" id="btnGetVinVoucherEdit" onclick="validatePlateVoucherEdit(1)"
                                    class="btn btn-3d btn-secondary col-12 col-md-4">
                                    انتخاب خودرو واعتبار سنجی
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>مشخصات پلاک وارد شده</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>

                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">

                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">پلاک :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtPlateNo">
                            </div>


                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">VIN :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtVIN">
                            </div>

                        </div>
                        <div class="row">

                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">سیستم :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtCarSystem">
                            </div>


                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">تیپ :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtCarStyle">
                            </div>

                        </div>
                        <div class="row">

                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">رنگ :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtCarColor">
                            </div>


                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">مالک :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtCarOwnerName">
                            </div>

                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">نوع خودرو :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtCarCategory">
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">اعتبار پروانه :</label>
                                <input readonly type="text" class="form-control col-12 col-md-7" style="background-color: transparent !important" id="txtLicenseStatusTitle">
                            </div>
                        </div>
                        <br />
                        <div class="row" style="text-align: center !important; -webkit-text-fill-color: red;">
                            <div>شهروند گرامی ، به اطلاعات ثبت شده دقت نمایید . در صورت مغایرت اطلاعات ثبت شده با برگ سبز ، از طریق منوی پشتیبانی ، نسبت به اعلام مغایرت اقدام نمایید.</div>
                        </div>

                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-user"></i>انتخاب راننده</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row ">
                            <label class="col-12 col-md-2 col-form-label">راننده :</label>
                            <select required id="drpDrivers" class="form-control col-12 col-md-10 select2bs4 "></select>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-boxes"></i>جزئیات محموله</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!--<form id="frmVoucherEdit">-->
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-5">تاریخ حمل :</label>
                                    <input class="form-control" disabled id="txtVoucherDate" />
                                </div>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">نوع بار :</label>
                                <select required id="drpGoodTypes" class="form-control col-12 col-md-7 select2bs4 "></select>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">وزن بسته :</label>
                                <select required numeric maxlength="6" id="drpGoodWeights" class="form-control col-12 col-md-7 select2bs4 "></select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">نوع بسته :</label>
                                <select required id="drpPackings" class="form-control col-12 col-md-7 select2bs4"></select>
                            </div>

                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">تعداد بسته :</label>
                                <input required numeric maxlength="6" id="txtPackingCount" class="form-control  col-12 col-md-7  ">
                            </div>

                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-map-marker"></i>تعیین مبدا</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!--<form id="frmVoucherEdit">-->

                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">نام فرستنده بار :</label>
                                <input required id="txtSenderFullName" class="form-control  col-12 col-md-7 ">
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">کد/شناسه ملی فرستنده :</label>
                                <input required numeric maxlength="11" pattern=".{10,11}" id="txtSenderNationalCode" class="form-control   col-12 col-md-7 ">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">شخصیت فرستنده :</label>
                                <select required id="drpSenderPersonalities" class="form-control col-12 col-md-7  select2bs4"></select>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">شماره موبایل (مبدا) :</label>
                                <input required numeric maxlength="11" pattern=".{11,11}" placeholder="09120000000" id="txtSenderMobile" class="form-control col-12 col-md-7   ">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <button onclick="loadLocation('source')" type="button" class="col-12 btn " style="background-color: rgb(87, 94, 255); color: white;">
                                    انتخاب مبدا
                                </button>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">آدرس مبدا :</label>
                                <input required id="txtSenderAddress" class="form-control  col-12 col-md-7  " />
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>


            <div class="col-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-map-marker"></i>تعیین مقصد</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">نام دریافت کننده :</label>
                                <input required id="txtReceiverFullName0" class="form-control col-12 col-md-7  ">
                            </div>

                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">کد/شناسه ملی دریافت کننده :</label>
                                <input required numeric maxlength="11" pattern=".{10,11}" id="txtReceiverNationalCode0" class="form-control  col-12 col-md-7  ">
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">شخصیت دریافت کننده :</label>
                                <select required id="drpReceiverPersonalities0" class="form-control  col-12 col-md-7 select2bs4 "></select>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">شماره موبایل دریافت کننده :</label>
                                <input required numeric maxlength="11" pattern=".{11,11}" placeholder="09120000000" id="txtReceiverMobile0" class="form-control  col-12 col-md-7  ">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group row col-12 col-md-6">
                                
                                <button onclick="loadLocation('destination')" type="button" class="col-12 btn " style="background-color: rgb(34, 169, 88); color: white;">
                                    انتخاب مقصد
                                </button>
                            </div>
                            <div class="form-group row col-12 col-md-6">
                                <label class="col-12 col-md-5 col-form-label">آدرس مقصد :</label>
                                <input required id="txtReceiverAddress0" class="form-control col-12 col-md-7" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="container d-flex justify-content-center">
                    <!-- Updated: Changed btn-lg to btn-sm  -->
                    <button id="btnSaveVoucherEdit" onclick="saveVoucherEdit()" type="button" class="col-6 btn  btn-secondary  ">
                        ثبت باربرگ
                    </button>
                </div>
            </div>

        </div>
        <div id="mapModal" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content h-100">
                    <div class="modal-header">
                        <h5 id="mapTitle" class="modal-title">Map</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="card card-primary card-outline card-outline-tabs h-100">
                            <div class="card-header p-0 border-bottom-0">
                                <ul class="nav nav-tabs" id="custom-tabs-four-tab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-toggle="pill" id="custom-tabs-four-home-btn" href="#custom-tabs-four-home" role="tab" aria-controls="custom-tabs-four-home" aria-selected="true">نقشه</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" style="display: none !important;" data-toggle="pill" href="#custom-tabs-four-profile" role="tab" aria-controls="custom-tabs-four-profile" aria-selected="false">جستجو</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" style="display: none !important;" data-toggle="pill" href="#custom-tabs-four-messages" role="tab" aria-controls="custom-tabs-four-messages" aria-selected="false">مکان های منتخب</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body">
                                <div class="tab-content h-100" id="custom-tabs-four-tabContent">
                                    <div class="tab-pane h-100 fade show active" id="custom-tabs-four-home" role="tabpanel" aria-labelledby="custom-tabs-four-home-tab">
                                        <div class="d-flex flex-column h-100" style="min-height: 400px">
                                            <div id="map" class="map"></div>
                                            <div class="modal-footer mt-3">
                                                <button type="button" class="btn btn-default" onclick="selectPoint()" data-dismiss="modal">انتخاب موقعیت</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane h-100 fade" id="custom-tabs-four-profile" role="tabpanel" aria-labelledby="custom-tabs-four-profile-tab">
                                        <div class="d-flex flex-column h-100" style="min-height: 400px">
                                            <div class="input-group col-12">
                                                <input id="txtSearchLocation" class="form-control" placeholder="جستجوی معبر، مکان" />
                                                <div class="input-group-append">
                                                    <button id="btnSearch" class="btn btn-primary" onclick="searchLocation()" type="button">بگرد</button>
                                                </div>
                                            </div>
                                            <div class="map">
                                                <ul id="searchResults" class="list-group"></ul>
                                            </div>
                                            <div class="text-center mt-3">
                                                <a id="prevPageBtn" href="#" role="button" disabled>
                                                    <i class="fa-regular fa-circle-right" style="font-size: x-large;"></i>
                                                </a>
                                                <a id="nextPageBtn" href="#" role="button" disabled>
                                                    <i class="fa-regular fa-circle-left" style="font-size: x-large;"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane h-100 fade" id="custom-tabs-four-messages" role="tabpanel" aria-labelledby="custom-tabs-four-messages-tab">
                                        <div class="d-flex flex-column h-100" style="min-height: 400px">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">

    <script>

        $.fn.comboSelect = function (options) {
            var valueField = options.valueField || 'id';
            var textField = options.textField || 'text';
            var data = options.data || [];

            this.each(function () {
                var $select = $(this);
                data.forEach(function (item) {
                    var $option = $('<option>').val(item[valueField]).text(item[textField]);
                    $select.append($option);
                });
            });

            return this.select2({
                theme: 'bootstrap4'
            }).on('select2:select', function (e) {
                if ($(this).val()) {
                    $(this).removeClass('is-invalid').addClass('is-valid'); // Add 'is-valid' on selection
                } else {
                    $(this).removeClass('is-valid').addClass('is-invalid');
                }
            }).val(null).trigger('change').addClass('is-invalid');

        };

        $.fn.fillLocationList = function (options) {
            var data = options.data || [];
            var listGroup = $(this);

            function displayItems(page) {
                listGroup.empty(); // Clear previous items

                var startIndex = (page - 1) * itemsPerPage;
                var endIndex = Math.min(startIndex + itemsPerPage, data.length);

                for (var i = startIndex; i < endIndex; i++) {
                    var item = data[i];
                    var listItem = $('<li>').addClass('list-group-item');
                    var formGroup = $('<div>').css('display', 'flex');
                    var col1 = $('<div>').addClass('col-2 catIcon');
                    var col2 = $('<div>').addClass('col-10');

                    /*col1.append($('<div>').addClass(item.iconClass));*/
                    col1.append($('<div>').addClass('fa-regular fa-flag').addClass(item.iconClass));
                    col1.append($('<div>').addClass('distance').text(item.distance));
                    col2.append($('<div>').addClass('title').text(item.title));
                    col2.append($('<div>').addClass('fullAddress').text(item.fullAddress));
                    col2.append($('<div>').addClass('location').css('display', 'none').text(item.location));

                    listItem.click(function () {
                        var location = $(this).find('.location').text();
                        $('#custom-tabs-four-home-btn').trigger('click');
                        locate(location);
                    });
                    formGroup.append(col1);
                    formGroup.append(col2);
                    listItem.append(formGroup);
                    listGroup.append(listItem);
                }

                $('#prevPageBtn').prop('disabled', currentPage === 1);
                $('#nextPageBtn').prop('disabled', currentPage === totalPages);
            }

            var itemsPerPage = 6;
            var currentPage = 1;
            var totalPages = Math.ceil(data.length / itemsPerPage);

            $('#prevPageBtn').on('click', function () {
                if (currentPage > 1) {
                    currentPage--;
                    displayItems(currentPage);
                }
            });

            $('#nextPageBtn').on('click', function () {
                if (currentPage < totalPages) {
                    currentPage++;
                    displayItems(currentPage);
                }
            });

            // Initial display
            displayItems(currentPage);

            return listGroup;
        };

        //$.extend({
        //    alert: function (title, message) {
        //        $("<div></div>")
        //            .text(message) // Move .text(message) here before .dialog()
        //            .dialog({
        //                buttons: {
        //                    "بستن": function () {
        //                        $(this).dialog("close");
        //                    }
        //                },
        //                close: function (event, ui) {
        //                    $(this).remove();
        //                },
        //                resizable: false,
        //                title: title,
        //                modal: true,
        //                create: function () {
        //                    $(this).closest(".ui-dialog").find(".ui-dialog-titlebar").css("font-family", "Vazir");
        //                    $(this).closest(".ui-dialog").find(".ui-button").css("font-family", "Vazir");
        //                },
        //                minWidth: 300, // Set minimum width
        //                minHeight: 150 // Set minimum height
        //            })
        //            .parent() // Ensure the created element is a valid jQuery object
        //            .css("font-family", "Vazir");
        //    }
        //});





        // Add event listener when the document is loaded
        document.addEventListener('DOMContentLoaded', function () {
            // Get all input elements with 'required' or 'numeric' attributes
            var inputs = document.querySelectorAll('input[required], input[numeric]');

            // Loop through each input element
            inputs.forEach(function (input) {

                if (input.hasAttribute('required') && input.value.trim() === '') {
                    // Add 'is-invalid' class if the input is empty

                    input.classList.add('is-invalid');
                }
                // Add input event listener
                input.addEventListener('input', function () {

                    // Check if the input allows only numeric characters
                    if (input.hasAttribute('numeric')) {
                        // Remove non-numeric characters from the input value
                        input.value = input.value.replace(/[^0-9]/g, '');
                    }

                    // Check if the input is required
                    if (input.hasAttribute('required')) {
                        // Add 'is-invalid' class if the input is empty
                        if (input.value.trim() === '') {
                            input.classList.add('is-invalid');
                        } else {
                            // Remove 'is-invalid' class if the input is not empty
                            input.classList.remove('is-invalid');
                            // Add 'is-valid' class if the input is not empty
                            input.classList.add('is-valid');
                        }
                    }

                    // Check if the input matches the specified pattern
                    if (input.hasAttribute('pattern')) {
                        var pattern = new RegExp(input.getAttribute('pattern'));
                        // Add 'is-invalid' class if the input value does not match the pattern
                        if (!pattern.test(input.value)) {
                            input.classList.add('is-invalid');
                        } else {
                            // Remove 'is-invalid' class if the input value matches the pattern
                            input.classList.remove('is-invalid');
                            // Add 'is-valid' class if the input value matches the pattern
                            input.classList.add('is-valid');
                        }
                    }


                });
            });



            var selects = document.querySelectorAll('select[required]'); // Select all required selects


        });

        //***************************************************************************************************** */

        var globalDrivers = null;

        function initPersonalityCombobox(drpIdentity) {

            $.ajax({
                url: "/Vouchers/API/Voucher/Peronalities",
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $("#" + drpIdentity).comboSelect({
                            textField: 'Title',
                            valueField: 'VoucherPersonalityId',
                            data: response.ReturnValue
                        });
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    //showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });
        }

        $(function () {



            $.getJSON("/Resources/jsons/plates.json", function (respond) {

                $('#drpPlateP2').comboSelect({
                    textField: 'text',
                    valueField: 'id',
                    data: respond
                });
                //.select2({
                //    theme: 'bootstrap4',
                //    data: respond
                //});
            });

            //$("txtVoucherDate").persianDatepicker({
            //    observer: true,
            //    format: 'YYYY/MM/DD',
            //});

            $.ajax({
                url: '/CoreServices/API/Shared/GetDate',
                type: 'GET',
                contentType: 'application/json',
                data: { diffDay: 0 },
                success: function (data) {
                    $('#txtVoucherDate').val(data);
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });

            $.ajax({
                url: "/Vouchers/API/Voucher/Times",
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $('#drpStartTimes,#drpEndTimes').comboSelect({
                            valueField: 'VoucherTimeId',
                            textField: 'Title',
                            data: response.ReturnValue
                        });
                    }
                }
            });



            $.ajax({
                url: "/Vouchers/API/Voucher/Goods",
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $('#drpGoodTypes').comboSelect({
                            textField: 'Title',
                            valueField: 'VoucherGoodId',
                            data: response.ReturnValue
                        });
                    }
                }
            });

            $.ajax({
                url: "/Vouchers/API/Voucher/Packings",
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $('#drpPackings').comboSelect({
                            textField: 'Title',
                            valueField: 'VoucherPackingId',
                            data: response.ReturnValue
                        });
                    }
                }
            });


            $.ajax({
                url: "/Vouchers/API/Voucher/Weights",
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $('#drpGoodWeights').comboSelect({
                            textField: 'Title',
                            valueField: 'VoucherWeightId',
                            data: response.ReturnValue
                        });
                    }
                }
            });

            //$.ajax({
            //    url: "/Vouchers/API/Voucher/Weights",
            //    type: 'get',
            //    success: function (response) {
            //        if (response.IsSuccessful) {
            //            $('#drpGoodWeights').comboSelect({
            //                textField: 'Title',
            //                valueField: 'VoucherWeightId',
            //                data: response.ReturnValue
            //            });
            //        }
            //    }
            //});

            initPersonalityCombobox("drpSenderPersonalities");
            initPersonalityCombobox("drpReceiverPersonalities0");

            //initRegionCombobox("drpSenderPersonalities", "drpSenderRegions", "drpSenderStreets");
            //initRegionCombobox("drpReceiverPersonalities0", "drpReceiverRegions0", "drpReceiverStreets0");
        });
        function numberParser(s) {
            if ($.isNumeric(s)) {
                return s;
            }
            return '';
        }
        var ReceiverCounter = 1;
        function addReceiver() {

            var rowId = ReceiverCounter;




            setTimeout(() => {
                /*initRegionCombobox("drpReceiverPersonalities" + rowId, "drpReceiverRegions" + rowId, "drpReceiverStreets" + rowId);*/
                initPersonalityCombobox("drpReceiverPersonalities" + rowId);
                initTextbox(rowId);
                initNumberbox(rowId);
                SetValidation();
            },
                1);
            //setTimeout(() => {
            //    initEventEasyuiTextboxOnlyNumber();
            //}, 0);

            ReceiverCounter++;




        }
        function initTextbox(liId) {
            var inputContainer = $("#region-li-" + liId).find("input[data-type='textbox']").toArray();
            inputContainer.forEach((item, index) => {
                $("#" + item.id).textbox();
            });
        }
        function initNumberbox(liId) {
            var inputContainer = $("#region-li-" + liId).find("input[data-type='numberbox']").toArray();
            inputContainer.forEach((item, index) => {
                $("#" + item.id).numberbox();
            });
        }
        function removeReceiver(id) {
            if (getRecivers().length <= 1) {
                $.messager.alert('پیام سیستم', 'حداقل یک مبدا اجباری است', 'error');
                return;
            }
            $.messager.confirm('پیام سیستم', 'اطلاعات مقصد مورد نظر حذف شود ؟', function (r) {
                if (r) {
                    $("#" + id).remove();

                }
            });
        }
        function validateRequiredElements() {
            var isValid = true;
            var requiredElements = document.querySelectorAll('[required]');

            requiredElements.forEach(function (element) {
                if (element.value.trim() === '') {
                    element.classList.add('is-invalid');
                    element.classList.remove('is-valid');
                    isValid = false;
                } else {
                    element.classList.remove('is-invalid');
                    element.classList.add('is-valid');
                }

                // Check if the element has a pattern attribute and validate it
                if (element.hasAttribute('pattern')) {
                    var pattern = new RegExp(element.getAttribute('pattern'));
                    if (!pattern.test(element.value)) {
                        element.classList.add('is-invalid');
                        element.classList.remove('is-valid');
                        isValid = false;
                    } else {
                        element.classList.remove('is-invalid');
                        element.classList.add('is-valid');
                    }
                }
            });

            return isValid;
        }

        function saveVoucherEdit() {


            try {
                if (!validateRequiredElements()) {
                    $.messager.alert('خطا', 'لطفا موارد اجباری را وارد نمایید');
                    return;
                }

                $("#btnSaveVoucherEdit").attr("disabled", true)
                //$.messager.progress({ title: 'لطفا صبر کنید...' });
                var plateNo = getPlateNoBoot(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
                if (plateNo.length != 9) {
                    throw new Error("plate")
                }

                var senderFullName = $("#txtSenderFullName").val();
                var senderNationalCode = $("#txtSenderNationalCode").val();
                var senderPersonalityId = $("#drpSenderPersonalities").val();
                var senderPostalCode = $("#txtSenderPostalCode").val();
                var senderPhone = $("#txtSenderPhone").val();
                var senderMobile = $("#txtSenderMobile").val();
                var startTimeId = $('#drpStartTimes').val();//زمان شروع حمل
                var endTimeId = $('#drpEndTimes').val();//زمان پایان حمل
                var senderRegionId = 0;//منطقه مبدا
                var senderStreetId = 0;//معبر مبدا
                var senderAddress = $("#txtSenderAddress").val();
                var goodTypeId = $("#drpGoodTypes").val();
                var weightId = $("#drpGoodWeights").val();
                var packingId = $("#drpPackings").val();
                var packingCount = $("#txtPackingCount").val();
                var driverNationalCode = $("#drpDrivers").val();

                var receiverFullName = $("#txtReceiverFullName0").val();
                var receiverNationalCode = $("#txtReceiverNationalCode0").val();
                var receiverPersonalityId = $("#drpReceiverPersonalities0").val();
                var receiverMobile = $("#txtReceiverMobile0").val();
                var receiverAddress = $("#txtReceiverAddress0").val();
                var receivers = [];

                var senderlngLat = sourceMarker.getLngLat();
                var receiverlngLat = destinationMarker.getLngLat();

                if (!senderlngLat || senderlngLat.lat === undefined || senderlngLat.lng === undefined) {
                    throw new Error("sourcelatlng")
                }

                if (!receiverlngLat || receiverlngLat.lat === undefined || receiverlngLat.lng === undefined) {
                    throw new Error("destlatlng")
                }

                let receiverItem =
                {
                    "ReceiverName": receiverFullName,
                    "ReceiverNationalCode": receiverNationalCode,
                    "ReceiverMobile": receiverMobile,
                    //"ReceiverPhone": receiverPhone,
                    "ReceiverAddress": receiverAddress,
                    //"ReceiverPostalCode": receiverPostalCode,
                    "ReceiverlocationLat": receiverlngLat.lat,
                    "ReceiverlocationLong": receiverlngLat.lng,
                    //"ReceiverRegionId": receiverRegionId,
                    //"ReceiverStreetId": receiverStreetId,
                    "ReciverPersonalityId": receiverPersonalityId
                };
                receivers.push(receiverItem);

                var voucher = {
                    PlateNo: plateNo,
                    SenderStreetId: senderStreetId,
                    SenderName: senderFullName,
                    SenderNationalCode: senderNationalCode,
                    WeightId: weightId,
                    PackingId: packingId,
                    PackageCount: packingCount,
                    SenderRegionId: senderRegionId,
                    SenderPeronalityId: senderPersonalityId,
                    StartTimeId: startTimeId,
                    EndTimeId: endTimeId,
                    DriverNationalCode: driverNationalCode,
                    GoodTypeId: goodTypeId,
                    SenderMobile: senderMobile,
                    SenderPhone: senderPhone,
                    SenderAddress: senderAddress,
                    SenderPostalCode: senderPostalCode,
                    SenderlocationLat: senderlngLat.lat,
                    SenderlocationLong: senderlngLat.lng,
                    //DriverPhoneNumber: "09000000000",
                    //RequestedByUserName: "Current",
                    //RequestedByMobileNumber: ,
                    /*WeighbridgeTrackingCode: 0,*/
                    //Receivers: getRecivers()
                    Receivers: receivers
                }

                $.ajax({
                    url: '/Vouchers/API/Voucher/CreateByWeb',
                    type: 'Post',
                    contentType: 'application/json',
                    data: JSON.stringify(voucher),// {
                    success: function (data) {
                        //$.messager.progress('close');
                        //$("#btnSaveVoucherEdit").attr("disabled", false)
                        //
                        if (!data.IsSuccessful) {
                            $('#btnSaveVoucherEdit').removeAttr('disabled');
                        }

                        //$.alert('پیام سیستم', data.Message);
                        $.messager.alert('پیام سیستم', data.Message);
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        //$.messager.progress('close');
                        $("#btnSaveVoucherEdit").attr("disabled", false);
                        //$.messager.alert('پیام سیستم', errorMessage, 'error');

                    }
                });
            }
            catch (error) {
                $("#btnSaveVoucherEdit").attr("disabled", false);
                var errorMsg = "";
                switch (true) {
                    case error.message.includes("plate"):
                        errorMsg = "پلاک وارد شده نامعتبر است."
                        break;
                    case error.message.includes("sourcelatlng"):
                        errorMsg = "انتخاب مبدا بر روی نقشه اجباری است";
                        break;
                    case error.message.includes("destlatlng"):
                        errorMsg = "انتخاب مقصد بر روی نقشه اجباری است";
                        break;
                    case error.message.includes("Cannot read properties of undefined"):
                        errorMsg = "فیلدهای اجباری را تکمیل نمایید";
                        break;
                    default:
                        errorMsg = "An unexpected error occurred: " + error.message;
                        break;
                }
                console.error("Error:", error.message);
                $.messager.alert('پیام سیستم', errorMsg, 'error');

            }
        };

        function getRecivers() {
            var receiversContainer = $("#regions-container");
            var receiverList = receiversContainer.children("li");

            var receivers = []


            for (var liIndex = 0; liIndex < receiverList.length; liIndex++) {
                var idx = receiverList[liIndex].getElementsByTagName("input")[0].value;

                var receiverFullName = $("#txtReceiverFullName" + idx).textbox('getValue');
                var receiverNationalCode = $("#txtReceiverNationalCode" + idx).textbox('getValue');
                var receiverPersonalityId = $("#drpReceiverPersonalities" + idx).comboSelect('getValue');
                var receiverPostalCode = $("#txtReceiverPostalCode" + idx).textbox('getValue');
                var receiverPhone = $("#txtReceiverPhone" + idx).textbox('getValue');
                var receiverMobile = $("#txtReceiverMobile" + idx).textbox('getValue');

                //var receiverRegionId = $('#drpReceiverRegions' + idx).comboSelect('getValue');
                //var receiverStreetId = $('#drpReceiverStreets' + idx).comboSelect('getValue');

                var receiverRegionId = 0;
                var receiverStreetId = 0;

                var receiverAddress = $("#txtReceiverAddress" + idx).textbox('getValue');

                let receiverItem =
                {
                    "ReceiverName": receiverFullName,
                    "ReceiverNationalCode": receiverNationalCode,
                    "ReceiverMobile": receiverMobile,
                    "ReceiverPhone": receiverPhone,
                    "ReceiverAddress": receiverAddress,
                    "ReceiverPostalCode": receiverPostalCode,
                    "ReceiverlocationLat": 0,
                    "ReceiverlocationLong": 0,
                    "ReceiverRegionId": receiverRegionId,
                    "ReceiverStreetId": receiverStreetId,
                    "ReciverPersonalityId": receiverPersonalityId
                };

                receivers.push(receiverItem);
            }

            return receivers;
        }
        function validatePlateVoucherEdit(type) {


            var plate = getPlateNoBoot(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plate.length != 9) {
                return;
            }

            /*//$.messager.progress({ title: 'لطفا صبر کنید...' });*/
            var car = {};
            $.ajax({
                url: '/CoreServices/API/Car/ValidateAccessPlateForAnyProduct',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    plateNo: plate,
                    companyId: 0,
                    driverId: 0
                },
                async: true,
                success: function (data) {
                    //$.messager.progress('close');
                    //
                    if (data.IsSuccessful == false) {
                        //$.alert('خطا', data.Message, 'error');
                        //$.messager.alert('پیام سیستم', errorMessage, 'error');
                        $.messager.alert('خطا', data.Message, 'error');
                        $('#btnGetVinVoucherEdit').removeAttr('disabled');
                    }
                    else {

                        car = data.ReturnValue;

                        $('#txtCarSystem').val(car.System);
                        $('#txtCarStyle').val(car.StyleTip);
                        $('#txtCarColor').val(car.Color);
                        $('#txtCarOwnerName').val(car.OwnerName);
                        $('#txtCarCategory').val(car.CarCategoryTitle);
                        $('#txtLicenseStatusTitle').val(car.LicenseStatusTitle);
                        $('#txtPlateNo').val(car.MISPlate);
                        $('#txtVIN').val(car.VIN);
                        //todo guid
                        globalVehicleGUID = car.VehicleGUID;

                    }

                    if (data.IsSuccessful) {
                        globalVehicleGuid = data.ReturnValue.VehicleGUID;
                        initDriverCombobx();

                    }
                },

                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');
                    //alert('خطا در دریافت اطلاعات');
                    //$.messager.progress('close');
                }
            });
        }
        function initDriverCombobx() {

            $.ajax({
                url: '/CoreServices/API/Driver/GetDriverByVehicleGuid?vehicleGuid=' + globalVehicleGuid,
                type: 'get',
                success: function (response) {

                    $('#drpDrivers').comboSelect({
                        textField: 'Title',
                        valueField: 'NationalCode',
                        data: response
                    });
                }
            });
        }



        //***************************************************************************************************** */




        var elSource = document.createElement('div');
        elSource.innerHTML = ` <button class="css-sx94m7"><div class="showLabel css-1p1gudd"><div class="css-10tprts"><div class="css-2izilp"></div></div><div class="showLabel css-1469v6k"><div class="showLabel css-srofch"><p color="surface.high" class="css-ysjbrp">مبـدأ</p></div></div></div><div class="css-1kst96w"></div><div class="css-aaw7ur"></div></button> `;
        var elDes = document.createElement('div');
        elDes.innerHTML = ` <button class=" css-sx94m7"><div class="showLabel css-netmwt"><div class="css-rlnau9"><div class="css-n50p3s"></div></div><div class="showLabel css-1469v6k"><div class="showLabel css-srofch"><p color="surface.high" class="css-ysjbrp">مقصد</p></div></div></div><div class="css-1kst96w"></div><div class="css-aaw7ur"></div></button> `;
        var sourceMarker = new nmp_mapboxgl.Marker(elSource); // Marker for source location
        var destinationMarker = new nmp_mapboxgl.Marker(elDes); // Marker for destination location
        var markers = [sourceMarker, destinationMarker]; // Array to store both markers

        // Define locationType variable outside the function for global scope
        var locationType = null;
        var map = null;

        var globalLat = 35.6892;
        var globalLng = 51.389;
        var globalKey = "";
        var globalZoom = 12;

        function loadLocation(locationTypeParam) {
            locationType = locationTypeParam;
            $("#mapTitle").text(locationType === "source" ? "مبدا" : "مقصد");
            $('#mapModal').modal('show');
        }

        var selectedPoints = {};
        var inputAddress = null;

        function flyToLocation(globalLat, globalLng, globalZoom) {
            if (map != null && map != undefined) {
                map.flyTo({
                    center: [globalLng, globalLat], // New center of the map
                    zoom: globalZoom, // Zoom level
                    essential: true // Indicates that this animation is essential, making it smoother
                });
            }
        };



        $(document).ready(function () {
            if (checkIfBaranehApp()) {

            }


            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (position) {
                    globalLng = position.coords.longitude;
                    globalLat = position.coords.latitude;
                    globalZoom = 9;
                    // Call a function to update the map with the new coordinates
                    //updateMap(globalLat, globalLng, globalZoom);
                }, function (error) {
                    //console.error("Geolocation error:", error);
                    handleGeolocationError(error);
                }, {
                    enableHighAccuracy: true,
                    timeout: 5000,
                    maximumAge: 0
                });
            } else {
                //console.warn("بازیابی موقعیت توسط مرورگر وب شما پشتیبانی نمی شود.");
                getDefaultLocation();
            }

            function handleGeolocationError(error) {
                let errorMessage;
                switch (error.code) {
                    case error.PERMISSION_DENIED:
                        errorMessage = "به نظر میرسد شما تمایلی به، به اشتراک گذاری موقعیت مکانی خود ندارید";
                        break;
                    case error.POSITION_UNAVAILABLE:
                        errorMessage = "دستیابی به موقعیت مکانی شما امکان پذیر نیست";
                        break;
                    case error.TIMEOUT:
                        errorMessage = "به نظر میرسد دستیابی به موقعیت مکانی شما امکان پذیر نباشد.";
                        break;
                    case error.UNKNOWN_ERROR:
                        errorMessage = "در زمان دستیابی به موقعیت مکانی شما ، خطایی ناشناخته رخ داده است";
                        break;
                }
                //$.alert('پیام سیستم', errorMessage, 'error');
                $.messager.alert('پیام سیستم', errorMessage, 'error');
                getDefaultLocation();
            }


            function getDefaultLocation() {
                fetch("/Map/API/Neshan/DefaultCityLocationToObject")
                    .then(response => response.json())
                    .then(data => {
                        if (data.IsSuccessful) {
                            globalLat = data.ReturnValue.lat;
                            globalLng = data.ReturnValue.lng;
                            globalZoom = 9;
                            // Call a function to update the map with the default coordinates
                            flyToLocation(globalLat, globalLng, globalZoom);
                        } else {
                            //console.error("Failed to get default location");
                        }
                    })
                    .catch(error => {
                        //console.error("Error fetching default location:", error);
                    });
            }



            // Call this function when you want to get the current position



            $.ajax({
                url: "/Map/API/Neshan/NeshanMapApiKey",
                type: 'get',
                async: false,
                success: function (response) {
                    globalKey = response
                }
            });

            $('#mapModal').on('shown.bs.modal', function (e) {

                if (map === null) {
                    map = new nmp_mapboxgl.Map({
                        mapType: nmp_mapboxgl.Map.mapTypes.neshanRaster,
                        container: "map",
                        zoom: globalZoom,
                        pitch: 0,
                        center: [globalLng, globalLat],
                        minZoom: 2,
                        maxZoom: 21,
                        trackResize: true,
                        mapKey: globalKey,
                        poi: false,
                        traffic: false,
                        isTouchPlatform: false,
                        mapTypeControllerOptions: {
                            show: false
                        }
                    });

                    map.addControl(
                        new nmp_mapboxgl.GeolocateControl({
                            positionOptions: {
                                enableHighAccuracy: true
                            },
                            trackUserLocation: true,
                            showUserHeading: true
                        })
                    );

                    map.on('click', function (e) {
                        var marker = locationType === "source" ? sourceMarker : destinationMarker;
                        inputAddress = locationType === "source" ? $('#txtSenderAddress') : $('#txtReceiverAddress0');
                        marker.setLngLat([e.lngLat.lng, e.lngLat.lat]).addTo(map);
                        selectedPoints[locationType] = [e.lngLat.lng, e.lngLat.lat];
                    });
                }
            });



        });

        function locate(location) {

            var marker = locationType === "source" ? sourceMarker : destinationMarker;
            inputAddress = locationType === "source" ? $('#txtSenderAddress') : $('#txtReceiverAddress0');

            // Splitting the location string into latitude and longitude values
            var coordinates = location.split(',').map(parseFloat);

            // Setting marker position
            marker.setLngLat(coordinates).addTo(map);

            // Storing location in selectedPoints object
            selectedPoints[locationType] = coordinates;

            // Fly to the location on the map
            map.flyTo({
                center: coordinates, // New center of the map
                zoom: 15, // Zoom level
                essential: true // Indicates that this animation is essential, making it smoother
            });


        }

        function selectPoint() {
            var lat = selectedPoints[locationType][1];
            var lng = selectedPoints[locationType][0];
            var address = retAddress(lat, lng);
            inputAddress.val(address).trigger('input').trigger('change');

            // Manually trigger validation
            if (inputAddress.attr('required') && inputAddress.val().trim() === '') {
                inputAddress.addClass('is-invalid').removeClass('is-valid');
            } else {
                inputAddress.removeClass('is-invalid').addClass('is-valid');
            }

        }

        function retAddress(latParam, lngParam) {

            var result = "";
            $.ajax({
                async: false,
                url: '/Map/API/Neshan/ReverseGeoCodeToAddress?lat=' + latParam + '&lng=' + lngParam,
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        result = response.ReturnValue;
                    }
                }
            });
            return result;
        }

        function searchLocation() {
            $("#drpSearchResult").val(null).trigger('change');
            var term = $('#txtSearchLocation').val();
            if (term === '') return;
            $.ajax({
                async: false,
                url: '/Map/API/Neshan/SearchAddress?term=' + term + ' &lat=' + globalLat + '&lng=' + globalLng,
                type: 'get',
                success: function (response) {
                    if (response.IsSuccessful) {
                        $("#searchResults").fillLocationList({
                            data: response.ReturnValue
                        });
                    }
                }
            });

        }





    </script>

</asp:Content>
