﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="LicensingList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Vehicles.LicensingList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent"  runat="server">
   
    <section class="content-wrapper">
        
            <div class="easyui-layout" id="mainLayout" data-options="fit:true" style="min-height: 600px" >
                <%--style="height: 600px; width: 100%"--%>
                <div data-options="fit:true,region:'center',title:'لیست ناوگان و درخواست های پروانه فعالیت'">
                    <table id="grdLicensingCarList">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'LicensingId', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'Vin', sortable:'true', width:160">VIN</th>
                                <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                                <th data-options="field:'StyleTip', sortable:'true', width:160">تیپ</th>
                                <th data-options="field:'IsNewLicense', sortable:'true', width:130 , formatter:formatIsNewField">نوع درخواست</th>
                                <th data-options="field:'LicenseTypeTitle', sortable:'true', width:90">نوع پروانه</th>
                                <th data-options="field:'RequestDate', sortable:'true', width:130">تاریخ درخواست</th>
                                <th data-options="field:'LicenseDate', sortable:'true', width:160">تاریخ صدور</th>
                                <th data-options="field:'LicenseNumber', sortable:'true', width:160">شماره پروانه</th>
                                <th data-options="field:'LicenseStatusTitle', sortable:'true', width:160">وضعیت درخواست</th>

                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                        <div class="d-flex" style="padding: 2px 5px;">
                            <div class="col-4" style="height: 25px !important">
                                <span>پلاک</span>
                                <input tabindex="4" id="txtPlateP4" class="easyui-numberbox plateP4" style="height: 25px !important">
                                <span>ایران</span>
                                <input tabindex="3" id="txtPlateP3" class="easyui-numberbox plateP3" style="height: 25px !important">
                                <select tabindex="2" id="drpPlateP2" class="easyui-combobox plateP2" style="height: 25px !important"></select>
                                <input tabindex="1" id="txtPlateP1" class="easyui-numberbox plateP1" style="height: 25px !important">
                            </div>
                            
                            <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                            <a onclick="print()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">چاپ پروانه</a>
                            <%--<a onclick="CancelLicensing()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">ثبت درخواست لغو پروانه </a>--%>


                            <a href="javascript:void(0)" id="btnUTCMS" onclick="inqueryUTCMS()" class="easyui-linkbutton">استعلام UTCMS</a>
                            <%--<a onclick="renewalLicensing()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">تمدید پروانه فعالیت </a>--%>
                        </div>
                    </div>
                </div>
            </div>
       
    </section>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdLicensingCarList = $('#grdLicensingCarList');
       
        function inqueryUTCMS() {

            
            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Licensing/InquiryUtcmsWithTranslateByGUID',
                type: 'Post',
                data: JSON.stringify(row.LicensingGUID),
                contentType: 'application/json',
                success: function (data) {
                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful === true) {
                            if (isJson(data.ReturnValue) || isObject(data.ReturnValue)) {
                                var final_data = data.ReturnValue;


                                if (isJson(data.ReturnValue)) {
                                    final_data = JSON.parse(data.ReturnValue);
                                }

                                var message = "<div style='text-align:right;direction:rtl '>";

                                Object.keys(final_data).map((item, index) => {
                                    if (final_data[item] !== 'br') {
                                        message += item + ' : ' + (final_data[item] === null ? 'نامشخص' : final_data[item]) + ' <br />';
                                    }
                                    else {
                                        message += ' <hr />';
                                    }

                                });
                                message += "</div>";
                                $.messager.alert('پیام سیستم', message, '');

                            } else {
                                $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                            }
                        } else {
                            $.messager.alert('پیام سیستم', data.Message, 'info');
                        }

                    } else {
                        $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        };

        


        function submitCancelRequest() {

            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            var description = $("#txtDescription").val();

            if (description.trim() === "") {
                $.messager.alert('هشدار', 'لطفا دلیل درخواست ابطال را وارد کنید');
            }
            description = description.trim();

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/DesktopModules/EspGovService/API/CancelLicensing/AddCancelLicenseRequest',
                type: 'get',
                contentType: 'application/json',
                data: { licensingNumber: row.LicensingNumber, description: description },
                success: function (data) {
                    $.messager.progress("close");
                    if (data) {
                        $.messager.alert('پیغام سیستمی', data.Message, 'info');
                        $("#txtDescription").val("");
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress("close");
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });
        }



        $(function () {

            

            //winLicensing.window({
            //    width: '1060',
            //    height: '500',
            //    modal: true,
            //    title: "فرم اطلاعات پروانه صادر شده",
            //    closed: true
            //});


            grdLicensingCarList.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                //method: 'get',
                //fit: true,
                //singleSelect: true,
                //collapsible: true,
                //fitColumns: true,
                //pagination: true,
                //pageSize: 15,
                //pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Licensing/LicensingList',
                //rownumbers: true,
                sortName: 'VehicleId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                //height: $(window).height() - 160,
                queryParams: {
                    licenseStatusId: 0,
                    isNewLicense:0,
                    plateNo: ''
                }
            });
        });
        function print() {

            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            if (row['LicenseTypeId'] === 2) {
                $.messager.alert('هشدار', "پروانه فعالیت شما در شهر دیگری صادر شده است و در این شهر پروانه شما مهمان است.", 'error');
                return;
            }

            if (row['LicenseStatusId'] !== 2) {
                $.messager.alert('هشدار', "پروانه مورد نظر هنوز تایید نشده است", 'error');
                return;
            }
            else {
                window.open("/Reports/Print/PrintLicensing.html?LicensingGUID=" + row['LicensingGUID']);
                }
            

        }

        function searchCarListOnDB() {

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            var plateNo = getPlateNoEu(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plateNo.length === 'error') {
                return;
            }

            opts.queryParams['plateNo'] = plateNo;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        function showDataCarList(type) {

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            var plateNo = getPlateNoBoot(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plateNo === 'error')
                return;

            opts.queryParams['plateNo'] = plateNo;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').val('');
            $('#txtThreePlateNoCarList').val('');
            $('#txtIranPlateNoCarList').val('');
            $('#drpTwoPlateNoCarList').val('');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = '';
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        var licenseOwnerIdInSelectGrid = 0;
       
        $(document).ready(function () {
            restrictAccess();
        });

    </script>
</asp:Content>
