﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="LicensingEdit.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Vehicles.LicensingEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

   
    <div class="content-wrapper" style="padding: 20px;">

        <div class="title-head">

            <h2>ثبت اطلاعات خودروی مهمان ( بدون اخد پروانه )</h2>
        </div>
        
        <!-- /.row -->
        <div class="main">
            <div id="frmCarEdit">


                <!-- LINE CHART -->
                <div class="card card-info bgrd" id="inq">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>استعلام اولیه خودرو  </h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="container d-flex justify-content-center">
                                <div class="col-md-4 plateContainer ">
                                    <div class="plateItems col-12">
                                        <input tabindex="4" id="txtPlateP4" class="easyui-numberbox plateP4" required>
                                        <input tabindex="3" id="txtPlateP3" class="easyui-numberbox plateP3" required>
                                        <select tabindex="2" id="drpPlateP2" class="easyui-combobox plateP2" required></select>
                                        <input tabindex="1" id="txtPlateP1" class="easyui-numberbox plateP1" required>
                                    </div>
                                </div>
                            </div>





                            <div class="container d-flex justify-content-center" style="margin-bottom: 10px">
                                <div class="col-md-4">
                                    <button type="button" id="btnInquiry" onclick="inquiryPlate()"
                                        class="btn btn-3d btn-secondary mr-xs mb-sm col-md-12">
                                        استعلام</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card card-info bgrd" id="deviceInformation">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>مشخصات خودرو</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>

                        </div>
                    </div>
                    <div class="card-body">

                        <div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">VIN :</label>
                                        <input id="txtVin"  required data-options="validType:'length[17,17]',prompt:'شامل 17 عدد یا حرف '" class="form-control easyui-textbox Vin" />
                                    </div>
                                </div>


                            </div>


                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">سیستم :</label>
                                        <input id="txtSystem" required class="form-control easyui-textbox " />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">تیپ :</label>

                                        <input required id="txtTipStyle" class="form-control easyui-textbox ">
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5">مدل خودرو (سال تولید) :</label>
                                        <input required id="txtModel" data-options="validType:'length[4,4]',prompt:'شامل 4 عدد '" class="form-control easyui-numberbox Model ">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">رنگ :</label>
                                        <input required id="txtColor" class="form-control easyui-textbox ">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">ظرفیت حمل بار به کیلوگرم :</label>
                                        <input required id="txtCapacity" data-options="validType:'length[3,5]',prompt:'شامل 3 تا 5 عدد '" class="form-control easyui-numberbox CapacityKg ">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 " for="drpFuelTypeId">نوع سوخت :</label>
                                        <input required id="drpFuelTypeId" class="form-control easyui-combobox  ">
                                    </div>
                                </div>

                            </div>
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">شماره شاسی :</label>
                                        <input required id="txtChassisNumber" class="form-control easyui-textbox ">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">شماره موتور :</label>
                                        <input required id="txtEngineNumber" class="form-control easyui-textbox ">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">شماره بیمه شخص ثالث :</label>
                                        <input required id="txtInsuranceNumber" class="form-control easyui-textbox ">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">تاریخ صدور بیمه :</label>
                                        <input id="dpInsuranceDate"  maxlength="0" class="form-control  dpTextBox dpTextBox-Invalid">
                                        <input hidden id="dpInsuranceDateVal"/>
                                    </div>
                                </div>


                            </div>
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">نام شرکت بیمه :</label>
                                        <input id="InsuranceCompany" class="form-control easyui-textbox ">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">تاریخ صدور معاینه فنی :</label>
                                        <input maxlength="0" id="dpTechnicalDiagnosisCardDate" maxlength="0" class="form-control  dpTextBox dpTextBox-Invalid">
                                        <input hidden id="dpTechnicalDiagnosisCardDateVal"/>
                                    </div>
                                </div>
                            </div>

                            <br />
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">تصویر بیمه : </label>
                                        <input buttontext="انتخاب" id="LicensingInsuranceImage" class="form-control" data-options="label:'',prompt:'انتخاب فایل تصویر بیمه ...'">
                                        <img id="LicensingInsuranceImagePreviewBtn" src="#" alt="" style="margin: 0px 10px -10px 0px; width: 26px;" />
                                        <div id="LicensingInsuranceImageImg" class="easyui-dialog" title="نمایش تصویر" style="padding: 10px; width: 450px; min-height: 10px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">
                                            <img id="LicensingInsuranceImagePreview" src="#" style="max-width: 420px; min-height: 10px;" />
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 ">تصویر کارت معاینه فنی : </label>
                                        <input buttontext="انتخاب" id="TechnicalDiagnosisfuAttach" class="form-control" data-options="label:'',prompt:'انتخاب فایل معاینه فنی ...'">
                                        <img id="fuAttachTechnicalDiagnosisPreviewBtn" src="#" alt="" style="margin: 0px 10px -10px 0px; width: 26px;" />
                                        <div id="dlgTechnicalDiagnosisImg" class="easyui-dialog" title="نمایش تصویر" style="padding: 10px; width: 450px; min-height: 10px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">
                                            <img id="fuAttachTechnicalDiagnosisPreview" src="#" style="max-width: 420px; min-height: 10px;" />
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 " for="fuAttachLicense">تصویر برگ سبز خودرو : </label>
                                        <input buttontext="انتخاب" id="fuAttachLicense" class="form-control" data-options="label:'',prompt:'انتخاب فایل برگ سبز ...'">
                                        <img id="fuAttachLicensePreviewBtn" src="#" alt="" style="margin: 0px 10px -10px 0px; width: 26px;" />
                                        <div id="dlgLicenseImg" class="easyui-dialog" title="نمایش تصویر" style="padding: 10px; width: 450px; min-height: 10px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">
                                            <img id="fuAttachLicensePreview" src="#" style="max-width: 420px; min-height: 10px;" />
                                        </div>
                                    </div>
                                </div>

                                


                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>


                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-user"></i>مشخصات دسته بندی ناوگان را به دقت انتخاب نمایید</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>

                        </div>
                    </div>
                    <div class="card-body">


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 " >نوع ناوگان :</label>
                                    <input id="drpFleetType" class="form-control easyui-combobox ">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 " >دسته ناوگان :</label>

                                    <input id="drpCarCategory" class="form-control easyui-combobox ">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">کاربری ناوگان :</label>
                                    <input id="drpCarUsage" class="form-control easyui-combobox ">
                                </div>
                            </div>

                        </div>

                    </div>
                    <!-- /.card-body -->
                </div>

                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-user"></i>اطلاعات مالکیت خودرو ( مطابق برگ سبز )</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>

                        </div>
                    </div>
                    <div class="card-body" style="padding: 2.5rem;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 " for="drpOwnerShipType">نوع مالکیت :</label>
                                    <select id="drpOwnerShipType" class="form-control easyui-combobox "></select>
                                </div>
                            </div>
                        </div>


                        <div class="row" id="nationalCode_BirthDate">
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">کد ملی (مالک / مدیرعامل ) :</label>
                                    <input required id="txtNationalCode" data-options="parser:easyuiNumberParser,validType:'length[10,10]',prompt:'شامل 10 عدد '" class="form-control easyui-numberbox NationalCode ">
                                </div>
                            </div>


                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">تاریخ تولد ( مالک/مدیرعامل ) :</label>
                                    <input  id="txtBirthDate" autocomplete="off" maxlength="0" class="form-control  dpTextBox dpTextBox-Invalid">
                                    <input hidden id="txtBirthDateVal"/>
                                </div>
                            </div>

                        </div>


                        <div class="row" id="OrganizationName">
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">نام سازمان :</label>
                                    <input id="txtOrganizationName" class="form-control easyui-textbox ">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">شناسه ملی :</label>
                                    <input id="txtNationalId" data-options="validType:'length[11,11]',prompt:'شامل 11 عدد '" class="form-control easyui-numberbox NationalId ">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-5 ">شماره موبایل مالک / مدیرعامل :</label>
                                    <input id="txtMobileNumber" required data-options="validType: 'length[11,11]',  prefix:0,prompt:'شامل 11 عدد '" class="form-control easyui-numberbox MobileNumber">
                                </div>
                            </div>
                            <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-5 " for="personalImage">تصویر پرسنلی : </label>
                                        <input buttontext="انتخاب" id="personalImage" class="form-control" data-options="label:'',prompt:'انتخاب فایل تصویر پرسنلی ...'">
                                        <img id="personalImagePreviewBtn" src="#" alt="" style="margin: 0px 10px -10px 0px; width: 26px;" />
                                        <div id="dlgPersonImg" class="easyui-dialog" title="نمایش تصویر" style="padding: 10px; width: 450px; min-height: 10px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">
                                            <img id="personalImagePreview" src="#" style="max-width: 420px; min-height: 10px;" />
                                        </div>
                                    </div>
                                </div>


                        </div>



                    </div>

                </div>

                <div class="container d-flex justify-content-center" style="margin-bottom: 10px">
                    <div class="col-md-4">
                        <button type="button" id="btnSave" onclick="save()"
                            class="btn btn-3d btn-success mr-xs mb-sm col-md-12">
                            ثبت و ارسال</button>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
    </div>


</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">

    <script>

        var greenCardLicensing = '';
        var technicalLicensing = '';
        var insuranceImage = '';

        $(function () {

            $(".easyui-combobox").combobox({
                /*width: '300px',*/
                /*width: '100%',*/
                required: true,
                //    panelHeight: 'auto',
                //    required: 'True',
                //    width: '165px',
                //    editable: false,
                //    labelWidth: '140px'
                multiple: false
            });

            $('#txtTownBirth').combobox({
                method: 'get',
                url: '/CoreServices/API/SateCity/GetStateList',
                valueField: 'StateId',
                textField: 'Name',
                multiple: false,
                onLoadSuccess: function () {
                    //if (globalCurrentLicensing)
                    //    $('#txtTownBirth').combobox('setValue', globalCurrentLicensing.BirthStateId);
                },
                onChange: function () {
                    
                    var endSelected = $('#txtTownBirth').combobox('getValue');
                    $('#txtCityBirth').combobox({
                        method: 'get',
                        url: '/CoreServices/API/SateCity/GetCityList?stateId=' + endSelected,
                        valueField: 'CityId',
                        textField: 'Name',
                        multiple: false,
                        onLoadSuccess: function () {
                            
                            //if (globalCurrentLicensing)
                            //    $('#txtCityBirth').combobox('setValue', globalCurrentLicensing.BirthCityId);
                        }
                    });
                }
            });

            $('#drpOwnerShipType').combobox({
                method: 'get',
                url: '/CoreServices/API/Base/FleetOwnershipTypes',
                valueField: 'FleetOwnershipTypeId',
                textField: 'Title',
                multiple: false,
            });

            $('#drpFuelTypeId').combobox({
                method: 'get',
                url: '/CoreServices/API/Base/FuelTypes',
                valueField: 'FuelTypeId',
                textField: 'Title',
                multiple: false,
            });

            $('#drpCarUsage').combobox({
                method: 'get',
                url: '/CoreServices/API/Base/CarUsages',
                valueField: 'CarUsageId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function () {
                    // var Selected = $('#txtCityBirth').combobox('getValue');
                }
            });
            $('#drpFleetType').combobox({
                method: 'get',
                url: '/CoreServices/API/Base/FleetTypes',
                valueField: 'FleetTypeId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function () {

                    // var endSelected = $('#txtTownBirth').combobox('getValue');
                },
                onChange: function () {

                    var endSelected = $('#drpFleetType').combobox('getValue');


                    $('#drpCarCategory').combobox({
                        method: 'get',
                        url: '/CoreServices/API/Base/CarCategories?fleetTypeId=' + endSelected,
                        valueField: 'CarCategoryId',
                        textField: 'Title',
                        multiple: false,
                        onLoadSuccess: function () {

                            //if (globalCurrentLicensing)
                            //    $('#drpCarCategory').combobox("setValue", globalCurrentLicensing.CarCategoryId);
                        }
                    });


                }
            });
            $('#drpDegreeEducation').combobox({//مدرک
                method: 'get',
                url: '/CoreServices/API/Base/EducationDegrees',
                valueField: 'EducationDegreeId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function (data) {
                    //$('#drpDegreeEducation').combobox('setValue', data[2].Title);

                }
            });
            $('#drpSacrificialStatus').combobox({//ایثارگری
                method: 'get',
                url: '/CoreServices/API/Base/SacrificialStatuses',
                valueField: 'SacrificialStatusId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function (data) {

                    // $('#drpSacrificialStatus').combobox('setValue', data[4].Title);
                }
            });
            $('#drpPhysicalCondition').combobox({//وضعیت جسمانی
                method: 'get',
                url: '/CoreServices/API/Base/PhysicalConditions',
                valueField: 'PhysicalConditionId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function (data) {
                    //$('#drpPhysicalCondition').combobox('setValue', data[5].Title);
                }
            });
            $('#drpMilitaryServiceStatus').combobox({//وضعیت نظام وظیفه
                method: 'get',
                url: '/CoreServices/API/Base/SoldierShipStatuses',
                valueField: 'SoldiershipStatusId',
                textField: 'Title',
                multiple: false,
                onLoadSuccess: function (data) {
                    //$('#drpMilitaryServiceStatus').combobox('setValue', data[2].Title);
                }
            });
            $('#InsuranceCompany').combobox({//شرکت بیمه
                method: 'get',
                url: '/CoreServices/API/Base/InsuranceCompanies',
                valueField: 'InsuranceCompanyId',
                textField: 'Title',
                required: 'True',
                multiple: false,
                onLoadSuccess: function (data) {
                    //$('#drpMilitaryServiceStatus').combobox('setValue', data[2].Title);
                }
            });

            
        
            //$('#dpInsuranceDate').MdPersianDateTimePicker({
            //    targetTextSelector: '#dpInsuranceDate',
            //    targetDateSelector: '#dpInsuranceDateVal',
            //    dateFormat: 'yyyy/MM/dd',
            //    textFormat: 'yyyy/MM/dd',

            //});

            //$('#dpTechnicalDiagnosisCardDate').MdPersianDateTimePicker({
            //    targetTextSelector: '#dpTechnicalDiagnosisCardDate',
            //    targetDateSelector: '#dpTechnicalDiagnosisCardDateVal',
            //    dateFormat: 'yyyy/MM/dd',
            //    textFormat: 'yyyy/MM/dd',

            //});
            //$('#txtBirthDate').MdPersianDateTimePicker({
            //    targetTextSelector: '#txtBirthDate',
            //    targetDateSelector: '#txtBirthDateVal',
            //    dateFormat: 'yyyy/MM/dd',
            //    textFormat: 'yyyy/MM/dd',

            //});



            //$("#dpInsuranceDate,#dpTechnicalDiagnosisCardDate,#txtBirthDate").persianDatepicker({
            //    observer: true,
            //    required: true,
            //    format: 'YYYY/MM/DD',
            //    initialValue: false,
            //    calendar: {
            //        persian: {
            //            locale: 'fa'
            //        }
            //    },
            //    //altField: '.observer-example-alt'
            //});

        })

        async function fillImagesVariables() {
            return new Promise(async (resolve, reject) => {
                try {
                    greenCardLicensing = await getBase64Image("#fuAttachLicense");
                    technicalLicensing = await getBase64Image("#TechnicalDiagnosisfuAttach");
                    personalImage = await getBase64Image("#personalImage");
                    insuranceImage = await getBase64Image("#LicensingInsuranceImage");



                    resolve(true);
                } catch (e) {
                    resolve(false);
                }
            });
        }


        $(function () {

            $('#fuAttachLicense').filebox({
                accept: 'image',
                required: true,
                onChange: function myfunction() {

                    var input = $('#fuAttachLicense').next().find('.textbox-value')[0];
                    var size = input.files[0].size;
                    var sizeKb = size / 1024;
                    if (size > 809600) {

                        $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 800 کیلوبایت میباشد', 'warning');
                        return;
                    }
                    //var size= alert($('#fuAttachLicense').input.files[0].size);
                    if (input.files && input.files[0]) {
                        $('#fuAttachLicensePreviewBtn').attr('src', "/Resources/Dist/Images/large_picture.png");
                        $('#fuAttachLicensePreviewBtn').click(function () {
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $('#fuAttachLicensePreview')
                                    .attr('src', e.target.result);

                            };
                            reader.readAsDataURL(input.files[0]);
                            $('#dlgLicenseImg').dialog('open').dialog('center');
                        });
                    }
                }
            });

            $('#TechnicalDiagnosisfuAttach').filebox({
                accept: 'image',
                required: true,
                onChange: function myfunction() {

                    var input = $('#TechnicalDiagnosisfuAttach').next().find('.textbox-value')[0];
                    var size = input.files[0].size;
                    var sizeKb = size / 1024;
                    if (size > 809600) {

                        $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 800 کیلوبایت میباشد', 'warning');
                        return;
                    }
                    //var size= alert($('#fuAttachLicense').input.files[0].size);
                    if (input.files && input.files[0]) {
                        $('#fuAttachTechnicalDiagnosisPreviewBtn').attr('src', "/Resources/Dist/Images/large_picture.png");
                        $('#fuAttachTechnicalDiagnosisPreviewBtn').click(function () {
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $('#fuAttachTechnicalDiagnosisPreview')
                                    .attr('src', e.target.result);

                            };
                            reader.readAsDataURL(input.files[0]);
                            $('#dlgTechnicalDiagnosisImg').dialog('open').dialog('center');
                        });
                    }
                }
            });

            $('#personalImage').filebox({
                accept: 'image',
                required: false,
                onChange: function myfunction() {

                    var input = $('#personalImage').next().find('.textbox-value')[0];
                    var size = input.files[0].size;
                    var sizeKb = size / 1024;
                    if (size > 809600) {

                        $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 800 کیلوبایت میباشد', 'warning');
                        return;
                    }
                    //var size= alert($('#personalImage').input.files[0].size);
                    if (input.files && input.files[0]) {
                        $('#personalImagePreviewBtn').attr('src', "/Resources/Dist/Images/large_picture.png");
                        $('#personalImagePreviewBtn').click(function () {
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $('#personalImagePreview')
                                    .attr('src', e.target.result);

                            };
                            reader.readAsDataURL(input.files[0]);
                            $('#dlgPersonImg').dialog('open').dialog('center');
                        });
                    }
                }
            });


            $('#LicensingInsuranceImage').filebox({
                accept: 'image',
                required: true,
                onChange: function myfunction() {

                    var input = $('#LicensingInsuranceImage').next().find('.textbox-value')[0];
                    var size = input.files[0].size;
                    var sizeKb = size / 1024;
                    if (size > 809600) {

                        $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 800 کیلوبایت میباشد', 'warning');
                        return;
                    }
                    //var size= alert($('#fuAttachLicense').input.files[0].size);
                    if (input.files && input.files[0]) {
                        $('#LicensingInsuranceImagePreviewBtn').attr('src', "/Resources/Dist/Images/large_picture.png");
                        $('#LicensingInsuranceImagePreviewBtn').click(function () {
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $('#LicensingInsuranceImagePreview')
                                    .attr('src', e.target.result);

                            };
                            reader.readAsDataURL(input.files[0]);
                            $('#LicensingInsuranceImageImg').dialog('open').dialog('center');
                        });
                    }
                }
            });
        });





        async function save() {


            

            if (!$('#frmCarEdit').form('validate')) {
                $.messager.alert('اخطار', 'لطفا موارد اجباری را وارد نمایید', 'اخطار');
                return;
            }

            var vin = $('#txtVin').textbox('getValue');
            if (vin.length !== 17) {
                $.messager.alert('خطا', 'وین وارد شده اشتباه می باشد.', 'error');
                return;
            }


            var plateNo = getPlateNoEu(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plateNo.length !== 9) {
                return;
            }


            var system = $("#txtSystem").textbox("getValue");
            var style = $("#txtTipStyle").textbox("getValue");
            var model = $('#txtModel').textbox('getValue');//مدل خودرو
            var color = $("#txtColor").textbox("getValue");
            var capacity = $('#txtCapacity').textbox('getValue');//ظرفیت
            var fuelTypeId = $("#drpFuelTypeId").combobox('getValue');
            var chassisNumber = $('#txtChassisNumber').textbox('getValue');//شماره شاسی
            var engineNumber = $('#txtEngineNumber').textbox('getValue');//شماره موتور
            var insuranceNumber = $('#txtInsuranceNumber').textbox('getValue');//شماره بیمه شخص ثالث
            var insuranceDate = $('#dpInsuranceDate').dpGetEnValue(); //تاریخ صدور بیمه
            var insuranceCompanyId = $('#InsuranceCompany').combobox('getValue');
            var technicalDiagnosisCardDate = toEnglishNumber($('#dpTechnicalDiagnosisCardDate').val()); //تاریخ صدور معاینه فنی

            var fleetTypeId = $('#drpFleetType').combobox('getValue');//نوع ناوگان
            var categoryId = $('#drpCarCategory').textbox("getValue");
            var usageId = $('#drpCarUsage').combobox('getValue');//کاربری ناوگان
            var ownerShipType = $('#drpOwnerShipType').combobox('getValue');
            var nationalCode = $("#txtNationalCode").textbox("getValue");
            var birthDate = $('#txtBirthDate').dpGetEnValue();//تاریخ تولد
            var organizationName = $('#txtOrganizationName').textbox('getValue');//نام سازمان
            var nationalId = $('#txtNationalId').textbox('getValue');//شناسه ملی
            var mobileNumber = $('#txtMobileNumber').textbox('getValue');//شناسه ملی


            if (insuranceDate == '' || insuranceDate == null) {
                $.messager.alert('اخطار', 'لطفا تاریخ صدور بیمه نامه را وارد نمایید', 'اخطار');
                return;
            }



            if (ownerShipType == '3' || ownerShipType == '4') {//اگر نوع مالکیت حقوقی خصوصی یا شهرداری بود
                if (nationalId.length < 11) {
                    $.messager.alert('اخطار', 'شناسه ملی سازمان وارد شده نمیتواند از یازده رقم کمتر باشد', 'اخطار');
                    return;
                }
            }



            
            var vehicle = {

                VIN: vin,
                PlateNo: plateNo,
                System: system,
                StyleTip: style,
                Color: color,
                Model: model,
                OwnerCellPhone: mobileNumber,
                CapacityKg: capacity,
                EnginNo: engineNumber,
                ChassisNo: chassisNumber,
                CarCategoryId: categoryId,
                SymfaIssueDate: technicalDiagnosisCardDate,
                CarUsageId: usageId,
                FuelTypeId: fuelTypeId,

            };



            // Decleare Varibles
            var licensing = {

                Vin: vin,
                PlateNo: plateNo,
                Capacity: capacity,
                EngineNumber: engineNumber,
                ChassisNumber: chassisNumber,
                InsuranceNumber: insuranceNumber,
                InsuranceDate: insuranceDate,
                TechnicalDiagnosisCardDate: technicalDiagnosisCardDate,

                FleetTypeId: fleetTypeId,
                OwnerShipTypeId: ownerShipType,
                CarUsageId: usageId,
                FuelTypeId: fuelTypeId,
                CarCategoryId: categoryId,
                NationalCode: nationalCode,
                OrganizationName: organizationName,
                NationalId: nationalId,
                MobileNumber: mobileNumber,
                EnBirthDate: birthDate,
                InsuranceCompanyId: insuranceCompanyId

            }

            await fillImagesVariables();


            var param = {
                guestVehicle: vehicle,
                guestLicensing: licensing,
                greenCardImage: greenCardLicensing,
                technicalDiagnosisCardImage: technicalLicensing,
                insuranceCardImage: insuranceImage,
                personalImage: personalImage
            }

            $.messager.progress({ ctitle: 'لطفا صبر کنید...' });



            $.ajax({
                url: '/CoreServices/API/Licensing/SaveLicensingGuest',
                type: 'Post',
                contentType: 'application/json',
                data: JSON.stringify({
                    //param
                    guestVehicle: vehicle,
                    guestLicensing: licensing,
                    greenCardImage: greenCardLicensing,
                    technicalDiagnosisCardImage: technicalLicensing,
                    insuranceCardImage: insuranceImage,
                    personalImage: personalImage
                }),
                success: function (data) {
                    $.messager.progress('close');
                    if (data.IsSuccessful === true) {

                        //$("#btnSave").linkbutton('disable');
                        $('#btnSave').prop('disabled', true);

                        $.messager.alert('پیغام سیستمی', data.Message, 'info');

                        //$('#btnSave').linkbutton('disable');
                        //check();

                        //$('#txtVin').textbox('setValue', lic.LicensingDate);
                        //$('#txtCarSystem').textbox('setValue', lic.InsuranceNumber);

                    }
                    else {
                        //$('#btnSave').linkbutton('enable');
                        $('#btnSave').prop('disabled', false);

                        $.messager.alert('خطا', data.Message, 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('cAjax Error', errorThrown, 'error');
                    $.messager.progress('close');

                }
            });



        };




        function inquiryPlate() {



            var plateNo = getPlateNoEu(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plateNo.length !== 9) {
                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Car/ValidateAccessPlateForAnyProduct',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    plateNo: plateNo,
                    companyId: 0,
                    driverId: 0
                },
                async: true,
                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful == false) {

                        $.messager.alert('توجه', 'خودروی مورد نظر ثبت نشده است. نسبت به ثبت اطلاعات زیر مطابق با برگ سبز اقدام نمایید.', 'warning');
                    }
                    else {
                        $.messager.alert('توجه', 'اطلاعات خودروی مورد نظر در سامانه وجود دارد. نیاز به ثبت مجدد اطلاعات نیست. در صورت نیاز به اخذ پروانه فعالیت از طریق Utcms اقدام نمایید.');
                    }


                },

                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');

                }
            })
        }



        //$(document).ready(function () {
        //    restrictAccess("#frmCarEdit", ["#btnSave"]);
        //});



    </script>
</asp:Content>
