﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true"
    CodeBehind="ResetPassword.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Users.ResetPassword" %>

    <asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
        <style>
            .login-container {
                width: 95%;
                max-width: 600px;
                /* Increased from 400px */
                margin: 0 auto;
                padding: 2rem 0;
            }

            /* Responsive adjustments */
            @media (max-width: 768px) {
                .login-container {
                    width: 90%;
                    min-width: 280px;
                }
            }

            .card {
                border: none;
                box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
                border-radius: 15px;
                overflow: hidden;
                transition: transform 0.2s;
            }

            /* .card:hover {
            transform: translateY(-5px);
        } */

            .card-header {
                background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
                border: none;
                padding: 1.5rem;
            }

            .card-header h3 {
                color: white;
                font-size: 1.5rem;
                margin: 0;
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
            }

            .card-body {
                padding: 2rem 2rem 2rem 2rem;
            }

            .input-field {
                border: 1px solid #ced4da;
                /* Bootstrap default border color */
                border-radius: 0.25rem;
                /* Bootstrap default border radius */
                display: flex;
                align-items: center;
                padding: 0.375rem 0.75rem;
                /* Bootstrap default padding */
                position: relative;
                margin-bottom: 1rem;
                transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                background: #f8f9fa;
                transition: all 0.3s ease;
            }

            .input-field:focus-within {
                border-color: #86b7fe;
                /* Bootstrap default focus border color */
                outline: 0;
                box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, .25);
                /* Bootstrap default focus shadow */
            }

            .input-field:hover {
                background: #fff;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            }

            .input-field input {
                border: none;
                outline: none;
                width: 100%;
                box-shadow: none;
                text-align: center;
                direction: ltr;
                padding: 0;
                /* Remove default input padding */
                background: transparent;
                /* Remove default input background */
                background-color: transparent !important;
                font-family: 'Vazirmatn' !important;
                font-size: 1.1rem !important;
                /* letter-spacing: 1px; */
            }

            .input-field .icon {
                color: dimgray;
                padding: 2px;
            }

            .toggle-password {
                cursor: pointer;
                position: absolute;
                left: 10px;
                color: dimgray;
            }

            .captcha-section {
                text-align: center;
                padding: 1rem 1rem 0 1rem;
                background: #f8f9fa;
                border-radius: 10px;
                padding: 1.5rem;
                /*margin: 1rem 0;*/
            }

            .captcha-wrapper {
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 0.5rem;
                margin-bottom: 1rem;
                padding: 0.5rem;
                /* Added padding for better spacing */
            }

            .captcha-wrapper img {
                width: 60;
                /* Increased from 160px */
                height: auto;
                object-fit: contain;
            }

            .refresh-btn {
                background: none;
                border: none;
                color: dimgray;
                cursor: pointer;
                font-size: 1.125rem;
                color: #0093E9;
                transition: transform 0.3s ease;
            }

            .refresh-btn:hover {
                transform: rotate(180deg);
            }

            .captcha-input {
                width: 80%;
                margin: 0 auto;
            }

            .captcha-input input {
                text-align: center !important;
                direction: ltr !important;
                width: 100%;
                border: 1px solid #ced4da;
                border-radius: 0.25rem;
                padding: 0.375rem 0.75rem;
                transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                background-color: transparent !important;
                font-family: 'Vazirmatn' !important;
                font-size: 1.1rem !important;
            }

            .captcha-input input:focus {
                border-color: #86b7fe;
                outline: 0;
                box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, .25);
            }

            .office-section {
                margin: 1rem 0;
            }

            .office-checkbox {
                width: 20px;
                height: 20px;
                margin-right: 0.5rem;
            }

            .loginGuide-section {
                /*text-align: center;*/
                /*padding: 1rem 0;*/
                background: #f8f9fa;
                border-radius: 10px;
                padding: 1.5rem;
                margin: 1rem 0;
                /*border: 1px solid red; */
                margin-left: 1.5rem;
                margin-right: 1.5rem;


            }

            .button-section {
                /*background: #f8f9fa;
            border-top: 1px solid rgba(0,0,0,0.05);*/
                margin-left: 1.5rem;
                margin-right: 1.5rem;
            }

            .app-section {
                display: flex;
                gap: 1rem;
                justify-content: center;
                flex-wrap: wrap;
                padding: 1rem;
            }

            .app-section img {
                width: clamp(80px, 15vw, 120px);
                height: auto;
            }

            /* Prevent browser autofill background colors */
            input:-webkit-autofill,
            input:-webkit-autofill:hover,
            input:-webkit-autofill:focus,
            input:-webkit-autofill:active {
                -webkit-box-shadow: 0 0 0 30px white inset !important;
                -webkit-text-fill-color: inherit !important;
                transition: background-color 5000s ease-in-out 0s;
            }

            /* Common input styles */
            input {
                font-family: 'Vazirmatn' !important;
                font-size: 1rem !important;
            }

            /* Adjust placeholder color and size */
            ::placeholder {
                font-family: 'Vazirmatn' !important;
                font-size: 1rem !important;
                opacity: 0.7;
            }

            .input-label {
                display: block;
                text-align: right;
                margin-bottom: 0.3rem;
                font-weight: 500;
                color: #495057;
                font-family: 'Vazirmatn';
                font-size: 0.95rem;
                margin-bottom: 0.5rem;
                color: #2c3e50;
            }

            .icon {
                color: #0093E9;
                font-size: 1.1rem;
            }

            .btn {
                border-radius: 8px;
                font-weight: 500;
                padding: 0.6rem 1.2rem;
                transition: all 0.3s ease;
            }

            .btn-success {
                background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
                border: none;
            }

            .btn-info {
                background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
                border: none;
            }

            .card-footer {
                background: #fff;
                border-top: 1px solid rgba(0, 0, 0, 0.05);
                padding: 1rem;
            }

            .card-footer a {
                color: #0093E9;
                text-decoration: none;
                transition: color 0.3s ease;
            }

            .card-footer a:hover {
                color: #0056b3;
            }

            /* Improve spacing between elements */
            .form-group {
                margin-bottom: 1.5rem;
            }

            /* Enhanced mobile responsiveness */
            @media (max-width: 768px) {
                .card-body {
                    padding: 1.5rem;
                }

                .button-section {
                    padding: 1rem;
                }

                .captcha-wrapper img {
                    width: 80%;
                    /* Increased from 160px */
                    height: auto;
                    object-fit: contain;
                }
            }

            @media (max-width: 576px) {
                .captcha-wrapper img {
                    width: 100%;
                    /* Increased from 160px */
                    height: auto;
                    object-fit: contain;
                }
            }


            .form-text {
                font-size: 0.875rem;
                margin-top: 0.25rem;
            }

            .text-danger {
                color: #dc3545;
            }

            .input-field:focus-within {
                border-color: #80bdff;
                box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
            }

            input:valid {
                /* border-color: #28a745; */
            }

            input:invalid {
                /* border-color: #dc3545; */
            }

            .hint-text {
                text-align: left;
            }
        </style>
        <div class="login-container">
            <div class="card card-info">
                <div class="card-header">
                    <h3 class="card-title">باز نشانی گذر واژه</h3>
                </div>
                <div class="card-body">
                    <form id="frmReset" class="needs-validation" novalidate>
                        <div class="form-group">
                            <label class="input-label" for="txtNationalCodeId">کد/شناسه ملی :</label>
                            <div class="input-field">
                                <span class="far fa-id-card icon" aria-hidden="true"></span>
                                <input type="text" class="form-control" id="txtNationalCodeId" name="nationalCodeId"
                                    required autocomplete="off" inputmode="numeric" dir="ltr" minlength="10"
                                    maxlength="11" placeholder="کد یا شناسه ملی را وارد کنید" pattern="^\d{10,11}$"
                                    oninvalid="validateNationalCodeId(this);" oninput="validateNationalCodeId(this);" onblur="validateNationalCodeId(this);"
                                    aria-describedby="nationalCodeIdHint">
                            </div>
                            <small id="nationalCodeIdHint" class="form-text text-muted hint-text">
                                مثال: ۰۰۱۲۳۴۵۶۷۸
                            </small>
                        </div>
                        <div class="form-group">
                            <label class="input-label" for="txtMobileNumber">شماره تلفن همراه :</label>
                            <div class="input-field">
                                <span class="fas fa-mobile-alt icon" aria-hidden="true"></span>
                                <input type="text" class="form-control" id="txtMobileNumber" name="mobileNumber"
                                    required autocomplete="mobileNumber" inputmode="numeric" dir="ltr" minlength="11"
                                    maxlength="11" placeholder="شماره تلفن همراه را وارد کنید" pattern="^09\d{9}$"
                                    oninvalid="validateMobileNumber(this);" oninput="validateMobileNumber(this);" onblur="validateMobileNumber(this);"
                                    aria-describedby="mobileNumberHint">
                            </div>
                            <small id="mobileNumberHint" class="form-text text-muted hint-text">
                                مثال: ۰۹۱۲۳۴۵۶۷۸۹
                            </small>
                        </div>
                        <!-- New captcha section inserted above the buttons -->
                        <div class="form-group captcha-section">
                            <div class="captcha-wrapper">
                                <img id="captchaImage" src="/App_handlers/captcha.ashx" alt="کد امنیتی">
                                <button type="button" class="refresh-btn" onclick="refreshCaptcha()"
                                    aria-label="تازه سازی کد امنیتی">
                                    <i class="fas fa-sync-alt"></i>
                                </button>
                            </div>
                            <div class="captcha-input">
                                <input type="text" id="txtCaptcha" name="captcha" class="form-control"
                                    placeholder="کد امنیتی را وارد کنید" required inputmode="numeric" autocomplete="off"
                                    dir="ltr" minlength="5" maxlength="5" pattern="^\d{5}$"
                                    aria-describedby="captchaHint" oninvalid="validateCaptcha(this);"
                                    oninput="validateCaptcha(this);" onblur="validateCaptcha(this);">
                                <small id="captchaHint" class="form-text text-muted hint-text" style="height:8px">
                                    کد ۵ رقمی نمایش داده شده را وارد کنید
                                </small>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="button" id="btnReset" onclick="sendPass()"
                                class="btn btn-info float-right col-md-12 mt-3">
                                دریافت رمز عبور جدید
                            </button>
                        </div>
                        <!-- New timer display element below the button -->
                        <div id="timer" style="text-align:center; margin-top:10px; font-size:0.9rem;"></div>
                        <div id="loginButtonContainer" style="display:none; text-align:center; margin-top:10px;">
                            <button type="button" id="btnLogin" class="btn btn-success col-md-12"
                                onclick="window.location.href='/Login.aspx';">
                                ورود به سیستم
                            </button>
                        </div>
                        <div style="height: 25px;">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </asp:Content>

    <asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
        <script src="/Resources/dist/js/CustomValidations.js" type="text/javascript"></script>
        <script>
            function refreshCaptcha() {
                // Updated URL to point to the new captcha handler
                document.getElementById('captchaImage').src = "/App_handlers/captcha.ashx?" + new Date().getTime();
            }
            function sendPass() {
                var form = document.getElementById("frmReset");
                if (!form.checkValidity()) {
                    form.reportValidity();
                    return;
                }

                // Disable the button and start timer
                $("#btnReset").prop("disabled", true);

                var countdown = 20; // Updated countdown to 120 seconds
                $("#timer").text("لطفا " + countdown + " ثانیه صبر کنید");
                var timerInterval = setInterval(function () {
                    countdown--;
                    $("#timer").text("لطفا " + countdown + " ثانیه صبر کنید");
                    if (countdown <= 0) {
                        clearInterval(timerInterval);
                        $("#timer").text("");
                        $("#btnReset").prop("disabled", false); // Enable the button after timer finishes
                    }
                }, 1000);

                // Removed setTimeout enabling btnReset

                // Updated: Include the captcha value from txtCaptcha in the AJAX parameters for captcha validation
                var param = {
                    NationalCodeId: $.trim($("#txtNationalCodeId").val()),  // Trimmed input
                    MobileNumber: $.trim($("#txtMobileNumber").val()),      // Trimmed input
                    Captcha: $.trim($("#txtCaptcha").val())                // Trimmed input
                };

                $.messager.progress({ title: 'لطفا صبر کنید...' });

                $.ajax({
                    url: '/CoreServices/API/Users/ClientResetRandomPassword', // Ensure correct API URL
                    method: 'POST', // Fix case sensitivity
                    contentType: 'application/json',
                    dataType: 'json', // Ensure response is handled as JSON
                    data: JSON.stringify(param),
                    success: function (data) {
                        $.messager.progress('close');

                        if (data && data.IsSuccessful) { // Safe check for `data`
                            clearInterval(timerInterval); // Stop the timer immediately
                            $.messager.alert('پیام سیستم', data.Message, 'info');

                            // Clear timer message, remove btnReset, and show the login button
                            $("#timer").text("");
                            $("#btnReset").remove();
                            $("#loginButtonContainer").show();
                        } else {
                            $.messager.alert('خطای سیستم', data?.Message || 'مشکلی پیش آمده است', 'error');
                            refreshCaptcha(); // Ensure `refreshCaptcha` is defined and works
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        $.messager.progress('close');
                        console.error("Error Details:", xhr.responseText); // Debugging
                        $.messager.alert('خطای سیستم', 'خطای سمت سرور پیش آمده', 'error');
                    }
                });

            }

            



        </script>
    </asp:Content>