﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="TrafficLicenseRequest.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.TrafficLicense.TrafficLicenseRequest" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    
    <style>
        .wizard > .content {
            min-height: 31em !important;  
        }
        /* Mobile responsive CSS adjustments */
        @media screen and (max-width: 768px) {
            .content-wrapper { padding: 10px !important; }
            .plateContainer, .card-body { width: 100% !important; }
            .plateItems input, .plateItems select { width: 100% !important; margin-bottom: 10px; }
            .form-group { flex-direction: column; align-items: flex-start; }
            .form-group label { width: 100%; margin-bottom: 5px; }
            /* jQuery Steps: force full width and adjust button sizing */
            .steps ul li { font-size: 14px; }
            .actions a { padding: 10px 15px; font-size: 14px; }
        }
    </style>


    <div class="content-wrapper" style="padding: 20px;">


        <div id="wizard-form" class="wizard-form">
            <fieldsettitle>انتخاب خودرو </fieldsettitle>
            <fieldset>
                <div class="fieldset-content">
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <span class="card-title"><i class="fa fa-car"></i>ثبت پلاک خودرو </span>
                        </div>
                        <div class="card-body">
                            <div class="container d-flex justify-content-center">
                                <div class="col-md-4 plateContainer ">
                                    <div class="plateItems col-12">
                                        <input tabindex="4" id="txtPlateP4" class="easyui-numberbox plateP4" required >
                                        <input tabindex="3" id="txtPlateP3" class="easyui-numberbox plateP3" required>
                                        <select tabindex="2" id="drpPlateP2" class="easyui-combobox plateP2" required></select>
                                        <input tabindex="1" id="txtPlateP1" class="easyui-numberbox plateP1" required>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>

            </fieldset>

            <fieldsettitle>مشخصات خودروی منتخب </fieldsettitle>
            <fieldset>

                <div class="fieldset-content">
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <span class="card-title"><i class="fa fa-car"></i>مشخصات </span>
                        </div>
                        <div class="card-body">

                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">پلاک :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtPlateNo">
                                </div>


                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">VIN :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtVIN">
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">سیستم :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarSystem">
                                </div>


                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">تیپ :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarStyle">
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">رنگ :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarColor">
                                </div>


                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">مالک :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarOwnerName">
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">نوع خودرو :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarCategory">
                                </div>
                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">اعتبار پروانه :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtLicenseStatusTitle">
                                </div>
                            </div>
                            <br />
                            <div class="row" style="text-align: center !important; -webkit-text-fill-color: red;">
                                <div>شهروند گرامی ، به اطلاعات ثبت شده دقت نمایید . در صورت مغایرت اطلاعات ثبت شده با برگ سبز ، از طریق منوی پشتیبانی ، نسبت به اعلام مغایرت اقدام نمایید.</div>
                            </div>

                        </div>

                    </div>
                </div>

            </fieldset>

            <fieldsettitle>جزییات مجوز درخواستی </fieldsettitle>
            <fieldset>
                <div class="fieldset-content">

                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <span class="card-title"><i class="fa fa-car"></i>انتخاب فعالیت اصلی </span>
                        </div>
                        <div class="card-body">
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">فعالیت اصلی :</label>
                                    <input name="drpCargoTypes" id="drpCargoTypes" required class="easyui-combobox" style="width: 100% !important">
                                </div>


                            </div>
                        </div>
                    </div>

                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <span class="card-title"><i class="fa fa-car"></i>انتخاب تاریخ تردد </span>
                        </div>
                        <div class="card-body">
                            <!--<form id="frmVoucherEdit">-->

                            <div class="row">

                                <div class="form-group col-md-12" style="display: flex;">
                                    <label class="col-md-2 control-label">نوع مجوز :</label>
                                    <input id="drpLicenseKind" required class="easyui-combobox" style="width: 100% !important">
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-12" style="display: flex;">
                                    <label class="col-md-2 control-label">توضیحات :</label>
                                    <label id="txtDescription" class="form-control-plaintext">
                                        &nbsp;<br><br>
                                    </label>
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">از تاریخ (شامل) :</label>
                                    <input id="txtFromDate" class="form-control dpTextBox dpTextBox-Invalid" required style="text-align: center">
                                    <input hidden id="txtFromDateVal" />
                                </div>

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-4 control-label">تا تاریخ (شامل) :</label>
                                    <input id="txtToDate" class="form-control dpTextBox dpTextBox-Invalid" required style="text-align: center">
                                    <input hidden id="txtToDateVal" />
                                </div>

                            </div>



                        </div>
                        <!-- /.card-body -->
                    </div>

                </div>

            </fieldset>


            <fieldsettitle>ثبت درخواست </fieldsettitle>
            <fieldset>
                <div class="fieldset-content">

                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <span class="card-title"><i class="fa fa-car"></i>پیش نویس درخواست </span>
                        </div>
                        <div class="card-body">
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">پلاک :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtMISPlate">
                                </div>

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">نوع خودرو :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarCategoryTitle">
                                </div>
                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">فعالیت اصلی :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCargoTitle">
                                </div>

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">نوع مجوز :</label>
                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtLicenseTypeTitle">
                                </div>

                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">از تاریخ (شامل) :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtAFromDate">
                                </div>


                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">تا تاریخ مورد تایید (شامل ) :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtAToDate">
                                </div>


                            </div>
                            <div class="row">

                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">نحوه محاسبه :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCalcDesc">
                                </div>
                                <div class="form-group col-md-6" style="display: flex;">
                                    <label class="col-md-5 control-label">هزینه (ریال ) :</label>

                                    <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtPrice">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6" style="display: flex;">
                                </div>
                                <div class="form-group col-md-6" style="display: flex;">

                                    <div>شهروند گرامی ،جهت صدور نهایی مجوز انتخاب شده ،  کیف پول شما باید حداقل به میزان مبلغ اعلام شده شارژ شود.</div>

                                </div>
                            </div>
                        </div>

                    </div>

                </div>


            </fieldset>



        </div>

    </div>


</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>



        (function ($) {
            var po = $.fn.combobox.parseOptions;
            $.fn.combobox.parseOptions = function (target) {
                return $.extend({}, po(target), {
                    width: $(target).outerWidth()
                });
            }
        })(jQuery);

        var allowMove = false;

        $("#wizard-form").steps({
            headerTag: "fieldsetTitle",
            bodyTag: "fieldset",
            
            labels: {
                previous: 'مرحله قبل',
                next: 'مرحله بعد',
                finish: 'ثبت درخواست',
                current: '',
                cancel: 'شروع مجدد'
            },
            titleTemplate: '<div class="title"><span class="number">#index# . </span>#title#</div>',
            onCanceled: function (event) {
                $("#wizard-form").steps('reset');
                $("#wizard-form").steps('cssButton', 'cancel', 'float', 'left');
                allowMove = false;
                return true;
            },
            onStepChanging: function (event, currentIndex, newIndex) {

                if (currentIndex > newIndex) {
                    allowMove = false;
                    return true;
                }

                switch (currentIndex) {
                    case 0:
                        if (allowMove) {
                            allowMove = false;
                            return true;
                        }

                        var plateNo = getPlateNoEu(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
                        if (plateNo.length === 9) {
                            validatePlate(plateNo);
                        }


                        break;
                    case 1:

                        return true;
                        break
                    case 2:

                        if (allowMove) {
                            allowMove = false;
                            return true;
                        }

                        if (validateDetails()) {
                            trafficLicenseCalcRequest();
                        }

                        break
                    case 3:

                        break
                    //case 4:
                    //    return true;
                    //    break
                }


            },
            onStepChanged: function (event, currentIndex, priorIndex) {

                if (priorIndex > currentIndex) {
                    $("#wizard-form").steps('resetStep', priorIndex);
                }

                if (currentIndex == 1) {
                    var p = $('#txtCarCategory').width()


                    $('#drpCargoTypes').combobox({
                        width: p
                    });
                    $('#drpLicenseKind').combobox({
                        width: p * 2
                    });
                }


            },
            onFinishing: function (event, currentIndex) {
                if (allowMove) {
                    return true;
                }

                trafficLicenseSaveRequest();
            },
            onFinished: function (event, currentIndex) {

            },

        });
        $("#wizard-form").steps('cssButton', 'cancel', 'float', 'left');

        // Adjust steps on window resize for mobile responsiveness
        $(window).on('resize', function () {
            $('#wizard-form').steps('update');
        });

        var globalVehicleGUID = null;


        $('#drpCargoTypes').combobox({
            method: 'get',
            url: '/TrafficLicenses/API/TrafficLicense/CargoTypes',
            valueField: 'VoucherGoodId',
            textField: 'Title',
            multiple: false,
            onLoadSuccess: function () {

            },
            onChange: function () {

            }

        });

        $('#drpLicenseKind').combobox({
            method: 'get',
            url: '/TrafficLicenses/API/TrafficLicense/TrafficLicenseKinds',
            valueField: 'ProductTypeId',
            textField: 'Title',
            multiple: false,

            onLoadSuccess: function () {

            },
            onChange: function () {
                // Get all data from the combobox
                var selectedValue = $('#drpLicenseKind').combobox('getValue');
                var data = $('#drpLicenseKind').combobox('getData');
                // Find the selected item by matching the ProductTypeId
                var selectedItem = data.find(item => item.ProductTypeId === parseInt(selectedValue));

                // If a match is found, set #txtDescription with Descriptions field
                if (selectedItem) {
                    $('#txtDescription').text(selectedItem.Description);
                }
            }

        });


        //$(function () {
        //    $.ajax({
        //        url: '/CoreServices/API/Shared/GetDate',
        //        type: 'GET',
        //        contentType: 'application/json',
        //        data: { diffDay: 0 },
        //        success: function (data) {

        //            $("#txtFromDate,#txtToDate").persianDatepicker({
        //                observer: false,
        //                minDate: data,
        //                format: 'YYYY/MM/DD',
        //                initialValue: false,
        //                calendar: {
        //                    persian: {
        //                        locale: 'fa'
        //                    }
        //                },
        //            });


        //            $('#txtFromDate').val(data);
        //            $('#txtToDate').val(data);

        //        },
        //        error: function (xhr, textStatus, errorThrown) {
        //        }
        //    });
        //});


        function validatePlate(plate) {

            allowMove = false;
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            var car = {};
            //$.when(
            $.ajax({
                url: '/CoreServices/API/Car/ValidateAccessPlateForAnyProduct',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    plateNo: plate,
                    companyId: 0,
                    driverId: 0
                },
                async: true,
                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful == false) {

                        $.messager.alert('توجه', data.Message, 'warning');
                        allowMove = false;
                    }
                    else {

                        car = data.ReturnValue;

                        $('#txtCarSystem').val(car.System);
                        $('#txtCarStyle').val(car.StyleTip);
                        $('#txtCarColor').val(car.Color);
                        $('#txtCarOwnerName').val(car.OwnerName);
                        $('#txtCarCategory').val(car.CarCategoryTitle);
                        $('#txtLicenseStatusTitle').val(car.LicenseStatusTitle);
                        $('#txtPlateNo').val(car.MISPlate);
                        $('#txtVIN').val(car.VIN);
                        //todo guid
                        globalVehicleGUID = car.VehicleGUID;
                        allowMove = true;
                        $("#wizard-form").steps("next");
                    }


                },

                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');

                }
            })
        }

        function validateDetails() {
            var cargoTypeid = $('#drpCargoTypes').combobox('getValue');
            var licenseKindId = $('#drpLicenseKind').combobox('getValue');
            var fromDate = $('#txtFromDate').dpGetEnValue();
            var toDate = $('#txtToDate').dpGetEnValue();


            if (cargoTypeid < 1) {
                $.messager.alert('خطا', "فعالیت اصلی را در دوره مجوز درخواستی مشخص نمایید.", 'warning');
                return false;
            }
            if (licenseKindId < 1) {
                $.messager.alert('خطا', "نوع مجوز را انتخاب نمایید", 'warning');
                return false;
            }

            if (fromDate > toDate) {
                $.messager.alert('خطا', "تاریخ شروع نمیتواند بزرگتر از تاریخ پایان باشد", 'warning');
                return false;
            }

            return true;

        }

        function trafficLicenseCalcRequest() {
            var cargoTypeId = $('#drpCargoTypes').combobox('getValue');
            var licenseKindId = $('#drpLicenseKind').combobox('getValue');
            var fromDate = $('#txtFromDate').dpGetEnValue();
            var toDate = $('#txtToDate').dpGetEnValue();
            var retValue = false;
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            var param = {
                VehicleGUID: globalVehicleGUID,
                CargoTypeId: cargoTypeId,
                LicenseKindId: licenseKindId,
                LicenseDateFrom: fromDate,
                LicenseDateTo: toDate
            }

            $.ajax({
                url: '/TrafficLicenses/API/TrafficLicense/TrafficLicenseCalcRequest',
                type: 'Post',
                async: true,
                contentType: 'application/json',
                data: JSON.stringify(param),
                success: function (data) {
                    $.messager.progress('close');
                    if (data.IsSuccessful) {
                        retValue = true;

                        calc = data.ReturnValue;

                        $('#txtMISPlate').val(calc.MisPlate);
                        $('#txtCarCategoryTitle').val(calc.CarCategoryTitle);
                        $('#txtCargoTitle').val(calc.CargoTypeTitle);
                        $('#txtLicenseTypeTitle').val(calc.TrafficLicenseTypeTitle);
                        $('#txtAFromDate').val(calc.LicenseDateFrom);
                        $('#txtAToDate').val(calc.LicenseDateTo);
                        $('#txtCalcDesc').val(calc.CalcDescription);
                        $('#txtPrice').val(calc.Price.toLocaleString("en-US"));
                        if (calc.IsTargetDateChanged) {
                            $('#txtAToDate').css('color', 'red');
                            $('#txtAToDate').val(calc.LicenseDateTo + ' - ' + calc.TargetDateChangedDesc);
                        }
                        else {
                            $('#txtAToDate').css('color', '');
                        }
                        allowMove = true;
                        $("#wizard-form").steps("next");
                    }
                    else {

                        $.messager.alert('پیام سیستم', data.Message, 'info');

                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('Ajax Error');

                }
            });

            return retValue;
        }



        function trafficLicenseSaveRequest() {
            $("#wizard-form").steps('enableButton', 'finish', false);
            $("#wizard-form").steps('enableButton', 'previous', false);

            var cargoTypeId = $('#drpCargoTypes').combobox('getValue');
            var licenseKindId = $('#drpLicenseKind').combobox('getValue');
            var fromDate = $('#txtFromDate').dpGetEnValue();
            var toDate = $('#txtToDate').dpGetEnValue();
            var retValue = false;
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            var param = {
                VehicleGUID: globalVehicleGUID,
                CargoTypeId: cargoTypeId,
                LicenseKindId: licenseKindId,
                LicenseDateFrom: fromDate,
                LicenseDateTo: toDate
            }

            $.ajax({
                url: '/TrafficLicenses/API/TrafficLicense/TrafficLicenseSaveRequest',
                type: 'Post',
                async: true,
                contentType: 'application/json',
                data: JSON.stringify(param),
                success: function (data) {
                    $.messager.progress('close');
                    if (data.IsSuccessful) {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                        $("#wizard-form").steps('enableButton', 'finish', false);
                        $("#wizard-form").steps('enableButton', 'previous', false);
                        //$("#wizard-form").steps("finish");
                        allowMove = true;
                        retValue = true;
                        $("#wizard-form").steps("finish");
                    }
                    else {
                        $.messager.alert('پیام سیستم', data.Message, 'warning');
                        $("#wizard-form").steps('enableButton', 'finish', true);
                        $("#wizard-form").steps('enableButton', 'previous', true);
                        retValue = false;
                    }
                    //retValue = data.IsSuccessful;
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $("#wizard-form").steps('enableButton', 'finish', true);
                    $("#wizard-form").steps('enableButton', 'previous', true);

                }
            });

            return retValue;

        };


    </script>
</asp:Content>
