﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="TrafficLicenseList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.TrafficLicense.TrafficLicenseList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
        
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست درخواست مجوزهای تردد'">
                    <table id="mainGrid">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'ProductTitle', sortable:'true', width:160">نوع مجوز</th>
                                <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'RequestDate', sortable:'true', width:160">تاریخ درخواست</th>
                                <th data-options="field:'LicenseValidDateFrom', sortable:'true', width:160">از تاریخ</th>
                                <th data-options="field:'LicenseValidDateTo', sortable:'true', width:160">تا تاریخ</th>
                                <th data-options="field:'LicensingStatuseTitle', sortable:'true', width:160">وضعیت درخواست</th>
                                <th data-options="field:'LicenseDate', sortable:'true', width:160">تاریخ صدور</th>
                                
                            </tr>
                        </thead>
                    </table>
                    <div id="gridToolbar" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
                 
                               <span>پلاک</span>
                            <input tabindex="4" onkeypress="return /[0-9]/i.test(event.key)"maxlength="2" id="txtIranPlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" required>
                            <span>ایران</span>
                            <input tabindex="3"onkeypress="return /[0-9]/i.test(event.key)" maxlength="3"id="txtThreePlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" >
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>

                            </select>
                            <input tabindex="1"onkeypress="return /[0-9]/i.test(event.key)" maxlength="2" type="text" id="txtOnePlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                            <a onclick="searchOnDb()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                            <a onclick="print()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print edit'">چاپ مجوز</a>
                            <label id="lblReject">با کلیک بر روی درخواست رد شده ، علت رد خواست خود را مشاهده نمایید</label>
                            <a id="btnRejectDetails" onclick="rejectDetails()" class="easyui-linkbutton" data-options="region:'center'">علت رد درخواست</a>
                            <a onclick="refuseRequest()" class="easyui-linkbutton" data-options="region:'center',iconCls:''"> انصراف از صدور</a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
       
        
               
    
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var mainGrid = $('#mainGrid');

      
        function rejectDetails() {
            var row = mainGrid.datagrid('getSelected');
            if (row == null) {
                $.messager.alert("info", 'لطفا ابتدا یک درخواست را انتخاب نمایید', "info");
                return;
            }

            if (row['LicenseStatusId'] != 3) {
                return;

            }
            $.messager.alert('علت رد درخواست', row['LastRejectDesc'], 'info');
        }


        $(function () {
            
            mainGrid.initializeGrid({
                //title: '',
                // filterBtnPosition: 'left',
                remoteFilter: false,
                method: 'get',
                // fit: true,
                singleSelect: true,
                // collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [15, 50, 100, 99999],
                url: '/TrafficLicenses/API/TrafficLicense/TrafficLicensesList',
                rownumbers: true,
                sortName: 'RequestDate',
                sortOrder: 'desc',
                toolbar: '#gridToolbar',
                height: $(window).height() - 160,
                queryParams: {
                    plateNo: '',
                    fromDate: '',
                    toDate: '',
                    carCategoryId: 0,
                    cargoTypeId:0
                }
            });
        });
        function print() {

            var row = mainGrid.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            if (row['LicenseStatusId'] != 2) {
                $.messager.alert('هشدار', 'درخواست شما تایید و یا مجوز شما صادر نشده است');
                return;
            }

            window.open("/Reports/Print/PrintTrafficLicense.html?guid=" + row['TrafficLicenseGUID']);
        }

        function refuseRequest() {

            var row = mainGrid.datagrid('getSelected');
            if (row == null) {
                $.messager.alert("info", 'لطفا ابتدا یک درخواست را انتخاب نمایید', "info");
                return;
            }

            var trafficLicenseGUID =row['TrafficLicenseGUID'];

                        
            $.messager.progress({ title: 'لطفا صبر کنید...' });

           

            $.ajax({
                url: '/TrafficLicenses/API/TrafficLicense/RefuseRequestTrafficLicense?guid='+trafficLicenseGUID,
                type: 'post',
                contentType: 'application/json',
                //data: JSON.stringify(data),
                success: function (data) {
                    $.messager.progress('close');
                    if (data.IsSuccessful == true) {

                        $.messager.alert('پیغام سیستم', data.Message, 'info');

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('خطا', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }


        function searchOnDb() {

            var opts = mainGrid.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoBoot(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue === 'error')
                return;

            opts.queryParams['plateNo'] = plaqueValue;
            mainGrid.datagrid('reload', opts.queryParams);

        }
        
        function clearFilter() {

            $('#txtOnePlateNoCarList').val('');
            $('#txtThreePlateNoCarList').val('');
            $('#txtIranPlateNoCarList').val('');
            $('#drpTwoPlateNoCarList').val('');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = mainGrid.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = '';
            
            mainGrid.datagrid('reload', opts.queryParams);

        }
        
        $(document).ready(function () {
            restrictAccess();
        });

    </script>
</asp:Content>
