﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="TicketRequest.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Tickets.TicketRequest" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" style="padding: 20px;">
        <div class="main">
            <div id="frmCarEdit">

                <div class="col-md-12">
                    <!-- LINE CHART -->
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fa fa-check-square-o"></i>ثبت مشکلات </h3>

                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>

                            </div>
                        </div>
                        <div class="card-body">



                            <form class="validation " novalidate>

                                <div style="margin: 10px 0;">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-6 control-label" for="exampleInputPassword1">قسمت دارای مشکل :</label>


                                                <select required id="drpTicketCategories" class="ps-prov selectpicker show-tick form-control" data-live-search="true" onchange="changCategory()"></select>

                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div style="margin: 20px 0;" class="form-row " id="txtplate">
                                    <label class=" control-label">پلاک :</label>

                                  
                                    <div class="container d-flex justify-content-center">
                                        <div class="col-md-4 plateContainer ">
                                            <div class="plateItems col-12">
                                                <input tabindex="4" id="txtPlateP4" class="easyui-numberbox plateP4" required>
                                                <input tabindex="3" id="txtPlateP3" class="easyui-numberbox plateP3" required>
                                                <select tabindex="2" id="drpPlateP2" class="easyui-combobox plateP2" required></select>
                                                <input tabindex="1" id="txtPlateP1" class="easyui-numberbox plateP1" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="invalid-feedback">پلاک وارد نمایید</div>




                                <div class="row" id="txtvin">
                                    <div class="col-md-8">
                                        <div class="form-group" style="display: flex;">
                                            <label class="col-md-6 control-label" for="exampleInputPassword1">VIN :</label>
                                            <input required id="txtVINCarEdits" required data-options="validType:'length[17,17]',prompt:'شامل 17 عدد یا حرف '" class="form-control easyui-textbox Vin" />

                                            <div class="invalid-feedback">وین وارد نمایید </div>


                                        </div>
                                    </div>


                                </div>
                                <div class="row" id="txtnationalCOde">
                                    <div class="col-md-8">
                                        <div class="form-group" style="display: flex;">
                                            <label class="col-md-6 control-label" for="exampleInputPassword1">کد ملی راننده/مدیرعامل</label>

                                            <input onkeypress="return /[0-9]/i.test(event.key)" minlenght="10" maxlength="10" required="true" tabindex="6" tipposition="left" id="userNastionalCode" class="form-control">
                                            <div class="invalid-feedback">کد ملی وارد نمایید </div>


                                        </div>
                                    </div>


                                </div>


                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group" style="display: flex;">
                                            <label class="col-md-6 control-label" for="exampleInputPassword1">توضیحات :</label>

                                            <textarea class="form-control" rows="5" id="comments" tabindex="8" name="text" required></textarea>
                                        </div>
                                    </div>


                                </div>

                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group" style="display: flex;">
                                            <label class="col-md-6 control-label">بارگزاری فایل : </label>
                                            <input type="text" buttontext="انتخاب" id="TechnicalDiagnosisfuAttach" class="arz" tabindex="9" data-options="label:'',prompt:'انتخاب فایل ...'">
                                            <img id="fuAttachTechnicalDiagnosisPreviewBtn" src="#" alt="" style="margin: 0px 10px -10px 0px; width: 26px;" />
                                            <div id="dlgTechnicalDiagnosisImg" class="easyui-dialog" title="نمایش تصویر" style="padding: 10px; width: 450px; min-height: 10px;" data-options="closed: true,iconCls:'icon-save',onResize:function(){$(this).dialog('center');}">
                                                <img id="fuAttachTechnicalDiagnosisPreview" src="#" style="max-width: 420px; min-height: 10px;" />
                                            </div>
                                        </div>
                                    </div>


                                </div>


                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group" style="display: flex;">
                                            <label class="col-md-6 control-label" for="exampleInputPassword1">شماره تماس فوری :</label>
                                            <inputn required id="phones" required data-options="validType: 'length[11,11]',  prefix:0,prompt:'شامل 11 عدد '" class="form-control easyui-numberbox MobileNumber"/>


                                                <div class="invalid-feedback">شماره تماس وارد نمایید </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-4 control-label"></label>
                                    <div class="col-md-4" style="display: flex;">

                                        <button type="submit" id="btnSave" onclick="save()"
                                            class=" btn btn-3d btn-success mr-xs mb-sm col-md-12" style="width: 110px; color: #000; margin-top: 16px;">
                                            ثبت
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>
        </div>

    </div>



    <!-- Main Footer -->
    <footer class="main-footer">
        <!-- To the right -->
        <div class="float-right d-none d-sm-block-down">
        </div>
        <!-- Default to the left -->
        <strong>تماس و پشتیبانی :
            <label id="SupportContact">137</label>
        </strong>
    </footer>
 
    
    <script>

        $(function () {

            $('#TechnicalDiagnosisfuAttach').filebox({
                accept: 'image',
                //required: true,
                onChange: function myfunction() {

                    var input = $('#TechnicalDiagnosisfuAttach').next().find('.textbox-value')[0];
                    var size = input.files[0].size;
                    var sizeKb = size / 1024;
                    if (size > 809600) {

                        $.messager.alert('اخطار', 'حداکثر حجم عکس ارسالی 800 کیلوبایت میباشد', 'warning');
                        return;
                    }
                    //var size= alert($('#fuAttachLicense').input.files[0].size);
                    if (input.files && input.files[0]) {
                        $('#fuAttachTechnicalDiagnosisPreviewBtn').attr('src', "/Resources/Dist/Images/large_picture.png");
                        $('#fuAttachTechnicalDiagnosisPreviewBtn').click(function () {
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $('#fuAttachTechnicalDiagnosisPreview')
                                    .attr('src', e.target.result);

                            };
                            reader.readAsDataURL(input.files[0]);
                            $('#dlgTechnicalDiagnosisImg').dialog('open');
                        });
                    }
                }
            });

        });



        $.ajax({
            url: '/CoreServices/API/Tickets/GetTicketSubSystems',
            type: 'get',

            contentType: 'application/json',

            success: function (data) {
                if (data) {
      
                    $.each(data, function (index, category) {
                        $('#drpTicketCategories').append($('<option>').text(category.Title).attr('value', category.SubSystemId));
                    });

                }

            },

            error: function (xhr, textStatus, errorThrown) {
                //$.messager.alert('Error', 'خطا در ذخیره عکس', 'error');
                return false;
            }

        });





        function changCategory() {

            var paramId = $('#drpTicketCategories').val();
            switch (paramId) {

                case "1":
                    $('#txtplate').hide().prop("disabled", true);
                    $('#txtvin').hide().prop("disabled", true);
                    $('#txtnationalCOde').prop("disabled", true);
                    break;
                case "3":
                    $('#txtnationalCOde').show();
                    $('#txtvin').hide().prop("disabled", true);
                    $('#txtplate').hide().prop("disabled", true);
                    break;
                case "2":

                    $('#txtplate').show();
                    $('#txtnationalCOde').hide().prop("disabled", true);
                    $('#txtvin').show();
                    break;
                case "5":

                    $('#txtplate').show();
                    $('#txtnationalCOde').show();
                    $('#txtvin').show();

                    break;
                case "6":

                    $('#txtplate').show();
                    $('#txtnationalCOde').show();
                    $('#txtvin').show();

                    break;
            }

        };

        setTimeout(function loadData() {

            $('#txtplate').hide().prop("disabled", true);
            $('#txtvin').hide().prop("disabled", true);
            $('#txtnationalCOde').hide().prop("disabled", true);

        }, 50);
        function getPlateNoDataCarList(txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

            var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
            var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).val());
            var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
            var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());

            if (onePlateNo == 0 && twoPlateNo == -1 && threePlateNo == 0 && iranPlateNo == 0) {
                return '';
            }

            var isValidValue = true;

            if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
                isValidValue = false;

            if (twoPlateNo == -1)
                isValidValue = false;

            if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
                isValidValue = false;

            if (iranPlateNo < 10 || iranPlateNo > 99)
                isValidValue = false;

            if (isValidValue == false) {
                $.messager.alert('خطا', 'شماره پلاک خطا دارد');
                return 'error';
            }

            if (twoPlateNo.toString().length == 1)
                twoPlateNo = '0' + twoPlateNo.toString();
            
            var plaqueValue = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

            return plaqueValue;

        }

        function save() {



            //if (!$('#frmCarEdit"').form('validate')) {
            //    $.messager.alert('اخطار', 'لطفا موارد اجباری را وارد نمایید', 'اخطار');
            //    return;
            //}

            var comment = $('#comments').val();//متن درخواست
            if (comment == '' || comment == null) {
                $.messager.alert('اخطار', 'لطفا توضیحات را وارد نمائید', 'اخطار');
                return;

            }
            var Vin = $('#txtVINCarEdits').val();//وین خودرو
            /*  var section = $('#drpCarHasAICards').combobox('getValue'); //مشکل دار*/
            var userNastionalCode = $('#userNastionalCode').val();
            var Phones = $('#phones').val();//ـلفن
            var cstegoryID = $('#drpTicketCategories').val();
            //var onePlateNo = Math.floor($('#txtOnePlateNoCarEdit').val());

            //var twoPlateNo = $('#drpTwoPlateNoEdit :selected').val();
            //var threePlateNo = Math.floor($('#txtThreePlateNoCarEdit').val());
            //var iranPlateNo = Math.floor($('#txtIranPlateNoCarEdit').val());
            //var plaqueValue = '';
            //if (cstegoryID !== 1 && cstegoryID !== 2) {

            //    plaqueValue = getPlateNoDataCarList('txtOnePlateNoCarEdit', 'drpTwoPlateNoEdit', 'txtThreePlateNoCarEdit', 'txtIranPlateNoCarEdit');
            //    if (plaqueValue == 'error')
            //        return;
            //}
            var plateNo = getPlateNo(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plateNo.length != 9) {
                return;
            }
            // Decleare Varibles
            data = {
                VIN: Vin,
                PlateNo: plateNo,
                Phone: Phones,
                Description: comment,
                NationalCode: userNastionalCode,
                SubSystemId: cstegoryID,


            }



            var content = JSON.stringify(data);

            $.ajax({
                url: '/CoreServices/API/Tickets/SaveTicket',
                type: 'POST',
                contentType: 'application/json',
                data: content,

                success: function (data) {

                    if (data.IsSuccessful == true) {
                        //$.messager.progress('close');

                        //var lic = data.ReturnValue;
                        var ticketId = data.ReturnValue;

                        savePicture(ticketId);

                        $('btnSave').prop('disabled', true);
                        $.messager.alert('پیغام سیستمی', data.Message, 'info');

                        //$('#txtVINCarEdit').textbox('setValue', lic.LicensingDate);
                        //$('#txtCarSystem').textbox('setValue', lic.InsuranceNumber);

                    }
                    else {
                        /*  $('#btnSave').linkbutton('enable');*/
                        $('btnSave').prop('disabled', false);
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        }




        function savePicture(ticketId) {

            var file = $('#TechnicalDiagnosisfuAttach').next().find('.textbox-value')[0].files[0];
            if (file == null)
                return true;

            var fileBoxs = new FormData();
            fileBoxs.append('file-License', file);

            $.ajax({
                url: '/CoreServices/API/FileAttachments/PostFile?foreignKeyId=' + ticketId + '&typeId=5',
                type: 'Post',
                cache: false,
                data: fileBoxs,
                contentType: false,
                processData: false,
                success: function (data) {

                    return true;
                },
                error: function (xhr, textStatus, errorThrown) {
                    //$.messager.alert('Error', 'خطا در ذخیره عکس', 'error');
                    return false;
                }
            });
        }


        $(document).ready(function () {
            restrictAccess();
        });
    </script>
</asp:Content>
