﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="TerminalsManager.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Terminals.TerminalsManager" %>


<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        #NationalCodeUserName + span {
            width: 100% !important;
        }
    </style>
    <div class="content-wrapper">
        <section class="content">

            <div class="easyui-layout" style="height: auto; width: 100%;">
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 id="gridTitle" class="card-title"><i class="fa fa-car"></i>&nbsp;&nbsp; پایانه های ثبت شده </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div style="width: 100%; height: 600px" data-options="region:'center'">
                            <table id="grdMain" style="width: 100%; height: auto">
                                <thead>
                                    <tr>
                                        <th field="ck" checkbox="true"></th>
                                        <th data-options="field:'ProvinceName', sortable:'true', width:160">استان</th>
                                        <th data-options="field:'CityName', sortable:'true', width:160">شهر</th>
                                        <th data-options="field:'TerminalName', sortable:'true', width:160">نام ترمینال</th>
                                    </tr>
                                </thead>
                            </table>
                            <div id="gridtoolbar" style="padding: 2px 5px;">
                                <div style="padding: 2px 5px;">
                                    <%--<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                                        Open Modal with Iframe
                                    </button>--%>
                                    <a onclick="actionDlg('add');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-add'">جدید </a>
                                    <a onclick="actionDlg('edit');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-edit'">ویرایش </a>
                                    <a onclick="actionDlg('delete');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-cancel'">حذف </a>
                                    <a onclick="CreateFormPage(document.getElementById('gridTitle').textContent, $('#grdMain'));" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ </a>
                                    <a onclick="$('#grdMain').datagrid('toExcel', 'report.xls');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel'">اکسل</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </section>
        <!-- /.content -->


        <div class="modal fade" id="dlg" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-xl" style="max-width: 60%;">
                <div class="modal-content" style="background-color: #e6e6e6;">
                    <div class="modal-header" style="background-color: #17a2b8; padding: 10px; color: white; font-weight: normal;">
                        <h5 class="modal-title">پایانه</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body ">
                        <!-- Form inside the modal body -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3" >استان:</label>
                                    <input required id="drpProvince" class="form-control easyui-combobox" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3" >شهر:</label>
                                    <input required id="drpCity" class="form-control easyui-combobox" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3" >نام پایانه:</label>
                                    <input id="txtTerminalName" class="form-control col-md-12" />
                                </div>
                            </div>
                            <div class="col-md-6">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" onclick="registerOrUpdateItem();" class="btn btn-success col-md-3">ذخیره</button>
                        <span class="col-md-1"></span>
                        <button type="button" class="btn btn-info col-md-3" data-dismiss="modal">برگشت</button>
                    </div>
                </div>
            </div>
        </div>



    </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdMain = $("#grdMain");
        var selectedItem = {};
        var actionParam = null;

        $(document).ready(() => {

            grdMain.initializeGrid({
                //title: 'پایانه های ثبت شده',
                // filterBtnPosition: 'left',
                remoteFilter: false,
                method: 'get',
                // fit: true,
                singleSelect: true,
                // collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 15,
                pageList: [5, 15, 50, 100, 99999],
                url: '/Terminals/API/PayaBarg/Terminals',
                rownumbers: true,
                sortName: 'ProvinceIranCode',
                sortOrder: 'asc',
                toolbar: '#gridtoolbar',
                //height: 400,
                //onSelect: function (rowIndex, rowData) {
                //    selectedItem = rowData;

                //},
                //queryParams:
                //{
                //    plateNo: ""
                //}
            });


            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdMain.datagrid('enableFilter', [
                {
                    field: 'ProvinceName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'CityName',
                    type: 'text',
                    op: textOp,
                },
                {
                    field: 'TerminalName',
                    type: 'text',
                    op: textOp,
                }
            ]);

            initProvinceCityCombobx();

        });

        function initProvinceCityCombobx() {

            $("#drpProvince").combobox({
                method: 'get',
                url: '/Terminals/API/PayaBarg/Provinces',
                valueField: 'ProvinceIranCode',
                textField: 'ProvinceName',
                multiple: false,
                onChange: function () {

                    $("#drpCity").combobox({
                        method: 'get',
                        url: '/Terminals/API/PayaBarg/Cities?provinceIranCode=' + $("#drpProvince").combobox('getValue'),
                        valueField: 'CityIranCode',
                        textField: 'CityName',
                        multiple: false,
                    });
                    $('.combo').css('width', '100%');
                }
            });
            $('.combo').css('width', '100%');

        }

        function actionDlg(action) {
            actionParam = action;
            if ((action === "edit" || action === "delete") && (grdMain.datagrid('getSelected') === null)) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            if (action === "delete") {
                deleteSelectedItem();
                return;
            }
            if (action === "add") {
                selectedItem = {};
            } else {
                selectedItem = grdMain.datagrid('getSelected');
            }


            // فیلدهای اطلاعاتی
            {
                $('#drpProvince').combobox('setValue', selectedItem['ProvinceIranCode'] ?? null);
                $('#drpCity').combobox('setValue', selectedItem['CityIranCode'] ?? null);
                $('#txtTerminalName').val(selectedItem['TerminalName'] ?? '');
            }
                       

            $('#dlg').modal('show');
        }

        function deleteSelectedItem() {

            $.messager.confirm('Confirm', 'آیا از حذف آیتم انتخاب شده اطمینان دارید؟', function (r) {
                if (r) {
                    $.messager.alert('Ajax Error', 'Done', 'error');
                }
            });




            //$.ajax({
            //    url: '/CoreServices/API/Driver/DriverVehiclesAssingment',
            //    type: 'Post',
            //    data: JSON.stringify(model),
            //    contentType: 'application/json',
            //    //processData: false,
            //    success: function (data) {
            //        //
            //        if (data) {
            //            $.messager.progress('close');
            //            $.messager.alert('پیام سیستم', data.Message, 'info');
            //        }
            //    },
            //    error: function (xhr, response, textResponse) {
            //        $.messager.progress('close');
            //        $.messager.alert('پیغام سیستمی', "خ��ا در اراتباط", 'info');
            //    }
            //});
        }


        function registerOrUpdateItem() {

            $.messager.alert('Ajax Error', actionParam, 'error');
            return;


            if (existDriverInformation == null) {
                $.messager.alert('خطا', 'ابتدا راننده مورد نظر را انتخاب کنید');

                return;
            }

            var allRows = grdMain.datagrid("getRows");
            var selectedRows = grdMain.datagrid("getSelections");

            //if (!selectedRows) {
            //    $.messager.alert('خطا', 'ابتدا خودروهای  مورد نظر را انتخاب کنید');
            //    return;
            //}

            var selectedVehicleGuids = [];
            var vehicleGuids = [];

            if (selectedRows) {
                selectedRows.map((item, index) => {
                    selectedVehicleGuids[index] = item.VehicleGUID;
                });
            }
            if (allRows) {
                allRows.map((item, index) => {
                    vehicleGuids[index] = item.VehicleGUID;
                });
            }

            var model = {
                VehicleGuids: vehicleGuids,
                SelectedVehicleGuids: selectedVehicleGuids,
                DriverUserName: existDriverInformation.UserName
            };


            $.ajax({
                url: '/CoreServices/API/Driver/DriverVehiclesAssingment',
                type: 'Post',
                data: JSON.stringify(model),
                contentType: 'application/json',
                //processData: false,
                success: function (data) {
                    //
                    if (data) {
                        $.messager.progress('close');
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                    }
                },
                error: function (xhr, response, textResponse) {
                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');
                }
            });
        }



    </script>
</asp:Content>
