﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        .login-container {
            width: 95%;
            max-width: 600px;
            margin: 0 auto;
            padding: 2rem 0;
        }

        @media (max-width: 768px) {
            .login-container {
                width: 90%;
                min-width: 280px;
            }
        }

        .card {
            border: none;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
            border-radius: 15px;
            overflow: hidden;
            transition: transform 0.2s;
        }

        .card-header {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
            padding: 1.5rem;
        }

        .card-header h3 {
            color: white;
            font-size: 1.5rem;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        }

        .card-body {
            padding: 2rem;
        }

        .input-field {
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            display: flex;
            align-items: center;
            padding: 0.375rem 0.75rem;
            position: relative;
            margin-bottom: 1rem;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            background: #f8f9fa;
            transition: all 0.3s ease;
        }

        .input-field:focus-within {
            border-color: #80bdff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        .input-field:hover {
            background: #fff;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .input-field input {
            border: none;
            outline: none;
            width: 100%;
            box-shadow: none;
            text-align: center;
            direction: ltr;
            padding: 0;
            background: transparent;
            background-color: transparent !important;
            font-family: 'Vazirmatn' !important;
            font-size: 1.1rem !important;
        }

        .input-field .icon {
            color: #0093E9;
            font-size: 1.1rem;
            padding: 2px;
        }

        .form-text {
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .text-danger {
            color: #dc3545;
        }

        .hint-text {
            text-align: left;
        }

        .input-label {
            display: block;
            text-align: right;
            font-weight: 500;
            color: #2c3e50;
            font-family: 'Vazirmatn';
            font-size: 0.95rem;
            margin-bottom: 0.5rem;
        }

        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 0.6rem 1.2rem;
            transition: all 0.3s ease;
        }

        .btn-info {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        input:valid {
            border-color: #28a745;
        }

        input:invalid {
            border-color: #dc3545;
        }

        #timer {
            text-align: center;
            margin-top: 10px;
            font-size: 0.9rem;
        }

        .action-buttons {
            display: flex;
            justify-content: space-between;
            gap: 1rem;
            margin-top: 2rem;
        }
    </style>

    <div class="login-container">
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">تایید کد فعال‌سازی</h3>
            </div>
            <div class="card-body">
                <form id="frmVerification" class="needs-validation" novalidate>
                    <div class="form-group">
                        <label class="input-label" for="txtUserName">نام کاربری :</label>
                        <div class="input-field">
                            <span class="far fa-user icon" aria-hidden="true"></span>
                            <input type="text" class="form-control" id="txtUserName" name="userName"
                                required autocomplete="username" dir="ltr" 
                                placeholder="نام کاربری را وارد کنید"
                                oninvalid="validateUsername(this);" 
                                oninput="validateUsername(this);" 
                                onblur="validateUsername(this);"
                                aria-describedby="userNameHint">
                        </div>
                        <small id="userNameHint" class="form-text text-muted hint-text">
                            کد ملی یا شناسه ملی شما نام کاربری است
                        </small>
                    </div>

                    <div class="form-group">
                        <label class="input-label" for="txtMobileNumber">شماره تلفن همراه :</label>
                        <div class="input-field">
                            <span class="fas fa-mobile-alt icon" aria-hidden="true"></span>
                            <input type="tel" class="form-control" id="txtMobileNumber" name="mobileNumber"
                                required autocomplete="tel" inputmode="numeric" dir="ltr" minlength="11"
                                maxlength="11" placeholder="شماره تلفن همراه را وارد کنید" pattern="^09\d{9}$"
                                oninvalid="validateMobileNumber(this);" 
                                oninput="validateMobileNumber(this);" 
                                onblur="validateMobileNumber(this);"
                                aria-describedby="mobileNumberHint">
                        </div>
                        <small id="mobileNumberHint" class="form-text text-muted hint-text">
                            مثال: ۰۹۱۲۳۴۵۶۷۸۹
                        </small>
                    </div>
                    
                    <div class="form-group">
                        <label class="input-label" for="txtActivationCode">کد تایید :</label>
                        <div class="input-field">
                            <span class="fas fa-key icon" aria-hidden="true"></span>
                            <input type="text" class="form-control" id="txtActivationCode" name="activationCode"
                                required autocomplete="off" inputmode="numeric" dir="ltr"
                                maxlength="5" placeholder="کد تایید دریافت شده را وارد کنید" pattern="^\d{5}$"
                                oninvalid="validateActivationCode(this);" 
                                oninput="validateActivationCode(this);" 
                                onblur="validateActivationCode(this);"
                                aria-describedby="activationCodeHint">
                        </div>
                        <small id="activationCodeHint" class="form-text text-muted hint-text">
                            کد ۵ رقمی ارسال شده به تلفن همراه را وارد کنید
                        </small>
                    </div>
                    
                    <div id="timer"></div>
                    
                    <div class="action-buttons">
                        <button type="button" id="btnResend" onclick="sendAgain()" 
                            class="btn btn-info col-md-5">
                            ارسال مجدد کد
                        </button>
                        <button type="button" id="btnConfirm" onclick="confirmSMSCode()" 
                            class="btn btn-success col-md-5">
                            تایید کد
                        </button>
                    </div>
                    
                    <div id="loginButtonContainer" style="text-align:center; margin-top:20px; display:none;">
                        <button type="button" class="btn btn-success col-md-12" 
                            onclick="window.location.href='/Login.aspx';">
                            ورود به سیستم
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script src="/Resources/dist/js/CustomValidations.js"></script>
    <script>
        function validateUsername(input) {
            const value = input.value.trim();
            const error = document.getElementById('userNameHint');
            
            if (!value) {
                error.className = 'form-text text-danger';
                error.textContent = 'لطفا نام کاربری را وارد کنید';
                input.setCustomValidity('لطفا نام کاربری را وارد کنید');
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'کد ملی یا شناسه ملی شما نام کاربری است';
                input.setCustomValidity('');
                return true;
            }
        }
        
        function validateActivationCode(input) {
            const value = input.value.trim();
            const error = document.getElementById('activationCodeHint');
            
            // Remove any non-digit characters
            input.value = value.replace(/\D/g, '');
            
            if (!value) {
                error.className = 'form-text text-danger';
                error.textContent = 'لطفا کد تایید را وارد کنید';
                input.setCustomValidity('لطفا کد تایید را وارد کنید');
                return false;
            } else if (!/^\d+$/.test(value)) {
                error.className = 'form-text text-danger';
                error.textContent = 'کد تایید باید فقط شامل اعداد باشد';
                input.setCustomValidity('کد تایید باید فقط شامل اعداد باشد');
                return false;
            } else if (value.length !== 5) {
                error.className = 'form-text text-danger';
                error.textContent = 'کد تایید باید ۵ رقم باشد';
                input.setCustomValidity('کد تایید باید ۵ رقم باشد');
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'کد ۵ رقمی ارسال شده به تلفن همراه را وارد کنید';
                input.setCustomValidity('');
                return true;
            }
        }
        
        function confirmSMSCode() {
            var form = document.getElementById("frmVerification");
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }

            // Disable button to prevent multiple submissions
            $("#btnConfirm").prop("disabled", true);
            
            var param = {
                UserName: $.trim($("#txtUserName").val()),
                ActivationCode: $.trim($("#txtActivationCode").val()),
                MobileNumber: $.trim($("#txtMobileNumber").val())
            };

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Users/ClientConfirmActivationCode',
                method: 'POST',
                contentType: 'application/json',
                dataType: 'json',
                data: JSON.stringify(param),
                success: function (data) {
                    $.messager.progress('close');
                    $("#btnConfirm").prop("disabled", false);

                    if (data && data.IsSuccessful) {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                        // Hide form elements and show login button
                        $("#btnConfirm").hide();
                        $("#btnResend").hide();
                        $("#loginButtonContainer").show();
                    } else {
                        $.messager.alert('خطای سیستم', data?.Message || 'مشکلی در تایید کد پیش آمده است', 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $("#btnConfirm").prop("disabled", false);
                    console.error("Error Details:", xhr.responseText);
                    $.messager.alert('خطای سیستم', 'خطای سمت سرور پیش آمده', 'error');
                }
            });
        }

        function sendAgain() {
            // Disable button and start timer
            $("#btnResend").prop("disabled", true);
            
            var countdown = 120; // Set countdown to 120 seconds (2 minutes)
            $("#timer").text("لطفا " + countdown + " ثانیه صبر کنید");
            var timerInterval = setInterval(function() {
                countdown--;
                $("#timer").text("لطفا " + countdown + " ثانیه صبر کنید");
                if (countdown <= 0) {
                    clearInterval(timerInterval);
                    $("#timer").text("");
                    $("#btnResend").prop("disabled", false); // Enable the button after timer finishes
                }
            }, 1000);
            
            var param = {
                UserName: $.trim($("#txtUserName").val()),
                MobileNumber: $.trim($("#txtMobileNumber").val())
            };

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Users/ClientRequestActivationCode',
                method: 'POST',
                contentType: 'application/json',
                dataType: 'json',
                data: JSON.stringify(param),
                success: function (data) {
                    $.messager.progress('close');
                    
                    if (data && data.IsSuccessful) {
                        $.messager.alert('پیام سیستم', data.Message || 'کد تایید با موفقیت ارسال شد', 'info');
                    } else {
                        clearInterval(timerInterval);
                        $("#timer").text("");
                        $("#btnResend").prop("disabled", false);
                        $.messager.alert('خطای سیستم', data?.Message || 'مشکلی در ارسال کد پیش آمده است', 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    clearInterval(timerInterval);
                    $("#timer").text("");
                    $("#btnResend").prop("disabled", false);
                    console.error("Error Details:", xhr.responseText);
                    $.messager.alert('خطای سیستم', 'خطای سمت سرور پیش آمده', 'error');
                }
            });
        }

        // Add paste event handler for activation code
        document.getElementById('txtActivationCode').addEventListener('paste', (e) => {
            e.preventDefault();
            const text = (e.originalEvent || e).clipboardData.getData('text/plain');
            const cleanNumber = text.replace(/\D/g, '');
            e.target.value = cleanNumber.slice(0, 5);
            validateActivationCode(e.target);
        });
    </script>
</asp:Content>
