﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true" CodeBehind="RegisterIndividual.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Registration.RegisterIndividual" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        /* Shared styles with ResetPassword.aspx */
        .login-container {
            width: 95%;
            max-width: 600px;
            margin: 0 auto;
            padding: 2rem 0;
        }

        @media (max-width: 768px) {
            .login-container {
                width: 90%;
                min-width: 280px;
            }
        }

        .card {
            border: none;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
            border-radius: 15px;
            overflow: hidden;
            transition: transform 0.2s;
        }

        .card-header {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
            padding: 1.5rem;
        }

        .card-header h3 {
            color: white;
            font-size: 1.5rem;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        }

        .card-body {
            padding: 2rem;
        }

        .input-field {
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            display: flex;
            align-items: center;
            padding: 0.375rem 0.75rem;
            position: relative;
            margin-bottom: 1rem;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            background: #f8f9fa;
            transition: all 0.3s ease;
        }

        .input-field:focus-within {
            border-color: #80bdff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        .input-field:hover {
            background: #fff;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .input-field input {
            border: none;
            outline: none;
            width: 100%;
            box-shadow: none;
            text-align: center;
            direction: ltr;
            padding: 0;
            background: transparent;
            background-color: transparent !important;
            font-family: 'Vazirmatn' !important;
            font-size: 1.1rem !important;
        }

        .input-field .icon {
            color: #0093E9;
            font-size: 1.1rem;
            padding: 2px;
        }

        .form-text {
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .text-danger {
            color: #dc3545;
        }

        .hint-text {
            text-align: left;
        }

        .input-label {
            display: block;
            text-align: right;
            font-weight: 500;
            color: #2c3e50;
            font-family: 'Vazirmatn';
            font-size: 0.95rem;
            margin-bottom: 0.5rem;
        }

        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 0.6rem 1.2rem;
            transition: all 0.3s ease;
        }

        .btn-info {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .captcha-section {
            text-align: center;
            padding: 1.5rem;
            background: #f8f9fa;
            border-radius: 10px;
            margin-bottom: 1.5rem;
        }

        .captcha-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
            padding: 0.5rem;
        }

        .captcha-wrapper img {
            height: auto;
            object-fit: contain;
        }

        .refresh-btn {
            background: none;
            border: none;
            color: #0093E9;
            cursor: pointer;
            font-size: 1.125rem;
            transition: transform 0.3s ease;
        }

        .refresh-btn:hover {
            transform: rotate(180deg);
        }

        .captcha-input {
            width: 80%;
            margin: 0 auto;
        }

        input:valid {
            border-color: #28a745;
        }

        input:invalid {
            border-color: #dc3545;
        }

        /* Personal styling for registration */
        .form-row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }

        .col-md-6 {
            position: relative;
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
        }

        @media (min-width: 768px) {
            .col-md-6 {
                flex: 0 0 50%;
                max-width: 50%;
            }
        }

        .password-feedback {
            margin-top: 0.25rem;
            font-size: 0.875em;
        }

        .password-requirements {
            list-style-type: none;
            padding-left: 0;
            margin-top: 0.5rem;
            font-size: 0.875em;
        }

        .password-requirements li {
            margin-bottom: 0.25rem;
            color: #6c757d;
        }

        .password-requirements li.valid {
            color: #28a745;
        }

        .password-requirements li.invalid {
            color: #dc3545;
        }

        .toggle-password {
            cursor: pointer;
            position: absolute;
            left: 10px;
            color: dimgray;
        }
    </style>

    <div class="login-container">
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">ثبت نام شخص حقیقی</h3>
            </div>
            <div class="card-body">
                <form id="frmRegister" class="needs-validation" novalidate>
                    <!-- Removed first name, last name, and email fields -->
                    
                    <div class="form-group">
                        <label class="input-label" for="txtBirthDate">تاریخ تولد :</label>
                        <div class="input-field date-field">
                            <span class="far fa-calendar icon" aria-hidden="true"></span>
                            <input type="text" class="form-control dpTextBox dpTextBox-Invalid" id="txtBirthDate" name="birthDate" 
                                required  placeholder="تاریخ تولد را انتخاب کنید" 
                                data-mddatetimepicker="true" data-placement="bottom"
                                data-englishnumber="true" data-format="yyyy/MM/dd"
                               >
                                <input hidden id="txtBirthDateVal" />
                        </div>
                        <small id="birthDateHint" class="form-text text-muted hint-text">
                            تاریخ تولد را از تقویم انتخاب کنید
                        </small>
                    </div>

                    <div class="form-group">
                        <label class="input-label" for="txtNationalCodeId">کد ملی :</label>
                        <div class="input-field">
                            <span class="far fa-id-card icon" aria-hidden="true"></span>
                            <input type="text" class="form-control" id="txtNationalCodeId" name="nationalCodeId"
                                required autocomplete="off" inputmode="numeric" dir="ltr" minlength="10"
                                maxlength="10" placeholder="کد ملی را وارد کنید" pattern="^\d{10}$"
                                oninvalid="validateNationalCodeId(this);" 
                                oninput="validateNationalCodeId(this);" 
                                onblur="validateNationalCodeId(this);"
                                aria-describedby="nationalCodeIdHint">
                        </div>
                        <small id="nationalCodeIdHint" class="form-text text-muted hint-text">
                            کد ملی باید ۱۰ رقم باشد مثال: ۰۰۱۲۳۴۵۶۷۸
                        </small>
                    </div>

                    <div class="form-group">
                        <label class="input-label" for="txtMobileNumber">شماره تلفن همراه :</label>
                        <div class="input-field">
                            <span class="fas fa-mobile-alt icon" aria-hidden="true"></span>
                            <input type="tel" class="form-control" id="txtMobileNumber" name="mobileNumber"
                                required autocomplete="tel" inputmode="numeric" dir="ltr" minlength="11"
                                maxlength="11" placeholder="شماره تلفن همراه را وارد کنید" pattern="^09\d{9}$"
                                oninvalid="validateMobileNumber(this);" 
                                oninput="validateMobileNumber(this);" 
                                onblur="validateMobileNumber(this);"
                                aria-describedby="mobileNumberHint">
                        </div>
                        <small id="mobileNumberHint" class="form-text text-muted hint-text">
                            مثال: ۰۹۱۲۳۴۵۶۷۸۹
                        </small>
                    </div>

                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="input-label" for="txtPassword">گذرواژه :</label>
                                <div class="input-field">
                                    <span class="fas fa-lock icon" aria-hidden="true"></span>
                                    <input type="password" class="form-control" id="txtPassword" name="password"
                                        required autocomplete="new-password" dir="ltr" minlength="8"
                                        placeholder="رمز عبور را وارد کنید"
                                        oninvalid="validatePassword(this);" 
                                        oninput="validatePassword(this);" 
                                        onblur="validatePassword(this);"
                                        aria-describedby="passwordHint">
                                    <span toggle="#txtPassword" class="far fa-eye toggle-password"></span>
                                </div>
                                <small id="passwordHint" class="form-text text-muted hint-text">
                                    حداقل ۸ کاراکتر شامل حروف بزرگ، کوچک و اعداد
                                </small>
                                <ul id="passwordRequirements" class="password-requirements">
                                    <li id="length" class="invalid">حداقل ۸ کاراکتر</li>
                                    <li id="lowercase" class="invalid">حروف کوچک انگلیسی (a-z)</li>
                                    <li id="uppercase" class="invalid">حروف بزرگ انگلیسی (A-Z)</li>
                                    <li id="number" class="invalid">اعداد (0-9)</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="input-label" for="txtConfirmPassword">تکرار گذرواژه :</label>
                                <div class="input-field">
                                    <span class="fas fa-lock icon" aria-hidden="true"></span>
                                    <input type="password" class="form-control" id="txtConfirmPassword" name="confirmPassword"
                                        required autocomplete="new-password" dir="ltr" 
                                        placeholder="تکرار رمز عبور را وارد کنید"
                                        oninvalid="validateConfirmPassword(this);" 
                                        oninput="validateConfirmPassword(this);" 
                                        onblur="validateConfirmPassword(this);"
                                        aria-describedby="confirmPasswordHint">
                                    <span toggle="#txtConfirmPassword" class="far fa-eye toggle-password"></span>
                                </div>
                                <small id="confirmPasswordHint" class="form-text text-muted hint-text">
                                    رمز عبور را مجددا وارد کنید
                                </small>
                            </div>
                        </div>
                    </div>

                    <div class="form-group captcha-section">
                        <div class="captcha-wrapper">
                            <img id="captchaImage" src="/App_handlers/captcha.ashx" alt="کد امنیتی">
                            <button type="button" class="refresh-btn" onclick="refreshCaptcha()" aria-label="تازه سازی کد امنیتی">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                        </div>
                        <div class="captcha-input">
                            <input type="text" id="txtCaptcha" name="captcha" class="form-control"
                                placeholder="کد امنیتی را وارد کنید" required inputmode="numeric" autocomplete="off"
                                dir="ltr" minlength="5" maxlength="5" pattern="^\d{5}$"
                                aria-describedby="captchaHint" 
                                oninvalid="validateCaptcha(this);"
                                oninput="validateCaptcha(this);" 
                                onblur="validateCaptcha(this);">
                            <small id="captchaHint" class="form-text text-muted hint-text">
                                کد ۵ رقمی نمایش داده شده را وارد کنید
                            </small>
                        </div>
                    </div>

                    <div class="form-group d-flex justify-content-between mt-3">
                        <button type="button" id="btnRegister" onclick="registerUser()" class="btn btn-info col-md-5">
                            ثبت نام
                        </button>
                        <button type="button" class="btn btn-success col-md-5" onclick="window.location.href='/Login.aspx';">
                            ورود به سیستم
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script src="/Resources/dist/js/CustomValidations.js"></script>
    
    <!-- Replace Persian datepicker with MD.Bootstrap version -->
    <link href="/Resources/plugins/MD.BootstrapPersianDateTimePicker-3.11.5/dist/jquery.md.bootstrap.datetimepicker.style.css" rel="stylesheet" />
    <script src="/Resources/plugins/MD.BootstrapPersianDateTimePicker-3.11.5/dist/jquery.md.bootstrap.datetimepicker.js"></script>
    
    <script>
        function refreshCaptcha() {
            document.getElementById('captchaImage').src = "/App_handlers/captcha.ashx?" + new Date().getTime();
        }

        function validateName(input, fieldName) {
            const value = input.value.trim();
            const error = input.parentElement.nextElementSibling;

            if (!value) {
                setError(`لطفا ${fieldName} را وارد کنید`);
                return false;
            } else if (/[a-zA-Z0-9]/.test(value)) {
                setError(`${fieldName} باید به فارسی وارد شود`);
                return false;
            } else if (value.length < 2) {
                setError(`${fieldName} باید حداقل ۲ حرف باشد`);
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = `${fieldName} را به فارسی وارد کنید`;
                input.setCustomValidity('');
                return true;
            }

            function setError(message) {
                error.className = 'form-text text-danger';
                error.textContent = message;
                input.setCustomValidity(message);
            }
        }

        function validateEmail(input) {
            const value = input.value.trim();
            const error = document.getElementById('emailHint');
            
            if (!value) {
                // Email is optional
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'مثال: example@domain.com';
                input.setCustomValidity('');
                return true;
            }
            
            const emailPattern = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
            if (!emailPattern.test(value)) {
                error.className = 'form-text text-danger';
                error.textContent = 'فرمت ایمیل نادرست است';
                input.setCustomValidity('فرمت ایمیل نادرست است');
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'مثال: example@domain.com';
                input.setCustomValidity('');
                return true;
            }
        }

        function validatePassword(input) {
            const value = input.value;
            
            // Update requirement indicators
            const length = document.getElementById('length');
            const lowercase = document.getElementById('lowercase');
            const uppercase = document.getElementById('uppercase');
            const number = document.getElementById('number');
            
            // Check each requirement
            length.className = value.length >= 8 ? 'valid' : 'invalid';
            lowercase.className = /[a-z]/.test(value) ? 'valid' : 'invalid';
            uppercase.className = /[A-Z]/.test(value) ? 'valid' : 'invalid';
            number.className = /[0-9]/.test(value) ? 'valid' : 'invalid';
            
            // All conditions must be true for password to be valid
            const isValid = value.length >= 8 && 
                            /[a-z]/.test(value) && 
                            /[A-Z]/.test(value) && 
                            /[0-9]/.test(value);
                            
            if (!value) {
                input.setCustomValidity('لطفا رمز عبور را وارد کنید');
                return false;
            } else if (!isValid) {
                input.setCustomValidity('رمز عبور شرایط لازم را ندارد');
                return false;
            } else {
                input.setCustomValidity('');
                return true;
            }
        }

        function validateConfirmPassword(input) {
            const password = document.getElementById('txtPassword').value;
            const confirmPassword = input.value;
            const error = document.getElementById('confirmPasswordHint');

            if (!confirmPassword) {
                error.className = 'form-text text-danger';
                error.textContent = 'لطفا تکرار رمز عبور را وارد کنید';
                input.setCustomValidity('لطفا تکرار رمز عبور را وارد کنید');
                return false;
            } else if (password !== confirmPassword) {
                error.className = 'form-text text-danger';
                error.textContent = 'تکرار رمز عبور با رمز عبور مطابقت ندارد';
                input.setCustomValidity('تکرار رمز عبور با رمز عبور مطابقت ندارد');
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'رمز عبور را مجددا وارد کنید';
                input.setCustomValidity('');
                return true;
            }
        }

        function validateBirthDate(input) {
            const value = input.value.trim();
            const error = document.getElementById('birthDateHint');
            
            if (!value) {
                error.className = 'form-text text-danger';
                error.textContent = 'لطفا تاریخ تولد را انتخاب کنید';
                input.setCustomValidity('لطفا تاریخ تولد را انتخاب کنید');
                return false;
            } else {
                error.className = 'form-text text-muted hint-text';
                error.textContent = 'تاریخ تولد را از تقویم انتخاب کنید';
                input.setCustomValidity('');
                return true;
            }
        }

        function registerUser() {
            var form = document.getElementById("frmRegister");
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }

            // Disable button to prevent multiple submissions
            $("#btnRegister").prop("disabled", true);

            var param = {
                BirthDate: $.trim($("#txtBirthDate").dpGetEnValue()),
                NationalCode: $.trim($("#txtNationalCodeId").val()),
                MobileNumber: $.trim($("#txtMobileNumber").val()),
                Password: $("#txtPassword").val(),
                Captcha: $.trim($("#txtCaptcha").val())
            };

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Users/IndividualRegister',
                method: 'POST',
                contentType: 'application/json',
                dataType: 'json',
                data: JSON.stringify(param),
                success: function (data) {
                    $.messager.progress('close');
                    $("#btnRegister").prop("disabled", false);

                    if (data && data.IsSuccessful) {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                        setTimeout(function() {
                            window.location.href = '/Baraneh/Registration/RegisterVerifactionCode.aspx';
                        }, 3000);
                    } else {
                        $.messager.alert('خطای سیستم', data?.Message || 'مشکلی در ثبت نام پیش آمده است', 'error');
                        refreshCaptcha();
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $("#btnRegister").prop("disabled", false);
                    console.error("Error Details:", xhr.responseText);
                    $.messager.alert('خطای سیستم', 'خطای سمت سرور پیش آمده', 'error');
                    refreshCaptcha();
                }
            });
        }

        // Toggle password visibility
        $(".toggle-password").click(function () {
            $(this).toggleClass("fa-eye fa-eye-slash");
            var input = $($(this).attr("toggle"));
            input.attr("type", input.attr("type") === "password" ? "text" : "password");
        });

        // Auto-refresh CAPTCHA on focus
        document.getElementById('txtCaptcha').addEventListener('focus', function () {
            if (this.value === '') {
                refreshCaptcha();
            }
        });

        // Update the date picker initialization
        $(document).ready(function() {
            // Initialize MD.Bootstrap Persian DateTimePicker
            // $('#txtBirthDate').MdPersianDateTimePicker({
            //     targetTextSelector: '#txtBirthDate',
            //     dateFormat: 'yyyy/MM/dd',
            //     englishNumber: true,
            //     disableBeforeToday: false,
            //     enableTimePicker: false,
            //     selectedDate: null,
            //     //fromDate: new Date(1920, 0, 1),
            //     //toDate: new Date(),
            //     yearOffset: -100
            // }).on('hide.bs.popover', function() {
            //     // Validate the date when the picker hides
            //     validateBirthDate(document.getElementById('txtBirthDate'));
            // });
            
            // Initialize captcha
            refreshCaptcha();
        });

        // Add validation for birth date field
        // document.getElementById('txtBirthDate').addEventListener('blur', function() {
        //     validateBirthDate(this);
        // });
    </script>
</asp:Content>
