﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true" CodeBehind="RegisterEnterprise.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Registration.RegisterEnterprise1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="col-lg-6 col-md-10">
        <div class="card card-info">
            <div class="card-header-register">
                <div>
                    <h3 class="card-title">سامانه حمل و نقل بار و کالا</h3>
                </div>
                <div>
                    <a href="/login.aspx" style="color: #fff; font-size: 13px;">ورود</a>
                    /
                    <div class="btn-group" role="group">
                        <button id="btnGroupDrop1" type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="font-size: 13px;">
                            ثبت نام
                        </button>
                        <div class="dropdown-menu" aria-labelledby="btnGroupDrop1" style="min-width: 6rem;">
                            <a class="dropdown-item" href="/Baraneh/Registration/RegisterIndividual.aspx">اشخاص حقیقی</a>
                            <a class="dropdown-item" href="/Baraneh/Registration/RegisterEnterprise.aspx">اشخاص حقوقی</a>
                            <a class="dropdown-item" href="/Baraneh/Registration/RegisterViaUtcmsTrackingCode.aspx">ثبت نام با کد پیگیری UTCMS  </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-header -->
            <!-- form start -->
            <div class="form-horizontal">
                <div class="card-body">

                    <div class="container">


                        <!-- Nav tabs -->
                        <h3 style="margin-left: auto; margin-right: auto; width: fit-content; margin-top: 40px;">ثبت نام افراد حقوقی</h3>

                        <div class="alert alert-secondary" style="margin-top: 40px;">
                            <h6 style="text-align: right;">شهروند گرامی - توجه کنید :</h6>
                            <ol>
                                <li>نوع شخصیت حقوقی را به دقت انتخاب نمایید.</li>
                                <li>درصورت نیاز ، شناسه ملی سازمان/شرکت را به دقت وارد سازید</li>
                                <li>مشخصات مدیرعامل/نماینده شامل شماره موبایل ، کد ملی ، تاریخ تولد را به دقت وارد سازید</li>
                                <li>اطلاعات مربوط به نماینده و یا مدیرعامل سازمان باید در سیستم منحصر به فرد باشد. چنانچه نماینده یا مدیرعامل متقاضی پروانه اشتغال یا پروانه فعالیت به نام خود می باشد ، از شماره موبایل دیگری استفاده نمایید</li>
                                <li>مالکیت شماره موبایل باید متعلق به کد ملی نماینده یا مدیرعامل باشد و با آن همخوانی داشته باشد. </li>
                            </ol>
                        </div>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div id="home" class="container tab-pane active">
                                <br>
                                <form id="frmEdit" class="needs-validation" novalidate>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="FleetOwnerShipType">نوع شخصیت حقوقی :</label>
                                            <select class="form-control " id="FleetOwnerShipType" required placeholder="نوع شخصیت حقوقی را مشخص سازید">
                                                <option value="3">حقوقی خصوصی</option>
                                                <option value="2">حقوقی دولتی</option>
                                                <option value="4">شهرداریها و دهیاریها</option>

                                            </select>
                                            <div class="invalid-feedback">
                                                نوع شخصیت حقوقی را مشخص سازید
                                            </div>
                                            <div class="valid-feedback">
                                                نوع شخصیت حقوقی  مشخص شد
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="Name">نام شرکت/سازمان :</label>
                                            <input type="text" class="form-control " id="Name" required placeholder="نام شرکت/سازمان را وارد کنید">
                                            <div class="invalid-feedback">
                                                نام شرکت/سازمان را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                نام شرکت/سازمان وارد شد
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="NationalId">شناسه ملی :</label>
                                            <input type="text" class="form-control simpletextbox-only-number " id="NationalId" required placeholder="شناسه ملی را وارد کنید">
                                            <div class="invalid-feedback">
                                                شناسه ملی را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                شناسه ملی وارد شد
                                            </div>
                                        </div>
                                        <div id="extraItems">
                                            <div class="form-group">
                                                <label for="EconomicCode">کد اقتصادی :</label>
                                                <input type="text" class="form-control simpletextbox-only-number " id="EconomicCode" required placeholder="کد اقتصادی را وارد کنید">
                                                <div class="invalid-feedback">
                                                    کد اقتصادی را وارد کنید
                                                </div>
                                                <div class="valid-feedback">
                                                    کد اقتصادی وارد شد
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="RegistrationNumber">شماره ثبت :</label>
                                                <input type="text" class="form-control simpletextbox-only-number " id="RegistrationNumber" required placeholder="شماره ثبت را وارد کنید">
                                                <div class="invalid-feedback">
                                                    شماره ثبت را وارد کنید
                                                </div>
                                                <div class="valid-feedback">
                                                    شماره ثبت وارد شد
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label>تاریخ ثبت :</label>

                                                <div class="input-group">
                                                    <input class="normal-example form-control " id="RegistrationDate" required placeholder="تاریخ ثبت را وارد کنید" />
                                                    <div class="invalid-feedback">
                                                        تاریخ ثبت را وارد کنید
                                                    </div>
                                                    <div class="valid-feedback">
                                                        تاریخ ثبت وارد شد
                                                    </div>
                                                </div>
                                                <!-- /.input group -->
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="ManagerName">نام مدیر عامل/نماینده سازمان دولتی :</label>
                                            <input type="text" class="form-control " id="ManagerName" required placeholder="نام مدیر عامل/نماینده سازمان دولتی را وارد کنید">
                                            <div class="invalid-feedback">
                                                نام مدیر عامل/نماینده سازمان دولتی را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                نام مدیر عامل/نماینده سازمان دولتی وارد شد
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="ManagerNationalCode">کد ملی مدیر عامل/نماینده سازمان دولتی :</label>
                                            <input type="text" class="form-control simpletextbox-only-number " id="ManagerNationalCode" maxlength="10" required placeholder="کد ملی مدیر عامل/نماینده سازمان دولتی را وارد کنید">
                                            <div class="invalid-feedback">
                                                کد ملی مدیر عامل/نماینده سازمان دولتی را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                کد ملی مدیر عامل/نماینده سازمان دولتی وارد شد
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="ManagerBirthDate">تاریخ تولد  مدیر عامل / نماینده سازمان دولتی :</label>
                                            <input type="text" class="form-control simpletextbox-only-number dpTextBox dpTextBox-Invalid" id="ManagerBirthDate" maxlength="10" required placeholder="تاریخ تولد مدیر عامل/نماینده سازمان دولتی را وارد کنید">
                                            <input hidden id="txtManagerBirthDateVal" />
                                            <div class="invalid-feedback">
                                                تاریخ تولد مدیر عامل/نماینده سازمان دولتی را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                تاریخ تولد مدیر عامل/نماینده سازمان دولتی وارد شد
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">آدرس :</label>
                                            <div class="input-group">

                                                <textarea class="form-control" aria-label="With textarea" id="Address" required placeholder="آدرس را وارد کنید"></textarea>
                                                <div class="invalid-feedback">
                                                    آدرس را وارد کنید
                                                </div>
                                                <div class="valid-feedback">
                                                    آدرس وارد شد
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="Phone">شماره تماس (ثابت) نماینده شخص حقوقی :</label>
                                            <input type="text" class="form-control simpletextbox-only-number " id="Phone" required placeholder="شماره تماس شخص حقوقی را وارد کنید">
                                            <div class="invalid-feedback">
                                                شماره تماس شخص حقئوقی را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                شماره تماس شخص حقوقی وارد شد
                                            </div>
                                        </div>

                                        <div class="hr">
                                            اطلاعات حساب‌ کاربری
                                        </div>

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">نام کاربری :</label>
                                            <input type="text" class="form-control " id="Username" disabled placeholder="نام کاربری شناسه ملی شخص حقوقی است">
                                            <div class="invalid-feedback">
                                                نام کاربری را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                نام کاربری وارد شد
                                            </div>
                                        </div>


                                        <div class="form-group" style="margin-bottom: 0.5rem !important;">
                                            <label for="exampleInputEmail1">رمز عبور :</label>
                                            <div>
                                                <input type="password" class="form-control  " id="Password" required placeholder="رمز عبور را وارد کنید">
                                                <span toggle="#password-field" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                            </div>
                                            <div class="invalid-feedback">
                                                رمز عبور را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                رمز عبور وارد شد
                                            </div>

                                        </div>


                                        <div class="form-group">
                                            <label for="exampleInputEmail1">شماره تلفن همراه به نام مدیرعامل یا نماینده سازمان دولتی :</label>
                                            <input type="text" class="form-control simpletextbox-only-number" id="MobileNumber" maxlength="11" required placeholder="09120000000">
                                            <div class="invalid-feedback">
                                                شماره تلفن همراه را وارد کنید
                                            </div>
                                            <div class="valid-feedback">
                                                شماره تلفن همراه وارد شد
                                            </div>
                                        </div>


                                        <div class="" style="margin-top: 40px;">
                                            <button type="submit" id="btnsubmit" class="btn btn-info float-right col-md-12 mt-3">دریافت کد تایید  </button>
                                            <%--<button type="button"  onclick="javascript:$('#myModal').modal('show')"  id="btnEnterActiveCode" class="btn btn-info float-right col-md-12 mt-3" >  ورود کد تایید  </button></div>--%>
                                            <button type="button" onclick="sendTest()" id="btnEnterActiveCode" class="btn btn-info float-right col-md-12 mt-3">ورود کد تایید  </button>
                                        </div>


                                    </div>

                                </form>

                                <div class="modal fade" data-backdrop="static" data-keyboard="false" id="myModal">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <!-- Modal Header -->
                                            <div class="modal-header">

                                                <h4 class="modal-title">ارسال کد تایید</h4>
                                                <!-- <button type="button" class="close" data-dismiss="modal">&times;</button> -->

                                                <button type="button" class="close" aria-label="Close" onclick="javascript: $('#myModal').modal('hide');">
                                                    <span aria-hidden="true">&times; </span>
                                                </button>
                                            </div>

                                            <!-- Modal body -->
                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label for="exampleInputEmail1">کد تایید  :</label>
                                                    <input type="number" class="form-control " id="editApplicantId" required placeholder="کد تایید را وارد کنید">
                                                    <div class="invalid-feedback">
                                                        کد تایید را وارد کنید
                                                    </div>
                                                    <div class="valid-feedback ">
                                                        کد تایید وارد شد
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal footer -->
                                            <div class="modal-footer" style="justify-content: space-between;">
                                                <button type="button" onclick="sendAgain()" class="btn btn-info">ارسال مجدد کد</button>
                                                <button type="submit" onclick="confirmSMSCode()" class="btn btn-success">ارسال</button>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="modal fade" id="msg">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title">پیام </h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <div id="msgText"></div>
                                            </div>
                                        </div>

                                        <!-- Modal footer -->

                                    </div>
                                </div>
                            </div>

                        </div>


                        <!-- /.card-body -->


                    </div>

                </div>
            </div>

        </div>
        <!-- /.card-body -->


        <!-- /.card-footer -->
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var localUserId;

        $(function () {
            'use strict';
            window.addEventListener('load', function () {
                // Fetch all the forms we want to apply custom Bootstrap validation styles to
                var forms = document.getElementsByClassName('needs-validation');
                // Loop over them and prevent submission
                var validation = Array.prototype.filter.call(forms, function (form) {
                    form.addEventListener('submit', function (event) {
                        if (form.checkValidity() === false) {

                        }
                        else {
                            sendRequest();
                        }
                        form.classList.add('was-validated');
                        event.preventDefault();
                        event.stopPropagation();
                    }, false);
                });
            }, false);
        });



        $('#FleetOwnerShipType').on('change', function (e) {

            switch (this.value) {
                case "2":
                case "4":
                    $("#EconomicCode").prop("disabled", true);
                    $("#RegistrationNumber").prop("disabled", true);
                    $("#RegistrationDate").prop("disabled", true);
                    $('#extraItems').hide();

                    break;
                case "3":
                    $("#EconomicCode").prop("disabled", false);
                    $("#RegistrationNumber").prop("disabled", false);
                    $("#RegistrationDate").prop("disabled", false);
                    $('#extraItems').show();
                    break;

            }

        });


        $(".toggle-password").click(function () {

            $(this).toggleClass("fa-eye fa-eye-slash");
            var input = $($(this).attr("toggle"));
            if (input.attr("type") == "password") {
                input.attr("type", "text");
            } else {
                input.attr("type", "password");
            }
        });

        $("#RegistrationDate,#ManagerBirthDate").persianDatepicker({
            observer: true,
            format: 'YYYY/MM/DD',
            initialValue: false,
            calendar: {
                persian: {
                    locale: 'en'
                }
            },
        });

        function sendRequest() {

            //$.messager.alert('خطا', " امکان ثبت کاربر وجود ندارد - در حال به روز رسانی هستیم", 'خطا');
            //return;

            var OwnerShipType = $('#FleetOwnerShipType').val();
            var Username = $('#NationalId').val();
            var Password = $('#Password').val();
            var MobileNumber = $('#MobileNumber').val();
            var EconomicCode = $('#EconomicCode').val();
            var NationalId = $('#NationalId').val();
            var Name = $('#Name').val();
            var RegistrationDate = $('#RegistrationDate').val();
            var Address = $('#Address').val();
            var RegistrationNumber = $('#RegistrationNumber').val();
            var ManagerName = $('#ManagerName').val();
            var ManagerNationalCode = $('#ManagerNationalCode').val();
            var Phone = $('#Phone').val();
            var managerBirthDate = $("#ManagerBirthDate").val();

            var param = {
                Username: Username
                , Password: Password
                , MobileNumber: MobileNumber
                , EconomicCode: EconomicCode
                , NationalId: NationalId
                , Name: Name
                , RegistrationDate: RegistrationDate
                , Address: Address
                , RegistrationNumber: RegistrationNumber
                , ManagerName: ManagerName
                , ManagerNationalCode: ManagerNationalCode
                , Phone: Phone
                , ManagerBirthDate: managerBirthDate
                , FleetOwnershipTypeId: OwnerShipType


            }

            var p = JSON.stringify(param);
            $.messager.progress({ title: 'لطفا صبر کنید...' });
            $.ajax({
                url: '/CoreServices/API/Users/EnterpriseRegister',
                type: 'POST',
                contentType: 'application/json',
                data: p,
                success: function (data) {
                    $.messager.progress('close');


                    if (data.IsSuccessful) {
                        localUserId = data.ReturnValue;
                        $('#myModal').modal('show');
                    }
                    else {

                        //$.messager.show({
                        //    title: 'پیغام سیستم',
                        //    msg: data.Message,
                        //    timeout: 1000,
                        //    showType: 'slide',
                        //    style: {
                        //        right: '',
                        //        bottom: ''
                        //    }
                        //});

                        $('#msgText').html(data.Message);
                        $('#msg').modal('show');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('خطا', errorThrown, 'خطا');
                }
            });
        }

        function confirmSMSCode() {

            var Code = $('#editApplicantId').val();
            if (Code == '') {
                //$.messager.show({
                //            title: 'پیغام سیستم',
                //            msg: "کد ارسال شده به شماره موبایل خود را وارد سازید",
                //            timeout: 1000,
                //            showType: 'slide',
                //            style: {
                //                right: '',
                //                bottom: ''
                //            }
                //        });
                //$('#msgText').html("کد ارسال شده به شماره موبایل خود را وارد سازید");
                //$('#msg').modal('show');

                $("#editApplicantId").addClass("is-invalid");
                return;
            }

            $("#editApplicantId").removeClass("is-invalid");

            var param = {
                activationCode: Code,
                UserId: localUserId
            }



            var q = JSON.stringify(param);
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Users/ConfirmSMSCode',
                type: 'POST',
                contentType: 'application/json',
                data: q,
                success: function (data) {
                    $.messager.progress('close');
                    $('#msgText').html(data.Message);
                    $('#msg').modal('show');

                    setTimeout(function () {
                        if (data.IsSuccessful) {
                            window.location.replace("/login.aspx");
                        }
                    }, 3000);


                    //$.messager.show({
                    //    title: 'پیغام سیستم',
                    //    msg: data.Message,
                    //    timeout: 1000,
                    //    showType: 'slide',
                    //    style: {
                    //        right: '',
                    //        bottom: ''
                    //    }
                    //});
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('خطا', errorThrown, 'خطا');
                }
            });

        }

        function sendAgain() {

            var param = {
                UserId: localUserId
            }

            var p = JSON.stringify(param);
            $.ajax({
                url: '/CoreServices/API/Users/ClientRequestActivationCode',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(param),
                success: function (data) {
                    //$.messager.show({
                    //        title: 'پیغام سیستم',
                    //        msg: data.Message,
                    //        timeout: 1000,
                    //        showType: 'slide',
                    //        style: {
                    //            right: '',
                    //            bottom: ''
                    //        }
                    //    });
                    $('#msgText').html(data.Message);
                    $('#msg').modal('show');
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('خطا', errorThrown, 'خطا');
                }
            });

        }

    </script>
</asp:Content>
