﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="TransferLicensePlateList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.PublicPlate.TransferLicensePlateList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" id="announce">


        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست درخواست های انتقال پلاک عمومی</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست درخواست های انتقال پلاک عمومی'">
                    <table id="grdMain">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                     
                                <th data-options="field:'FromPlateNo'" hidden="hidden"></th>
                                <th data-options="field:'ToPlateNo'" hidden="hidden"></th>
                                <th data-options="field:'StateValue'" hidden="hidden"></th>
                                <th data-options="field:'FromTransferPlateVehicleId'" hidden="hidden"></th>
                                <th data-options="field:'ToTransferPlateVehicleId'" hidden="hidden"></th>
                                <th data-options="field:'TransferPlateRequestId'" hidden="hidden"></th>
                                <th data-options="field:'RequestDate', sortable:'true', width:160">تاریخ درخواست</th>
                                <th data-options="field:'FromVin', sortable:'true', width:160">VIN خودرو فعلی</th>
                                <th data-options="field:'FromPlate', sortable:'true', width:160">پلاک خودرو فعلی</th>
                                <th data-options="field:'ToVin', sortable:'true', width:160">VIN خودرو جدید</th>
                                <th data-options="field:'ToPlate', sortable:'true', width:160">پلاک خودرو جدید</th>
                                <%--<th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>--%>
                                <%--<th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>--%>
                                <th data-options="field:'State', sortable:'true', width:160">وضعیت در خواست</th>
                            </tr>
                        </thead>
                    </table>
                    <div id="grdMainToolbar" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
                         
                             <span>پلاک</span>
                            <input tabindex="4" onkeypress="return /[0-9]/i.test(event.key)"maxlength="2" id="txtIranPlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" required>
                            <span>ایران</span>
                            <input tabindex="3"onkeypress="return /[0-9]/i.test(event.key)" maxlength="3"id="txtThreePlateNoCarList" type="text" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;" >
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>

                            </select>
                            <input tabindex="1"onkeypress="return /[0-9]/i.test(event.key)" maxlength="2" type="text" id="txtOnePlateNoCarList" class="" style="width: 5%; height: 25px; text-align: center; border: 1px solid #95B8E7; border-radius: 5px;">
                            <a onclick="DeleteRequest()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-cancel'">حذف درخواست</a>
                            <a onclick="Display()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display'">نمایش</a>
                            <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
        var grdMain = $("#grdMain");

        $(document).ready(() => {

            initComponent();
        });



        var initComponent = () => {

            grdMain.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: false,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/TransferLicensePlate/GetAll',
                rownumbers: true,
                sortName: 'TransferPlateRequestId',
                sortOrder: 'desc',
                toolbar: '#grdMainToolbar',
                height: $(window).height() - 160,
                queryParams: {
                    plaqueValue: ''
                }
            });

        }



        function searchCarListOnDB() {

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNoBoot(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            grdMain.datagrid('reload', opts.queryParams);

        }

        


        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').val('');
            $('#txtThreePlateNoCarList').val('');
            $('#txtIranPlateNoCarList').val('');
            $('#drpTwoPlateNoCarList').val('');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 2;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }

        var DeleteRequest = () => {

            var row = grdMain.datagrid('getSelected');
                if (row == null) {
                    $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                    return;
                }

            var TransferPlateRequestId = row.TransferPlateRequestId;
            $.messager.progress({ title: 'لطفا صبر کنید...' });
             


                $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                    if (r) {

                        //انتخاب اول
                        //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                        $.ajax({
                            url: '/CoreServices/API/TransferLicensePlate/DeleteRequest',
                            type: 'Post',
                            contentType: 'application/json',
                            data: JSON.stringify(TransferPlateRequestId),
                            async: false,
                            success: function (data) {
                                $.messager.progress('close');

                                if (data.IsSuccessful == true) {
                                    searchCarListOnDB();

                                }
                                else {
                                    $.messager.alert('Warning', data.Message);
                                }
                            },
                            error: function (xhr, textStatus, errorThrown) {
                                $.messager.progress('close');
                                showAjaxErrorMessage(xhr, textStatus, errorThrown);
                            }
                        });

                    }
                });
             
        }
        var Display = () => {

            var row = grdMain.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var TransferPlateWin = window.open("/Baraneh/TransferLicensePlate.aspx");
            
            TransferPlateWin.window.TransferPlate = {
                FromVin:row.FromVin,
                ToVin: row.ToVin,
                FromPlate: row.FromPlateNo,
                ToPlate: row.ToPlateNo,
                FromTransferPlateVehicleId:row.FromTransferPlateVehicleId,
                ToTransferPlateVehicleId: row.ToTransferPlateVehicleId,
                State: row.StateValue
            }
        }

    </script>
</asp:Content>
