﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="ExitPublicPlateListPolice.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.PublicPlate.ExitPublicPlateList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

    <div class="content-wrapper" id="announce">


        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> درخواست های خروج از ناوگان پلاک عمومی</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست درخواست های انتقال پلاک عمومی'">
                    <table id="grdMain">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'ExitPublicPlateId'" hidden="hidden"></th>
                                <th data-options="field:'State'" hidden="hidden"></th>
                                
                                <th data-options="field:'PlateNo', sortable:'true', width:160," hidden="hidden"> </th>

                                <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                                <th data-options="field:'PlateStr', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ ثبت</th>
                                <th data-options="field:'StrState', sortable:'true', width:160">وضعیت</th>
                            </tr>
                        </thead>
                    </table>
                    <div id="grdMainToolbar" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
                            <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                            <span>ایران</span>
                            <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>
                            </select>
                            <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                            <a onclick="Display()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display'">نمایش</a>
                            <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdMain = $("#grdMain");

        $(document).ready(() => {

            initComponent();
        });



        var initComponent = () => {

            grdMain.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: false,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/ExitPublicPlate/GetAllPolice',
                rownumbers: true,
                sortName: 'ExitPublicPlateId',
                sortOrder: 'desc',
                toolbar: '#grdMainToolbar',
                height: $(window).height() - 160,

                queryParams: {
                    plaqueValue: ''
                }
            });

        }



        function searchCarListOnDB() {

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            grdMain.datagrid('reload', opts.queryParams);

        }

        


        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 2;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }

        
        var Display = () => {
            var row = grdMain.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            
            var ExitPublicPlateWin = window.open("/Print/PrintExitpublicPlate.html?exitPlateId=" + row.ExitPublicPlateId);

           
        }
   


    </script>
</asp:Content>
