﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="OfficeLmsManagerLicensing.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Office.OfficeLmsManagerLicensing" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
     <div class="content-wrapper" style="padding: 20px;">
        <div id="mainForm">
            
            <div class="easyui-panel" title=" تغذیه اطلاعات پروانه فعالیت " style="width: 100%; padding: 10px" data-options="collapsible:true">


                <div class="col-md-12" style="display: flex; padding: 5px;">
                    <div class="col-md-8">
                        <!--Objects-->
                        <input tabindex="6" tipPosition="left" id="txtVehicleTrackingCode" class="easyui-textbox" labelWidth="140" style="width: 280px;text-align: center" data-options="label:'کد پیگیری :'">
                        <input tabindex="6" tipPosition="left" id="txtNationalId" class="easyui-textbox" labelWidth="140" style="width: 280px; text-align: center" data-options="label:'شناسه ملی :'">
                    </div>
                    <div class="col-md-4">
                        <!--Buttons-->
                        <a href="#" class="easyui-linkbutton " id="btnVehicleInquiry" onclick="lmsVehicleInquiry()" style="" iconcls="icon-reload">استعلام کد پیگیری</a>
                        <a href="#" class="easyui-linkbutton " onclick="vehicleNew()" style="" iconcls="icon-reload">جدید</a>
                    </div>
                </div>
                <div style="padding-right: 380px !important">درج شناسه ملی برای اشخاص حقوقی اجباری است</div>
                <div class="col-md-12" style=" padding: 5px;">
                    <div class="col-md-12" style=" padding-bottom: 5px;">
                        <input tabindex="1" tipPosition="left" id="txtVIN" class="easyui-textbox" labelWidth="140" style="width: 280px; text-align: center" data-options="label:'VIN :'">
                        <input tabindex="1" tipPosition="left" id="txtPlateNo" class="easyui-textbox" labelWidth="140" style="width: 280px; text-align: center" data-options="label:'پلاک :'">
                    </div>
                    <div style="display: flex; ">
                        <div class="col-md-8">
                            <input tabindex="1" tipPosition="left" id="txtVehicleOwner" class="easyui-textbox" labelWidth="140" style="width: 280px; text-align: center" data-options="label:'مالک :'">
                            <input tabindex="1" tipPosition="left" id="txtVehicleCategory" class="easyui-textbox" labelWidth="140" style="width: 340px; text-align: center" data-options="label:'نوع ناوگان :'">
                        </div>
                        <div class="col-md-4">
                            <!--Buttons-->
                            <a href="#" id="btnVehicleImport" class="easyui-linkbutton " onclick="lmsVehicleImport()" disabled="true" iconcls="icon-reload">تغذیه</a>
                            <%--<a href="#" id="btnVehicleDetails" class="easyui-linkbutton " onclick="lmsShowLicensingDetails()" disabled="true" style="width: 113px" iconcls="icon-reload">نمایش جزییات</a>--%>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
        var globalVehicleRequestDetails = {};
        var globalLicensingResult = {};
        var globalDriverLicensingResult = {};
        var globalDriverRequestDetails = {};

        function lmsVehicleInquiry() {

            var nationalId = $('#txtNationalId').textbox('getValue');
            var trackingCode = $('#txtVehicleTrackingCode').textbox('getValue');
            if (trackingCode === "") {
                $.messager.alert('اخطار', "کد پیگیری را وارد سازید", 'error');
                return;
            }

            var param = {
                NationalId: nationalId,
                TrackingCode: trackingCode,
                ValidateData: true
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/PcPos/API/PcPosVehicles/VehicleRequestDetails',
                type: 'Post',
                data: JSON.stringify(param),
                contentType: 'application/json',

                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful) {
                        
                        globalVehicleRequestDetails = data.ReturnValue;
                        if (globalVehicleRequestDetails.HasError === true) {
                            $.messager.alert('Error', globalVehicleRequestDetails.ErrorMessage, 'info');
                            return;
                        }
                        $('#txtVIN').textbox('setValue', globalVehicleRequestDetails.VIN);
                        $('#txtPlateNo').textbox('setValue', globalVehicleRequestDetails.MisPlate);
                        $('#txtVehicleOwner').textbox('setValue', globalVehicleRequestDetails.FullName);
                        $('#txtVehicleCategory').textbox('setValue', globalVehicleRequestDetails.LicenseCategotyTitle);
                        $('#btnVehicleInquiry').linkbutton('disable');
                        $('#btnVehicleImport').linkbutton('enable');
                        $.messager.alert('پیام سیستم', "درصورت تایید صحت اطلاعات ، نسبت به تغذیه درخواست اقدام نمایید", 'info');

                    }
                    else {

                        $.messager.alert('خطا', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });
        }
        function lmsVehicleImport() {
            var nationalId = $('#txtNationalId').textbox('getValue');
            if (globalVehicleRequestDetails.IsPersonalUser === false
                && nationalId.length !== 11) {

                $.messager.alert('خطا', 'شناسه ملی 11 رقمی اشخاص حقوقی اجباری است', 'error');
                return;

            } else if (globalVehicleRequestDetails.IsPersonalUser === false) {
                globalVehicleRequestDetails.NationalId = nationalId;
            }


            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/PcPos/API/PcPosVehicles/ImportVehiclRequestLicenseFromDbWithUserRegistration',
                type: 'Post',
                data: JSON.stringify(globalVehicleRequestDetails),
                contentType: 'application/json',

                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful) {
                        
                        globalLicensingResult = data.ReturnValue;
                        /*$('#btnVehicleDetails').linkbutton('enable');*/
                        $('#btnVehicleImport').linkbutton('disable');
                        $('#btnVehicleImport').linkbutton('diasble');
                        $('#messageInfo').html(data.Message);
                        $.messager.alert('پیام سیستم', "تغدیه اطلاعات با موفقیت همراه بود. میتوانید نسبت به مشاهده جزییات درخواست اقدام فرمایید", 'error');
                    }
                    else {

                        $.messager.alert('خطا', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });
        }

       

        function lmsDriverInquiry() {
            var trackingCode = $('#txtDriverTrackingCode').textbox('getValue');

            if (trackingCode === "") {
                $.messager.alert('اخطار', "کد پیگیری را وارد سازید", 'error');
                return;
            }

            var param = {
                TrackingCode: trackingCode,
                ValidateData: true
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/PcPos/API/PcPosDrivers/DriverRequestDetails',
                type: 'Post',
                data: JSON.stringify(param),
                contentType: 'application/json',

                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful) {
                        
                        globalDriverRequestDetails = data.ReturnValue;
                        $('#txtDriverFullName').textbox('setValue', globalDriverRequestDetails.Name + ' ' + globalDriverRequestDetails.Family);
                        $('#txtNationalCode').textbox('setValue', globalDriverRequestDetails.NationalCode);
                        $('#btnDriverImport').linkbutton('enable');
                        $('#btnDriverInquiry').linkbutton('disable');
                        $.messager.alert('پیام سیستم', "درصورت تایید صحت اطلاعات ، نسبت به تغذیه درخواست اقدام نمایید", 'info');

                    }
                    else {

                        $.messager.alert('خطا', data.Message, 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });
        }
        function lmsDriverImport() {

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/PcPos/API/PcPosDrivers/ImportDriverRequestLicenseFromDbWithUserRegistration',
                type: 'Post',
                data: JSON.stringify(globalDriverRequestDetails),
                contentType: 'application/json',

                success: function (data) {
                    $.messager.progress('close');

                    if (data.IsSuccessful) {
                        globalDriverLicensingResult = data.ReturnValue;
                        $('#btnDriverDetails').linkbutton('enable');
                        $('#btnDriverImport').linkbutton('disable');
                        $.messager.alert('پیام سیستم', "تغدیه اطلاعات با موفقیت همراه بود. میتوانید نسبت به مشاهده جزییات درخواست اقدام فرمایید", 'info');

                    }
                    else {

                        $.messager.alert('خطا', data.Message, 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');
                }
            });
        }

        function lmsShowDriverLicensingDetails() {

            window.open('/AdminBaraneh/Baraneh/Drivers/driverDetail.aspx?DriverLicenseId=' + globalDriverLicensingResult.DriverLicenseId + '&DriverId=' + globalDriverLicensingResult.DriverId);
        }

        function vehicleNew() {
            $('#txtVehicleTrackingCode').textbox('setValue', '');
            $('#txtNationalId').textbox('setValue', '');
            $('#txtVIN').textbox('setValue', '');
            $('#txtPlateNo').textbox('setValue', '');
            $('#txtVehicleOwner').textbox('setValue', '');
            $('#txtVehicleCategory').textbox('setValue', '');

            $('#btnVehicleImport').linkbutton('disable');
            /*$('#btnVehicleDetails').linkbutton('disable');*/
            $('#btnVehicleInquiry').linkbutton('enable');

            globalLicensingResult = {};
            globalVehicleRequestDetails = {};
        }

        function driverNew() {
            $('#txtDriverTrackingCode').textbox('setValue', '');
            $('#txtDriverFullName').textbox('setValue', '');
            $('#txtNationalCode').textbox('setValue', '');

            $('#btnDriverImport').linkbutton('disable');
            $('#btnDriverDetails').linkbutton('disable');
            $('#btnDriverInquiry').linkbutton('enable');
            globalDriverLicensingResult = {};
            globalDriverRequestDetails = {};

        }

        $(document).ready(function () {
            //   restrictAccess();
        });

    </script>
</asp:Content>
