﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="OfficeLicensingList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Office.OfficeLicensingList" %>
 
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <script type="text/javascript" src="/DesktopModules/Baraneh/Css/plugins/datagrid-detailview.js"></script>
    <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
       <%-- <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست پروانه های صادر شده</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>--%>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست درخواست های پروانه فعالیت'">
                    <table id="grdLicensingCarList">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'LicensingId', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'NationalCode', sortable:'true', width:160">کد/شناسه ملی</th>
                                <th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>
                                <th data-options="field:'Vin', sortable:'true', width:160">VIN</th>
                                <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'System', sortable:'true', width:140">سیستم</th>
                                <%--<th data-options="field:'style', sortable:'true', width:160">تیپ</th>--%>
                                <th data-options="field:'LicenseDate', sortable:'true', width:140">تاریخ صدور</th>
                                <th data-options="field:'LicenseNumber', sortable:'true', width:160">شماره پروانه</th>
                                <th data-options="field:'LicenseStatusTitle', sortable:'true', width:200">وضعیت</th>
                                <th data-options="field:'UTCMSTrackingCode', sortable:'true', width:160">کدپیگیری</th>
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
                            
                            <%--<a onclick="addNew()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-add'">افزودن</a>--%>
                            <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                            <span>ایران</span>
                            <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>

                            </select>
                            <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                            
                            <select class="easyui-combobox" id="LicenseStatesList" label="وضعیت پروانه :" labelPosition="right" style="width:350px;">
                                <option value="0">همه</option>
                                <option value="1">در دست بررسی</option>
                                <option value="2">تایید شده</option>
                                <option value="3">تایید نشده</option>
                                <option value="4">رد شده UTCMS</option>
                                <option value="16">منقضی شده</option>
                                <option value="14">در انتظار پرداخت</option>
                                <%-- <option value="3">Arkansas</option>
                                 <option value="3">Arkansas</option>--%>
               
                            </select>

                            <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو / به روز رسانی </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                            <a href="javascript:void(0)" id="btnUTCMS" onclick="inqueryUTCMS()" class="easyui-linkbutton">استعلام UTCMS</a>
                            <a id="LicenseOwnerEdit_btnSendTicket" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="sendTicketDialog()">ارسال تیکت</a>
                            <a onclick="print()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ پروانه</a>
                            <a onclick="$('#grdLicensingCarList').datagrid('print','درخواست های پروانه فعالیت');" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print'">چاپ لیست</a>
                            <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>

                        </div>
                    </div>
                </div>
            </div>

            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
       
        
                <div class="row">
                    <div class="col-lg-12">
                        <section class="content">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" style="margin-top: 45px; z-index: 99999;">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <!--
                                                        <div class="modal-header">
                                                      <h5 class="modal-title" id="exampleModalLabel">اطلاعیه های سامانه حمل و نقل بار وکالا</h5>
                                                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                      </button>
                                                    </div>
                                                     -->
                                                    <div class="modal-body"  >                                                      
                                                        توضیحات : 
                                                        <br />
                                                        <textarea id="txtDescription" rows="10" style="width:100%;"></textarea>                                              
                                                    </div>
                                                    <div class="modal-footer" style="text-align:right; justify-content:center;">
                                                        <button type="button" id="btnSubmitCancelRequest" onclick="submitCancelRequest()" class="btn btn-danger" data-dismiss="modal">
                                                            ثبت درخواست ابطال
                                                        </button>
                                                    &nbsp

                                                        <button type="button" id="close" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                                                     
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Main content -->
                                        <!-- /.invoice -->
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                            </div>
                            <!-- /.container-fluid -->
                        </section>
                    </div>
                </div>
        <div id="dlgTicket" class="easyui-dialog" style="width:620px;height:220px;padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width:15%; text-align:left;">
                        <div> موضوع پیام:</div>
                    </td>

                    <td>
                        <input id="subjectTicket" class="easyui-textbox" tipPosition="left" style="width:300px;height:30px " data-options="multiline:true">
                    </td>
                </tr>

                <tr>
                    <td style="width:15%; text-align:left;">
                        <div> متن پیام:</div>
                    </td>

                    <td>
                        <input id="txtTicketBody" class="easyui-textbox" tipPosition="left" style="width:300px;height:100px " data-options="multiline:true">
                    </td>
                </tr>

            </table>
        </form>
        <a href="javascript:void(0)" class="easyui-linkbutton c6" style="width: 120px; " iconcls="icon-ok " onclick="sendTicket()">ارسال</a>
        <a href="javascript:void(0)" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript: $('#dlgTicket').dialog('close');" style="width:120px">لغو</a>
    </div>
    
    </div>
   
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdLicensingCarList = $('#grdLicensingCarList');
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var drpLicenseOwner = $('#drpLicenseOwner'); 
        function toExcel() {
            //$("#grdMain").datagrid('toExcel', 'dg.xls');
            $("#grdLicensingCarList").datagrid('toExcel', {
                filename: 'licensing.xls',
                fields: ['OwnerName', 'NationalCode', 'MISPlate', 'LicenseDate', 'LicenseStatusTitle'],
            });
        }
        function addNew() {

            var plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error') {
                $.messager.alert('خطا', 'پلاک به درستی انتخاب نشده است', 'error');
                return;
            }

           

            $.ajax({
                url: '/DesktopModules/BaranehServices/API/Licensing/AddToOfficeList',
                type: 'post',
                contentType: 'application/json',
                data: JSON.stringify(plaqueValue),
                success: function (data) {
                    
                    $.messager.progress('close');

                    if (data) {
                        
                        $.messager.alert('توجه', data.Message, 'info');

                    }
                },
                error: function (xhr, textStatus, errorThrown) {

                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                }
            });

        }

        function sendTicketDialog() {
            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $('#txtTicketBody').textbox('clear');
            $('#dlgTicket').dialog('open').dialog('center').dialog('setTitle', 'ارسال تیکت');

        }
        function sendTicket() {
            var comment = $('#txtTicketBody').val(); // متن درخواست

            if (comment === '' || comment === null) {
                $.messager.alert('اخطار', 'لطفا توضیحات را وارد نمائید', 'اخطار');
                return;
            }

            // فرض می‌کنیم که row همان رکورد انتخاب شده از گرید است
            var row = $('#grdLicensingCarList').datagrid('getSelected');

            if (!row) {
                $.messager.alert('اخطار', 'لطفا یک رکورد را انتخاب نمائید', 'اخطار');
                return;
            }

            // متغیرها از رکورد انتخاب شده
            var LicensingId = row.LicensingId;
            var Vin = row.Vin;
                var OwnerUserName = row.OwnerUserName;
            var PlateNo = row.PlateNo;
            var OwnerCellPhone = row.OwnerCellPhone;
            var LicensingGUID = row.LicensingGUID;

            $.ajax({
                url: '/CoreServices/API/Tickets/SaveTicket',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    'UserName': OwnerUserName,
                    'VIN': Vin,
                    'PlateNo': PlateNo,
                    'licensingId': LicensingId,
                    'Phone': OwnerCellPhone,
                    'Description': comment,
                    'SubSystemId':2,
                    'LicensingGUID': LicensingGUID
                }),

                success: function (data) {
                    if (data.IsSuccessful === true) {
             
                        $.messager.alert('پیغام سیستمی', data.Message, 'info'); // نمایش پیام سیستمی پس از بروز رسانی
                    } else {
                        $.messager.alert('اخطار', data.Message, 'error');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');
                }
            });
        }

     
        function inqueryUTCMS() {

            
            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Licensing/InquiryUtcmsWithTranslateByGUID',
                type: 'Post',
                data: JSON.stringify(row.LicensingGUID),
                contentType: 'application/json',
                success: function (data) {
                    $.messager.progress('close');

                    
                    if (data) {
                        if (data.IsSuccessful === true) {
                            if (isJson(data.ReturnValue) || isObject(data.ReturnValue)) {
                                var final_data = data.ReturnValue;


                                if (isJson(data.ReturnValue)) {
                                    final_data = JSON.parse(data.ReturnValue);
                                }

                                var message = "<div style='text-align:right;direction:rtl '>";

                                Object.keys(final_data).map((item, index) => {
                                    if (final_data[item] !== 'br') {
                                        message += item + ' : ' + (final_data[item] === null ? 'نامشخص' : final_data[item]) + ' <br />';
                                    }
                                    else {
                                        message += ' <hr />';
                                    }

                                });
                                message += "</div>";
                                $.messager.alert('پیام سیستم', message, '');

                            } else {
                                $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                            }
                        } else {
                            $.messager.alert('پیام سیستم', data.Message, 'info');
                        }

                    } else {
                        $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });


        };

    


        $(function () {
            
            

            grdLicensingCarList.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: true,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                // rownumbers: true,
                // loadMsg: 'صبر کنید - درحال بارگذرای',
                // isBindOnLoad: true,
                url: '/CoreServices/API/Licensing/LicensingList',
                sortName: 'RequestDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                onClickRow: function () {
                    globalCurrentRow = grdLicensingCarList.datagrid("getSelected");
                },
                detailFormatter: function (rowIndex, rowData) {
                    if (rowData.LastRejectedDesc) {
                        return '<div class=".col-md12"><div class=".col-md2"> علت رد درخواست :</div><div class=".col-md8">' + rowData.LastRejectedDesc + '</div>';
                    }

                },
                queryParams: {
                    licenseStatusId: 0,
                    isNewLicense: 0,
                    plateNo: ''
                }
            });
        });


        

        function print() {

            var row = grdLicensingCarList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            if (row['LicenseTypeId'] === 2) {
                $.messager.alert('هشدار', "پروانه فعالیت شما در شهر دیگری صادر شده است و در این شهر پروانه شما مهمان است.", 'error');
                return;
            }

            if (row['LicenseStatusId'] !== 2) {
                $.messager.alert('هشدار', "پروانه مورد نظر هنوز تایید نشده است", 'error');
                return;
            }
            else {
                window.open("/Reports/Print/PrintLicensing.html?LicensingGUID=" + row['LicensingGUID']);
            }
        }

        

        


        $(() => {

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];


            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdLicensingCarList.datagrid('enableFilter',
                [
                    {
                        field: 'NationalCode',
                        type: 'text',
                        op: textOp,
                    },
                    {
                        field: 'OwnerName',
                        type: 'text',
                        op: textOp,
                    },
                    {
                        field: 'VIN',
                        type: 'text',
                        op: textOp,
                    },
                    {
                        field: 'UTCMSTrackingCode',
                        type: 'text',
                        op: textOp,
                    }
                   
                ]);


        });


        function searchCarListOnDB() {
            
            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;
            var StatesList = $('#LicenseStatesList').combobox('getValue');
            opts.queryParams['plateNo'] = plaqueValue;
            opts.queryParams['licenseStatusId'] = StatesList;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingCarList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = '';
            opts.queryParams['requestStatus'] = 0;
            grdLicensingCarList.datagrid('reload', opts.queryParams);

        }
        
        var licenseOwnerIdInSelectGrid = 0;
        
        $(document).ready(function () {
            restrictAccess();
        });
  
     
      
    </script>
</asp:Content>
