﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="MotorcycleList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Motorcycles.MotorcycleList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست موتورسیکلت های ثبت شده</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست ناوگان موتورسیکلت و پروانه های صادر شده'">
                    <table id="grdLicensingMotorcycleList">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'MotorcycleLicensingNumber', sortable:'true', width:160">شماره پروانه</th>
                                <th data-options="field:'Vin', sortable:'true', width:160">VIN</th>
                                <th data-options="field:'PlateNo', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'Driver_NationalCode', sortable:'true', width:160">کدملی راننده</th>
                                <th data-options="field:'Driver_Phone', sortable:'true', width:160">شماره تماس راننده</th>
                                <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                                <th data-options="field:'Color', sortable:'true', width:160">رنگ</th>
                                <%--<th data-options="field:'OwnerName', sortable:'true', width:160">نام مالک</th>--%>
                                <%--<th data-options="field:'OwnerCellPhone', sortable:'true', width:160">شماره تماس</th>--%>
                                <th data-options="field:'UsageName', sortable:'true', width:160">کاربرد</th>
                                <th data-options="field:'LicensingDate', sortable:'true', width:160">تاریخ صدور</th>
                                <th data-options="field:'ExpireData', sortable:'true', width:160">تاریخ انقضا</th>
                                <th runat="server" id="th_Facilities" data-options="field:'_operate', sortable:'true', width:160,align:'center',formatter:formatOper" hidden="hidden">معرفی جهت وام</th>
                                <%--<th data-options="field:'LicensingStatusTitle', sortable:'true', width:300">وضعیت</th>--%>
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarLicensingCarList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">
                            <a href="#" class="easyui-linkbutton" onclick="edit()" iconcls="icon-display">ویرایش اطلاعات</a>
                            <a href="#" class="easyui-linkbutton" onclick="addNew()" iconcls="icon-add">افزودن مورد جدید</a>
                            <input id="txtPlakNo" type="text" class="easyui-numberbox" data-options="label:'پلاک :',width:'220px'">
                            <a href="#" class="easyui-linkbutton" onclick="searchByPlak()" iconcls="icon-search">جست و جو</a>
                             
                        </div>
                    </div>
                </div>
            </div>


            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->

    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
       

        var currentSelectedRowId;
        var grdLicensingMotorcycleList = $('#grdLicensingMotorcycleList');
        var winCarEdit = $('#winCarEdit');
        var winLicensing = $('#winLicensing');
        var drpLicenseOwner = $('#drpLicenseOwner');

        function searchByPlak() {

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = $("#txtPlakNo").textbox("getValue");


            opts.queryParams['plaqueValue'] = plaqueValue;
            // opts.queryParams['type'] = 2;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        function edit() {

            var row = grdLicensingMotorcycleList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            window.open('/Baraneh/motorcycleLicensingEdit.aspx?MotorcycleLicensingId=' + row['MotorcycleLicensingId']);

        }
        function addNew() {
            window.open('/Baraneh/motorcycleLicensingEdit.aspx');

        }


        $(function () {

            winCarEdit.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات خودروها",
                closed: true
            });

            winLicensing.window({
                width: '1060',
                height: '500',

                modal: true,
                title: "فرم اطلاعات پروانه صادر شده",
                closed: true
            });
            grdLicensingMotorcycleList.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                // rownumbers: true,
                // loadMsg: 'صبر کنید - درحال بارگذرای',
                // isBindOnLoad: true,
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/GetAllMotorcycleLicensing',
                sortName: 'MotorcycleLicensingId',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarLicensingCarList',
                height: $(window).height() - 160,
                queryParams: {
                    plaqueValue: ''
                }
            });


        });

        function print() {

            var row = grdLicensingMotorcycleList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            //openEditLicensingWindow('/Reports/Print/PrintLicensing.html?vehicleId=' + row['VehicleId']);
            window.open("/Print/PrintLicensing.html?vehicleId=" + row['VehicleId']);
        }
        function formatOper(val, row, index) {
            currentSelectedRowId = row.MotorcycleLicensingId;
            //
            if (row.GetFacilities) {
                return `<input type="checkbox" checked data-row="` + row + `" onchange="addToFacilitiesList(event)"/>`;

            }
            return `<input type="checkbox" data-row="` + row + `" onchange="addToFacilitiesList(event)"/>`;

        }
        function addToFacilitiesList(ev) {
            if (ev.target.checked) {
                $.messager.confirm('پیام سیستم', 'موتور سیکلت مورد نظر جهت دریافت تسهیلات معرفی شود ؟', function (r) {
                    if (r) {
                        $.ajax({

                            url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/AddToFacilitiesList',
                            type: 'Get',
                            contentType: 'application/json',
                            data: { licensingId: currentSelectedRowId },
                            success: function (data) {
                                $.messager.alert(data.Title, data.Message);

                            },
                            error: function (xhr, textStatus, errorThrown) {
                                //
                                window.location.replace("/login.aspx");
                            }
                        });
                    }
                });

            } else {
                $.messager.confirm('پیام سیستم', 'حذف موتور سیکلت مورد نظر از دریافت تسهیلات ؟', function (r) {
                    if (r) {
                        $.ajax({

                            url: '/DesktopModules/MotorcycleProxy/API/MotorcycleLicensing/RemoveFromFacilitiesList',
                            type: 'Get',
                            contentType: 'application/json',
                            data: { licensingId: currentSelectedRowId },
                            success: function (data) {
                                $.messager.alert(data.Title, data.Message);

                            },
                            error: function (xhr, textStatus, errorThrown) {
                                //
                                window.location.replace("/login.aspx");
                            }
                        });
                    }
                });

            }
        }
       
        function showDataCarList(type) {

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plaqueValue'] = plaqueValue;
            opts.queryParams['type'] = type;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdLicensingMotorcycleList.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plaqueValue'] = '';
            opts.queryParams['type'] = 2;
            grdLicensingMotorcycleList.datagrid('reload', opts.queryParams);

        }
        
        var licenseOwnerIdInSelectGrid = 0;
        

        $(document).ready(function () {
        //    restrictAccess();
        });

    </script>
</asp:Content>
