﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MotorcycleFacilities.aspx.cs" MasterPageFile="~/MasterPages/MainMaster.Master" Inherits="Baraneh.Web.UI.Baraneh.Motorcycles.MotorcycleFacilities" %>




<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" style="padding: 20px;">
        <div class="title-head">

            <h2>تسهیلات موتور سیکلت</h2>
        </div>


        <div class="main">
            <div id="frmMotorcycleFacilities">
                <div class="col-md-12">
                    <!-- LINE CHART -->
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fa fa-user"></i>ثبت درخواست تسهیلات</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-3 control-label" >انتخاب نوع تسهیلات :</label>
                                        <select required class="col-md-6 easyui-combobox" id="drpFacilities" style="width:100%;">
                                            
                                        </select>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group" style="display: flex;">
                                        <label class="col-md-3 control-label" > توضیحات :</label>
                                          <input readonly   id="txtDescription" class="col-md-4 easyui-textbox" data-options="multiline:true" style="width:100%;height:200px;"  />
                      
                                    </div>
                                </div>

                            </div>


                            <div class="row">

                                <div class="col-md-3"></div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-success" onclick="save()" style="padding-left: 20px; padding-right: 20px;">
                                        ثبت
                                    </button>
                                </div>
                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-user"></i>لیست درخواست ها</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">

                                <div style="margin: 10px 0; height: 500px;">
                                    <table id="grdMotorcycleFacilitiesRequests">
                                        <thead>
                                            <tr>
                                                <th field="ck" checkbox="true"></th>
                                                <th data-options="field:'MotorcycleFacilitiesRequestId', sortable:'true', width:160" hidden="hidden"></th>
                                                <th data-options="field:'Title', sortable:'true', width:160">عنوان</th>
                                                <th data-options="field:'CreateDate', sortable:'true', width:70">تاریخ درخواست</th>
                                                <th data-options="field:'ViewDate', sortable:'true', width:70">تاریخ مشاهده</th>
                                                <th data-options="field:'AcceptedDate', sortable:'true', width:70">تاریخ تایید درخواست</th>
                                                <th data-options="field:'RejectedDate', sortable:'true', width:70">تاریخ رد درخواست</th>
                                            </tr>
                                        </thead>
                                    </table>
                                    <div id="gridtoolbarMotorcycleFacilities" style="padding: 2px 5px;">
                                        <div style="padding: 2px 5px;">
                                                 عنوان یا توضیحات :
                                                <input id="txtSearch" type="text" class="easyui-textbox" />
                                               <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جست و جو </a>
                                        
                                               <a onclick="deleteRecord()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-cancel'">حذف مورد </a>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

        </div>
    </div>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdMotorcycleFacilitiesRequests = $("#grdMotorcycleFacilitiesRequests");
        var globalMotorcycleFacilities;

        const deleteRecord=function () {


            var row = grdMotorcycleFacilitiesRequests.datagrid('getSelected');
            if (!row) {
                $.messager.alert('پیغام',"لطفا ابتدا  رکورد مورد نظر را انتخاب کنید");

                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/DeleteRequest',
                type: 'Post',
                contentType: 'application/json',
                data: JSON.stringify( row.MotorcycleFacilitiesRequestId),
                success: function (data)
                {
                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful == true) {
                            grdMotorcycleFacilitiesRequests.datagrid('reload');
                        }
                        $.messager.alert('پیغام', data.Message);
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                }
            });

        }

        const searchCarListOnDB = function () {

            var opts = grdMotorcycleFacilitiesRequests.datagrid('options');
            opts.isBindOnLoad = true;
            var query = $('#txtSearch').textbox('getValue');
            opts.queryParams['query'] = query 
            grdMotorcycleFacilitiesRequests.datagrid('reload', opts.queryParams);
        }

        const initGlobalObjects = function (callback) {

            $.messager.progress({ title: 'لطفا صبر کنید...' });
            $.ajax({
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetAll?query&isActive=true',
                type: 'get',
                contentType: 'application/json',
                success: function (data) {
                    $.messager.progress('close');
                    globalMotorcycleFacilities = data;
                    if (typeof callback === "function") callback();
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                }
            });
        }
        const save = function () {


            if (!$('#frmMotorcycleFacilities').form('validate')) {
                $.messager.alert('اخطار', 'لطفا ابتدا تسهیلات مورد نظر را انتخاب کنید', 'اخطار');
                return;
            }

            var facilitiesId = $('#drpFacilities').combobox("getValue");

            $.messager.progress({ title: 'لطفا صبر کنید...' });
            $.ajax({
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/SaveRequest',
                type: 'post',
                contentType: 'application/json',
                data: JSON.stringify(  facilitiesId ),
                success: function (data) {
                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful == true) {
                            grdMotorcycleFacilitiesRequests.datagrid('reload');
                        }
                        $.messager.alert('پیغام',data.Message);
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                }
            });
        }




        $(document).ready(() => {
           grdMotorcycleFacilitiesRequests.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: true,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                // rownumbers: true,
                // loadMsg: 'صبر کنید - درحال بارگذرای',
                // isBindOnLoad: true,
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetCurrentUserRequests',
                sortName: 'CreateDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarMotorcycleFacilities',
                height: $(window).height() - 160,
                queryParams: {
                    query: ""
                },
                onSelect: function (e) {
                    // ...existing code...
                }
            });
            initGlobalObjects();
            $('#drpFacilities').combobox({ 
                method: 'get',
                url: '/DesktopModules/MotorcycleProxy/API/MotorcycleFacilities/GetAll?query&isActive=true',
                valueField: 'MotorcycleFacilitiesId',
                textField: 'Title',
                multiple: false,
                onChange: function (data) {
                    if (globalMotorcycleFacilities) {
                           let current = globalMotorcycleFacilities.find(x => x.MotorcycleFacilitiesId == data);
                           $("#txtDescription").textbox("setValue", current.Description);
                    } 
                    else {
                            initGlobalObjects(function () {
                            let current = globalMotorcycleFacilities.find(x => x.MotorcycleFacilitiesId == data);
                            $("#txtDescription").textbox("setValue", current.Description);
                        });
                    }
                }
            });
        });
 


       

    </script>
</asp:Content>
