﻿<%@ Page Async="true" Language="C#" MasterPageFile="~/MasterPages/SinglePage.Master" AutoEventWireup="true" CodeBehind="WalletVerifyPage.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Financial.WalletVerifyPage" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        .login-container {
            width: 95%;
            max-width: 600px;
            margin: 0 auto;
            padding: 2rem 0;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .login-container {
                width: 90%;
                min-width: 280px;
            }
        }
        
        .card {
            border: none;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
            border-radius: 15px;
            overflow: hidden;
            transition: transform 0.2s;
        }
        
        .card-header {
            background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
            border: none;
            padding: 1.5rem;
        }
        
        .card-header h3 {
            color: white;
            font-size: 1.5rem;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .card-body {
            padding: 2rem;
            background-color: #fff;
        }
        
        .info-container {
            margin-bottom: 1.5rem;
        }
        
        .info-row {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            transition: all 0.2s ease;
        }
        
        .info-row:hover {
            background-color: #f1f8ff;
            transform: translateX(-5px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .info-label {
            font-weight: bold;
            color: #495057;
            margin-left: 10px;
            min-width: 120px;
        }
        
        .info-value {
            color: #212529;
            flex-grow: 1;
            font-family: 'Vazirmatn';
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 0.6rem 1.2rem;
            transition: all 0.3s ease;
            display: block;
            width: 100%;
            margin-top: 1.5rem;
            text-align: center;
            text-decoration: none;
        }
        
        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
            color: white;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }
        
        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            text-decoration: none;
            color: white;
        }
        
        .btn-success:active {
            transform: translateY(0);
        }
        
        .notice-text {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1rem 0;
            font-size: 0.95rem;
            color: #856404;
            background-color: #fff3cd;
            text-align: center;
        }
        
        .icon {
            color: #0093E9;
            font-size: 1.1rem;
            margin-left: 10px;
        }
        
        .status-icon {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .status-icon i {
            font-size: 48px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
        
        /* Enhanced mobile responsiveness */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            
            .info-row {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .info-label {
                margin-bottom: 5px;
                width: 100%;
            }
        }
    </style>

    
        <div class="login-container">
            <div class="card card-info">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fa fa-credit-card"></i>
                        نتیجه تراکنش مالی
                    </h3>
                </div>
                
                <div class="card-body">
                    <!-- Status Icon - will be displayed based on transaction status -->
                    <div class="status-icon">
                        <i class="fa fa-check-circle" style="color: #28a745;"></i>
                    </div>
                    
                    <div class="info-container">
                        <!-- Message -->
                        <div class="info-row">
                            <div class="info-label">
                                <i class="fa fa-comment icon"></i>
                                پیغام:
                            </div>
                            <div class="info-value" id="message" runat="server"></div>
                        </div>
                        
                        <!-- Transaction Code -->
                        <div class="info-row">
                            <div class="info-label">
                                <i class="fa fa-barcode icon"></i>
                                کد تراکنش:
                            </div>
                            <div class="info-value" id="TransactionCode" runat="server"></div>
                        </div>
                        
                        <!-- Reference Code -->
                        <div class="info-row">
                            <div class="info-label">
                                <i class="fa fa-tag icon"></i>
                                کد پیگیری:
                            </div>
                            <div class="info-value" id="referenceCode" runat="server"></div>
                        </div>
                    </div>
                    
                    <!-- Notice Text (if needed) -->
                    <div class="notice-text" id="paragraph" runat="server" style="display:none;">
                        <!-- Any warning or notice message will appear here -->
                    </div>
                    
                    <!-- Back Button -->
                    <a href="TransactionList.aspx" class="btn btn-success">
                        <i class="fa fa-arrow-circle-right"></i>
                        بازگشت به سامانه
                    </a>
                </div>
            </div>
        </div>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
        $(document).ready(function() {
            // Fade in effect for the card
            $('.card').hide().fadeIn(800);
            
            // Check message content to determine success/failure
            const messageText = $('#<%=message.ClientID%>').text().trim().toLowerCase();
            
            // Show paragraph element if it has content
            if ($('#<%=paragraph.ClientID%>').text().trim().length > 0) {
                $('#<%=paragraph.ClientID%>').show();
            }
            
            // Change icon based on transaction result
            if (messageText.includes('موفق') || messageText.includes('success')) {
                $('.status-icon i').removeClass('fa-times-circle').addClass('fa-check-circle').css('color', '#28a745');
            } else if (messageText.includes('ناموفق') || messageText.includes('fail') || messageText.includes('error')) {
                $('.status-icon i').removeClass('fa-check-circle').addClass('fa-times-circle').css('color', '#dc3545');
            }
        });
    </script>
</asp:Content>

