﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="Wallet.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Financial.Wallet" %>


<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    
    <style>
        .btn-amount {
            font-family: 'addad';
            font-size: 14px !important;
            margin-bottom: 10px;
            width: 100%;
            white-space: normal;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .btn-amount h3 {
            margin: 0;
            padding: 10px 5px;
        }

        #amount {
            font-family: 'addad' !important;
        }
        
        .amount-buttons {
            display: flex;
            flex-wrap: wrap;
        }
        
        .amount-buttons .button-col {
            padding: 5px;
            margin-bottom: 10px;
        }
        
        .button-row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -5px;
        }
        
        .button-row:first-child {
            margin-bottom: 10px;
        }
        
        .button-row:last-child {
            margin-top: 5px;
        }
        
        @media (max-width: 768px) {
            .btn-amount h3 {
                font-size: 14px;
            }
            
            .card-body {
                padding: 10px;
            }
            
            .content-wrapper {
                padding: 10px !important;
            }
        }
        
        @media (max-width: 576px) {
            .button-col {
                height: 60px;
            }
            
            .btn-amount h3 {
                font-size: 12px !important;
            }
        }
        
        #amount-text {
            font-size: 14px;
            color: #6c757d;
        }
        
        .warning-text {
            margin-top: 15px;
            font-size: 13px;
        }
    </style>

    <div class="content-wrapper" style="padding: 20px;">
        <div class="main">
            <div class="col-md-12 px-0">
                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-check-square-o"></i>شارژ کیف پول </h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="announce" runat="server"></div>

                        <div class="alert alert-light">
                            <!-- First row of buttons -->
                            <div class="button-row">
                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(200000)" id="btn-amount1" class="btn btn-default btn-amount">
                                        <h3>200,000 ریال</h3>
                                    </button>
                                </div>

                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(500000)" id="btn-amount2" class="btn btn-default btn-amount">
                                        <h3>500,000 ریال</h3>
                                    </button>
                                </div>

                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(1000000)" id="btn-amount3" class="btn btn-default btn-amount">
                                        <h3>1,000,000 ریال</h3>
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Second row of buttons -->
                            <div class="button-row">
                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(1500000)" id="btn-amount4" class="btn btn-default btn-amount">
                                        <h3>1,500,000 ریال</h3>
                                    </button>
                                </div>

                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(2000000)" id="btn-amount5" class="btn btn-default btn-amount">
                                        <h3>2,000,000 ریال</h3>
                                    </button>
                                </div>

                                <div class="col-4 button-col">
                                    <button type="button" onclick="setAmount(3000000)" id="btn-amount6" class="btn btn-default btn-amount">
                                        <h3>3,000,000 ریال</h3>
                                    </button>
                                </div>
                            </div>

                            <input type="hidden" id="token" name="token" />
                            <input type="hidden" id="merchantId" name="merchantId" />

                            <div class="col-sm-12 my-3 px-0">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">مبلغ (ریال)</div>
                                    </div>
                                    <input type="text" class="form-control" id="amount" placeholder="مبلغ دلخواه را وارد کنید">
                                </div>
                                <div class="mt-2">
                                    <label id="amount-text"></label>
                                </div>
                                <div class="input-group mt-3">
                                    <button class="btn btn-success btn-lg" onclick="doPay()" style="width: 100%" type="button">
                                        پرداخت
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-12 text-center warning-text" style="color:red !important">
                                شهروند گرامی ، بنا به سیاستهای بانکهای مختلف ، پیشنهاد می گردد ، مبلغ انتخابی خود را بیش از  ( پنجاه هزار ریال ) انتخاب نمایید.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var isValidBrowser = true;


        var delimiter = " و ", zero = "صفر", negative = "منفی ", letters = [["", "یک", "دو", "سه", "چهار", "پنج", "شش", "هفت", "هشت", "نه"], ["ده", "یازده", "دوازده", "سیزده", "چهارده", "پانزده", "شانزده", "هفده", "هجده", "نوزده", "بیست"], ["", "", "بیست", "سی", "چهل", "پنجاه", "شصت", "هفتاد", "هشتاد", "نود"], ["", "یکصد", "دویست", "سیصد", "چهارصد", "پانصد", "ششصد", "هفتصد", "هشتصد", "نهصد"], ["", " هزار", " میلیون", " میلیارد", " بیلیون", " بیلیارد", " تریلیون", " تریلیارد", " کوآدریلیون", " کادریلیارد", " کوینتیلیون", " کوانتینیارد", " سکستیلیون", " سکستیلیارد", " سپتیلیون", " سپتیلیارد", " اکتیلیون", " اکتیلیارد", " نانیلیون", " نانیلیارد", " دسیلیون", " دسیلیارد"]], decimalSuffixes = ["", "دهم", "صدم", "هزارم", "ده‌هزارم", "صد‌هزارم", "میلیونوم", "ده‌میلیونوم", "صدمیلیونوم", "میلیاردم", "ده‌میلیاردم", "صد‌‌میلیاردم"], prepareNumber = function (e) { var t = e; return "number" == typeof t && (t = t.toString()), t.length % 3 == 1 ? t = "00".concat(t) : t.length % 3 == 2 && (t = "0".concat(t)), t.replace(/\d{3}(?=\d)/g, "$&*").split("*") }, tinyNumToWord = function (e) { if (0 === parseInt(e, 0)) return ""; var t = parseInt(e, 0); if (t < 10) return letters[0][t]; if (t <= 20) return letters[1][t - 10]; if (t < 100) { var r = t % 10, n = (t - r) / 10; return r > 0 ? letters[2][n] + delimiter + letters[0][r] : letters[2][n] } var i = t % 10, u = (t - t % 100) / 100, s = (t - (100 * u + i)) / 10, a = [letters[3][u]], o = 10 * s + i; return 0 === o ? a.join(delimiter) : (o < 10 ? a.push(letters[0][o]) : o <= 20 ? a.push(letters[1][o - 10]) : (a.push(letters[2][s]), i > 0 && a.push(letters[0][i])), a.join(delimiter)) }, convertDecimalPart = function (e) { return "" === (e = e.replace(/0*$/, "")) ? "" : (e.length > 11 && (e = e.substr(0, 11)), " ممیز " + Num2persian(e) + " " + decimalSuffixes[e.length]) }, Num2persian = function (e) { e = e.toString().replace(/[^0-9.-]/g, ""); var t = !1, r = parseFloat(e); if (isNaN(r)) return zero; if (0 === r) return zero; r < 0 && (t = !0, e = e.replace(/-/g, "")); var n = "", i = e, u = e.indexOf("."); if (u > -1 && (i = e.substring(0, u), n = e.substring(u + 1, e.length)), i.length > 66) return "خارج از محدوده"; for (var s = prepareNumber(i), a = [], o = 0; o < s.length; o += 1) { var l = tinyNumToWord(s[o]); "" !== l && a.push(l + letters[4][s.length - (o + 1)]) } return n.length > 0 && (n = convertDecimalPart(n)), (t ? negative : "") + a.join(delimiter) + n }; String.prototype.toPersianLetter = function () { return Num2persian(this) }, Number.prototype.toPersianLetter = function () { return Num2persian(parseFloat(this).toString()) }, String.prototype.num2persian = function () { return Num2persian(this) }, Number.prototype.num2persian = function () { return Num2persian(parseFloat(this).toString()) };

        document.getElementById('amount').addEventListener('input', event => {

            event.target.value = (parseInt(event.target.value.replace(/[^\d]+/gi, '')) || 0).toLocaleString('en-US');
            var x = document.getElementById("amount").value;
            x = x.split(',').join('')
            document.getElementById("amount-text").innerHTML = x.num2persian() + ' ' + 'ریال';
        });

        function CurrentLocalUserCallBack() {
            $("#currentAmount").html(` موجودی نقدی  : ${CurrentLocalUser.balance} ريال`);
        }
        function post(params, path) {
            var method = 'post';
            // The rest of this code assumes you are not using a library.
            // It can be made less wordy if you use one.
            const form = document.createElement('form');
            form.method = method;
            form.action = path;

            for (const key in params) {
                if (params.hasOwnProperty(key)) {
                    const hiddenField = document.createElement('input');
                    hiddenField.type = 'hidden';
                    hiddenField.name = key;
                    hiddenField.value = params[key];

                    form.appendChild(hiddenField);
                }
            }

            document.body.appendChild(form);
            form.submit();
        }

        function setAmount(val) {
            $("#amount").val(val.toLocaleString('en-US'));
            var element = document.getElementById("amount");
            element.dispatchEvent(new Event('input', { bubbles: true }));
        }

        function doPay() {
            //if (!isValidBrowser) {
            //    $.messager.alert('پیام سیستم', 'لطفا جهت شارژ حساب فقط از مرورگر فایرفاکس استفاده کنید ', 'info');
            //    return;
            //}
            var amount = $("#amount").val();
            amount = amount.split(',').join('')
            if (amount == "") {
                $.messager.alert('پیام سیستم', 'ابتدا مبلغ مورد نظر را وارد کنید ', 'info');
                return;
            }
            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/Payment/API/Ipg/PayByIpg',
                data: JSON.stringify(amount),
                method: 'post',
                contentType: 'application/json',
                success: function (data) {

                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful) {
                            if (data.Message.includes("redirect")) {
                                window.location.replace(data.ReturnValue);
                            }
                            else {
                                var formContainer = document.createElement('div');
                                formContainer.innerHTML = data.ReturnValue;
                                document.body.appendChild(formContainer);
                                formContainer.querySelector('form').submit();
                            }

                        }
                        else {
                            $.messager.alert('پیام سیستم', data.Message, 'info');
                        }
                    } else {
                        $.messager.alert('پیام سیستم', 'خطای سمت سرور پیش آمده', 'info');

                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    $.messager.progress('close');
                    $.messager.alert('پیام سیستم', 'خطای سمت سرور پیش آمده', 'info');
                    //reject(false/*{ xhr, textStatus, errorThrown }*/);
                }

            });
        }

    </script>

</asp:Content>
