﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="DriverVehiclesRequestList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverVehiclesRequestList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <script src="../DesktopModules/Baraneh/CSS/datagrid-export.js"></script>
    <div class="content-wrapper" style="padding: 20px;">
        <div class="title-head">
            <h2>درخواست اشتغال برخودرو</h2>
        </div>
        <div class="main">
            <div id="frmCarEdit">

                <div class="col-md-12">
                    <!-- LINE CHART -->
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fa fa-check-square-o"></i>جست وجو و درخواست خودرو</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">

                            <section class="content">
                                <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">

                                    <table class="table table-hover" id="grdRequests">
                                        <thead>
                                            <tr>
                                                 <th field="ck" checkbox="true"></th>
                                                <th data-options="field:'DriverVehiclesAssignmentsId', sortable:'true', width:0" hidden="hidden"></th>
                                                <th data-options="field:'DriverFullName', sortable:'true', width:0">نام و نام خانوادگی راننده</th>
                                                <th data-options="field:'DriverNationalCode', sortable:'true', width:0">کد ملی </th>
                                                <th data-options="field:'DriverMobileNumber', sortable:'true', width:0">شماره همراه</th>                                                                   
                                                <th data-options="field:'MISPlaque', sortable:'true', width:0">شماره پلاک </th>
                                                <th data-options="field:'VIN', sortable:'true', width:0">VIN </th>
                                                <th data-options="field:'System', sortable:'true', width:160">نام خودرو</th>
                                                <th data-options="field:'Color', sortable:'true', width:160">رنگ خودرو</th>
                                                <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ ثبت</th>
                                                <th data-options="field:'AcceptedDate', sortable:'true', width:160">تاریخ تایید</th>
                                                <th data-options="field:'RejectedDate', sortable:'true', width:160">تاریخ عدم تایید</th>
                                                <%--<th data-options="field:'RequestState', sortable:'true', width:160">وضعیت</th>--%>
                                            </tr>
                                        </thead>
                                    </table>
                                    <div id="grdRequeststoolbar" style="padding: 2px 5px;">
                                        <div style="padding: 2px 5px;">
                                            <a href="#" class="easyui-linkbutton responsives" onclick="deleteRequest()" iconcls="icon-cancel">حذف درخواست</a>
                                            <a href="#" class="easyui-linkbutton responsives" onclick="acceptRequest()" iconcls="icon-ok">تایید  </a>
                                            <a href="#" class="easyui-linkbutton responsives" onclick="rejectRequest()" iconcls="icon-close">عدم تایید</a>
                                        </div>
                                    </div>
                                </div>
                            </section>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>


   var grdRequests=$("#grdRequests");





   $(document).ready(function(){

    grdRequests.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url:'/CoreServices/API/Driver/GetCurrentUserDriverVehicleRequests',
                // rownumbers: true,
                sortName: 'CreateDate',
                sortOrder: 'desc',
                toolbar: '#grdRequeststoolbar',
                height: $(window).height() - 160,
                queryParams: {
                 plateNo: ''
               }
            });

      });





           function deleteRequest()
               {

       var row = grdRequests.datagrid('getSelected');
           
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

          $.ajax({
                url: '/CoreServices/API/Driver/DeleteDriverVehicleRequest?driverVehiclesAssignmentsId='+row.DriverVehiclesAssignmentsId+'&isOwner=true',
                type: 'post', 
                contentType: 'application/json',
                data:{}, 
                dataType:'json',
                success: function (data) {
                    $.messager.progress('close');
                    if (data)  
                    {
 
                     $("#txtName").textbox("setValue",'');
                     $("#txtColor").textbox("setValue",'');     
                     $.messager.alert('پیغام ', data.Message, 'info');    
                   grdRequests.datagrid('reload');                 
                    }else
                    {
               $.messager.alert('پیغام ', 'موردی یافت نشد', 'info');                         
                    }
                },
                error: function (xhr, response, txt) {

                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');

                }
            });  
                 }});

               }


              function acceptRequest()
               {

                 var row = grdRequests.datagrid('getSelected');
           
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.confirm('Confirm', 'آیا برای تایید اطمینان دارید؟', function (r) {
                if (r) {
          $.ajax({
                url: '/CoreServices/API/Driver/AcceptDriverVehicleRequest?driverVehiclesAssignmentsId='+row.DriverVehiclesAssignmentsId,
                type: 'post', 
                contentType: 'application/json',
                data:{}, 
                dataType:'json',
                success: function (data) {
                    $.messager.progress('close');
                    if (data)  
                    {
 
                  $("#txtName").textbox("setValue",'');
                  $("#txtColor").textbox("setValue",'');     
                  $.messager.alert('پیغام ', data.Message, 'info');    
                   grdRequests.datagrid('reload');                 
                    }else
                    {
               $.messager.alert('پیغام ', 'موردی یافت نشد', 'info');                         
                    }
                },
                error: function (xhr, response, txt) {

                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');

                }
            });  
            }});

           }


              function rejectRequest()
               {

       var row = grdRequests.datagrid('getSelected');
           
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.confirm('Confirm', 'آیا برای عدم تایید اطمینان دارید؟', function (r) {
                if (r) {
          $.ajax({
                url: '/CoreServices/API/Driver/RejectDriverVehicleRequest?driverVehiclesAssignmentsId='+row.DriverVehiclesAssignmentsId,
                type: 'post', 
                contentType: 'application/json',
                data:{}, 
                dataType:'json',
                success: function (data) {
                    $.messager.progress('close');
                    if (data)  
                    {
 
                  $("#txtName").textbox("setValue",'');
                  $("#txtColor").textbox("setValue",'');     
                  $.messager.alert('پیغام ', data.Message, 'info');    
                   grdRequests.datagrid('reload');                 
                    }else
                    {
               $.messager.alert('پیغام ', 'موردی یافت نشد', 'info');                         
                    }
                },
                error: function (xhr, response, txt) {

                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');

                }
            });  
           }});

            }

    </script>
</asp:Content>
