﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="DriverVehiclesOwners.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverOwners" %>
 
 
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

       <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست رانندگان  </h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست رانندگان '">
                    <table id="grdMain">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'DriverId', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'FullName', sortable:'true', width:160">نام و نام خانوادگی</th>
                                <th data-options="field:'NationalCode', sortable:'true', width:160">کد ملی </th>
                                <th data-options="field:'Mobile', sortable:'true', width:160">شماره همراه</th> 
                                <th data-options="field:'BirthDate', sortable:'true', width:160">تاریخ تولد</th>
                                <th data-options="field:'DrivingLicenseNumber', sortable:'true', width:160">شماره کواهی نامه </th>
                              
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarDriverLicensingList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">

                        <%--    <a onclick="addNew()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-add'">افزودن</a>
                       <%--        <a onclick="display()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display edit'"> نمایش جزئیات </a>--%>
                        

                            <input  id="searchValue" type="text" class="easyui-textbox arz" data-options="label:'کدملی ، شماره همراه ، نام ونام خانوادگی  :'" Style="max-width:300px;">
                            <a onclick="search()" id="btnSearch" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">


    <script>
        var grdMain = $("#grdMain");
        document.getElementById("btnSearch").addEventListener("click", () => { search() });
        function search()
        {
            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;
            var searchValue = $("#searchValue").textbox("getValue");
            opts.queryParams['searchValue'] = searchValue;
            grdMain.datagrid('reload', opts.queryParams);
        }

        const licenseStatus = function (val) {
            
            return { 1: 'در دست بررسی', 2: 'تایید شده', 3: 'رد شده', 5: 'حذف شده' }[val];
        }

        function display()
        {
            var row = grdMain.datagrid("getSelected");

            if (!row) {
                $.messager.alert('خطا', 'ابتدا راننده  مورد نظر را انتخاب کنید');
                return;
            }

            var displayWin = window.open("/Baraneh/DriverVehiclesAssignment.aspx?");
            displayWin.window.NationalCode = row.NationalCode;
        }


        function CarList_clearFilter() {

            $('#searchValue').textbox('clear');
 

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['searchValue'] = '';
            grdMain.datagrid('reload', opts.queryParams);

        }

        $(document).ready(() => {
            grdMain.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Driver/GetDriverByCurrentVehiclesOwner',
                // rownumbers: true,
                sortName: 'FullName',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDriverLicensingList',
                height: $(window).height() - 160,
                onClickRow: function () {
                    // globalCurrentRow = grdLicensingList.datagrid("getSelected")
                },
                queryParams: {
                    searchValue: ""
                }
            });
        });

    </script>


</asp:Content>