﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="DriverVehiclesAssignment.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverVehiclesAssignment" %>


<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        #NationalCodeUserName + span {
            width: 100% !important;
        }
    </style>
    <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">انتخاب راننده </h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: auto; width: 100%;">

                <div class="card card-info bgrd" id="DriverInformation">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-user"></i>&nbsp;&nbsp;   مشخصات راننده </h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div data-options="region:'center',title:'مشخصات راننده'">
                            <div id="frmDriver">
                                <div class="container" style="margin-top: 20px;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="Name">کد ملی یا نام کاربری راننده : </label>
                                                <input id="NationalCodeUserName" type="text" class="easyui-textbox arz" placeholder="کد ملی یا  نام کاربری راننده" />

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">

                                                <button type="button" class="btn  btn-success" onclick="checkDriver()">
                                                    <i class="fa fa-refresh"></i>
                                                    استعلام راننده 
                                                </button>
                                            </div>
                                        </div>
                                    </div>


                                    <%--<div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="CurrentDriverUserName">نام کاربری راننده : </label>
                                                <input readonly id="CurrentDriverUserName" class="easyui-textbox arz">
                                            </div>
                                        </div>
                                    </div>--%>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="Name">نام : </label>
                                                <input readonly id="Name" class="easyui-textbox arz">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="Family">نام خانوادگی :</label>
                                                <input readonly id="Family" class="easyui-textbox arz">
                                            </div>
                                        </div>
                                    </div>
                                    
                                   <%-- <div class="row">



                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="Certificate">نوع گواهی نامه: </label>
                                                <select readonly class="easyui-combobox arz" id="Certificate">
                                                    <option value="CertificateP1" >دارای گواهینامه پایه 1</option>
                                                    <option value="CertificateP2" >دارای گواهینامه پایه 2</option>
                                                    <option value="CertificateP3" >دارای گواهینامه پایه 3</option>
                                                    <option value="CertificateVIP" >دارای گواهینامه پایه ویژه</option>
                                                </select>

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="DriverLicensingNumber">شماره گواهی نامه: </label>
                                                <input readonly id="DriverLicensingNumber" class="easyui-textbox arz">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">



                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="DrivingLicenseValidationPeriodId">اعتبار گواهینامه : </label>
                                                <select readonly class="easyui-combobox" id="DrivingLicenseValidationPeriodId">
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">



                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="InsuranceType">نوع بیمه : </label>
                                                <select readonly class="easyui-combobox" id="InsuranceType">
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="InsuranceNumber ">شماره بیمه : </label>
                                                <input readonly class="easyui-textbox arz textbox-f" id="InsuranceNumber" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="BirthPlaceStateId">استان محل تولد :</label>
                                                <input readonly id="BirthPlaceStateId" class="easyui-combobox">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group" style="display: flex;">
                                                <label class="col-md-5 control-label" for="BirthPlaceCityId">شهر محل تولد :</label>
                                                <input readonly id="BirthPlaceCityId" class="easyui-combobox">
                                            </div>
                                        </div>
                                    </div>--%>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card card-info bgrd" id="">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>&nbsp;&nbsp; انتخاب خودرو </h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div data-options="region:'center',title:'لیست ناوگان و پروانه های صادر شده'">
                            <div style="height: 400px;">


                                <table id="grdMain" style="width: 100%; height: 300px">
                                    <thead>
                                        <tr>
                                            <th field="ck" checkbox="true"></th>
                                            <th data-options="field:'VehicleGUID', sortable:'true', width:160" hidden="hidden"></th>
                                            <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                                            <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                                            <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                                            <th data-options="field:'StyleTip', sortable:'true', width:160">استایل</th>
                                            <th data-options="field:'OwnerName', sortable:'true', width:160">مالک</th>
                                        </tr>
                                    </thead>
                                </table>
                                <div id="gridtoolbarDriverLicensingList" style="padding: 2px 5px;">
                                    <div style="padding: 2px 5px;">
                                        <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                                        <span>ایران</span>
                                        <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                                        <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'60px'">
                                            <option value="-1" selected="selected"></option>
                                            <option value="01">الف</option>
                                            <option value="02">ب</option>
                                            <option value="04">ت</option>
                                            <option value="06">ج</option>
                                            <option value="07">چ-ژ</option>
                                            <option value="10">د</option>
                                            <option value="15">س</option>
                                            <option value="17">ص</option>
                                            <option value="19">ط</option>
                                            <option value="21">ع</option>
                                            <option value="24">ق</option>
                                            <option value="27">ل</option>
                                            <option value="28">م</option>
                                            <option value="29">ن</option>
                                            <option value="30">و</option>
                                            <option value="31">هـ</option>
                                            <option value="32">ی</option>
                                            <option value="33">D</option>
                                            <option value="34">S</option>
                                        </select>
                                        <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">

                                        <a onclick="searchVehicles()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو </a>
                                        <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="cpl-md-12" style="text-align: center; width: 100%;">
                    <button onclick="save()" type="button" class="btn  btn-success">
                        ذخیره
                    </button>

                </div>

            </div>
        </section>
        <!-- /.content -->

    </div>


</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var grdMain = $("#grdMain");
        var existDriverInformation = null;
        var globalCityId = null;
        var currentGlobalVehicleIds = null;
        

        function initDriver() {
            if (typeof window.NationalCode != 'object') {
                $("#NationalCodeUserName").textbox("setValue", window.NationalCode);
                checkDriver();
            }
        }
        function checkDriver() {
         
            var model = $("#NationalCodeUserName").textbox("getValue");
            $.messager.progress({ title: 'لطفا صبر کنید...' });
            $.ajax({
                url: '/CoreServices/API/Driver/GetDriverByUserNameOrNationalCode',
                type: 'Post',
                data: JSON.stringify(model),
                contentType: 'application/json',
                //processData: false,
                success: function (data) {

                    $.messager.progress('close');
                    
                    if (data.IsSuccessful) {
                        
                        currentGlobalVehicleIds = JSON.parse(JSON.stringify(data.ReturnValue.vehicleGuids));
                        
                        existDriverInformation = data.ReturnValue.driver;

                        
                        //$("#CurrentDriverUserName").textbox("setValue", data.ReturnValue.driver.UserName);
                        
                        $("#Family").textbox("setValue", data.ReturnValue.driver.Family);
                        $("#Name").textbox("setValue", data.ReturnValue.driver.Name);
                        
                        initDriverVehicles();

                    }
                    else
                    {
                        $.messager.alert('پیغام سیستمی', data.Message, 'info');
                    }
                },
                error: function (xhr, response, textResponse) {
                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');
                }
            });
        }

        $(document).ready(() => {
            //initialStateCity();
            grdMain.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                 singleSelect: false,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [5, 15, 50, 100, 99999],
                url: '/CoreServices/API/Car/CurrentUserVehiclesList',
                // rownumbers: true,
                sortName: 'CreatedDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDriverLicensingList',
                height: 400,
                onLoadSuccess: function () {
                    initDriver();
                },
                queryParams: {
                    plateNo: ""
                }
            });
             
        });
        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = ''; 
            grdMain.datagrid('reload', opts.queryParams);

        }


        

        function searchVehicles() { 

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plateNo'] = plaqueValue; 
            grdMain.datagrid('reload', opts.queryParams);
        }

        function save() {

            if (existDriverInformation == null) {
                $.messager.alert('خطا', 'ابتدا راننده مورد نظر را انتخاب کنید');

                return;
            }

            var allRows = grdMain.datagrid("getRows");
            var selectedRows = grdMain.datagrid("getSelections");

            //if (!selectedRows) {
            //    $.messager.alert('خطا', 'ابتدا خودروهای  مورد نظر را انتخاب کنید');
            //    return;
            //}

            var selectedVehicleGuids = [];
            var vehicleGuids = [];
            
            if (selectedRows) {
                selectedRows.map((item, index) => {
                    selectedVehicleGuids[index] = item.VehicleGUID;
                });
            }
            if (allRows) {
                allRows.map((item, index) => {
                    vehicleGuids[index] = item.VehicleGUID;
                });
            }

            var model = {
                VehicleGuids: vehicleGuids,
                SelectedVehicleGuids:selectedVehicleGuids,
                DriverUserName: existDriverInformation.UserName
            };


            $.ajax({
                url: '/CoreServices/API/Driver/DriverVehiclesAssingment',
                type: 'Post',
                data: JSON.stringify(model),
                contentType: 'application/json',
                //processData: false,
                success: function (data) {
                    //
                    if (data) {
                        $.messager.progress('close');
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                    }
                },
                error: function (xhr, response, textResponse) {
                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', "خطا در اراتباط", 'info');
                }
            });
        }

        function initDriverVehicles() {
            var rows = grdMain.datagrid("getRows");
            var rowsIndex = [];
            if (rows) {
                rows.map((item, index) => {

                    rowsIndex[index] = item.VehicleGUID;
                });
            }
            if (currentGlobalVehicleIds)
                currentGlobalVehicleIds.map((item, counter) => {
                    //
                    var index = rowsIndex.indexOf(item);
                    grdMain.datagrid("checkRow", index);
                });
        }

    </script>
</asp:Content>
