﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="DriverVehicles.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverVehicles" %>

 
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

       <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">لیست خودروهایی که برروی آنها اجازه اشتغال دارید</h1>
                    </div>
                    <!-- /.col -->
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>

        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'لیست خودرو های راننده'">
                    <table id="grdMain">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'DriverId', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'VIN', sortable:'true', width:160">VIN</th>
                                <th data-options="field:'MISPlate', sortable:'true', width:160">شماره پلاک</th>
                                <th data-options="field:'OwnerName', sortable:'true', width:160">مالک</th> 
                                <th data-options="field:'System', sortable:'true', width:160">سیستم</th>
                                <th data-options="field:'style', sortable:'true', width:160">استایل</th>
                                <th data-options="field:'Color', sortable:'true', width:160">رنگ</th> 
                                
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarDriverLicensingList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">

                        <%--    <a onclick="addNew()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-add'">افزودن</a>
                            <a onclick="edit()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display edit'">ویرایش</a>
                           --%>

                             <input tabindex="4" id="txtIranPlateNoCarList" type="text" class="easyui-numberbox" data-options="label:'پلاک :',min:10,max:99,width:'120px'">
                          <span>ایران</span>
                          <input tabindex="3" id="txtThreePlateNoCarList" type="text" class="easyui-numberbox" data-options="min:10,max:999,width:'40px'">
                            <select tabindex="2" id="drpTwoPlateNoCarList" class="easyui-combobox" data-options="width:'40px'">
                                <option value="-1" selected="selected"></option>
                                <option value="01">الف</option>
                                <option value="02">ب</option>
                                <option value="04">ت</option>
                                <option value="06">ج</option>
                                <option value="07">چ-ژ</option>
                                <option value="10">د</option>
                                <option value="15">س</option>
                                <option value="17">ص</option>
                                <option value="19">ط</option>
                                <option value="21">ع</option>
                                <option value="24">ق</option>
                                <option value="27">ل</option>
                                <option value="28">م</option>
                                <option value="29">ن</option>
                                <option value="30">و</option>
                                <option value="31">هـ</option>
                                <option value="32">ی</option>
                                <option value="33">D</option>
                                <option value="34">S</option>
                            </select>
                            <input tabindex="1" type="text" id="txtOnePlateNoCarList" class="easyui-numberbox" data-options="min:10,max:99,width:'40px'">
                            
                           
                            <a onclick="searchVehicles()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو </a>
                            <a onclick="CarList_clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">


    <script>
        var grdMain = $("#grdMain");

        function CarList_clearFilter() {

            $('#txtOnePlateNoCarList').textbox('clear');
            $('#txtThreePlateNoCarList').textbox('clear');
            $('#txtIranPlateNoCarList').textbox('clear');
            $('#drpTwoPlateNoCarList').combobox('reset');
            //$('#drpTwoPlateNo').combobox('unselect', value);

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            opts.queryParams['plateNo'] = '';
            grdMain.datagrid('reload', opts.queryParams);

        }

        function getPlateNo(txtOnePlateNoId, drpTwoPlateNoId, txtThreePlateNoId, txtIranPlateNoId) {

            var onePlateNo = Math.floor($('#' + txtOnePlateNoId).val());
            var twoPlateNo = Math.floor($('#' + drpTwoPlateNoId).combobox('getValue'));
            var threePlateNo = Math.floor($('#' + txtThreePlateNoId).val());
            var iranPlateNo = Math.floor($('#' + txtIranPlateNoId).val());

            if (onePlateNo == 0 && twoPlateNo == -1 && threePlateNo == 0 && iranPlateNo == 0) {
                return null;
            }

            var isValidValue = true;

            if (onePlateNo == 0 || (onePlateNo < 10 || onePlateNo > 99))
                isValidValue = false;

            if (twoPlateNo == -1)
                isValidValue = false;

            if (threePlateNo == 0 || (threePlateNo < 10 || threePlateNo > 999))
                isValidValue = false;

            if (iranPlateNo < 10 || iranPlateNo > 99)
                isValidValue = false;

            if (isValidValue == false) {
                $.messager.alert('خطا', 'شماره پلاک خطا دارد');
                return 'error';
            }

            if (twoPlateNo.toString().length == 1)
                twoPlateNo = '0' + twoPlateNo.toString();

            var plaqueValue = onePlateNo.toString() + twoPlateNo.toString() + threePlateNo.toString() + iranPlateNo.toString();

            return plaqueValue;

        }

        function searchVehicles() {

            var opts = grdMain.datagrid('options');
            opts.isBindOnLoad = true;

            plaqueValue = getPlateNo(false,'txtOnePlateNoCarList', 'drpTwoPlateNoCarList', 'txtThreePlateNoCarList', 'txtIranPlateNoCarList');
            if (plaqueValue == 'error')
                return;

            opts.queryParams['plateNo'] = plaqueValue;
            grdMain.datagrid('reload', opts.queryParams);
        }



        $(document).ready(() => {
            grdMain.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Driver/GetAllDriverVehicles',
                // rownumbers: true,
                sortName: 'FullName',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDriverLicensingList',
                height: $(window).height() - 160,
                onClickRow: function () {
                    // globalCurrentRow = grdLicensingList.datagrid("getSelected")
                },
                queryParams: {
                    plateNo: ""
                }
            });
        });

    </script>


</asp:Content>