﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="DriverVehicleRequest.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverVehicleRequest" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

    <div class="content-wrapper" style="padding: 20px;">
        <div class="title-head">
            <h2>درخواست اشتغال برخودرو</h2>
        </div>
        <div class="main">
            <div id="frmCarEdit">

                <div class="col-md-12">
                    <!-- LINE CHART -->
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fa fa-check-square-o"></i>جست وجو و درخواست خودرو</h3>

                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>

                            </div>
                        </div>
                        <div class="card-body">

                            <div>
                                <div style="margin: 10px 0;">
                                    <div class="container d-flex justify-content-center">
                                        <div class="col-md-4 plateContainer ">
                                            <div class="plateItems col-12">
                                                <input tabindex="4" id="txtIranPlateNoCarEdit" class="easyui-numberbox plateP4" required>
                                                <input tabindex="3" id="txtThreePlateNoCarEdit" class="easyui-numberbox plateP3" required>
                                                <select tabindex="2" id="drpTwoPlateNoCarEdit" class="easyui-combobox plateP2" required></select>
                                                <input tabindex="1" id="txtOnePlateNoCarEdit" class="easyui-numberbox plateP1" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="container d-flex justify-content-center" style="margin-top: 10px">
                                        <div class="col-4">
                                            <button type="button" id="btnGetVinVoucherEdit" onclick="validatePlate()"
                                                class="btn btn-3d btn-secondary col-12">
                                                انتخاب خودرو واعتبار سنجی
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="row" style="justify-content: center;">
                                    <fieldset style="border: 1px dotted; padding: 5px;">
                                        <legend style="width: auto;">مشخصات خودرو</legend>

                                        <div class="container-fluid">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group" style="display: flex;">
                                                        <label class="col-md-5 control-label">نام خودرو:</label>
                                                        <input readonly id="txtName" class="easyui-textbox ">
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group" style="display: flex;">
                                                        <label class="col-md-5 control-label">رنگ:</label>
                                                        <input readonly id="txtColor" class="easyui-textbox ">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="form-group" style="display: flex;">
                                    <label class="col-md-4 control-label"></label>
                                    <div class="col-md-4" style="display: flex;">

                                        <button type="button" id="btnSave" onclick="save()"
                                            class="easyui-linkbutton c6 btn btn-3d btn-success mr-xs mb-sm col-md-12" style="width: 110px; color: #000; margin-top: 16px; font-weight: bold; font-size: 14px;">
                                            ثبت
                                        </button>
                                    </div>
                                </div>

                                <!-- /.card-body -->
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <!-- LINE CHART -->
                        <div class="card card-info bgrd">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fa fa-check-square-o"></i>لیست درخواست ها</h3>

                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-widget="collapse">
                                        <i class="fa fa-minus"></i>
                                    </button>

                                </div>
                            </div>
                            <div class="card-body">
                                <section class="content">
                                    <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">

                                        <table class="table table-hover" id="grdRequests">
                                            <thead>
                                                <tr>
                                                    <th field="ck" checkbox="true"></th>
                                                    <th data-options="field:'DriverVehiclesAssignmentsId', sortable:'true', width:0" hidden="hidden"></th>
                                                    <th data-options="field:'MISPlaque', sortable:'true', width:0">شماره پلاک </th>
                                                    <th data-options="field:'System', sortable:'true', width:160">نام خودرو</th>
                                                    <th data-options="field:'Color', sortable:'true', width:160">رنگ خودرو</th>

                                                    <th data-options="field:'CreateDate', sortable:'true', width:160">تاریخ ثبت</th>
                                                    <th data-options="field:'AcceptedDate', sortable:'true', width:160">تاریخ تایید</th>
                                                    <th data-options="field:'RejectedDate', sortable:'true', width:160">تاریخ عدم تایید</th>
                                                    <th data-options="field:'RequestState', sortable:'true', width:160">وضعیت</th>
                                                </tr>
                                            </thead>
                                        </table>
                                        <div id="grdRequeststoolbar" style="padding: 2px 5px;">
                                            <div style="padding: 2px 5px;">
                                                <%--<a onclick="saveVehicleItemCarList()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">درخواست شرکت</a>--%>
                                                <a href="#" class="easyui-linkbutton responsives" onclick="deleteVehicle()" iconcls="icon-cancel">حذف درخواست</a>
                                                <!--  <input id="txtCode" class="easyui-textbox" style="width:150px;height:25px " data-options="label:'نام شرکت:'">-->
                                                <!-- <a onclick="showDataCarList(2)" class="easyui-linkbutton" data-options="region:'center',iconCls:''">نمایش درخواست های جابجایی</a>-->
                                            </div>
                                        </div>

                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>

        var globalVehicle = null;
        var grdRequests = $("#grdRequests");

        function validatePlate() {


            var plate = getPlateNo(false, 'txtOnePlateNoCarEdit', 'drpTwoPlateNoCarEdit', 'txtThreePlateNoCarEdit', 'txtIranPlateNoCarEdit');


            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Car/InquiryPlateVinInfoWithNAC_ByPlate?plateNo=' + plate,
                type: 'Get',
                contentType: 'application/json',
                success: function (data) {
                    $.messager.progress('close');
                    if (data) {
                        if (data.IsSuccessful) {

                            globalVehicle = data.ReturnValue;
                            $("#txtName").textbox("setValue", globalVehicle.System + ' ' + globalVehicle.StyleTip);
                            $("#txtColor").textbox("setValue", globalVehicle.Color);
                        }
                        else {
                            $.messager.alert('پیغام ', data.Message, 'info');
                        }
                    }
                },
                error: function (xhr, response, txt) {

                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', txt, 'info');
                }
            });

        }

        function save() {

            if (globalVehicle == null) {
                $.messager.alert('اخطار', 'ابتدا خودرو مورد نظر را انتخاب کنید', 'اخطار');
                return;
            }


            $.ajax({
                url: '/CoreServices/API/Driver/SaveDriverVehicleRequst',
                type: 'post',
                contentType: 'application/json',
                data: JSON.stringify( globalVehicle.VehicleGUID ) ,
                dataType: 'json',
                success: function (data) {
                    $.messager.progress('close');
                    if (data) {

                        //$("#txtName").textbox("setValue",'');
                        // $("#txtColor").textbox("setValue",'');     
                        $.messager.alert('پیغام ', data.Message, 'info');
                        grdRequests.datagrid('reload');
                    } else {
                        $.messager.alert('پیغام ', 'موردی یافت نشد', 'info');
                    }
                },
                error: function (xhr, response, txt) {

                    $.messager.progress('close');
                    $.messager.alert('پیغام سیستمی', txt, 'info');

                }
            });
        }

        $(document).ready(function () {

            grdRequests.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Driver/GetCurrentDriverVehicleRequests',
                // rownumbers: true,
                sortName: 'CreateDate',
                sortOrder: 'desc',
                toolbar: '#grdRequeststoolbar',
                height: $(window).height() - 160,
                queryParams: {
                    plateNo: ''
                }
            });
        });





        function deleteVehicle() {

            var row = grdRequests.datagrid('getSelected');

            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {


                    $.ajax({
                        url: '/CoreServices/API/Driver/DeleteDriverVehicleRequest?driverVehicleRequestId=' + row.DriverVehiclesAssignmentsId,
                        type: 'post',
                        contentType: 'application/json',
                        data: {},
                        dataType: 'json',
                        success: function (data) {
                            $.messager.progress('close');
                            if (data) {

                                $("#txtName").textbox("setValue", '');
                                $("#txtColor").textbox("setValue", '');
                                $.messager.alert('پیغام ', data.Message, 'info');
                                grdRequests.datagrid('reload');
                            } else {
                                $.messager.alert('پیغام ', 'موردی یافت نشد', 'info');
                            }
                        },
                        error: function (xhr, response, txt) {

                            $.messager.progress('close');
                            $.messager.alert('پیغام سیستمی', txt, 'info');

                        }
                    });
                }
            });

        }

    </script>
</asp:Content>
