﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="DriverLicenseList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Drivers.DriverLicenseList" %>


<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">

    <div class="content-wrapper">

        <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
            <div data-options="region:'center',title:'لیست درخواست های پروانه اشتغال'">
                <table id="mainGrid">
                    <thead>
                        <tr>
                            <th field="ck" checkbox="true"></th>
                            <th data-options="field:'DriverId', sortable:'true', width:160" hidden="hidden"></th>
                            <th data-options="field:'FullName', sortable:'true', width:160">نام و نام خانوادگی</th>
                            <th data-options="field:'NationalCode', sortable:'true', width:160">کد ملی</th>
                            <th data-options="field:'IsNewLicense', sortable:'true', width:130 , formatter:formatIsNewField">نوع درخواست</th>
                            <th data-options="field:'LicenseTypeTitle', sortable:'true', width:90">نوع پروانه</th>
                            <th data-options="field:'RequestDate', sortable:'true', width:130">تاریخ درخواست</th>
                            <th data-options="field:'LicenseDate', sortable:'true', width:160">تاریخ صدور</th>
                            <th data-options="field:'LicenseNumber', sortable:'true', width:160">شماره پروانه</th>
                            <th data-options="field:'LicenseStatusTitle', sortable:'true', width:160">وضعیت درخواست</th>

                        </tr>
                    </thead>
                </table>
                <div id="gridtoolbarDriverLicensingList" style="padding: 2px 5px;">
                    <div style="padding: 2px 5px;">

                        <%--<a onclick="addNew()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-add'">افزودن</a>--%>
                        <%--<a onclick="edit()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-display edit'">ویرایش</a>--%>
                        کد ملی : 
                        <input type="text" id="txtNationalCode" class="easyui-textbox" style="width: 200px; height: 30px;" />
                        <a onclick="searchCarListOnDB()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-search'">جستجو و به روزرسانی </a>
                        <a onclick="clearFilter()" class="easyui-linkbutton" data-options="region:'center',iconCls:''">حذف فیلتر</a>
                        <a onclick="printLicensing()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print edit'">چاپ پروانه اشتغال</a>
                        <a href="javascript:void(0)" id="btnUTCMS" onclick="inqueryUTCMS()" class="easyui-linkbutton">استعلام UTCMS</a>

                        <%--  <a onclick="CreateFormPage('لیست پروانه اشتغال های صادر شده', $('#mainGrid'))" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print edit'">چاپ لیست</a>--%>
                    </div>
                </div>
            </div>
        </div>

    </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
        var mainGrid = $('#mainGrid');


        function inqueryUTCMS() {

            
            var row = mainGrid.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }


            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/Driver/InquiryUtcmsWithTranslateByGUID',
                type: 'Post',
                data: JSON.stringify(row.DriverLicenseGUID),
                contentType: 'application/json',
                success: function (data) {
                    $.messager.progress('close');

                    if (data) {
                        if (data.IsSuccessful === true) {
                            if (isJson(data.ReturnValue) || isObject(data.ReturnValue)) {
                                var final_data = data.ReturnValue;


                                if (isJson(data.ReturnValue)) {
                                    final_data = JSON.parse(data.ReturnValue);
                                }

                                var message = "<div style='text-align:right;direction:rtl '>";

                                Object.keys(final_data).map((item, index) => {
                                    message += ' <br />' + item + ' : ' + (final_data[item] === null ? 'نامشخص' : final_data[item]);

                                });
                                message += "</div>";
                                $.messager.alert('پیام سیستم', message, '');

                            } else {
                                $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                            }
                        } else {
                            $.messager.alert('پیام سیستم', data.Message, 'info');
                        }

                    } else {
                        $.messager.alert('پیام سیستم', "وضعیت نامشخص", 'info');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        };

        function printLicensing() {
            var row = mainGrid.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            if (row['LicenseTypeId'] === 2) {
                $.messager.alert('هشدار', "پروانه فعالیت شما در شهر دیگری صادر شده است و در این شهر پروانه شما مهمان است.", 'error');
                return;
            }

            if (row['LicenseStatusId'] !== 2) {
                $.messager.alert('هشدار', "پروانه مورد نظر هنوز تایید نشده است", 'error');
                return;
            }
            else {

                window.open("/Reports/Print/PrintDriverLicensing.html?driverLicenseGUID=" + row['DriverLicenseGUID']);
            }

        }

        $(document).ready(() => {

            initialForm();
        });

        function initialForm() {

           

            mainGrid.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/CoreServices/API/Driver/LicensingList',
                // rownumbers: true,
                sortName: 'RequestDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDriverLicensingList',
                queryParams: {
                    licenseStatusId: 0,
                    isNewLicense: 0,
                    nationalCode: ''
                }
            });
        }

        function clearFilter() {
           

            var opts = mainGrid.datagrid('options');
            opts.isBindOnLoad = true;
            $("#txtNationalCode").textbox("setValue", "");
            opts.queryParams['nationalCode'] = '';
            mainGrid.datagrid('reload', opts.queryParams);

        }

        
        function searchCarListOnDB() {

            var opts = mainGrid.datagrid('options');
            opts.isBindOnLoad = true;

            var nationalCode = $("#txtNationalCode").textbox("getValue");
            
            opts.queryParams['nationalCode'] = nationalCode;
            mainGrid.datagrid('reload', opts.queryParams);

        }

       

        $(document).ready(function () {
            // restrictAccess();
        });

    </script>
</asp:Content>


