﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/MasterPages/MainMaster.Master" CodeBehind="CompanyLicenseList.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Companies.CompanyLicenseList" %>


<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <style>
        .red {
            color: red;
        }

        .edit {
            color: rgb(39, 117, 203);
        }
    </style>
    <div class="content-wrapper" id="announce">
        <!-- Content Header (Page header) -->


        <section class="content">
            <div class="easyui-layout" id="mainLayout" style="height: 600px; width: 100%">
                <div data-options="region:'center',title:'درخواست های صدور پروانه بهره برداری '">
                    <table id="grdLicensingList">
                        <thead>
                            <tr>
                                <th field="ck" checkbox="true"></th>
                                <th data-options="field:'CompanyLicensingGUID', sortable:'true', width:160" hidden="hidden"></th>
                                <th data-options="field:'CompanyName', sortable:'true', width:160">نام شرکت</th>
                                <th data-options="field:'CompanyLicensingCreateDate', sortable:'true', width:160">تاریخ درخواست</th>
                                <th data-options="field:'isNewLicense', sortable:'true', width:160,formatter: formatIsNewField">نوع درخواست</th>
                                <th data-options="field:'LicenseStatusTitle', sortable:'true', width:160">وضعیت درخواست</th>
                                <th data-options="field:'LicenseNumber', sortable:'true', width:160">شماره پروانه</th>
                                <th data-options="field:'LicenseExpireDate', sortable:'true', width:160">تاریخ انقضا</th>
                            </tr>
                        </thead>
                    </table>
                    <div id="gridtoolbarDriverLicensingList" style="padding: 2px 5px;">
                        <div style="padding: 2px 5px;">


                            <a onclick="printLicensing()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-print edit'">چاپ پروانه بهره برداری</a>
                            <label id="lblReject">با کلیک بر روی درخواست رد شده ، علت رد خواست خود را مشاهده نمایید</label>
                            <a id="btnRejectDetails" onclick="rejectDetails()" class="easyui-linkbutton" data-options="region:'center'">علت رد درخواست</a>


                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>
        var grdLicensingList = $('#grdLicensingList');

        var globalCurrentRow = null;



        function rejectDetails() {
            var row = grdLicensingList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert("info", 'لطفا ابتدا یک درخواست را انتخاب نمایید', "info");
                return;
            }

            if (row['LicenseStatusId'] != 3) {
                return;

            }
            $.messager.alert('علت رد درخواست', row['LastRejectDesc'], 'info');
        }

        function printLicensing() {

            var row = grdLicensingList.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            if (row['LicenseStatusId'] !== 2) {
                $.messager.alert('Error', "درخواست مورد نظر هنوز تایید و پروانه صادر نشده است", 'error');
                return;
            }
            window.open('/Reports/Print/PrintCompanyLicensing.html?companyLicensingGUID=' + row.CompanyLicensingGUID);


        }

        $(document).ready(() => {

            initialForm();
        });

        function initialForm() {

            grdLicensingList.initializeGrid({
                // filterBtnPosition: 'left',
                // remoteFilter: false,
                // method: 'get',
                // fit: true,
                // singleSelect: true,
                // collapsible: true,
                // fitColumns: true,
                // pagination: true,
                // pageSize: 15,
                // pageList: [15, 50, 100, 99999],
                url: '/Companies/API/Companies/CompanyLicensingList',
                sortName: 'CompanyLicensingCreateDate',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarDriverLicensingList',
                height: $(window).height() - 160,
                onClickRow: function () {
                    globalCurrentRow = grdLicensingList.datagrid("getSelected");
                    showHideRejectDetails(globalCurrentRow);
                },
                onCheck: function () {
                    globalCurrentRow = grdLicensingList.datagrid("getChecked");
                    showHideRejectDetails(globalCurrentRow);
                },
                queryParams: {
                    licenseStatusId: 0,
                    IsNewLicense: -1,
                    activityTypeId: -1
                }
            });
        }

        function showHideRejectDetails(currentRow) {
            if (currentRow.LicenseStatusId !== 3) {

                $('#lblReject').show();
                $('#btnRejectDetails').hide();
            } else {
                $('#lblReject').hide();
                $('#btnRejectDetails').show();
            }
        }



        $(document).ready(function () {
            $('#btnRejectDetails').hide();
            // restrictAccess();
        });

    </script>
</asp:Content>


