﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPages/MainMaster.Master" AutoEventWireup="true" CodeBehind="carEdit.aspx.cs" Inherits="Baraneh.Web.UI.Baraneh.Cars.CarEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <div class="content-wrapper" style="padding: 20px;">

        <div class="main">
            <form id="frmVoucherEdit">
                <div class="menu1">

                    <!-- LINE CHART -->
                    <div class="card card-info bgrd">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fa fa-car"></i>ثبت ناوگان برای شرکت های بهره بردار</h3>

                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>

                            </div>
                        </div>
                        <div class="card-body">
                            <div style="margin: 10px 0;">
                                <div class="container d-flex justify-content-center">
                                    <div class="col-md-4 plateContainer ">
                                        <div class="plateItems col-12">
                                            <input tabindex="4" id="txtPlateP4" class="easyui-numberbox plateP4" required>
                                            <input tabindex="3" id="txtPlateP3" class="easyui-numberbox plateP3" required>
                                            <select tabindex="2" id="drpPlateP2" class="easyui-combobox plateP2" required></select>
                                            <input tabindex="1" id="txtPlateP1" class="easyui-numberbox plateP1" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="container d-flex justify-content-center">
                                    <div class="col-md-4">
                                        <input required="true" id="txtVINCarEdit" class="form-control easyui-textbox Vin " style="width: 100%; text-align: center">
                                    </div>
                                </div>
                                <div class="container d-flex justify-content-center" style="margin-top: 10px">
                                    <div class="col-4">
                                        <button type="button" id="btnGetVinVoucherEdit" onclick="validatePlateVin()"
                                            class="btn btn-3d btn-secondary col-12">
                                            انتخاب خودرو واعتبار سنجی
                                        </button>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>

                <!-- LINE CHART -->
                <div class="card card-info bgrd">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-car"></i>مشخصات پلاک وارد شده</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">

                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">پلاک :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtPlateNo">
                            </div>


                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">VIN :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtVIN">
                            </div>

                        </div>
                        <div class="row">

                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">سیستم :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarSystem">
                            </div>


                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">تیپ :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarStyle">
                            </div>

                        </div>
                        <div class="row">

                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">رنگ :</label>

                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarColor">
                            </div>


                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">مالک :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarOwnerName">
                            </div>

                        </div>
                        <div class="row">

                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">نوع خودرو :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtCarCategory">
                            </div>
                            <div class="form-group col-md-6" style="display: flex;">
                                <label class="col-md-4 control-label">اعتبار پروانه :</label>
                                <input readonly type="text" class="form-control" style="background-color: transparent !important" id="txtLicenseStatusTitle">
                            </div>
                        </div>
                        <br />
                        <div class="row" style="text-align: center !important; -webkit-text-fill-color: red;">
                            <div>شهروند گرامی ، به اطلاعات ثبت شده دقت نمایید . در صورت مغایرت اطلاعات ثبت شده با برگ سبز ، از طریق منوی پشتیبانی ، نسبت به اعلام مغایرت اقدام نمایید.</div>
                        </div>

                    </div>
                </div>
                <!-- /.card-body -->

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group" style="display: flex;">
                            <a href="javascript:void(0)" id="btnSaveCarEdit" class="easyui-linkbutton btn btn-3d btn-success mr-xs mb-sm col-md-3" onclick="addToCompanyList()" style="color: black; margin: auto;">ثبت در لیست ناوگان</a>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <script>


        var globalVehicleGUID=null;


        function validatePlateVin() {

            clearData();

            var vin = $('#txtVINCarEdit').val(); 
            var plate = getPlateNoEu(true, 'txtPlateP1', 'drpPlateP2', 'txtPlateP3', 'txtPlateP4');
            if (plate.length != 9) {
                return;
            }

            $.messager.progress({ title: 'لطفا صبر کنید...' });
            var car = {};
            $.ajax({
                url: '/CoreServices/API/Car/InquiryPlateVinInfoWithNAC',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    plateNo: plate,
                    vin:vin
                },
                async: true,
                success: function (data) {
                    $.messager.progress('close');
                    //
                    if (data.IsSuccessful == false) {
                        $.messager.alert('خطا', data.Message, 'error');
                        
                    }
                    else {

                        car = data.ReturnValue;

                        $('#txtCarSystem').val(car.System);
                        $('#txtCarStyle').val(car.StyleTip);
                        $('#txtCarColor').val(car.Color);
                        $('#txtCarOwnerName').val(car.OwnerName);
                        $('#txtCarCategory').val(car.CarCategoryTitle);
                        $('#txtLicenseStatusTitle').val(car.LicenseStatusTitle);
                        $('#txtPlateNo').val(car.MISPlate);
                        $('#txtVIN').val(car.VIN);
                        //todo guid
                        globalVehicleGUID = car.VehicleGUID;

                    }

                },

                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');

                    $.messager.progress('close');
                }
            });
        }


        function clearData() {
            $('#txtCarSystem').val('');
            $('#txtCarStyle').val('');
            $('#txtCarColor').val('');
            $('#txtCarOwnerName').val('');
            $('#txtCarCategory').val('');
            $('#txtLicenseStatusTitle').val('');
            $('#txtPlateNo').val('');
            $('#txtVIN').val('');
            globalVehicleGUID = null;
        }

        function addToCompanyList() {
            if (globalVehicleGUID === null) {
                $.messager.alert('اخطار', 'خودرویی انتخاب نشده است', 'warning');
            }
            $.ajax({
                url: '/CoreServices/API/Car/AddVehicleToCurrentCompanyByGuid',
                type: 'GET',
                contentType: 'application/json',
                data: {
                    vehicleGuid: globalVehicleGUID
                },
                async: false,
                success: function (data) {
                    $.messager.progress('close');
                    //
                    if (data.IsSuccessful == false) {
                        $.messager.alert('خطا', data.Message, 'error');
                    }
                    else {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                    }

                },

                error: function (xhr, textStatus, errorThrown) {
                    $.messager.alert('اخطار', 'خطا در دریافت اطلاعات', 'warning');

                    $.messager.progress('close');
                }
            });

        }
     

       

        

        

        



    </script>
</asp:Content>
