﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    body > div.panel.combo-p
        {
            height:150px;
            overflow-y:scroll;
        }

    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'مراکز نوزین'">

            <table id="grdItems">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'CenterWeighingId', sortable:'true', width:60"  hidden="hidden">کد داده </th>
                        <th data-options="field:'CenterWeighingCode', sortable:'true', width:60,type:'integer'">کد توزین </th>
                        <th data-options="field:'Name', sortable:'true', width:160">نام مرکز</th>
                        <th data-options="field:'IsActive',formatter:showCheckbox, sortable:'true', width:50">فعال</th>
                        <th data-options="field:'CompanyLicRequired',formatter:showCheckbox, sortable:'true', width:50">پروانه بهره برداری</th>
                        <th data-options="field:'CreateDate', sortable:'true', width:50">تاریخ درج</th>
                        <th data-options="field:'RequestByUser', sortable:'true', width:110">درج توسط کاربر</th>
                    </tr>
                </thead>
            </table>
            <div id="gridToolBar" style="padding:2px 5px;">
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgInsertItem()">درج مرکز</a>
                <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="dlgShowItem()">نمایش جزییات</a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="dlgDeleteItem()" iconcls="icon-cancel">حذف</a>

            </div>



        </div>
    </div>

    <div id="dlgForm" class="easyui-dialog" style="width:670px;height:220px;padding:10px 20px"
         closed="true">
        <form id="frmEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> کد توزین:</label>
                    </td>

                    <td>
                        <input id="txtCenterWeighingCode" class="easyui-textbox" tipPosition="left" style="width:520px;height:30px;font-size: 16px;text-align: justify;">
                    </td>
                </tr>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> نام مرکز:</label>
                    </td>

                    <td>
                        <input id="txtName" class="easyui-textbox" tipPosition="left" style="width:520px;height:30px;font-size: 16px;text-align: justify;">
                    </td>
                </tr>

                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> آدرس:</label>
                    </td>

                    <td>
                        <input id="txtAddress" class="easyui-textbox" tipPosition="left" style="width:520px;height:30px;">
                    </td>
                </tr>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> فعال:</label>
                    </td>

                    <td>
                        <input id="chkIsActive" class="easyui-checkbox" tipPosition="left" type="checkbox">
                    </td>
                </tr>
                <tr>
                    <td style="width:25%; text-align:left;">
                        <label> پروانه بهره برداری:</label>
                    </td>

                    <td>
                        <input id="chkCompanyLicRequired" class="easyui-checkbox" tipPosition="left" type="checkbox" >
                    </td>
                </tr>

                
            </table>
        </form>
        <a href="javascript:void(0)" id="btnSave" class="easyui-linkbutton c6" style="width:90px;" iconcls="icon-ok" onclick="saveItem()">ثبت</a>
        <a href="javascript:void(0)" id="btnEdit" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="editItem()">ثبت ویرایش</a>
        <a href="javascript:void(0)"  class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#dlgForm').dialog('close')" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        function showCheckbox(value) {

            if (value == 1) {
                return '<input type="checkbox" checked disabled>';
            }
            else {
                return '<input type="checkbox" disabled>';
            }
        }
       

        function saveItem() {

            
            var centerWeighingCode = $('#txtCenterWeighingCode').textbox('getValue');
            var name = $('#txtName').textbox('getValue');
            var address = $('#txtAddress').textbox('getValue');
            var isActive = $("#chkIsActive").prop("checked");
            var isCompanyLicRequired = $("#chkCompanyLicRequired").prop("checked");

           

            data = {
                CenterWeighingId: 0,
                CenterWeighingCode: centerWeighingCode,
                Name: name,
                Address: address,
                IsActive: isActive,
                CompanyLicRequired: isCompanyLicRequired
            }

            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/AddUpdate',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');

                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function dlgShowItem() {
            
            $("#btnEdit").show();
            $("#btnSave").hide();

            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'نمایش آیتم');


            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/GetbyId',
                type: 'GET',
                contentType: 'application/json',
                data: { id: row.CenterWeighingId },
                success: function (data) {

                    $('#txtCenterWeighingCode').textbox('setValue', data.CenterWeighingCode);
                    $('#txtName').textbox('setValue', data.Name);
                    $('#txtAddress').textbox('setValue', data.Address);
                    $('#chkIsActive').prop('checked', data.IsActive);
                    $('#chkCompanyLicRequired').prop('checked', data.CompanyLicRequired);



                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });
        }

        function dlgInsertItem() {
            
            $('#txtCenterWeighingCode').textbox('clear');
            $('#txtName').textbox('clear');
            $('#txtAddress').textbox('clear');
            $('#dlgForm').dialog('open').dialog('center').dialog('setTitle', 'اضافه کردن مرکز');
            $("#btnEdit").hide();
            $("#btnSave").show();

        }

        function editItem() {
            
            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var centerWeighingCode = $('#txtCenterWeighingCode').textbox('getValue');
            var name = $('#txtName').textbox('getValue');
            var address = $('#txtAddress').textbox('getValue');
            var isActive = $("#chkIsActive").prop("checked");
            var isCompanyLicRequired = $("#chkCompanyLicRequired").prop("checked");


            data = {
                CenterWeighingId: row.CenterWeighingId,
                CenterWeighingCode: centerWeighingCode,
                Name: name,
                Address: address,
                IsActive: isActive,
                CompanyLicRequired: isCompanyLicRequired
            }

            $.ajax({
                url: '/Weighbridge/API/PCenterWeighing/AddUpdate',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (data) {

                    if (data.IsSuccessful == true) {

                        $.messager.show({
                            title: 'پیغام سیستم',
                            msg: data.Message,
                            timeout: 1000,
                            showType: 'slide',
                            style: {
                                right: '',
                                bottom: ''
                            }
                        });
                        var opts = grdItems.datagrid('options');
                        opts.isBindOnLoad = true;
                        //opts.queryParams['catId'] = 1;
                        //opts.queryParams['type'] = 0;
                        grdItems.datagrid('reload', opts.queryParams);

                        $('#dlgForm').dialog('close');
                    }
                    else {
                        $.messager.progress('close');
                        $.messager.alert('Warning', data.Message, 'error');
                    }

                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');

                }
            });

        }
        

        function dlgDeleteItem() {


            var row = grdItems.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectedId = row.CenterWeighingId;




            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/Weighbridge/API/PCenterWeighing/Delete',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            id: selectedId

                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdItems.datagrid('options');
                                opts.isBindOnLoad = true;
                                //opts.queryParams['catId'] = 1;
                                //opts.queryParams['type'] = 0;
                                grdItems.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }


        var grdItems = $('#grdItems');
        var dlgForm = $('#dlgForm');

        $(function () {

            dlgForm.window({
                width: '750',
                height: '300',
                closed: true,
                modal: true,


            });

            grdItems.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                pageSize: 99999,
                pageList: [15, 50, 100, 99999],
                url: '/Weighbridge/API/PCenterWeighing/GetAll',
                rownumbers: true,
                 
                sortName: 'CenterWeighingId',
                sortOrder: 'desc',
                toolbar: '#gridToolBar',
                queryParams: {
                    
                }

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            //var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;

            grdItems.datagrid('enableFilter', [
                {
                    field: 'CenterWeighingCode',
                    type: 'text',
                    op: numberBoxOP,
                },
                {
                    field: 'Name',
                    type: 'text',
                    op: textOp,
                },
              
            ]);





        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>