﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'فرم محل فعالیت'">

            <table id="grdWokPlaces">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'WorkPlaceId', sortable:'true', width:60" hidden="hidden"> </th>
                        <th data-options="field:'Title', sortable:'true', width:60">محل فعالیت</th>

                    </tr>
                </thead>
            </table>
            <div id="gridtoolbarWorkPlaceList" style="padding:2px 5px;">
                <a id="LicenseOwnerEdit_btnSendMessage" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="addWorkPlace()">درج محل فعالیت </a>
                <a id="btnshowMessage" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="displayWorkPlace()">نمایش </a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="deleteWorkPlace()" iconcls="icon-cancel">حذف</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
            </div>



        </div>
    </div>

    <div id="dlgMessage" class="easyui-dialog" style="width:600px;height:200px;"
         data-options="iconCls:'icon-save',resizable:true,modal:true,closed:true">
        <form id="frmWorkPlaceEdit" method="post" novalidate>

            <table>
                <tr>
                    <td style="width:15%; text-align:left;">
                        <label>  محل فعالیت:</label>
                    </td>
                    <td>
                        <input type="hidden" id="WorkPlaceId" />
                        <input id="Title" required class="easyui-textbox" tipPosition="left" style="width:520px;height:30px;font-size: 16px;text-align: justify;" data-options="multiline:true">
                    </td>
                </tr>



            </table>
        </form>
        <a href="javascript:void(0)" id="send" class="easyui-linkbutton c6" style="width:90px" iconcls="icon-ok" onclick="save()">ذخیره</a>
        <a href="javascript:void(0)" id="cancel" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#dlgMessage').dialog('close')" style="width:90px">لغو</a>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>

        var grdWokPlaces = $("#grdWokPlaces");
        var globalWorkSpace = null;

        function toExcel() {
            $('#grdWokPlaces').datagrid('toExcel', 'dg.xls');
        }

        function deleteWorkPlace() {
            globalWorkSpace = grdWokPlaces.datagrid('getSelected');
            if (globalWorkSpace == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    $.ajax({
                        url: '/CoreServices/API/WorkPlace/Delete',
                        type: 'Post',
                        contentType: 'application/json',
                        data: JSON.stringify( globalWorkSpace.WorkPlaceId),
                        success: function (data) {

                            $.messager.progress('close');

                            if (data.IsSuccessful == true) {

                                $.messager.alert('پیام سیستم', data.Message, 'info');

                                grdWokPlaces.datagrid('reload');
                            }
                            else {
                                $.messager.alert('پیام سیستم', data.Message, 'info');
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                            $.messager.progress('close');
                        }
                    });
                }
            });


        }

        function displayWorkPlace()
        {
            globalWorkSpace = grdWokPlaces.datagrid('getSelected');
            if (globalWorkSpace == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            $("#WorkPlaceId").val(globalWorkSpace.WorkPlaceId);
            $("#Title").textbox("setValue", globalWorkSpace.Title);

            $('#dlgMessage').dialog({
                title: 'My Dialog',
                width: 600,
                height: 200,
                closed: false,
                cache: false,
                modal: true
            });
        }

        function addWorkPlace() {
            globalWorkSpace = null;
            $("#WorkPlaceId").val(null);
            $("#Title").textbox("setValue", null);

            $('#dlgMessage').dialog({
                title: 'ثبت / ویرایش محل فعالیت',
                width: 600,
                height: 200,
                closed: false,
                modal: true
            });
        }

        $(document).ready(() => {


            grdWokPlaces.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                // pageSize: 0,
                pageList: [14, 20, 50, 100, 99999],
                url: '/CoreServices/API/WorkPlace/InQuery',
                rownumbers: true,
                // singleSelect: false,
                sortName: 'Title',
                sortOrder: 'desc',
                toolbar: '#gridtoolbarWorkPlaceList',
                queryParams: {
                    searchValue:''
                }
            });

        });

        function save() {
            if (!$('#frmWorkPlaceEdit').form('validate')) {
                $.messager.alert('اخطار', 'لطفا موارد اجباری را وارد نمایید', 'warning');
                return;
            }

            globalWorkSpace =
            {
                WorkPlaceId: $("#WorkPlaceId").val(),
                Title: $("#Title").textbox("getValue")
            };

            $.messager.progress({ title: 'لطفا صبر کنید...' });

            $.ajax({
                url: '/CoreServices/API/WorkPlace/Save',
                type: 'Post',
                contentType: 'application/json',
                data: JSON.stringify(globalWorkSpace),
                success: function (data) {

                    $.messager.progress('close');

                    if (data.IsSuccessful == true) {

                        $.messager.alert('پیام سیستم', data.Message, 'info');
                        $('#dlgMessage').dialog({
                            closed: true,
                        });
                        grdWokPlaces.datagrid('reload');
                    }
                    else
                    {
                        $.messager.alert('پیام سیستم', data.Message, 'info');
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    showAjaxErrorMessage(xhr, textStatus, errorThrown);
                    $.messager.progress('close');
                }
            });

           
        }

        $(document).ready(function () {
            restrictAccess();
        });
    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>