﻿<%@ Page Language="C#" MasterPageFile="~/MasterPages/AdminPage.Master" AutoEventWireup="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="cContent" runat="server">
    <!-- -------------- Page Style -------------- -->
    <style>
    
    </style>
    <!-- -------------- End Of Page Style -------------- -->

    <!-- -------------- Page Content -------------- -->
    <div data-options="fit:true" class="easyui-layout" id="mainLayout" style="height:500px">
        <div data-options="region:'center',title:'لیست حاملین بار چرخدستی'">

            <table id="grdPersons">
                <thead>
                    <tr>
                        <th field="ck" checkbox="true"></th>
                        <th data-options="field:'NationalCode', sortable:'true', width:110">کد ملی</th>
                        <th data-options="field:'BirthDate', sortable:'true', width:110">تاریخ تولد</th>
                        <th data-options="field:'FullName', sortable:'true', width:120">نام و نام خانوادگی</th>
                        <th data-options="field:'FatherName', sortable:'true', width:110">نام پدر</th>
                        <th data-options="field:'FamilyCount', sortable:'true', width:70">افراد تحت تکفل</th>
                        <th data-options="field:'HasInsuranceTitle', sortable:'true', width:70">وضعیت بیمه</th>
                        <th data-options="field:'IsIranianTitle', sortable:'true', width:70">ملیت</th>
                        <th data-options="field:'Tel', sortable:'true', width:110">تلفن ثابت</th>
                        <th data-options="field:'Mobile', sortable:'true', width:110">موبایل</th>
                        <th data-options="field:'WorkPlaceTitle', sortable:'true', width:110">محل فعالیت</th>
                        <th data-options="field:'TrolleyTypeTitle', sortable:'true', width:110">نوع چرخدستی</th>
                        <th data-options="field:'RecommendBy', sortable:'true', width:110">معرف</th>
                        <th data-options="field:'ForeignCode', sortable:'true', width:110">کد اتباع</th>
                        <th data-options="field:'RequestedBy', sortable:'true', width:110">کابر ثبت کننده</th>
                        <th data-options="field:'CreatedDate', sortable:'true', width:110">تاریخ ثبت</th>

                    </tr>
                </thead>
            </table>
            <div id="gridToolbarPeronList" style="padding:2px 5px;">
                <!--<a id="LicenseOwnerEdit_btnSendMessage" href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-message" onclick="sendMessageDialog()">درج </a>-->
                <a id="btnShowDetails" href="javascript:void(0)" class="easyui-linkbutton c6"  onclick="showDetails()">نمایش </a>
                <a href="javascript:void(0)" class="easyui-linkbutton" onclick="deletePerson()" iconcls="icon-cancel">حذف</a>
                <a onclick="toExcel()" class="easyui-linkbutton" data-options="region:'center',iconCls:'icon-excel edit'">گزارش اکسل</a>
            </div>
        </div>
    </div>
    <!-- -------------- End of Page Style -------------- -->
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="cScripts" runat="server">
    <!-- -------------- Page Script -------------- -->

    <script>
        

        function toExcel() {
            $('#grdPersons').datagrid('toExcel', 'dg.xls');
        }

       
        
        function showDetails() {

            var row = grdPersons.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('هشدار', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }
            if (row['IsIranian'] === true) {
                openEditLicensingWindow('/AdminBaraneh/Trolley/TrolleyIranianPersons.aspx?TrolleyPersonId=' + row['TrolleyPersonId']);
            } else {
                
                openEditLicensingWindow('/AdminBaraneh/Trolley/TrolleyForeignPersons.aspx?TrolleyPersonId=' + row['TrolleyPersonId']);
            }

        }
        function openEditLicensingWindow(url) {

            window.open(url);
        }

       


        function deletePerson() {


            var row = grdPersons.datagrid('getSelected');
            if (row == null) {
                $.messager.alert('Warning', 'لطفا ابتدا یک رکورد را انتخاب نمایید');
                return;
            }

            var selectlicense = row.TrolleyPersoanId;




            $.messager.confirm('Confirm', 'آیا برای حذف اطمینان دارید؟', function (r) {
                if (r) {

                    //انتخاب اول
                    //$.messager.progress({ msg: 'لطفا کمی صبر کنید' });

                    $.ajax({
                        url: '/CoreServices/API/TrolleyPersons/TrolleyPersonsRemove',
                        type: 'GET',
                        contentType: 'application/json',
                        data: {
                            trolleyPersonId: selectlicense

                        },
                        async: false,
                        success: function (data) {

                            if (data.IsSuccessful == true) {
                                var opts = grdPersons.datagrid('options');
                                opts.isBindOnLoad = true;
                                //opts.queryParams['catId'] = 1;
                                //opts.queryParams['type'] = 0;
                                grdPersons.datagrid('reload', opts.queryParams);

                                //$.messager.alert('پیام سیستمی', data.Message, "info");

                                //showlist();


                            }
                            else {
                                $.messager.alert('Warning', data.Message);
                            }
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            showAjaxErrorMessage(xhr, textStatus, errorThrown);
                        }
                    });

                    $.messager.progress('close');
                }
            });

        }

        
  

        var grdPersons = $('#grdPersons');
     

        $(function () {

           
            grdPersons.datagrid({
                //title: '',
                filterBtnPosition: 'left',
                remoteFilter: true,
                method: 'get',
                fit: true,
                singleSelect: true,
                collapsible: true,
                fitColumns: true,
                pagination: true,
                // pageSize: 0,
                pageList: [14, 20, 50, 100, 99999],
                url: '/CoreServices/API/TrolleyPersons/TrolleyPersonsList',
                rownumbers: true,
                // singleSelect: false,
                sortName: 'TrolleyPersonId',
                sortOrder: 'desc',
                toolbar: '#gridToolbarPeronList',
                queryParams: {
                    searchValue:''
                }

            });

            var textOp = ['equal', 'contains', 'beginwith', 'endwith'];
            var dateboxOp = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];
            var numberBoxOP = ['equal', 'notequal', 'less', 'greater', 'lessorequal', 'greaterorequal'];

            var filterOnSelectValue = null;
            var filterOnSelectField = null;
            grdPersons.datagrid('enableFilter', [
                {
                    field: 'NationalCode',
                    type: 'text',
                    op: textOp
                },
                {
                    field: 'FullName',
                    type: 'text',
                    op: textOp
                },
                {
                    field: 'FatherName',
                    type: 'text',
                    op: textOp
                },
                {
                    field: 'FamilyCount',
                    type: 'text',
                    op: numberBoxOP
                },
                {
                    field: 'HasInsuranceTitle',
                    type: 'text',
                    op: textOp
                },
                {
                    field: 'IsIranianTitle',
                    type: 'text',
                    op: textOp
                },
                {
                    field: 'Tel',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'Mobile',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'WorkPlaceTitle',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'TrolleyTypeTitle',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'RecommendBy',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'RequestedBy',
                    type: 'text',
                    op: textOp
                }
                ,
                {
                    field: 'CreateDate',
                    type: 'text',
                    op: dateboxOp
                }
              
            ]);

        });
        $(document).ready(function () {
            restrictAccess();
        });

    </script>


    <!-- -------------- End Of Page Style -------------- -->
</asp:Content>